/*!
 * jsoneditor.js
 *
 * @brief
 * JSONEditor is a web-based tool to view, edit, format, and validate JSON.
 * It has various modes such as a tree editor, a code editor, and a plain text
 * editor.
 *
 * Supported browsers: Chrome, Firefox, Safari, Opera, Internet Explorer 8+
 *
 * @license
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 * Copyright (c) 2011-2019 Jos de Jong, http://jsoneditoronline.org
 *
 * @author  Jos de Jong, <wjosdejong@gmail.com>
 * @version 7.2.1
 * @date    2019-10-27
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define([],t):"object"==typeof exports?exports.JSONEditor=t():e.JSONEditor=t()}(window,function(){return n={},o.m=i=[function(e,t,i){"use strict";i.r(t),i.d(t,"parse",function(){return u}),i.d(t,"repair",function(){return p}),i.d(t,"escapeUnicodeChars",function(){return f}),i.d(t,"validate",function(){return m}),i.d(t,"extend",function(){return v}),i.d(t,"clear",function(){return g}),i.d(t,"getType",function(){return y}),i.d(t,"isUrl",function(){return x}),i.d(t,"isArray",function(){return C}),i.d(t,"getAbsoluteLeft",function(){return _}),i.d(t,"getAbsoluteTop",function(){return E}),i.d(t,"addClassName",function(){return w}),i.d(t,"removeAllClassNames",function(){return T}),i.d(t,"removeClassName",function(){return S}),i.d(t,"stripFormatting",function(){return j}),i.d(t,"setEndOfContentEditable",function(){return N}),i.d(t,"selectContentEditable",function(){return k}),i.d(t,"getSelection",function(){return O}),i.d(t,"setSelection",function(){return I}),i.d(t,"getSelectionOffset",function(){return D}),i.d(t,"setSelectionOffset",function(){return A}),i.d(t,"getInnerText",function(){return P}),i.d(t,"hasParentNode",function(){return M}),i.d(t,"getInternetExplorerVersion",function(){return F}),i.d(t,"isFirefox",function(){return L}),i.d(t,"addEventListener",function(){return B}),i.d(t,"removeEventListener",function(){return R}),i.d(t,"isChildOf",function(){return H}),i.d(t,"parsePath",function(){return z}),i.d(t,"stringifyPath",function(){return U}),i.d(t,"improveSchemaError",function(){return J}),i.d(t,"isPromise",function(){return $}),i.d(t,"isValidValidationError",function(){return q}),i.d(t,"insideRect",function(){return K}),i.d(t,"debounce",function(){return W}),i.d(t,"textDiff",function(){return Q}),i.d(t,"getInputSelection",function(){return Z}),i.d(t,"getIndexForPosition",function(){return X}),i.d(t,"getPositionForPath",function(){return Y}),i.d(t,"compileJSONPointer",function(){return G}),i.d(t,"getColorCSS",function(){return ee}),i.d(t,"isValidColor",function(){return te}),i.d(t,"makeFieldTooltip",function(){return ie}),i.d(t,"get",function(){return ne}),i.d(t,"findUniqueName",function(){return oe}),i.d(t,"getChildPaths",function(){return re}),i.d(t,"sort",function(){return se}),i.d(t,"sortObjectKeys",function(){return ae}),i.d(t,"parseString",function(){return le}),i.d(t,"formatSize",function(){return ce}),i.d(t,"limitCharacters",function(){return de}),i.d(t,"isObject",function(){return he}),i.d(t,"contains",function(){return ue});i(17);var n=i(9),r=i.n(n),o=i(16),s=i.n(o),a=i(18),l=i.n(a),c=i(1);function d(e){return(d="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var h=1e4;function u(t){try{return JSON.parse(t)}catch(e){throw m(t),e}}function p(n){var i=[],o=0,e=n.match(/^\s*(\/\*(.|[\r\n])*?\*\/)?\s*[\da-zA-Z_$]+\s*\(([\s\S]*)\)\s*;?\s*$/);e&&(n=e[3]);var t,r={"\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t"};function s(){return n.charAt(o)}function a(){return n.charAt(o+1)}function l(e){return" "===e||"\n"===e||"\r"===e||"\t"===e}function c(){for(var e=i.length-1;0<=e;){var t=i[e];if(!l(t))return t;e--}return""}function d(){for(var e=o+1;e<n.length&&l(n[e]);)e++;return n[e]}function h(){for(o+=2;o<n.length&&("*"!==s()||"/"!==a());)o++;o+=2}function u(){for(o+=2;o<n.length&&"\n"!==s();)o++}function p(e){var t="";t+='"',o++;for(var i=s();o<n.length&&i!==e;)'"'===i&&"\\"!==n.charAt(o-1)?t+='\\"':i in r?t+=r[i]:("\\"===i&&(o++,"'"!==(i=s())&&(t+="\\")),t+=i),o++,i=s();return i===e&&(t+='"',o++),t}function f(){for(var e="",t=s(),i=/[a-zA-Z_$\d]/;i.test(t);)e+=t,o++,t=s();return-1===["null","true","false"].indexOf(e)?'"'+e+'"':e}function m(){for(var e,t=s(),i="";/[a-zA-Z_$]/.test(t);)i+=t,o++,t=s();if(0<i.length&&"("===t){if(o++,'"'===(t=s()))e=p(t),t=s();else for(e="";")"!==t&&""!==t;)e+=t,o++,t=s();return")"===t?(o++,e):i+"("+e+t}return i}for(;o<n.length;){var v=s();"/"===v&&"*"===a()?h():"/"===v&&"/"===a()?u():" "===(t=v)||" "<=t&&t<=" "||" "===t||" "===t||"　"===t?(i.push(" "),o++):"'"===v?i.push(p(v)):'"'===v?i.push(p('"')):"`"===v?i.push(p("´")):"‘"===v?i.push(p("’")):"“"===v?i.push(p("”")):","===v&&-1!==["]","}"].indexOf(d())?o++:/[a-zA-Z_$]/.test(v)&&-1!==["{",","].indexOf(c())?i.push(f()):/[a-zA-Z_$]/.test(v)?i.push(m()):(i.push(v),o++)}return i.join("")}function f(e){return e.replace(/[\u007F-\uFFFF]/g,function(e){return"\\u"+("0000"+e.charCodeAt(0).toString(16)).slice(-4)})}function m(e){void 0!==s.a?s.a.parse(e):JSON.parse(e)}function v(e,t){for(var i in t)pe(t,i)&&(e[i]=t[i]);return e}function g(e){for(var t in e)pe(e,t)&&delete e[t];return e}function y(e){return null===e?"null":void 0===e?"undefined":e instanceof Number||"number"==typeof e?"number":e instanceof String||"string"==typeof e?"string":e instanceof Boolean||"boolean"==typeof e?"boolean":e instanceof RegExp?"regexp":C(e)?"array":"object"}var b=/^https?:\/\/\S+$/;function x(e){return("string"==typeof e||e instanceof String)&&b.test(e)}function C(e){return"[object Array]"===Object.prototype.toString.call(e)}function _(e){return e.getBoundingClientRect().left+window.pageXOffset||document.scrollLeft||0}function E(e){return e.getBoundingClientRect().top+window.pageYOffset||document.scrollTop||0}function w(e,t){var i=e.className.split(" ");-1===i.indexOf(t)&&(i.push(t),e.className=i.join(" "))}function T(e){e.className=""}function S(e,t){var i=e.className.split(" "),n=i.indexOf(t);-1!==n&&(i.splice(n,1),e.className=i.join(" "))}function j(e){for(var t=e.childNodes,i=0,n=t.length;i<n;i++){var o=t[i];o.style&&o.removeAttribute("style");var r=o.attributes;if(r)for(var s=r.length-1;0<=s;s--){var a=r[s];!0===a.specified&&o.removeAttribute(a.name)}j(o)}}function N(e){var t,i;document.createRange&&((t=document.createRange()).selectNodeContents(e),t.collapse(!1),(i=window.getSelection()).removeAllRanges(),i.addRange(t))}function k(e){var t,i;e&&"DIV"===e.nodeName&&window.getSelection&&document.createRange&&((i=document.createRange()).selectNodeContents(e),(t=window.getSelection()).removeAllRanges(),t.addRange(i))}function O(){if(window.getSelection){var e=window.getSelection();if(e.getRangeAt&&e.rangeCount)return e.getRangeAt(0)}return null}function I(e){if(e&&window.getSelection){var t=window.getSelection();t.removeAllRanges(),t.addRange(e)}}function D(){var e=O();return e&&"startOffset"in e&&"endOffset"in e&&e.startContainer&&e.startContainer===e.endContainer?{startOffset:e.startOffset,endOffset:e.endOffset,container:e.startContainer.parentNode}:null}function A(e){if(document.createRange&&window.getSelection&&window.getSelection()){var t=document.createRange();e.container.firstChild||e.container.appendChild(document.createTextNode("")),t.setStart(e.container.firstChild,e.startOffset),t.setEnd(e.container.firstChild,e.endOffset),I(t)}}function P(e,t){if(void 0===t&&(t={text:"",flush:function(){var e=this.text;return this.text="",e},set:function(e){this.text=e}}),e.nodeValue)return t.flush()+e.nodeValue;if(e.hasChildNodes()){for(var i=e.childNodes,n="",o=0,r=i.length;o<r;o++){var s=i[o];if("DIV"===s.nodeName||"P"===s.nodeName){var a=i[o-1],l=a?a.nodeName:void 0;l&&"DIV"!==l&&"P"!==l&&"BR"!==l&&(n+="\n",t.flush()),n+=P(s,t),t.set("\n")}else"BR"===s.nodeName?(n+=t.flush(),t.set("\n")):n+=P(s,t)}return n}return"P"===e.nodeName&&-1!==F()?t.flush():""}function M(e,t){for(var i=e?e.parentNode:void 0;i;){if(i===t)return!0;i=i.parentNode}return!1}function F(){if(-1===V){var e=-1;if("undefined"!=typeof navigator&&"Microsoft Internet Explorer"===navigator.appName){var t=navigator.userAgent;null!=new RegExp("MSIE ([0-9]+[.0-9]+)").exec(t)&&(e=parseFloat(RegExp.$1))}V=e}return V}function L(){return"undefined"!=typeof navigator&&-1!==navigator.userAgent.indexOf("Firefox")}var V=-1;function B(e,t,i,n){if(e.addEventListener)return void 0===n&&(n=!1),"mousewheel"===t&&L()&&(t="DOMMouseScroll"),e.addEventListener(t,i,n),i;if(e.attachEvent){var o=function(){return i.call(e,window.event)};return e.attachEvent("on"+t,o),o}}function R(e,t,i,n){e.removeEventListener?(void 0===n&&(n=!1),"mousewheel"===t&&L()&&(t="DOMMouseScroll"),e.removeEventListener(t,i,n)):e.detachEvent&&e.detachEvent("on"+t,i)}function H(e,t){for(var i=e.parentNode;i;){if(i===t)return!0;i=i.parentNode}return!1}function z(i){var e=[],n=0;function t(){for(var e="";void 0!==i[n]&&/[\w$]/.test(i[n]);)e+=i[n],n++;if(""===e)throw new Error("Invalid JSON path: property name expected at index "+n);return e}function o(e){for(var t="";void 0!==i[n]&&i[n]!==e;)t+=i[n],n++;if(i[n]!==e)throw new Error("Invalid JSON path: unexpected end, character "+e+" expected");return t}for(;void 0!==i[n];)if("."===i[n])n++,e.push(t());else{if("["!==i[n])throw new Error('Invalid JSON path: unexpected character "'+i[n]+'" at index '+n);if("'"===i[++n]||'"'===i[n]){var r=i[n];if(n++,e.push(o(r)),i[n]!==r)throw new Error("Invalid JSON path: closing quote ' expected at index "+n);n++}else{var s=o("]").trim();if(0===s.length)throw new Error("Invalid JSON path: array value expected at index "+n);s="*"===s?s:JSON.parse(s),e.push(s)}if("]"!==i[n])throw new Error("Invalid JSON path: closing bracket ] expected at index "+n);n++}return e}function U(e){return e.map(function(e){return"number"==typeof e?"["+e+"]":"string"==typeof e&&e.match(/^[A-Za-z0-9_$]+$/)?"."+e:'["'+e+'"]'}).join("")}function J(e){if("enum"===e.keyword&&Array.isArray(e.schema)){var t=e.schema;if(t){if(5<(t=t.map(function(e){return JSON.stringify(e)})).length){var i=["("+(t.length-5)+" more...)"];(t=t.slice(0,5)).push(i)}e.message="should be equal to one of: "+t.join(", ")}}return"additionalProperties"===e.keyword&&(e.message="should NOT have additional property: "+e.params.additionalProperty),e}function $(e){return e&&"function"==typeof e.then&&"function"==typeof e.catch}function q(e){return"object"===d(e)&&Array.isArray(e.path)&&"string"==typeof e.message}function K(e,t,i){var n=void 0!==i?i:0;return t.left-n>=e.left&&t.right+n<=e.right&&t.top-n>=e.top&&t.bottom+n<=e.bottom}function W(n,o,r){var s;return function(){var e=this,t=arguments,i=r&&!s;clearTimeout(s),s=setTimeout(function(){s=null,r||n.apply(e,t)},o),i&&n.apply(e,t)}}function Q(e,t){for(var i=t.length,n=0,o=e.length,r=t.length;t.charAt(n)===e.charAt(n)&&n<i;)n++;for(;t.charAt(r-1)===e.charAt(o-1)&&n<r&&0<o;)r--,o--;return{start:n,end:r}}function Z(i){var e,t,n,o,r,s=0,a=0;return"number"==typeof i.selectionStart&&"number"==typeof i.selectionEnd?(s=i.selectionStart,a=i.selectionEnd):(t=document.selection.createRange())&&t.parentElement()===i&&(o=i.value.length,e=i.value.replace(/\r\n/g,"\n"),(n=i.createTextRange()).moveToBookmark(t.getBookmark()),(r=i.createTextRange()).collapse(!1),-1<n.compareEndPoints("StartToEnd",r)?s=a=o:(s=-n.moveStart("character",-o),s+=e.slice(0,s).split("\n").length-1,-1<n.compareEndPoints("EndToEnd",r)?a=o:(a=-n.moveEnd("character",-o),a+=e.slice(0,a).split("\n").length-1))),{startIndex:s,endIndex:a,start:l(s),end:l(a)};function l(e){var t=i.value.substring(0,e);return{row:(t.match(/\n/g)||[]).length+1,column:t.length-t.lastIndexOf("\n")}}}function X(e,t,i){var n=e.value||"";if(0<t&&0<i){var o=n.split("\n",t);t=Math.min(o.length,t),i=Math.min(o[t-1].length,i-1);var r=1===t?i:i+1;return o.slice(0,t-1).join("\n").length+r}return-1}function Y(e,t){var n,o=[];if(!t||!t.length)return o;try{n=l.a.parse(e)}catch(e){return o}return t.forEach(function(e){var t=G(z(e)),i=n.pointers[t];i&&o.push({path:e,line:i.key?i.key.line:i.value?i.value.line:0,column:i.key?i.key.column:i.value?i.value.column:0})}),o}function G(e){return e.map(function(e){return"/"+String(e).replace(/~/g,"~0").replace(/\//g,"~1")}).join("")}function ee(e){var t=document.createElement("div");return t.style.color=e,t.style.color.split(/\s+/).join("").toLowerCase()||null}function te(e){return!!ee(e)}function ie(i,e){if(!i)return"";var n="";return i.title&&(n+=i.title),i.description&&(0<n.length&&(n+="\n"),n+=i.description),i.default&&(0<n.length&&(n+="\n\n"),n+=Object(c.c)("default",void 0,e)+"\n",n+=JSON.stringify(i.default,null,2)),Array.isArray(i.examples)&&0<i.examples.length&&(0<n.length&&(n+="\n\n"),n+=Object(c.c)("examples",void 0,e)+"\n",i.examples.forEach(function(e,t){n+=JSON.stringify(e,null,2),t!==i.examples.length-1&&(n+="\n")})),n}function ne(e,t){for(var i=e,n=0;n<t.length&&null!=i;n++)i=i[t[n]];return i}function oe(e,t){for(var i=e.replace(/ \(copy( \d+)?\)$/,""),n=i,o=1;-1!==t.indexOf(n);){n=i+" ("+("copy"+(1<o?" "+o:""))+")",o++}return n}function re(e,t){var i={};function r(t,i,n,o){(Array.isArray(t)||he(t))&&!o||(i[n||""]=!0),he(t)&&Object.keys(t).forEach(function(e){r(t[e],i,n+"."+e,o)})}if(Array.isArray(e))for(var n=Math.min(e.length,h),o=0;o<n;o++){r(e[o],i,"",t)}else i[""]=!0;return Object.keys(i).sort()}function se(e,t,i){var o=t&&"."!==t?z(t):[],r="desc"===i?-1:1,n=e.slice();return n.sort(function(e,t){var i=ne(e,o),n=ne(t,o);return r*(n<i?1:i<n?-1:0)}),n}function ae(t,e){var i="desc"===e?-1:1,n=Object.keys(t).sort(function(e,t){return i*r()(e,t)}),o={};return n.forEach(function(e){o[e]=t[e]}),o}function le(e){if(""===e)return"";var t=e.toLowerCase();if("null"===t)return null;if("true"===t)return!0;if("false"===t)return!1;var i=Number(e),n=parseFloat(e);return isNaN(i)||isNaN(n)?e:i}function ce(e){if(e<900)return e.toFixed()+" B";var t=e/1024;if(t<900)return t.toFixed(1)+" KiB";var i=t/1024;if(i<900)return i.toFixed(1)+" MiB";var n=i/1024;return n<900?n.toFixed(1)+" GiB":(n/1024).toFixed(1)+" TiB"}function de(e,t){return e.length<=t?e:e.slice(0,t)+"..."}function he(e){return"object"===d(e)&&null!==e&&!Array.isArray(e)}function ue(e,t){return-1!==e.indexOf(t)}function pe(e,t){return Object.prototype.hasOwnProperty.call(e,t)}},function(e,t,i){"use strict";i.d(t,"a",function(){return l}),i.d(t,"b",function(){return c}),i.d(t,"c",function(){return d});i(17);var n=["en","pt-BR","zh-CN","tr","ja","fr-FR"],o={en:{array:"Array",auto:"Auto",appendText:"Append",appendTitle:"Append a new field with type 'auto' after this field (Ctrl+Shift+Ins)",appendSubmenuTitle:"Select the type of the field to be appended",appendTitleAuto:"Append a new field with type 'auto' (Ctrl+Shift+Ins)",ascending:"Ascending",ascendingTitle:"Sort the childs of this ${type} in ascending order",actionsMenu:"Click to open the actions menu (Ctrl+M)",collapseAll:"Collapse all fields",descending:"Descending",descendingTitle:"Sort the childs of this ${type} in descending order",drag:"Drag to move this field (Alt+Shift+Arrows)",duplicateKey:"duplicate key",duplicateText:"Duplicate",duplicateTitle:"Duplicate selected fields (Ctrl+D)",duplicateField:"Duplicate this field (Ctrl+D)",duplicateFieldError:"Duplicate field name",cannotParseFieldError:"Cannot parse field into JSON",cannotParseValueError:"Cannot parse value into JSON",empty:"empty",expandAll:"Expand all fields",expandTitle:"Click to expand/collapse this field (Ctrl+E). \nCtrl+Click to expand/collapse including all childs.",insert:"Insert",insertTitle:"Insert a new field with type 'auto' before this field (Ctrl+Ins)",insertSub:"Select the type of the field to be inserted",object:"Object",ok:"Ok",redo:"Redo (Ctrl+Shift+Z)",removeText:"Remove",removeTitle:"Remove selected fields (Ctrl+Del)",removeField:"Remove this field (Ctrl+Del)",searchTitle:"Search fields and values",searchNextResultTitle:"Next result (Enter)",searchPreviousResultTitle:"Previous result (Shift + Enter)",selectNode:"Select a node...",showAll:"show all",showMore:"show more",showMoreStatus:"displaying ${visibleChilds} of ${totalChilds} items.",sort:"Sort",sortTitle:"Sort the childs of this ${type}",sortTitleShort:"Sort contents",sortFieldLabel:"Field:",sortDirectionLabel:"Direction:",sortFieldTitle:"Select the nested field by which to sort the array or object",sortAscending:"Ascending",sortAscendingTitle:"Sort the selected field in ascending order",sortDescending:"Descending",sortDescendingTitle:"Sort the selected field in descending order",string:"String",transform:"Transform",transformTitle:"Filter, sort, or transform the childs of this ${type}",transformTitleShort:"Filter, sort, or transform contents",extract:"Extract",extractTitle:"Extract this ${type}",transformQueryTitle:"Enter a JMESPath query",transformWizardLabel:"Wizard",transformWizardFilter:"Filter",transformWizardSortBy:"Sort by",transformWizardSelectFields:"Select fields",transformQueryLabel:"Query",transformPreviewLabel:"Preview",type:"Type",typeTitle:"Change the type of this field",openUrl:"Ctrl+Click or Ctrl+Enter to open url in new window",undo:"Undo last action (Ctrl+Z)",validationCannotMove:"Cannot move a field into a child of itself",autoType:'Field type "auto". The field type is automatically determined from the value and can be a string, number, boolean, or null.',objectType:'Field type "object". An object contains an unordered set of key/value pairs.',arrayType:'Field type "array". An array contains an ordered collection of values.',stringType:'Field type "string". Field type is not determined from the value, but always returned as string.',modeEditorTitle:"Switch Editor Mode",modeCodeText:"Code",modeCodeTitle:"Switch to code highlighter",modeFormText:"Form",modeFormTitle:"Switch to form editor",modeTextText:"Text",modeTextTitle:"Switch to plain text editor",modeTreeText:"Tree",modeTreeTitle:"Switch to tree editor",modeViewText:"View",modeViewTitle:"Switch to tree view",modePreviewText:"Preview",modePreviewTitle:"Switch to preview mode",examples:"Examples",default:"Default"},"zh-CN":{array:"数组",auto:"自动",appendText:"追加",appendTitle:"在此字段后追加一个类型为“auto”的新字段 (Ctrl+Shift+Ins)",appendSubmenuTitle:"选择要追加的字段类型",appendTitleAuto:"追加类型为“auto”的新字段 (Ctrl+Shift+Ins)",ascending:"升序",ascendingTitle:"升序排列${type}的子节点",actionsMenu:"点击打开动作菜单(Ctrl+M)",collapseAll:"缩进所有字段",descending:"降序",descendingTitle:"降序排列${type}的子节点",drag:"拖拽移动该节点(Alt+Shift+Arrows)",duplicateKey:"重复键",duplicateText:"复制",duplicateTitle:"复制选中字段(Ctrl+D)",duplicateField:"复制该字段(Ctrl+D)",duplicateFieldError:"重复的字段名称",cannotParseFieldError:"无法将字段解析为JSON",cannotParseValueError:"无法将值解析为JSON",empty:"清空",expandAll:"展开所有字段",expandTitle:"点击 展开/收缩 该字段(Ctrl+E). \nCtrl+Click 展开/收缩 包含所有子节点.",insert:"插入",insertTitle:"在此字段前插入类型为“auto”的新字段 (Ctrl+Ins)",insertSub:"选择要插入的字段类型",object:"对象",ok:"Ok",redo:"重做 (Ctrl+Shift+Z)",removeText:"移除",removeTitle:"移除选中字段 (Ctrl+Del)",removeField:"移除该字段 (Ctrl+Del)",selectNode:"选择一个节点...",showAll:"展示全部",showMore:"展示更多",showMoreStatus:"显示${totalChilds}的${visibleChilds}项目.",sort:"排序",sortTitle:"排序${type}的子节点",sortTitleShort:"内容排序",sortFieldLabel:"字段：",sortDirectionLabel:"方向：",sortFieldTitle:"选择用于对数组或对象排序的嵌套字段",sortAscending:"升序排序",sortAscendingTitle:"按照该字段升序排序",sortDescending:"降序排序",sortDescendingTitle:"按照该字段降序排序",string:"字符串",transform:"变换",transformTitle:"筛选，排序，或者转换${type}的子节点",transformTitleShort:"筛选，排序，或者转换内容",extract:"提取",extractTitle:"提取这个 ${type}",transformQueryTitle:"输入JMESPath查询",transformWizardLabel:"向导",transformWizardFilter:"筛选",transformWizardSortBy:"排序",transformWizardSelectFields:"选择字段",transformQueryLabel:"查询",transformPreviewLabel:"预览",type:"类型",typeTitle:"更改字段类型",openUrl:"Ctrl+Click 或者 Ctrl+Enter 在新窗口打开链接",undo:"撤销上次动作 (Ctrl+Z)",validationCannotMove:"无法将字段移入其子节点",autoType:'字段类型 "auto". 字段类型由值自动确定 可以为 string，number，boolean，或者 null.',objectType:'字段类型 "object". 对象包含一组无序的键/值对.',arrayType:'字段类型 "array". 数组包含值的有序集合.',stringType:'字段类型 "string". 字段类型由值自动确定，但始终作为字符串返回.',modeCodeText:"代码",modeCodeTitle:"切换至代码高亮",modeFormText:"表单",modeFormTitle:"切换至表单编辑",modeTextText:"文本",modeTextTitle:"切换至文本编辑",modeTreeText:"树",modeTreeTitle:"切换至树编辑",modeViewText:"视图",modeViewTitle:"切换至树视图",modePreviewText:"预览",modePreviewTitle:"切换至预览模式",examples:"例子",default:"缺省"},"pt-BR":{array:"Lista",auto:"Automatico",appendText:"Adicionar",appendTitle:"Adicionar novo campo com tipo 'auto' depois deste campo (Ctrl+Shift+Ins)",appendSubmenuTitle:"Selecione o tipo do campo a ser adicionado",appendTitleAuto:"Adicionar novo campo com tipo 'auto' (Ctrl+Shift+Ins)",ascending:"Ascendente",ascendingTitle:"Organizar filhor do tipo ${type} em crescente",actionsMenu:"Clique para abrir o menu de ações (Ctrl+M)",collapseAll:"Fechar todos campos",descending:"Descendente",descendingTitle:"Organizar o filhos do tipo ${type} em decrescente",duplicateKey:"chave duplicada",drag:"Arraste para mover este campo (Alt+Shift+Arrows)",duplicateText:"Duplicar",duplicateTitle:"Duplicar campos selecionados (Ctrl+D)",duplicateField:"Duplicar este campo (Ctrl+D)",duplicateFieldError:"Nome do campo duplicado",cannotParseFieldError:"Não é possível analisar o campo no JSON",cannotParseValueError:"Não é possível analisar o valor em JSON",empty:"vazio",expandAll:"Expandir todos campos",expandTitle:"Clique para expandir/encolher este campo (Ctrl+E). \nCtrl+Click para expandir/encolher incluindo todos os filhos.",insert:"Inserir",insertTitle:"Inserir um novo campo do tipo 'auto' antes deste campo (Ctrl+Ins)",insertSub:"Selecionar o tipo de campo a ser inserido",object:"Objeto",ok:"Ok",redo:"Refazer (Ctrl+Shift+Z)",removeText:"Remover",removeTitle:"Remover campos selecionados (Ctrl+Del)",removeField:"Remover este campo (Ctrl+Del)",selectNode:"Selecione um nódulo...",showAll:"mostrar todos",showMore:"mostrar mais",showMoreStatus:"exibindo ${visibleChilds} de ${totalChilds} itens.",sort:"Organizar",sortTitle:"Organizar os filhos deste ${type}",sortTitleShort:"Organizar os filhos",sortFieldLabel:"Campo:",sortDirectionLabel:"Direção:",sortFieldTitle:"Selecione um campo filho pelo qual ordenar o array ou objeto",sortAscending:"Ascendente",sortAscendingTitle:"Ordenar o campo selecionado por ordem ascendente",sortDescending:"Descendente",sortDescendingTitle:"Ordenar o campo selecionado por ordem descendente",string:"Texto",transform:"Transformar",transformTitle:"Filtrar, ordenar ou transformar os filhos deste ${type}",transformTitleShort:"Filtrar, ordenar ou transformar conteúdos",transformQueryTitle:"Insira uma expressão JMESPath",transformWizardLabel:"Assistente",transformWizardFilter:"Filtro",transformWizardSortBy:"Ordenar por",transformWizardSelectFields:"Selecionar campos",transformQueryLabel:"Expressão",transformPreviewLabel:"Visualizar",type:"Tipo",typeTitle:"Mudar o tipo deste campo",openUrl:"Ctrl+Click ou Ctrl+Enter para abrir link em nova janela",undo:"Desfazer último ação (Ctrl+Z)",validationCannotMove:"Não pode mover um campo como filho dele mesmo",autoType:'Campo do tipo "auto". O tipo do campo é determinao automaticamente a partir do seu valor e pode ser texto, número, verdade/falso ou nulo.',objectType:'Campo do tipo "objeto". Um objeto contém uma lista de pares com chave e valor.',arrayType:'Campo do tipo "lista". Uma lista contem uma coleção de valores ordenados.',stringType:'Campo do tipo "string". Campo do tipo nao é determinado através do seu valor, mas sempre retornara um texto.',examples:"Exemplos",default:"Revelia"},tr:{array:"Dizin",auto:"Otomatik",appendText:"Ekle",appendTitle:"Bu alanın altına 'otomatik' tipinde yeni bir alan ekle (Ctrl+Shift+Ins)",appendSubmenuTitle:"Eklenecek alanın tipini seç",appendTitleAuto:"'Otomatik' tipinde yeni bir alan ekle (Ctrl+Shift+Ins)",ascending:"Artan",ascendingTitle:"${type}'ın alt tiplerini artan düzende sırala",actionsMenu:"Aksiyon menüsünü açmak için tıklayın (Ctrl+M)",collapseAll:"Tüm alanları kapat",descending:"Azalan",descendingTitle:"${type}'ın alt tiplerini azalan düzende sırala",drag:"Bu alanı taşımak için sürükleyin (Alt+Shift+Arrows)",duplicateKey:"Var olan anahtar",duplicateText:"Aşağıya kopyala",duplicateTitle:"Seçili alanlardan bir daha oluştur (Ctrl+D)",duplicateField:"Bu alandan bir daha oluştur (Ctrl+D)",duplicateFieldError:"Duplicate field name",cannotParseFieldError:"Alan JSON'a ayrıştırılamıyor",cannotParseValueError:"JSON'a değer ayrıştırılamıyor",empty:"boş",expandAll:"Tüm alanları aç",expandTitle:"Bu alanı açmak/kapatmak için tıkla (Ctrl+E). \nAlt alanlarda dahil tüm alanları açmak için Ctrl+Click ",insert:"Ekle",insertTitle:"Bu alanın üstüne 'otomatik' tipinde yeni bir alan ekle (Ctrl+Ins)",insertSub:"Araya eklenecek alanın tipini seç",object:"Nesne",ok:"Tamam",redo:"Yeniden yap (Ctrl+Shift+Z)",removeText:"Kaldır",removeTitle:"Seçilen alanları kaldır (Ctrl+Del)",removeField:"Bu alanı kaldır (Ctrl+Del)",selectNode:"Bir nesne seç...",showAll:"tümünü göster",showMore:"daha fazla göster",showMoreStatus:"${totalChilds} alanın ${visibleChilds} alt alanları gösteriliyor",sort:"Sırala",sortTitle:"${type}'ın alt alanlarını sırala",sortTitleShort:"İçerikleri sırala",sortFieldLabel:"Alan:",sortDirectionLabel:"Yön:",sortFieldTitle:"Diziyi veya nesneyi sıralamak için iç içe geçmiş alanı seçin",sortAscending:"Artan",sortAscendingTitle:"Seçili alanı artan düzende sırala",sortDescending:"Azalan",sortDescendingTitle:"Seçili alanı azalan düzende sırala",string:"Karakter Dizisi",transform:"Dönüştür",transformTitle:"${type}'ın alt alanlarını filtrele, sırala veya dönüştür",transformTitleShort:"İçerikleri filterele, sırala veya dönüştür",transformQueryTitle:"JMESPath sorgusu gir",transformWizardLabel:"Sihirbaz",transformWizardFilter:"Filtre",transformWizardSortBy:"Sırala",transformWizardSelectFields:"Alanları seç",transformQueryLabel:"Sorgu",transformPreviewLabel:"Önizleme",type:"Tip",typeTitle:"Bu alanın tipini değiştir",openUrl:"URL'i yeni bir pencerede açmak için Ctrl+Click veya Ctrl+Enter",undo:"Son değişikliği geri al (Ctrl+Z)",validationCannotMove:"Alt alan olarak taşınamıyor",autoType:'Alan tipi "otomatik". Alan türü otomatik olarak değerden belirlenirve bir dize, sayı, boolean veya null olabilir.',objectType:'Alan tipi "nesne". Bir nesne, sıralanmamış bir anahtar / değer çifti kümesi içerir.',arrayType:'Alan tipi "dizi". Bir dizi, düzenli değerler koleksiyonu içerir.',stringType:'Alan tipi "karakter dizisi". Alan türü değerden belirlenmez,ancak her zaman karakter dizisi olarak döndürülür.',modeCodeText:"Kod",modeCodeTitle:"Kod vurgulayıcıya geç",modeFormText:"Form",modeFormTitle:"Form düzenleyiciye geç",modeTextText:"Metin",modeTextTitle:"Düz metin düzenleyiciye geç",modeTreeText:"Ağaç",modeTreeTitle:"Ağaç düzenleyiciye geç",modeViewText:"Görünüm",modeViewTitle:"Ağaç görünümüne geç",examples:"Örnekler",default:"Varsayılan"},ja:{array:"配列",auto:"オート",appendText:"追加",appendTitle:'次のフィールドに"オート"のフィールドを追加 (Ctrl+Shift+Ins)',appendSubmenuTitle:"追加するフィールドの型を選択してください",appendTitleAuto:'"オート"のフィールドを追加 (Ctrl+Shift+Ins)',ascending:"昇順",ascendingTitle:"${type}の子要素を昇順に並べ替え",actionsMenu:"クリックしてアクションメニューを開く (Ctrl+M)",collapseAll:"すべてを折りたたむ",descending:"降順",descendingTitle:"${type}の子要素を降順に並べ替え",drag:"ドラッグして選択中のフィールドを移動 (Alt+Shift+Arrows)",duplicateKey:"複製キー",duplicateText:"複製",duplicateTitle:"選択中のフィールドを複製 (Ctrl+D)",duplicateField:"選択中のフィールドを複製 (Ctrl+D)",duplicateFieldError:"フィールド名が重複しています",cannotParseFieldError:"JSONのフィールドを解析できません",cannotParseValueError:"JSONの値を解析できません",empty:"空",expandAll:"すべてを展開",expandTitle:"クリックしてフィールドを展開/折りたたむ (Ctrl+E). \nCtrl+Click ですべての子要素を展開/折りたたむ",insert:"挿入",insertTitle:"選択中のフィールドの前に新しいフィールドを挿入 (Ctrl+Ins)",insertSub:"挿入するフィールドの型を選択",object:"オブジェクト",ok:"実行",redo:"やり直す (Ctrl+Shift+Z)",removeText:"削除",removeTitle:"選択中のフィールドを削除 (Ctrl+Del)",removeField:"選択中のフィールドを削除 (Ctrl+Del)",selectNode:"ノードを選択...",showAll:"すべてを表示",showMore:"もっと見る",showMoreStatus:"${totalChilds}個のアイテムのうち ${visibleChilds}個を表示しています。",sort:"並べ替え",sortTitle:"${type}の子要素を並べ替え",sortTitleShort:"並べ替え",sortFieldLabel:"フィールド:",sortDirectionLabel:"順序:",sortFieldTitle:"配列またはオブジェクトを並び替えるためのフィールドを選択",sortAscending:"昇順",sortAscendingTitle:"選択中のフィールドを昇順に並び替え",sortDescending:"降順",sortDescendingTitle:"選択中のフィールドを降順に並び替え",string:"文字列",transform:"変換",transformTitle:"${type}の子要素をフィルター・並び替え・変換する",transformTitleShort:"内容をフィルター・並び替え・変換する",extract:"抽出",extractTitle:"${type}を抽出",transformQueryTitle:"JMESPathクエリを入力",transformWizardLabel:"ウィザード",transformWizardFilter:"フィルター",transformWizardSortBy:"並び替え",transformWizardSelectFields:"フィールドを選択",transformQueryLabel:"クエリ",transformPreviewLabel:"プレビュー",type:"型",typeTitle:"選択中のフィールドの型を変更",openUrl:"Ctrl+Click または Ctrl+Enter で 新規ウィンドウでURLを開く",undo:"元に戻す (Ctrl+Z)",validationCannotMove:"子要素に移動できません ",autoType:"オート： フィールドの型は値から自動的に決定されます。 (文字列・数値・ブール・null)",objectType:"オブジェクト： オブジェクトは順序が決まっていないキーと値のペア組み合わせです。",arrayType:"配列： 配列は順序が決まっている値の集合体です。",stringType:"文字列： フィールド型は値から決定されませんが、常に文字列として返されます。",modeCodeText:"コードモード",modeCodeTitle:"ハイライトモードに切り替え",modeFormText:"フォームモード",modeFormTitle:"フォームモードに切り替え",modeTextText:"テキストモード",modeTextTitle:"テキストモードに切り替え",modeTreeText:"ツリーモード",modeTreeTitle:"ツリーモードに切り替え",modeViewText:"ビューモード",modeViewTitle:"ビューモードに切り替え",modePreviewText:"プレビュー",modePreviewTitle:"プレビューに切り替え",examples:"例",default:"デフォルト"},"fr-FR":{array:"Liste",auto:"Auto",appendText:"Ajouter",appendTitle:"Ajouter un champ de type 'auto' après ce champ (Ctrl+Shift+Ins)",appendSubmenuTitle:"Sélectionner le type du champ à ajouter",appendTitleAuto:"Ajouter un champ de type 'auto' (Ctrl+Shift+Ins)",ascending:"Ascendant",ascendingTitle:"Trier les enfants de ce ${type} par ordre ascendant",actionsMenu:"Ouvrir le menu des actions (Ctrl+M)",collapseAll:"Regrouper",descending:"Descendant",descendingTitle:"Trier les enfants de ce ${type} par ordre descendant",drag:"Déplacer (Alt+Shift+Arrows)",duplicateKey:"Dupliquer la clé",duplicateText:"Dupliquer",duplicateTitle:"Dupliquer les champs sélectionnés (Ctrl+D)",duplicateField:"Dupliquer ce champ (Ctrl+D)",duplicateFieldError:"Dupliquer le nom de champ",cannotParseFieldError:"Champ impossible à parser en JSON",cannotParseValueError:"Valeur impossible à parser en JSON",empty:"vide",expandAll:"Étendre",expandTitle:"Étendre/regrouper ce champ (Ctrl+E). \nCtrl+Click pour étendre/regrouper avec tous les champs.",insert:"Insérer",insertTitle:"Insérer un champ de type 'auto' avant ce champ (Ctrl+Ins)",insertSub:"Sélectionner le type de champ à insérer",object:"Objet",ok:"Ok",redo:"Rejouer (Ctrl+Shift+Z)",removeText:"Supprimer",removeTitle:"Supprimer les champs sélectionnés (Ctrl+Del)",removeField:"Supprimer ce champ (Ctrl+Del)",searchTitle:"Rechercher champs et valeurs",searchNextResultTitle:"Résultat suivant (Enter)",searchPreviousResultTitle:"Résultat précédent (Shift + Enter)",selectNode:"Sélectionner un nœud...",showAll:"voir tout",showMore:"voir plus",showMoreStatus:"${visibleChilds} éléments affichés de ${totalChilds}.",sort:"Trier",sortTitle:"Trier les champs de ce ${type}",sortTitleShort:"Trier",sortFieldLabel:"Champ:",sortDirectionLabel:"Direction:",sortFieldTitle:"Sélectionner les champs permettant de trier les listes et objet",sortAscending:"Ascendant",sortAscendingTitle:"Trier les champs sélectionnés par ordre ascendant",sortDescending:"Descendant",sortDescendingTitle:"Trier les champs sélectionnés par ordre descendant",string:"Chaîne",transform:"Transformer",transformTitle:"Filtrer, trier, or transformer les enfants de ce ${type}",transformTitleShort:"Filtrer, trier ou transformer le contenu",extract:"Extraire",extractTitle:"Extraire ce ${type}",transformQueryTitle:"Saisir une requête JMESPath",transformWizardLabel:"Assistant",transformWizardFilter:"Filtrer",transformWizardSortBy:"Trier par",transformWizardSelectFields:"Sélectionner les champs",transformQueryLabel:"Requête",transformPreviewLabel:"Prévisualisation",type:"Type",typeTitle:"Changer le type de ce champ",openUrl:"Ctrl+Click ou Ctrl+Enter pour ouvrir l'url dans une autre fenêtre",undo:"Annuler la dernière action (Ctrl+Z)",validationCannotMove:"Cannot move a field into a child of itself",autoType:'Champe de type "auto". Ce type de champ est automatiquement déterminé en fonction de la valeur et peut être de type "chaîne", "nombre", "booléen" ou null.',objectType:'Champ de type "objet". Un objet contient un ensemble non ordonné de paires clé/valeur.',arrayType:'Champ de type "liste". Une liste contient une collection ordonnée de valeurs.',stringType:'Champ de type "chaîne". Ce type de champ n\'est pas déterminé en fonction de la valeur, mais retourne systématiquement une chaîne de caractères.',modeEditorTitle:"Changer mode d'édition",modeCodeText:"Code",modeCodeTitle:"Activer surlignage code",modeFormText:"Formulaire",modeFormTitle:"Activer formulaire",modeTextText:"Texte",modeTextTitle:"Activer éditeur texte",modeTreeText:"Arbre",modeTreeTitle:"Activer éditeur arbre",modeViewText:"Lecture seule",modeViewTitle:"Activer vue arbre",modePreviewText:"Prévisualisation",modePreviewTitle:"Activer mode prévisualiser",examples:"Exemples",default:"Défaut"}},r="en",s="undefined"!=typeof navigator?navigator.language||navigator.userLanguage:void 0,a=n.find(function(e){return e===s})||r;function l(t){if(t){var e=n.find(function(e){return e===t});e?a=e:console.error("Language not found")}}function c(e){if(e){var t=function(t){n.find(function(e){return e===t})||n.push(t),o[t]=Object.assign({},o[r],o[t],e[t])};for(var i in e)t(i)}}function d(e,t,i){var n=o[i=i||a][e];if(t)for(e in t)n=n.replace("${"+e+"}",t[e]);return n||e}},function(e,t,i){"use strict";i.d(t,"a",function(){return n}),i.d(t,"d",function(){return o}),i.d(t,"b",function(){return r}),i.d(t,"c",function(){return s});var n=document.body,o=10485760,r=2e4,s=2147483648},function(e,t,i){"use strict";i.d(t,"a",function(){return o});var u=i(10),p=i(0),g=i(1);function n(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var o=function(){function h(i,e){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,h),this.dom={};var v=this,t=this.dom;this.anchor=void 0,this.items=i,this.eventListeners={},this.selection=void 0,this.onClose=e?e.close:void 0;var n=document.createElement("div");n.className="jsoneditor-contextmenu-root",t.root=n;var o=document.createElement("div");o.className="jsoneditor-contextmenu",t.menu=o,n.appendChild(o);var r=document.createElement("ul");r.className="jsoneditor-menu",o.appendChild(r),t.list=r,t.items=[];var s=document.createElement("button");s.type="button",t.focusButton=s;var a=document.createElement("li");a.style.overflow="hidden",a.style.height="0",a.appendChild(s),r.appendChild(a),function p(f,m,e){e.forEach(function(t){if("separator"===t.type){var e=document.createElement("div");e.className="jsoneditor-separator";var i=document.createElement("li");i.appendChild(e),f.appendChild(i)}else{var n={},o=document.createElement("li");f.appendChild(o);var r=document.createElement("button");if(r.type="button",r.className=t.className,n.button=r,t.title&&(r.title=t.title),t.click&&(r.onclick=function(e){e.preventDefault(),v.hide(),t.click()}),o.appendChild(r),t.submenu){var s=document.createElement("div");s.className="jsoneditor-icon",r.appendChild(s);var a,l=document.createElement("div");if(l.className="jsoneditor-text"+(t.click?"":" jsoneditor-right-margin"),l.appendChild(document.createTextNode(t.text)),r.appendChild(l),t.click){r.className+=" jsoneditor-default";var c=document.createElement("button");c.type="button",(n.buttonExpand=c).className="jsoneditor-expand",c.innerHTML='<div class="jsoneditor-expand"></div>',o.appendChild(c),t.submenuTitle&&(c.title=t.submenuTitle),a=c}else{var d=document.createElement("div");d.className="jsoneditor-expand",r.appendChild(d),a=r}a.onclick=function(e){e.preventDefault(),v._onExpandItem(n),a.focus()};var h=[];n.subItems=h;var u=document.createElement("ul");(n.ul=u).className="jsoneditor-menu",u.style.height="0",o.appendChild(u),p(u,h,t.submenu)}else r.innerHTML='<div class="jsoneditor-icon"></div><div class="jsoneditor-text">'+Object(g.c)(t.text)+"</div>";m.push(n)}})}(r,this.dom.items,i),this.maxHeight=0,i.forEach(function(e){var t=24*(i.length+(e.submenu?e.submenu.length:0));v.maxHeight=Math.max(v.maxHeight,t)})}return function(e,t,i){t&&n(e.prototype,t),i&&n(e,i)}(h,[{key:"_getVisibleButtons",value:function(){var t=[],i=this;return this.dom.items.forEach(function(e){t.push(e.button),e.buttonExpand&&t.push(e.buttonExpand),e.subItems&&e===i.expandedItem&&e.subItems.forEach(function(e){t.push(e.button),e.buttonExpand&&t.push(e.buttonExpand)})}),t}},{key:"show",value:function(e,t,i){this.hide();var n=!0,o=e.parentNode,r=e.getBoundingClientRect(),s=o.getBoundingClientRect(),a=t.getBoundingClientRect(),l=this;this.dom.absoluteAnchor=Object(u.a)(e,t,function(){l.hide()}),r.bottom+this.maxHeight<a.bottom||r.top-this.maxHeight>a.top&&(n=!1);var c=i?0:r.top-s.top;if(n){var d=e.offsetHeight;this.dom.menu.style.left="0",this.dom.menu.style.top=c+d+"px",this.dom.menu.style.bottom=""}else this.dom.menu.style.left="0",this.dom.menu.style.top="",this.dom.menu.style.bottom="0px";this.dom.absoluteAnchor.appendChild(this.dom.root),this.selection=Object(p.getSelection)(),this.anchor=e,setTimeout(function(){l.dom.focusButton.focus()},0),h.visibleMenu&&h.visibleMenu.hide(),h.visibleMenu=this}},{key:"hide",value:function(){this.dom.absoluteAnchor&&(this.dom.absoluteAnchor.destroy(),delete this.dom.absoluteAnchor),this.dom.root.parentNode&&(this.dom.root.parentNode.removeChild(this.dom.root),this.onClose&&this.onClose()),h.visibleMenu===this&&(h.visibleMenu=void 0)}},{key:"_onExpandItem",value:function(i){var n=this,e=i===this.expandedItem,t=this.expandedItem;if(t&&(t.ul.style.height="0",t.ul.style.padding="",setTimeout(function(){n.expandedItem!==t&&(t.ul.style.display="",Object(p.removeClassName)(t.ul.parentNode,"jsoneditor-selected"))},300),this.expandedItem=void 0),!e){var o=i.ul;o.style.display="block",o.clientHeight,setTimeout(function(){if(n.expandedItem===i){for(var e=0,t=0;t<o.childNodes.length;t++)e+=o.childNodes[t].clientHeight;o.style.height=e+"px",o.style.padding="5px 10px"}},0),Object(p.addClassName)(o.parentNode,"jsoneditor-selected"),this.expandedItem=i}}},{key:"_onKeyDown",value:function(e){var t,i,n,o,r=e.target,s=e.which,a=!1;27===s?(this.selection&&Object(p.setSelection)(this.selection),this.anchor&&this.anchor.focus(),this.hide(),a=!0):9===s?e.shiftKey?0===(i=(t=this._getVisibleButtons()).indexOf(r))&&(t[t.length-1].focus(),a=!0):(i=(t=this._getVisibleButtons()).indexOf(r))===t.length-1&&(t[0].focus(),a=!0):37===s?("jsoneditor-expand"===r.className&&(i=(t=this._getVisibleButtons()).indexOf(r),(n=t[i-1])&&n.focus()),a=!0):38===s?(i=(t=this._getVisibleButtons()).indexOf(r),(n=t[i-1])&&"jsoneditor-expand"===n.className&&(n=t[i-2]),(n=n||t[t.length-1])&&n.focus(),a=!0):39===s?(i=(t=this._getVisibleButtons()).indexOf(r),(o=t[i+1])&&"jsoneditor-expand"===o.className&&o.focus(),a=!0):40===s&&(i=(t=this._getVisibleButtons()).indexOf(r),(o=t[i+1])&&"jsoneditor-expand"===o.className&&(o=t[i+2]),(o=o||t[0])&&(o.focus(),a=!0),a=!0),a&&(e.stopPropagation(),e.preventDefault())}}]),h}();o.visibleMenu=void 0},function(e,t,i){!function(e){"use strict";function j(e){return null!==e&&"[object Array]"===Object.prototype.toString.call(e)}function N(e){return null!==e&&"[object Object]"===Object.prototype.toString.call(e)}function k(e,t){if(e===t)return!0;if(Object.prototype.toString.call(e)!==Object.prototype.toString.call(t))return!1;if(!0===j(e)){if(e.length!==t.length)return!1;for(var i=0;i<e.length;i++)if(!1===k(e[i],t[i]))return!1;return!0}if(!0!==N(e))return!1;var n={};for(var o in e)if(hasOwnProperty.call(e,o)){if(!1===k(e[o],t[o]))return!1;n[o]=!0}for(var r in t)if(hasOwnProperty.call(t,r)&&!0!==n[r])return!1;return!0}function O(e){if(""===e||!1===e||null===e)return!0;if(j(e)&&0===e.length)return!0;if(N(e)){for(var t in e)if(e.hasOwnProperty(t))return!1;return!0}return!1}var s;s="function"==typeof String.prototype.trimLeft?function(e){return e.trimLeft()}:function(e){return e.match(/^\s*(.*)/)[1]};var c=0,r=1,d=2,a=3,t=4,i=6,l=8,h=9,u="UnquotedIdentifier",p="QuotedIdentifier",f="Rbracket",m="Rparen",v="Comma",g="Colon",y="Rbrace",b="Number",I="Current",D="Expref",A="Pipe",P="GTE",M="LTE",F="Flatten",x="Star",C="Filter",_="Dot",E="Lbrace",w="Lbracket",T="Lparen",S="Literal",L={".":_,"*":x,",":v,":":g,"{":E,"}":y,"]":f,"(":T,")":m,"@":I},V={"<":!0,">":!0,"=":!0,"!":!0},B={" ":!0,"\t":!0,"\n":!0};function R(e){return"0"<=e&&e<="9"||"-"===e}function n(){}n.prototype={tokenize:function(e){var t,i,n,o,r=[];for(this._current=0;this._current<e.length;)if("a"<=(o=e[this._current])&&o<="z"||"A"<=o&&o<="Z"||"_"===o)t=this._current,i=this._consumeUnquotedIdentifier(e),r.push({type:u,value:i,start:t});else if(void 0!==L[e[this._current]])r.push({type:L[e[this._current]],value:e[this._current],start:this._current}),this._current++;else if(R(e[this._current]))n=this._consumeNumber(e),r.push(n);else if("["===e[this._current])n=this._consumeLBracket(e),r.push(n);else if('"'===e[this._current])t=this._current,i=this._consumeQuotedIdentifier(e),r.push({type:p,value:i,start:t});else if("'"===e[this._current])t=this._current,i=this._consumeRawStringLiteral(e),r.push({type:S,value:i,start:t});else if("`"===e[this._current]){t=this._current;var s=this._consumeLiteral(e);r.push({type:S,value:s,start:t})}else if(void 0!==V[e[this._current]])r.push(this._consumeOperator(e));else if(void 0!==B[e[this._current]])this._current++;else if("&"===e[this._current])t=this._current,this._current++,"&"===e[this._current]?(this._current++,r.push({type:"And",value:"&&",start:t})):r.push({type:D,value:"&",start:t});else{if("|"!==e[this._current]){var a=new Error("Unknown character:"+e[this._current]);throw a.name="LexerError",a}t=this._current,this._current++,"|"===e[this._current]?(this._current++,r.push({type:"Or",value:"||",start:t})):r.push({type:A,value:"|",start:t})}return r},_consumeUnquotedIdentifier:function(e){var t,i=this._current;for(this._current++;this._current<e.length&&("a"<=(t=e[this._current])&&t<="z"||"A"<=t&&t<="Z"||"0"<=t&&t<="9"||"_"===t);)this._current++;return e.slice(i,this._current)},_consumeQuotedIdentifier:function(e){var t=this._current;this._current++;for(var i=e.length;'"'!==e[this._current]&&this._current<i;){var n=this._current;"\\"!==e[n]||"\\"!==e[n+1]&&'"'!==e[n+1]?n++:n+=2,this._current=n}return this._current++,JSON.parse(e.slice(t,this._current))},_consumeRawStringLiteral:function(e){var t=this._current;this._current++;for(var i=e.length;"'"!==e[this._current]&&this._current<i;){var n=this._current;"\\"!==e[n]||"\\"!==e[n+1]&&"'"!==e[n+1]?n++:n+=2,this._current=n}return this._current++,e.slice(t+1,this._current-1).replace("\\'","'")},_consumeNumber:function(e){var t=this._current;this._current++;for(var i=e.length;R(e[this._current])&&this._current<i;)this._current++;var n=parseInt(e.slice(t,this._current));return{type:b,value:n,start:t}},_consumeLBracket:function(e){var t=this._current;return this._current++,"?"===e[this._current]?(this._current++,{type:C,value:"[?",start:t}):"]"===e[this._current]?(this._current++,{type:F,value:"[]",start:t}):{type:w,value:"[",start:t}},_consumeOperator:function(e){var t=this._current,i=e[t];return this._current++,"!"===i?"="===e[this._current]?(this._current++,{type:"NE",value:"!=",start:t}):{type:"Not",value:"!",start:t}:"<"===i?"="===e[this._current]?(this._current++,{type:M,value:"<=",start:t}):{type:"LT",value:"<",start:t}:">"===i?"="===e[this._current]?(this._current++,{type:P,value:">=",start:t}):{type:"GT",value:">",start:t}:"="===i&&"="===e[this._current]?(this._current++,{type:"EQ",value:"==",start:t}):void 0},_consumeLiteral:function(e){this._current++;for(var t,i=this._current,n=e.length;"`"!==e[this._current]&&this._current<n;){var o=this._current;"\\"!==e[o]||"\\"!==e[o+1]&&"`"!==e[o+1]?o++:o+=2,this._current=o}var r=s(e.slice(i,this._current));return r=r.replace("\\`","`"),t=this._looksLikeJSON(r)?JSON.parse(r):JSON.parse('"'+r+'"'),this._current++,t},_looksLikeJSON:function(e){if(""===e)return!1;if(0<='[{"'.indexOf(e[0]))return!0;if(0<=["true","false","null"].indexOf(e))return!0;if(!(0<="-0123456789".indexOf(e[0])))return!1;try{return JSON.parse(e),!0}catch(e){return!1}}};var H={};function z(){}function U(e){this.runtime=e}function J(e){this._interpreter=e,this.functionTable={abs:{_func:this._functionAbs,_signature:[{types:[c]}]},avg:{_func:this._functionAvg,_signature:[{types:[l]}]},ceil:{_func:this._functionCeil,_signature:[{types:[c]}]},contains:{_func:this._functionContains,_signature:[{types:[d,a]},{types:[r]}]},ends_with:{_func:this._functionEndsWith,_signature:[{types:[d]},{types:[d]}]},floor:{_func:this._functionFloor,_signature:[{types:[c]}]},length:{_func:this._functionLength,_signature:[{types:[d,a,t]}]},map:{_func:this._functionMap,_signature:[{types:[i]},{types:[a]}]},max:{_func:this._functionMax,_signature:[{types:[l,h]}]},merge:{_func:this._functionMerge,_signature:[{types:[t],variadic:!0}]},max_by:{_func:this._functionMaxBy,_signature:[{types:[a]},{types:[i]}]},sum:{_func:this._functionSum,_signature:[{types:[l]}]},starts_with:{_func:this._functionStartsWith,_signature:[{types:[d]},{types:[d]}]},min:{_func:this._functionMin,_signature:[{types:[l,h]}]},min_by:{_func:this._functionMinBy,_signature:[{types:[a]},{types:[i]}]},type:{_func:this._functionType,_signature:[{types:[r]}]},keys:{_func:this._functionKeys,_signature:[{types:[t]}]},values:{_func:this._functionValues,_signature:[{types:[t]}]},sort:{_func:this._functionSort,_signature:[{types:[h,l]}]},sort_by:{_func:this._functionSortBy,_signature:[{types:[a]},{types:[i]}]},join:{_func:this._functionJoin,_signature:[{types:[d]},{types:[h]}]},reverse:{_func:this._functionReverse,_signature:[{types:[d,a]}]},to_array:{_func:this._functionToArray,_signature:[{types:[r]}]},to_string:{_func:this._functionToString,_signature:[{types:[r]}]},to_number:{_func:this._functionToNumber,_signature:[{types:[r]}]},not_null:{_func:this._functionNotNull,_signature:[{types:[r],variadic:!0}]}}}H.EOF=0,H[u]=0,H[p]=0,H[f]=0,H[m]=0,H[v]=0,H[y]=0,H[b]=0,H[I]=0,H[D]=0,H[A]=1,H.Or=2,H.And=3,H.EQ=5,H.GT=5,H.LT=5,H.GTE=5,H.LTE=5,H.NE=5,H[F]=9,H[x]=20,H[C]=21,H.Dot=40,H.Not=45,H[E]=50,H[w]=55,H[T]=60,z.prototype={parse:function(e){this._loadTokens(e),this.index=0;var t=this.expression(0);if("EOF"===this._lookahead(0))return t;var i=this._lookaheadToken(0),n=new Error("Unexpected token type: "+i.type+", value: "+i.value);throw n.name="ParserError",n},_loadTokens:function(e){var t=(new n).tokenize(e);t.push({type:"EOF",value:"",start:e.length}),this.tokens=t},expression:function(e){var t=this._lookaheadToken(0);this._advance();for(var i=this.nud(t),n=this._lookahead(0);e<H[n];)this._advance(),i=this.led(n,i),n=this._lookahead(0);return i},_lookahead:function(e){return this.tokens[this.index+e].type},_lookaheadToken:function(e){return this.tokens[this.index+e]},_advance:function(){this.index++},nud:function(e){var t,i;switch(e.type){case S:return{type:"Literal",value:e.value};case u:return{type:"Field",name:e.value};case p:var n={type:"Field",name:e.value};if(this._lookahead(0)===T)throw new Error("Quoted identifier not allowed for function names.");return n;case"Not":return{type:"NotExpression",children:[t=this.expression(H.Not)]};case x:return t=null,{type:"ValueProjection",children:[{type:"Identity"},t=this._lookahead(0)===f?{type:"Identity"}:this._parseProjectionRHS(H.Star)]};case C:return this.led(e.type,{type:"Identity"});case E:return this._parseMultiselectHash();case F:return{type:"Projection",children:[{type:F,children:[{type:"Identity"}]},t=this._parseProjectionRHS(H.Flatten)]};case w:return this._lookahead(0)===b||this._lookahead(0)===g?(t=this._parseIndexExpression(),this._projectIfSlice({type:"Identity"},t)):this._lookahead(0)===x&&this._lookahead(1)===f?(this._advance(),this._advance(),{type:"Projection",children:[{type:"Identity"},t=this._parseProjectionRHS(H.Star)]}):this._parseMultiselectList();case I:return{type:I};case D:return{type:"ExpressionReference",children:[i=this.expression(H.Expref)]};case T:for(var o=[];this._lookahead(0)!==m;)this._lookahead(0)===I?(i={type:I},this._advance()):i=this.expression(0),o.push(i);return this._match(m),o[0];default:this._errorToken(e)}},led:function(e,t){var i;switch(e){case _:var n=H.Dot;return this._lookahead(0)!==x?{type:"Subexpression",children:[t,i=this._parseDotRHS(n)]}:(this._advance(),{type:"ValueProjection",children:[t,i=this._parseProjectionRHS(n)]});case A:return i=this.expression(H.Pipe),{type:A,children:[t,i]};case"Or":return{type:"OrExpression",children:[t,i=this.expression(H.Or)]};case"And":return{type:"AndExpression",children:[t,i=this.expression(H.And)]};case T:for(var o,r=t.name,s=[];this._lookahead(0)!==m;)this._lookahead(0)===I?(o={type:I},this._advance()):o=this.expression(0),this._lookahead(0)===v&&this._match(v),s.push(o);return this._match(m),{type:"Function",name:r,children:s};case C:var a=this.expression(0);return this._match(f),{type:"FilterProjection",children:[t,i=this._lookahead(0)===F?{type:"Identity"}:this._parseProjectionRHS(H.Filter),a]};case F:return{type:"Projection",children:[{type:F,children:[t]},this._parseProjectionRHS(H.Flatten)]};case"EQ":case"NE":case"GT":case P:case"LT":case M:return this._parseComparator(t,e);case w:var l=this._lookaheadToken(0);return l.type===b||l.type===g?(i=this._parseIndexExpression(),this._projectIfSlice(t,i)):(this._match(x),this._match(f),{type:"Projection",children:[t,i=this._parseProjectionRHS(H.Star)]});default:this._errorToken(this._lookaheadToken(0))}},_match:function(e){if(this._lookahead(0)!==e){var t=this._lookaheadToken(0),i=new Error("Expected "+e+", got: "+t.type);throw i.name="ParserError",i}this._advance()},_errorToken:function(e){var t=new Error("Invalid token ("+e.type+'): "'+e.value+'"');throw t.name="ParserError",t},_parseIndexExpression:function(){if(this._lookahead(0)===g||this._lookahead(1)===g)return this._parseSliceExpression();var e={type:"Index",value:this._lookaheadToken(0).value};return this._advance(),this._match(f),e},_projectIfSlice:function(e,t){var i={type:"IndexExpression",children:[e,t]};return"Slice"===t.type?{type:"Projection",children:[i,this._parseProjectionRHS(H.Star)]}:i},_parseSliceExpression:function(){for(var e=[null,null,null],t=0,i=this._lookahead(0);i!==f&&t<3;){if(i===g)t++,this._advance();else{if(i!==b){var n=this._lookahead(0),o=new Error("Syntax error, unexpected token: "+n.value+"("+n.type+")");throw o.name="Parsererror",o}e[t]=this._lookaheadToken(0).value,this._advance()}i=this._lookahead(0)}return this._match(f),{type:"Slice",children:e}},_parseComparator:function(e,t){return{type:"Comparator",name:t,children:[e,this.expression(H[t])]}},_parseDotRHS:function(e){var t=this._lookahead(0);return 0<=[u,p,x].indexOf(t)?this.expression(e):t===w?(this._match(w),this._parseMultiselectList()):t===E?(this._match(E),this._parseMultiselectHash()):void 0},_parseProjectionRHS:function(e){var t;if(H[this._lookahead(0)]<10)t={type:"Identity"};else if(this._lookahead(0)===w)t=this.expression(e);else if(this._lookahead(0)===C)t=this.expression(e);else{if(this._lookahead(0)!==_){var i=this._lookaheadToken(0),n=new Error("Sytanx error, unexpected token: "+i.value+"("+i.type+")");throw n.name="ParserError",n}this._match(_),t=this._parseDotRHS(e)}return t},_parseMultiselectList:function(){for(var e=[];this._lookahead(0)!==f;){var t=this.expression(0);if(e.push(t),this._lookahead(0)===v&&(this._match(v),this._lookahead(0)===f))throw new Error("Unexpected token Rbracket")}return this._match(f),{type:"MultiSelectList",children:e}},_parseMultiselectHash:function(){for(var e,t,i,n=[],o=[u,p];;){if(e=this._lookaheadToken(0),o.indexOf(e.type)<0)throw new Error("Expecting an identifier token, got: "+e.type);if(t=e.value,this._advance(),this._match(g),i={type:"KeyValuePair",name:t,value:this.expression(0)},n.push(i),this._lookahead(0)===v)this._match(v);else if(this._lookahead(0)===y){this._match(y);break}}return{type:"MultiSelectHash",children:n}}},U.prototype={search:function(e,t){return this.visit(e,t)},visit:function(e,t){var i,n,o,r,s,a,l,c,d;switch(e.type){case"Field":return null===t?null:N(t)?void 0===(a=t[e.name])?null:a:null;case"Subexpression":for(o=this.visit(e.children[0],t),d=1;d<e.children.length;d++)if(null===(o=this.visit(e.children[1],o)))return null;return o;case"IndexExpression":return l=this.visit(e.children[0],t),this.visit(e.children[1],l);case"Index":if(!j(t))return null;var h=e.value;return h<0&&(h=t.length+h),void 0===(o=t[h])&&(o=null),o;case"Slice":if(!j(t))return null;var u=e.children.slice(0),p=this.computeSliceParams(t.length,u),f=p[0],m=p[1],v=p[2];if(o=[],0<v)for(d=f;d<m;d+=v)o.push(t[d]);else for(d=f;m<d;d+=v)o.push(t[d]);return o;case"Projection":var g=this.visit(e.children[0],t);if(!j(g))return null;for(c=[],d=0;d<g.length;d++)null!==(n=this.visit(e.children[1],g[d]))&&c.push(n);return c;case"ValueProjection":if(!N(g=this.visit(e.children[0],t)))return null;c=[];var y=function(e){for(var t=Object.keys(e),i=[],n=0;n<t.length;n++)i.push(e[t[n]]);return i}(g);for(d=0;d<y.length;d++)null!==(n=this.visit(e.children[1],y[d]))&&c.push(n);return c;case"FilterProjection":if(!j(g=this.visit(e.children[0],t)))return null;var b=[],x=[];for(d=0;d<g.length;d++)O(i=this.visit(e.children[2],g[d]))||b.push(g[d]);for(var C=0;C<b.length;C++)null!==(n=this.visit(e.children[1],b[C]))&&x.push(n);return x;case"Comparator":switch(r=this.visit(e.children[0],t),s=this.visit(e.children[1],t),e.name){case"EQ":o=k(r,s);break;case"NE":o=!k(r,s);break;case"GT":o=s<r;break;case P:o=s<=r;break;case"LT":o=r<s;break;case M:o=r<=s;break;default:throw new Error("Unknown comparator: "+e.name)}return o;case F:var _=this.visit(e.children[0],t);if(!j(_))return null;var E=[];for(d=0;d<_.length;d++)j(n=_[d])?E.push.apply(E,n):E.push(n);return E;case"Identity":return t;case"MultiSelectList":if(null===t)return null;for(c=[],d=0;d<e.children.length;d++)c.push(this.visit(e.children[d],t));return c;case"MultiSelectHash":if(null===t)return null;var w;for(c={},d=0;d<e.children.length;d++)c[(w=e.children[d]).name]=this.visit(w.value,t);return c;case"OrExpression":return O(i=this.visit(e.children[0],t))&&(i=this.visit(e.children[1],t)),i;case"AndExpression":return!0===O(r=this.visit(e.children[0],t))?r:this.visit(e.children[1],t);case"NotExpression":return O(r=this.visit(e.children[0],t));case"Literal":return e.value;case A:return l=this.visit(e.children[0],t),this.visit(e.children[1],l);case I:return t;case"Function":var T=[];for(d=0;d<e.children.length;d++)T.push(this.visit(e.children[d],t));return this.runtime.callFunction(e.name,T);case"ExpressionReference":var S=e.children[0];return S.jmespathType=D,S;default:throw new Error("Unknown node type: "+e.type)}},computeSliceParams:function(e,t){var i=t[0],n=t[1],o=t[2],r=[null,null,null];if(null===o)o=1;else if(0===o){var s=new Error("Invalid slice, step cannot be 0");throw s.name="RuntimeError",s}var a=o<0;return i=null===i?a?e-1:0:this.capSliceRange(e,i,o),n=null===n?a?-1:e:this.capSliceRange(e,n,o),r[0]=i,r[1]=n,r[2]=o,r},capSliceRange:function(e,t,i){return t<0?(t+=e)<0&&(t=i<0?-1:0):e<=t&&(t=i<0?e-1:e),t}},J.prototype={callFunction:function(e,t){var i=this.functionTable[e];if(void 0===i)throw new Error("Unknown function: "+e+"()");return this._validateArgs(e,t,i._signature),i._func.call(this,t)},_validateArgs:function(e,t,i){var n,o,r,s;if(i[i.length-1].variadic){if(t.length<i.length)throw n=1===i.length?" argument":" arguments",new Error("ArgumentError: "+e+"() takes at least"+i.length+n+" but received "+t.length)}else if(t.length!==i.length)throw n=1===i.length?" argument":" arguments",new Error("ArgumentError: "+e+"() takes "+i.length+n+" but received "+t.length);for(var a=0;a<i.length;a++){s=!1,o=i[a].types,r=this._getTypeName(t[a]);for(var l=0;l<o.length;l++)if(this._typeMatches(r,o[l],t[a])){s=!0;break}if(!s)throw new Error("TypeError: "+e+"() expected argument "+(a+1)+" to be type "+o+" but received type "+r+" instead.")}},_typeMatches:function(e,t,i){if(t===r)return!0;if(t!==h&&t!==l&&t!==a)return e===t;if(t===a)return e===a;if(e===a){var n;t===l?n=c:t===h&&(n=d);for(var o=0;o<i.length;o++)if(!this._typeMatches(this._getTypeName(i[o]),n,i[o]))return!1;return!0}},_getTypeName:function(e){switch(Object.prototype.toString.call(e)){case"[object String]":return d;case"[object Number]":return c;case"[object Array]":return a;case"[object Boolean]":return 5;case"[object Null]":return 7;case"[object Object]":return e.jmespathType===D?i:t}},_functionStartsWith:function(e){return 0===e[0].lastIndexOf(e[1])},_functionEndsWith:function(e){var t=e[0],i=e[1];return-1!==t.indexOf(i,t.length-i.length)},_functionReverse:function(e){if(this._getTypeName(e[0])===d){for(var t=e[0],i="",n=t.length-1;0<=n;n--)i+=t[n];return i}var o=e[0].slice(0);return o.reverse(),o},_functionAbs:function(e){return Math.abs(e[0])},_functionCeil:function(e){return Math.ceil(e[0])},_functionAvg:function(e){for(var t=0,i=e[0],n=0;n<i.length;n++)t+=i[n];return t/i.length},_functionContains:function(e){return 0<=e[0].indexOf(e[1])},_functionFloor:function(e){return Math.floor(e[0])},_functionLength:function(e){return N(e[0])?Object.keys(e[0]).length:e[0].length},_functionMap:function(e){for(var t=[],i=this._interpreter,n=e[0],o=e[1],r=0;r<o.length;r++)t.push(i.visit(n,o[r]));return t},_functionMerge:function(e){for(var t={},i=0;i<e.length;i++){var n=e[i];for(var o in n)t[o]=n[o]}return t},_functionMax:function(e){if(0<e[0].length){if(this._getTypeName(e[0][0])===c)return Math.max.apply(Math,e[0]);for(var t=e[0],i=t[0],n=1;n<t.length;n++)i.localeCompare(t[n])<0&&(i=t[n]);return i}return null},_functionMin:function(e){if(0<e[0].length){if(this._getTypeName(e[0][0])===c)return Math.min.apply(Math,e[0]);for(var t=e[0],i=t[0],n=1;n<t.length;n++)t[n].localeCompare(i)<0&&(i=t[n]);return i}return null},_functionSum:function(e){for(var t=0,i=e[0],n=0;n<i.length;n++)t+=i[n];return t},_functionType:function(e){switch(this._getTypeName(e[0])){case c:return"number";case d:return"string";case a:return"array";case t:return"object";case 5:return"boolean";case i:return"expref";case 7:return"null"}},_functionKeys:function(e){return Object.keys(e[0])},_functionValues:function(e){for(var t=e[0],i=Object.keys(t),n=[],o=0;o<i.length;o++)n.push(t[i[o]]);return n},_functionJoin:function(e){var t=e[0];return e[1].join(t)},_functionToArray:function(e){return this._getTypeName(e[0])===a?e[0]:[e[0]]},_functionToString:function(e){return this._getTypeName(e[0])===d?e[0]:JSON.stringify(e[0])},_functionToNumber:function(e){var t,i=this._getTypeName(e[0]);return i===c?e[0]:i!==d||(t=+e[0],isNaN(t))?null:t},_functionNotNull:function(e){for(var t=0;t<e.length;t++)if(7!==this._getTypeName(e[t]))return e[t];return null},_functionSort:function(e){var t=e[0].slice(0);return t.sort(),t},_functionSortBy:function(e){var t=e[0].slice(0);if(0===t.length)return t;var o=this._interpreter,r=e[1],s=this._getTypeName(o.visit(r,t[0]));if([c,d].indexOf(s)<0)throw new Error("TypeError");for(var a=this,i=[],n=0;n<t.length;n++)i.push([n,t[n]]);i.sort(function(e,t){var i=o.visit(r,e[1]),n=o.visit(r,t[1]);if(a._getTypeName(i)!==s)throw new Error("TypeError: expected "+s+", received "+a._getTypeName(i));if(a._getTypeName(n)!==s)throw new Error("TypeError: expected "+s+", received "+a._getTypeName(n));return n<i?1:i<n?-1:e[0]-t[0]});for(var l=0;l<i.length;l++)t[l]=i[l][1];return t},_functionMaxBy:function(e){for(var t,i,n=e[1],o=e[0],r=this.createKeyFunction(n,[c,d]),s=-1/0,a=0;a<o.length;a++)s<(i=r(o[a]))&&(s=i,t=o[a]);return t},_functionMinBy:function(e){for(var t,i,n=e[1],o=e[0],r=this.createKeyFunction(n,[c,d]),s=1/0,a=0;a<o.length;a++)(i=r(o[a]))<s&&(s=i,t=o[a]);return t},createKeyFunction:function(n,o){var r=this,s=this._interpreter;return function(e){var t=s.visit(n,e);if(o.indexOf(r._getTypeName(t))<0){var i="TypeError: expected one of "+o+", received "+r._getTypeName(t);throw new Error(i)}return t}}},e.tokenize=function(e){return(new n).tokenize(e)},e.compile=function(e){return(new z).parse(e)},e.search=function(e,t){var i=new z,n=new J,o=new U(n);n._interpreter=o;var r=i.parse(t);return o.search(r,e)},e.strictDeepEqual=k}(t)},function(e,t,i){"use strict";i.d(t,"a",function(){return s});var n=i(12),o=i.n(n),r=i(1),d=i(0);function s(e,t,s,i){var a=Array.isArray(t)?Object(d.getChildPaths)(t):[""],l=i&&i.path&&Object(d.contains)(a,i.path)?i.path:a[0],c=i&&i.direction||"asc",n='<div class="pico-modal-contents"><div class="pico-modal-header">'+Object(r.c)("sort")+"</div><form><table><tbody><tr>  <td>"+Object(r.c)("sortFieldLabel")+' </td>  <td class="jsoneditor-modal-input">  <div class="jsoneditor-select-wrapper">    <select id="field" title="'+Object(r.c)("sortFieldTitle")+'">    </select>  </div>  </td></tr><tr>  <td>'+Object(r.c)("sortDirectionLabel")+' </td>  <td class="jsoneditor-modal-input">  <div id="direction" class="jsoneditor-button-group"><input type="button" value="'+Object(r.c)("sortAscending")+'" title="'+Object(r.c)("sortAscendingTitle")+'" data-value="asc" class="jsoneditor-button-first jsoneditor-button-asc"/><input type="button" value="'+Object(r.c)("sortDescending")+'" title="'+Object(r.c)("sortDescendingTitle")+'" data-value="desc" class="jsoneditor-button-last jsoneditor-button-desc"/>  </div>  </td></tr><tr><td colspan="2" class="jsoneditor-modal-input jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+Object(r.c)("ok")+'" /></td></tr></tbody></table></form></div>';o()({parent:e,content:n,overlayClass:"jsoneditor-modal-overlay",overlayStyles:{backgroundColor:"rgb(1,1,1)",opacity:.3},modalClass:"jsoneditor-modal jsoneditor-modal-sort"}).afterCreate(function(t){var e=t.modalElem().querySelector("form"),i=t.modalElem().querySelector("#ok"),n=t.modalElem().querySelector("#field"),o=t.modalElem().querySelector("#direction");function r(e){o.value=e,o.className="jsoneditor-button-group jsoneditor-button-group-value-"+o.value}a.forEach(function(e){var t=document.createElement("option");t.text=function(e){return""===e?"@":"."===e[0]?e.slice(1):e}(e),t.value=e,n.appendChild(t)}),n.value=l||a[0],r(c||"asc"),o.onclick=function(e){r(e.target.getAttribute("data-value"))},i.onclick=function(e){e.preventDefault(),e.stopPropagation(),t.close(),s({path:n.value,direction:o.value})},e&&(e.onsubmit=i.onclick)}).afterClose(function(e){e.destroy()}).show()}},function(e,t,i){"use strict";i.d(t,"a",function(){return o});var f=i(3),m=i(1);function n(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var o=function(){function p(e,t,i,n){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,p);for(var o={code:{text:Object(m.c)("modeCodeText"),title:Object(m.c)("modeCodeTitle"),click:function(){n("code")}},form:{text:Object(m.c)("modeFormText"),title:Object(m.c)("modeFormTitle"),click:function(){n("form")}},text:{text:Object(m.c)("modeTextText"),title:Object(m.c)("modeTextTitle"),click:function(){n("text")}},tree:{text:Object(m.c)("modeTreeText"),title:Object(m.c)("modeTreeTitle"),click:function(){n("tree")}},view:{text:Object(m.c)("modeViewText"),title:Object(m.c)("modeViewTitle"),click:function(){n("view")}},preview:{text:Object(m.c)("modePreviewText"),title:Object(m.c)("modePreviewTitle"),click:function(){n("preview")}}},r=[],s=0;s<t.length;s++){var a=t[s],l=o[a];if(!l)throw new Error('Unknown mode "'+a+'"');l.className="jsoneditor-type-modes"+(i===a?" jsoneditor-selected":""),r.push(l)}var c=o[i];if(!c)throw new Error('Unknown mode "'+i+'"');var d=c.text,h=document.createElement("button");h.type="button",h.className="jsoneditor-modes jsoneditor-separator",h.innerHTML=d+" &#x25BE;",h.title=Object(m.c)("modeEditorTitle"),h.onclick=function(){new f.a(r).show(h,e)};var u=document.createElement("div");u.className="jsoneditor-modes",u.style.position="relative",u.appendChild(h),e.appendChild(u),this.dom={container:e,box:h,frame:u}}return function(e,t,i){t&&n(e.prototype,t),i&&n(e,i)}(p,[{key:"focus",value:function(){this.dom.box.focus()}},{key:"destroy",value:function(){this.dom&&this.dom.frame&&this.dom.frame.parentNode&&this.dom.frame.parentNode.removeChild(this.dom.frame),this.dom=null}}]),p}()},function(e,t,i
){"use strict";var n=i(4),T=i.n(n),o=i(12),r=i.n(o),s=i(8),S=i.n(s),a=i(1);function l(e){return(l="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function j(e,t,i){var n;"number"==typeof t?10<t?n=c(" ",10):1<=t&&(n=c(" ",t)):"string"==typeof t&&""!==t&&(n=t);var o=h(e,n,"",i);return o.length>i?function(e,t){return"number"==typeof t?e.slice(0,t):e}(o,i)+"...":o}function h(e,t,i,n){return"boolean"==typeof e||e instanceof Boolean||null===e||"number"==typeof e||e instanceof Number||"string"==typeof e||e instanceof String||e instanceof Date?JSON.stringify(e):Array.isArray(e)?function(e,t,i,n){for(var o=t?i+t:void 0,r=t?"[\n":"[",s=0;s<e.length;s++){var a=e[s];if(t&&(r+=o),r+=void 0!==a&&"function"!=typeof a?h(a,t,o,n):"null",s<e.length-1&&(r+=t?",\n":","),r.length>n)return r+"..."}return r+=t?"\n"+i+"]":"]"}(e,t,i,n):e&&"object"===l(e)?function(e,t,i,n){var o=t?i+t:void 0,r=!0,s=t?"{\n":"{";if("function"==typeof e.toJSON)return h(e.toJSON(),t,i,n);for(var a in e)if(c=e,d=a,Object.prototype.hasOwnProperty.call(c,d)){var l=e[a];if(r?r=!1:s+=t?",\n":",",s+=t?o+'"'+a+'": ':'"'+a+'":',(s+=h(l,t,o,n)).length>n)return s+"..."}var c,d;return s+=t?"\n"+i+"}":"}"}(e,t,i,n):void 0}function c(e,t){for(var i="";0<t--;)i+=e;return i}var N=i(0),k=i(2);function d(e,_,E){var w=_,t='<label class="pico-modal-contents"><div class="pico-modal-header">'+Object(a.c)("transform")+'</div><p>Enter a <a href="http://jmespath.org" target="_blank">JMESPath</a> query to filter, sort, or transform the JSON data.<br/>To learn JMESPath, go to <a href="http://jmespath.org/tutorial.html" target="_blank">the interactive tutorial</a>.</p><div class="jsoneditor-jmespath-label">'+Object(a.c)("transformWizardLabel")+' </div><div id="wizard" class="jsoneditor-jmespath-block jsoneditor-jmespath-wizard">  <table class="jsoneditor-jmespath-wizard-table">    <tbody>      <tr>        <th>'+Object(a.c)("transformWizardFilter")+'</th>        <td class="jsoneditor-jmespath-filter">          <div class="jsoneditor-inline jsoneditor-jmespath-filter-field" >            <select id="filterField">            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-filter-relation" >            <select id="filterRelation">              <option value="==">==</option>              <option value="!=">!=</option>              <option value="<">&lt;</option>              <option value="<=">&lt;=</option>              <option value=">">&gt;</option>              <option value=">=">&gt;=</option>            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-filter-value" >            <input placeholder="value..." id="filterValue" />          </div>        </td>      </tr>      <tr>        <th>'+Object(a.c)("transformWizardSortBy")+'</th>        <td class="jsoneditor-jmespath-filter">          <div class="jsoneditor-inline jsoneditor-jmespath-sort-field">            <select id="sortField">            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-sort-order" >            <select id="sortOrder">              <option value="asc">Ascending</option>              <option value="desc">Descending</option>            </select>          </div>        </td>      </tr>      <tr id="selectFieldsPart">        <th>'+Object(a.c)("transformWizardSelectFields")+'</th>        <td class="jsoneditor-jmespath-filter">          <select class="jsoneditor-jmespath-select-fields" id="selectFields" multiple></select>        </td>      </tr>    </tbody>  </table></div><div class="jsoneditor-jmespath-label">'+Object(a.c)("transformQueryLabel")+' </div><div class="jsoneditor-jmespath-block">  <textarea id="query"             rows="4"             autocomplete="off"             autocorrect="off"             autocapitalize="off"             spellcheck="false"            title="'+Object(a.c)("transformQueryTitle")+'">[*]</textarea></div><div class="jsoneditor-jmespath-label">'+Object(a.c)("transformPreviewLabel")+' </div><div class="jsoneditor-jmespath-block">  <textarea id="preview"       class="jsoneditor-transform-preview"      readonly> </textarea></div><div class="jsoneditor-jmespath-block jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+Object(a.c)("ok")+'" autofocus /></div></div>';r()({parent:e,content:t,overlayClass:"jsoneditor-modal-overlay",overlayStyles:{backgroundColor:"rgb(1,1,1)",opacity:.3},modalClass:"jsoneditor-modal jsoneditor-modal-transform",focus:!1}).afterCreate(function(t){var e=t.modalElem(),i=e.querySelector("#wizard"),n=e.querySelector("#ok"),a=e.querySelector("#filterField"),l=e.querySelector("#filterRelation"),c=e.querySelector("#filterValue"),d=e.querySelector("#sortField"),h=e.querySelector("#sortOrder"),u=e.querySelector("#selectFields"),p=e.querySelector("#query"),o=e.querySelector("#preview");Array.isArray(w)||(i.style.fontStyle="italic",i.innerHTML="(wizard not available for objects, only for arrays)"),Object(N.getChildPaths)(_).forEach(function(e){var t=b(e),i=document.createElement("option");i.text=t,i.value=t,a.appendChild(i);var n=document.createElement("option");n.text=t,n.value=t,d.appendChild(n)});var r=Object(N.getChildPaths)(_,!0).filter(function(e){return""!==e});if(0<r.length)r.forEach(function(e){var t=b(e),i=document.createElement("option");i.text=t,i.value=t,u.appendChild(i)});else{var s=e.querySelector("#selectFieldsPart");s&&(s.style.display="none")}var f=new S.a(a,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"field..."}),m=new S.a(l,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"compare..."}),v=new S.a(d,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"field..."}),g=new S.a(h,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"order..."}),y=new S.a(u,{multiple:!0,clearable:!0,defaultSelected:!1,placeholder:"select fields..."});function b(e){return""===e?"@":"."===e[0]?e.slice(1):e}function x(){if(a.value&&l.value&&c.value){var e=a.value,t="@"!==e?["0"].concat(Object(N.parsePath)("."+e)):["0"],i="string"==typeof Object(N.get)(w,t)?c.value:Object(N.parseString)(c.value);p.value="[? "+e+" "+l.value+" `"+JSON.stringify(i)+"`]"}else p.value="[*]";if(d.value&&h.value){var n=d.value;"desc"===h.value?p.value+=" | reverse(sort_by(@, &"+n+"))":p.value+=" | sort_by(@, &"+n+")"}if(u.value){for(var o=[],r=0;r<u.options.length;r++)if(u.options[r].selected){var s=u.options[r].value;o.push(s)}"]"!==p.value[p.value.length-1]&&(p.value+=" | [*]"),1===o.length?p.value+="."+o[0]:1<o.length&&(p.value+=".{"+o.map(function(e){var t=e.split(".");return t[t.length-1]+": "+e}).join(", ")+"}")}C()}f.on("selectr.change",x),m.on("selectr.change",x),c.oninput=x,v.on("selectr.change",x),g.on("selectr.change",x),y.on("selectr.change",x),e.querySelector(".pico-modal-contents").onclick=function(e){"A"!==e.target.nodeName&&e.preventDefault()},p.value=Array.isArray(w)?"[*]":"@";var C=Object(N.debounce)(function(){try{var e=T.a.search(w,p.value);o.className="jsoneditor-transform-preview",o.value=j(e,2,k.b),n.disabled=!1}catch(e){o.className="jsoneditor-transform-preview jsoneditor-error",o.value=e.toString(),n.disabled=!0}},300);(p.oninput=C)(),n.onclick=function(e){e.preventDefault(),e.stopPropagation(),t.close(),E(p.value)},setTimeout(function(){p.select(),p.focus(),p.selectionStart=3,p.selectionEnd=3})}).afterClose(function(e){e.destroy()}).show()}i.d(t,"a",function(){return d})},function(e,t,i){"use strict";function n(){}var o={defaultSelected:!0,width:"auto",disabled:!1,searchable:!0,clearable:!1,sortSelected:!1,allowDeselect:!1,closeOnScroll:!1,nativeDropdown:!1,placeholder:"Select an option...",taggable:!1,tagPlaceholder:"Enter a tag..."};n.prototype={on:function(e,t){this._events=this._events||{},this._events[e]=this._events[e]||[],this._events[e].push(t)},off:function(e,t){this._events=this._events||{},e in this._events!=!1&&this._events[e].splice(this._events[e].indexOf(t),1)},emit:function(e){if(this._events=this._events||{},e in this._events!=!1)for(var t=0;t<this._events[e].length;t++)this._events[e][t].apply(this,Array.prototype.slice.call(arguments,1))}},n.mixin=function(e){for(var t=["on","off","emit"],i=0;i<t.length;i++)"function"==typeof e?e.prototype[t[i]]=n.prototype[t[i]]:e[t[i]]=n.prototype[t[i]];return e};var l={extend:function(e,t){var i;for(i in t=t||{},e)e.hasOwnProperty(i)&&(t.hasOwnProperty(i)||(t[i]=e[i]));return t},each:function(e,t,i){if("[object Object]"===Object.prototype.toString.call(e))for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&t.call(i,n,e[n],e);else for(var o=0,r=e.length;o<r;o++)t.call(i,o,e[o],e)},createElement:function(e,t){var i,n=document,o=n.createElement(e);if(t&&"[object Object]"===Object.prototype.toString.call(t))for(i in t)if(i in o)o[i]=t[i];else if("html"===i)o.innerHTML=t[i];else if("text"===i){var r=n.createTextNode(t[i]);o.appendChild(r)}else o.setAttribute(i,t[i]);return o},hasClass:function(e,t){if(e)return e.classList?e.classList.contains(t):!!e.className&&!!e.className.match(new RegExp("(\\s|^)"+t+"(\\s|$)"))},addClass:function(e,t){l.hasClass(e,t)||(e.classList?e.classList.add(t):e.className=e.className.trim()+" "+t)},removeClass:function(e,t){l.hasClass(e,t)&&(e.classList?e.classList.remove(t):e.className=e.className.replace(new RegExp("(^|\\s)"+t.split(" ").join("|")+"(\\s|$)","gi")," "))},closest:function(e,t){return e&&e!==document.body&&(t(e)?e:l.closest(e.parentNode,t))},isInt:function(e){return"number"==typeof e&&isFinite(e)&&Math.floor(e)===e},debounce:function(n,o,r){var s;return function(){var e=this,t=arguments,i=r&&!s;clearTimeout(s),s=setTimeout(function(){s=null,r||n.apply(e,t)},o),i&&n.apply(e,t)}},rect:function(e,t){var i=window,n=e.getBoundingClientRect(),o=t?i.pageXOffset:0,r=t?i.pageYOffset:0;return{bottom:n.bottom+r,height:n.height,left:n.left+o,right:n.right+o,top:n.top+r,width:n.width}},includes:function(e,t){return-1<e.indexOf(t)},truncate:function(e){for(;e.firstChild;)e.removeChild(e.firstChild)}};function c(e,t){return e.hasOwnProperty(t)&&(!0===e[t]||e[t].length)}function r(e,t,i){e.parentNode?e.parentNode.parentNode||t.appendChild(e.parentNode):t.appendChild(e),l.removeClass(e,"excluded"),i||(e.innerHTML=e.textContent)}function s(){if(this.items.length){var i=document.createDocumentFragment();if(this.config.pagination){var e=this.pages.slice(0,this.pageIndex);l.each(e,function(e,t){l.each(t,function(e,t){r(t,i,this.customOption)},this)},this)}else l.each(this.items,function(e,t){r(t,i,this.customOption)},this);i.childElementCount&&(l.removeClass(this.items[this.navIndex],"active"),this.navIndex=i.querySelector(".selectr-option").idx,l.addClass(this.items[this.navIndex],"active")),this.tree.appendChild(i)}}function d(e,t){t=t||e;var i=this.customOption?this.config.renderOption(t):e.textContent,n=l.createElement("li",{class:"selectr-option",html:i,role:"treeitem","aria-selected":!1});return n.idx=e.idx,this.items.push(n),e.defaultSelected&&this.defaultSelected.push(e.idx),e.disabled&&(n.disabled=!0,l.addClass(n,"disabled")),n}function a(){(this.config.searchable||this.config.taggable)&&(this.input.value=null,this.searching=!1,this.config.searchable&&l.removeClass(this.inputContainer,"active"),l.hasClass(this.container,"notice")&&(l.removeClass(this.container,"notice"),l.addClass(this.container,"open"),this.input.focus()),l.each(this.items,function(e,t){l.removeClass(t,"excluded"),this.customOption||(t.innerHTML=t.textContent)},this))}function h(e,t){if(t=t||{},!e)throw new Error("You must supply either a HTMLSelectElement or a CSS3 selector string.");if("string"==typeof(this.el=e)&&(this.el=document.querySelector(e)),null===this.el)throw new Error("The element you passed to Selectr can not be found.");if("select"!==this.el.nodeName.toLowerCase())throw new Error("The element you passed to Selectr is not a HTMLSelectElement.");this.render(t)}var u=function(){var e=this.tree,t=e.scrollTop;if(e.scrollHeight-e.offsetHeight<=t&&this.pageIndex<this.pages.length){var i=document.createDocumentFragment();l.each(this.pages[this.pageIndex],function(e,t){r(t,i,this.customOption)},this),e.appendChild(i),this.pageIndex++,this.emit("selectr.paginate",{items:this.items.length,total:this.data.length,page:this.pageIndex,pages:this.pages.length})}};h.prototype.render=function(e){if(!this.rendered){this.config=l.extend(o,e),this.originalType=this.el.type,this.originalIndex=this.el.tabIndex,this.defaultSelected=[],this.originalOptionCount=this.el.options.length,(this.config.multiple||this.config.taggable)&&(this.el.multiple=!0),this.disabled=c(this.config,"disabled"),this.opened=!1,this.config.taggable&&(this.config.searchable=!1),this.navigating=!1,this.mobileDevice=!1,/Android|webOS|iPhone|iPad|BlackBerry|Windows Phone|Opera Mini|IEMobile|Mobile/i.test(navigator.userAgent)&&(this.mobileDevice=!0),this.customOption=this.config.hasOwnProperty("renderOption")&&"function"==typeof this.config.renderOption,this.customSelected=this.config.hasOwnProperty("renderSelection")&&"function"==typeof this.config.renderSelection,n.mixin(this),function(){this.requiresPagination=this.config.pagination&&0<this.config.pagination,c(this.config,"width")&&(l.isInt(this.config.width)?this.width=this.config.width+"px":"auto"===this.config.width?this.width="100%":l.includes(this.config.width,"%")&&(this.width=this.config.width)),this.container=l.createElement("div",{class:"selectr-container"}),this.config.customClass&&l.addClass(this.container,this.config.customClass),this.mobileDevice?l.addClass(this.container,"selectr-mobile"):l.addClass(this.container,"selectr-desktop"),this.el.tabIndex=-1,this.config.nativeDropdown||this.mobileDevice?l.addClass(this.el,"selectr-visible"):l.addClass(this.el,"selectr-hidden"),this.selected=l.createElement("div",{class:"selectr-selected",disabled:this.disabled,tabIndex:1,"aria-expanded":!1}),this.label=l.createElement(this.el.multiple?"ul":"span",{class:"selectr-label"});var e=l.createElement("div",{class:"selectr-options-container"});if(this.tree=l.createElement("ul",{class:"selectr-options",role:"tree","aria-hidden":!0,"aria-expanded":!1}),this.notice=l.createElement("div",{class:"selectr-notice"}),this.el.setAttribute("aria-hidden",!0),this.disabled&&(this.el.disabled=!0),this.el.multiple&&(l.addClass(this.label,"selectr-tags"),l.addClass(this.container,"multiple"),this.tags=[],this.selectedValues=this.getSelectedProperties("value"),this.selectedIndexes=this.getSelectedProperties("idx")),this.selected.appendChild(this.label),this.config.clearable&&(this.selectClear=l.createElement("button",{class:"selectr-clear",type:"button"}),this.container.appendChild(this.selectClear),l.addClass(this.container,"clearable")),this.config.taggable){var t=l.createElement("li",{class:"input-tag"});this.input=l.createElement("input",{class:"selectr-tag-input",placeholder:this.config.tagPlaceholder,tagIndex:0,autocomplete:"off",autocorrect:"off",autocapitalize:"off",spellcheck:"false",role:"textbox",type:"search"}),t.appendChild(this.input),this.label.appendChild(t),l.addClass(this.container,"taggable"),this.tagSeperators=[","],this.config.tagSeperators&&(this.tagSeperators=this.tagSeperators.concat(this.config.tagSeperators))}this.config.searchable&&(this.input=l.createElement("input",{class:"selectr-input",tagIndex:-1,autocomplete:"off",autocorrect:"off",autocapitalize:"off",spellcheck:"false",role:"textbox",type:"search"}),this.inputClear=l.createElement("button",{class:"selectr-input-clear",type:"button"}),this.inputContainer=l.createElement("div",{class:"selectr-input-container"}),this.inputContainer.appendChild(this.input),this.inputContainer.appendChild(this.inputClear),e.appendChild(this.inputContainer)),e.appendChild(this.notice),e.appendChild(this.tree),this.items=[],this.options=[],this.el.options.length&&(this.options=[].slice.call(this.el.options));var i,n=!1,o=0;if(this.el.children.length&&l.each(this.el.children,function(e,t){"OPTGROUP"===t.nodeName?(n=l.createElement("ul",{class:"selectr-optgroup",role:"group",html:"<li class='selectr-optgroup--label'>"+t.label+"</li>"}),l.each(t.children,function(e,t){t.idx=o,n.appendChild(d.call(this,t,n)),o++},this)):(t.idx=o,d.call(this,t),o++)},this),this.config.data&&Array.isArray(this.config.data)){var r,s=!(this.data=[]);n=!1,o=0,l.each(this.config.data,function(e,t){c(t,"children")?(s=l.createElement("optgroup",{label:t.text}),n=l.createElement("ul",{class:"selectr-optgroup",role:"group",html:"<li class='selectr-optgroup--label'>"+t.text+"</li>"}),l.each(t.children,function(e,t){(r=new Option(t.text,t.value,!1,t.hasOwnProperty("selected")&&!0===t.selected)).disabled=c(t,"disabled"),this.options.push(r),s.appendChild(r),r.idx=o,n.appendChild(d.call(this,r,t)),this.data[o]=t,o++},this)):((r=new Option(t.text,t.value,!1,t.hasOwnProperty("selected")&&!0===t.selected)).disabled=c(t,"disabled"),this.options.push(r),r.idx=o,d.call(this,r,t),this.data[o]=t,o++)},this)}this.setSelected(!0);for(var a=this.navIndex=0;a<this.items.length;a++)if(i=this.items[a],!l.hasClass(i,"disabled")){l.addClass(i,"active"),this.navIndex=a;break}this.requiresPagination&&(this.pageIndex=1,this.paginate()),this.container.appendChild(this.selected),this.container.appendChild(e),this.placeEl=l.createElement("div",{class:"selectr-placeholder"}),this.setPlaceholder(),this.selected.appendChild(this.placeEl),this.disabled&&this.disable(),this.el.parentNode.insertBefore(this.container,this.el),this.container.appendChild(this.el)}.call(this),this.bindEvents(),this.update(),this.optsRect=l.rect(this.tree),this.rendered=!0,this.el.multiple||(this.el.selectedIndex=this.selectedIndex);var t=this;setTimeout(function(){t.emit("selectr.init")},20)}},h.prototype.getSelected=function(){return this.el.querySelectorAll("option:checked")},h.prototype.getSelectedProperties=function(t){var e=this.getSelected();return[].slice.call(e).map(function(e){return e[t]}).filter(function(e){return null!=e})},h.prototype.bindEvents=function(){var n=this;if(this.events={},this.events.dismiss=function(e){var t=e.target;this.container.contains(t)||!this.opened&&!l.hasClass(this.container,"notice")||this.close()}.bind(this),this.events.navigate=function(e){if(e=e||window.event,this.items.length&&this.opened&&l.includes([13,38,40],e.which)){if(e.preventDefault(),13===e.which)return!(this.config.taggable&&0<this.input.value.length)&&this.change(this.navIndex);var t,i=this.items[this.navIndex];switch(e.which){case 38:(t=0)<this.navIndex&&this.navIndex--;break;case 40:t=1,this.navIndex<this.items.length-1&&this.navIndex++}for(this.navigating=!0;l.hasClass(this.items[this.navIndex],"disabled")||l.hasClass(this.items[this.navIndex],"excluded");)if(t?this.navIndex++:this.navIndex--,this.searching){if(this.navIndex>this.tree.lastElementChild.idx){this.navIndex=this.tree.lastElementChild.idx;break}if(this.navIndex<this.tree.firstElementChild.idx){this.navIndex=this.tree.firstElementChild.idx;break}}var n=l.rect(this.items[this.navIndex]);t?(0===this.navIndex?this.tree.scrollTop=0:n.top+n.height>this.optsRect.top+this.optsRect.height&&(this.tree.scrollTop=this.tree.scrollTop+(n.top+n.height-(this.optsRect.top+this.optsRect.height))),this.navIndex===this.tree.childElementCount-1&&this.requiresPagination&&u.call(this)):0===this.navIndex?this.tree.scrollTop=0:n.top-this.optsRect.top<0&&(this.tree.scrollTop=this.tree.scrollTop+(n.top-this.optsRect.top)),i&&l.removeClass(i,"active"),l.addClass(this.items[this.navIndex],"active")}else this.navigating=!1}.bind(this),this.events.reset=this.reset.bind(this),this.config.nativeDropdown||this.mobileDevice){this.container.addEventListener("touchstart",function(e){e.changedTouches[0].target===n.el&&n.toggle()}),(this.config.nativeDropdown||this.mobileDevice)&&this.container.addEventListener("click",function(e){e.preventDefault(),e.stopPropagation(),e.target===n.el&&n.toggle()});this.el.addEventListener("change",function(e){if(n.el.multiple){var t=n.getSelectedProperties("idx"),i=function(e,t){for(var i,n=[],o=e.slice(0),r=0;r<t.length;r++)-1<(i=o.indexOf(t[r]))?o.splice(i,1):n.push(t[r]);return[n,o]}(n.selectedIndexes,t);l.each(i[0],function(e,t){n.select(t)},n),l.each(i[1],function(e,t){n.deselect(t)},n)}else-1<n.el.selectedIndex&&n.select(n.el.selectedIndex)})}this.config.nativeDropdown&&this.container.addEventListener("keydown",function(e){"Enter"===e.key&&n.selected===document.activeElement&&(n.toggle(),setTimeout(function(){n.el.focus()},200))}),this.selected.addEventListener("click",function(e){n.disabled||n.toggle(),e.preventDefault(),e.stopPropagation()}),this.label.addEventListener("click",function(e){l.hasClass(e.target,"selectr-tag-remove")&&n.deselect(e.target.parentNode.idx)}),this.selectClear&&this.selectClear.addEventListener("click",this.clear.bind(this)),this.tree.addEventListener("mousedown",function(e){e.preventDefault()}),this.tree.addEventListener("click",function(e){e.preventDefault(),e.stopPropagation();var t=l.closest(e.target,function(e){return e&&l.hasClass(e,"selectr-option")});t&&(l.hasClass(t,"disabled")||(l.hasClass(t,"selected")?(n.el.multiple||!n.el.multiple&&n.config.allowDeselect)&&n.deselect(t.idx):n.select(t.idx),n.opened&&!n.el.multiple&&n.close()))}),this.tree.addEventListener("mouseover",function(e){l.hasClass(e.target,"selectr-option")&&(l.hasClass(e.target,"disabled")||(l.removeClass(n.items[n.navIndex],"active"),l.addClass(e.target,"active"),n.navIndex=[].slice.call(n.items).indexOf(e.target)))}),this.config.searchable&&(this.input.addEventListener("focus",function(e){n.searching=!0}),this.input.addEventListener("blur",function(e){n.searching=!1}),this.input.addEventListener("keyup",function(e){n.search(),n.config.taggable||(this.value.length?l.addClass(this.parentNode,"active"):l.removeClass(this.parentNode,"active"))}),this.inputClear.addEventListener("click",function(e){n.input.value=null,a.call(n),n.tree.childElementCount||s.call(n)})),this.config.taggable&&this.input.addEventListener("keyup",function(e){if(n.search(),n.config.taggable&&this.value.length){var i=this.value.trim();if(13===e.which||l.includes(n.tagSeperators,e.key))l.each(n.tagSeperators,function(e,t){i=i.replace(t,"")}),n.add({value:i,text:i,selected:!0},!0)?(n.close(),a.call(n)):(this.value="",n.setMessage("That tag is already in use."))}}),this.update=l.debounce(function(){n.opened&&n.config.closeOnScroll&&n.close(),n.width&&(n.container.style.width=n.width),n.invert()},50),this.requiresPagination&&(this.paginateItems=l.debounce(function(){u.call(this)},50),this.tree.addEventListener("scroll",this.paginateItems.bind(this))),document.addEventListener("click",this.events.dismiss),window.addEventListener("keydown",this.events.navigate),window.addEventListener("resize",this.update),window.addEventListener("scroll",this.update),this.el.form&&this.el.form.addEventListener("reset",this.events.reset)},h.prototype.setSelected=function(e){if(this.config.data||this.el.multiple||!this.el.options.length||(0===this.el.selectedIndex&&(this.el.options[0].defaultSelected||this.config.defaultSelected||(this.el.selectedIndex=-1)),this.selectedIndex=this.el.selectedIndex,-1<this.selectedIndex&&this.select(this.selectedIndex)),this.config.multiple&&"select-one"===this.originalType&&!this.config.data&&this.el.options[0].selected&&!this.el.options[0].defaultSelected&&(this.el.options[0].selected=!1),l.each(this.options,function(e,t){t.selected&&t.defaultSelected&&this.select(t.idx)},this),this.config.selectedValue&&this.setValue(this.config.selectedValue),this.config.data){!this.el.multiple&&this.config.defaultSelected&&this.el.selectedIndex<0&&this.select(0);var i=0;l.each(this.config.data,function(e,t){c(t,"children")?l.each(t.children,function(e,t){t.hasOwnProperty("selected")&&!0===t.selected&&this.select(i),i++},this):(t.hasOwnProperty("selected")&&!0===t.selected&&this.select(i),i++)},this)}},h.prototype.destroy=function(){this.rendered&&(this.emit("selectr.destroy"),"select-one"===this.originalType&&(this.el.multiple=!1),this.config.data&&(this.el.innerHTML=""),l.removeClass(this.el,"selectr-hidden"),this.el.form&&l.off(this.el.form,"reset",this.events.reset),l.off(document,"click",this.events.dismiss),l.off(document,"keydown",this.events.navigate),l.off(window,"resize",this.update),l.off(window,"scroll",this.update),this.container.parentNode.replaceChild(this.el,this.container),this.rendered=!1)},h.prototype.change=function(e){var t=this.items[e],i=this.options[e];i.disabled||(i.selected&&l.hasClass(t,"selected")?this.deselect(e):this.select(e),this.opened&&!this.el.multiple&&this.close())},h.prototype.select=function(n){var e=this.items[n],t=[].slice.call(this.el.options),i=this.options[n];if(this.el.multiple){if(l.includes(this.selectedIndexes,n))return!1;if(this.config.maxSelections&&this.tags.length===this.config.maxSelections)return this.setMessage("A maximum of "+this.config.maxSelections+" items can be selected.",!0),!1;this.selectedValues.push(i.value),this.selectedIndexes.push(n),function(e){var c,d=this,i=document.createDocumentFragment(),t=this.options[e.idx],n=this.data?this.data[e.idx]:t,o=this.customSelected?this.config.renderSelection(n):t.textContent,r=l.createElement("li",{class:"selectr-tag",html:o}),s=l.createElement("button",{class:"selectr-tag-remove",type:"button"});if(r.appendChild(s),r.idx=e.idx,r.tag=t.value,this.tags.push(r),this.config.sortSelected){var a=this.tags.slice();c=function(e,n){e.replace(/(\d+)|(\D+)/g,function(e,t,i){n.push([t||1/0,i||""])})},a.sort(function(e,t){var i,n,o=[],r=[];for(!0===d.config.sortSelected?(i=e.tag,n=t.tag):"text"===d.config.sortSelected&&(i=e.textContent,n=t.textContent),c(i,o),c(n,r);o.length&&r.length;){var s=o.shift(),a=r.shift(),l=s[0]-a[0]||s[1].localeCompare(a[1]);if(l)return l}return o.length-r.length}),l.each(a,function(e,t){i.appendChild(t)}),this.label.innerHTML=""}else i.appendChild(r);this.config.taggable?this.label.insertBefore(i,this.input.parentNode):this.label.appendChild(i)}.call(this,e)}else{var o=this.data?this.data[n]:i;this.label.innerHTML=this.customSelected?this.config.renderSelection(o):i.textContent,this.selectedValue=i.value,this.selectedIndex=n,l.each(this.options,function(e,t){var i=this.items[e];e!==n&&(i&&l.removeClass(i,"selected"),t.selected=!1,t.removeAttribute("selected"))},this)}l.includes(t,i)||this.el.add(i),e.setAttribute("aria-selected",!0),l.addClass(e,"selected"),l.addClass(this.container,"has-selected"),i.selected=!0,i.setAttribute("selected",""),this.emit("selectr.change",i),this.emit("selectr.select",i)},h.prototype.deselect=function(e,t){var i=this.items[e],n=this.options[e];if(this.el.multiple){var o=this.selectedIndexes.indexOf(e);this.selectedIndexes.splice(o,1);var r=this.selectedValues.indexOf(n.value);this.selectedValues.splice(r,1),function(i){var n=!1;l.each(this.tags,function(e,t){t.idx===i.idx&&(n=t)},this),n&&(this.label.removeChild(n),this.tags.splice(this.tags.indexOf(n),1))}.call(this,i),this.tags.length||l.removeClass(this.container,"has-selected")}else{if(!t&&!this.config.clearable&&!this.config.allowDeselect)return!1;this.label.innerHTML="",this.selectedValue=null,this.el.selectedIndex=this.selectedIndex=-1,l.removeClass(this.container,"has-selected")}this.items[e].setAttribute("aria-selected",!1),l.removeClass(this.items[e],"selected"),n.selected=!1,n.removeAttribute("selected"),this.emit("selectr.change",null),this.emit("selectr.deselect",n)},h.prototype.setValue=function(i){var n=Array.isArray(i);if(n||(i=i.toString().trim()),!this.el.multiple&&n)return!1;l.each(this.options,function(e,t){(n&&l.includes(i.toString(),t.value)||t.value===i)&&this.change(t.idx)},this)},h.prototype.getValue=function(e,t){var n;if(this.el.multiple)e?this.selectedIndexes.length&&(n={values:[]},l.each(this.selectedIndexes,function(e,t){var i=this.options[t];n.values[e]={value:i.value,text:i.textContent}},this)):n=this.selectedValues.slice();else if(e){var i=this.options[this.selectedIndex];n={value:i.value,text:i.textContent}}else n=this.selectedValue;return e&&t&&(n=JSON.stringify(n)),n},h.prototype.add=function(i,n){if(i){if(this.data=this.data||[],this.items=this.items||[],this.options=this.options||[],Array.isArray(i))l.each(i,function(e,t){this.add(t,n)},this);else if("[object Object]"===Object.prototype.toString.call(i)){if(n){var o=!1;if(l.each(this.options,function(e,t){t.value.toLowerCase()===i.value.toLowerCase()&&(o=!0)}),o)return!1}var e=l.createElement("option",i);return this.data.push(i),this.options.push(e),e.idx=0<this.options.length?this.options.length-1:0,d.call(this,e),i.selected&&this.select(e.idx),e}return this.setPlaceholder(),this.config.pagination&&this.paginate(),!0}},h.prototype.remove=function(i){var n,o=[];Array.isArray(i)?l.each(i,function(e,t){l.isInt(t)?o.push(this.getOptionByIndex(t)):"string"==typeof i&&o.push(this.getOptionByValue(t))},this):l.isInt(i)?o.push(this.getOptionByIndex(i)):"string"==typeof i&&o.push(this.getOptionByValue(i)),o.length&&(l.each(o,function(e,t){n=t.idx,this.el.remove(t),this.options.splice(n,1);var i=this.items[n].parentNode;i&&i.removeChild(this.items[n]),this.items.splice(n,1),l.each(this.options,function(e,t){t.idx=e,this.items[e].idx=e},this)},this),this.setPlaceholder(),this.config.pagination&&this.paginate())},h.prototype.removeAll=function(){this.clear(!0),l.each(this.el.options,function(e,t){this.el.remove(t)},this),l.truncate(this.tree),this.items=[],this.options=[],this.data=[],this.navIndex=0,this.requiresPagination&&(this.requiresPagination=!1,this.pageIndex=1,this.pages=[]),this.setPlaceholder()},h.prototype.search=function(n){if(!this.navigating){n=n||this.input.value;var o=document.createDocumentFragment();if(this.removeMessage(),l.truncate(this.tree),1<n.length)if(l.each(this.options,function(e,t){var i=this.items[t.idx];l.includes(t.textContent.toLowerCase(),n.toLowerCase())&&!t.disabled?(r(i,o,this.customOption),l.removeClass(i,"excluded"),this.customOption||(i.innerHTML=function(e,t){var i=new RegExp(e,"i").exec(t.textContent);return!!i&&t.textContent.replace(i[0],"<span class='selectr-match'>"+i[0]+"</span>")}(n,t))):l.addClass(i,"excluded")},this),o.childElementCount){var e=this.items[this.navIndex],t=o.firstElementChild;l.removeClass(e,"active"),this.navIndex=t.idx,l.addClass(t,"active")}else this.config.taggable||this.setMessage("no results.");else s.call(this);this.tree.appendChild(o)}},h.prototype.toggle=function(){this.disabled||(this.opened?this.close():this.open())},h.prototype.open=function(){var e=this;return!!this.options.length&&(this.opened||this.emit("selectr.open"),this.opened=!0,this.mobileDevice||this.config.nativeDropdown?(l.addClass(this.container,"native-open"),void(this.config.data&&l.each(this.options,function(e,t){this.el.add(t)},this))):(l.addClass(this.container,"open"),s.call(this),this.invert(),this.tree.scrollTop=0,l.removeClass(this.container,"notice"),this.selected.setAttribute("aria-expanded",!0),this.tree.setAttribute("aria-hidden",!1),this.tree.setAttribute("aria-expanded",!0),void(this.config.searchable&&!this.config.taggable&&setTimeout(function(){e.input.focus(),e.input.tabIndex=0},10))))},h.prototype.close=function(){if(this.opened&&this.emit("selectr.close"),this.opened=!1,this.mobileDevice||this.config.nativeDropdown)l.removeClass(this.container,"native-open");else{var e=l.hasClass(this.container,"notice");this.config.searchable&&!e&&(this.input.blur(),this.input.tabIndex=-1,this.searching=!1),e&&(l.removeClass(this.container,"notice"),this.notice.textContent=""),l.removeClass(this.container,"open"),l.removeClass(this.container,"native-open"),this.selected.setAttribute("aria-expanded",!1),this.tree.setAttribute("aria-hidden",!0),this.tree.setAttribute("aria-expanded",!1),l.truncate(this.tree),a.call(this)}},h.prototype.enable=function(){this.disabled=!1,this.el.disabled=!1,this.selected.tabIndex=this.originalIndex,this.el.multiple&&l.each(this.tags,function(e,t){t.lastElementChild.tabIndex=0}),l.removeClass(this.container,"selectr-disabled")},h.prototype.disable=function(e){e||(this.el.disabled=!0),this.selected.tabIndex=-1,this.el.multiple&&l.each(this.tags,function(e,t){t.lastElementChild.tabIndex=-1}),this.disabled=!0,l.addClass(this.container,"selectr-disabled")},h.prototype.reset=function(){this.disabled||(this.clear(),this.setSelected(!0),l.each(this.defaultSelected,function(e,t){this.select(t)},this),this.emit("selectr.reset"))},h.prototype.clear=function(e){if(this.el.multiple){if(this.selectedIndexes.length){var t=this.selectedIndexes.slice();l.each(t,function(e,t){this.deselect(t)},this)}}else-1<this.selectedIndex&&this.deselect(this.selectedIndex,e);this.emit("selectr.clear")},h.prototype.serialise=function(e){var n=[];return l.each(this.options,function(e,t){var i={value:t.value,text:t.textContent};t.selected&&(i.selected=!0),t.disabled&&(i.disabled=!0),n[e]=i}),e?JSON.stringify(n):n},h.prototype.serialize=function(e){return this.serialise(e)},h.prototype.setPlaceholder=function(e){e=e||this.config.placeholder||this.el.getAttribute("placeholder"),this.options.length||(e="No options available"),this.placeEl.innerHTML=e},h.prototype.paginate=function(){if(this.items.length){var i=this;return this.pages=this.items.map(function(e,t){return t%i.config.pagination==0?i.items.slice(t,t+i.config.pagination):null}).filter(function(e){return e}),this.pages}},h.prototype.setMessage=function(e,t){t&&this.close(),l.addClass(this.container,"notice"),this.notice.textContent=e},h.prototype.removeMessage=function(){l.removeClass(this.container,"notice"),this.notice.innerHTML=""},h.prototype.invert=function(){var e=l.rect(this.selected),t=this.tree.parentNode.offsetHeight,i=window.innerHeight;e.top+e.height+t>i?(l.addClass(this.container,"inverted"),this.isInverted=!0):(l.removeClass(this.container,"inverted"),this.isInverted=!1),this.optsRect=l.rect(this.tree)},h.prototype.getOptionByIndex=function(e){return this.options[e]},h.prototype.getOptionByValue=function(e){for(var t=!1,i=0,n=this.options.length;i<n;i++)if(this.options[i].value.trim()===e.toString().trim()){t=this.options[i];break}return t},e.exports=h},function(e,t){e.exports=function t(e,i){"use strict";function n(e){return t.insensitive&&(""+e).toLowerCase()||""+e}var o,r,s=/(^([+\-]?(?:0|[1-9]\d*)(?:\.\d*)?(?:[eE][+\-]?\d+)?)?$|^0x[0-9a-f]+$|\d+)/gi,a=/(^[ ]*|[ ]*$)/g,l=/(^([\w ]+,?[\w ]+)?[\w ]+,?[\w ]+\d+:\d+(:\d+)?[\w ]?|^\d{1,4}[\/\-]\d{1,4}[\/\-]\d{1,4}|^\w+, \w+ \d+, \d{4})/,c=/^0x[0-9a-f]+$/i,d=/^0/,h=n(e).replace(a,"")||"",u=n(i).replace(a,"")||"",p=h.replace(s,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),f=u.replace(s,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),m=parseInt(h.match(c),16)||1!==p.length&&h.match(l)&&Date.parse(h),v=parseInt(u.match(c),16)||m&&u.match(l)&&Date.parse(u)||null;if(v){if(m<v)return-1;if(v<m)return 1}for(var g=0,y=Math.max(p.length,f.length);g<y;g++){if(o=!(p[g]||"").match(d)&&parseFloat(p[g])||p[g]||0,r=!(f[g]||"").match(d)&&parseFloat(f[g])||f[g]||0,isNaN(o)!==isNaN(r))return isNaN(o)?1:-1;if(typeof o!=typeof r&&(o+="",r+=""),o<r)return-1;if(r<o)return 1}return 0}},function(e,t,i){"use strict";i.d(t,"a",function(){return n});var u=i(0);function n(o,e,r){var t=3<arguments.length&&void 0!==arguments[3]&&arguments[3],s=function(e){return"function"==typeof e.getRootNode?e.getRootNode():window}(o),a={},i=o.getBoundingClientRect(),n=e.getBoundingClientRect(),l=document.createElement("div");function c(){if(l&&l.parentNode){for(var e in l.parentNode.removeChild(l),a)if(i=a,n=e,Object.prototype.hasOwnProperty.call(i,n)){var t=a[e];t&&Object(u.removeEventListener)(s,e,t),delete a[e]}"function"==typeof r&&r(o)}var i,n}function d(e){!function(e){return e!==l&&!Object(u.isChildOf)(e,l)}(e.target)||c()}if(l.className="jsoneditor-anchor",l.style.position="absolute",l.style.left=i.left-n.left+"px",l.style.top=i.top-n.top+"px",l.style.width=i.width-2+"px",l.style.height=i.height-2+"px",l.style.boxSizing="border-box",e.appendChild(l),a.mousedown=Object(u.addEventListener)(s,"mousedown",d),a.mousewheel=Object(u.addEventListener)(s,"mousewheel",d),t){var h=null;l.onmouseover=function(){clearTimeout(h),h=null},l.onmouseout=function(){h=h||setTimeout(c,200)}}return l.destroy=c,l}},function(e,t,i){var n;if(window.Picker)n=window.Picker;else try{n=i(!function(){var e=new Error("Cannot find module 'vanilla-picker'");throw e.code="MODULE_NOT_FOUND",e}())}catch(e){}e.exports=n},function(e,t,i){var n,o,r;!function(){"use strict";o=[],void 0===(r="function"==typeof(n=function(){"use strict";function v(e){if(typeof Node==="object"){return e instanceof Node}else{return e&&typeof e==="object"&&typeof e.nodeType==="number"}}function e(e){return"string"==typeof e}function g(){var r=[];return{watch:r.push.bind(r),trigger:function(e,t){var i=true;var n={detail:t,preventDefault:function e(){i=false}};for(var o=0;o<r.length;o++){r[o](e,n)}return i}}}function y(e){return window.getComputedStyle(e).display==="none"}function b(e){this.elem=e}function t(e,t){return b.make(e("parent")).clazz("pico-overlay").clazz(e("overlayClass","")).stylize({display:"none",position:"fixed",top:"0px",left:"0px",height:"100%",width:"100%",zIndex:1e4}).stylize(e("overlayStyles",{opacity:.5,background:"#000"})).onClick(function(){e("overlayClose",!0)&&t()})}b.make=function(e,t){if(typeof e==="string"){e=document.querySelector(e)}var i=document.createElement(t||"div");(e||document.body).appendChild(i);return new b(i)},b.prototype={child:function(e){return b.make(this.elem,e)},stylize:function(e){e=e||{};if(typeof e.opacity!=="undefined"){e.filter="alpha(opacity="+e.opacity*100+")"}for(var t in e){if(e.hasOwnProperty(t)){this.elem.style[t]=e[t]}}return this},clazz:function(e){this.elem.className+=" "+e;return this},html:function(e){if(v(e)){this.elem.appendChild(e)}else{this.elem.innerHTML=e}return this},onClick:function(e){this.elem.addEventListener("click",e);return this},destroy:function(){this.elem.parentNode.removeChild(this.elem)},hide:function(){this.elem.style.display="none"},show:function(){this.elem.style.display="block"},attr:function(e,t){if(t!==undefined){this.elem.setAttribute(e,t)}return this},anyAncestor:function(e){var t=this.elem;while(t){if(e(new b(t))){return true}else{t=t.parentNode}}return false},isVisible:function(){return!y(this.elem)}};var x=1;function i(e,t){var i=e("width","auto");if("number"==typeof i)i+="px";var n=e("modalId","pico-"+x++);return b.make(e("parent")).clazz("pico-content").clazz(e("modalClass","")).stylize({display:"none",position:"fixed",zIndex:10001,left:"50%",top:"38.1966%",maxHeight:"90%",boxSizing:"border-box",width:i,"-ms-transform":"translate(-50%,-38.1966%)","-moz-transform":"translate(-50%,-38.1966%)","-webkit-transform":"translate(-50%,-38.1966%)","-o-transform":"translate(-50%,-38.1966%)",transform:"translate(-50%,-38.1966%)"}).stylize(e("modalStyles",{overflow:"auto",backgroundColor:"white",padding:"20px",borderRadius:"5px"})).html(e("content")).attr("id",n).attr("role","dialog").attr("aria-labelledby",e("ariaLabelledBy")).attr("aria-describedby",e("ariaDescribedBy",n)).onClick(function(e){new b(e.target).anyAncestor(function(e){return/\bpico-close\b/.test(e.elem.className)})&&t()})}function n(e,t){if(t("closeButton",!0))return e.child("button").html(t("closeHtml","&#xD7;")).clazz("pico-close").clazz(t("closeClass","")).stylize(t("closeStyles",{borderRadius:"2px",border:0,padding:0,cursor:"pointer",height:"15px",width:"15px",position:"absolute",top:"5px",right:"5px",fontSize:"16px",textAlign:"center",lineHeight:"15px",background:"#CCC"})).attr("aria-label",t("close-label","Close"))}function C(e){return function(){return e().elem}}var _=g(),E=g();function o(n,o){function t(e,t){return(e.msMatchesSelector||e.webkitMatchesSelector||e.matches).call(e,t)}function r(e){return!(y(e)||t(e,":disabled")||e.hasAttribute("contenteditable"))&&(e.hasAttribute("tabindex")||t(e,"input,select,textarea,button,a[href],area[href],iframe"))}function s(e){for(var t=e.getElementsByTagName("*"),i=0;i<t.length;i++)if(r(t[i]))return t[i]}function r(e){for(var t=e.getElementsByTagName("*"),i=t.length;i--;)if(r(t[i]))return t[i]}var e;n.beforeShow(function(){e=document.activeElement}),n.afterShow(function(){if(o()){var e=s(n.modalElem());e&&e.focus()}}),n.afterClose(function(){o()&&e&&e.focus(),e=null}),E.watch(function(e){if(o()&&n.isVisible()){var t=s(n.modalElem()),i=function(e){for(var t=e.getElementsByTagName("*"),i=t.length;i--;)if(r(t[i]))return t[i]}(n.modalElem());(e.shiftKey?t:i)===document.activeElement&&((e.shiftKey?i:t).focus(),e.preventDefault())}})}function r(e,t){var i,n=new b(document.body);e.beforeShow(function(){i=n.elem.style.overflow,t()&&n.stylize({overflow:"hidden"})}),e.afterClose(function(){n.stylize({overflow:i})})}return document.documentElement.addEventListener("keydown",function(e){var t=e.which||e.keyCode;27===t?_.trigger():9===t&&E.trigger(e)}),function(n){(function(e){return"string"==typeof e}(n)||v(n))&&(n={content:n});var o=g(),t=g(),i=g(),r=g(),s=g();function a(e,t){var i=n[e];return"function"==typeof i&&(i=i(t)),void 0===i?t:i}var l,c,d=m.bind(window,"modal"),h=m.bind(window,"overlay"),u=m.bind(window,"close");function p(e){h().hide(),d().hide(),s.trigger(l,e)}function f(e){r.trigger(l,e)&&p(e)}function e(e){return function(){return e.apply(this,arguments),l}}function m(e,t){if(!c){var i=function(e,t){var i=e("width","auto");"number"==typeof i&&(i+="px");var n=e("modalId","pico-"+x++);return b.make(e("parent")).clazz("pico-content").clazz(e("modalClass","")).stylize({display:"none",position:"fixed",zIndex:10001,left:"50%",top:"38.1966%",maxHeight:"90%",boxSizing:"border-box",width:i,"-ms-transform":"translate(-50%,-38.1966%)","-moz-transform":"translate(-50%,-38.1966%)","-webkit-transform":"translate(-50%,-38.1966%)","-o-transform":"translate(-50%,-38.1966%)",transform:"translate(-50%,-38.1966%)"}).stylize(e("modalStyles",{overflow:"auto",backgroundColor:"white",padding:"20px",borderRadius:"5px"})).html(e("content")).attr("id",n).attr("role","dialog").attr("aria-labelledby",e("ariaLabelledBy")).attr("aria-describedby",e("ariaDescribedBy",n)).onClick(function(e){new b(e.target).anyAncestor(function(e){return/\bpico-close\b/.test(e.elem.className)})&&t()})}(a,f);c={modal:i,overlay:function(e,t){return b.make(e("parent")).clazz("pico-overlay").clazz(e("overlayClass","")).stylize({display:"none",position:"fixed",top:"0px",left:"0px",height:"100%",width:"100%",zIndex:1e4}).stylize(e("overlayStyles",{opacity:.5,background:"#000"})).onClick(function(){e("overlayClose",!0)&&t()})}(a,f),close:function(e,t){if(t("closeButton",!0))return e.child("button").html(t("closeHtml","&#xD7;")).clazz("pico-close").clazz(t("closeClass","")).stylize(t("closeStyles",{borderRadius:"2px",border:0,padding:0,cursor:"pointer",height:"15px",width:"15px",position:"absolute",top:"5px",right:"5px",fontSize:"16px",textAlign:"center",lineHeight:"15px",background:"#CCC"})).attr("aria-label",t("close-label","Close"))}(i,a)},o.trigger(l,t)}return c[e]}return function(n,o){function t(e,t){return(e.msMatchesSelector||e.webkitMatchesSelector||e.matches).call(e,t)}function r(e){return!(y(e)||t(e,":disabled")||e.hasAttribute("contenteditable"))&&(e.hasAttribute("tabindex")||t(e,"input,select,textarea,button,a[href],area[href],iframe"))}function s(e){for(var t=e.getElementsByTagName("*"),i=0;i<t.length;i++)if(r(t[i]))return t[i]}var e;n.beforeShow(function(){e=document.activeElement}),n.afterShow(function(){if(o()){var e=s(n.modalElem());e&&e.focus()}}),n.afterClose(function(){o()&&e&&e.focus(),e=null}),E.watch(function(e){if(o()&&n.isVisible()){var t=s(n.modalElem()),i=function(e){for(var t=e.getElementsByTagName("*"),i=t.length;i--;)if(r(t[i]))return t[i]}(n.modalElem());(e.shiftKey?t:i)===document.activeElement&&((e.shiftKey?i:t).focus(),e.preventDefault())}})}(l={modalElem:C(d),closeElem:C(u),overlayElem:C(h),buildDom:e(m.bind(null,null)),isVisible:function(){return!!(c&&d&&d().isVisible())},show:function(e){return t.trigger(l,e)&&(h().show(),u(),d().show(),i.trigger(l,e)),this},close:e(f),forceClose:e(p),destroy:function(){d().destroy(),h().destroy(),h=d=u=void 0},options:function(t){Object.keys(t).map(function(e){n[e]=t[e]})},afterCreate:e(o.watch),beforeShow:e(t.watch),afterShow:e(i.watch),beforeClose:e(r.watch),afterClose:e(s.watch)},a.bind(null,"focus",!0)),function(e,t){var i,n=new b(document.body);e.beforeShow(function(){i=n.elem.style.overflow,t()&&n.stylize({overflow:"hidden"})}),e.afterClose(function(){n.stylize({overflow:i})})}(l,a.bind(null,"bodyOverflow",!0)),_.watch(function(){a("escCloses",!0)&&l.isVisible()&&l.close()}),l}})?n.apply(t,o):n)||(e.exports=r)}()},function(e,t,i){"use strict";function n(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}i.d(t,"a",function(){return o});var o=function(){function r(e){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,r),this.errorTableVisible=e.errorTableVisible,this.onToggleVisibility=e.onToggleVisibility,this.onFocusLine=e.onFocusLine||function(){},this.onChangeHeight=e.onChangeHeight,this.dom={};var t=document.createElement("div");t.className="jsoneditor-validation-errors-container",this.dom.validationErrorsContainer=t;var i=document.createElement("div");i.style.display="none",i.className="jsoneditor-additional-errors fadein",i.innerHTML="Scroll for more &#9663;",this.dom.additionalErrorsIndication=i,t.appendChild(i);var n=document.createElement("span");n.className="jsoneditor-validation-error-icon",n.style.display="none",this.dom.validationErrorIcon=n;var o=document.createElement("span");o.className="jsoneditor-validation-error-count",o.style.display="none",this.dom.validationErrorCount=o,this.dom.parseErrorIndication=document.createElement("span"),this.dom.parseErrorIndication.className="jsoneditor-parse-error-icon",this.dom.parseErrorIndication.style.display="none"}return function(e,t,i){t&&n(e.prototype,t),i&&n(e,i)}(r,[{key:"getErrorTable",value:function(){return this.dom.validationErrorsContainer}},{key:"getErrorCounter",value:function(){return this.dom.validationErrorCount}},{key:"getWarningIcon",value:function(){return this.dom.validationErrorIcon}},{key:"getErrorIcon",value:function(){return this.dom.parseErrorIndication}},{key:"toggleTableVisibility",value:function(){this.errorTableVisible=!this.errorTableVisible,this.onToggleVisibility(this.errorTableVisible)}},{key:"setErrors",value:function(e,r){var s=this;if(this.dom.validationErrors&&(this.dom.validationErrors.parentNode.removeChild(this.dom.validationErrors),this.dom.validationErrors=null,this.dom.additionalErrorsIndication.style.display="none"),this.errorTableVisible&&0<e.length){var t=document.createElement("div");t.className="jsoneditor-validation-errors",t.innerHTML='<table class="jsoneditor-text-errors"><tbody></tbody></table>';var a=t.getElementsByTagName("tbody")[0];e.forEach(function(t){var e,i;if(e="string"==typeof t?'<td colspan="2"><pre>'+t+"</pre></td>":"<td>"+(t.dataPath||"")+"</td><td><pre>"+t.message+"</pre></td>",isNaN(t.line)){if(t.dataPath){var n=r.find(function(e){return e.path===t.dataPath});n&&(i=n.line+1)}}else i=t.line;var o=document.createElement("tr");o.className=isNaN(i)?"":"jump-to-line","error"===t.type?o.className+=" parse-error":o.className+=" validation-error",o.innerHTML='<td><button class="jsoneditor-schema-error"></button></td><td style="white-space:nowrap;">'+(isNaN(i)?"":"Ln "+i)+"</td>"+e,o.onclick=function(){s.onFocusLine(i)},a.appendChild(o)}),this.dom.validationErrors=t,this.dom.validationErrorsContainer.appendChild(t),this.dom.additionalErrorsIndication.title=e.length+" errors total",this.dom.validationErrorsContainer.clientHeight<this.dom.validationErrorsContainer.scrollHeight?(this.dom.additionalErrorsIndication.style.display="block",this.dom.validationErrorsContainer.onscroll=function(){s.dom.additionalErrorsIndication.style.display=0<s.dom.validationErrorsContainer.clientHeight&&0===s.dom.validationErrorsContainer.scrollTop?"block":"none"}):this.dom.validationErrorsContainer.onscroll=void 0;var i=this.dom.validationErrorsContainer.clientHeight+(this.dom.statusBar?this.dom.statusBar.clientHeight:0);this.onChangeHeight(i)}else this.onChangeHeight(0);var n=e.filter(function(e){return"error"!==e.type}).length;if(0<n?(this.dom.validationErrorCount.style.display="inline",this.dom.validationErrorCount.innerText=n,this.dom.validationErrorCount.onclick=this.toggleTableVisibility.bind(this),this.dom.validationErrorIcon.style.display="inline",this.dom.validationErrorIcon.title=n+" schema validation error(s) found",this.dom.validationErrorIcon.onclick=this.toggleTableVisibility.bind(this)):(this.dom.validationErrorCount.style.display="none",this.dom.validationErrorIcon.style.display="none"),e.some(function(e){return"error"===e.type})){var o=e[0].line;this.dom.parseErrorIndication.style.display="block",this.dom.parseErrorIndication.title=isNaN(o)?"parse error - check that the json is valid":"parse error on line "+o,this.dom.parseErrorIndication.onclick=this.toggleTableVisibility.bind(this)}else this.dom.parseErrorIndication.style.display="none"}}]),r}()},function(e,t,i){var n;if(window.ace)n=window.ace;else try{n=i(!function(){var e=new Error("Cannot find module 'ace-builds/src-noconflict/ace'");throw e.code="MODULE_NOT_FOUND",e}()),i(!function(){var e=new Error("Cannot find module 'ace-builds/src-noconflict/mode-json'");throw e.code="MODULE_NOT_FOUND",e}()),i(!function(){var e=new Error("Cannot find module 'ace-builds/src-noconflict/ext-searchbox'");throw e.code="MODULE_NOT_FOUND",e}());var o=i(!function(){var e=new Error("Cannot find module '../generated/worker-json-data-url'");throw e.code="MODULE_NOT_FOUND",e}());n.config.setModuleUrl("ace/mode/json_worker",o)}catch(e){}e.exports=n},function(e,t,i){"use strict";i.r(t);var n=i(14),_=i.n(n),o=i(4),r=i.n(o),E=i(1),w=i(6),T=i(13),S=i(0);var s=i(5),a=i(7),l=i(2),j=i(19);function N(e){return(N="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}i.d(t,"textModeMixins",function(){return h});var c={},k="ace/theme/jsoneditor";function d(){try{this.format()}catch(e){}}c.create=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};void 0===t.statusBar&&(t.statusBar=!0),t.mainMenuBar=!1!==t.mainMenuBar,t.enableSort=!1!==t.enableSort,t.enableTransform=!1!==t.enableTransform,"number"==typeof(this.options=t).indentation?this.indentation=Number(t.indentation):this.indentation=2;var i=t.ace?t.ace:_.a;this.mode="code"===t.mode?"code":"text","code"===this.mode&&void 0===i&&(this.mode="text",console.warn("Failed to load Ace editor, falling back to plain text mode. Please use a JSONEditor bundle including Ace, or pass Ace as via the configuration option `ace`.")),this.theme=t.theme||k,this.theme===k&&i&&Object(j.tryRequireThemeJsonEditor)(),t.onTextSelectionChange&&this.onTextSelectionChange(t.onTextSelectionChange);var n=this;if(this.container=e,this.dom={},this.aceEditor=void 0,this.textarea=void 0,this.validateSchema=null,this.annotations=[],this._debouncedValidate=Object(S.debounce)(this.validate.bind(this),this.DEBOUNCE_INTERVAL),this.width=e.clientWidth,this.height=e.clientHeight,this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode,this.frame.onclick=function(e){e.preventDefault()},this.frame.onkeydown=function(e){n._onKeyDown(e)},this.content=document.createElement("div"),this.content.className="jsoneditor-outer",this.options.mainMenuBar){Object(S.addClassName)(this.content,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu);var o=document.createElement("button");o.type="button",o.className="jsoneditor-format",o.title="Format JSON data, with proper indentation and line feeds (Ctrl+\\)",this.menu.appendChild(o),o.onclick=function(){try{n.format(),n._onChange()}catch(e){n._onError(e)}};var r=document.createElement("button");if(r.type="button",r.className="jsoneditor-compact",r.title="Compact JSON data, remove all whitespaces (Ctrl+Shift+\\)",this.menu.appendChild(r),r.onclick=function(){try{n.compact(),n._onChange()}catch(e){n._onError(e)}},this.options.enableSort){var s=document.createElement("button");s.type="button",s.className="jsoneditor-sort",s.title=Object(E.c)("sortTitleShort"),s.onclick=function(){n._showSortModal()},this.menu.appendChild(s)}if(this.options.enableTransform){var a=document.createElement("button");a.type="button",a.title=Object(E.c)("transformTitleShort"),a.className="jsoneditor-transform",a.onclick=function(){n._showTransformModal()},this.menu.appendChild(a)}var l=document.createElement("button");if(l.type="button",l.className="jsoneditor-repair",l.title="Repair JSON: fix quotes and escape characters, remove comments and JSONP notation, turn JavaScript objects into JSON.",this.menu.appendChild(l),l.onclick=function(){try{n.repair(),n._onChange()}catch(e){n._onError(e)}},this.options&&this.options.modes&&this.options.modes.length&&(this.modeSwitcher=new w.a(this.menu,this.options.modes,this.options.mode,function(e){n.setMode(e),n.modeSwitcher.focus()})),"code"===this.mode){var c=document.createElement("a");c.appendChild(document.createTextNode("powered by ace")),c.href="http://ace.ajax.org",c.target="_blank",c.className="jsoneditor-poweredBy",c.onclick=function(){window.open(c.href,c.target)},this.menu.appendChild(c)}}var d=this.options.onEditable&&N("function"===this.options.onEditable)&&!this.options.onEditable({});if(this.frame.appendChild(this.content),this.container.appendChild(this.frame),"code"===this.mode){this.editorDom=document.createElement("div"),this.editorDom.style.height="100%",this.editorDom.style.width="100%",this.content.appendChild(this.editorDom);var h=i.edit(this.editorDom),u=h.getSession();h.$blockScrolling=1/0,h.setTheme(this.theme),h.setOptions({readOnly:d}),h.setShowPrintMargin(!1),h.setFontSize("13px"),u.setMode("ace/mode/json"),u.setTabSize(this.indentation),u.setUseSoftTabs(!0),u.setUseWrapMode(!0);var p=u.setAnnotations;u.setAnnotations=function(e){p.call(this,e&&e.length?e:n.annotations)},h.commands.bindKey("Ctrl-L",null),h.commands.bindKey("Command-L",null),(this.aceEditor=h).on("change",this._onChange.bind(this)),h.on("changeSelection",this._onSelect.bind(this))}else{var f=document.createElement("textarea");f.className="jsoneditor-text",f.spellcheck=!1,this.content.appendChild(f),this.textarea=f,this.textarea.readOnly=d,null===this.textarea.oninput?this.textarea.oninput=this._onChange.bind(this):this.textarea.onchange=this._onChange.bind(this),f.onselect=this._onSelect.bind(this),f.onmousedown=this._onMouseDown.bind(this),f.onblur=this._onBlur.bind(this)}if(this.errorTable=new T.a({errorTableVisible:"text"===this.mode,onToggleVisibility:function(){n.validate()},onFocusLine:function(e){n.isFocused=!0,isNaN(e)||n.setTextSelection({row:e,column:1},{row:e,column:1e3})},onChangeHeight:function(e){var t=e+(n.dom.statusBar?n.dom.statusBar.clientHeight:0)+1;n.content.style.marginBottom=-t+"px",n.content.style.paddingBottom=t+"px"}}),this.frame.appendChild(this.errorTable.getErrorTable()),t.statusBar){Object(S.addClassName)(this.content,"has-status-bar"),this.curserInfoElements={};var m=document.createElement("div");(this.dom.statusBar=m).className="jsoneditor-statusbar",this.frame.appendChild(m);var v=document.createElement("span");v.className="jsoneditor-curserinfo-label",v.innerText="Ln:";var g=document.createElement("span");g.className="jsoneditor-curserinfo-val",g.innerText="1",m.appendChild(v),m.appendChild(g);var y=document.createElement("span");y.className="jsoneditor-curserinfo-label",y.innerText="Col:";var b=document.createElement("span");b.className="jsoneditor-curserinfo-val",b.innerText="1",m.appendChild(y),m.appendChild(b),this.curserInfoElements.colVal=b,this.curserInfoElements.lnVal=g;var x=document.createElement("span");x.className="jsoneditor-curserinfo-label",x.innerText="characters selected",x.style.display="none";var C=document.createElement("span");C.className="jsoneditor-curserinfo-count",C.innerText="0",C.style.display="none",this.curserInfoElements.countLabel=x,this.curserInfoElements.countVal=C,m.appendChild(C),m.appendChild(x),m.appendChild(this.errorTable.getErrorCounter()),m.appendChild(this.errorTable.getWarningIcon()),m.appendChild(this.errorTable.getErrorIcon())}this.setSchema(this.options.schema,this.options.schemaRefs)},c._onChange=function(){if(!this.onChangeDisabled){if(this._debouncedValidate(),this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(e){console.error("Error in onChangeText callback: ",e)}}},c._showSortModal=function(){var n=this,e=this.options.modalAnchor||l.a,o=this.get();Object(s.a)(e,o,function(e){if(Array.isArray(o)){var t=Object(S.sort)(o,e.path,e.direction);n.sortedBy=e,n.set(t)}if(Object(S.isObject)(o)){var i=Object(S.sortObjectKeys)(o,e.direction);n.sortedBy=e,n.set(i)}},n.sortedBy)},c._showTransformModal=function(){var i=this,e=this.options.modalAnchor||l.a,n=this.get();Object(a.a)(e,n,function(e){var t=r.a.search(n,e);i.set(t)})},c._onSelect=function(){this._updateCursorInfo(),this._emitSelectionChange()},c._onKeyDown=function(e){var t=!1;220===(e.which||e.keyCode)&&e.ctrlKey&&(e.shiftKey?this.compact():this.format(),this._onChange(),t=!0),t&&(e.preventDefault(),e.stopPropagation()),this._updateCursorInfo(),this._emitSelectionChange()},c._onMouseDown=function(){this._updateCursorInfo(),this._emitSelectionChange()},c._onBlur=function(){var e=this;setTimeout(function(){e.isFocused||(e._updateCursorInfo(),e._emitSelectionChange()),e.isFocused=!1})},c._updateCursorInfo=function(){var t,i,n,o=this;if(this.textarea)setTimeout(function(){var e=Object(S.getInputSelection)(o.textarea);e.startIndex!==e.endIndex&&(n=e.endIndex-e.startIndex),i=n&&o.cursorInfo&&o.cursorInfo.line===e.end.row&&o.cursorInfo.column===e.end.column?(t=e.start.row,e.start.column):(t=e.end.row,e.end.column),o.cursorInfo={line:t,column:i,count:n},o.options.statusBar&&s()},0);else if(this.aceEditor&&this.curserInfoElements){var e=this.aceEditor.getCursorPosition(),r=this.aceEditor.getSelectedText();t=e.row+1,i=e.column+1,n=r.length,o.cursorInfo={line:t,column:i,count:n},this.options.statusBar&&s()}function s(){o.curserInfoElements.countVal.innerText!==n&&(o.curserInfoElements.countVal.innerText=n,o.curserInfoElements.countVal.style.display=n?"inline":"none",o.curserInfoElements.countLabel.style.display=n?"inline":"none"),o.curserInfoElements.lnVal.innerText=t,o.curserInfoElements.colVal.innerText=i}},c._emitSelectionChange=function(){if(this._selectionChangedHandler){var e=this.getTextSelection();this._selectionChangedHandler(e.start,e.end,e.text)}},c._refreshAnnotations=function(){var e=this.aceEditor&&this.aceEditor.getSession();if(e){var t=e.getAnnotations().filter(function(e){return"error"===e.type});e.setAnnotations(t)}},c.destroy=function(){this.aceEditor&&(this.aceEditor.destroy(),this.aceEditor=null),this.frame&&this.container&&this.frame.parentNode===this.container&&this.container.removeChild(this.frame),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this.textarea=null,this._debouncedValidate=null},c.compact=function(){var e=this.get(),t=JSON.stringify(e);this._setText(t,!1)},c.format=function(){var e=this.get(),t=JSON.stringify(e,null,this.indentation);this._setText(t,!1)},c.repair=function(){var e=this.getText(),t=Object(S.repair)(e);this._setText(t,!1)},c.focus=function(){this.textarea&&this.textarea.focus(),this.aceEditor&&this.aceEditor.focus()},c.resize=function(){if(this.aceEditor){this.aceEditor.resize(!1)}},c.set=function(e){this.setText(JSON.stringify(e,null,this.indentation))},c.update=function(e){this.updateText(JSON.stringify(e,null,this.indentation))},c.get=function(){var e=this.getText();return Object(S.parse)(e)},c.getText=function(){return this.textarea?this.textarea.value:this.aceEditor?this.aceEditor.getValue():""},c._setText=function(e,t){var i=!0===this.options.escapeUnicode?Object(S.escapeUnicodeChars)(e):e;if(this.textarea&&(this.textarea.value=i),this.aceEditor&&(this.onChangeDisabled=!0,this.aceEditor.setValue(i,-1),this.onChangeDisabled=!1,t)){var n=this;setTimeout(function(){n.aceEditor&&n.aceEditor.session.getUndoManager().reset()},0)}this._debouncedValidate()},c.setText=function(e){this._setText(e,!0)},c.updateText=function(e){this.getText()!==e&&this._setText(e,!1)},c.validate=function(){var e,i=[],n=[];try{if(e=this.get(),this.validateSchema)this.validateSchema(e)||(i=this.validateSchema.errors.map(function(e){return e.type="validation",Object(S.improveSchemaError)(e)}));this.validationSequence=(this.validationSequence||0)+1;var o=this,r=this.validationSequence;(function(e,t){if(!t)return Promise.resolve([]);try{var i=t(e);return(Object(S.isPromise)(i)?i:Promise.resolve(i)).then(function(e){return Array.isArray(e)?e.filter(function(e){var t=Object(S.isValidValidationError)(e);return t||console.warn('Ignoring a custom validation error with invalid structure. Expected structure: {path: [...], message: "..."}. Actual error:',e),t}).map(function(e){return{dataPath:Object(S.stringifyPath)(e.path),message:e.message}}):[]})}catch(e){return Promise.reject(e)}})(e,this.options.onValidate).then(function(e){if(r===o.validationSequence){var t=i.concat(n).concat(e);o._renderErrors(t)}}).catch(function(e){console.error("Custom validation function did throw an error",e)})}catch(e){if(this.getText()){var t,s=/\w*line\s*(\d+)\w*/g.exec(e.message);s&&(t=+s[1]),n=[{type:"error",message:e.message.replace(/\n/g,"<br>"),line:t}]}this._renderErrors(n)}},c._renderErrors=function(n){var e=this.getText(),t=[];n.reduce(function(e,t){return"string"==typeof t.dataPath&&-1===e.indexOf(t.dataPath)&&e.push(t.dataPath),e},t);var i=Object(S.getPositionForPath)(e,t);if(this.aceEditor&&(this.annotations=i.map(function(t){var e=n.filter(function(e){return e.dataPath===t.path}),i=e.map(function(e){return e.message}).join("\n");return i?{row:t.line,column:t.column,text:"Schema validation error"+(1!==e.length?"s":"")+": \n"+i,type:"warning",source:"jsoneditor"}:{}}),this._refreshAnnotations()),this.errorTable.setErrors(n,i),this.aceEditor){this.aceEditor.resize(!1)}},c.getTextSelection=function(){var e={};if(this.textarea){var t=Object(S.getInputSelection)(this.textarea);return this.cursorInfo&&this.cursorInfo.line===t.end.row&&this.cursorInfo.column===t.end.column?(e.start=t.end,e.end=t.start):e=t,{start:e.start,end:e.end,text:this.textarea.value.substring(t.startIndex,t.endIndex)}}if(this.aceEditor){var i=this.aceEditor.getSelection(),n=this.aceEditor.getSelectedText(),o=i.getRange(),r=i.getSelectionLead();return r.row===o.end.row&&r.column===o.end.column?e=o:(e.start=o.end,e.end=o.start),{start:{row:e.start.row+1,column:e.start.column+1},end:{row:e.end.row+1,column:e.end.column+1},text:n}}},c.onTextSelectionChange=function(e){"function"==typeof e&&(this._selectionChangedHandler=Object(S.debounce)(e,this.DEBOUNCE_INTERVAL))},c.setTextSelection=function(e,t){if(e&&t)if(this.textarea){var i=Object(S.getIndexForPosition)(this.textarea,e.row,e.column),n=Object(S.getIndexForPosition)(this.textarea,t.row,t.column);if(-1<i&&-1<n){if(this.textarea.setSelectionRange)this.textarea.focus(),this.textarea.setSelectionRange(i,n);else if(this.textarea.createTextRange){var o=this.textarea.createTextRange();o.collapse(!0),o.moveEnd("character",n),o.moveStart("character",i),o.select()}var r=(this.textarea.value.match(/\n/g)||[]).length+1,s=this.textarea.scrollHeight/r
,a=e.row*s;this.textarea.scrollTop=a>this.textarea.clientHeight?a-this.textarea.clientHeight/2:0}}else if(this.aceEditor){var l={start:{row:e.row-1,column:e.column-1},end:{row:t.row-1,column:t.column-1}};this.aceEditor.selection.setRange(l),this.aceEditor.scrollToLine(e.row-1,!0)}};var h=[{mode:"text",mixin:c,data:"text",load:d},{mode:"code",mixin:c,data:"text",load:d}]},function(e,t,i){var n,o=((n={trace:function(){},yy:{},symbols_:{error:2,JSONString:3,STRING:4,JSONNumber:5,NUMBER:6,JSONNullLiteral:7,NULL:8,JSONBooleanLiteral:9,TRUE:10,FALSE:11,JSONText:12,JSONValue:13,EOF:14,JSONObject:15,JSONArray:16,"{":17,"}":18,JSONMemberList:19,JSONMember:20,":":21,",":22,"[":23,"]":24,JSONElementList:25,$accept:0,$end:1},terminals_:{2:"error",4:"STRING",6:"NUMBER",8:"NULL",10:"TRUE",11:"FALSE",14:"EOF",17:"{",18:"}",21:":",22:",",23:"[",24:"]"},productions_:[0,[3,1],[5,1],[7,1],[9,1],[9,1],[12,2],[13,1],[13,1],[13,1],[13,1],[13,1],[13,1],[15,2],[15,3],[20,3],[19,1],[19,3],[16,2],[16,3],[25,1],[25,3]],performAction:function(e,t,i,n,o,r){var s=r.length-1;switch(o){case 1:this.$=e.replace(/\\(\\|")/g,"$1").replace(/\\n/g,"\n").replace(/\\r/g,"\r").replace(/\\t/g,"\t").replace(/\\v/g,"\v").replace(/\\f/g,"\f").replace(/\\b/g,"\b");break;case 2:this.$=Number(e);break;case 3:this.$=null;break;case 4:this.$=!0;break;case 5:this.$=!1;break;case 6:return this.$=r[s-1];case 13:this.$={};break;case 14:this.$=r[s-1];break;case 15:this.$=[r[s-2],r[s]];break;case 16:this.$={},this.$[r[s][0]]=r[s][1];break;case 17:this.$=r[s-2],r[s-2][r[s][0]]=r[s][1];break;case 18:this.$=[];break;case 19:this.$=r[s-1];break;case 20:this.$=[r[s]];break;case 21:this.$=r[s-2],r[s-2].push(r[s])}},table:[{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],12:1,13:2,15:7,16:8,17:[1,14],23:[1,15]},{1:[3]},{14:[1,16]},{14:[2,7],18:[2,7],22:[2,7],24:[2,7]},{14:[2,8],18:[2,8],22:[2,8],24:[2,8]},{14:[2,9],18:[2,9],22:[2,9],24:[2,9]},{14:[2,10],18:[2,10],22:[2,10],24:[2,10]},{14:[2,11],18:[2,11],22:[2,11],24:[2,11]},{14:[2,12],18:[2,12],22:[2,12],24:[2,12]},{14:[2,3],18:[2,3],22:[2,3],24:[2,3]},{14:[2,4],18:[2,4],22:[2,4],24:[2,4]},{14:[2,5],18:[2,5],22:[2,5],24:[2,5]},{14:[2,1],18:[2,1],21:[2,1],22:[2,1],24:[2,1]},{14:[2,2],18:[2,2],22:[2,2],24:[2,2]},{3:20,4:[1,12],18:[1,17],19:18,20:19},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:23,15:7,16:8,17:[1,14],23:[1,15],24:[1,21],25:22},{1:[2,6]},{14:[2,13],18:[2,13],22:[2,13],24:[2,13]},{18:[1,24],22:[1,25]},{18:[2,16],22:[2,16]},{21:[1,26]},{14:[2,18],18:[2,18],22:[2,18],24:[2,18]},{22:[1,28],24:[1,27]},{22:[2,20],24:[2,20]},{14:[2,14],18:[2,14],22:[2,14],24:[2,14]},{3:20,4:[1,12],20:29},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:30,15:7,16:8,17:[1,14],23:[1,15]},{14:[2,19],18:[2,19],22:[2,19],24:[2,19]},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:31,15:7,16:8,17:[1,14],23:[1,15]},{18:[2,17],22:[2,17]},{18:[2,15],22:[2,15]},{22:[2,21],24:[2,21]}],defaultActions:{16:[2,6]},parseError:function(e){throw new Error(e)},parse:function(e){var t=this,i=[0],n=[null],o=[],r=this.table,s="",a=0,l=0,c=0;this.lexer.setInput(e),this.lexer.yy=this.yy,this.yy.lexer=this.lexer,void 0===this.lexer.yylloc&&(this.lexer.yylloc={});var d=this.lexer.yylloc;function h(){var e;return"number"!=typeof(e=t.lexer.lex()||1)&&(e=t.symbols_[e]||e),e}o.push(d),"function"==typeof this.yy.parseError&&(this.parseError=this.yy.parseError);for(var u,p,f,m,v,g,y,b,x,C,_={};;){if(f=i[i.length-1],void 0===(m=this.defaultActions[f]?this.defaultActions[f]:(null==u&&(u=h()),r[f]&&r[f][u]))||!m.length||!m[0]){if(!c){for(g in x=[],r[f])this.terminals_[g]&&2<g&&x.push("'"+this.terminals_[g]+"'");var E="";E=this.lexer.showPosition?"Parse error on line "+(a+1)+":\n"+this.lexer.showPosition()+"\nExpecting "+x.join(", ")+", got '"+this.terminals_[u]+"'":"Parse error on line "+(a+1)+": Unexpected "+(1==u?"end of input":"'"+(this.terminals_[u]||u)+"'"),this.parseError(E,{text:this.lexer.match,token:this.terminals_[u]||u,line:this.lexer.yylineno,loc:d,expected:x})}if(3==c){if(1==u)throw new Error(E||"Parsing halted.");l=this.lexer.yyleng,s=this.lexer.yytext,a=this.lexer.yylineno,d=this.lexer.yylloc,u=h()}for(;!(2..toString()in r[f]);){if(0==f)throw new Error(E||"Parsing halted.");C=1,i.length=i.length-2*C,n.length=n.length-C,o.length=o.length-C,f=i[i.length-1]}p=u,u=2,m=r[f=i[i.length-1]]&&r[f][2],c=3}if(m[0]instanceof Array&&1<m.length)throw new Error("Parse Error: multiple actions possible at state: "+f+", token: "+u);switch(m[0]){case 1:i.push(u),n.push(this.lexer.yytext),o.push(this.lexer.yylloc),i.push(m[1]),u=null,p?(u=p,p=null):(l=this.lexer.yyleng,s=this.lexer.yytext,a=this.lexer.yylineno,d=this.lexer.yylloc,0<c&&c--);break;case 2:if(y=this.productions_[m[1]][1],_.$=n[n.length-y],_._$={first_line:o[o.length-(y||1)].first_line,last_line:o[o.length-1].last_line,first_column:o[o.length-(y||1)].first_column,last_column:o[o.length-1].last_column},void 0!==(v=this.performAction.call(_,s,l,a,this.yy,m[1],n,o)))return v;y&&(i=i.slice(0,-1*y*2),n=n.slice(0,-1*y),o=o.slice(0,-1*y)),i.push(this.productions_[m[1]][0]),n.push(_.$),o.push(_._$),b=r[i[i.length-2]][i[i.length-1]],i.push(b);break;case 3:return!0}}return!0}}).lexer={EOF:1,parseError:function(e,t){if(!this.yy.parseError)throw new Error(e);this.yy.parseError(e,t)},setInput:function(e){return this._input=e,this._more=this._less=this.done=!1,this.yylineno=this.yyleng=0,this.yytext=this.matched=this.match="",this.conditionStack=["INITIAL"],this.yylloc={first_line:1,first_column:0,last_line:1,last_column:0},this},input:function(){var e=this._input[0];return this.yytext+=e,this.yyleng++,this.match+=e,this.matched+=e,e.match(/\n/)&&this.yylineno++,this._input=this._input.slice(1),e},unput:function(e){return this._input=e+this._input,this},more:function(){return this._more=!0,this},less:function(e){this._input=this.match.slice(e)+this._input},pastInput:function(){var e=this.matched.substr(0,this.matched.length-this.match.length);return(20<e.length?"...":"")+e.substr(-20).replace(/\n/g,"")},upcomingInput:function(){var e=this.match;return e.length<20&&(e+=this._input.substr(0,20-e.length)),(e.substr(0,20)+(20<e.length?"...":"")).replace(/\n/g,"")},showPosition:function(){var e=this.pastInput(),t=new Array(e.length+1).join("-");return e+this.upcomingInput()+"\n"+t+"^"},next:function(){if(this.done)return this.EOF;var e,t,i,n,o;this._input||(this.done=!0),this._more||(this.yytext="",this.match="");for(var r=this._currentRules(),s=0;s<r.length&&(!(i=this._input.match(this.rules[r[s]]))||t&&!(i[0].length>t[0].length)||(t=i,n=s,this.options.flex));s++);return t?((o=t[0].match(/\n.*/g))&&(this.yylineno+=o.length),this.yylloc={first_line:this.yylloc.last_line,last_line:this.yylineno+1,first_column:this.yylloc.last_column,last_column:o?o[o.length-1].length-1:this.yylloc.last_column+t[0].length},this.yytext+=t[0],this.match+=t[0],this.yyleng=this.yytext.length,this._more=!1,this._input=this._input.slice(t[0].length),this.matched+=t[0],e=this.performAction.call(this,this.yy,this,r[n],this.conditionStack[this.conditionStack.length-1]),this.done&&this._input&&(this.done=!1),e||void 0):""===this._input?this.EOF:void this.parseError("Lexical error on line "+(this.yylineno+1)+". Unrecognized text.\n"+this.showPosition(),{text:"",token:null,line:this.yylineno})},lex:function(){var e=this.next();return void 0!==e?e:this.lex()},begin:function(e){this.conditionStack.push(e)},popState:function(){return this.conditionStack.pop()},_currentRules:function(){return this.conditions[this.conditionStack[this.conditionStack.length-1]].rules},topState:function(){return this.conditionStack[this.conditionStack.length-2]},pushState:function(e){this.begin(e)},options:{},performAction:function(e,t,i){switch(i){case 0:break;case 1:return 6;case 2:return t.yytext=t.yytext.substr(1,t.yyleng-2),4;case 3:return 17;case 4:return 18;case 5:return 23;case 6:return 24;case 7:return 22;case 8:return 21;case 9:return 10;case 10:return 11;case 11:return 8;case 12:return 14;case 13:return"INVALID"}},rules:[/^(?:\s+)/,/^(?:(-?([0-9]|[1-9][0-9]+))(\.[0-9]+)?([eE][-+]?[0-9]+)?\b)/,/^(?:"(?:\\[\\"bfnrt/]|\\u[a-fA-F0-9]{4}|[^\\\0-\x09\x0a-\x1f"])*")/,/^(?:\{)/,/^(?:\})/,/^(?:\[)/,/^(?:\])/,/^(?:,)/,/^(?::)/,/^(?:true\b)/,/^(?:false\b)/,/^(?:null\b)/,/^(?:$)/,/^(?:.)/],conditions:{INITIAL:{rules:[0,1,2,3,4,5,6,7,8,9,10,11,12,13],inclusive:!0}}},n);t.parser=o,t.parse=o.parse.bind(o)},function(e,t){function i(e){"remove"in e||Object.defineProperty(e,"remove",{configurable:!0,enumerable:!0,writable:!0,value:function(){void 0!==this.parentNode&&this.parentNode.removeChild(this)}})}"undefined"!=typeof Element&&(void 0!==window.Element&&i(window.Element.prototype),void 0!==window.CharacterData&&i(window.CharacterData.prototype),void 0!==window.DocumentType&&i(window.DocumentType.prototype)),Array.prototype.find||(Array.prototype.find=function(e){for(var t=0;t<this.length;t++){var i=this[t];if(e.call(this,i,t,this))return i}}),String.prototype.trim||(String.prototype.trim=function(){return this.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,"")})},function(e,t,i){"use strict";var _={b:"\b",f:"\f",n:"\n",r:"\r",t:"\t",'"':'"',"/":"/","\\":"\\"},E="a".charCodeAt();t.parse=function(o,e,t){var n={},i=0,r=0,s=0,a=t&&t.bigint&&"undefined"!=typeof BigInt;return{data:l("",!0),pointers:n};function l(e,t){var i;c(),v(e,"value");var n=u();switch(n){case"t":h("rue"),i=!0;break;case"f":h("alse"),i=!1;break;case"n":h("ull"),i=null;break;case'"':i=d();break;case"[":i=function(e){c();var t=[],i=0;if("]"==u())return t;p();for(;;){var n=e+"/"+i;t.push(l(n)),c();var o=u();if("]"==o)break;","!=o&&x(),c(),i++}return t}(e);break;case"{":i=function(e){c();var t={};if("}"==u())return t;p();for(;;){var i=y();'"'!=u()&&x();var n=d(),o=e+"/"+w(n);g(o,"key",i),v(o,"keyEnd"),c(),":"!=u()&&x(),c(),t[n]=l(o),c();var r=u();if("}"==r)break;","!=r&&x(),c()}return t}(e);break;default:p(),0<="-0123456789".indexOf(n)?i=function(){var e="",t=!0;"-"==o[s]&&(e+=u());e+="0"==o[s]?u():m(),"."==o[s]&&(e+=u()+m(),t=!1);"e"!=o[s]&&"E"!=o[s]||(e+=u(),"+"!=o[s]&&"-"!=o[s]||(e+=u()),e+=m(),t=!1);var i=+e;return a&&t&&(i>Number.MAX_SAFE_INTEGER||i<Number.MIN_SAFE_INTEGER)?BigInt(e):i}():b()}return v(e,"valueEnd"),c(),t&&s<o.length&&b(),i}function c(){e:for(;s<o.length;){switch(o[s]){case" ":r++;break;case"\t":r+=4;break;case"\r":r=0;break;case"\n":r=0,i++;break;default:break e}s++}}function d(){for(var e,t="";'"'!=(e=u());)"\\"==e?(e=u())in _?t+=_[e]:"u"==e?t+=f():x():t+=e;return t}function h(e){for(var t=0;t<e.length;t++)u()!==e[t]&&x()}function u(){C();var e=o[s];return s++,r++,e}function p(){s--,r--}function f(){for(var e=4,t=0;e--;){t<<=4;var i=u().toLowerCase();"a"<=i&&i<="f"?t+=i.charCodeAt()-E+10:"0"<=i&&i<="9"?t+=+i:x()}return String.fromCharCode(t)}function m(){for(var e="";"0"<=o[s]&&o[s]<="9";)e+=u();if(e.length)return e;C(),b()}function v(e,t){g(e,t,y())}function g(e,t,i){n[e]=n[e]||{},n[e][t]=i}function y(){return{line:i,column:r,pos:s}}function b(){throw new SyntaxError("Unexpected token "+o[s]+" in JSON at position "+s)}function x(){p(),b()}function C(){if(s>=o.length)throw new SyntaxError("Unexpected end of JSON input")}},t.stringify=function(e,t,i){if(b(e)){var n,o,r=0,p="object"==typeof i?i.space:i;switch(typeof p){case"number":var s=10<p?10:p<0?0:Math.floor(p);p=s&&y(s," "),o=n=s;break;case"string":p=p.slice(0,10);for(var a=o=n=0;a<p.length;a++){switch(p[a]){case" ":o++;break;case"\t":o+=4;break;case"\r":o=0;break;case"\n":o=0,r++;break;default:throw new Error("whitespace characters not allowed in JSON")}n++}break;default:p=void 0}var l="",c={},d=0,h=0,u=0,f=i&&i.es6&&"function"==typeof Map;return function c(d,h,u){g(u,"value");switch(typeof d){case"number":case"bigint":case"boolean":m(""+d);break;case"string":m(x(d));break;case"object":null===d?m("null"):"function"==typeof d.toJSON?m(x(d.toJSON())):Array.isArray(d)?e():f?d.constructor.BYTES_PER_ELEMENT?e():d instanceof Map?i():d instanceof Set?i(!0):t():t()}g(u,"valueEnd");function e(){if(d.length){m("[");for(var e=h+1,t=0;t<d.length;t++){t&&m(","),v(e);var i=b(d[t])?d[t]:null,n=u+"/"+t;c(i,e,n)}v(h),m("]")}else m("[]")}function t(){var e=Object.keys(d);if(e.length){m("{");for(var t=h+1,i=0;i<e.length;i++){var n=e[i],o=d[n];if(b(o)){i&&m(",");var r=u+"/"+w(n);v(t),g(r,"key"),m(x(n)),g(r,"keyEnd"),m(":"),p&&m(" "),c(o,t,r)}}v(h),m("}")}else m("{}")}function i(e){if(d.size){m("{");for(var t=h+1,i=!0,n=d.entries(),o=n.next();!o.done;){var r=o.value,s=r[0],a=!!e||r[1];if(b(a)){i||m(","),i=!1;var l=u+"/"+w(s);v(t),g(l,"key"),m(x(s)),g(l,"keyEnd"),m(":"),p&&m(" "),c(a,t,l)}o=n.next()}v(h),m("}")}else m("{}")}}(e,0,""),{json:l,pointers:c}}function m(e){h+=e.length,u+=e.length,l+=e}function v(e){if(p){for(l+="\n"+y(e,p),d++,h=0;e--;)r?(d+=r,h=o):h+=o,u+=n;u+=1}}function g(e,t){c[e]=c[e]||{},c[e][t]={line:d,column:h,pos:u}}function y(e,t){return Array(e+1).join(t)}};var n=["number","bigint","boolean","string","object"];function b(e){return 0<=n.indexOf(typeof e)}var o=/"|\\/g,r=/[\b]/g,s=/\f/g,a=/\n/g,l=/\r/g,c=/\t/g;function x(e){return'"'+(e=e.replace(o,"\\$&").replace(s,"\\f").replace(r,"\\b").replace(a,"\\n").replace(l,"\\r").replace(c,"\\t"))+'"'}var d=/~/g,h=/\//g;function w(e){return e.replace(d,"~0").replace(h,"~1")}},function(e,t,i){t.tryRequireThemeJsonEditor=function(){try{i(21)}catch(e){console.error(e)}}},function(e,t,o){"use strict";var i=o(14),n=o(11),r=o(23).treeModeMixins,s=o(15).textModeMixins,a=o(24).previewModeMixins,l=o(0),c=l.clear,d=l.extend,h=l.getInternetExplorerVersion,u=l.parse,p=(0,o(22).tryRequireAjv)();function f(e,t,i){if(!(this instanceof f))throw new Error('JSONEditor constructor called without "new".');var n=h();if(-1!==n&&n<9)throw new Error("Unsupported browser, IE9 or newer required. Please install the newest version of your browser.");t&&(t.error&&(console.warn('Option "error" has been renamed to "onError"'),t.onError=t.error,delete t.error),t.change&&(console.warn('Option "change" has been renamed to "onChange"'),t.onChange=t.change,delete t.change),t.editable&&(console.warn('Option "editable" has been renamed to "onEditable"'),t.onEditable=t.editable,delete t.editable),t.onChangeJSON&&("text"!==t.mode&&"code"!==t.mode&&(!t.modes||-1===t.modes.indexOf("text")&&-1===t.modes.indexOf("code"))||console.warn('Option "onChangeJSON" is not applicable to modes "text" and "code". Use "onChangeText" or "onChange" instead.')),t&&Object.keys(t).forEach(function(e){-1===f.VALID_OPTIONS.indexOf(e)&&console.warn('Unknown option "'+e+'". This option will be ignored')})),arguments.length&&this._create(e,t,i)}"undefined"==typeof Promise&&console.error("Promise undefined. Please load a Promise polyfill in the browser in order to use JSONEditor"),f.modes={},f.prototype.DEBOUNCE_INTERVAL=150,f.VALID_OPTIONS=["ajv","schema","schemaRefs","templates","ace","theme","autocomplete","onChange","onChangeJSON","onChangeText","onEditable","onError","onEvent","onModeChange","onNodeName","onValidate","onCreateMenu","onSelectionChange","onTextSelectionChange","onClassName","colorPicker","onColorPicker","timestampTag","escapeUnicode","history","search","mode","modes","name","indentation","sortObjectKeys","navigationBar","statusBar","mainMenuBar","languages","language","enableSort","enableTransform","maxVisibleChilds"],f.prototype._create=function(e,t,i){this.container=e,this.options=t||{},this.json=i||{};var n=this.options.mode||this.options.modes&&this.options.modes[0]||"tree";this.setMode(n)},f.prototype.destroy=function(){},f.prototype.set=function(e){this.json=e},f.prototype.get=function(){return this.json},f.prototype.setText=function(e){this.json=u(e)},f.prototype.getText=function(){return JSON.stringify(this.json)},f.prototype.setName=function(e){this.options||(this.options={}),this.options.name=e},f.prototype.getName=function(){return this.options&&this.options.name},f.prototype.setMode=function(e){if(e!==this.options.mode||!this.create){var t,i,n=this.container,o=d({},this.options),r=o.mode;o.mode=e;var s=f.modes[e];if(!s)throw new Error('Unknown mode "'+o.mode+'"');try{var a="text"===s.data;if(i=this.getName(),t=this[a?"getText":"get"](),this.destroy(),c(this),d(this,s.mixin),this.create(n,o),this.setName(i),this[a?"setText":"set"](t),"function"==typeof s.load)try{s.load.call(this)}catch(e){console.error(e)}if("function"==typeof o.onModeChange&&e!==r)try{o.onModeChange(e,r)}catch(e){console.error(e)}}catch(e){this._onError(e)}}},f.prototype.getMode=function(){return this.options.mode},f.prototype._onError=function(e){if(!this.options||"function"!=typeof this.options.onError)throw e;this.options.onError(e)},f.prototype.setSchema=function(e,t){if(e){var i;try{this.options.ajv?i=this.options.ajv:((i=p({allErrors:!0,verbose:!0,schemaId:"auto",$data:!0})).addMetaSchema(o(!function(){var e=new Error("Cannot find module 'ajv/lib/refs/json-schema-draft-04.json'");throw e.code="MODULE_NOT_FOUND",e}())),i.addMetaSchema(o(!function(){var e=new Error("Cannot find module 'ajv/lib/refs/json-schema-draft-06.json'");throw e.code="MODULE_NOT_FOUND",e}())))}catch(e){console.warn("Failed to create an instance of Ajv, JSON Schema validation is not available. Please use a JSONEditor bundle including Ajv, or pass an instance of Ajv as via the configuration option `ajv`.")}if(i){if(t){for(var n in t)i.removeSchema(n),t[n]&&i.addSchema(t[n],n);this.options.schemaRefs=t}this.validateSchema=i.compile(e),this.options.schema=e,this.validate()}this.refresh()}else this.validateSchema=null,this.options.schema=null,this.options.schemaRefs=null,this.validate(),this.refresh()},f.prototype.validate=function(){},f.prototype.refresh=function(){},f.registerMode=function(e){var t,i;if(Array.isArray(e))for(t=0;t<e.length;t++)f.registerMode(e[t]);else{if(!("mode"in e))throw new Error('Property "mode" missing');if(!("mixin"in e))throw new Error('Property "mixin" missing');if(!("data"in e))throw new Error('Property "data" missing');var n=e.mode;if(n in f.modes)throw new Error('Mode "'+n+'" already registered');if("function"!=typeof e.mixin.create)throw new Error('Required function "create" missing on mixin');var o=["setMode","registerMode","modes"];for(t=0;t<o.length;t++)if((i=o[t])in e.mixin)throw new Error('Reserved property "'+i+'" not allowed in mixin');f.modes[n]=e}},f.registerMode(r),f.registerMode(s),f.registerMode(a),f.ace=i,f.Ajv=p,f.VanillaPicker=n,f.default=f,e.exports=f},function(e,t){window.ace.define("ace/theme/jsoneditor",["require","exports","module","ace/lib/dom"],function(e,t,i){t.isDark=!1,t.cssClass="ace-jsoneditor",t.cssText='.ace-jsoneditor .ace_gutter {\nbackground: #ebebeb;\ncolor: #333\n}\n\n.ace-jsoneditor.ace_editor {\nfont-family: "dejavu sans mono", "droid sans mono", consolas, monaco, "lucida console", "courier new", courier, monospace, sans-serif;\nline-height: 1.3;\nbackground-color: #fff;\n}\n.ace-jsoneditor .ace_print-margin {\nwidth: 1px;\nbackground: #e8e8e8\n}\n.ace-jsoneditor .ace_scroller {\nbackground-color: #FFFFFF\n}\n.ace-jsoneditor .ace_text-layer {\ncolor: gray\n}\n.ace-jsoneditor .ace_variable {\ncolor: #1a1a1a\n}\n.ace-jsoneditor .ace_cursor {\nborder-left: 2px solid #000000\n}\n.ace-jsoneditor .ace_overwrite-cursors .ace_cursor {\nborder-left: 0px;\nborder-bottom: 1px solid #000000\n}\n.ace-jsoneditor .ace_marker-layer .ace_selection {\nbackground: lightgray\n}\n.ace-jsoneditor.ace_multiselect .ace_selection.ace_start {\nbox-shadow: 0 0 3px 0px #FFFFFF;\nborder-radius: 2px\n}\n.ace-jsoneditor .ace_marker-layer .ace_step {\nbackground: rgb(255, 255, 0)\n}\n.ace-jsoneditor .ace_marker-layer .ace_bracket {\nmargin: -1px 0 0 -1px;\nborder: 1px solid #BFBFBF\n}\n.ace-jsoneditor .ace_marker-layer .ace_active-line {\nbackground: #FFFBD1\n}\n.ace-jsoneditor .ace_gutter-active-line {\nbackground-color : #dcdcdc\n}\n.ace-jsoneditor .ace_marker-layer .ace_selected-word {\nborder: 1px solid lightgray\n}\n.ace-jsoneditor .ace_invisible {\ncolor: #BFBFBF\n}\n.ace-jsoneditor .ace_keyword,\n.ace-jsoneditor .ace_meta,\n.ace-jsoneditor .ace_support.ace_constant.ace_property-value {\ncolor: #AF956F\n}\n.ace-jsoneditor .ace_keyword.ace_operator {\ncolor: #484848\n}\n.ace-jsoneditor .ace_keyword.ace_other.ace_unit {\ncolor: #96DC5F\n}\n.ace-jsoneditor .ace_constant.ace_language {\ncolor: darkorange\n}\n.ace-jsoneditor .ace_constant.ace_numeric {\ncolor: red\n}\n.ace-jsoneditor .ace_constant.ace_character.ace_entity {\ncolor: #BF78CC\n}\n.ace-jsoneditor .ace_invalid {\ncolor: #FFFFFF;\nbackground-color: #FF002A;\n}\n.ace-jsoneditor .ace_fold {\nbackground-color: #AF956F;\nborder-color: #000000\n}\n.ace-jsoneditor .ace_storage,\n.ace-jsoneditor .ace_support.ace_class,\n.ace-jsoneditor .ace_support.ace_function,\n.ace-jsoneditor .ace_support.ace_other,\n.ace-jsoneditor .ace_support.ace_type {\ncolor: #C52727\n}\n.ace-jsoneditor .ace_string {\ncolor: green\n}\n.ace-jsoneditor .ace_comment {\ncolor: #BCC8BA\n}\n.ace-jsoneditor .ace_entity.ace_name.ace_tag,\n.ace-jsoneditor .ace_entity.ace_other.ace_attribute-name {\ncolor: #606060\n}\n.ace-jsoneditor .ace_markup.ace_underline {\ntext-decoration: underline\n}\n.ace-jsoneditor .ace_indent-guide {\nbackground: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y\n}',e("../lib/dom").importCssString(t.cssText,t.cssClass)})},function(e,t,i){t.tryRequireAjv=function(){try{return i(!function(){var e=new Error("Cannot find module 'ajv'");throw e.code="MODULE_NOT_FOUND",e}())}catch(e){}}},function(e,t,i){"use strict";i.r(t);var n=i(11),r=i.n(n);function o(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var s=function(){function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.locked=!1}return function(e,t,i){t&&o(e.prototype,t),i&&o(e,i)}(e,[{key:"highlight",value:function(e){this.locked||(this.node!==e&&(this.node&&this.node.setHighlight(!1),this.node=e,this.node.setHighlight(!0)),this._cancelUnhighlight())}},{key:"unhighlight",value:function(){if(!this.locked){var e=this;this.node&&(this._cancelUnhighlight(),this.unhighlightTimer=setTimeout(function(){e.node.setHighlight(!1),e.node=void 0,e.unhighlightTimer=void 0},0))}}},{key:"_cancelUnhighlight",value:function(){this.unhighlightTimer&&(clearTimeout(this.unhighlightTimer),this.unhighlightTimer=void 0)}},{key:"lock",value:function(){this.locked=!0}},{key:"unlock",value:function(){this.locked=!1}}]),e}(),M=i(0);function a(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var l=function(){function e(t){function r(e){return t.node.findNodeByInternalPath(e)}!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.editor=t,this.history=[],this.index=-1,this.clear(),this.actions={editField:{undo:function(e){r(e.parentPath).childs[e.index].updateField(e.oldValue)},redo:function(e){r(e.parentPath).childs[e.index].updateField(e.newValue)}},editValue:{undo:function(e){r(e.path).updateValue(e.oldValue)},redo:function(e){r(e.path).updateValue(e.newValue)}},changeType:{undo:function(e){r(e.path).changeType(e.oldType)},redo:function(e){r(e.path).changeType(e.newType)}},appendNodes:{undo:function(e){var t=r(e.parentPath);e.paths.map(r).forEach(function(e){t.removeChild(e)})},redo:function(e){var t=r(e.parentPath);e.nodes.forEach(function(e){t.appendChild(e)})}},insertBeforeNodes:{undo:function(e){var t=r(e.parentPath);e.paths.map(r).forEach(function(e){t.removeChild(e)})},redo:function(e){var t=r(e.parentPath),i=r(e.beforePath);e.nodes.forEach(function(e){t.insertBefore(e,i)})}},insertAfterNodes:{undo:function(e){var t=r(e.parentPath);e.paths.map(r).forEach(function(e){t.removeChild(e)})},redo:function(e){var t=r(e.parentPath),i=r(e.afterPath);e.nodes.forEach(function(e){t.insertAfter(e,i),i=e})}},removeNodes:{undo:function(e){var t=r(e.parentPath),i=t.childs[e.index]||t.append;e.nodes.forEach(function(e){t.insertBefore(e,i)})},redo:function(e){var t=r(e.parentPath);e.paths.map(r).forEach(function(e){t.removeChild(e)})}},duplicateNodes:{undo:function(e){var t=r(e.parentPath);e.clonePaths.map(r).forEach(function(e){t.removeChild(e)})},redo:function(e){var n=r(e.parentPath),o=r(e.afterPath);e.paths.map(r).forEach(function(e){var t=e.clone();if("object"===n.type){var i=n.getFieldNames();t.field=Object(M.findUniqueName)(e.field,i)}n.insertAfter(t,o),o=t})}},moveNodes:{undo:function(i){var n=r(i.oldParentPath),e=r(i.newParentPath),o=n.childs[i.oldIndex]||n.append;e.childs.slice(i.newIndex,i.newIndex+i.count).forEach(function(e,t){e.field=i.fieldNames[t],n.moveBefore(e,o)}),null===i.newParentPathRedo&&(i.newParentPathRedo=e.getInternalPath())},redo:function(i){var e=r(i.oldParentPathRedo),n=r(i.newParentPathRedo),o=n.childs[i.newIndexRedo]||n.append;e.childs.slice(i.oldIndexRedo,i.oldIndexRedo+i.count).forEach(function(e,t){e.field=i.fieldNames[t],n.moveBefore(e,o)})}},sort:{undo:function(e){var t=r(e.path);t.hideChilds(),t.childs=e.oldChilds,t.updateDom({updateIndexes:!0}),t.showChilds()},redo:function(e){var t=r(e.path);t.hideChilds(),t.childs=e.newChilds,t.updateDom({updateIndexes:!0}),t.showChilds()}},transform:{undo:function(e){r(e.path).setInternalValue(e.oldValue)},redo:function(e){r(e.path).setInternalValue(e.newValue)}}}}return function(e,t,i){t&&a(e.prototype,t),i&&a(e,i)}(e,[{key:"onChange",value:function(){}},{key:"add",value:function(e,t){this.index++,this.history[this.index]={action:e,params:t,timestamp:new Date},this.index<this.history.length-1&&this.history.splice(this.index+1,this.history.length-this.index-1),this.onChange()}},{key:"clear",value:function(){this.history=[],this.index=-1,this.onChange()}},{key:"canUndo",value:function(){return 0<=this.index}},{key:"canRedo",value:function(){return this.index<this.history.length-1}},{key:"undo",value:function(){if(this.canUndo()){var e=this.history[this.index];if(e){var t=this.actions[e.action];if(t&&t.undo){if(t.undo(e.params),e.params.oldSelection)try{this.editor.setDomSelection(e.params.oldSelection)}catch(e){console.error(e)}}else console.error(new Error('unknown action "'+e.action+'"'))}this.index--,this.onChange()}}},{key:"redo",value:function(){if(this.canRedo()){this.index++;var e=this.history[this.index];if(e){var t=this.actions[e.action];if(t&&t.redo){if(t.redo(e.params),e.params.newSelection)try{this.editor.setDomSelection(e.params.newSelection)}catch(e){console.error(e)}}else console.error(new Error('unknown action "'+e.action+'"'))}this.onChange()}}},{key:"destroy",value:function(){this.editor=null,this.history=[],this.index=-1}}]),e}(),h=i(1);function c(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var d=function(){function d(e,t){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,d);var i=this;this.editor=e,this.timeout=void 0,this.delay=200,this.lastText=void 0,this.results=null,this.dom={},this.dom.container=t;var n=document.createElement("div");(this.dom.wrapper=n).className="jsoneditor-search",t.appendChild(n);var o=document.createElement("div");(this.dom.results=o).className="jsoneditor-results",n.appendChild(o);var r=document.createElement("div");(this.dom.input=r).className="jsoneditor-frame",r.title=Object(h.c)("searchTitle"),n.appendChild(r);var s=document.createElement("button");s.type="button",s.className="jsoneditor-refresh",r.appendChild(s);var a=document.createElement("input");a.type="text",(this.dom.search=a).oninput=function(e){i._onDelayedSearch(e)},a.onchange=function(e){i._onSearch()},a.onkeydown=function(e){i._onKeyDown(e)},a.onkeyup=function(e){i._onKeyUp(e)},s.onclick=function(e){a.select()},r.appendChild(a);var l=document.createElement("button");l.type="button",l.title=Object(h.c)("searchNextResultTitle"),l.className="jsoneditor-next",l.onclick=function(){i.next()},r.appendChild(l);var c=document.createElement("button");c.type="button",c.title=Object(h.c)("searchPreviousResultTitle"),c.className="jsoneditor-previous",c.onclick=function(){i.previous()},r.appendChild(c)}return function(e,t,i){t&&c(e.prototype,t),i&&c(e,i)}(d,[{key:"next",value:function(e){if(this.results){var t=null!==this.resultIndex?this.resultIndex+1:0;t>this.results.length-1&&(t=0),this._setActiveResult(t,e)}}},{key:"previous",value:function(e){if(this.results){var t=this.results.length-1,i=null!==this.resultIndex?this.resultIndex-1:t;i<0&&(i=t),this._setActiveResult(i,e)}}},{key:"_setActiveResult",value:function(e,t){if(this.activeResult){var i=this.activeResult.node;"field"===this.activeResult.elem?delete i.searchFieldActive:delete i.searchValueActive,i.updateDom()}if(!this.results||!this.results[e])return this.resultIndex=void 0,void(this.activeResult=void 0);this.resultIndex=e;var n=this.results[this.resultIndex].node,o=this.results[this.resultIndex].elem;"field"===o?n.searchFieldActive=!0:n.searchValueActive=!0,this.activeResult=this.results[this.resultIndex],n.updateDom(),n.scrollTo(function(){t&&n.focus(o)})}},{key:"_clearDelay",value:function(){void 0!==this.timeout&&(clearTimeout(this.timeout),delete this.timeout)}},{key:"_onDelayedSearch",value:function(){this._clearDelay();var t=this;this.timeout=setTimeout(function(e){t._onSearch()},this.delay)}},{key:"_onSearch",value:function(e){this._clearDelay();var t=this.dom.search.value,i=0<t.length?t:void 0;if(i!==this.lastText||e){this.lastText=i,this.results=this.editor.search(i);var n=this.results[0]?this.results[0].node.MAX_SEARCH_RESULTS:1/0,o=0;if(this.activeResult)for(var r=0;r<this.results.length;r++)if(this.results[r].node===this.activeResult.node){o=r;break}if(this._setActiveResult(o,!1),void 0!==i){var s=this.results.length;this.dom.results.innerHTML=0===s?"no&nbsp;results":1===s?"1&nbsp;result":n<s?n+"+&nbsp;results":s+"&nbsp;results"}else this.dom.results.innerHTML=""}}},{key:"_onKeyDown",value:function(e){var t=e.which;27===t?(this.dom.search.value="",this._onSearch(),e.preventDefault(),e.stopPropagation()):13===t&&(e.ctrlKey?this._onSearch(!0):e.shiftKey?this.previous():this.next(),e.preventDefault(),e.stopPropagation())}},{key:"_onKeyUp",value:function(e){var t=e.keyCode;27!==t&&13!==t&&this._onDelayedSearch(e)}},{key:"clear",value:function(){this.dom.search.value="",this._onSearch()}},{key:"forceSearch",value:function(){this._onSearch(!0)}},{key:"isEmpty",value:function(){return""===this.dom.search.value}},{key:"destroy",value:function(){this.editor=null,this.dom.container.removeChild(this.dom.wrapper),this.dom=null,this.results=null,this.activeResult=null,this._clearDelay()}}]),d}(),u=i(3);function p(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var f=function(){function i(e,t){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,i),e&&(this.root=t,this.path=document.createElement("div"),this.path.className="jsoneditor-treepath",this.path.setAttribute("tabindex",0),this.contentMenuClicked=!1,e.appendChild(this.path),this.reset())}return function(e,t,i){t&&p(e.prototype,t),i&&p(e,i)}(i,[{key:"reset",value:function(){this.path.innerHTML=Object(h.c)("selectNode")}},{key:"setPath",value:function(s){var a=this;this.path.innerHTML="",s&&s.length&&s.forEach(function(i,n){var e,t=document.createElement("span");if(t.className="jsoneditor-treepath-element",t.innerText=i.name,t.onclick=function(e){this.selectionCallback&&this.selectionCallback(e)}.bind(a,i),a.path.appendChild(t),i.children.length&&((e=document.createElement("span")).className="jsoneditor-treepath-seperator",e.innerHTML="&#9658;",e.onclick=function(){a.contentMenuClicked=!0;var t=[];i.children.forEach(function(e){t.push({text:e.name,className:"jsoneditor-type-modes"+(s[n+1]+1&&s[n+1].name===e.name?" jsoneditor-selected":""),click:function(e,t){this.contextMenuCallback&&this.contextMenuCallback(e,t)}.bind(a,i,e.name)})}),new u.a(t).show(e,a.root,!0)},a.path.appendChild(e)),n===s.length-1){var o=(e||t).getBoundingClientRect().right;if(a.path.offsetWidth<o&&(a.path.scrollLeft=o),a.path.scrollLeft){var r=document.createElement("span");r.className="jsoneditor-treepath-show-all-btn",r.title="show all path",r.innerHTML="...",r.onclick=function(e){a.contentMenuClicked=!1,Object(M.addClassName)(a.path,"show-all"),a.path.style.width=a.path.parentNode.getBoundingClientRect().width-10+"px",a.path.onblur=function(){if(a.contentMenuClicked)return a.contentMenuClicked=!1,void a.path.focus();Object(M.removeClassName)(a.path,"show-all"),a.path.onblur=void 0,a.path.style.width="",a.setPath(e)}}.bind(a,s),a.path.insertBefore(r,a.path.firstChild)}}})}},{key:"onSectionSelected",value:function(e){"function"==typeof e&&(this.selectionCallback=e)}},{key:"onContextMenuItemSelected",value:function(e){"function"==typeof e&&(this.contextMenuCallback=e)}}]),i}(),m=i(4),v=i.n(m),g=i(9),y=i.n(g),b=i(10);var x=i(5),C=i(7),_=i(2);function E(e){return(E="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function w(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var j=function(){function P(e,t){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,P),this.editor=e,this.dom={},this.expanded=!1,t&&t instanceof Object?(this.setField(t.field,t.fieldEditable),"value"in t&&this.setValue(t.value,t.type),"internalValue"in t&&this.setInternalValue(t.internalValue)):(this.setField(""),this.setValue(null)),this._debouncedOnChangeValue=Object(M.debounce)(this._onChangeValue.bind(this),P.prototype.DEBOUNCE_INTERVAL),this._debouncedOnChangeField=Object(M.debounce)(this._onChangeField.bind(this),P.prototype.DEBOUNCE_INTERVAL),this.visibleChilds=this.getMaxVisibleChilds()}return function(e,t,i){t&&w(e.prototype,t),i&&w(e,i)}(P,[{key:"getMaxVisibleChilds",value:function(){return this.editor&&this.editor.options&&this.editor.options.maxVisibleChilds?this.editor.options.maxVisibleChilds:T}},{key:"_updateEditability",value:function(){if(this.editable={field:!0,value:!0},this.editor&&(this.editable.field="tree"===this.editor.options.mode,this.editable.value="view"!==this.editor.options.mode,("tree"===this.editor.options.mode||"form"===this.editor.options.mode)&&"function"==typeof this.editor.options.onEditable)){var e=this.editor.options.onEditable({field:this.field,value:this.value,path:this.getPath()});"boolean"==typeof e?(this.editable.field=e,this.editable.value=e):("boolean"==typeof e.field&&(this.editable.field=e.field),"boolean"==typeof e.value&&(this.editable.value=e.value))}}},{key:"getPath",value:function(){for(var e=this,t=[];e;){var i=e.getName();void 0!==i&&t.unshift(i),e=e.parent}return t}},{key:"getInternalPath",value:function(){for(var e=this,t=[];e;)e.parent&&t.unshift(e.getIndex()),e=e.parent;return t}},{key:"getName",value:function(){return this.parent?"array"!==this.parent.type?this.field:this.index:void 0}},{key:"findNodeByPath",value:function(e){if(e){if(0===e.length)return this;if(e.length&&this.childs&&this.childs.length)for(var t=0;t<this.childs.length;++t)if(""+e[0]==""+this.childs[t].getName())return this.childs[t].findNodeByPath(e.slice(1))}}},{key:"findNodeByInternalPath",value:function(e){if(e){for(var t=this,i=0;i<e.length&&t;i++){var n=e[i];t=t.childs[n]}return t}}},{key:"serialize",value:function(){return{value:this.getValue(),path:this.getPath()}}},{key:"findNode",value:function(e){for(var i=Object(M.parsePath)(e),n=this,t=function(){var t=i.shift();if("number"==typeof t){if("array"!==n.type)throw new Error("Cannot get child node at index "+t+": node is no array");n=n.childs[t]}else{if("object"!==n.type)throw new Error("Cannot get child node "+t+": node is no object");n=n.childs.filter(function(e){return e.field===t})[0]}};n&&0<i.length;)t();return n}},{key:"findParents",value:function(){for(var e=[],t=this.parent;t;)e.unshift(t),t=t.parent;return e}},{key:"setError",value:function(e,t){this.error=e,this.errorChild=t,this.dom&&this.dom.tr&&this.updateError()}},{key:"updateError",value:function(){var r=this,s=this.fieldError||this.valueError||this.error,e=this.dom.tdError;if(s&&this.dom&&this.dom.tr){Object(M.addClassName)(this.dom.tr,"jsoneditor-validation-error"),e||(e=document.createElement("td"),this.dom.tdError=e,this.dom.tdValue.parentNode.appendChild(e));var a=document.createElement("button");a.type="button",a.className="jsoneditor-button jsoneditor-schema-error";var t=function(){r.dom.popupAnchor&&r.dom.popupAnchor.destroy()},l=function(){delete r.dom.popupAnchor},i=function(e){var t=r.editor.frame;r.dom.popupAnchor=Object(b.a)(a,t,l,e);var i=a.getBoundingClientRect(),n=120<t.getBoundingClientRect().width-i.x?"jsoneditor-above":"jsoneditor-left",o=document.createElement("div");o.className="jsoneditor-popover "+n,o.appendChild(document.createTextNode(s.message)),r.dom.popupAnchor.appendChild(o)};a.onmouseover=function(){r.dom.popupAnchor||i(!0)},a.onfocus=function(){t(),i(!1)},a.onblur=function(){t()};var n=this.errorChild;for(n&&(a.onclick=function(){n.findParents().forEach(function(e){e.expand(!1)}),n.scrollTo(function(){n.focus()})});e.firstChild;)e.removeChild(e.firstChild);e.appendChild(a)}else this.dom.tr&&Object(M.removeClassName)(this.dom.tr,"jsoneditor-validation-error"),e&&(this.dom.tdError.parentNode.removeChild(this.dom.tdError),delete this.dom.tdError)}},{key:"getIndex",value:function(){if(this.parent){var e=this.parent.childs.indexOf(this);return-1!==e?e:null}return-1}},{key:"setParent",value:function(e){this.parent=e}},{key:"setField",value:function(e,t){this.field=e,this.previousField=e,this.fieldEditable=!0===t}},{key:"getField",value:function(){return void 0===this.field&&this._getDomField(),this.field}},{key:"setValue",value:function(e,t){var i,n,o,r,s,a=this.childs;if(this.type=this._getType(e),t&&t!==this.type){if("string"!==t||"auto"!==this.type)throw new Error('Type mismatch: cannot cast value of type "'+this.type+' to the specified type "'+t+'"');this.type=t}if("array"===this.type){for(this.childs||(this.childs=[]),r=0;r<e.length;r++)void 0===(i=e[r])||i instanceof Function||(r<this.childs.length?((n=this.childs[r]).fieldEditable=!1,n.index=r,n.setValue(i)):(n=new P(this.editor,{value:i}),o=r<this.getMaxVisibleChilds(),this.appendChild(n,o,!1)));for(s=this.childs.length;s>=e.length;s--)this.removeChild(this.childs[s],!1)}else if("object"===this.type){for(this.childs||(this.childs=[]),s=this.childs.length-1;0<=s;s--)N(e,this.childs[s].field)||this.removeChild(this.childs[s],!1);for(var l in r=0,e)N(e,l)&&(void 0===(i=e[l])||i instanceof Function||((n=this.findChildByProperty(l))?(n.setField(l,!0),n.setValue(i)):(n=new P(this.editor,{field:l,value:i}),o=r<this.getMaxVisibleChilds(),this.appendChild(n,o,!1))),r++);!(this.value="")===this.editor.options.sortObjectKeys&&this.sort([],"asc")}else this.hideChilds(),delete this.append,delete this.showMore,delete this.expanded,delete this.childs,this.value=e;Array.isArray(a)!==Array.isArray(this.childs)&&this.recreateDom(),this.updateDom({updateIndexes:!0}),this.previousValue=this.value}},{key:"setInternalValue",value:function(e){var t,i,n,o,r,s=this.childs;if(this.type=e.type,"array"===e.type){for(this.childs||(this.childs=[]),o=0;o<e.childs.length;o++)void 0===(t=e.childs[o])||t instanceof Function||(o<this.childs.length?((i=this.childs[o]).fieldEditable=!1,i.index=o,i.setInternalValue(t)):(i=new P(this.editor,{internalValue:t}),n=o<this.getMaxVisibleChilds(),this.appendChild(i,n,!1)));for(r=this.childs.length;r>=e.childs.length;r--)this.removeChild(this.childs[r],!1)}else if("object"===e.type){for(this.childs||(this.childs=[]),o=0;o<e.childs.length;o++)void 0===(t=e.childs[o])||t instanceof Function||(o<this.childs.length?(delete(i=this.childs[o]).index,i.setField(t.field,!0),i.setInternalValue(t.value)):(i=new P(this.editor,{field:t.field,internalValue:t.value}),n=o<this.getMaxVisibleChilds(),this.appendChild(i,n,!1)));for(r=this.childs.length;r>=e.childs.length;r--)this.removeChild(this.childs[r],!1)}else this.hideChilds(),delete this.append,delete this.showMore,delete this.expanded,delete this.childs,this.value=e.value;Array.isArray(s)!==Array.isArray(this.childs)&&this.recreateDom(),this.updateDom({updateIndexes:!0}),this.previousValue=this.value}},{key:"recreateDom",value:function(){if(this.dom&&this.dom.tr&&this.dom.tr.parentNode){var e=this._detachFromDom();this.clearDom(),this._attachToDom(e)}else this.clearDom()}},{key:"getValue",value:function(){if("array"===this.type){var t=[];return this.childs.forEach(function(e){t.push(e.getValue())}),t}if("object"!==this.type)return void 0===this.value&&this._getDomValue(),this.value;var i={};return this.childs.forEach(function(e){i[e.getField()]=e.getValue()}),i}},{key:"getInternalValue",value:function(){return"array"===this.type?{type:this.type,childs:this.childs.map(function(e){return e.getInternalValue()})}:"object"===this.type?{type:this.type,childs:this.childs.map(function(e){return{field:e.getField(),value:e.getInternalValue()}})}:(void 0===this.value&&this._getDomValue(),{type:this.type,value:this.value})}},{key:"getLevel",value:function(){return this.parent?this.parent.getLevel()+1:0}},{key:"getNodePath",value:function(){var e=this.parent?this.parent.getNodePath():[];return e.push(this),e}},{key:"clone",value:function(){var i=new P(this.editor);if(i.type=this.type,i.field=this.field,i.fieldInnerText=this.fieldInnerText,i.fieldEditable=this.fieldEditable,i.previousField=this.previousField,i.value=this.value,i.valueInnerText=this.valueInnerText,i.previousValue=this.previousValue,i.expanded=this.expanded,i.visibleChilds=this.visibleChilds,this.childs){var n=[];this.childs.forEach(function(e){var t=e.clone();t.setParent(i),n.push(t)}),i.childs=n}else i.childs=void 0;return i}},{key:"expand",value:function(t){this.childs&&(this.expanded=!0,this.dom.expand&&(this.dom.expand.className="jsoneditor-button jsoneditor-expanded"),this.showChilds(),!1!==t&&this.childs.forEach(function(e){e.expand(t)}))}},{key:"collapse",value:function(t){this.childs&&(this.hideChilds(),!1!==t&&this.childs.forEach(function(e){e.collapse(t)}),this.dom.expand&&(this.dom.expand.className="jsoneditor-button jsoneditor-collapsed"),this.expanded=!1)}},{key:"showChilds",value:function(){if(this.childs&&this.expanded){var e,t=this.dom.tr,i=t?t.parentNode:void 0;if(i){var n=this.getAppendDom();n.parentNode||((e=t.nextSibling)?i.insertBefore(n,e):i.appendChild(n));var o=Math.min(this.childs.length,this.visibleChilds);e=this._getNextTr();for(var r=0;r<o;r++){var s=this.childs[r];s.getDom().parentNode||i.insertBefore(s.getDom(),e),s.showChilds()}var a=this.getShowMoreDom();e=this._getNextTr(),a.parentNode||i.insertBefore(a,e),this.showMore.updateDom()}}}},{key:"_getNextTr",value:function(){return this.showMore&&this.showMore.getDom().parentNode?this.showMore.getDom():this.append&&this.append.getDom().parentNode?this.append.getDom():void 0}},{key:"hide",value:function(e){var t=this.dom.tr,i=t?t.parentNode:void 0;i&&i.removeChild(t),this.dom.popupAnchor&&this.dom.popupAnchor.destroy(),this.hideChilds(e)}},{key:"hideChilds",value:function(e){if(this.childs&&this.expanded){var t=this.getAppendDom();t.parentNode&&t.parentNode.removeChild(t),this.childs.forEach(function(e){e.hide()});var i=this.getShowMoreDom();i.parentNode&&i.parentNode.removeChild(i),e&&!e.resetVisibleChilds||(this.visibleChilds=this.getMaxVisibleChilds())}}},{key:"_updateCssClassName",value:function(){if(this.dom.field&&this.editor&&this.editor.options&&"function"==typeof this.editor.options.onClassName&&this.dom.tree){Object(M.removeAllClassNames)(this.dom.tree);var e=this.editor.options.onClassName({path:this.getPath(),field:this.field,value:this.value})||"";Object(M.addClassName)(this.dom.tree,"jsoneditor-values "+e)}}},{key:"recursivelyUpdateCssClassesOnNodes",value:function(){if(this._updateCssClassName(),Array.isArray(this.childs))for(var e=0;e<this.childs.length;e++)this.childs[e].recursivelyUpdateCssClassesOnNodes()}},{key:"expandTo",value:function(){for(var e=this.parent;e;)e.expanded||e.expand(),e=e.parent}},{key:"appendChild",value:function(e,t,i){if(this._hasChilds()){if(e.setParent(this),e.fieldEditable="object"===this.type,"array"===this.type&&(e.index=this.childs.length),"object"===this.type&&void 0===e.field&&e.setField(""),this.childs.push(e),this.expanded&&!1!==t){var n=e.getDom(),o=this._getNextTr(),r=o?o.parentNode:void 0;o&&r&&r.insertBefore(n,o),e.showChilds(),this.visibleChilds++}!1!==i&&(this.updateDom({updateIndexes:!0}),e.updateDom({recurse:!0}))}}},{key:"moveBefore",value:function(e,t){if(this._hasChilds()){var i=this.dom.tr?this.dom.tr.parentNode:void 0;if(i){var n=document.createElement("tr");n.style.height=i.clientHeight+"px",i.appendChild(n)}if(e.parent&&e.parent.removeChild(e),t instanceof L||!t)if(this.childs.length+1>this.visibleChilds){var o=this.childs[this.visibleChilds-1];this.insertBefore(e,o)}else this.appendChild(e);else this.insertBefore(e,t);i&&i.removeChild(n)}}},{key:"insertBefore",value:function(e,t){if(this._hasChilds()){if(this.visibleChilds++,"object"===this.type&&void 0===e.field&&e.setField(""),t===this.append)e.setParent(this),e.fieldEditable="object"===this.type,this.childs.push(e);else{var i=this.childs.indexOf(t);if(-1===i)throw new Error("Node not found");e.setParent(this),e.fieldEditable="object"===this.type,this.childs.splice(i,0,e)}if(this.expanded){var n=e.getDom(),o=t.getDom(),r=o?o.parentNode:void 0;o&&r&&r.insertBefore(n,o),e.showChilds(),this.showChilds()}this.updateDom({updateIndexes:!0}),e.updateDom({recurse:!0})}}},{key:"insertAfter",value:function(e,t){if(this._hasChilds()){var i=this.childs.indexOf(t),n=this.childs[i+1];n?this.insertBefore(e,n):this.appendChild(e)}}},{key:"search",value:function(t,i){Array.isArray(i)||(i=[]);var e=t?t.toLowerCase():void 0;delete this.searchField,delete this.searchValue,void 0!==this.field&&i.length<=this.MAX_SEARCH_RESULTS&&(-1!==String(this.field).toLowerCase().indexOf(e)&&(this.searchField=!0,i.push({node:this,elem:"field"})),this._updateDomField());this._hasChilds()?this.childs&&this.childs.forEach(function(e){e.search(t,i)}):void 0!==this.value&&i.length<=this.MAX_SEARCH_RESULTS&&(-1!==String(this.value).toLowerCase().indexOf(e)&&(this.searchValue=!0,i.push({node:this,elem:"value"})),this._updateDomValue());return i}},{key:"scrollTo",value:function(e){this.expandPathToNode(),this.dom.tr&&this.dom.tr.parentNode&&this.editor.scrollTo(this.dom.tr.offsetTop,e)}},{key:"expandPathToNode",value:function(){for(var e=this;e&&e.parent;){for(var t="array"===e.parent.type?e.index:e.parent.childs.indexOf(e);e.parent.visibleChilds<t+1;)e.parent.visibleChilds+=this.getMaxVisibleChilds();e.parent.expand(!1),e=e.parent}}},{key:"focus",value:function(e){if(P.focusElement=e,this.dom.tr&&this.dom.tr.parentNode){var t=this.dom;switch(e){case"drag":t.drag?t.drag.focus():t.menu.focus();break;case"menu":t.menu.focus();break;case"expand":this._hasChilds()?t.expand.focus():t.field&&this.fieldEditable?(t.field.focus(),Object(M.selectContentEditable)(t.field)):t.value&&!this._hasChilds()?(t.value.focus(),Object(M.selectContentEditable)(t.value)):t.menu.focus();break;case"field":t.field&&this.fieldEditable?(t.field.focus(),Object(M.selectContentEditable)(t.field)):t.value&&!this._hasChilds()?(t.value.focus(),Object(M.selectContentEditable)(t.value)):this._hasChilds()?t.expand.focus():t.menu.focus();break;case"value":default:t.select?t.select.focus():t.value&&!this._hasChilds()?(t.value.focus(),Object(M.selectContentEditable)(t.value)):t.field&&this.fieldEditable?(t.field.focus(),Object(M.selectContentEditable)(t.field)):this._hasChilds()?t.expand.focus():t.menu.focus()}}}},{key:"containsNode",value:function(e){if(this===e)return!0;var t=this.childs;if(t)for(var i=0,n=t.length;i<n;i++)if(t[i].containsNode(e))return!0;return!1}},{key:"removeChild",value:function(e,t){if(this.childs){var i=this.childs.indexOf(e);if(-1!==i){i<this.visibleChilds&&this.expanded&&this.visibleChilds--,e.hide(),delete e.searchField,delete e.searchValue;var n=this.childs.splice(i,1)[0];return n.parent=null,!1!==t&&this.updateDom({updateIndexes:!0}),n}}}},{key:"_remove",value:function(e){this.removeChild(e)}},{key:"changeType",value:function(e){var t=this.type;if(t!==e){if("string"!==e&&"auto"!==e||"string"!==t&&"auto"!==t){var i=this._detachFromDom();this.clearDom(),"object"===(this.type=e)?(this.childs||(this.childs=[]),this.childs.forEach(function(e){e.clearDom(),delete e.index,e.fieldEditable=!0,void 0===e.field&&(e.field="")}),"string"!==t&&"auto"!==t||(this.expanded=!0)):"array"===e?(this.childs||(this.childs=[]),this.childs.forEach(function(e,t){e.clearDom(),e.fieldEditable=!1,e.index=t}),"string"!==t&&"auto"!==t||(this.expanded=!0)):this.expanded=!1,this._attachToDom(i)}else this.type=e;"auto"!==e&&"string"!==e||(this.value="string"===e?String(this.value):Object(M.parseString)(String(this.value)),this.focus()),this.updateDom({updateIndexes:!0})}}},{key:"deepEqual",value:function(e){var t;if("array"===this.type){if(!Array.isArray(e))return!1;if(this.childs.length!==e.length)return!1;for(t=0;t<this.childs.length;t++)if(!this.childs[t].deepEqual(e[t]))return!1}else if("object"===this.type){if("object"!==E(e)||!e)return!1;var i={},n=0;for(t=0;t<this.childs.length;t++){var o=this.childs[t];if(!i[o.field]){if(i[o.field]=!0,n++,!(o.field in e))return!1;if(!o.deepEqual(e[o.field]))return!1}}if(n!==Object.keys(e).length)return!1}else if(this.value!==e)return!1;return!0}},{key:"_getDomValue",value:function(){if(this._clearValueError(),this.dom.value&&"array"!==this.type&&"object"!==this.type&&(this.valueInnerText=Object(M.getInnerText)(this.dom.value)),void 0!==this.valueInnerText)try{var e;if("string"===this.type)e=this._unescapeHTML(this.valueInnerText);else{var t=this._unescapeHTML(this.valueInnerText);e=Object(M.parseString)(t)}e!==this.value&&(this.value=e,this._debouncedOnChangeValue())}catch(e){this._setValueError(Object(h.c)("cannotParseValueError"))}}},{key:"_setValueError",value:function(e){this.valueError={message:e},this.updateError()}},{key:"_clearValueError",value:function(){this.valueError&&(this.valueError=null,this.updateError())}},{key:"_setFieldError",value:function(e){this.fieldError={message:e},this.updateError()}},{key:"_clearFieldError",value:function(){this.fieldError&&(this.fieldError=null,this.updateError())}},{key:"_onChangeValue",value:function(){var e=this.editor.getDomSelection();if(e.range){var t=Object(M.textDiff)(String(this.value),String(this.previousValue));e.range.startOffset=t.start,e.range.endOffset=t.end}var i=this.editor.getDomSelection();if(i.range){var n=Object(M.textDiff)(String(this.previousValue),String(this.value));i.range.startOffset=n.start,i.range.endOffset=n.end}this.editor._onAction("editValue",{path:this.getInternalPath(),oldValue:this.previousValue,newValue:this.value,oldSelection:e,newSelection:i}),this.previousValue=this.value}},{key:"_onChangeField",value:function(){var e=this.editor.getDomSelection(),t=this.previousField||"";if(e.range){var i=Object(M.textDiff)(this.field,t);e.range.startOffset=i.start,e.range.endOffset=i.end}var n=this.editor.getDomSelection();if(n.range){var o=Object(M.textDiff)(t,this.field);n.range.startOffset=o.start,n.range.endOffset=o.end}this.editor._onAction("editField",{parentPath:this.parent.getInternalPath(),index:this.getIndex(),oldValue:this.previousField,newValue:this.field,oldSelection:e,newSelection:n}),this.previousField=this.field}},{key:"_updateDomValue",value:function(){var e=this.dom.value;if(e){var t=["jsoneditor-value"],i=this.value,n="auto"===this.type?Object(M.getType)(i):this.type,o="string"===n&&Object(M.isUrl)(i);if(t.push("jsoneditor-"+n),o&&t.push("jsoneditor-url"),""===String(this.value)&&"array"!==this.type&&"object"!==this.type&&t.push("jsoneditor-empty"),this.searchValueActive&&t.push("jsoneditor-highlight-active"),this.searchValue&&t.push("jsoneditor-highlight"),e.className=t.join(" "),"array"===n||"object"===n){var r=this.childs?this.childs.length:0;e.title=this.type+" containing "+r+" items"}else o&&this.editable.value?e.title=Object(h.c)("openUrl"):e.title="";if("boolean"===n&&this.editable.value?(this.dom.checkbox||(this.dom.checkbox=document.createElement("input"),this.dom.checkbox.type="checkbox",this.dom.tdCheckbox=document.createElement("td"),this.dom.tdCheckbox.className="jsoneditor-tree",this.dom.tdCheckbox.appendChild(this.dom.checkbox),this.dom.tdValue.parentNode.insertBefore(this.dom.tdCheckbox,this.dom.tdValue)),this.dom.checkbox.checked=this.value):this.dom.tdCheckbox&&(this.dom.tdCheckbox.parentNode.removeChild(this.dom.tdCheckbox),delete this.dom.tdCheckbox,delete this.dom.checkbox),this.enum&&this.editable.value){if(!this.dom.select){this.dom.select=document.createElement("select"),this.id=this.field+"_"+(new Date).getUTCMilliseconds(),this.dom.select.id=this.id,this.dom.select.name=this.dom.select.id,this.dom.select.option=document.createElement("option"),this.dom.select.option.value="",this.dom.select.option.innerHTML="--",this.dom.select.appendChild(this.dom.select.option);for(var s=0;s<this.enum.length;s++)this.dom.select.option=document.createElement("option"),this.dom.select.option.value=this.enum[s],this.dom.select.option.innerHTML=this.enum[s],this.dom.select.option.value===this.value&&(this.dom.select.option.selected=!0),this.dom.select.appendChild(this.dom.select.option);this.dom.tdSelect=document.createElement("td"),this.dom.tdSelect.className="jsoneditor-tree",this.dom.tdSelect.appendChild(this.dom.select),this.dom.tdValue.parentNode.insertBefore(this.dom.tdSelect,this.dom.tdValue)}!this.schema||N(this.schema,"oneOf")||N(this.schema,"anyOf")||N(this.schema,"allOf")?delete this.valueFieldHTML:(this.valueFieldHTML=this.dom.tdValue.innerHTML,this.dom.tdValue.style.visibility="hidden",this.dom.tdValue.innerHTML="")}else this.dom.tdSelect&&(this.dom.tdSelect.parentNode.removeChild(this.dom.tdSelect),delete this.dom.tdSelect,delete this.dom.select,this.dom.tdValue.innerHTML=this.valueFieldHTML,this.dom.tdValue.style.visibility="",delete this.valueFieldHTML);this.editable.value&&this.editor.options.colorPicker&&"string"==typeof i&&Object(M.isValidColor)(i)?(this.dom.color||(this.dom.color=document.createElement("div"),this.dom.color.className="jsoneditor-color",this.dom.tdColor=document.createElement("td"),this.dom.tdColor.className="jsoneditor-tree",this.dom.tdColor.appendChild(this.dom.color),this.dom.tdValue.parentNode.insertBefore(this.dom.tdColor,this.dom.tdValue),this.dom.value.style.color="#1A1A1A"),this.dom.color.style.backgroundColor=i):this._deleteDomColor(),this.editor.options.timestampTag&&"number"==typeof i&&9466848e5<i&&!isNaN(new Date(i).valueOf())?(this.dom.date||(this.dom.date=document.createElement("div"),this.dom.date.className="jsoneditor-date",this.dom.value.parentNode.appendChild(this.dom.date)),this.dom.date.innerHTML=new Date(i).toISOString(),this.dom.date.title=new Date(i).toString()):this.dom.date&&(this.dom.date.parentNode.removeChild(this.dom.date),delete this.dom.date),Object(M.stripFormatting)(e),this._updateDomDefault()}}},{key:"_deleteDomColor",value:function(){this.dom.color&&(this.dom.tdColor.parentNode.removeChild(this.dom.tdColor),delete this.dom.tdColor,delete this.dom.color,this.dom.value.style.color="")}},{key:"_updateDomField",value:function(){var e=this.dom.field;if(e){var t=Object(M.makeFieldTooltip)(this.schema,this.editor.options.language);t&&(e.title=t),""===String(this.field)&&"array"!==this.parent.type?Object(M.addClassName)(e,"jsoneditor-empty"):Object(M.removeClassName)(e,"jsoneditor-empty"),this.searchFieldActive?Object(M.addClassName)(e,"jsoneditor-highlight-active"):Object(M.removeClassName)(e,"jsoneditor-highlight-active"),this.searchField?Object(M.addClassName)(e,"jsoneditor-highlight"):Object(M.removeClassName)(e,"jsoneditor-highlight"),Object(M.stripFormatting)(e)}}},{key:"_getDomField",value:function(e){if(this._clearFieldError(),this.dom.field&&this.fieldEditable&&(this.fieldInnerText=Object(M.getInnerText)(this.dom.field)),void 0!==this.fieldInnerText)try{var t=this._unescapeHTML(this.fieldInnerText),i=this.parent.getFieldNames(this);-1!==i.indexOf(t)?e?(t=Object(M.findUniqueName)(t,i))!==this.field&&(this.field=t,this._debouncedOnChangeField()):this._setFieldError(Object(h.c)("duplicateFieldError")):t!==this.field&&(this.field=t,this._debouncedOnChangeField())}catch(e){this._setFieldError(Object(h.c)("cannotParseFieldError"))}}},{key:"_updateDomDefault",value:function(){if(this.schema&&void 0!==this.schema.default&&!this._hasChilds()){var e=this.dom.select?this.dom.select:this.dom.value;e&&(this.value===this.schema.default?(e.title=Object(h.c)("default"),Object(M.addClassName)(e,"jsoneditor-is-default"),Object(M.removeClassName)(e,"jsoneditor-is-not-default")):(e.removeAttribute("title"),Object(M.removeClassName)(e,"jsoneditor-is-default"),Object(M.addClassName)(e,"jsoneditor-is-not-default")))}}},{key:"clearDom",value:function(){this.dom={}}},{key:"getDom",value:function(){var e=this.dom;if(e.tr)return e.tr;if(this._updateEditability(),e.tr=document.createElement("tr"),"tree"===(e.tr.node=this).editor.options.mode){var t=document.createElement("td");if(this.editable.field&&this.parent){var i=document.createElement("button");i.type="button",(e.drag=i).className="jsoneditor-button jsoneditor-dragarea",i.title=Object(h.c)("drag"),t.appendChild(i)}e.tr.appendChild(t);var n=document.createElement("td"),o=document.createElement("button");o.type="button",(e.menu=o).className="jsoneditor-button jsoneditor-contextmenu-button",o.title=Object(h.c)("actionsMenu"),n.appendChild(e.menu),e.tr.appendChild(n)}var r=document.createElement("td");return e.tr.appendChild(r),e.tree=this._createDomTree(),r.appendChild(e.tree),this.updateDom({updateIndexes:!0}),e.tr}},{key:"isVisible",value:function(){return this.dom&&this.dom.tr&&this.dom.tr.parentNode||!1}},{key:"isDescendantOf",value:function(e){for(var t=this.parent;t;){if(t===e)return!0;t=t.parent}return!1}},{key:"_createDomField",value:function(){return document.createElement("div")}},{key:"setHighlight",value:function(t){this.dom.tr&&(t?Object(M.addClassName)(this.dom.tr,"jsoneditor-highlight"):Object(M.removeClassName)(this.dom.tr,"jsoneditor-highlight"),this.append&&this.append.setHighlight(t),this.childs&&this.childs.forEach(function(e){e.setHighlight(t)}))}},{key:"setSelected",value:function(t,e){this.selected=t,this.dom.tr&&(t?Object(M.addClassName)(this.dom.tr,"jsoneditor-selected"):Object(M.removeClassName)(this.dom.tr,"jsoneditor-selected"),e?Object(M.addClassName)(this.dom.tr,"jsoneditor-first"):Object(M.removeClassName)(this.dom.tr,"jsoneditor-first"),this.append&&this.append.setSelected(t),this.showMore&&this.showMore.setSelected(t),this.childs&&this.childs.forEach(function(e){e.setSelected(t)}))}},{key:"updateValue",value:function(e){this.value=e,this.previousValue=e,this.valueError=void 0,this.updateDom()}},{key:"updateField",value:function(e){this.field=e,this.previousField=e,this.fieldError=void 0,this.updateDom()}},{key:"updateDom",value:function(t){var e=this.dom.tree;e&&(e.style.marginLeft=24*this.getLevel()+"px");var i=this.dom.field;if(i){var n;if(this.fieldEditable?(i.contentEditable=this.editable.field,i.spellcheck=!1,i.className="jsoneditor-field"):(i.contentEditable=!1,i.className="jsoneditor-readonly"),void 0!==this.index)n=this.index;else if(void 0!==this.field)n=this.field;else{var o=this.editor.options.schema?P._findSchema(this.editor.options.schema,this.editor.options.schemaRefs||{},this.getPath()):void 0;n=o&&o.title?o.title:this._hasChilds()?this.type:""}i.innerHTML=this._escapeHTML(n),this._updateSchema()}var r=this.dom.value;r&&("array"===this.type?(this.updateNodeName(),Object(M.addClassName)(this.dom.tr,"jsoneditor-expandable")):"object"===this.type?(this.updateNodeName(),Object(M.addClassName)(this.dom.tr,"jsoneditor-expandable")):(r.innerHTML=this._escapeHTML(this.value),Object(M.removeClassName)(this.dom.tr,"jsoneditor-expandable"))),this._updateDomField(),this._updateDomValue(),this._updateCssClassName(),t&&!0===t.updateIndexes&&this._updateDomIndexes(),t&&!0===t.recurse&&this.childs&&this.childs.forEach(function(e){e.updateDom(t)}),this.error&&this.updateError(),this.append&&this.append.updateDom(),this.showMore&&this.showMore.updateDom()}},{key:"_updateSchema",value:function(){this.editor&&this.editor.options&&(this.schema=this.editor.options.schema?P._findSchema(this.editor.options.schema,this.editor.options.schemaRefs||{},this.getPath()):null,this.schema?this.enum=P._findEnum(this.schema):delete this.enum)}},{key:"_updateDomIndexes",value:function(){var e=this.dom.value,t=this.childs;e&&t&&("array"===this.type?t.forEach(function(e,t){e.index=t;var i=e.dom.field;i&&(i.innerHTML=t)}):"object"===this.type&&t.forEach(function(e){void 0!==e.index&&(delete e.index,void 0===e.field&&(e.field=""))}))}},{key:"_createDomValue",value:function(){var e;return"array"===this.type?(e=document.createElement("div")).innerHTML="[...]":"object"===this.type?(e=document.createElement("div")).innerHTML="{...}":(!this.editable.value&&Object(M.isUrl)(this.value)?(e=document.createElement("a")).href=this.value:((e=document.createElement("div")).contentEditable=this.editable.value,e.spellcheck=!1),e.innerHTML=this._escapeHTML(this.value)),e}},{key:"_createDomExpandButton",value:function(){var e=document.createElement("button");return e.type="button",this._hasChilds()?(e.className=this.expanded?"jsoneditor-button jsoneditor-expanded":"jsoneditor-button jsoneditor-collapsed",e.title=Object(h.c)("expandTitle")):(e.className="jsoneditor-button jsoneditor-invisible",e.title=""),e}},{key:"_createDomTree",value:function(){var e=this.dom,t=document.createElement("table"),i=document.createElement("tbody");t.style.borderCollapse="collapse",t.className="jsoneditor-values",t.appendChild(i);var n=document.createElement("tr");i.appendChild(n);var o=document.createElement("td");o.className="jsoneditor-tree",n.appendChild(o),e.expand=this._createDomExpandButton(),o.appendChild(e.expand),e.tdExpand=o;var r=document.createElement("td");r.className="jsoneditor-tree",n.appendChild(r),e.field=this._createDomField(),r.appendChild(e.field),e.tdField=r;var s=document.createElement("td");s.className="jsoneditor-tree",n.appendChild(s),"object"!==this.type&&"array"!==this.type&&(s.appendChild(document.createTextNode(":")),s.className="jsoneditor-separator"),e.tdSeparator=s;var a=document.createElement("td");return a.className="jsoneditor-tree",n.appendChild(a),e.value=this._createDomValue(),a.appendChild(e.value),e.tdValue=a,t}},{key:"onEvent",value:function(e){var t=e.type,i=e.target||e.srcElement,n=this.dom,o=this,r=this._hasChilds();if("function"==typeof this.editor.options.onEvent&&this._onEvent(e),i!==n.drag&&i!==n.menu||("mouseover"===t?this.editor.highlighter.highlight(this):"mouseout"===t&&this.editor.highlighter.unhighlight()),"click"===t&&i===n.menu){var s=o.editor.highlighter;s.highlight(o),s.lock(),Object(M.addClassName)(n.menu,"jsoneditor-selected"),this.showContextMenu(n.menu,function(){Object(M.removeClassName)(n.menu,"jsoneditor-selected"),s.unlock(),s.unhighlight()})}if("click"===t&&i===n.expand&&r){var a=e.ctrlKey;this._onExpand(a)}"click"!==t||e.target!==o.dom.tdColor&&e.target!==o.dom.color||this._showColorPicker(),"change"===t&&i===n.checkbox&&(this.dom.value.innerHTML=!this.value,this._getDomValue(),this._updateDomDefault()),
"change"===t&&i===n.select&&(this.dom.value.innerHTML=n.select.value,this._getDomValue(),this._updateDomValue());var l=n.value;if(i===l)switch(t){case"blur":case"change":this._getDomValue(),this._clearValueError(),this._updateDomValue();var c=this._escapeHTML(this.value);l.innerHTML!==c&&(l.innerHTML=c);break;case"input":this._getDomValue(),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getDomSelection();break;case"click":e.ctrlKey&&this.editable.value&&Object(M.isUrl)(this.value)&&(e.preventDefault(),window.open(this.value,"_blank"));break;case"keyup":this._getDomValue(),this._updateDomValue();break;case"cut":case"paste":setTimeout(function(){o._getDomValue(),o._updateDomValue()},1)}var d=n.field;if(i===d)switch(t){case"blur":this._getDomField(!0),this._updateDomField();var h=this._escapeHTML(this.field);d.innerHTML!==h&&(d.innerHTML=h);break;case"input":this._getDomField(),this._updateSchema(),this._updateDomField(),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getDomSelection();break;case"keyup":this._getDomField(),this._updateDomField();break;case"cut":case"paste":setTimeout(function(){o._getDomField(),o._updateDomField()},1)}var u=n.tree;u&&i===u.parentNode&&"click"===t&&!e.hasMoved&&((void 0!==e.offsetX?e.offsetX<24*(this.getLevel()+1):e.pageX<Object(M.getAbsoluteLeft)(n.tdSeparator))||r?d&&(Object(M.setEndOfContentEditable)(d),d.focus()):l&&!this.enum&&(Object(M.setEndOfContentEditable)(l),l.focus()));(i!==n.tdExpand||r)&&i!==n.tdField&&i!==n.tdSeparator||"click"!==t||e.hasMoved||d&&(Object(M.setEndOfContentEditable)(d),d.focus()),"keydown"===t&&this.onKeyDown(e)}},{key:"_onEvent",value:function(e){var t=e.target;if(t===this.dom.field||t===this.dom.value){var i={field:this.getField(),path:this.getPath()};this._hasChilds()||t!==this.dom.value||(i.value=this.getValue()),this.editor.options.onEvent(i,e)}}},{key:"onKeyDown",value:function(e){var t,i,n,o,r,s,a,l,c,d,h,u,p,f=e.which||e.keyCode,m=e.target||e.srcElement,v=e.ctrlKey,g=e.shiftKey,y=e.altKey,b=!1,x="tree"===this.editor.options.mode,C=0<this.editor.multiselection.nodes.length?this.editor.multiselection.nodes:[this],_=C[0],E=C[C.length-1];if(13===f){if(m===this.dom.value)this.editable.value&&!e.ctrlKey||Object(M.isUrl)(this.value)&&(window.open(this.value,"_blank"),b=!0);else if(m===this.dom.expand){if(this._hasChilds()){var w=e.ctrlKey;this._onExpand(w),m.focus(),b=!0}}}else if(68===f)v&&x&&(P.onDuplicate(C),b=!0);else if(69===f)v&&(this._onExpand(g),m.focus(),b=!0);else if(77===f&&x)v&&(this.showContextMenu(m),b=!0);else if(46===f&&x)v&&(P.onRemove(C),b=!0);else if(45===f&&x)v&&!g?(this._onInsertBefore(),b=!0):v&&g&&(this._onInsertAfter(),b=!0);else if(35===f){if(y){var T=this._lastNode();T&&T.focus(P.focusElement||this._getElementName(m)),b=!0}}else if(36===f){if(y){var S=this._firstNode();S&&S.focus(P.focusElement||this._getElementName(m)),b=!0}}else if(37===f){if(y&&!g){var j=this._previousElement(m);j&&this.focus(this._getElementName(j)),b=!0}else if(y&&g&&x){if(E.expanded){var N=E.getAppendDom();n=N?N.nextSibling:void 0}else{var k=E.getDom();n=k.nextSibling}if(n){i=P.getNodeFromTarget(n),o=n.nextSibling;var O=P.getNodeFromTarget(o);i&&i instanceof L&&1!==E.parent.childs.length&&O&&O.parent&&(r=this.editor.getDomSelection(),s=(a=_.parent).childs[E.getIndex()+1]||a.append,l=_.getIndex(),c=O.getIndex(),d=a.getInternalPath(),h=O.parent.getInternalPath(),C.forEach(function(e){O.parent.moveBefore(e,O)}),this.focus(P.focusElement||this._getElementName(m)),this.editor._onAction("moveNodes",{count:C.length,fieldNames:C.map(F),oldParentPath:a.getInternalPath(),newParentPath:_.parent.getInternalPath(),oldIndex:s.getIndex(),newIndex:_.getIndex(),oldIndexRedo:l,newIndexRedo:c,oldParentPathRedo:d,newParentPathRedo:h,oldSelection:r,newSelection:this.editor.getDomSelection()}))}}}else if(38===f)y&&!g?((t=this._previousNode())&&(this.editor.deselect(!0),t.focus(P.focusElement||this._getElementName(m))),b=!0):!y&&v&&g&&x?((t=this._previousNode())&&((p=this.editor.multiselection).start=p.start||this,p.end=t,u=this.editor._findTopLevelNodes(p.start,p.end),this.editor.select(u),t.focus("field")),b=!0):y&&g&&x&&((t=_._previousNode())&&t.parent&&(r=this.editor.getDomSelection(),s=(a=_.parent).childs[E.getIndex()+1]||a.append,l=_.getIndex(),c=t.getIndex(),d=a.getInternalPath(),h=t.parent.getInternalPath(),C.forEach(function(e){t.parent.moveBefore(e,t)}),this.focus(P.focusElement||this._getElementName(m)),this.editor._onAction("moveNodes",{count:C.length,fieldNames:C.map(F),oldParentPath:a.getInternalPath(),newParentPath:_.parent.getInternalPath(),oldIndex:s.getIndex(),newIndex:_.getIndex(),oldIndexRedo:l,newIndexRedo:c,oldParentPathRedo:d,newParentPathRedo:h,oldSelection:r,newSelection:this.editor.getDomSelection()})),b=!0);else if(39===f){if(y&&!g){var I=this._nextElement(m);I&&this.focus(this._getElementName(I)),b=!0}else if(y&&g&&x){var D=(k=_.getDom()).previousSibling;D&&(t=P.getNodeFromTarget(D))&&t.parent&&!t.isVisible()&&(r=this.editor.getDomSelection(),s=(a=_.parent).childs[E.getIndex()+1]||a.append,l=_.getIndex(),c=t.getIndex(),d=a.getInternalPath(),h=t.parent.getInternalPath(),C.forEach(function(e){t.parent.moveBefore(e,t)}),this.focus(P.focusElement||this._getElementName(m)),this.editor._onAction("moveNodes",{count:C.length,fieldNames:C.map(F),oldParentPath:a.getInternalPath(),newParentPath:_.parent.getInternalPath(),oldIndex:s.getIndex(),newIndex:_.getIndex(),oldIndexRedo:l,newIndexRedo:c,oldParentPathRedo:d,newParentPathRedo:h,oldSelection:r,newSelection:this.editor.getDomSelection()}))}}else if(40===f)if(y&&!g)(i=this._nextNode())&&(this.editor.deselect(!0),i.focus(P.focusElement||this._getElementName(m))),b=!0;else if(!y&&v&&g&&x)(i=this._nextNode())&&((p=this.editor.multiselection).start=p.start||this,p.end=i,u=this.editor._findTopLevelNodes(p.start,p.end),this.editor.select(u),i.focus("field")),b=!0;else if(y&&g&&x){(i=E.expanded?E.append?E.append._nextNode():void 0:E._nextNode())&&!i.isVisible()&&(i=i.parent.showMore),i&&i instanceof L&&(i=E);var A=i&&(i._nextNode()||i.parent.append);A&&A.parent&&(r=this.editor.getDomSelection(),s=(a=_.parent).childs[E.getIndex()+1]||a.append,l=_.getIndex(),c=A.getIndex(),d=a.getInternalPath(),h=A.parent.getInternalPath(),C.forEach(function(e){A.parent.moveBefore(e,A)}),this.focus(P.focusElement||this._getElementName(m)),this.editor._onAction("moveNodes",{count:C.length,fieldNames:C.map(F),oldParentPath:a.getInternalPath(),newParentPath:_.parent.getInternalPath(),oldParentPathRedo:d,newParentPathRedo:h,oldIndexRedo:l,newIndexRedo:c,oldIndex:s.getIndex(),newIndex:_.getIndex(),oldSelection:r,newSelection:this.editor.getDomSelection()})),b=!0}b&&(e.preventDefault(),e.stopPropagation())}},{key:"_onExpand",value:function(e){if(e){var t=this.dom.tr.parentNode,i=t.parentNode,n=i.scrollTop;i.removeChild(t)}this.expanded?this.collapse(e):this.expand(e),e&&(i.appendChild(t),i.scrollTop=n)}},{key:"_showColorPicker",value:function(){if("function"==typeof this.editor.options.onColorPicker&&this.dom.color){var t=this;t._deleteDomColor(),t.updateDom();var e=Object(b.a)(this.dom.color,this.editor.frame);this.editor.options.onColorPicker(e,this.value,function(e){"string"==typeof e&&e!==t.value&&(t._deleteDomColor(),t.value=e,t.updateDom(),t._debouncedOnChangeValue())})}}},{key:"getFieldNames",value:function(t){return"object"===this.type?this.childs.filter(function(e){return e!==t}).map(function(e){return e.field}):[]}},{key:"_onInsertBefore",value:function(e,t,i){var n=this.editor.getDomSelection(),o=new P(this.editor,{field:void 0!==e?e:"",value:void 0!==t?t:"",type:i});o.expand(!0);var r=this.getInternalPath();this.parent.insertBefore(o,this),this.editor.highlighter.unhighlight(),o.focus("field");var s=this.editor.getDomSelection();this.editor._onAction("insertBeforeNodes",{nodes:[o],paths:[o.getInternalPath()],beforePath:r,parentPath:this.parent.getInternalPath(),oldSelection:n,newSelection:s})}},{key:"_onInsertAfter",value:function(e,t,i){var n=this.editor.getDomSelection(),o=new P(this.editor,{field:void 0!==e?e:"",value:void 0!==t?t:"",type:i});o.expand(!0),this.parent.insertAfter(o,this),this.editor.highlighter.unhighlight(),o.focus("field");var r=this.editor.getDomSelection();this.editor._onAction("insertAfterNodes",{nodes:[o],paths:[o.getInternalPath()],afterPath:this.getInternalPath(),parentPath:this.parent.getInternalPath(),oldSelection:n,newSelection:r})}},{key:"_onAppend",value:function(e,t,i){var n=this.editor.getDomSelection(),o=new P(this.editor,{field:void 0!==e?e:"",value:void 0!==t?t:"",type:i});o.expand(!0),this.parent.appendChild(o),this.editor.highlighter.unhighlight(),o.focus("field");var r=this.editor.getDomSelection();this.editor._onAction("appendNodes",{nodes:[o],paths:[o.getInternalPath()],parentPath:this.parent.getInternalPath(),oldSelection:n,newSelection:r})}},{key:"_onChangeType",value:function(e){var t=this.type;if(e!==t){var i=this.editor.getDomSelection();this.changeType(e);var n=this.editor.getDomSelection();this.editor._onAction("changeType",{path:this.getInternalPath(),oldType:t,newType:e,oldSelection:i,newSelection:n})}}},{key:"sort",value:function(s,e){if("string"==typeof s&&(s=Object(M.parsePath)(s)),this._hasChilds()){this.hideChilds();var t=this.childs;this.childs=this.childs.concat();var a="desc"===e?-1:1;"object"===this.type?this.childs.sort(function(e,t){return a*y()(e.field,t.field)}):this.childs.sort(function(e,t){var i=e.getNestedChild(s),n=t.getNestedChild(s);if(!i)return a;if(!n)return-a;var o=i.value,r=n.value;return"string"!=typeof o&&"string"!=typeof r?r<o?a:o<r?-a:0:a*y()(o,r)}),this._updateDomIndexes(),this.editor._onAction("sort",{path:this.getInternalPath(),oldChilds:t,newChilds:this.childs}),this.showChilds()}}},{key:"update",value:function(e){var t=this.getInternalValue();this.setValue(e),this.editor._onAction("transform",{path:this.getInternalPath(),oldValue:t,newValue:this.getInternalValue()})}},{key:"_detachFromDom",value:function(){var e,t=this.dom.tr?this.dom.tr.parentNode:void 0,i=(e=this.expanded?this.getAppendDom():this.getDom())&&e.parentNode?e.nextSibling:void 0;return this.hide({resetVisibleChilds:!1}),{table:t,nextTr:i}}},{key:"_attachToDom",value:function(e){e.table&&(e.nextTr?e.table.insertBefore(this.getDom(),e.nextTr):e.table.appendChild(this.getDom())),this.expanded&&this.showChilds()}},{key:"transform",value:function(e){if(this._hasChilds()){this.hideChilds();try{var t=this.getInternalValue(),i=this.getValue(),n=v.a.search(i,e);this.setValue(n);var o=this.getInternalValue();this.editor._onAction("transform",{path:this.getInternalPath(),oldValue:t,newValue:o}),this.showChilds()}catch(e){this.showChilds(),this.editor._onError(e)}}}},{key:"extract",value:function(){this.editor.node.hideChilds(),this.hideChilds();try{var e=this.editor.node.getInternalValue();this.editor._setRoot(this);var t=this.editor.node.getInternalValue();this.editor._onAction("transform",{path:this.editor.node.getInternalPath(),oldValue:e,newValue:t})}catch(e){this.editor._onError(e)}finally{this.updateDom({recurse:!0}),this.showChilds()}}},{key:"getNestedChild",value:function(e){for(var t=0,i=this;i&&t<e.length;)i=i.findChildByProperty(e[t]),t++;return i}},{key:"findChildByProperty",value:function(t){if("object"===this.type)return this.childs.find(function(e){return e.field===t})}},{key:"getAppendDom",value:function(){return this.append||(this.append=new L(this.editor),this.append.setParent(this)),this.append.getDom()}},{key:"getShowMoreDom",value:function(){return this.showMore||(this.showMore=new I(this.editor,this)),this.showMore.getDom()}},{key:"nextSibling",value:function(){var e=this.parent.childs.indexOf(this);return this.parent.childs[e+1]||this.parent.append}},{key:"_previousNode",value:function(){var e=null,t=this.getDom();if(t&&t.parentNode)for(var i=t;i=i.previousSibling,e=P.getNodeFromTarget(i),i&&e&&e instanceof L&&!e.isVisible(););return e}},{key:"_nextNode",value:function(){var e=null,t=this.getDom();if(t&&t.parentNode)for(var i=t;i=i.nextSibling,e=P.getNodeFromTarget(i),i&&e&&e instanceof L&&!e.isVisible(););return e}},{key:"_firstNode",value:function(){var e=null,t=this.getDom();if(t&&t.parentNode){var i=t.parentNode.firstChild;e=P.getNodeFromTarget(i)}return e}},{key:"_lastNode",value:function(){var e=null,t=this.getDom();if(t&&t.parentNode){var i=t.parentNode.lastChild;for(e=P.getNodeFromTarget(i);i&&e&&!e.isVisible();)i=i.previousSibling,e=P.getNodeFromTarget(i)}return e}},{key:"_previousElement",value:function(e){var t=this.dom;switch(e){case t.value:if(this.fieldEditable)return t.field;case t.field:if(this._hasChilds())return t.expand;case t.expand:return t.menu;case t.menu:if(t.drag)return t.drag;default:return null}}},{key:"_nextElement",value:function(e){var t=this.dom;switch(e){case t.drag:return t.menu;case t.menu:if(this._hasChilds())return t.expand;case t.expand:if(this.fieldEditable)return t.field;case t.field:if(!this._hasChilds())return t.value;default:return null}}},{key:"_getElementName",value:function(t){var i=this;return Object.keys(this.dom).find(function(e){return i.dom[e]===t})}},{key:"_hasChilds",value:function(){return"array"===this.type||"object"===this.type}},{key:"addTemplates",value:function(t,i){var n=this,e=n.editor.options.templates;if(null!=e){e.length&&t.push({type:"separator"});e.forEach(function(e){t.push({text:e.text,className:e.className||"jsoneditor-type-object",title:e.title,click:i?function(e,t){n._onAppend(e,t)}.bind(this,e.field,e.value):function(e,t){n._onInsertBefore(e,t)}.bind(this,e.field,e.value)})})}}},{key:"showContextMenu",value:function(e,t){var i=this,n=P.TYPE_TITLES,o=[];if(this.editable.value&&o.push({text:Object(h.c)("type"),title:Object(h.c)("typeTitle"),className:"jsoneditor-type-"+this.type,submenu:[{text:Object(h.c)("auto"),className:"jsoneditor-type-auto"+("auto"===this.type?" jsoneditor-selected":""),title:n.auto,click:function(){i._onChangeType("auto")}},{text:Object(h.c)("array"),className:"jsoneditor-type-array"+("array"===this.type?" jsoneditor-selected":""),title:n.array,click:function(){i._onChangeType("array")}},{text:Object(h.c)("object"),className:"jsoneditor-type-object"+("object"===this.type?" jsoneditor-selected":""),title:n.object,click:function(){i._onChangeType("object")}},{text:Object(h.c)("string"),className:"jsoneditor-type-string"+("string"===this.type?" jsoneditor-selected":""),title:n.string,click:function(){i._onChangeType("string")}}]}),this._hasChilds()&&(this.editor.options.enableSort&&o.push({text:Object(h.c)("sort"),title:Object(h.c)("sortTitle",{type:this.type}),className:"jsoneditor-sort-asc",click:function(){i.showSortModal()}}),this.editor.options.enableTransform&&o.push({text:Object(h.c)("transform"),title:Object(h.c)("transformTitle",{type:this.type}),className:"jsoneditor-transform",click:function(){i.showTransformModal()}}),this.parent&&o.push({text:Object(h.c)("extract"),title:Object(h.c)("extractTitle",{type:this.type}),className:"jsoneditor-extract",click:function(){i.extract()}})),this.parent&&this.parent._hasChilds()){o.length&&o.push({type:"separator"});var r=i.parent.childs;if(i===r[r.length-1]){var s=[{text:Object(h.c)("auto"),className:"jsoneditor-type-auto",title:n.auto,click:function(){i._onAppend("","","auto")}},{text:Object(h.c)("array"),className:"jsoneditor-type-array",title:n.array,click:function(){i._onAppend("",[])}},{text:Object(h.c)("object"),className:"jsoneditor-type-object",title:n.object,click:function(){i._onAppend("",{})}},{text:Object(h.c)("string"),className:"jsoneditor-type-string",title:n.string,click:function(){i._onAppend("","","string")}}];i.addTemplates(s,!0),o.push({text:Object(h.c)("appendText"),title:Object(h.c)("appendTitle"),submenuTitle:Object(h.c)("appendSubmenuTitle"),className:"jsoneditor-append",click:function(){i._onAppend("","","auto")},submenu:s})}var a=[{text:Object(h.c)("auto"),className:"jsoneditor-type-auto",title:n.auto,click:function(){i._onInsertBefore("","","auto")}},{text:Object(h.c)("array"),className:"jsoneditor-type-array",title:n.array,click:function(){i._onInsertBefore("",[])}},{text:Object(h.c)("object"),className:"jsoneditor-type-object",title:n.object,click:function(){i._onInsertBefore("",{})}},{text:Object(h.c)("string"),className:"jsoneditor-type-string",title:n.string,click:function(){i._onInsertBefore("","","string")}}];i.addTemplates(a,!1),o.push({text:Object(h.c)("insert"),title:Object(h.c)("insertTitle"),submenuTitle:Object(h.c)("insertSub"),className:"jsoneditor-insert",click:function(){i._onInsertBefore("","","auto")},submenu:a}),this.editable.field&&(o.push({text:Object(h.c)("duplicateText"),title:Object(h.c)("duplicateField"),className:"jsoneditor-duplicate",click:function(){P.onDuplicate(i)}}),o.push({text:Object(h.c)("removeText"),title:Object(h.c)("removeField"),className:"jsoneditor-remove",click:function(){P.onRemove(i)}}))}if(this.editor.options.onCreateMenu){var l=i.getPath();o=this.editor.options.onCreateMenu(o,{type:"single",path:l,paths:[l]})}new u.a(o,{close:t}).show(e,this.editor.frame)}},{key:"showSortModal",value:function(){var n=this,e=this.editor.options.modalAnchor||_.a,t=this.getValue();Object(x.a)(e,t,function(e){var t=e.path,i=Object(M.parsePath)(t);n.sortedBy=e,n.sort(i,e.direction)},n.sortedBy)}},{key:"showTransformModal",value:function(){var t=this,e=this.editor.options.modalAnchor||_.a,i=t.getValue();Object(C.a)(e,i,function(e){t.transform(e)})}},{key:"_getType",value:function(e){return e instanceof Array?"array":e instanceof Object?"object":"string"==typeof e&&"string"!=typeof Object(M.parseString)(e)?"string":"auto"}},{key:"_escapeHTML",value:function(e){if("string"!=typeof e)return String(e);var t=String(e).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/ {2}/g," &nbsp;").replace(/^ /,"&nbsp;").replace(/ $/,"&nbsp;"),i=JSON.stringify(t),n=i.substring(1,i.length-1);return!0===this.editor.options.escapeUnicode&&(n=Object(M.escapeUnicodeChars)(n)),n}},{key:"_unescapeHTML",value:function(e){var t='"'+this._escapeJSON(e)+'"';return Object(M.parse)(t).replace(/&lt;/g,"<").replace(/&gt;/g,">").replace(/&nbsp;|\u00A0/g," ").replace(/&amp;/g,"&")}},{key:"_escapeJSON",value:function(e){for(var t="",i=0;i<e.length;){var n=e.charAt(i);"\n"===n?t+="\\n":"\\"===n?(t+=n,i++,""!==(n=e.charAt(i))&&-1!=='"\\/bfnrtu'.indexOf(n)||(t+="\\"),t+=n):t+='"'===n?'\\"':n,i++}return t}},{key:"updateNodeName",value:function(){var e,t=this.childs?this.childs.length:0;if("object"===this.type||"array"===this.type){if(this.editor.options.onNodeName)try{e=this.editor.options.onNodeName({path:this.getPath(),size:t,type:this.type})}catch(e){console.error("Error in onNodeName callback: ",e)}this.dom.value.innerHTML="object"===this.type?"{"+(e||t)+"}":"["+(e||t)+"]"}}},{key:"recursivelyUpdateNodeName",value:function(){var e;if(this.expanded&&(this.updateNodeName(),"undefined"!==this.childs))for(e in this.childs)this.childs[e].recursivelyUpdateNodeName()}}]),P}();j.prototype.DEBOUNCE_INTERVAL=150,j.prototype.MAX_SEARCH_RESULTS=999;var T=100;function S(e){return e.getInternalPath()}function F(e){return e.getField()}function N(e,t){return Object.prototype.hasOwnProperty.call(e,t)}j.focusElement=void 0,j.select=function(e){setTimeout(function(){Object(M.selectContentEditable)(e)},0)},j.onDragStart=function(t,e){if(!Array.isArray(t))return j.onDragStart([t],e);if(0!==t.length){var i=t[0],n=t[t.length-1],o=i.parent,r=j.getNodeFromTarget(e.target),s=i.editor,a=Object(M.getAbsoluteTop)(r.dom.tr)-Object(M.getAbsoluteTop)(i.dom.tr);s.mousemove||(s.mousemove=Object(M.addEventListener)(window,"mousemove",function(e){j.onDrag(t,e)})),s.mouseup||(s.mouseup=Object(M.addEventListener)(window,"mouseup",function(e){j.onDragEnd(t,e)})),s.highlighter.lock(),s.drag={oldCursor:document.body.style.cursor,oldSelection:s.getDomSelection(),oldPaths:t.map(S),oldParent:o,oldNextNode:o.childs[n.getIndex()+1]||o.append,oldParentPathRedo:o.getInternalPath(),oldIndexRedo:i.getIndex(),mouseX:e.pageX,offsetY:a,level:i.getLevel()},document.body.style.cursor="move",e.preventDefault()}},j.onDrag=function(e,t){if(!Array.isArray(e))return j.onDrag([e],t);if(0!==e.length){var i,n,o,r,s,a,l,c,d,h,u,p=e[0].editor,f=t.pageY-p.drag.offsetY,m=t.pageX,v=!1,g=e[0],y=g.dom.tr,b=Object(M.getAbsoluteTop)(y),x=y.offsetHeight;if(f<b){for(i=y;i=i.previousSibling,a=j.getNodeFromTarget(i),c=i?Object(M.getAbsoluteTop)(i):0,i&&f<c;);a&&!a.parent&&(a=void 0),a||(i=(s=y.parentNode.firstChild)?s.nextSibling:void 0,(a=j.getNodeFromTarget(i))===g&&(a=void 0)),a&&a.isVisible()&&(c=(i=a.dom.tr)?Object(M.getAbsoluteTop)(i):0)+x<f&&(a=void 0),a&&(e.forEach(function(e){a.parent.moveBefore(e,a)}),v=!0)}else{var C=e[e.length-1];if(o=(r=C.expanded&&C.append?C.append.getDom():C.dom.tr)?r.nextSibling:void 0){for(d=Object(M.getAbsoluteTop)(o),n=o;l=j.getNodeFromTarget(n),n&&(h=n.nextSibling?Object(M.getAbsoluteTop)(n.nextSibling):0,u=n?h-d:0,l&&l.parent.childs.length===e.length&&l.parent.childs[e.length-1]===C&&(b+=27),n=n.nextSibling),n&&b+u<f;);if(l&&l.parent){var _=m-p.drag.mouseX,E=Math.round(_/24/2),w=p.drag.level+E,T=l.getLevel();for(i=l.dom.tr&&l.dom.tr.previousSibling;T<w&&i;){if(a=j.getNodeFromTarget(i),e.some(function(e){return e===a||a.isDescendantOf(e)}));else{if(!(a instanceof L))break;var S=a.parent.childs;if(S.length===e.length&&S[e.length-1]===C)break;T=(l=j.getNodeFromTarget(i)).getLevel()}i=i.previousSibling}l instanceof L&&!l.isVisible()&&l.parent.showMore.isVisible()&&(l=l._nextNode()),l&&l.dom.tr&&r.nextSibling!==l.dom.tr&&(e.forEach(function(e){l.parent.moveBefore(e,l)}),v=!0)}}}v&&(p.drag.mouseX=m,p.drag.level=g.getLevel()),p.startAutoScroll(f),t.preventDefault()}},j.onDragEnd=function(e,t){if(!Array.isArray(e))return j.onDrag([e],t);if(0!==e.length){var i=e[0],n=i.editor;e[0]&&e[0].dom.menu.focus();var o=n.drag.oldParent.getInternalPath(),r=i.parent.getInternalPath(),s=n.drag.oldParent===i.parent,a=n.drag.oldNextNode.getIndex(),l=i.getIndex(),c=n.drag.oldParentPathRedo,d=n.drag.oldIndexRedo,h=s&&d<l?l+e.length:l;s&&d===l||n._onAction("moveNodes",{count:e.length,fieldNames:e.map(F),oldParentPath:o,newParentPath:r,oldIndex:a,newIndex:l,oldIndexRedo:d,newIndexRedo:h,oldParentPathRedo:c,newParentPathRedo:null,oldSelection:n.drag.oldSelection,newSelection:n.getDomSelection()}),document.body.style.cursor=n.drag.oldCursor,n.highlighter.unlock(),e.forEach(function(e){e.updateDom(),t.target!==e.dom.drag&&t.target!==e.dom.menu&&n.highlighter.unhighlight()}),delete n.drag,n.mousemove&&(Object(M.removeEventListener)(window,"mousemove",n.mousemove),delete n.mousemove),n.mouseup&&(Object(M.removeEventListener)(window,"mouseup",n.mouseup),delete n.mouseup),n.stopAutoScroll(),t.preventDefault()}},j._findEnum=function(e){if(e.enum)return e.enum;var t=e.oneOf||e.anyOf||e.allOf;if(t){var i=t.filter(function(e){return e.enum});if(0<i.length)return i[0].enum}return null},j._findSchema=function(e,t,i){var n=e,o=n,r=e.oneOf||e.anyOf||e.allOf;r=r||[e];for(var s=0;s<r.length;s++){"$ref"in(n=r[s])&&"string"==typeof n.$ref&&(n=t[n.$ref])&&(o=j._findSchema(n,t,i));for(var a=0;a<i.length&&n;a++){var l=i.slice(a+1,i.length),c=i[a];if("string"!=typeof c||!n.patternProperties||n.properties&&c in n.properties)"string"==typeof c&&n.properties?c in n.properties?(n=n.properties[c])&&(o=j._findSchema(n,t,l)):o=null:"number"==typeof c&&n.items&&(n=n.items)&&(o=j._findSchema(n,t,l));else for(var d in n.patternProperties)c.match(d)&&(o=j._findSchema(n.patternProperties[d],t,l))}}return o===e&&0<i.length?null:o},j.onRemove=function(e){if(!Array.isArray(e))return j.onRemove([e]);if(e&&0<e.length){var t=e[0],i=t.parent,n=t.editor,o=t.getIndex();n.highlighter.unhighlight();var r=n.getDomSelection();j.blurNodes(e);var s=n.getDomSelection(),a=e.map(S);e.forEach(function(e){e.parent._remove(e)}),n._onAction("removeNodes",{nodes:e,paths:a,parentPath:i.getInternalPath(),index:o,oldSelection:r,newSelection:s})}},j.onDuplicate=function(e){if(!Array.isArray(e))return j.onDuplicate([e]);if(e&&0<e.length){var t=e[e.length-1],n=t.parent,i=t.editor;i.deselect(i.multiselection.nodes);var o=i.getDomSelection(),r=t,s=e.map(function(e){var t=e.clone();if("object"===e.parent.type){var i=e.parent.getFieldNames();t.field=Object(M.findUniqueName)(e.field,i)}return n.insertAfter(t,r),r=t});1===e.length?"object"===s[0].parent.type?(s[0].dom.field.innerHTML=e[0].field,s[0].focus("field")):s[0].focus():i.select(s);var a=i.getDomSelection();i._onAction("duplicateNodes",{paths:e.map(S),clonePaths:s.map(S),afterPath:t.getInternalPath(),parentPath:n.getInternalPath(),oldSelection:o,newSelection:a})}},j.getNodeFromTarget=function(e){for(;e;){if(e.node)return e.node;e=e.parentNode}},j.targetIsColorPicker=function(e){var t=j.getNodeFromTarget(e);if(t)for(var i=e&&e.parentNode;i;){if(i===t.dom.color)return!0;i=i.parentNode}return!1},j.blurNodes=function(e){if(Array.isArray(e)){var t=e[0],i=t.parent,n=t.getIndex();i.childs[n+e.length]?i.childs[n+e.length].focus():i.childs[n-1]?i.childs[n-1].focus():i.focus()}else j.blurNodes([e])},j.TYPE_TITLES={auto:Object(h.c)("autoType"),object:Object(h.c)("objectType"),array:Object(h.c)("arrayType"),string:Object(h.c)("stringType")};var k,L=((O.prototype=new(k=j)).getDom=function(){var e=this.dom;if(e.tr)return e.tr;this._updateEditability();var t=document.createElement("tr");if(t.className="jsoneditor-append",t.node=this,e.tr=t,"tree"===this.editor.options.mode){e.tdDrag=document.createElement("td");var i=document.createElement("td");e.tdMenu=i;var n=document.createElement("button");n.type="button",n.className="jsoneditor-button jsoneditor-contextmenu-button",n.title="Click to open the actions menu (Ctrl+M)",e.menu=n,i.appendChild(e.menu)}var o=document.createElement("td"),r=document.createElement("div");return r.innerHTML="("+Object(h.c)("empty")+")",r.className="jsoneditor-readonly",o.appendChild(r),e.td=o,e.text=r,this.updateDom(),t},O.prototype.getPath=function(){return null},O.prototype.getIndex=function(){return null},O.prototype.updateDom=function(e){var t=this.dom,i=t.td;i&&(i.style.paddingLeft=24*this.getLevel()+26+"px");var n=t.text;n&&(n.innerHTML="("+Object(h.c)("empty")+" "+this.parent.type+")");var o=t.tr;this.isVisible()?t.tr.firstChild||(t.tdDrag&&o.appendChild(t.tdDrag),t.tdMenu&&o.appendChild(t.tdMenu),o.appendChild(i)):t.tr.firstChild&&(t.tdDrag&&o.removeChild(t.tdDrag),t.tdMenu&&o.removeChild(t.tdMenu),o.removeChild(i))},O.prototype.isVisible=function(){return 0===this.parent.childs.length},O.prototype.showContextMenu=function(e,t){var i=this,n=k.TYPE_TITLES,o=[{text:Object(h.c)("auto"),className:"jsoneditor-type-auto",title:n.auto,click:function(){i._onAppend("","","auto")}},{text:Object(h.c)("array"),className:"jsoneditor-type-array",title:n.array,click:function(){i._onAppend("",[])}},{text:Object(h.c)("object"),className:"jsoneditor-type-object",title:n.object,click:function(){i._onAppend("",{})}},{text:Object(h.c)("string"),className:"jsoneditor-type-string",title:n.string,click:function(){i._onAppend("","","string")}}];i.addTemplates(o,!0);var r=[{text:Object(h.c)("appendText"),title:Object(h.c)("appendTitleAuto"),submenuTitle:Object(h.c)("appendSubmenuTitle"),className:"jsoneditor-insert",click:function(){i._onAppend("","","auto")},submenu:o}];if(this.editor.options.onCreateMenu){var s=i.parent.getPath();r=this.editor.options.onCreateMenu(r,{type:"append",path:s,paths:[s]})}new u.a(r,{close:t}).show(e,this.editor.frame)},O.prototype.onEvent=function(e){var t=e.type,i=e.target||e.srcElement,n=this.dom;if(i===n.menu&&("mouseover"===t?this.editor.highlighter.highlight(this.parent):"mouseout"===t&&this.editor.highlighter.unhighlight()),"click"===t&&i===n.menu){var o=this.editor.highlighter;o.highlight(this.parent),o.lock(),Object(M.addClassName)(n.menu,"jsoneditor-selected"),this.showContextMenu(n.menu,function(){Object(M.removeClassName)(n.menu,"jsoneditor-selected"),o.unlock(),o.unhighlight()})}"keydown"===t&&this.onKeyDown(e)},O);function O(e){this.editor=e,this.dom={}}var I=((D.prototype=new j).getDom=function(){if(this.dom.tr)return this.dom.tr;if(this._updateEditability(),!this.dom.tr){var t=this,i=this.parent,e=document.createElement("a");e.appendChild(document.createTextNode(Object(h.c)("showMore"))),e.href="#",e.onclick=function(e){return i.visibleChilds=Math.floor(i.visibleChilds/i.getMaxVisibleChilds()+1)*i.getMaxVisibleChilds(),t.updateDom(),i.showChilds(),e.preventDefault(),!1};var n=document.createElement("a");n.appendChild(document.createTextNode(Object(h.c)("showAll"))),n.href="#",n.onclick=function(e){return i.visibleChilds=1/0,t.updateDom(),i.showChilds(),e.preventDefault(),!1};var o=document.createElement("div"),r=document.createTextNode(this._getShowMoreText());o.className="jsoneditor-show-more",o.appendChild(r),o.appendChild(e),o.appendChild(document.createTextNode(". ")),o.appendChild(n),o.appendChild(document.createTextNode(". "));var s=document.createElement("td");s.appendChild(o);var a=document.createElement("tr");"tree"===this.editor.options.mode&&(a.appendChild(document.createElement("td")),a.appendChild(document.createElement("td"))),a.appendChild(s),a.className="jsoneditor-show-more",this.dom.tr=a,this.dom.moreContents=o,this.dom.moreText=r}return this.updateDom(),this.dom.tr},D.prototype.updateDom=function(e){if(this.isVisible()){if(this.dom.tr.node=this.parent.childs[this.parent.visibleChilds],!this.dom.tr.parentNode){var t=this.parent._getNextTr();t&&t.parentNode.insertBefore(this.dom.tr,t)}this.dom.moreText.nodeValue=this._getShowMoreText(),this.dom.moreContents.style.marginLeft=24*(this.getLevel()+1)+"px"}else this.dom.tr&&this.dom.tr.parentNode&&this.dom.tr.parentNode.removeChild(this.dom.tr)},D.prototype._getShowMoreText=function(){return Object(h.c)("showMoreStatus",{visibleChilds:this.parent.visibleChilds,totalChilds:this.parent.childs.length})+" "},D.prototype.isVisible=function(){return this.parent.expanded&&this.parent.childs.length>this.parent.visibleChilds},D.prototype.onEvent=function(e){"keydown"===e.type&&this.onKeyDown(e)},D);function D(e,t){this.editor=e,this.parent=t,this.dom={}}var A=i(6),P={start:function(e,t){return 0===t.indexOf(e)},contain:function(e,t){return-1<t.indexOf(e)}};i.d(t,"treeModeMixins",function(){return B});var V={};V.create=function(e,t){if(!e)throw new Error("No container element provided.");this.container=e,this.dom={},this.highlighter=new s,this.selection=void 0,this.multiselection={nodes:[]},this.validateSchema=null,this.validationSequence=0,this.errorNodes=[],this.node=null,this.focusTarget=null,this._setOptions(t),t.autocomplete&&(this.autocomplete=function(l){(l=l||{}).filter=l.filter||"start",l.trigger=l.trigger||"keydown",l.confirmKeys=l.confirmKeys||[39,35,9],l.caseSensitive=l.caseSensitive||!1;var o="",r="",s=document.createElement("div");s.style.position="relative",s.style.outline="0",s.style.border="0",s.style.margin="0",s.style.padding="0";var t,c,d=document.createElement("div");function h(e){var t,i;document.createRange?((t=document.createRange()).selectNodeContents(e),t.collapse(!1),(i=window.getSelection()).removeAllRanges(),i.addRange(t)):document.selection&&((t=document.body.createTextRange()).moveToElementText(e),t.collapse(!1),t.select())}function a(e){return void 0===t&&((t=document.createElement("span")).style.visibility="hidden",t.style.position="fixed",t.style.outline="0",t.style.margin="0",t.style.padding="0",t.style.border="0",t.style.left="0",t.style.whiteSpace="pre",t.style.fontSize=o,t.style.fontFamily=r,t.style.fontWeight="normal",document.body.appendChild(t)),t.innerHTML=String(e).replace(/&/g,"&amp;").replace(/"/g,"&quot;").replace(/'/g,"&#39;").replace(/</g,"&lt;").replace(/>/g,"&gt;"),t.getBoundingClientRect().right}d.className="autocomplete dropdown",d.style.position="absolute",d.style.visibility="hidden";var u,p,f,i,m,v={onArrowDown:function(){},onArrowUp:function(){},onEnter:function(){},onTab:function(){},startFrom:0,options:[],element:null,elementHint:null,elementStyle:null,wrapper:s,show:function(e,t,i){var n=this;this.startFrom=t,this.wrapper.remove(),this.elementHint&&(this.elementHint.remove(),this.elementHint=null),""===o&&(o=window.getComputedStyle(e).getPropertyValue("font-size")),""===r&&(r=window.getComputedStyle(e).getPropertyValue("font-family")),d.style.marginLeft="0",d.style.marginTop=e.getBoundingClientRect().height+"px",this.options=i,this.element!==e&&(this.element=e,this.elementStyle={zIndex:this.element.style.zIndex,position:this.element.style.position,backgroundColor:this.element.style.backgroundColor,borderColor:this.element.style.borderColor}),this.element.style.zIndex=3,this.element.style.position="relative",this.element.style.backgroundColor="transparent",this.element.style.borderColor="transparent",this.elementHint=e.cloneNode(),this.elementHint.className="autocomplete hint",this.elementHint.style.zIndex=2,this.elementHint.style.position="absolute",this.elementHint.onfocus=function(){n.element.focus()},this.element.addEventListener&&(this.element.removeEventListener("keydown",C),this.element.addEventListener("keydown",C,!1),this.element.removeEventListener("blur",_),this.element.addEventListener("blur",_,!1)),s.appendChild(this.elementHint),s.appendChild(d),e.parentElement.appendChild(s),this.repaint(e)},setText:function(e){this.element.innerText=e},getText:function(){return this.element.innerText},hideDropDown:function(){this.wrapper.remove(),this.elementHint&&(this.elementHint.remove(),this.elementHint=null,g.hide(),this.element.style.zIndex=this.elementStyle.zIndex,this.element.style.position=this.elementStyle.position,this.element.style.backgroundColor=this.elementStyle.backgroundColor,this.element.style.borderColor=this.elementStyle.borderColor)},repaint:function(e){var t=e.innerText;t=t.replace("\n","");var i=this.options.length,n=t.substring(this.startFrom);c=t.substring(0,this.startFrom);for(var o=0;o<i;o++){var r=this.options[o];if(!l.caseSensitive&&0===r.toLowerCase().indexOf(n.toLowerCase())||l.caseSensitive&&0===r.indexOf(n)){this.elementHint.innerText=c+n+r.substring(n.length),this.elementHint.realInnerText=c+r;break}}d.style.left=a(c)+"px",g.refresh(n,this.options),this.elementHint.style.width=a(this.elementHint.innerText)+10+"px","hidden"===d.style.visibility||(this.elementHint.style.width=a(this.elementHint.innerText)+d.clientWidth+"px")}},g=(u=d,p=[],f=0,i=-1,m={rs:v,hide:function(){u.style.visibility="hidden"},refresh:function(i,e){u.style.visibility="hidden",f=0,u.innerHTML="";var t=window.innerHeight||document.documentElement.clientHeight,n=u.parentNode.getBoundingClientRect(),o=n.top-6,r=t-n.bottom-6;p=[];var s="function"==typeof l.filter?l.filter:P[l.filter],a=s?e.filter(function(e){return s(l.caseSensitive?i:i.toLowerCase(),l.caseSensitive?e:e.toLowerCase(),l)}):[];0!==(p=a.map(function(e){var t=document.createElement("div");return t.className="item",t.onmouseover=y,t.onmouseout=b,t.onmousedown=x,t.__hint=e,t.innerHTML=e.substring(0,i.length)+"<b>"+e.substring(i.length)+"</b>",u.appendChild(t),t})).length&&(1===p.length&&(i.toLowerCase()===p[0].__hint.toLowerCase()&&!l.caseSensitive||i===p[0].__hint&&l.caseSensitive)||p.length<2||(m.highlight(0),3*r<o?(u.style.maxHeight=o+"px",u.style.top="",u.style.bottom="100%"):(u.style.top="100%",u.style.bottom="",u.style.maxHeight=r+"px"),u.style.visibility="visible"))},highlight:function(e){-1!==i&&p[i]&&(p[i].className="item"),p[e].className="item hover",i=e},move:function(e){return"hidden"===u.style.visibility?"":(f+e===-1||f+e===p.length||(f+=e,m.highlight(f)),p[f].__hint)},onmouseselection:function(){}});function y(){this.style.backgroundColor="#ddd"}function b(){this.style.backgroundColor=""}function x(){m.hide(),m.onmouseselection(this.__hint,m.rs)}var C=function(e){var t=(e=e||window.event).keyCode;if(null!=this.elementHint&&33!==t&&34!==t){if(27===t)return v.hideDropDown(),v.element.focus(),e.preventDefault(),void e.stopPropagation();var i=this.element.innerText;if(i=i.replace("\n",""),0<=l.confirmKeys.indexOf(t))return 9===t&&0===this.elementHint.innerText.length&&v.onTab(),void(0<this.elementHint.innerText.length&&this.element.innerText!==this.elementHint.realInnerText&&(this.element.innerText=this.elementHint.realInnerText,v.hideDropDown(),h(this.element),9===t&&(v.element.focus(),e.preventDefault(),e.stopPropagation())));if(13!==t){if(40===t){var n=i.substring(this.startFrom),o=g.move(1);return""===o&&v.onArrowDown(),this.elementHint.innerText=c+n+o.substring(n.length),this.elementHint.realInnerText=c+o,e.preventDefault(),void e.stopPropagation()}if(38===t){var r=i.substring(this.startFrom),s=g.move(-1);""===s&&v.onArrowUp(),this.elementHint.innerText=c+r+s.substring(r.length),this.elementHint.realInnerText=c+s,e.preventDefault(),e.stopPropagation()}}else if(0===this.elementHint.innerText.length)v.onEnter();else{var a="hidden"===d.style.visibility;if(g.hide(),a)return v.hideDropDown(),v.element.focus(),void v.onEnter();this.element.innerText=this.elementHint.realInnerText,v.hideDropDown(),h(this.element),e.preventDefault(),e.stopPropagation()}}}.bind(v),_=function(){v.hideDropDown()};return g.onmouseselection=function(e,t){t.element.innerText=t.elementHint.innerText=c+e,t.hideDropDown(),window.setTimeout(function(){t.element.focus(),h(t.element)},1)},v}(t.autocomplete)),this.options.history&&"view"!==this.options.mode&&(this.history=new l(this)),this._createFrame(),this._createTable()},V.destroy=function(){this.frame&&this.container&&this.frame.parentNode===this.container&&(this.container.removeChild(this.frame),this.frame=null),this.container=null,this.dom=null,this.clear(),this.node=null,this.focusTarget=null,this.selection=null,this.multiselection=null,this.errorNodes=null,this.validateSchema=null,this._debouncedValidate=null,this.history&&(this.history.destroy(),this.history=null),this.searchBox&&(this.searchBox.destroy(),this.searchBox=null),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null)},V._setOptions=function(t){var i=this;this.options={search:!0,history:!0,mode:"tree",name:void 0,schema:null,schemaRefs:null,autocomplete:null,navigationBar:!0,mainMenuBar:!0,onSelectionChange:null,colorPicker:!0,onColorPicker:function(e,t,i){if(r.a){var n=e.getBoundingClientRect().top,o=window.innerHeight;new r.a({parent:e,color:t,popup:o-n<300&&300<n?"top":"bottom",onDone:function(e){var t=1===e.rgba[3]?e.hex.substr(0,7):e.hex;i(t)}}).show()}else console.warn("Cannot open color picker: the `vanilla-picker` library is not included in the bundle. Either use the full bundle or implement your own color picker using `onColorPicker`.")},timestampTag:!0,onEvent:null,enableSort:!0,enableTransform:!0},t&&Object.keys(t).forEach(function(e){i.options[e]=t[e]}),this.setSchema(this.options.schema,this.options.schemaRefs),this._debouncedValidate=Object(M.debounce)(this.validate.bind(this),this.DEBOUNCE_INTERVAL),t.onSelectionChange&&this.onSelectionChange(t.onSelectionChange),Object(h.b)(this.options.languages),Object(h.a)(this.options.language)},V.set=function(e){if(e instanceof Function||void 0===e)this.clear();else{this.content.removeChild(this.table);var t={field:this.options.name,value:e},i=new j(this,t);this._setRoot(i),this.validate();this.node.expand(!1),this.content.appendChild(this.table)}this.history&&this.history.clear(),this.searchBox&&this.searchBox.clear()},V.update=function(e){if(!this.node.deepEqual(e)){var t=this.getSelection();if(this.onChangeDisabled=!0,this.node.update(e),this.onChangeDisabled=!1,this.validate(),this.searchBox&&!this.searchBox.isEmpty()&&this.searchBox.forceSearch(),t&&t.start&&t.end){var i=this.node.findNodeByPath(t.start.path),n=this.node.findNodeByPath(t.end.path);i&&n?this.setSelection(t.start,t.end):this.setSelection({},{})}else this.setSelection({},{})}},V.get=function(){return this.node?this.node.getValue():void 0},V.getText=function(){return JSON.stringify(this.get())},V.setText=function(t){try{this.set(Object(M.parse)(t))}catch(e){var i=Object(M.repair)(t);this.set(Object(M.parse)(i))}},V.updateText=function(t){try{this.update(Object(M.parse)(t))}catch(e){var i=Object(M.repair)(t);this.update(Object(M.parse)(i))}},V.setName=function(e){this.options.name=e,this.node&&this.node.updateField(this.options.name)},V.getName=function(){return this.options.name},V.focus=function(){var e=this.scrollableContent.querySelector("[contenteditable=true]");e?e.focus():this.node.dom.expand?this.node.dom.expand.focus():this.node.dom.menu?this.node.dom.menu.focus():(e=this.frame.querySelector("button"))&&e.focus()},V.clear=function(){this.node&&(this.node.hide(),delete this.node),this.treePath&&this.treePath.reset()},V._setRoot=function(e){this.clear(),(this.node=e).setParent(null),e.setField(this.getName(),!1),delete e.index,this.tbody.appendChild(e.getDom())},V.search=function(e){var t;return this.node?(this.content.removeChild(this.table),t=this.node.search(e),this.content.appendChild(this.table)):t=[],t},V.expandAll=function(){this.node&&(this.content.removeChild(this.table),this.node.expand(),this.content.appendChild(this.table))},V.collapseAll=function(){this.node&&(this.content.removeChild(this.table),this.node.collapse(),this.content.appendChild(this.table))},V._onAction=function(e,t){this.history&&this.history.add(e,t),this._onChange()},V._onChange=function(){if(!this.onChangeDisabled){if(this.selection=this.getDomSelection(),this._debouncedValidate(),this.treePath){var e=this.node&&this.selection?this.node.findNodeByInternalPath(this.selection.path):this.multiselection?this.multiselection.nodes[0]:void 0;e?this._updateTreePath(e.getNodePath()):this.treePath.reset()}if(this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}if(this.options.onChangeJSON)try{this.options.onChangeJSON(this.get())}catch(e){console.error("Error in onChangeJSON callback: ",e)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(e){console.error("Error in onChangeText callback: ",e)}if(this.options.onClassName&&this.node.recursivelyUpdateCssClassesOnNodes(),this.options.onNodeName&&this.node.childs)try{this.node.recursivelyUpdateNodeName()}catch(e){console.error("Error in onNodeName callback: ",e)}}},V.validate=function(){var t=this.node;if(t){var e=t.getValue(),i=[];if(this.validateSchema)this.validateSchema(e)||(i=this.validateSchema.errors.map(function(e){return Object(M.improveSchemaError)(e)}).map(function(e){return{node:t.findNode(e.dataPath),error:e}}).filter(function(e){return null!=e.node}));try{this.validationSequence++;var n=this,o=this.validationSequence;this._validateCustom(e).then(function(e){if(o===n.validationSequence){var t=[].concat(i,e||[]);n._renderValidationErrors(t)}}).catch(function(e){console.error(e)})}catch(e){console.error(e)}}},V._renderValidationErrors=function(e){this.errorNodes&&this.errorNodes.forEach(function(e){e.setError(null)});var t=e.reduce(function(e,t){return t.node.findParents().filter(function(t){return!e.some(function(e){return e[0]===t})}).map(function(e){return[e,t.node]}).concat(e)},[]);this.errorNodes=t.map(function(e){return{node:e[0],child:e[1],error:{message:"object"===e[0].type?"Contains invalid properties":"Contains invalid items"}}}).concat(e).map(function(e){return e.node.setError(e.error,e.child),e.node})},V._validateCustom=function(e){try{if(this.options.onValidate){var i=this.node,t=this.options.onValidate(e);return(Object(M.isPromise)(t)?t:Promise.resolve(t)).then(function(e){return Array.isArray(e)?e.filter(function(e){var t=Object(M.isValidValidationError)(e);return t||console.warn('Ignoring a custom validation error with invalid structure. Expected structure: {path: [...], message: "..."}. Actual error:',e),t}).map(function(e){var t;try{t=e&&e.path?i.findNodeByPath(e.path):null}catch(e){}return t||console.warn("Ignoring validation error: node not found. Path:",e.path,"Error:",e),{node:t,error:e}}).filter(function(e){return e&&e.node&&e.error&&e.error.message}):null})}}catch(e){return Promise.reject(e)}return Promise.resolve(null)},V.refresh=function(){this.node&&this.node.updateDom({recurse:!0})},V.startAutoScroll=function(e){var t=this,i=this.scrollableContent,n=Object(M.getAbsoluteTop)(i),o=i.clientHeight,r=n+o;e<n+24&&0<i.scrollTop?this.autoScrollStep=(n+24-e)/3:r-24<e&&o+i.scrollTop<i.scrollHeight?this.autoScrollStep=(r-24-e)/3:this.autoScrollStep=void 0,this.autoScrollStep?this.autoScrollTimer||(this.autoScrollTimer=setInterval(function(){t.autoScrollStep?i.scrollTop-=t.autoScrollStep:t.stopAutoScroll()},50)):this.stopAutoScroll()},V.stopAutoScroll=function(){this.autoScrollTimer&&(clearTimeout(this.autoScrollTimer),delete this.autoScrollTimer),this.autoScrollStep&&delete this.autoScrollStep},V.setDomSelection=function(e){if(e)if("scrollTop"in e&&this.scrollableContent&&(this.scrollableContent.scrollTop=e.scrollTop),e.paths){var t=this,i=e.paths.map(function(e){return t.node.findNodeByInternalPath(e)});this.select(i)}else{var n=e.path?this.node.findNodeByInternalPath(e.path):null,o=n&&e.domName?n.dom[e.domName]:null;if(e.range&&o){var r=Object.assign({},e.range,{container:o});Object(M.setSelectionOffset)(r)}else n&&n.focus()}},V.getDomSelection=function(){var t=j.getNodeFromTarget(this.focusTarget),i=this.focusTarget,e=t?Object.keys(t.dom).find(function(e){return t.dom[e]===i}):null,n=Object(M.getSelectionOffset)();return n&&"DIV"!==n.container.nodeName&&(n=null),n&&n.container!==i&&(n=null),n&&delete n.container,{path:t?t.getInternalPath():null,domName:e,range:n,paths:0<this.multiselection.length?this.multiselection.nodes.map(function(e){return e.getInternalPath()}):null,scrollTop:this.scrollableContent?this.scrollableContent.scrollTop:0}},V.scrollTo=function(e,n){var o=this.scrollableContent;if(o){var r=this;r.animateTimeout&&(clearTimeout(r.animateTimeout),delete r.animateTimeout),r.animateCallback&&(r.animateCallback(!1),delete r.animateCallback);var t=o.clientHeight,i=o.scrollHeight-t,s=Math.min(Math.max(e-t/4,0),i);!function e(){var t=o.scrollTop,i=s-t;3<Math.abs(i)?(o.scrollTop+=i/3,r.animateCallback=n,r.animateTimeout=setTimeout(e,50)):(n&&n(!0),o.scrollTop=s,delete r.animateTimeout,delete r.animateCallback)}()}else n&&n(!1)},V._createFrame=function(){this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode,this.container.appendChild(this.frame),this.contentOuter=document.createElement("div"),this.contentOuter.className="jsoneditor-outer";var t=this;function i(e){t._onEvent&&t._onEvent(e)}if(this.frame.onclick=function(e){var t=e.target;i(e),"BUTTON"===t.nodeName&&e.preventDefault()},this.frame.oninput=i,this.frame.onchange=i,this.frame.onkeydown=i,this.frame.onkeyup=i,this.frame.oncut=i,this.frame.onpaste=i,this.frame.onmousedown=i,this.frame.onmouseup=i,this.frame.onmouseover=i,this.frame.onmouseout=i,Object(M.addEventListener)(this.frame,"focus",i,!0),Object(M.addEventListener)(this.frame,"blur",i,!0),this.frame.onfocusin=i,this.frame.onfocusout=i,this.options.mainMenuBar){Object(M.addClassName)(this.contentOuter,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu);var e=document.createElement("button");e.type="button",e.className="jsoneditor-expand-all",e.title=Object(h.c)("expandAll"),e.onclick=function(){t.expandAll()},this.menu.appendChild(e);var n=document.createElement("button");if(n.type="button",n.title=Object(h.c)("collapseAll"),n.className="jsoneditor-collapse-all",n.onclick=function(){t.collapseAll()},this.menu.appendChild(n),this.options.enableSort){var o=document.createElement("button");o.type="button",o.className="jsoneditor-sort",o.title=Object(h.c)("sortTitleShort"),o.onclick=function(){t.node.showSortModal()},this.menu.appendChild(o)}if(this.options.enableTransform){var r=document.createElement("button");r.type="button",r.title=Object(h.c)("transformTitleShort"),r.className="jsoneditor-transform",r.onclick=function(){t.node.showTransformModal()},this.menu.appendChild(r)}if(this.history){var s=document.createElement("button");s.type="button",s.className="jsoneditor-undo jsoneditor-separator",s.title=Object(h.c)("undo"),s.onclick=function(){t._onUndo()},this.menu.appendChild(s),this.dom.undo=s;var a=document.createElement("button");a.type="button",a.className="jsoneditor-redo",a.title=Object(h.c)("redo"),a.onclick=function(){t._onRedo()},this.menu.appendChild(a),this.dom.redo=a,this.history.onChange=function(){s.disabled=!t.history.canUndo(),a.disabled=!t.history.canRedo()},this.history.onChange()}if(this.options&&this.options.modes&&this.options.modes.length){var l=this;this.modeSwitcher=new A.a(this.menu,this.options.modes,this.options.mode,function(e){l.setMode(e),l.modeSwitcher.focus()})}this.options.search&&(this.searchBox=new d(this,this.menu))}this.options.navigationBar&&(this.navBar=document.createElement("div"),this.navBar.className="jsoneditor-navigation-bar nav-bar-empty",this.frame.appendChild(this.navBar),this.treePath=new f(this.navBar,this.frame),this.treePath.onSectionSelected(this._onTreePathSectionSelected.bind(this)),this.treePath.onContextMenuItemSelected(this._onTreePathMenuItemSelected.bind(this)))},V._onUndo=function(){this.history&&(this.history.undo(),this._onChange())},V._onRedo=function(){this.history&&(this.history.redo(),this._onChange())},V._onEvent=function(e){if(!j.targetIsColorPicker(e.target)){var t=j.getNodeFromTarget(e.target);if("keydown"===e.type&&this._onKeyDown(e),t&&"focus"===e.type&&(this.focusTarget=e.target,this.options.autocomplete&&"focus"===this.options.autocomplete.trigger&&this._showAutoComplete(e.target)),"mousedown"===e.type&&this._startDragDistance(e),"mousemove"!==e.type&&"mouseup"!==e.type&&"click"!==e.type||this._updateDragDistance(e),t&&this.options&&this.options.navigationBar&&t&&("keydown"===e.type||"mousedown"===e.type)){var i=this;setTimeout(function(){i._updateTreePath(t.getNodePath())})}if(t&&t.selected){if("click"===e.type){if(e.target===t.dom.menu)return void this.showContextMenu(e.target);e.hasMoved||this.deselect()}"mousedown"===e.type&&j.onDragStart(this.multiselection.nodes,e)}else"mousedown"===e.type&&Object(M.hasParentNode)(e.target,this.content)&&(this.deselect(),t&&e.target===t.dom.drag?j.onDragStart(t,e):t&&(e.target===t.dom.field||e.target===t.dom.value||e.target===t.dom.select)||this._onMultiSelectStart(e));t&&t.onEvent(e)}},V._updateTreePath=function(e){if(e&&e.length){Object(M.removeClassName)(this.navBar,"nav-bar-empty");var i=[];e.forEach(function(e){var t={name:n(e),node:e,children:[]};e.childs&&e.childs.length&&e.childs.forEach(function(e){t.children.push({name:n(e),node:e})}),i.push(t)}),this.treePath.setPath(i)}else Object(M.addClassName)(this.navBar,"nav-bar-empty");function n(e){return e.parent?"array"===e.parent.type?e.index:e.field:e.type}},V._onTreePathSectionSelected=function(e){e&&e.node&&(e.node.expandTo(),e.node.focus())},V._onTreePathMenuItemSelected=function(e,t){if(e&&e.children.length){var i=e.children.find(function(e){return e.name===t});i&&i.node&&(this._updateTreePath(i.node.getNodePath()),i.node.expandTo(),i.node.focus())}},V._startDragDistance=function(e){this.dragDistanceEvent={initialTarget:e.target,initialPageX:e.pageX,initialPageY:e.pageY,dragDistance:0,hasMoved:!1}},V._updateDragDistance=function(e){this.dragDistanceEvent||this._startDragDistance(e);var t=e.pageX-this.dragDistanceEvent.initialPageX,i=e.pageY-this.dragDistanceEvent.initialPageY;return this.dragDistanceEvent.dragDistance=Math.sqrt(t*t+i*i),this.dragDistanceEvent.hasMoved=this.dragDistanceEvent.hasMoved||10<this.dragDistanceEvent.dragDistance,e.dragDistance=this.dragDistanceEvent.dragDistance,e.hasMoved=this.dragDistanceEvent.hasMoved,e.dragDistance},V._onMultiSelectStart=function(e){var t=j.getNodeFromTarget(e.target);if("tree"===this.options.mode&&void 0===this.options.onEditable){this.multiselection={start:t||null,end:null,nodes:[]},this._startDragDistance(e);var i=this;this.mousemove||(this.mousemove=Object(M.addEventListener)(window,"mousemove",function(e){i._onMultiSelect(e)})),this.mouseup||(this.mouseup=Object(M.addEventListener)(window,"mouseup",function(e){i._onMultiSelectEnd(e)})),e.preventDefault()}},V._onMultiSelect=function(e){if(e.preventDefault(),this._updateDragDistance(e),e.hasMoved){var t=j.getNodeFromTarget(e.target);t&&(null==this.multiselection.start&&(this.multiselection.start=t),this.multiselection.end=t),this.deselect();var i=this.multiselection.start,n=this.multiselection.end||this.multiselection.start;if(i&&n){if(this.multiselection.nodes=this._findTopLevelNodes(i,n),this.multiselection.nodes&&this.multiselection.nodes.length){var o=this.multiselection.nodes[0];this.multiselection.start===o||this.multiselection.start.isDescendantOf(o)?this.multiselection.direction="down":this.multiselection.direction="up"}this.select(this.multiselection.nodes)}}},V._onMultiSelectEnd=function(){this.multiselection.nodes[0]&&this.multiselection.nodes[0].dom.menu.focus(),this.multiselection.start=null,this.multiselection.end=null,this.mousemove&&(Object(M.removeEventListener)(window,"mousemove",this.mousemove),delete this.mousemove),this.mouseup&&(Object(M.removeEventListener)(window,"mouseup",this.mouseup),delete this.mouseup)},V.deselect=function(e){var t=!!this.multiselection.nodes.length;this.multiselection.nodes.forEach(function(e){e.setSelected(!1)}),this.multiselection.nodes=[],e&&(this.multiselection.start=null,this.multiselection.end=null),t&&this._selectionChangedHandler&&this._selectionChangedHandler()},V.select=function(e){if(!Array.isArray(e))return this.select([e]);if(e){this.deselect(),this.multiselection.nodes=e.slice(0);var t=e[0];if(e.forEach(function(e){e.expandPathToNode(),e.setSelected(!0,e===t)}),this._selectionChangedHandler){var i=this.getSelection();this._selectionChangedHandler(i.start,i.end)}}},V._findTopLevelNodes=function(e,t){for(var i=e.getNodePath(),n=t.getNodePath(),o=0;o<i.length&&i[o]===n[o];)o++;var r=i[o-1],s=i[o],a=n[o];if(s&&a||(r.parent?r=(a=s=r).parent:(s=r.childs[0],a=r.childs[r.childs.length-1])),r&&s&&a){var l=r.childs.indexOf(s),c=r.childs.indexOf(a),d=Math.min(l,c),h=Math.max(l,c);return r.childs.slice(d,h+1)}return[]},V._showAutoComplete=function(t){var i=j.getNodeFromTarget(t),n="";0<=t.className.indexOf("jsoneditor-value")&&(n="value"),0<=t.className.indexOf("jsoneditor-field")&&(n="field");var o=this;setTimeout(function(){if(i&&("focus"===o.options.autocomplete.trigger||0<t.innerText.length)){var e=o.options.autocomplete.getOptions(t.innerText,i.getPath(),n,i.editor);null===e?o.autocomplete.hideDropDown():"function"==typeof e.then?e.then(function(e){null===e?o.autocomplete.hideDropDown():e.options?o.autocomplete.show(t,e.startFrom,e.options):o.autocomplete.show(t,0,e)}).catch(function(e){console.error(e)}):e.options?o.autocomplete.show(t,e.startFrom,e.options):o.autocomplete.show(t,0,e)}else o.autocomplete.hideDropDown()},50)},V._onKeyDown=function(e){var t=e.which||e.keyCode,i=e.altKey,n=e.ctrlKey,o=e.metaKey,r=e.shiftKey,s=!1;if(9===t){var a=this;setTimeout(function(){Object(M.selectContentEditable)(a.focusTarget)},0)}if(this.searchBox)if(n&&70===t)this.searchBox.dom.search.focus(),this.searchBox.dom.search.select(),s=!0;else if(114===t||n&&71===t){r?this.searchBox.previous(!0):this.searchBox.next(!0),s=!0}this.history&&(n&&!r&&90===t?(this._onUndo(),s=!0):n&&r&&90===t&&(this._onRedo(),s=!0)),this.options.autocomplete&&!s&&(n||i||o||1!==e.key.length&&8!==t&&46!==t||(s=!1,this._showAutoComplete(e.target))),s&&(e.preventDefault(),e.stopPropagation())},V._createTable=function(){var e;this.options.navigationBar&&Object(M.addClassName)(this.contentOuter,"has-nav-bar"),this.scrollableContent=document.createElement("div"),this.scrollableContent.className="jsoneditor-tree",this.contentOuter.appendChild(this.scrollableContent),this.content=document.createElement("div"),this.content.className="jsoneditor-tree-inner",this.scrollableContent.appendChild(this.content),this.table=document.createElement("table"),this.table.className="jsoneditor-tree",this.content.appendChild(this.table),this.colgroupContent=document.createElement("colgroup"),"tree"===this.options.mode&&((e=document.createElement("col")).width="24px",this.colgroupContent.appendChild(e)),(e=document.createElement("col")).width="24px",this.colgroupContent.appendChild(e),e=document.createElement("col"),this.colgroupContent.appendChild(e),this.table.appendChild(this.colgroupContent),this.tbody=document.createElement("tbody"),this.table.appendChild(this.tbody),this.frame.appendChild(this.contentOuter)},V.showContextMenu=function(e,t){var i=[],n=this.multiselection.nodes.slice();if(i.push({text:Object(h.c)("duplicateText"),title:Object(h.c)("duplicateTitle"),className:"jsoneditor-duplicate",click:function(){j.onDuplicate(n)}}),i.push({text:Object(h.c)("remove"),title:Object(h.c)("removeTitle"),className:"jsoneditor-remove",click:function(){j.onRemove(n)}}),this.options.onCreateMenu){var o=n.map(function(e){return e.getPath()});i=this.options.onCreateMenu(i,{type:"multiple",path:o[0],paths:o})}new u.a(i,{close:t}).show(e,this.frame)},V.getSelection=function(){var e={start:null,end:null};if(this.multiselection.nodes&&this.multiselection.nodes.length&&this.multiselection.nodes.length){var t=this.multiselection.nodes[0],i=this.multiselection.nodes[this.multiselection.nodes.length-1];"down"===this.multiselection.direction?(e.start=t.serialize(),e.end=i.serialize()):(e.start=i.serialize(),e.end=t.serialize())}return e},V.onSelectionChange=function(e){"function"==typeof e&&(this._selectionChangedHandler=Object(M.debounce)(e,this.DEBOUNCE_INTERVAL))},V.setSelection=function(e,t){e&&e.dom&&e.range&&(console.warn("setSelection/getSelection usage for text selection is deprecated and should not be used, see documentation for supported selection options"),this.setDomSelection(e));var i=this._getNodeInstancesByRange(e,t);i.forEach(function(e){e.expandTo()}),this.select(i)},V._getNodeInstancesByRange=function(e,t){var i,n;e&&e.path&&(i=this.node.findNodeByPath(e.path),t&&t.path&&(n=this.node.findNodeByPath(t.path)));var o=[];if(i instanceof j)if(n instanceof j&&n!==i)if(i.parent===n.parent){t=i.getIndex()<n.getIndex()?(e=i,n):(e=n,i);var r=e;for(o.push(r);r=r.nextSibling(),o.push(r),r&&r!==t;);}else o=this._findTopLevelNodes(i,n);else o.push(i);return o},V.getNodesByRange=function(e,t){var i=this._getNodeInstancesByRange(e,t),n=[];return i.forEach(function(e){n.push(e.serialize())}),n};var B=[{mode:"tree",mixin:V,data:"json"},{mode:"view",mixin:V,data:"json"},{mode:"form",mixin:V,data:"json"}]},function(e,t,i){"use strict";i.r(t);var n=i(4),o=i.n(n),h=i(1),u=i(6),p=i(13),r=i(5),s=i(7),a=i(15),f=i(2),m=i(0);function l(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var v=function(){function n(e,t,i){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,n),this.onChange=e,this.calculateItemSize=t||function(){return 1},this.limit=i,this.items=[],this.index=-1}return function(e,t,i){t&&l(e.prototype,t),i&&l(e,i)}(n,[{key:"add",value:function(e){for(;this._calculateHistorySize()>this.limit&&1<this.items.length;)this.items.shift(),this.index--;this.items=this.items.slice(0,this.index+1),this.items.push(e),this.index++,this.onChange()}},{key:"_calculateHistorySize",value:function(){var t=this.calculateItemSize,i=0;return this.items.forEach(function(e){i+=t(e)}),i}},{key:"undo",value:function(){if(this.canUndo())return this.index--,this.onChange(),this.items[this.index]}},{key:"redo",value:function(){if(this.canRedo())return this.index++,this.onChange(),this.items[this.index]}},{key:"canUndo",value:function(){return 0<this.index}},{key:"canRedo",value:function(){return this.index<this.items.length-1}},{key:"clear",value:function(){this.items=[],this.index=-1,this.onChange()}}]),n}();i.d(t,"previewModeMixins",function(){return g});var c=a.textModeMixins[0].mixin,d={create:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};void 0===t.statusBar&&(t.statusBar=!0),t.mainMenuBar=!1!==t.mainMenuBar,t.enableSort=!1!==t.enableSort,t.enableTransform=!1!==t.enableTransform,"number"==typeof(this.options=t).indentation?this.indentation=Number(t.indentation):this.indentation=2,this.mode="preview";var i=this;if(this.container=e,this.dom={},this.json=void 0,this.text="",this._debouncedValidate=Object(m.debounce)(this.validate.bind(this),this.DEBOUNCE_INTERVAL),this.width=e.clientWidth,this.height=e.clientHeight,this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-preview",this.frame.onclick=function(e){e.preventDefault()},this.content=document.createElement("div"),this.content.className="jsoneditor-outer",this.dom.busy=document.createElement("div"),this.dom.busy.className="jsoneditor-busy",this.dom.busyContent=document.createElement("span"),this.dom.busyContent.innerHTML="busy...",this.dom.busy.appendChild(this.dom.busyContent),this.content.appendChild(this.dom.busy),this.dom.previewContent=document.createElement("pre"),this.dom.previewContent.className="jsoneditor-preview",this.dom.previewText=document.createTextNode(""),this.dom.previewContent.appendChild(this.dom.previewText),this.content.appendChild(this.dom.previewContent),this.options.mainMenuBar){Object(m.addClassName)(this.content,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu);var n=document.createElement("button");n.type="button",n.className="jsoneditor-format",n.title="Format JSON data, with proper indentation and line feeds (Ctrl+\\)",this.menu.appendChild(n),n.onclick=function(){i.executeWithBusyMessage(function(){try{i.format()}catch(e){i._onError(e)}},"formatting...")};var o=document.createElement("button");if(o.type="button",o.className="jsoneditor-compact",o.title="Compact JSON data, remove all whitespaces (Ctrl+Shift+\\)",this.menu.appendChild(o),o.onclick=function(){i.executeWithBusyMessage(function(){try{i.compact()}catch(e){i._onError(e)}},"compacting...")},this.options.enableSort){var r=document.createElement("button");r.type="button",r.className="jsoneditor-sort",r.title=Object(h.c)("sortTitleShort"),r.onclick=function(){i._showSortModal()},this.menu.appendChild(r)}if(this.options.enableTransform){var s=document.createElement("button");s.type="button",s.title=Object(h.c)("transformTitleShort"),s.className="jsoneditor-transform",s.onclick=function(){i._showTransformModal()},this.dom.transform=s,this.menu.appendChild(s)}var a=document.createElement("button");if(a.type="button",a.className="jsoneditor-repair",a.title="Repair JSON: fix quotes and escape characters, remove comments and JSONP notation, turn JavaScript objects into JSON.",this.menu.appendChild(a),!(a.onclick=function(){void 0===i.json&&i.executeWithBusyMessage(function(){try{i.repair()}catch(e){i._onError(e)}},"repairing...")})!==this.options.history){this.history=new v(function(){i.dom.undo.disabled=!i.history.canUndo(),i.dom.redo.disabled=!i.history.canRedo()},function(e){return 2*e.text.length},f.c);var l=document.createElement("button");l.type="button",l.className="jsoneditor-undo jsoneditor-separator",l.title=Object(h.c)("undo"),l.onclick=function(){var e=i.history.undo();e&&i._applyHistory(e)},this.menu.appendChild(l),this.dom.undo=l;var c=document.createElement("button");c.type="button",c.className="jsoneditor-redo",c.title=Object(h.c)("redo"),c.onclick=function(){var e=i.history.redo();e&&i._applyHistory(e)},this.menu.appendChild(c),this.dom.redo=c,this.history.onChange()}this.options&&this.options.modes&&this.options.modes.length&&(this.modeSwitcher=new u.a(this.menu,this.options.modes,this.options.mode,function(e){i.setMode(e),i.modeSwitcher.focus()}))}if(this.errorTable=new p.a({errorTableVisible:!0,
onToggleVisibility:function(){i.validate()},onFocusLine:null,onChangeHeight:function(e){var t=e+(i.dom.statusBar?i.dom.statusBar.clientHeight:0)+1;i.content.style.marginBottom=-t+"px",i.content.style.paddingBottom=t+"px"}}),this.frame.appendChild(this.content),this.frame.appendChild(this.errorTable.getErrorTable()),this.container.appendChild(this.frame),t.statusBar){Object(m.addClassName)(this.content,"has-status-bar");var d=document.createElement("div");(this.dom.statusBar=d).className="jsoneditor-statusbar",this.frame.appendChild(d),this.dom.fileSizeInfo=document.createElement("span"),this.dom.fileSizeInfo.className="jsoneditor-size-info",this.dom.fileSizeInfo.innerText="",d.appendChild(this.dom.fileSizeInfo),this.dom.arrayInfo=document.createElement("span"),this.dom.arrayInfo.className="jsoneditor-size-info",this.dom.arrayInfo.innerText="",d.appendChild(this.dom.arrayInfo),d.appendChild(this.errorTable.getErrorCounter()),d.appendChild(this.errorTable.getWarningIcon()),d.appendChild(this.errorTable.getErrorIcon())}this._renderPreview(),this.setSchema(this.options.schema,this.options.schemaRefs)},_renderPreview:function(){var e=this.getText();this.dom.previewText.nodeValue=Object(m.limitCharacters)(e,f.b),this.dom.fileSizeInfo&&(this.dom.fileSizeInfo.innerText="Size: "+Object(m.formatSize)(e.length)),this.dom.arrayInfo&&(Array.isArray(this.json)?this.dom.arrayInfo.innerText="Array: "+this.json.length+" items":this.dom.arrayInfo.innerText="")},_onChange:function(){if(this._debouncedValidate(),this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}if(this.options.onChangeJSON)try{this.options.onChangeJSON(this.get())}catch(e){console.error("Error in onChangeJSON callback: ",e)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(e){console.error("Error in onChangeText callback: ",e)}}};d._showSortModal=function(){var o=this;this.executeWithBusyMessage(function(){var e=o.options.modalAnchor||f.a,t=o.get();o._renderPreview(),Object(r.a)(e,t,function(e){o.executeWithBusyMessage(function(){!function(e,t){if(Array.isArray(e)){var i=Object(m.sort)(e,t.path,t.direction);o.sortedBy=t,o._setAndFireOnChange(i)}if(Object(m.isObject)(e)){var n=Object(m.sortObjectKeys)(e,t.direction);o.sortedBy=t,o._setAndFireOnChange(n)}}(t,e)},"sorting...")},o.sortedBy)},"parsing...")},d._showTransformModal=function(){var n=this;this.executeWithBusyMessage(function(){var e=n.options.modalAnchor||f.a,i=n.get();n._renderPreview(),Object(s.a)(e,i,function(t){n.executeWithBusyMessage(function(){var e=o.a.search(i,t);n._setAndFireOnChange(e)},"transforming...")})},"parsing...")},d.destroy=function(){this.frame&&this.container&&this.frame.parentNode===this.container&&this.container.removeChild(this.frame),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this._debouncedValidate=null,this.history.clear(),this.history=null},d.compact=function(){var e=this.get(),t=JSON.stringify(e);this._setTextAndFireOnChange(t,e)},d.format=function(){var e=this.get(),t=JSON.stringify(e,null,this.indentation);this._setTextAndFireOnChange(t,e)},d.repair=function(){var e=this.getText(),t=Object(m.repair)(e);this._setTextAndFireOnChange(t)},d.focus=function(){this.dom.transform.focus()},d.set=function(e){this.history&&this.history.clear(),this._set(e)},d.update=function(e){this._set(e)},d._set=function(e){this.text=void 0,this.json=e,this._renderPreview(),this._pushHistory(),this._debouncedValidate()},d._setAndFireOnChange=function(e){this._set(e),this._onChange()},d.get=function(){if(void 0===this.json){var e=this.getText();this.json=Object(m.parse)(e)}return this.json},d.getText=function(){return void 0===this.text&&(this.text=JSON.stringify(this.json,null,this.indentation),!0===this.options.escapeUnicode&&(this.text=Object(m.escapeUnicodeChars)(this.text))),this.text},d.setText=function(e){this.history&&this.history.clear(),this._setText(e)},d.updateText=function(e){this.getText()!==e&&this._setText(e)},d._setText=function(e,t){if(!0===this.options.escapeUnicode?this.text=Object(m.escapeUnicodeChars)(e):this.text=e,this.json=t,this._renderPreview(),void 0===this.json){var i=this;this.executeWithBusyMessage(function(){try{i.json=i.get(),i._renderPreview(),i._pushHistory()}catch(e){}},"parsing...")}else this._pushHistory();this._debouncedValidate()},d._setTextAndFireOnChange=function(e,t){this._setText(e,t),this._onChange()},d._applyHistory=function(e){this.json=e.json,this.text=e.text,this._renderPreview(),this._debouncedValidate()},d._pushHistory=function(){if(this.history){var e={text:this.text,json:this.json};this.history.add(e)}},d.executeWithBusyMessage=function(e,t){if(this.getText().length>f.d){var i=this;Object(m.addClassName)(i.frame,"busy"),i.dom.busyContent.innerText=t,setTimeout(function(){e(),Object(m.removeClassName)(i.frame,"busy"),i.dom.busyContent.innerText=""},100)}else e()},d.validate=c.validate,d._renderErrors=c._renderErrors;var g=[{mode:"preview",mixin:d,data:"json"}]}],o.c=n,o.d=function(e,t,i){o.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:i})},o.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},o.t=function(t,e){if(1&e&&(t=o(t)),8&e)return t;if(4&e&&"object"==typeof t&&t&&t.__esModule)return t;var i=Object.create(null);if(o.r(i),Object.defineProperty(i,"default",{enumerable:!0,value:t}),2&e&&"string"!=typeof t)for(var n in t)o.d(i,n,function(e){return t[e]}.bind(null,n));return i},o.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return o.d(t,"a",t),t},o.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},o.p="",o(o.s=20);function o(e){if(n[e])return n[e].exports;var t=n[e]={i:e,l:!1,exports:{}};return i[e].call(t.exports,t,t.exports,o),t.l=!0,t.exports}var i,n});
//# sourceMappingURL=jsoneditor-minimalist.map