/*!
 * jsoneditor.js
 *
 * @brief
 * JSONEditor is a web-based tool to view, edit, format, and validate JSON.
 * It has various modes such as a tree editor, a code editor, and a plain text
 * editor.
 *
 * Supported browsers: Chrome, Firefox, Safari, Opera, Internet Explorer 8+
 *
 * @license
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 * Copyright (c) 2011-2019 Jos de Jong, http://jsoneditoronline.org
 *
 * @author  Jos de Jong, <wjosdejong@gmail.com>
 * @version 7.2.1
 * @date    2019-10-27
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define([],t):"object"==typeof exports?exports.JSONEditor=t():e.JSONEditor=t()}(window,function(){return n={},r.m=i=[function(e,t,i){"use strict";i.r(t),i.d(t,"parse",function(){return u}),i.d(t,"repair",function(){return g}),i.d(t,"escapeUnicodeChars",function(){return p}),i.d(t,"validate",function(){return m}),i.d(t,"extend",function(){return f}),i.d(t,"clear",function(){return C}),i.d(t,"getType",function(){return I}),i.d(t,"isUrl",function(){return v}),i.d(t,"isArray",function(){return b}),i.d(t,"getAbsoluteLeft",function(){return y}),i.d(t,"getAbsoluteTop",function(){return w}),i.d(t,"addClassName",function(){return S}),i.d(t,"removeAllClassNames",function(){return x}),i.d(t,"removeClassName",function(){return k}),i.d(t,"stripFormatting",function(){return R}),i.d(t,"setEndOfContentEditable",function(){return E}),i.d(t,"selectContentEditable",function(){return B}),i.d(t,"getSelection",function(){return G}),i.d(t,"setSelection",function(){return Z}),i.d(t,"getSelectionOffset",function(){return T}),i.d(t,"setSelectionOffset",function(){return W}),i.d(t,"getInnerText",function(){return _}),i.d(t,"hasParentNode",function(){return H}),i.d(t,"getInternetExplorerVersion",function(){return L}),i.d(t,"isFirefox",function(){return $}),i.d(t,"addEventListener",function(){return N}),i.d(t,"removeEventListener",function(){return O}),i.d(t,"isChildOf",function(){return F}),i.d(t,"parsePath",function(){return P}),i.d(t,"stringifyPath",function(){return K}),i.d(t,"improveSchemaError",function(){return M}),i.d(t,"isPromise",function(){return D}),i.d(t,"isValidValidationError",function(){return j}),i.d(t,"insideRect",function(){return X}),i.d(t,"debounce",function(){return Y}),i.d(t,"textDiff",function(){return J}),i.d(t,"getInputSelection",function(){return z}),i.d(t,"getIndexForPosition",function(){return U}),i.d(t,"getPositionForPath",function(){return Q}),i.d(t,"compileJSONPointer",function(){return q}),i.d(t,"getColorCSS",function(){return ee}),i.d(t,"isValidColor",function(){return te}),i.d(t,"makeFieldTooltip",function(){return ie}),i.d(t,"get",function(){return ne}),i.d(t,"findUniqueName",function(){return re}),i.d(t,"getChildPaths",function(){return oe}),i.d(t,"sort",function(){return se}),i.d(t,"sortObjectKeys",function(){return ae}),i.d(t,"parseString",function(){return le}),i.d(t,"formatSize",function(){return ce}),i.d(t,"limitCharacters",function(){return he}),i.d(t,"isObject",function(){return de}),i.d(t,"contains",function(){return ue});i(23);var n=i(10),o=i.n(n),r=i(21),s=i.n(r),a=i(32),l=i.n(a),c=i(1);function h(e){return(h="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var d=1e4;function u(t){try{return JSON.parse(t)}catch(e){throw m(t),e}}function g(n){var i=[],r=0,e=n.match(/^\s*(\/\*(.|[\r\n])*?\*\/)?\s*[\da-zA-Z_$]+\s*\(([\s\S]*)\)\s*;?\s*$/);e&&(n=e[3]);var t,o={"\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t"};function s(){return n.charAt(r)}function a(){return n.charAt(r+1)}function l(e){return" "===e||"\n"===e||"\r"===e||"\t"===e}function c(){for(var e=i.length-1;0<=e;){var t=i[e];if(!l(t))return t;e--}return""}function h(){for(var e=r+1;e<n.length&&l(n[e]);)e++;return n[e]}function d(){for(r+=2;r<n.length&&("*"!==s()||"/"!==a());)r++;r+=2}function u(){for(r+=2;r<n.length&&"\n"!==s();)r++}function g(e){var t="";t+='"',r++;for(var i=s();r<n.length&&i!==e;)'"'===i&&"\\"!==n.charAt(r-1)?t+='\\"':i in o?t+=o[i]:("\\"===i&&(r++,"'"!==(i=s())&&(t+="\\")),t+=i),r++,i=s();return i===e&&(t+='"',r++),t}function p(){for(var e="",t=s(),i=/[a-zA-Z_$\d]/;i.test(t);)e+=t,r++,t=s();return-1===["null","true","false"].indexOf(e)?'"'+e+'"':e}function m(){for(var e,t=s(),i="";/[a-zA-Z_$]/.test(t);)i+=t,r++,t=s();if(0<i.length&&"("===t){if(r++,'"'===(t=s()))e=g(t),t=s();else for(e="";")"!==t&&""!==t;)e+=t,r++,t=s();return")"===t?(r++,e):i+"("+e+t}return i}for(;r<n.length;){var f=s();"/"===f&&"*"===a()?d():"/"===f&&"/"===a()?u():" "===(t=f)||" "<=t&&t<=" "||" "===t||" "===t||"　"===t?(i.push(" "),r++):"'"===f?i.push(g(f)):'"'===f?i.push(g('"')):"`"===f?i.push(g("´")):"‘"===f?i.push(g("’")):"“"===f?i.push(g("”")):","===f&&-1!==["]","}"].indexOf(h())?r++:/[a-zA-Z_$]/.test(f)&&-1!==["{",","].indexOf(c())?i.push(p()):/[a-zA-Z_$]/.test(f)?i.push(m()):(i.push(f),r++)}return i.join("")}function p(e){return e.replace(/[\u007F-\uFFFF]/g,function(e){return"\\u"+("0000"+e.charCodeAt(0).toString(16)).slice(-4)})}function m(e){void 0!==s.a?s.a.parse(e):JSON.parse(e)}function f(e,t){for(var i in t)ge(t,i)&&(e[i]=t[i]);return e}function C(e){for(var t in e)ge(e,t)&&delete e[t];return e}function I(e){return null===e?"null":void 0===e?"undefined":e instanceof Number||"number"==typeof e?"number":e instanceof String||"string"==typeof e?"string":e instanceof Boolean||"boolean"==typeof e?"boolean":e instanceof RegExp?"regexp":b(e)?"array":"object"}var A=/^https?:\/\/\S+$/;function v(e){return("string"==typeof e||e instanceof String)&&A.test(e)}function b(e){return"[object Array]"===Object.prototype.toString.call(e)}function y(e){return e.getBoundingClientRect().left+window.pageXOffset||document.scrollLeft||0}function w(e){return e.getBoundingClientRect().top+window.pageYOffset||document.scrollTop||0}function S(e,t){var i=e.className.split(" ");-1===i.indexOf(t)&&(i.push(t),e.className=i.join(" "))}function x(e){e.className=""}function k(e,t){var i=e.className.split(" "),n=i.indexOf(t);-1!==n&&(i.splice(n,1),e.className=i.join(" "))}function R(e){for(var t=e.childNodes,i=0,n=t.length;i<n;i++){var r=t[i];r.style&&r.removeAttribute("style");var o=r.attributes;if(o)for(var s=o.length-1;0<=s;s--){var a=o[s];!0===a.specified&&r.removeAttribute(a.name)}R(r)}}function E(e){var t,i;document.createRange&&((t=document.createRange()).selectNodeContents(e),t.collapse(!1),(i=window.getSelection()).removeAllRanges(),i.addRange(t))}function B(e){var t,i;e&&"DIV"===e.nodeName&&window.getSelection&&document.createRange&&((i=document.createRange()).selectNodeContents(e),(t=window.getSelection()).removeAllRanges(),t.addRange(i))}function G(){if(window.getSelection){var e=window.getSelection();if(e.getRangeAt&&e.rangeCount)return e.getRangeAt(0)}return null}function Z(e){if(e&&window.getSelection){var t=window.getSelection();t.removeAllRanges(),t.addRange(e)}}function T(){var e=G();return e&&"startOffset"in e&&"endOffset"in e&&e.startContainer&&e.startContainer===e.endContainer?{startOffset:e.startOffset,endOffset:e.endOffset,container:e.startContainer.parentNode}:null}function W(e){if(document.createRange&&window.getSelection&&window.getSelection()){var t=document.createRange();e.container.firstChild||e.container.appendChild(document.createTextNode("")),t.setStart(e.container.firstChild,e.startOffset),t.setEnd(e.container.firstChild,e.endOffset),Z(t)}}function _(e,t){if(void 0===t&&(t={text:"",flush:function(){var e=this.text;return this.text="",e},set:function(e){this.text=e}}),e.nodeValue)return t.flush()+e.nodeValue;if(e.hasChildNodes()){for(var i=e.childNodes,n="",r=0,o=i.length;r<o;r++){var s=i[r];if("DIV"===s.nodeName||"P"===s.nodeName){var a=i[r-1],l=a?a.nodeName:void 0;l&&"DIV"!==l&&"P"!==l&&"BR"!==l&&(n+="\n",t.flush()),n+=_(s,t),t.set("\n")}else"BR"===s.nodeName?(n+=t.flush(),t.set("\n")):n+=_(s,t)}return n}return"P"===e.nodeName&&-1!==L()?t.flush():""}function H(e,t){for(var i=e?e.parentNode:void 0;i;){if(i===t)return!0;i=i.parentNode}return!1}function L(){if(-1===V){var e=-1;if("undefined"!=typeof navigator&&"Microsoft Internet Explorer"===navigator.appName){var t=navigator.userAgent;null!=new RegExp("MSIE ([0-9]+[.0-9]+)").exec(t)&&(e=parseFloat(RegExp.$1))}V=e}return V}function $(){return"undefined"!=typeof navigator&&-1!==navigator.userAgent.indexOf("Firefox")}var V=-1;function N(e,t,i,n){if(e.addEventListener)return void 0===n&&(n=!1),"mousewheel"===t&&$()&&(t="DOMMouseScroll"),e.addEventListener(t,i,n),i;if(e.attachEvent){var r=function(){return i.call(e,window.event)};return e.attachEvent("on"+t,r),r}}function O(e,t,i,n){e.removeEventListener?(void 0===n&&(n=!1),"mousewheel"===t&&$()&&(t="DOMMouseScroll"),e.removeEventListener(t,i,n)):e.detachEvent&&e.detachEvent("on"+t,i)}function F(e,t){for(var i=e.parentNode;i;){if(i===t)return!0;i=i.parentNode}return!1}function P(i){var e=[],n=0;function t(){for(var e="";void 0!==i[n]&&/[\w$]/.test(i[n]);)e+=i[n],n++;if(""===e)throw new Error("Invalid JSON path: property name expected at index "+n);return e}function r(e){for(var t="";void 0!==i[n]&&i[n]!==e;)t+=i[n],n++;if(i[n]!==e)throw new Error("Invalid JSON path: unexpected end, character "+e+" expected");return t}for(;void 0!==i[n];)if("."===i[n])n++,e.push(t());else{if("["!==i[n])throw new Error('Invalid JSON path: unexpected character "'+i[n]+'" at index '+n);if("'"===i[++n]||'"'===i[n]){var o=i[n];if(n++,e.push(r(o)),i[n]!==o)throw new Error("Invalid JSON path: closing quote ' expected at index "+n);n++}else{var s=r("]").trim();if(0===s.length)throw new Error("Invalid JSON path: array value expected at index "+n);s="*"===s?s:JSON.parse(s),e.push(s)}if("]"!==i[n])throw new Error("Invalid JSON path: closing bracket ] expected at index "+n);n++}return e}function K(e){return e.map(function(e){return"number"==typeof e?"["+e+"]":"string"==typeof e&&e.match(/^[A-Za-z0-9_$]+$/)?"."+e:'["'+e+'"]'}).join("")}function M(e){if("enum"===e.keyword&&Array.isArray(e.schema)){var t=e.schema;if(t){if(5<(t=t.map(function(e){return JSON.stringify(e)})).length){var i=["("+(t.length-5)+" more...)"];(t=t.slice(0,5)).push(i)}e.message="should be equal to one of: "+t.join(", ")}}return"additionalProperties"===e.keyword&&(e.message="should NOT have additional property: "+e.params.additionalProperty),e}function D(e){return e&&"function"==typeof e.then&&"function"==typeof e.catch}function j(e){return"object"===h(e)&&Array.isArray(e.path)&&"string"==typeof e.message}function X(e,t,i){var n=void 0!==i?i:0;return t.left-n>=e.left&&t.right+n<=e.right&&t.top-n>=e.top&&t.bottom+n<=e.bottom}function Y(n,r,o){var s;return function(){var e=this,t=arguments,i=o&&!s;clearTimeout(s),s=setTimeout(function(){s=null,o||n.apply(e,t)},r),i&&n.apply(e,t)}}function J(e,t){for(var i=t.length,n=0,r=e.length,o=t.length;t.charAt(n)===e.charAt(n)&&n<i;)n++;for(;t.charAt(o-1)===e.charAt(r-1)&&n<o&&0<r;)o--,r--;return{start:n,end:o}}function z(i){var e,t,n,r,o,s=0,a=0;return"number"==typeof i.selectionStart&&"number"==typeof i.selectionEnd?(s=i.selectionStart,a=i.selectionEnd):(t=document.selection.createRange())&&t.parentElement()===i&&(r=i.value.length,e=i.value.replace(/\r\n/g,"\n"),(n=i.createTextRange()).moveToBookmark(t.getBookmark()),(o=i.createTextRange()).collapse(!1),-1<n.compareEndPoints("StartToEnd",o)?s=a=r:(s=-n.moveStart("character",-r),s+=e.slice(0,s).split("\n").length-1,-1<n.compareEndPoints("EndToEnd",o)?a=r:(a=-n.moveEnd("character",-r),a+=e.slice(0,a).split("\n").length-1))),{startIndex:s,endIndex:a,start:l(s),end:l(a)};function l(e){var t=i.value.substring(0,e);return{row:(t.match(/\n/g)||[]).length+1,column:t.length-t.lastIndexOf("\n")}}}function U(e,t,i){var n=e.value||"";if(0<t&&0<i){var r=n.split("\n",t);t=Math.min(r.length,t),i=Math.min(r[t-1].length,i-1);var o=1===t?i:i+1;return r.slice(0,t-1).join("\n").length+o}return-1}function Q(e,t){var n,r=[];if(!t||!t.length)return r;try{n=l.a.parse(e)}catch(e){return r}return t.forEach(function(e){var t=q(P(e)),i=n.pointers[t];i&&r.push({path:e,line:i.key?i.key.line:i.value?i.value.line:0,column:i.key?i.key.column:i.value?i.value.column:0})}),r}function q(e){return e.map(function(e){return"/"+String(e).replace(/~/g,"~0").replace(/\//g,"~1")}).join("")}function ee(e){var t=document.createElement("div");return t.style.color=e,t.style.color.split(/\s+/).join("").toLowerCase()||null}function te(e){return!!ee(e)}function ie(i,e){if(!i)return"";var n="";return i.title&&(n+=i.title),i.description&&(0<n.length&&(n+="\n"),n+=i.description),i.default&&(0<n.length&&(n+="\n\n"),n+=Object(c.c)("default",void 0,e)+"\n",n+=JSON.stringify(i.default,null,2)),Array.isArray(i.examples)&&0<i.examples.length&&(0<n.length&&(n+="\n\n"),n+=Object(c.c)("examples",void 0,e)+"\n",i.examples.forEach(function(e,t){n+=JSON.stringify(e,null,2),t!==i.examples.length-1&&(n+="\n")})),n}function ne(e,t){for(var i=e,n=0;n<t.length&&null!=i;n++)i=i[t[n]];return i}function re(e,t){for(var i=e.replace(/ \(copy( \d+)?\)$/,""),n=i,r=1;-1!==t.indexOf(n);){n=i+" ("+("copy"+(1<r?" "+r:""))+")",r++}return n}function oe(e,t){var i={};function o(t,i,n,r){(Array.isArray(t)||de(t))&&!r||(i[n||""]=!0),de(t)&&Object.keys(t).forEach(function(e){o(t[e],i,n+"."+e,r)})}if(Array.isArray(e))for(var n=Math.min(e.length,d),r=0;r<n;r++){o(e[r],i,"",t)}else i[""]=!0;return Object.keys(i).sort()}function se(e,t,i){var r=t&&"."!==t?P(t):[],o="desc"===i?-1:1,n=e.slice();return n.sort(function(e,t){var i=ne(e,r),n=ne(t,r);return o*(n<i?1:i<n?-1:0)}),n}function ae(t,e){var i="desc"===e?-1:1,n=Object.keys(t).sort(function(e,t){return i*o()(e,t)}),r={};return n.forEach(function(e){r[e]=t[e]}),r}function le(e){if(""===e)return"";var t=e.toLowerCase();if("null"===t)return null;if("true"===t)return!0;if("false"===t)return!1;var i=Number(e),n=parseFloat(e);return isNaN(i)||isNaN(n)?e:i}function ce(e){if(e<900)return e.toFixed()+" B";var t=e/1024;if(t<900)return t.toFixed(1)+" KiB";var i=t/1024;if(i<900)return i.toFixed(1)+" MiB";var n=i/1024;return n<900?n.toFixed(1)+" GiB":(n/1024).toFixed(1)+" TiB"}function he(e,t){return e.length<=t?e:e.slice(0,t)+"..."}function de(e){return"object"===h(e)&&null!==e&&!Array.isArray(e)}function ue(e,t){return-1!==e.indexOf(t)}function ge(e,t){return Object.prototype.hasOwnProperty.call(e,t)}},function(e,t,i){"use strict";i.d(t,"a",function(){return l}),i.d(t,"b",function(){return c}),i.d(t,"c",function(){return h});i(23);var n=["en","pt-BR","zh-CN","tr","ja","fr-FR"],r={en:{array:"Array",auto:"Auto",appendText:"Append",appendTitle:"Append a new field with type 'auto' after this field (Ctrl+Shift+Ins)",appendSubmenuTitle:"Select the type of the field to be appended",appendTitleAuto:"Append a new field with type 'auto' (Ctrl+Shift+Ins)",ascending:"Ascending",ascendingTitle:"Sort the childs of this ${type} in ascending order",actionsMenu:"Click to open the actions menu (Ctrl+M)",collapseAll:"Collapse all fields",descending:"Descending",descendingTitle:"Sort the childs of this ${type} in descending order",drag:"Drag to move this field (Alt+Shift+Arrows)",duplicateKey:"duplicate key",duplicateText:"Duplicate",duplicateTitle:"Duplicate selected fields (Ctrl+D)",duplicateField:"Duplicate this field (Ctrl+D)",duplicateFieldError:"Duplicate field name",cannotParseFieldError:"Cannot parse field into JSON",cannotParseValueError:"Cannot parse value into JSON",empty:"empty",expandAll:"Expand all fields",expandTitle:"Click to expand/collapse this field (Ctrl+E). \nCtrl+Click to expand/collapse including all childs.",insert:"Insert",insertTitle:"Insert a new field with type 'auto' before this field (Ctrl+Ins)",insertSub:"Select the type of the field to be inserted",object:"Object",ok:"Ok",redo:"Redo (Ctrl+Shift+Z)",removeText:"Remove",removeTitle:"Remove selected fields (Ctrl+Del)",removeField:"Remove this field (Ctrl+Del)",searchTitle:"Search fields and values",searchNextResultTitle:"Next result (Enter)",searchPreviousResultTitle:"Previous result (Shift + Enter)",selectNode:"Select a node...",showAll:"show all",showMore:"show more",showMoreStatus:"displaying ${visibleChilds} of ${totalChilds} items.",sort:"Sort",sortTitle:"Sort the childs of this ${type}",sortTitleShort:"Sort contents",sortFieldLabel:"Field:",sortDirectionLabel:"Direction:",sortFieldTitle:"Select the nested field by which to sort the array or object",sortAscending:"Ascending",sortAscendingTitle:"Sort the selected field in ascending order",sortDescending:"Descending",sortDescendingTitle:"Sort the selected field in descending order",string:"String",transform:"Transform",transformTitle:"Filter, sort, or transform the childs of this ${type}",transformTitleShort:"Filter, sort, or transform contents",extract:"Extract",extractTitle:"Extract this ${type}",transformQueryTitle:"Enter a JMESPath query",transformWizardLabel:"Wizard",transformWizardFilter:"Filter",transformWizardSortBy:"Sort by",transformWizardSelectFields:"Select fields",transformQueryLabel:"Query",transformPreviewLabel:"Preview",type:"Type",typeTitle:"Change the type of this field",openUrl:"Ctrl+Click or Ctrl+Enter to open url in new window",undo:"Undo last action (Ctrl+Z)",validationCannotMove:"Cannot move a field into a child of itself",autoType:'Field type "auto". The field type is automatically determined from the value and can be a string, number, boolean, or null.',objectType:'Field type "object". An object contains an unordered set of key/value pairs.',arrayType:'Field type "array". An array contains an ordered collection of values.',stringType:'Field type "string". Field type is not determined from the value, but always returned as string.',modeEditorTitle:"Switch Editor Mode",modeCodeText:"Code",modeCodeTitle:"Switch to code highlighter",modeFormText:"Form",modeFormTitle:"Switch to form editor",modeTextText:"Text",modeTextTitle:"Switch to plain text editor",modeTreeText:"Tree",modeTreeTitle:"Switch to tree editor",modeViewText:"View",modeViewTitle:"Switch to tree view",modePreviewText:"Preview",modePreviewTitle:"Switch to preview mode",examples:"Examples",default:"Default"},"zh-CN":{array:"数组",auto:"自动",appendText:"追加",appendTitle:"在此字段后追加一个类型为“auto”的新字段 (Ctrl+Shift+Ins)",appendSubmenuTitle:"选择要追加的字段类型",appendTitleAuto:"追加类型为“auto”的新字段 (Ctrl+Shift+Ins)",ascending:"升序",ascendingTitle:"升序排列${type}的子节点",actionsMenu:"点击打开动作菜单(Ctrl+M)",collapseAll:"缩进所有字段",descending:"降序",descendingTitle:"降序排列${type}的子节点",drag:"拖拽移动该节点(Alt+Shift+Arrows)",duplicateKey:"重复键",duplicateText:"复制",duplicateTitle:"复制选中字段(Ctrl+D)",duplicateField:"复制该字段(Ctrl+D)",duplicateFieldError:"重复的字段名称",cannotParseFieldError:"无法将字段解析为JSON",cannotParseValueError:"无法将值解析为JSON",empty:"清空",expandAll:"展开所有字段",expandTitle:"点击 展开/收缩 该字段(Ctrl+E). \nCtrl+Click 展开/收缩 包含所有子节点.",insert:"插入",insertTitle:"在此字段前插入类型为“auto”的新字段 (Ctrl+Ins)",insertSub:"选择要插入的字段类型",object:"对象",ok:"Ok",redo:"重做 (Ctrl+Shift+Z)",removeText:"移除",removeTitle:"移除选中字段 (Ctrl+Del)",removeField:"移除该字段 (Ctrl+Del)",selectNode:"选择一个节点...",showAll:"展示全部",showMore:"展示更多",showMoreStatus:"显示${totalChilds}的${visibleChilds}项目.",sort:"排序",sortTitle:"排序${type}的子节点",sortTitleShort:"内容排序",sortFieldLabel:"字段：",sortDirectionLabel:"方向：",sortFieldTitle:"选择用于对数组或对象排序的嵌套字段",sortAscending:"升序排序",sortAscendingTitle:"按照该字段升序排序",sortDescending:"降序排序",sortDescendingTitle:"按照该字段降序排序",string:"字符串",transform:"变换",transformTitle:"筛选，排序，或者转换${type}的子节点",transformTitleShort:"筛选，排序，或者转换内容",extract:"提取",extractTitle:"提取这个 ${type}",transformQueryTitle:"输入JMESPath查询",transformWizardLabel:"向导",transformWizardFilter:"筛选",transformWizardSortBy:"排序",transformWizardSelectFields:"选择字段",transformQueryLabel:"查询",transformPreviewLabel:"预览",type:"类型",typeTitle:"更改字段类型",openUrl:"Ctrl+Click 或者 Ctrl+Enter 在新窗口打开链接",undo:"撤销上次动作 (Ctrl+Z)",validationCannotMove:"无法将字段移入其子节点",autoType:'字段类型 "auto". 字段类型由值自动确定 可以为 string，number，boolean，或者 null.',objectType:'字段类型 "object". 对象包含一组无序的键/值对.',arrayType:'字段类型 "array". 数组包含值的有序集合.',stringType:'字段类型 "string". 字段类型由值自动确定，但始终作为字符串返回.',modeCodeText:"代码",modeCodeTitle:"切换至代码高亮",modeFormText:"表单",modeFormTitle:"切换至表单编辑",modeTextText:"文本",modeTextTitle:"切换至文本编辑",modeTreeText:"树",modeTreeTitle:"切换至树编辑",modeViewText:"视图",modeViewTitle:"切换至树视图",modePreviewText:"预览",modePreviewTitle:"切换至预览模式",examples:"例子",default:"缺省"},"pt-BR":{array:"Lista",auto:"Automatico",appendText:"Adicionar",appendTitle:"Adicionar novo campo com tipo 'auto' depois deste campo (Ctrl+Shift+Ins)",appendSubmenuTitle:"Selecione o tipo do campo a ser adicionado",appendTitleAuto:"Adicionar novo campo com tipo 'auto' (Ctrl+Shift+Ins)",ascending:"Ascendente",ascendingTitle:"Organizar filhor do tipo ${type} em crescente",actionsMenu:"Clique para abrir o menu de ações (Ctrl+M)",collapseAll:"Fechar todos campos",descending:"Descendente",descendingTitle:"Organizar o filhos do tipo ${type} em decrescente",duplicateKey:"chave duplicada",drag:"Arraste para mover este campo (Alt+Shift+Arrows)",duplicateText:"Duplicar",duplicateTitle:"Duplicar campos selecionados (Ctrl+D)",duplicateField:"Duplicar este campo (Ctrl+D)",duplicateFieldError:"Nome do campo duplicado",cannotParseFieldError:"Não é possível analisar o campo no JSON",cannotParseValueError:"Não é possível analisar o valor em JSON",empty:"vazio",expandAll:"Expandir todos campos",expandTitle:"Clique para expandir/encolher este campo (Ctrl+E). \nCtrl+Click para expandir/encolher incluindo todos os filhos.",insert:"Inserir",insertTitle:"Inserir um novo campo do tipo 'auto' antes deste campo (Ctrl+Ins)",insertSub:"Selecionar o tipo de campo a ser inserido",object:"Objeto",ok:"Ok",redo:"Refazer (Ctrl+Shift+Z)",removeText:"Remover",removeTitle:"Remover campos selecionados (Ctrl+Del)",removeField:"Remover este campo (Ctrl+Del)",selectNode:"Selecione um nódulo...",showAll:"mostrar todos",showMore:"mostrar mais",showMoreStatus:"exibindo ${visibleChilds} de ${totalChilds} itens.",sort:"Organizar",sortTitle:"Organizar os filhos deste ${type}",sortTitleShort:"Organizar os filhos",sortFieldLabel:"Campo:",sortDirectionLabel:"Direção:",sortFieldTitle:"Selecione um campo filho pelo qual ordenar o array ou objeto",sortAscending:"Ascendente",sortAscendingTitle:"Ordenar o campo selecionado por ordem ascendente",sortDescending:"Descendente",sortDescendingTitle:"Ordenar o campo selecionado por ordem descendente",string:"Texto",transform:"Transformar",transformTitle:"Filtrar, ordenar ou transformar os filhos deste ${type}",transformTitleShort:"Filtrar, ordenar ou transformar conteúdos",transformQueryTitle:"Insira uma expressão JMESPath",transformWizardLabel:"Assistente",transformWizardFilter:"Filtro",transformWizardSortBy:"Ordenar por",transformWizardSelectFields:"Selecionar campos",transformQueryLabel:"Expressão",transformPreviewLabel:"Visualizar",type:"Tipo",typeTitle:"Mudar o tipo deste campo",openUrl:"Ctrl+Click ou Ctrl+Enter para abrir link em nova janela",undo:"Desfazer último ação (Ctrl+Z)",validationCannotMove:"Não pode mover um campo como filho dele mesmo",autoType:'Campo do tipo "auto". O tipo do campo é determinao automaticamente a partir do seu valor e pode ser texto, número, verdade/falso ou nulo.',objectType:'Campo do tipo "objeto". Um objeto contém uma lista de pares com chave e valor.',arrayType:'Campo do tipo "lista". Uma lista contem uma coleção de valores ordenados.',stringType:'Campo do tipo "string". Campo do tipo nao é determinado através do seu valor, mas sempre retornara um texto.',examples:"Exemplos",default:"Revelia"},tr:{array:"Dizin",auto:"Otomatik",appendText:"Ekle",appendTitle:"Bu alanın altına 'otomatik' tipinde yeni bir alan ekle (Ctrl+Shift+Ins)",appendSubmenuTitle:"Eklenecek alanın tipini seç",appendTitleAuto:"'Otomatik' tipinde yeni bir alan ekle (Ctrl+Shift+Ins)",ascending:"Artan",ascendingTitle:"${type}'ın alt tiplerini artan düzende sırala",actionsMenu:"Aksiyon menüsünü açmak için tıklayın (Ctrl+M)",collapseAll:"Tüm alanları kapat",descending:"Azalan",descendingTitle:"${type}'ın alt tiplerini azalan düzende sırala",drag:"Bu alanı taşımak için sürükleyin (Alt+Shift+Arrows)",duplicateKey:"Var olan anahtar",duplicateText:"Aşağıya kopyala",duplicateTitle:"Seçili alanlardan bir daha oluştur (Ctrl+D)",duplicateField:"Bu alandan bir daha oluştur (Ctrl+D)",duplicateFieldError:"Duplicate field name",cannotParseFieldError:"Alan JSON'a ayrıştırılamıyor",cannotParseValueError:"JSON'a değer ayrıştırılamıyor",empty:"boş",expandAll:"Tüm alanları aç",expandTitle:"Bu alanı açmak/kapatmak için tıkla (Ctrl+E). \nAlt alanlarda dahil tüm alanları açmak için Ctrl+Click ",insert:"Ekle",insertTitle:"Bu alanın üstüne 'otomatik' tipinde yeni bir alan ekle (Ctrl+Ins)",insertSub:"Araya eklenecek alanın tipini seç",object:"Nesne",ok:"Tamam",redo:"Yeniden yap (Ctrl+Shift+Z)",removeText:"Kaldır",removeTitle:"Seçilen alanları kaldır (Ctrl+Del)",removeField:"Bu alanı kaldır (Ctrl+Del)",selectNode:"Bir nesne seç...",showAll:"tümünü göster",showMore:"daha fazla göster",showMoreStatus:"${totalChilds} alanın ${visibleChilds} alt alanları gösteriliyor",sort:"Sırala",sortTitle:"${type}'ın alt alanlarını sırala",sortTitleShort:"İçerikleri sırala",sortFieldLabel:"Alan:",sortDirectionLabel:"Yön:",sortFieldTitle:"Diziyi veya nesneyi sıralamak için iç içe geçmiş alanı seçin",sortAscending:"Artan",sortAscendingTitle:"Seçili alanı artan düzende sırala",sortDescending:"Azalan",sortDescendingTitle:"Seçili alanı azalan düzende sırala",string:"Karakter Dizisi",transform:"Dönüştür",transformTitle:"${type}'ın alt alanlarını filtrele, sırala veya dönüştür",transformTitleShort:"İçerikleri filterele, sırala veya dönüştür",transformQueryTitle:"JMESPath sorgusu gir",transformWizardLabel:"Sihirbaz",transformWizardFilter:"Filtre",transformWizardSortBy:"Sırala",transformWizardSelectFields:"Alanları seç",transformQueryLabel:"Sorgu",transformPreviewLabel:"Önizleme",type:"Tip",typeTitle:"Bu alanın tipini değiştir",openUrl:"URL'i yeni bir pencerede açmak için Ctrl+Click veya Ctrl+Enter",undo:"Son değişikliği geri al (Ctrl+Z)",validationCannotMove:"Alt alan olarak taşınamıyor",autoType:'Alan tipi "otomatik". Alan türü otomatik olarak değerden belirlenirve bir dize, sayı, boolean veya null olabilir.',objectType:'Alan tipi "nesne". Bir nesne, sıralanmamış bir anahtar / değer çifti kümesi içerir.',arrayType:'Alan tipi "dizi". Bir dizi, düzenli değerler koleksiyonu içerir.',stringType:'Alan tipi "karakter dizisi". Alan türü değerden belirlenmez,ancak her zaman karakter dizisi olarak döndürülür.',modeCodeText:"Kod",modeCodeTitle:"Kod vurgulayıcıya geç",modeFormText:"Form",modeFormTitle:"Form düzenleyiciye geç",modeTextText:"Metin",modeTextTitle:"Düz metin düzenleyiciye geç",modeTreeText:"Ağaç",modeTreeTitle:"Ağaç düzenleyiciye geç",modeViewText:"Görünüm",modeViewTitle:"Ağaç görünümüne geç",examples:"Örnekler",default:"Varsayılan"},ja:{array:"配列",auto:"オート",appendText:"追加",appendTitle:'次のフィールドに"オート"のフィールドを追加 (Ctrl+Shift+Ins)',appendSubmenuTitle:"追加するフィールドの型を選択してください",appendTitleAuto:'"オート"のフィールドを追加 (Ctrl+Shift+Ins)',ascending:"昇順",ascendingTitle:"${type}の子要素を昇順に並べ替え",actionsMenu:"クリックしてアクションメニューを開く (Ctrl+M)",collapseAll:"すべてを折りたたむ",descending:"降順",descendingTitle:"${type}の子要素を降順に並べ替え",drag:"ドラッグして選択中のフィールドを移動 (Alt+Shift+Arrows)",duplicateKey:"複製キー",duplicateText:"複製",duplicateTitle:"選択中のフィールドを複製 (Ctrl+D)",duplicateField:"選択中のフィールドを複製 (Ctrl+D)",duplicateFieldError:"フィールド名が重複しています",cannotParseFieldError:"JSONのフィールドを解析できません",cannotParseValueError:"JSONの値を解析できません",empty:"空",expandAll:"すべてを展開",expandTitle:"クリックしてフィールドを展開/折りたたむ (Ctrl+E). \nCtrl+Click ですべての子要素を展開/折りたたむ",insert:"挿入",insertTitle:"選択中のフィールドの前に新しいフィールドを挿入 (Ctrl+Ins)",insertSub:"挿入するフィールドの型を選択",object:"オブジェクト",ok:"実行",redo:"やり直す (Ctrl+Shift+Z)",removeText:"削除",removeTitle:"選択中のフィールドを削除 (Ctrl+Del)",removeField:"選択中のフィールドを削除 (Ctrl+Del)",selectNode:"ノードを選択...",showAll:"すべてを表示",showMore:"もっと見る",showMoreStatus:"${totalChilds}個のアイテムのうち ${visibleChilds}個を表示しています。",sort:"並べ替え",sortTitle:"${type}の子要素を並べ替え",sortTitleShort:"並べ替え",sortFieldLabel:"フィールド:",sortDirectionLabel:"順序:",sortFieldTitle:"配列またはオブジェクトを並び替えるためのフィールドを選択",sortAscending:"昇順",sortAscendingTitle:"選択中のフィールドを昇順に並び替え",sortDescending:"降順",sortDescendingTitle:"選択中のフィールドを降順に並び替え",string:"文字列",transform:"変換",transformTitle:"${type}の子要素をフィルター・並び替え・変換する",transformTitleShort:"内容をフィルター・並び替え・変換する",extract:"抽出",extractTitle:"${type}を抽出",transformQueryTitle:"JMESPathクエリを入力",transformWizardLabel:"ウィザード",transformWizardFilter:"フィルター",transformWizardSortBy:"並び替え",transformWizardSelectFields:"フィールドを選択",transformQueryLabel:"クエリ",transformPreviewLabel:"プレビュー",type:"型",typeTitle:"選択中のフィールドの型を変更",openUrl:"Ctrl+Click または Ctrl+Enter で 新規ウィンドウでURLを開く",undo:"元に戻す (Ctrl+Z)",validationCannotMove:"子要素に移動できません ",autoType:"オート： フィールドの型は値から自動的に決定されます。 (文字列・数値・ブール・null)",objectType:"オブジェクト： オブジェクトは順序が決まっていないキーと値のペア組み合わせです。",arrayType:"配列： 配列は順序が決まっている値の集合体です。",stringType:"文字列： フィールド型は値から決定されませんが、常に文字列として返されます。",modeCodeText:"コードモード",modeCodeTitle:"ハイライトモードに切り替え",modeFormText:"フォームモード",modeFormTitle:"フォームモードに切り替え",modeTextText:"テキストモード",modeTextTitle:"テキストモードに切り替え",modeTreeText:"ツリーモード",modeTreeTitle:"ツリーモードに切り替え",modeViewText:"ビューモード",modeViewTitle:"ビューモードに切り替え",modePreviewText:"プレビュー",modePreviewTitle:"プレビューに切り替え",examples:"例",default:"デフォルト"},"fr-FR":{array:"Liste",auto:"Auto",appendText:"Ajouter",appendTitle:"Ajouter un champ de type 'auto' après ce champ (Ctrl+Shift+Ins)",appendSubmenuTitle:"Sélectionner le type du champ à ajouter",appendTitleAuto:"Ajouter un champ de type 'auto' (Ctrl+Shift+Ins)",ascending:"Ascendant",ascendingTitle:"Trier les enfants de ce ${type} par ordre ascendant",actionsMenu:"Ouvrir le menu des actions (Ctrl+M)",collapseAll:"Regrouper",descending:"Descendant",descendingTitle:"Trier les enfants de ce ${type} par ordre descendant",drag:"Déplacer (Alt+Shift+Arrows)",duplicateKey:"Dupliquer la clé",duplicateText:"Dupliquer",duplicateTitle:"Dupliquer les champs sélectionnés (Ctrl+D)",duplicateField:"Dupliquer ce champ (Ctrl+D)",duplicateFieldError:"Dupliquer le nom de champ",cannotParseFieldError:"Champ impossible à parser en JSON",cannotParseValueError:"Valeur impossible à parser en JSON",empty:"vide",expandAll:"Étendre",expandTitle:"Étendre/regrouper ce champ (Ctrl+E). \nCtrl+Click pour étendre/regrouper avec tous les champs.",insert:"Insérer",insertTitle:"Insérer un champ de type 'auto' avant ce champ (Ctrl+Ins)",insertSub:"Sélectionner le type de champ à insérer",object:"Objet",ok:"Ok",redo:"Rejouer (Ctrl+Shift+Z)",removeText:"Supprimer",removeTitle:"Supprimer les champs sélectionnés (Ctrl+Del)",removeField:"Supprimer ce champ (Ctrl+Del)",searchTitle:"Rechercher champs et valeurs",searchNextResultTitle:"Résultat suivant (Enter)",searchPreviousResultTitle:"Résultat précédent (Shift + Enter)",selectNode:"Sélectionner un nœud...",showAll:"voir tout",showMore:"voir plus",showMoreStatus:"${visibleChilds} éléments affichés de ${totalChilds}.",sort:"Trier",sortTitle:"Trier les champs de ce ${type}",sortTitleShort:"Trier",sortFieldLabel:"Champ:",sortDirectionLabel:"Direction:",sortFieldTitle:"Sélectionner les champs permettant de trier les listes et objet",sortAscending:"Ascendant",sortAscendingTitle:"Trier les champs sélectionnés par ordre ascendant",sortDescending:"Descendant",sortDescendingTitle:"Trier les champs sélectionnés par ordre descendant",string:"Chaîne",transform:"Transformer",transformTitle:"Filtrer, trier, or transformer les enfants de ce ${type}",transformTitleShort:"Filtrer, trier ou transformer le contenu",extract:"Extraire",extractTitle:"Extraire ce ${type}",transformQueryTitle:"Saisir une requête JMESPath",transformWizardLabel:"Assistant",transformWizardFilter:"Filtrer",transformWizardSortBy:"Trier par",transformWizardSelectFields:"Sélectionner les champs",transformQueryLabel:"Requête",transformPreviewLabel:"Prévisualisation",type:"Type",typeTitle:"Changer le type de ce champ",openUrl:"Ctrl+Click ou Ctrl+Enter pour ouvrir l'url dans une autre fenêtre",undo:"Annuler la dernière action (Ctrl+Z)",validationCannotMove:"Cannot move a field into a child of itself",autoType:'Champe de type "auto". Ce type de champ est automatiquement déterminé en fonction de la valeur et peut être de type "chaîne", "nombre", "booléen" ou null.',objectType:'Champ de type "objet". Un objet contient un ensemble non ordonné de paires clé/valeur.',arrayType:'Champ de type "liste". Une liste contient une collection ordonnée de valeurs.',stringType:'Champ de type "chaîne". Ce type de champ n\'est pas déterminé en fonction de la valeur, mais retourne systématiquement une chaîne de caractères.',modeEditorTitle:"Changer mode d'édition",modeCodeText:"Code",modeCodeTitle:"Activer surlignage code",modeFormText:"Formulaire",modeFormTitle:"Activer formulaire",modeTextText:"Texte",modeTextTitle:"Activer éditeur texte",modeTreeText:"Arbre",modeTreeTitle:"Activer éditeur arbre",modeViewText:"Lecture seule",modeViewTitle:"Activer vue arbre",modePreviewText:"Prévisualisation",modePreviewTitle:"Activer mode prévisualiser",examples:"Exemples",default:"Défaut"}},o="en",s="undefined"!=typeof navigator?navigator.language||navigator.userLanguage:void 0,a=n.find(function(e){return e===s})||o;function l(t){if(t){var e=n.find(function(e){return e===t});e?a=e:console.error("Language not found")}}function c(e){if(e){var t=function(t){n.find(function(e){return e===t})||n.push(t),r[t]=Object.assign({},r[o],r[t],e[t])};for(var i in e)t(i)}}function h(e,t,i){var n=r[i=i||a][e];if(t)for(e in t)n=n.replace("${"+e+"}",t[e]);return n||e}},function(e,t,i){"use strict";i.d(t,"a",function(){return n}),i.d(t,"d",function(){return r}),i.d(t,"b",function(){return o}),i.d(t,"c",function(){return s});var n=document.body,r=10485760,o=2e4,s=2147483648},function(e,t,i){"use strict";i.d(t,"a",function(){return r});var u=i(11),g=i(0),C=i(1);function n(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var r=function(){function d(i,e){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,d),this.dom={};var f=this,t=this.dom;this.anchor=void 0,this.items=i,this.eventListeners={},this.selection=void 0,this.onClose=e?e.close:void 0;var n=document.createElement("div");n.className="jsoneditor-contextmenu-root",t.root=n;var r=document.createElement("div");r.className="jsoneditor-contextmenu",t.menu=r,n.appendChild(r);var o=document.createElement("ul");o.className="jsoneditor-menu",r.appendChild(o),t.list=o,t.items=[];var s=document.createElement("button");s.type="button",t.focusButton=s;var a=document.createElement("li");a.style.overflow="hidden",a.style.height="0",a.appendChild(s),o.appendChild(a),function g(p,m,e){e.forEach(function(t){if("separator"===t.type){var e=document.createElement("div");e.className="jsoneditor-separator";var i=document.createElement("li");i.appendChild(e),p.appendChild(i)}else{var n={},r=document.createElement("li");p.appendChild(r);var o=document.createElement("button");if(o.type="button",o.className=t.className,n.button=o,t.title&&(o.title=t.title),t.click&&(o.onclick=function(e){e.preventDefault(),f.hide(),t.click()}),r.appendChild(o),t.submenu){var s=document.createElement("div");s.className="jsoneditor-icon",o.appendChild(s);var a,l=document.createElement("div");if(l.className="jsoneditor-text"+(t.click?"":" jsoneditor-right-margin"),l.appendChild(document.createTextNode(t.text)),o.appendChild(l),t.click){o.className+=" jsoneditor-default";var c=document.createElement("button");c.type="button",(n.buttonExpand=c).className="jsoneditor-expand",c.innerHTML='<div class="jsoneditor-expand"></div>',r.appendChild(c),t.submenuTitle&&(c.title=t.submenuTitle),a=c}else{var h=document.createElement("div");h.className="jsoneditor-expand",o.appendChild(h),a=o}a.onclick=function(e){e.preventDefault(),f._onExpandItem(n),a.focus()};var d=[];n.subItems=d;var u=document.createElement("ul");(n.ul=u).className="jsoneditor-menu",u.style.height="0",r.appendChild(u),g(u,d,t.submenu)}else o.innerHTML='<div class="jsoneditor-icon"></div><div class="jsoneditor-text">'+Object(C.c)(t.text)+"</div>";m.push(n)}})}(o,this.dom.items,i),this.maxHeight=0,i.forEach(function(e){var t=24*(i.length+(e.submenu?e.submenu.length:0));f.maxHeight=Math.max(f.maxHeight,t)})}return function(e,t,i){t&&n(e.prototype,t),i&&n(e,i)}(d,[{key:"_getVisibleButtons",value:function(){var t=[],i=this;return this.dom.items.forEach(function(e){t.push(e.button),e.buttonExpand&&t.push(e.buttonExpand),e.subItems&&e===i.expandedItem&&e.subItems.forEach(function(e){t.push(e.button),e.buttonExpand&&t.push(e.buttonExpand)})}),t}},{key:"show",value:function(e,t,i){this.hide();var n=!0,r=e.parentNode,o=e.getBoundingClientRect(),s=r.getBoundingClientRect(),a=t.getBoundingClientRect(),l=this;this.dom.absoluteAnchor=Object(u.a)(e,t,function(){l.hide()}),o.bottom+this.maxHeight<a.bottom||o.top-this.maxHeight>a.top&&(n=!1);var c=i?0:o.top-s.top;if(n){var h=e.offsetHeight;this.dom.menu.style.left="0",this.dom.menu.style.top=c+h+"px",this.dom.menu.style.bottom=""}else this.dom.menu.style.left="0",this.dom.menu.style.top="",this.dom.menu.style.bottom="0px";this.dom.absoluteAnchor.appendChild(this.dom.root),this.selection=Object(g.getSelection)(),this.anchor=e,setTimeout(function(){l.dom.focusButton.focus()},0),d.visibleMenu&&d.visibleMenu.hide(),d.visibleMenu=this}},{key:"hide",value:function(){this.dom.absoluteAnchor&&(this.dom.absoluteAnchor.destroy(),delete this.dom.absoluteAnchor),this.dom.root.parentNode&&(this.dom.root.parentNode.removeChild(this.dom.root),this.onClose&&this.onClose()),d.visibleMenu===this&&(d.visibleMenu=void 0)}},{key:"_onExpandItem",value:function(i){var n=this,e=i===this.expandedItem,t=this.expandedItem;if(t&&(t.ul.style.height="0",t.ul.style.padding="",setTimeout(function(){n.expandedItem!==t&&(t.ul.style.display="",Object(g.removeClassName)(t.ul.parentNode,"jsoneditor-selected"))},300),this.expandedItem=void 0),!e){var r=i.ul;r.style.display="block",r.clientHeight,setTimeout(function(){if(n.expandedItem===i){for(var e=0,t=0;t<r.childNodes.length;t++)e+=r.childNodes[t].clientHeight;r.style.height=e+"px",r.style.padding="5px 10px"}},0),Object(g.addClassName)(r.parentNode,"jsoneditor-selected"),this.expandedItem=i}}},{key:"_onKeyDown",value:function(e){var t,i,n,r,o=e.target,s=e.which,a=!1;27===s?(this.selection&&Object(g.setSelection)(this.selection),this.anchor&&this.anchor.focus(),this.hide(),a=!0):9===s?e.shiftKey?0===(i=(t=this._getVisibleButtons()).indexOf(o))&&(t[t.length-1].focus(),a=!0):(i=(t=this._getVisibleButtons()).indexOf(o))===t.length-1&&(t[0].focus(),a=!0):37===s?("jsoneditor-expand"===o.className&&(i=(t=this._getVisibleButtons()).indexOf(o),(n=t[i-1])&&n.focus()),a=!0):38===s?(i=(t=this._getVisibleButtons()).indexOf(o),(n=t[i-1])&&"jsoneditor-expand"===n.className&&(n=t[i-2]),(n=n||t[t.length-1])&&n.focus(),a=!0):39===s?(i=(t=this._getVisibleButtons()).indexOf(o),(r=t[i+1])&&"jsoneditor-expand"===r.className&&r.focus(),a=!0):40===s&&(i=(t=this._getVisibleButtons()).indexOf(o),(r=t[i+1])&&"jsoneditor-expand"===r.className&&(r=t[i+2]),(r=r||t[0])&&(r.focus(),a=!0),a=!0),a&&(e.stopPropagation(),e.preventDefault())}}]),d}();r.visibleMenu=void 0},function(e,t,i){!function(e){"use strict";function R(e){return null!==e&&"[object Array]"===Object.prototype.toString.call(e)}function E(e){return null!==e&&"[object Object]"===Object.prototype.toString.call(e)}function B(e,t){if(e===t)return!0;if(Object.prototype.toString.call(e)!==Object.prototype.toString.call(t))return!1;if(!0===R(e)){if(e.length!==t.length)return!1;for(var i=0;i<e.length;i++)if(!1===B(e[i],t[i]))return!1;return!0}if(!0!==E(e))return!1;var n={};for(var r in e)if(hasOwnProperty.call(e,r)){if(!1===B(e[r],t[r]))return!1;n[r]=!0}for(var o in t)if(hasOwnProperty.call(t,o)&&!0!==n[o])return!1;return!0}function G(e){if(""===e||!1===e||null===e)return!0;if(R(e)&&0===e.length)return!0;if(E(e)){for(var t in e)if(e.hasOwnProperty(t))return!1;return!0}return!1}var s;s="function"==typeof String.prototype.trimLeft?function(e){return e.trimLeft()}:function(e){return e.match(/^\s*(.*)/)[1]};var c=0,o=1,h=2,a=3,t=4,i=6,l=8,d=9,u="UnquotedIdentifier",g="QuotedIdentifier",p="Rbracket",m="Rparen",f="Comma",C="Colon",I="Rbrace",A="Number",Z="Current",T="Expref",W="Pipe",_="GTE",H="LTE",L="Flatten",v="Star",b="Filter",y="Dot",w="Lbrace",S="Lbracket",x="Lparen",k="Literal",$={".":y,"*":v,",":f,":":C,"{":w,"}":I,"]":p,"(":x,")":m,"@":Z},V={"<":!0,">":!0,"=":!0,"!":!0},N={" ":!0,"\t":!0,"\n":!0};function O(e){return"0"<=e&&e<="9"||"-"===e}function n(){}n.prototype={tokenize:function(e){var t,i,n,r,o=[];for(this._current=0;this._current<e.length;)if("a"<=(r=e[this._current])&&r<="z"||"A"<=r&&r<="Z"||"_"===r)t=this._current,i=this._consumeUnquotedIdentifier(e),o.push({type:u,value:i,start:t});else if(void 0!==$[e[this._current]])o.push({type:$[e[this._current]],value:e[this._current],start:this._current}),this._current++;else if(O(e[this._current]))n=this._consumeNumber(e),o.push(n);else if("["===e[this._current])n=this._consumeLBracket(e),o.push(n);else if('"'===e[this._current])t=this._current,i=this._consumeQuotedIdentifier(e),o.push({type:g,value:i,start:t});else if("'"===e[this._current])t=this._current,i=this._consumeRawStringLiteral(e),o.push({type:k,value:i,start:t});else if("`"===e[this._current]){t=this._current;var s=this._consumeLiteral(e);o.push({type:k,value:s,start:t})}else if(void 0!==V[e[this._current]])o.push(this._consumeOperator(e));else if(void 0!==N[e[this._current]])this._current++;else if("&"===e[this._current])t=this._current,this._current++,"&"===e[this._current]?(this._current++,o.push({type:"And",value:"&&",start:t})):o.push({type:T,value:"&",start:t});else{if("|"!==e[this._current]){var a=new Error("Unknown character:"+e[this._current]);throw a.name="LexerError",a}t=this._current,this._current++,"|"===e[this._current]?(this._current++,o.push({type:"Or",value:"||",start:t})):o.push({type:W,value:"|",start:t})}return o},_consumeUnquotedIdentifier:function(e){var t,i=this._current;for(this._current++;this._current<e.length&&("a"<=(t=e[this._current])&&t<="z"||"A"<=t&&t<="Z"||"0"<=t&&t<="9"||"_"===t);)this._current++;return e.slice(i,this._current)},_consumeQuotedIdentifier:function(e){var t=this._current;this._current++;for(var i=e.length;'"'!==e[this._current]&&this._current<i;){var n=this._current;"\\"!==e[n]||"\\"!==e[n+1]&&'"'!==e[n+1]?n++:n+=2,this._current=n}return this._current++,JSON.parse(e.slice(t,this._current))},_consumeRawStringLiteral:function(e){var t=this._current;this._current++;for(var i=e.length;"'"!==e[this._current]&&this._current<i;){var n=this._current;"\\"!==e[n]||"\\"!==e[n+1]&&"'"!==e[n+1]?n++:n+=2,this._current=n}return this._current++,e.slice(t+1,this._current-1).replace("\\'","'")},_consumeNumber:function(e){var t=this._current;this._current++;for(var i=e.length;O(e[this._current])&&this._current<i;)this._current++;var n=parseInt(e.slice(t,this._current));return{type:A,value:n,start:t}},_consumeLBracket:function(e){var t=this._current;return this._current++,"?"===e[this._current]?(this._current++,{type:b,value:"[?",start:t}):"]"===e[this._current]?(this._current++,{type:L,value:"[]",start:t}):{type:S,value:"[",start:t}},_consumeOperator:function(e){var t=this._current,i=e[t];return this._current++,"!"===i?"="===e[this._current]?(this._current++,{type:"NE",value:"!=",start:t}):{type:"Not",value:"!",start:t}:"<"===i?"="===e[this._current]?(this._current++,{type:H,value:"<=",start:t}):{type:"LT",value:"<",start:t}:">"===i?"="===e[this._current]?(this._current++,{type:_,value:">=",start:t}):{type:"GT",value:">",start:t}:"="===i&&"="===e[this._current]?(this._current++,{type:"EQ",value:"==",start:t}):void 0},_consumeLiteral:function(e){this._current++;for(var t,i=this._current,n=e.length;"`"!==e[this._current]&&this._current<n;){var r=this._current;"\\"!==e[r]||"\\"!==e[r+1]&&"`"!==e[r+1]?r++:r+=2,this._current=r}var o=s(e.slice(i,this._current));return o=o.replace("\\`","`"),t=this._looksLikeJSON(o)?JSON.parse(o):JSON.parse('"'+o+'"'),this._current++,t},_looksLikeJSON:function(e){if(""===e)return!1;if(0<='[{"'.indexOf(e[0]))return!0;if(0<=["true","false","null"].indexOf(e))return!0;if(!(0<="-0123456789".indexOf(e[0])))return!1;try{return JSON.parse(e),!0}catch(e){return!1}}};var F={};function P(){}function K(e){this.runtime=e}function M(e){this._interpreter=e,this.functionTable={abs:{_func:this._functionAbs,_signature:[{types:[c]}]},avg:{_func:this._functionAvg,_signature:[{types:[l]}]},ceil:{_func:this._functionCeil,_signature:[{types:[c]}]},contains:{_func:this._functionContains,_signature:[{types:[h,a]},{types:[o]}]},ends_with:{_func:this._functionEndsWith,_signature:[{types:[h]},{types:[h]}]},floor:{_func:this._functionFloor,_signature:[{types:[c]}]},length:{_func:this._functionLength,_signature:[{types:[h,a,t]}]},map:{_func:this._functionMap,_signature:[{types:[i]},{types:[a]}]},max:{_func:this._functionMax,_signature:[{types:[l,d]}]},merge:{_func:this._functionMerge,_signature:[{types:[t],variadic:!0}]},max_by:{_func:this._functionMaxBy,_signature:[{types:[a]},{types:[i]}]},sum:{_func:this._functionSum,_signature:[{types:[l]}]},starts_with:{_func:this._functionStartsWith,_signature:[{types:[h]},{types:[h]}]},min:{_func:this._functionMin,_signature:[{types:[l,d]}]},min_by:{_func:this._functionMinBy,_signature:[{types:[a]},{types:[i]}]},type:{_func:this._functionType,_signature:[{types:[o]}]},keys:{_func:this._functionKeys,_signature:[{types:[t]}]},values:{_func:this._functionValues,_signature:[{types:[t]}]},sort:{_func:this._functionSort,_signature:[{types:[d,l]}]},sort_by:{_func:this._functionSortBy,_signature:[{types:[a]},{types:[i]}]},join:{_func:this._functionJoin,_signature:[{types:[h]},{types:[d]}]},reverse:{_func:this._functionReverse,_signature:[{types:[h,a]}]},to_array:{_func:this._functionToArray,_signature:[{types:[o]}]},to_string:{_func:this._functionToString,_signature:[{types:[o]}]},to_number:{_func:this._functionToNumber,_signature:[{types:[o]}]},not_null:{_func:this._functionNotNull,_signature:[{types:[o],variadic:!0}]}}}F.EOF=0,F[u]=0,F[g]=0,F[p]=0,F[m]=0,F[f]=0,F[I]=0,F[A]=0,F[Z]=0,F[T]=0,F[W]=1,F.Or=2,F.And=3,F.EQ=5,F.GT=5,F.LT=5,F.GTE=5,F.LTE=5,F.NE=5,F[L]=9,F[v]=20,F[b]=21,F.Dot=40,F.Not=45,F[w]=50,F[S]=55,F[x]=60,P.prototype={parse:function(e){this._loadTokens(e),this.index=0;var t=this.expression(0);if("EOF"===this._lookahead(0))return t;var i=this._lookaheadToken(0),n=new Error("Unexpected token type: "+i.type+", value: "+i.value);throw n.name="ParserError",n},_loadTokens:function(e){var t=(new n).tokenize(e);t.push({type:"EOF",value:"",start:e.length}),this.tokens=t},expression:function(e){var t=this._lookaheadToken(0);this._advance();for(var i=this.nud(t),n=this._lookahead(0);e<F[n];)this._advance(),i=this.led(n,i),n=this._lookahead(0);return i},_lookahead:function(e){return this.tokens[this.index+e].type},_lookaheadToken:function(e){return this.tokens[this.index+e]},_advance:function(){this.index++},nud:function(e){var t,i;switch(e.type){case k:return{type:"Literal",value:e.value};case u:return{type:"Field",name:e.value};case g:var n={type:"Field",name:e.value};if(this._lookahead(0)===x)throw new Error("Quoted identifier not allowed for function names.");return n;case"Not":return{type:"NotExpression",children:[t=this.expression(F.Not)]};case v:return t=null,{type:"ValueProjection",children:[{type:"Identity"},t=this._lookahead(0)===p?{type:"Identity"}:this._parseProjectionRHS(F.Star)]};case b:return this.led(e.type,{type:"Identity"});case w:return this._parseMultiselectHash();case L:return{type:"Projection",children:[{type:L,children:[{type:"Identity"}]},t=this._parseProjectionRHS(F.Flatten)]};case S:return this._lookahead(0)===A||this._lookahead(0)===C?(t=this._parseIndexExpression(),this._projectIfSlice({type:"Identity"},t)):this._lookahead(0)===v&&this._lookahead(1)===p?(this._advance(),this._advance(),{type:"Projection",children:[{type:"Identity"},t=this._parseProjectionRHS(F.Star)]}):this._parseMultiselectList();case Z:return{type:Z};case T:return{type:"ExpressionReference",children:[i=this.expression(F.Expref)]};case x:for(var r=[];this._lookahead(0)!==m;)this._lookahead(0)===Z?(i={type:Z},this._advance()):i=this.expression(0),r.push(i);return this._match(m),r[0];default:this._errorToken(e)}},led:function(e,t){var i;switch(e){case y:var n=F.Dot;return this._lookahead(0)!==v?{type:"Subexpression",children:[t,i=this._parseDotRHS(n)]}:(this._advance(),{type:"ValueProjection",children:[t,i=this._parseProjectionRHS(n)]});case W:return i=this.expression(F.Pipe),{type:W,children:[t,i]};case"Or":return{type:"OrExpression",children:[t,i=this.expression(F.Or)]};case"And":return{type:"AndExpression",children:[t,i=this.expression(F.And)]};case x:for(var r,o=t.name,s=[];this._lookahead(0)!==m;)this._lookahead(0)===Z?(r={type:Z},this._advance()):r=this.expression(0),this._lookahead(0)===f&&this._match(f),s.push(r);return this._match(m),{type:"Function",name:o,children:s};case b:var a=this.expression(0);return this._match(p),{type:"FilterProjection",children:[t,i=this._lookahead(0)===L?{type:"Identity"}:this._parseProjectionRHS(F.Filter),a]};case L:return{type:"Projection",children:[{type:L,children:[t]},this._parseProjectionRHS(F.Flatten)]};case"EQ":case"NE":case"GT":case _:case"LT":case H:return this._parseComparator(t,e);case S:var l=this._lookaheadToken(0);return l.type===A||l.type===C?(i=this._parseIndexExpression(),this._projectIfSlice(t,i)):(this._match(v),this._match(p),{type:"Projection",children:[t,i=this._parseProjectionRHS(F.Star)]});default:this._errorToken(this._lookaheadToken(0))}},_match:function(e){if(this._lookahead(0)!==e){var t=this._lookaheadToken(0),i=new Error("Expected "+e+", got: "+t.type);throw i.name="ParserError",i}this._advance()},_errorToken:function(e){var t=new Error("Invalid token ("+e.type+'): "'+e.value+'"');throw t.name="ParserError",t},_parseIndexExpression:function(){if(this._lookahead(0)===C||this._lookahead(1)===C)return this._parseSliceExpression();var e={type:"Index",value:this._lookaheadToken(0).value};return this._advance(),this._match(p),e},_projectIfSlice:function(e,t){var i={type:"IndexExpression",children:[e,t]};return"Slice"===t.type?{type:"Projection",children:[i,this._parseProjectionRHS(F.Star)]}:i},_parseSliceExpression:function(){for(var e=[null,null,null],t=0,i=this._lookahead(0);i!==p&&t<3;){if(i===C)t++,this._advance();else{if(i!==A){var n=this._lookahead(0),r=new Error("Syntax error, unexpected token: "+n.value+"("+n.type+")");throw r.name="Parsererror",r}e[t]=this._lookaheadToken(0).value,this._advance()}i=this._lookahead(0)}return this._match(p),{type:"Slice",children:e}},_parseComparator:function(e,t){return{type:"Comparator",name:t,children:[e,this.expression(F[t])]}},_parseDotRHS:function(e){var t=this._lookahead(0);return 0<=[u,g,v].indexOf(t)?this.expression(e):t===S?(this._match(S),this._parseMultiselectList()):t===w?(this._match(w),this._parseMultiselectHash()):void 0},_parseProjectionRHS:function(e){var t;if(F[this._lookahead(0)]<10)t={type:"Identity"};else if(this._lookahead(0)===S)t=this.expression(e);else if(this._lookahead(0)===b)t=this.expression(e);else{if(this._lookahead(0)!==y){var i=this._lookaheadToken(0),n=new Error("Sytanx error, unexpected token: "+i.value+"("+i.type+")");throw n.name="ParserError",n}this._match(y),t=this._parseDotRHS(e)}return t},_parseMultiselectList:function(){for(var e=[];this._lookahead(0)!==p;){var t=this.expression(0);if(e.push(t),this._lookahead(0)===f&&(this._match(f),this._lookahead(0)===p))throw new Error("Unexpected token Rbracket")}return this._match(p),{type:"MultiSelectList",children:e}},_parseMultiselectHash:function(){for(var e,t,i,n=[],r=[u,g];;){if(e=this._lookaheadToken(0),r.indexOf(e.type)<0)throw new Error("Expecting an identifier token, got: "+e.type);if(t=e.value,this._advance(),this._match(C),i={type:"KeyValuePair",name:t,value:this.expression(0)},n.push(i),this._lookahead(0)===f)this._match(f);else if(this._lookahead(0)===I){this._match(I);break}}return{type:"MultiSelectHash",children:n}}},K.prototype={search:function(e,t){return this.visit(e,t)},visit:function(e,t){var i,n,r,o,s,a,l,c,h;switch(e.type){case"Field":return null===t?null:E(t)?void 0===(a=t[e.name])?null:a:null;case"Subexpression":for(r=this.visit(e.children[0],t),h=1;h<e.children.length;h++)if(null===(r=this.visit(e.children[1],r)))return null;return r;case"IndexExpression":return l=this.visit(e.children[0],t),this.visit(e.children[1],l);case"Index":if(!R(t))return null;var d=e.value;return d<0&&(d=t.length+d),void 0===(r=t[d])&&(r=null),r;case"Slice":if(!R(t))return null;var u=e.children.slice(0),g=this.computeSliceParams(t.length,u),p=g[0],m=g[1],f=g[2];if(r=[],0<f)for(h=p;h<m;h+=f)r.push(t[h]);else for(h=p;m<h;h+=f)r.push(t[h]);return r;case"Projection":var C=this.visit(e.children[0],t);if(!R(C))return null;for(c=[],h=0;h<C.length;h++)null!==(n=this.visit(e.children[1],C[h]))&&c.push(n);return c;case"ValueProjection":if(!E(C=this.visit(e.children[0],t)))return null;c=[];var I=function(e){for(var t=Object.keys(e),i=[],n=0;n<t.length;n++)i.push(e[t[n]]);return i}(C);for(h=0;h<I.length;h++)null!==(n=this.visit(e.children[1],I[h]))&&c.push(n);return c;case"FilterProjection":if(!R(C=this.visit(e.children[0],t)))return null;var A=[],v=[];for(h=0;h<C.length;h++)G(i=this.visit(e.children[2],C[h]))||A.push(C[h]);for(var b=0;b<A.length;b++)null!==(n=this.visit(e.children[1],A[b]))&&v.push(n);return v;case"Comparator":switch(o=this.visit(e.children[0],t),s=this.visit(e.children[1],t),e.name){case"EQ":r=B(o,s);break;case"NE":r=!B(o,s);break;case"GT":r=s<o;break;case _:r=s<=o;break;case"LT":r=o<s;break;case H:r=o<=s;break;default:throw new Error("Unknown comparator: "+e.name)}return r;case L:var y=this.visit(e.children[0],t);if(!R(y))return null;var w=[];for(h=0;h<y.length;h++)R(n=y[h])?w.push.apply(w,n):w.push(n);return w;case"Identity":return t;case"MultiSelectList":if(null===t)return null;for(c=[],h=0;h<e.children.length;h++)c.push(this.visit(e.children[h],t));return c;case"MultiSelectHash":if(null===t)return null;var S;for(c={},h=0;h<e.children.length;h++)c[(S=e.children[h]).name]=this.visit(S.value,t);return c;case"OrExpression":return G(i=this.visit(e.children[0],t))&&(i=this.visit(e.children[1],t)),i;case"AndExpression":return!0===G(o=this.visit(e.children[0],t))?o:this.visit(e.children[1],t);case"NotExpression":return G(o=this.visit(e.children[0],t));case"Literal":return e.value;case W:return l=this.visit(e.children[0],t),this.visit(e.children[1],l);case Z:return t;case"Function":var x=[];for(h=0;h<e.children.length;h++)x.push(this.visit(e.children[h],t));return this.runtime.callFunction(e.name,x);case"ExpressionReference":var k=e.children[0];return k.jmespathType=T,k;default:throw new Error("Unknown node type: "+e.type)}},computeSliceParams:function(e,t){var i=t[0],n=t[1],r=t[2],o=[null,null,null];if(null===r)r=1;else if(0===r){var s=new Error("Invalid slice, step cannot be 0");throw s.name="RuntimeError",s}var a=r<0;return i=null===i?a?e-1:0:this.capSliceRange(e,i,r),n=null===n?a?-1:e:this.capSliceRange(e,n,r),o[0]=i,o[1]=n,o[2]=r,o},capSliceRange:function(e,t,i){return t<0?(t+=e)<0&&(t=i<0?-1:0):e<=t&&(t=i<0?e-1:e),t}},M.prototype={callFunction:function(e,t){var i=this.functionTable[e];if(void 0===i)throw new Error("Unknown function: "+e+"()");return this._validateArgs(e,t,i._signature),i._func.call(this,t)},_validateArgs:function(e,t,i){var n,r,o,s;if(i[i.length-1].variadic){if(t.length<i.length)throw n=1===i.length?" argument":" arguments",new Error("ArgumentError: "+e+"() takes at least"+i.length+n+" but received "+t.length)}else if(t.length!==i.length)throw n=1===i.length?" argument":" arguments",new Error("ArgumentError: "+e+"() takes "+i.length+n+" but received "+t.length);for(var a=0;a<i.length;a++){s=!1,r=i[a].types,o=this._getTypeName(t[a]);for(var l=0;l<r.length;l++)if(this._typeMatches(o,r[l],t[a])){s=!0;break}if(!s)throw new Error("TypeError: "+e+"() expected argument "+(a+1)+" to be type "+r+" but received type "+o+" instead.")}},_typeMatches:function(e,t,i){if(t===o)return!0;if(t!==d&&t!==l&&t!==a)return e===t;if(t===a)return e===a;if(e===a){var n;t===l?n=c:t===d&&(n=h);for(var r=0;r<i.length;r++)if(!this._typeMatches(this._getTypeName(i[r]),n,i[r]))return!1;return!0}},_getTypeName:function(e){switch(Object.prototype.toString.call(e)){case"[object String]":return h;case"[object Number]":return c;case"[object Array]":return a;case"[object Boolean]":return 5;case"[object Null]":return 7;case"[object Object]":return e.jmespathType===T?i:t}},_functionStartsWith:function(e){return 0===e[0].lastIndexOf(e[1])},_functionEndsWith:function(e){var t=e[0],i=e[1];return-1!==t.indexOf(i,t.length-i.length)},_functionReverse:function(e){if(this._getTypeName(e[0])===h){for(var t=e[0],i="",n=t.length-1;0<=n;n--)i+=t[n];return i}var r=e[0].slice(0);return r.reverse(),r},_functionAbs:function(e){return Math.abs(e[0])},_functionCeil:function(e){return Math.ceil(e[0])},_functionAvg:function(e){for(var t=0,i=e[0],n=0;n<i.length;n++)t+=i[n];return t/i.length},_functionContains:function(e){return 0<=e[0].indexOf(e[1])},_functionFloor:function(e){return Math.floor(e[0])},_functionLength:function(e){return E(e[0])?Object.keys(e[0]).length:e[0].length},_functionMap:function(e){for(var t=[],i=this._interpreter,n=e[0],r=e[1],o=0;o<r.length;o++)t.push(i.visit(n,r[o]));return t},_functionMerge:function(e){for(var t={},i=0;i<e.length;i++){var n=e[i];for(var r in n)t[r]=n[r]}return t},_functionMax:function(e){if(0<e[0].length){if(this._getTypeName(e[0][0])===c)return Math.max.apply(Math,e[0]);for(var t=e[0],i=t[0],n=1;n<t.length;n++)i.localeCompare(t[n])<0&&(i=t[n]);return i}return null},_functionMin:function(e){if(0<e[0].length){if(this._getTypeName(e[0][0])===c)return Math.min.apply(Math,e[0]);for(var t=e[0],i=t[0],n=1;n<t.length;n++)t[n].localeCompare(i)<0&&(i=t[n]);return i}return null},_functionSum:function(e){for(var t=0,i=e[0],n=0;n<i.length;n++)t+=i[n];return t},_functionType:function(e){switch(this._getTypeName(e[0])){case c:return"number";case h:return"string";case a:return"array";case t:return"object";case 5:return"boolean";case i:return"expref";case 7:return"null"}},_functionKeys:function(e){return Object.keys(e[0])},_functionValues:function(e){for(var t=e[0],i=Object.keys(t),n=[],r=0;r<i.length;r++)n.push(t[i[r]]);return n},_functionJoin:function(e){var t=e[0];return e[1].join(t)},_functionToArray:function(e){return this._getTypeName(e[0])===a?e[0]:[e[0]]},_functionToString:function(e){return this._getTypeName(e[0])===h?e[0]:JSON.stringify(e[0])},_functionToNumber:function(e){var t,i=this._getTypeName(e[0]);return i===c?e[0]:i!==h||(t=+e[0],isNaN(t))?null:t},_functionNotNull:function(e){for(var t=0;t<e.length;t++)if(7!==this._getTypeName(e[t]))return e[t];return null},_functionSort:function(e){var t=e[0].slice(0);return t.sort(),t},_functionSortBy:function(e){var t=e[0].slice(0);if(0===t.length)return t;var r=this._interpreter,o=e[1],s=this._getTypeName(r.visit(o,t[0]));if([c,h].indexOf(s)<0)throw new Error("TypeError");for(var a=this,i=[],n=0;n<t.length;n++)i.push([n,t[n]]);i.sort(function(e,t){var i=r.visit(o,e[1]),n=r.visit(o,t[1]);if(a._getTypeName(i)!==s)throw new Error("TypeError: expected "+s+", received "+a._getTypeName(i));if(a._getTypeName(n)!==s)throw new Error("TypeError: expected "+s+", received "+a._getTypeName(n));return n<i?1:i<n?-1:e[0]-t[0]});for(var l=0;l<i.length;l++)t[l]=i[l][1];return t},_functionMaxBy:function(e){for(var t,i,n=e[1],r=e[0],o=this.createKeyFunction(n,[c,h]),s=-1/0,a=0;a<r.length;a++)s<(i=o(r[a]))&&(s=i,t=r[a]);return t},_functionMinBy:function(e){for(var t,i,n=e[1],r=e[0],o=this.createKeyFunction(n,[c,h]),s=1/0,a=0;a<r.length;a++)(i=o(r[a]))<s&&(s=i,t=r[a]);return t},createKeyFunction:function(n,r){var o=this,s=this._interpreter;return function(e){var t=s.visit(n,e);if(r.indexOf(o._getTypeName(t))<0){var i="TypeError: expected one of "+r+", received "+o._getTypeName(t);throw new Error(i)}return t}}},e.tokenize=function(e){return(new n).tokenize(e)},e.compile=function(e){return(new P).parse(e)},e.search=function(e,t){var i=new P,n=new M,r=new K(n);n._interpreter=r;var o=i.parse(t);return r.search(o,e)},e.strictDeepEqual=B}(t)},function(e,t,i){"use strict";function o(e,t,i){var n=i?" !== ":" === ",r=i?" || ":" && ",o=i?"!":"",s=i?"":"!";switch(e){case"null":return t+n+"null";case"array":return o+"Array.isArray("+t+")";case"object":return"("+o+t+r+"typeof "+t+n+'"object"'+r+s+"Array.isArray("+t+"))";case"integer":return"(typeof "+t+n+'"number"'+r+s+"("+t+" % 1)"+r+t+n+t+")";default:return"typeof "+t+n+'"'+e+'"'}}e.exports={copy:function(e,t){for(var i in t=t||{},e)t[i]=e[i];return t},checkDataType:o,checkDataTypes:function(e,t){switch(e.length){case 1:return o(e[0],t,!0);default:var i="",n=a(e);for(var r in n.array&&n.object&&(i=n.null?"(":"(!"+t+" || ",i+="typeof "+t+' !== "object")',delete n.null,delete n.array,delete n.object),n.number&&delete n.integer,n)i+=(i?" && ":"")+o(r,t,!0);return i}},coerceToTypes:function(e,t){if(Array.isArray(t)){for(var i=[],n=0;n<t.length;n++){var r=t[n];s[r]?i[i.length]=r:"array"===e&&"array"===r&&(i[i.length]=r)}if(i.length)return i}else{if(s[t])return[t];if("array"===e&&"array"===t)return["array"]}},toHash:a,getProperty:d,escapeQuotes:l,equal:i(17),ucs2length:i(45),varOccurences:function(e,t){t+="[^0-9]";var i=e.match(new RegExp(t,"g"));return i?i.length:0},varReplace:function(e,t,i){return t+="([^0-9])",i=i.replace(/\$/g,"$$$$"),e.replace(new RegExp(t,"g"),i+"$1")},cleanUpCode:function(e){return e.replace(c,"").replace(h,"").replace(u,"if (!($1))")},finalCleanUpCode:function(e,t){var i=e.match(g);i&&2==i.length&&(e=t?e.replace(m,"").replace(I,A):e.replace(p,"").replace(f,C));return(i=e.match(v))&&3===i.length?e.replace(b,""):e},schemaHasRules:function(e,t){if("boolean"==typeof e)return!e;for(var i in e)if(t[i])return!0},schemaHasRulesExcept:function(e,t,i){if("boolean"==typeof e)return!e&&"not"!=i;for(var n in e)if(n!=i&&t[n])return!0},schemaUnknownRules:function(e,t){if("boolean"==typeof e)return;for(var i in e)if(!t[i])return i},toQuotedString:y,getPathExpr:function(e,t,i,n){return x(e,i?"'/' + "+t+(n?"":".replace(/~/g, '~0').replace(/\\//g, '~1')"):n?"'[' + "+t+" + ']'":"'[\\'' + "+t+" + '\\']'")},getPath:function(e,t,i){var n=y(i?"/"+k(t):d(t));return x(e,n)},getData:function(e,t,i){var n,r,o,s;if(""===e)return"rootData";if("/"==e[0]){if(!w.test(e))throw new Error("Invalid JSON-pointer: "+e);r=e,o="rootData"}else{if(!(s=e.match(S)))throw new Error("Invalid JSON-pointer: "+e);if(n=+s[1],"#"==(r=s[2])){if(t<=n)throw new Error("Cannot access property/index "+n+" levels up, current level is "+t);return i[t-n]}if(t<n)throw new Error("Cannot access data "+n+" levels up, current level is "+t);if(o="data"+(t-n||""),!r)return o}for(var a=o,l=r.split("/"),c=0;c<l.length;c++){var h=l[c];h&&(o+=d(R(h)),a+=" && "+o)}return a},unescapeFragment:function(e){return R(decodeURIComponent(e))},unescapeJsonPointer:R,escapeFragment:function(e){return encodeURIComponent(k(e))},escapeJsonPointer:k};var s=a(["string","number","integer","boolean","null"]);function a(e){for(var t={},i=0;i<e.length;i++)t[e[i]]=!0;return t}var n=/^[a-z$_][a-z$_0-9]*$/i,r=/'|\\/g;function d(e){return"number"==typeof e?"["+e+"]":n.test(e)?"."+e:"['"+l(e)+"']"}function l(e){return e.replace(r,"\\$&").replace(/\n/g,"\\n").replace(/\r/g,"\\r").replace(/\f/g,"\\f").replace(/\t/g,"\\t")}var c=/else\s*{\s*}/g,h=/if\s*\([^)]+\)\s*\{\s*\}(?!\s*else)/g,u=/if\s*\(([^)]+)\)\s*\{\s*\}\s*else(?!\s*if)/g;var g=/[^v.]errors/g,p=/var errors = 0;|var vErrors = null;|validate.errors = vErrors;/g,m=/var errors = 0;|var vErrors = null;/g,f="return errors === 0;",C="validate.errors = null; return true;",I=/if \(errors === 0\) return data;\s*else throw new ValidationError\(vErrors\);/,A="return data;",v=/[^A-Za-z_$]rootData[^A-Za-z0-9_$]/g,b=/if \(rootData === undefined\) rootData = data;/;function y(e){return"'"+l(e)+"'"}var w=/^\/(?:[^~]|~0|~1)*$/,S=/^([0-9]+)(#|\/(?:[^~]|~0|~1)*)?$/;function x(e,t){return'""'==e?t:(e+" + "+t).replace(/' \+ '/g,"")}function k(e){return e.replace(/~/g,"~0").replace(/\//g,"~1")}function R(e){return e.replace(/~1/g,"/").replace(/~0/g,"~")}},function(e,t,i){"use strict";i.d(t,"a",function(){return s});var n=i(13),r=i.n(n),o=i(1),h=i(0);function s(e,t,s,i){
var a=Array.isArray(t)?Object(h.getChildPaths)(t):[""],l=i&&i.path&&Object(h.contains)(a,i.path)?i.path:a[0],c=i&&i.direction||"asc",n='<div class="pico-modal-contents"><div class="pico-modal-header">'+Object(o.c)("sort")+"</div><form><table><tbody><tr>  <td>"+Object(o.c)("sortFieldLabel")+' </td>  <td class="jsoneditor-modal-input">  <div class="jsoneditor-select-wrapper">    <select id="field" title="'+Object(o.c)("sortFieldTitle")+'">    </select>  </div>  </td></tr><tr>  <td>'+Object(o.c)("sortDirectionLabel")+' </td>  <td class="jsoneditor-modal-input">  <div id="direction" class="jsoneditor-button-group"><input type="button" value="'+Object(o.c)("sortAscending")+'" title="'+Object(o.c)("sortAscendingTitle")+'" data-value="asc" class="jsoneditor-button-first jsoneditor-button-asc"/><input type="button" value="'+Object(o.c)("sortDescending")+'" title="'+Object(o.c)("sortDescendingTitle")+'" data-value="desc" class="jsoneditor-button-last jsoneditor-button-desc"/>  </div>  </td></tr><tr><td colspan="2" class="jsoneditor-modal-input jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+Object(o.c)("ok")+'" /></td></tr></tbody></table></form></div>';r()({parent:e,content:n,overlayClass:"jsoneditor-modal-overlay",overlayStyles:{backgroundColor:"rgb(1,1,1)",opacity:.3},modalClass:"jsoneditor-modal jsoneditor-modal-sort"}).afterCreate(function(t){var e=t.modalElem().querySelector("form"),i=t.modalElem().querySelector("#ok"),n=t.modalElem().querySelector("#field"),r=t.modalElem().querySelector("#direction");function o(e){r.value=e,r.className="jsoneditor-button-group jsoneditor-button-group-value-"+r.value}a.forEach(function(e){var t=document.createElement("option");t.text=function(e){return""===e?"@":"."===e[0]?e.slice(1):e}(e),t.value=e,n.appendChild(t)}),n.value=l||a[0],o(c||"asc"),r.onclick=function(e){o(e.target.getAttribute("data-value"))},i.onclick=function(e){e.preventDefault(),e.stopPropagation(),t.close(),s({path:n.value,direction:r.value})},e&&(e.onsubmit=i.onclick)}).afterClose(function(e){e.destroy()}).show()}},function(e,t,i){"use strict";i.d(t,"a",function(){return r});var p=i(3),m=i(1);function n(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var r=function(){function g(e,t,i,n){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,g);for(var r={code:{text:Object(m.c)("modeCodeText"),title:Object(m.c)("modeCodeTitle"),click:function(){n("code")}},form:{text:Object(m.c)("modeFormText"),title:Object(m.c)("modeFormTitle"),click:function(){n("form")}},text:{text:Object(m.c)("modeTextText"),title:Object(m.c)("modeTextTitle"),click:function(){n("text")}},tree:{text:Object(m.c)("modeTreeText"),title:Object(m.c)("modeTreeTitle"),click:function(){n("tree")}},view:{text:Object(m.c)("modeViewText"),title:Object(m.c)("modeViewTitle"),click:function(){n("view")}},preview:{text:Object(m.c)("modePreviewText"),title:Object(m.c)("modePreviewTitle"),click:function(){n("preview")}}},o=[],s=0;s<t.length;s++){var a=t[s],l=r[a];if(!l)throw new Error('Unknown mode "'+a+'"');l.className="jsoneditor-type-modes"+(i===a?" jsoneditor-selected":""),o.push(l)}var c=r[i];if(!c)throw new Error('Unknown mode "'+i+'"');var h=c.text,d=document.createElement("button");d.type="button",d.className="jsoneditor-modes jsoneditor-separator",d.innerHTML=h+" &#x25BE;",d.title=Object(m.c)("modeEditorTitle"),d.onclick=function(){new p.a(o).show(d,e)};var u=document.createElement("div");u.className="jsoneditor-modes",u.style.position="relative",u.appendChild(d),e.appendChild(u),this.dom={container:e,box:d,frame:u}}return function(e,t,i){t&&n(e.prototype,t),i&&n(e,i)}(g,[{key:"focus",value:function(){this.dom.box.focus()}},{key:"destroy",value:function(){this.dom&&this.dom.frame&&this.dom.frame.parentNode&&this.dom.frame.parentNode.removeChild(this.dom.frame),this.dom=null}}]),g}()},function(e,t,i){"use strict";var n=i(4),x=i.n(n),r=i(13),o=i.n(r),s=i(9),k=i.n(s),a=i(1);function l(e){return(l="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function R(e,t,i){var n;"number"==typeof t?10<t?n=c(" ",10):1<=t&&(n=c(" ",t)):"string"==typeof t&&""!==t&&(n=t);var r=d(e,n,"",i);return r.length>i?function(e,t){return"number"==typeof t?e.slice(0,t):e}(r,i)+"...":r}function d(e,t,i,n){return"boolean"==typeof e||e instanceof Boolean||null===e||"number"==typeof e||e instanceof Number||"string"==typeof e||e instanceof String||e instanceof Date?JSON.stringify(e):Array.isArray(e)?function(e,t,i,n){for(var r=t?i+t:void 0,o=t?"[\n":"[",s=0;s<e.length;s++){var a=e[s];if(t&&(o+=r),o+=void 0!==a&&"function"!=typeof a?d(a,t,r,n):"null",s<e.length-1&&(o+=t?",\n":","),o.length>n)return o+"..."}return o+=t?"\n"+i+"]":"]"}(e,t,i,n):e&&"object"===l(e)?function(e,t,i,n){var r=t?i+t:void 0,o=!0,s=t?"{\n":"{";if("function"==typeof e.toJSON)return d(e.toJSON(),t,i,n);for(var a in e)if(c=e,h=a,Object.prototype.hasOwnProperty.call(c,h)){var l=e[a];if(o?o=!1:s+=t?",\n":",",s+=t?r+'"'+a+'": ':'"'+a+'":',(s+=d(l,t,r,n)).length>n)return s+"..."}var c,h;return s+=t?"\n"+i+"}":"}"}(e,t,i,n):void 0}function c(e,t){for(var i="";0<t--;)i+=e;return i}var E=i(0),B=i(2);function h(e,y,w){var S=y,t='<label class="pico-modal-contents"><div class="pico-modal-header">'+Object(a.c)("transform")+'</div><p>Enter a <a href="http://jmespath.org" target="_blank">JMESPath</a> query to filter, sort, or transform the JSON data.<br/>To learn JMESPath, go to <a href="http://jmespath.org/tutorial.html" target="_blank">the interactive tutorial</a>.</p><div class="jsoneditor-jmespath-label">'+Object(a.c)("transformWizardLabel")+' </div><div id="wizard" class="jsoneditor-jmespath-block jsoneditor-jmespath-wizard">  <table class="jsoneditor-jmespath-wizard-table">    <tbody>      <tr>        <th>'+Object(a.c)("transformWizardFilter")+'</th>        <td class="jsoneditor-jmespath-filter">          <div class="jsoneditor-inline jsoneditor-jmespath-filter-field" >            <select id="filterField">            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-filter-relation" >            <select id="filterRelation">              <option value="==">==</option>              <option value="!=">!=</option>              <option value="<">&lt;</option>              <option value="<=">&lt;=</option>              <option value=">">&gt;</option>              <option value=">=">&gt;=</option>            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-filter-value" >            <input placeholder="value..." id="filterValue" />          </div>        </td>      </tr>      <tr>        <th>'+Object(a.c)("transformWizardSortBy")+'</th>        <td class="jsoneditor-jmespath-filter">          <div class="jsoneditor-inline jsoneditor-jmespath-sort-field">            <select id="sortField">            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-sort-order" >            <select id="sortOrder">              <option value="asc">Ascending</option>              <option value="desc">Descending</option>            </select>          </div>        </td>      </tr>      <tr id="selectFieldsPart">        <th>'+Object(a.c)("transformWizardSelectFields")+'</th>        <td class="jsoneditor-jmespath-filter">          <select class="jsoneditor-jmespath-select-fields" id="selectFields" multiple></select>        </td>      </tr>    </tbody>  </table></div><div class="jsoneditor-jmespath-label">'+Object(a.c)("transformQueryLabel")+' </div><div class="jsoneditor-jmespath-block">  <textarea id="query"             rows="4"             autocomplete="off"             autocorrect="off"             autocapitalize="off"             spellcheck="false"            title="'+Object(a.c)("transformQueryTitle")+'">[*]</textarea></div><div class="jsoneditor-jmespath-label">'+Object(a.c)("transformPreviewLabel")+' </div><div class="jsoneditor-jmespath-block">  <textarea id="preview"       class="jsoneditor-transform-preview"      readonly> </textarea></div><div class="jsoneditor-jmespath-block jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+Object(a.c)("ok")+'" autofocus /></div></div>';o()({parent:e,content:t,overlayClass:"jsoneditor-modal-overlay",overlayStyles:{backgroundColor:"rgb(1,1,1)",opacity:.3},modalClass:"jsoneditor-modal jsoneditor-modal-transform",focus:!1}).afterCreate(function(t){var e=t.modalElem(),i=e.querySelector("#wizard"),n=e.querySelector("#ok"),a=e.querySelector("#filterField"),l=e.querySelector("#filterRelation"),c=e.querySelector("#filterValue"),h=e.querySelector("#sortField"),d=e.querySelector("#sortOrder"),u=e.querySelector("#selectFields"),g=e.querySelector("#query"),r=e.querySelector("#preview");Array.isArray(S)||(i.style.fontStyle="italic",i.innerHTML="(wizard not available for objects, only for arrays)"),Object(E.getChildPaths)(y).forEach(function(e){var t=A(e),i=document.createElement("option");i.text=t,i.value=t,a.appendChild(i);var n=document.createElement("option");n.text=t,n.value=t,h.appendChild(n)});var o=Object(E.getChildPaths)(y,!0).filter(function(e){return""!==e});if(0<o.length)o.forEach(function(e){var t=A(e),i=document.createElement("option");i.text=t,i.value=t,u.appendChild(i)});else{var s=e.querySelector("#selectFieldsPart");s&&(s.style.display="none")}var p=new k.a(a,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"field..."}),m=new k.a(l,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"compare..."}),f=new k.a(h,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"field..."}),C=new k.a(d,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"order..."}),I=new k.a(u,{multiple:!0,clearable:!0,defaultSelected:!1,placeholder:"select fields..."});function A(e){return""===e?"@":"."===e[0]?e.slice(1):e}function v(){if(a.value&&l.value&&c.value){var e=a.value,t="@"!==e?["0"].concat(Object(E.parsePath)("."+e)):["0"],i="string"==typeof Object(E.get)(S,t)?c.value:Object(E.parseString)(c.value);g.value="[? "+e+" "+l.value+" `"+JSON.stringify(i)+"`]"}else g.value="[*]";if(h.value&&d.value){var n=h.value;"desc"===d.value?g.value+=" | reverse(sort_by(@, &"+n+"))":g.value+=" | sort_by(@, &"+n+")"}if(u.value){for(var r=[],o=0;o<u.options.length;o++)if(u.options[o].selected){var s=u.options[o].value;r.push(s)}"]"!==g.value[g.value.length-1]&&(g.value+=" | [*]"),1===r.length?g.value+="."+r[0]:1<r.length&&(g.value+=".{"+r.map(function(e){var t=e.split(".");return t[t.length-1]+": "+e}).join(", ")+"}")}b()}p.on("selectr.change",v),m.on("selectr.change",v),c.oninput=v,f.on("selectr.change",v),C.on("selectr.change",v),I.on("selectr.change",v),e.querySelector(".pico-modal-contents").onclick=function(e){"A"!==e.target.nodeName&&e.preventDefault()},g.value=Array.isArray(S)?"[*]":"@";var b=Object(E.debounce)(function(){try{var e=x.a.search(S,g.value);r.className="jsoneditor-transform-preview",r.value=R(e,2,B.b),n.disabled=!1}catch(e){r.className="jsoneditor-transform-preview jsoneditor-error",r.value=e.toString(),n.disabled=!0}},300);(g.oninput=b)(),n.onclick=function(e){e.preventDefault(),e.stopPropagation(),t.close(),w(g.value)},setTimeout(function(){g.select(),g.focus(),g.selectionStart=3,g.selectionEnd=3})}).afterClose(function(e){e.destroy()}).show()}i.d(t,"a",function(){return h})},function(e,t,i){"use strict";function n(){}var r={defaultSelected:!0,width:"auto",disabled:!1,searchable:!0,clearable:!1,sortSelected:!1,allowDeselect:!1,closeOnScroll:!1,nativeDropdown:!1,placeholder:"Select an option...",taggable:!1,tagPlaceholder:"Enter a tag..."};n.prototype={on:function(e,t){this._events=this._events||{},this._events[e]=this._events[e]||[],this._events[e].push(t)},off:function(e,t){this._events=this._events||{},e in this._events!=!1&&this._events[e].splice(this._events[e].indexOf(t),1)},emit:function(e){if(this._events=this._events||{},e in this._events!=!1)for(var t=0;t<this._events[e].length;t++)this._events[e][t].apply(this,Array.prototype.slice.call(arguments,1))}},n.mixin=function(e){for(var t=["on","off","emit"],i=0;i<t.length;i++)"function"==typeof e?e.prototype[t[i]]=n.prototype[t[i]]:e[t[i]]=n.prototype[t[i]];return e};var l={extend:function(e,t){var i;for(i in t=t||{},e)e.hasOwnProperty(i)&&(t.hasOwnProperty(i)||(t[i]=e[i]));return t},each:function(e,t,i){if("[object Object]"===Object.prototype.toString.call(e))for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&t.call(i,n,e[n],e);else for(var r=0,o=e.length;r<o;r++)t.call(i,r,e[r],e)},createElement:function(e,t){var i,n=document,r=n.createElement(e);if(t&&"[object Object]"===Object.prototype.toString.call(t))for(i in t)if(i in r)r[i]=t[i];else if("html"===i)r.innerHTML=t[i];else if("text"===i){var o=n.createTextNode(t[i]);r.appendChild(o)}else r.setAttribute(i,t[i]);return r},hasClass:function(e,t){if(e)return e.classList?e.classList.contains(t):!!e.className&&!!e.className.match(new RegExp("(\\s|^)"+t+"(\\s|$)"))},addClass:function(e,t){l.hasClass(e,t)||(e.classList?e.classList.add(t):e.className=e.className.trim()+" "+t)},removeClass:function(e,t){l.hasClass(e,t)&&(e.classList?e.classList.remove(t):e.className=e.className.replace(new RegExp("(^|\\s)"+t.split(" ").join("|")+"(\\s|$)","gi")," "))},closest:function(e,t){return e&&e!==document.body&&(t(e)?e:l.closest(e.parentNode,t))},isInt:function(e){return"number"==typeof e&&isFinite(e)&&Math.floor(e)===e},debounce:function(n,r,o){var s;return function(){var e=this,t=arguments,i=o&&!s;clearTimeout(s),s=setTimeout(function(){s=null,o||n.apply(e,t)},r),i&&n.apply(e,t)}},rect:function(e,t){var i=window,n=e.getBoundingClientRect(),r=t?i.pageXOffset:0,o=t?i.pageYOffset:0;return{bottom:n.bottom+o,height:n.height,left:n.left+r,right:n.right+r,top:n.top+o,width:n.width}},includes:function(e,t){return-1<e.indexOf(t)},truncate:function(e){for(;e.firstChild;)e.removeChild(e.firstChild)}};function c(e,t){return e.hasOwnProperty(t)&&(!0===e[t]||e[t].length)}function o(e,t,i){e.parentNode?e.parentNode.parentNode||t.appendChild(e.parentNode):t.appendChild(e),l.removeClass(e,"excluded"),i||(e.innerHTML=e.textContent)}function s(){if(this.items.length){var i=document.createDocumentFragment();if(this.config.pagination){var e=this.pages.slice(0,this.pageIndex);l.each(e,function(e,t){l.each(t,function(e,t){o(t,i,this.customOption)},this)},this)}else l.each(this.items,function(e,t){o(t,i,this.customOption)},this);i.childElementCount&&(l.removeClass(this.items[this.navIndex],"active"),this.navIndex=i.querySelector(".selectr-option").idx,l.addClass(this.items[this.navIndex],"active")),this.tree.appendChild(i)}}function h(e,t){t=t||e;var i=this.customOption?this.config.renderOption(t):e.textContent,n=l.createElement("li",{class:"selectr-option",html:i,role:"treeitem","aria-selected":!1});return n.idx=e.idx,this.items.push(n),e.defaultSelected&&this.defaultSelected.push(e.idx),e.disabled&&(n.disabled=!0,l.addClass(n,"disabled")),n}function a(){(this.config.searchable||this.config.taggable)&&(this.input.value=null,this.searching=!1,this.config.searchable&&l.removeClass(this.inputContainer,"active"),l.hasClass(this.container,"notice")&&(l.removeClass(this.container,"notice"),l.addClass(this.container,"open"),this.input.focus()),l.each(this.items,function(e,t){l.removeClass(t,"excluded"),this.customOption||(t.innerHTML=t.textContent)},this))}function d(e,t){if(t=t||{},!e)throw new Error("You must supply either a HTMLSelectElement or a CSS3 selector string.");if("string"==typeof(this.el=e)&&(this.el=document.querySelector(e)),null===this.el)throw new Error("The element you passed to Selectr can not be found.");if("select"!==this.el.nodeName.toLowerCase())throw new Error("The element you passed to Selectr is not a HTMLSelectElement.");this.render(t)}var u=function(){var e=this.tree,t=e.scrollTop;if(e.scrollHeight-e.offsetHeight<=t&&this.pageIndex<this.pages.length){var i=document.createDocumentFragment();l.each(this.pages[this.pageIndex],function(e,t){o(t,i,this.customOption)},this),e.appendChild(i),this.pageIndex++,this.emit("selectr.paginate",{items:this.items.length,total:this.data.length,page:this.pageIndex,pages:this.pages.length})}};d.prototype.render=function(e){if(!this.rendered){this.config=l.extend(r,e),this.originalType=this.el.type,this.originalIndex=this.el.tabIndex,this.defaultSelected=[],this.originalOptionCount=this.el.options.length,(this.config.multiple||this.config.taggable)&&(this.el.multiple=!0),this.disabled=c(this.config,"disabled"),this.opened=!1,this.config.taggable&&(this.config.searchable=!1),this.navigating=!1,this.mobileDevice=!1,/Android|webOS|iPhone|iPad|BlackBerry|Windows Phone|Opera Mini|IEMobile|Mobile/i.test(navigator.userAgent)&&(this.mobileDevice=!0),this.customOption=this.config.hasOwnProperty("renderOption")&&"function"==typeof this.config.renderOption,this.customSelected=this.config.hasOwnProperty("renderSelection")&&"function"==typeof this.config.renderSelection,n.mixin(this),function(){this.requiresPagination=this.config.pagination&&0<this.config.pagination,c(this.config,"width")&&(l.isInt(this.config.width)?this.width=this.config.width+"px":"auto"===this.config.width?this.width="100%":l.includes(this.config.width,"%")&&(this.width=this.config.width)),this.container=l.createElement("div",{class:"selectr-container"}),this.config.customClass&&l.addClass(this.container,this.config.customClass),this.mobileDevice?l.addClass(this.container,"selectr-mobile"):l.addClass(this.container,"selectr-desktop"),this.el.tabIndex=-1,this.config.nativeDropdown||this.mobileDevice?l.addClass(this.el,"selectr-visible"):l.addClass(this.el,"selectr-hidden"),this.selected=l.createElement("div",{class:"selectr-selected",disabled:this.disabled,tabIndex:1,"aria-expanded":!1}),this.label=l.createElement(this.el.multiple?"ul":"span",{class:"selectr-label"});var e=l.createElement("div",{class:"selectr-options-container"});if(this.tree=l.createElement("ul",{class:"selectr-options",role:"tree","aria-hidden":!0,"aria-expanded":!1}),this.notice=l.createElement("div",{class:"selectr-notice"}),this.el.setAttribute("aria-hidden",!0),this.disabled&&(this.el.disabled=!0),this.el.multiple&&(l.addClass(this.label,"selectr-tags"),l.addClass(this.container,"multiple"),this.tags=[],this.selectedValues=this.getSelectedProperties("value"),this.selectedIndexes=this.getSelectedProperties("idx")),this.selected.appendChild(this.label),this.config.clearable&&(this.selectClear=l.createElement("button",{class:"selectr-clear",type:"button"}),this.container.appendChild(this.selectClear),l.addClass(this.container,"clearable")),this.config.taggable){var t=l.createElement("li",{class:"input-tag"});this.input=l.createElement("input",{class:"selectr-tag-input",placeholder:this.config.tagPlaceholder,tagIndex:0,autocomplete:"off",autocorrect:"off",autocapitalize:"off",spellcheck:"false",role:"textbox",type:"search"}),t.appendChild(this.input),this.label.appendChild(t),l.addClass(this.container,"taggable"),this.tagSeperators=[","],this.config.tagSeperators&&(this.tagSeperators=this.tagSeperators.concat(this.config.tagSeperators))}this.config.searchable&&(this.input=l.createElement("input",{class:"selectr-input",tagIndex:-1,autocomplete:"off",autocorrect:"off",autocapitalize:"off",spellcheck:"false",role:"textbox",type:"search"}),this.inputClear=l.createElement("button",{class:"selectr-input-clear",type:"button"}),this.inputContainer=l.createElement("div",{class:"selectr-input-container"}),this.inputContainer.appendChild(this.input),this.inputContainer.appendChild(this.inputClear),e.appendChild(this.inputContainer)),e.appendChild(this.notice),e.appendChild(this.tree),this.items=[],this.options=[],this.el.options.length&&(this.options=[].slice.call(this.el.options));var i,n=!1,r=0;if(this.el.children.length&&l.each(this.el.children,function(e,t){"OPTGROUP"===t.nodeName?(n=l.createElement("ul",{class:"selectr-optgroup",role:"group",html:"<li class='selectr-optgroup--label'>"+t.label+"</li>"}),l.each(t.children,function(e,t){t.idx=r,n.appendChild(h.call(this,t,n)),r++},this)):(t.idx=r,h.call(this,t),r++)},this),this.config.data&&Array.isArray(this.config.data)){var o,s=!(this.data=[]);n=!1,r=0,l.each(this.config.data,function(e,t){c(t,"children")?(s=l.createElement("optgroup",{label:t.text}),n=l.createElement("ul",{class:"selectr-optgroup",role:"group",html:"<li class='selectr-optgroup--label'>"+t.text+"</li>"}),l.each(t.children,function(e,t){(o=new Option(t.text,t.value,!1,t.hasOwnProperty("selected")&&!0===t.selected)).disabled=c(t,"disabled"),this.options.push(o),s.appendChild(o),o.idx=r,n.appendChild(h.call(this,o,t)),this.data[r]=t,r++},this)):((o=new Option(t.text,t.value,!1,t.hasOwnProperty("selected")&&!0===t.selected)).disabled=c(t,"disabled"),this.options.push(o),o.idx=r,h.call(this,o,t),this.data[r]=t,r++)},this)}this.setSelected(!0);for(var a=this.navIndex=0;a<this.items.length;a++)if(i=this.items[a],!l.hasClass(i,"disabled")){l.addClass(i,"active"),this.navIndex=a;break}this.requiresPagination&&(this.pageIndex=1,this.paginate()),this.container.appendChild(this.selected),this.container.appendChild(e),this.placeEl=l.createElement("div",{class:"selectr-placeholder"}),this.setPlaceholder(),this.selected.appendChild(this.placeEl),this.disabled&&this.disable(),this.el.parentNode.insertBefore(this.container,this.el),this.container.appendChild(this.el)}.call(this),this.bindEvents(),this.update(),this.optsRect=l.rect(this.tree),this.rendered=!0,this.el.multiple||(this.el.selectedIndex=this.selectedIndex);var t=this;setTimeout(function(){t.emit("selectr.init")},20)}},d.prototype.getSelected=function(){return this.el.querySelectorAll("option:checked")},d.prototype.getSelectedProperties=function(t){var e=this.getSelected();return[].slice.call(e).map(function(e){return e[t]}).filter(function(e){return null!=e})},d.prototype.bindEvents=function(){var n=this;if(this.events={},this.events.dismiss=function(e){var t=e.target;this.container.contains(t)||!this.opened&&!l.hasClass(this.container,"notice")||this.close()}.bind(this),this.events.navigate=function(e){if(e=e||window.event,this.items.length&&this.opened&&l.includes([13,38,40],e.which)){if(e.preventDefault(),13===e.which)return!(this.config.taggable&&0<this.input.value.length)&&this.change(this.navIndex);var t,i=this.items[this.navIndex];switch(e.which){case 38:(t=0)<this.navIndex&&this.navIndex--;break;case 40:t=1,this.navIndex<this.items.length-1&&this.navIndex++}for(this.navigating=!0;l.hasClass(this.items[this.navIndex],"disabled")||l.hasClass(this.items[this.navIndex],"excluded");)if(t?this.navIndex++:this.navIndex--,this.searching){if(this.navIndex>this.tree.lastElementChild.idx){this.navIndex=this.tree.lastElementChild.idx;break}if(this.navIndex<this.tree.firstElementChild.idx){this.navIndex=this.tree.firstElementChild.idx;break}}var n=l.rect(this.items[this.navIndex]);t?(0===this.navIndex?this.tree.scrollTop=0:n.top+n.height>this.optsRect.top+this.optsRect.height&&(this.tree.scrollTop=this.tree.scrollTop+(n.top+n.height-(this.optsRect.top+this.optsRect.height))),this.navIndex===this.tree.childElementCount-1&&this.requiresPagination&&u.call(this)):0===this.navIndex?this.tree.scrollTop=0:n.top-this.optsRect.top<0&&(this.tree.scrollTop=this.tree.scrollTop+(n.top-this.optsRect.top)),i&&l.removeClass(i,"active"),l.addClass(this.items[this.navIndex],"active")}else this.navigating=!1}.bind(this),this.events.reset=this.reset.bind(this),this.config.nativeDropdown||this.mobileDevice){this.container.addEventListener("touchstart",function(e){e.changedTouches[0].target===n.el&&n.toggle()}),(this.config.nativeDropdown||this.mobileDevice)&&this.container.addEventListener("click",function(e){e.preventDefault(),e.stopPropagation(),e.target===n.el&&n.toggle()});this.el.addEventListener("change",function(e){if(n.el.multiple){var t=n.getSelectedProperties("idx"),i=function(e,t){for(var i,n=[],r=e.slice(0),o=0;o<t.length;o++)-1<(i=r.indexOf(t[o]))?r.splice(i,1):n.push(t[o]);return[n,r]}(n.selectedIndexes,t);l.each(i[0],function(e,t){n.select(t)},n),l.each(i[1],function(e,t){n.deselect(t)},n)}else-1<n.el.selectedIndex&&n.select(n.el.selectedIndex)})}this.config.nativeDropdown&&this.container.addEventListener("keydown",function(e){"Enter"===e.key&&n.selected===document.activeElement&&(n.toggle(),setTimeout(function(){n.el.focus()},200))}),this.selected.addEventListener("click",function(e){n.disabled||n.toggle(),e.preventDefault(),e.stopPropagation()}),this.label.addEventListener("click",function(e){l.hasClass(e.target,"selectr-tag-remove")&&n.deselect(e.target.parentNode.idx)}),this.selectClear&&this.selectClear.addEventListener("click",this.clear.bind(this)),this.tree.addEventListener("mousedown",function(e){e.preventDefault()}),this.tree.addEventListener("click",function(e){e.preventDefault(),e.stopPropagation();var t=l.closest(e.target,function(e){return e&&l.hasClass(e,"selectr-option")});t&&(l.hasClass(t,"disabled")||(l.hasClass(t,"selected")?(n.el.multiple||!n.el.multiple&&n.config.allowDeselect)&&n.deselect(t.idx):n.select(t.idx),n.opened&&!n.el.multiple&&n.close()))}),this.tree.addEventListener("mouseover",function(e){l.hasClass(e.target,"selectr-option")&&(l.hasClass(e.target,"disabled")||(l.removeClass(n.items[n.navIndex],"active"),l.addClass(e.target,"active"),n.navIndex=[].slice.call(n.items).indexOf(e.target)))}),this.config.searchable&&(this.input.addEventListener("focus",function(e){n.searching=!0}),this.input.addEventListener("blur",function(e){n.searching=!1}),this.input.addEventListener("keyup",function(e){n.search(),n.config.taggable||(this.value.length?l.addClass(this.parentNode,"active"):l.removeClass(this.parentNode,"active"))}),this.inputClear.addEventListener("click",function(e){n.input.value=null,a.call(n),n.tree.childElementCount||s.call(n)})),this.config.taggable&&this.input.addEventListener("keyup",function(e){if(n.search(),n.config.taggable&&this.value.length){var i=this.value.trim();if(13===e.which||l.includes(n.tagSeperators,e.key))l.each(n.tagSeperators,function(e,t){i=i.replace(t,"")}),n.add({value:i,text:i,selected:!0},!0)?(n.close(),a.call(n)):(this.value="",n.setMessage("That tag is already in use."))}}),this.update=l.debounce(function(){n.opened&&n.config.closeOnScroll&&n.close(),n.width&&(n.container.style.width=n.width),n.invert()},50),this.requiresPagination&&(this.paginateItems=l.debounce(function(){u.call(this)},50),this.tree.addEventListener("scroll",this.paginateItems.bind(this))),document.addEventListener("click",this.events.dismiss),window.addEventListener("keydown",this.events.navigate),window.addEventListener("resize",this.update),window.addEventListener("scroll",this.update),this.el.form&&this.el.form.addEventListener("reset",this.events.reset)},d.prototype.setSelected=function(e){if(this.config.data||this.el.multiple||!this.el.options.length||(0===this.el.selectedIndex&&(this.el.options[0].defaultSelected||this.config.defaultSelected||(this.el.selectedIndex=-1)),this.selectedIndex=this.el.selectedIndex,-1<this.selectedIndex&&this.select(this.selectedIndex)),this.config.multiple&&"select-one"===this.originalType&&!this.config.data&&this.el.options[0].selected&&!this.el.options[0].defaultSelected&&(this.el.options[0].selected=!1),l.each(this.options,function(e,t){t.selected&&t.defaultSelected&&this.select(t.idx)},this),this.config.selectedValue&&this.setValue(this.config.selectedValue),this.config.data){!this.el.multiple&&this.config.defaultSelected&&this.el.selectedIndex<0&&this.select(0);var i=0;l.each(this.config.data,function(e,t){c(t,"children")?l.each(t.children,function(e,t){t.hasOwnProperty("selected")&&!0===t.selected&&this.select(i),i++},this):(t.hasOwnProperty("selected")&&!0===t.selected&&this.select(i),i++)},this)}},d.prototype.destroy=function(){this.rendered&&(this.emit("selectr.destroy"),"select-one"===this.originalType&&(this.el.multiple=!1),this.config.data&&(this.el.innerHTML=""),l.removeClass(this.el,"selectr-hidden"),this.el.form&&l.off(this.el.form,"reset",this.events.reset),l.off(document,"click",this.events.dismiss),l.off(document,"keydown",this.events.navigate),l.off(window,"resize",this.update),l.off(window,"scroll",this.update),this.container.parentNode.replaceChild(this.el,this.container),this.rendered=!1)},d.prototype.change=function(e){var t=this.items[e],i=this.options[e];i.disabled||(i.selected&&l.hasClass(t,"selected")?this.deselect(e):this.select(e),this.opened&&!this.el.multiple&&this.close())},d.prototype.select=function(n){var e=this.items[n],t=[].slice.call(this.el.options),i=this.options[n];if(this.el.multiple){if(l.includes(this.selectedIndexes,n))return!1;if(this.config.maxSelections&&this.tags.length===this.config.maxSelections)return this.setMessage("A maximum of "+this.config.maxSelections+" items can be selected.",!0),!1;this.selectedValues.push(i.value),this.selectedIndexes.push(n),function(e){var c,h=this,i=document.createDocumentFragment(),t=this.options[e.idx],n=this.data?this.data[e.idx]:t,r=this.customSelected?this.config.renderSelection(n):t.textContent,o=l.createElement("li",{class:"selectr-tag",html:r}),s=l.createElement("button",{class:"selectr-tag-remove",type:"button"});if(o.appendChild(s),o.idx=e.idx,o.tag=t.value,this.tags.push(o),this.config.sortSelected){var a=this.tags.slice();c=function(e,n){e.replace(/(\d+)|(\D+)/g,function(e,t,i){n.push([t||1/0,i||""])})},a.sort(function(e,t){var i,n,r=[],o=[];for(!0===h.config.sortSelected?(i=e.tag,n=t.tag):"text"===h.config.sortSelected&&(i=e.textContent,n=t.textContent),c(i,r),c(n,o);r.length&&o.length;){var s=r.shift(),a=o.shift(),l=s[0]-a[0]||s[1].localeCompare(a[1]);if(l)return l}return r.length-o.length}),l.each(a,function(e,t){i.appendChild(t)}),this.label.innerHTML=""}else i.appendChild(o);this.config.taggable?this.label.insertBefore(i,this.input.parentNode):this.label.appendChild(i)}.call(this,e)}else{var r=this.data?this.data[n]:i;this.label.innerHTML=this.customSelected?this.config.renderSelection(r):i.textContent,this.selectedValue=i.value,this.selectedIndex=n,l.each(this.options,function(e,t){var i=this.items[e];e!==n&&(i&&l.removeClass(i,"selected"),t.selected=!1,t.removeAttribute("selected"))},this)}l.includes(t,i)||this.el.add(i),e.setAttribute("aria-selected",!0),l.addClass(e,"selected"),l.addClass(this.container,"has-selected"),i.selected=!0,i.setAttribute("selected",""),this.emit("selectr.change",i),this.emit("selectr.select",i)},d.prototype.deselect=function(e,t){var i=this.items[e],n=this.options[e];if(this.el.multiple){var r=this.selectedIndexes.indexOf(e);this.selectedIndexes.splice(r,1);var o=this.selectedValues.indexOf(n.value);this.selectedValues.splice(o,1),function(i){var n=!1;l.each(this.tags,function(e,t){t.idx===i.idx&&(n=t)},this),n&&(this.label.removeChild(n),this.tags.splice(this.tags.indexOf(n),1))}.call(this,i),this.tags.length||l.removeClass(this.container,"has-selected")}else{if(!t&&!this.config.clearable&&!this.config.allowDeselect)return!1;this.label.innerHTML="",this.selectedValue=null,this.el.selectedIndex=this.selectedIndex=-1,l.removeClass(this.container,"has-selected")}this.items[e].setAttribute("aria-selected",!1),l.removeClass(this.items[e],"selected"),n.selected=!1,n.removeAttribute("selected"),this.emit("selectr.change",null),this.emit("selectr.deselect",n)},d.prototype.setValue=function(i){var n=Array.isArray(i);if(n||(i=i.toString().trim()),!this.el.multiple&&n)return!1;l.each(this.options,function(e,t){(n&&l.includes(i.toString(),t.value)||t.value===i)&&this.change(t.idx)},this)},d.prototype.getValue=function(e,t){var n;if(this.el.multiple)e?this.selectedIndexes.length&&(n={values:[]},l.each(this.selectedIndexes,function(e,t){var i=this.options[t];n.values[e]={value:i.value,text:i.textContent}},this)):n=this.selectedValues.slice();else if(e){var i=this.options[this.selectedIndex];n={value:i.value,text:i.textContent}}else n=this.selectedValue;return e&&t&&(n=JSON.stringify(n)),n},d.prototype.add=function(i,n){if(i){if(this.data=this.data||[],this.items=this.items||[],this.options=this.options||[],Array.isArray(i))l.each(i,function(e,t){this.add(t,n)},this);else if("[object Object]"===Object.prototype.toString.call(i)){if(n){var r=!1;if(l.each(this.options,function(e,t){t.value.toLowerCase()===i.value.toLowerCase()&&(r=!0)}),r)return!1}var e=l.createElement("option",i);return this.data.push(i),this.options.push(e),e.idx=0<this.options.length?this.options.length-1:0,h.call(this,e),i.selected&&this.select(e.idx),e}return this.setPlaceholder(),this.config.pagination&&this.paginate(),!0}},d.prototype.remove=function(i){var n,r=[];Array.isArray(i)?l.each(i,function(e,t){l.isInt(t)?r.push(this.getOptionByIndex(t)):"string"==typeof i&&r.push(this.getOptionByValue(t))},this):l.isInt(i)?r.push(this.getOptionByIndex(i)):"string"==typeof i&&r.push(this.getOptionByValue(i)),r.length&&(l.each(r,function(e,t){n=t.idx,this.el.remove(t),this.options.splice(n,1);var i=this.items[n].parentNode;i&&i.removeChild(this.items[n]),this.items.splice(n,1),l.each(this.options,function(e,t){t.idx=e,this.items[e].idx=e},this)},this),this.setPlaceholder(),this.config.pagination&&this.paginate())},d.prototype.removeAll=function(){this.clear(!0),l.each(this.el.options,function(e,t){this.el.remove(t)},this),l.truncate(this.tree),this.items=[],this.options=[],this.data=[],this.navIndex=0,this.requiresPagination&&(this.requiresPagination=!1,this.pageIndex=1,this.pages=[]),this.setPlaceholder()},d.prototype.search=function(n){if(!this.navigating){n=n||this.input.value;var r=document.createDocumentFragment();if(this.removeMessage(),l.truncate(this.tree),1<n.length)if(l.each(this.options,function(e,t){var i=this.items[t.idx];l.includes(t.textContent.toLowerCase(),n.toLowerCase())&&!t.disabled?(o(i,r,this.customOption),l.removeClass(i,"excluded"),this.customOption||(i.innerHTML=function(e,t){var i=new RegExp(e,"i").exec(t.textContent);return!!i&&t.textContent.replace(i[0],"<span class='selectr-match'>"+i[0]+"</span>")}(n,t))):l.addClass(i,"excluded")},this),r.childElementCount){var e=this.items[this.navIndex],t=r.firstElementChild;l.removeClass(e,"active"),this.navIndex=t.idx,l.addClass(t,"active")}else this.config.taggable||this.setMessage("no results.");else s.call(this);this.tree.appendChild(r)}},d.prototype.toggle=function(){this.disabled||(this.opened?this.close():this.open())},d.prototype.open=function(){var e=this;return!!this.options.length&&(this.opened||this.emit("selectr.open"),this.opened=!0,this.mobileDevice||this.config.nativeDropdown?(l.addClass(this.container,"native-open"),void(this.config.data&&l.each(this.options,function(e,t){this.el.add(t)},this))):(l.addClass(this.container,"open"),s.call(this),this.invert(),this.tree.scrollTop=0,l.removeClass(this.container,"notice"),this.selected.setAttribute("aria-expanded",!0),this.tree.setAttribute("aria-hidden",!1),this.tree.setAttribute("aria-expanded",!0),void(this.config.searchable&&!this.config.taggable&&setTimeout(function(){e.input.focus(),e.input.tabIndex=0},10))))},d.prototype.close=function(){if(this.opened&&this.emit("selectr.close"),this.opened=!1,this.mobileDevice||this.config.nativeDropdown)l.removeClass(this.container,"native-open");else{var e=l.hasClass(this.container,"notice");this.config.searchable&&!e&&(this.input.blur(),this.input.tabIndex=-1,this.searching=!1),e&&(l.removeClass(this.container,"notice"),this.notice.textContent=""),l.removeClass(this.container,"open"),l.removeClass(this.container,"native-open"),this.selected.setAttribute("aria-expanded",!1),this.tree.setAttribute("aria-hidden",!0),this.tree.setAttribute("aria-expanded",!1),l.truncate(this.tree),a.call(this)}},d.prototype.enable=function(){this.disabled=!1,this.el.disabled=!1,this.selected.tabIndex=this.originalIndex,this.el.multiple&&l.each(this.tags,function(e,t){t.lastElementChild.tabIndex=0}),l.removeClass(this.container,"selectr-disabled")},d.prototype.disable=function(e){e||(this.el.disabled=!0),this.selected.tabIndex=-1,this.el.multiple&&l.each(this.tags,function(e,t){t.lastElementChild.tabIndex=-1}),this.disabled=!0,l.addClass(this.container,"selectr-disabled")},d.prototype.reset=function(){this.disabled||(this.clear(),this.setSelected(!0),l.each(this.defaultSelected,function(e,t){this.select(t)},this),this.emit("selectr.reset"))},d.prototype.clear=function(e){if(this.el.multiple){if(this.selectedIndexes.length){var t=this.selectedIndexes.slice();l.each(t,function(e,t){this.deselect(t)},this)}}else-1<this.selectedIndex&&this.deselect(this.selectedIndex,e);this.emit("selectr.clear")},d.prototype.serialise=function(e){var n=[];return l.each(this.options,function(e,t){var i={value:t.value,text:t.textContent};t.selected&&(i.selected=!0),t.disabled&&(i.disabled=!0),n[e]=i}),e?JSON.stringify(n):n},d.prototype.serialize=function(e){return this.serialise(e)},d.prototype.setPlaceholder=function(e){e=e||this.config.placeholder||this.el.getAttribute("placeholder"),this.options.length||(e="No options available"),this.placeEl.innerHTML=e},d.prototype.paginate=function(){if(this.items.length){var i=this;return this.pages=this.items.map(function(e,t){return t%i.config.pagination==0?i.items.slice(t,t+i.config.pagination):null}).filter(function(e){return e}),this.pages}},d.prototype.setMessage=function(e,t){t&&this.close(),l.addClass(this.container,"notice"),this.notice.textContent=e},d.prototype.removeMessage=function(){l.removeClass(this.container,"notice"),this.notice.innerHTML=""},d.prototype.invert=function(){var e=l.rect(this.selected),t=this.tree.parentNode.offsetHeight,i=window.innerHeight;e.top+e.height+t>i?(l.addClass(this.container,"inverted"),this.isInverted=!0):(l.removeClass(this.container,"inverted"),this.isInverted=!1),this.optsRect=l.rect(this.tree)},d.prototype.getOptionByIndex=function(e){return this.options[e]},d.prototype.getOptionByValue=function(e){for(var t=!1,i=0,n=this.options.length;i<n;i++)if(this.options[i].value.trim()===e.toString().trim()){t=this.options[i];break}return t},e.exports=d},function(e,t){e.exports=function t(e,i){"use strict";function n(e){return t.insensitive&&(""+e).toLowerCase()||""+e}var r,o,s=/(^([+\-]?(?:0|[1-9]\d*)(?:\.\d*)?(?:[eE][+\-]?\d+)?)?$|^0x[0-9a-f]+$|\d+)/gi,a=/(^[ ]*|[ ]*$)/g,l=/(^([\w ]+,?[\w ]+)?[\w ]+,?[\w ]+\d+:\d+(:\d+)?[\w ]?|^\d{1,4}[\/\-]\d{1,4}[\/\-]\d{1,4}|^\w+, \w+ \d+, \d{4})/,c=/^0x[0-9a-f]+$/i,h=/^0/,d=n(e).replace(a,"")||"",u=n(i).replace(a,"")||"",g=d.replace(s,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),p=u.replace(s,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),m=parseInt(d.match(c),16)||1!==g.length&&d.match(l)&&Date.parse(d),f=parseInt(u.match(c),16)||m&&u.match(l)&&Date.parse(u)||null;if(f){if(m<f)return-1;if(f<m)return 1}for(var C=0,I=Math.max(g.length,p.length);C<I;C++){if(r=!(g[C]||"").match(h)&&parseFloat(g[C])||g[C]||0,o=!(p[C]||"").match(h)&&parseFloat(p[C])||p[C]||0,isNaN(r)!==isNaN(o))return isNaN(r)?1:-1;if(typeof r!=typeof o&&(r+="",o+=""),r<o)return-1;if(o<r)return 1}return 0}},function(e,t,i){"use strict";i.d(t,"a",function(){return n});var u=i(0);function n(r,e,o){var t=3<arguments.length&&void 0!==arguments[3]&&arguments[3],s=function(e){return"function"==typeof e.getRootNode?e.getRootNode():window}(r),a={},i=r.getBoundingClientRect(),n=e.getBoundingClientRect(),l=document.createElement("div");function c(){if(l&&l.parentNode){for(var e in l.parentNode.removeChild(l),a)if(i=a,n=e,Object.prototype.hasOwnProperty.call(i,n)){var t=a[e];t&&Object(u.removeEventListener)(s,e,t),delete a[e]}"function"==typeof o&&o(r)}var i,n}function h(e){!function(e){return e!==l&&!Object(u.isChildOf)(e,l)}(e.target)||c()}if(l.className="jsoneditor-anchor",l.style.position="absolute",l.style.left=i.left-n.left+"px",l.style.top=i.top-n.top+"px",l.style.width=i.width-2+"px",l.style.height=i.height-2+"px",l.style.boxSizing="border-box",e.appendChild(l),a.mousedown=Object(u.addEventListener)(s,"mousedown",h),a.mousewheel=Object(u.addEventListener)(s,"mousewheel",h),t){var d=null;l.onmouseover=function(){clearTimeout(d),d=null},l.onmouseout=function(){d=d||setTimeout(c,200)}}return l.destroy=c,l}},function(e,t,i){var n;if(window.Picker)n=window.Picker;else try{n=i(39)}catch(e){}e.exports=n},function(e,t,i){var n,r,o;!function(){"use strict";r=[],void 0===(o="function"==typeof(n=function(){"use strict";function f(e){if(typeof Node==="object"){return e instanceof Node}else{return e&&typeof e==="object"&&typeof e.nodeType==="number"}}function e(e){return"string"==typeof e}function C(){var o=[];return{watch:o.push.bind(o),trigger:function(e,t){var i=true;var n={detail:t,preventDefault:function e(){i=false}};for(var r=0;r<o.length;r++){o[r](e,n)}return i}}}function I(e){return window.getComputedStyle(e).display==="none"}function A(e){this.elem=e}function t(e,t){return A.make(e("parent")).clazz("pico-overlay").clazz(e("overlayClass","")).stylize({display:"none",position:"fixed",top:"0px",left:"0px",height:"100%",width:"100%",zIndex:1e4}).stylize(e("overlayStyles",{opacity:.5,background:"#000"})).onClick(function(){e("overlayClose",!0)&&t()})}A.make=function(e,t){if(typeof e==="string"){e=document.querySelector(e)}var i=document.createElement(t||"div");(e||document.body).appendChild(i);return new A(i)},A.prototype={child:function(e){return A.make(this.elem,e)},stylize:function(e){e=e||{};if(typeof e.opacity!=="undefined"){e.filter="alpha(opacity="+e.opacity*100+")"}for(var t in e){if(e.hasOwnProperty(t)){this.elem.style[t]=e[t]}}return this},clazz:function(e){this.elem.className+=" "+e;return this},html:function(e){if(f(e)){this.elem.appendChild(e)}else{this.elem.innerHTML=e}return this},onClick:function(e){this.elem.addEventListener("click",e);return this},destroy:function(){this.elem.parentNode.removeChild(this.elem)},hide:function(){this.elem.style.display="none"},show:function(){this.elem.style.display="block"},attr:function(e,t){if(t!==undefined){this.elem.setAttribute(e,t)}return this},anyAncestor:function(e){var t=this.elem;while(t){if(e(new A(t))){return true}else{t=t.parentNode}}return false},isVisible:function(){return!I(this.elem)}};var v=1;function i(e,t){var i=e("width","auto");if("number"==typeof i)i+="px";var n=e("modalId","pico-"+v++);return A.make(e("parent")).clazz("pico-content").clazz(e("modalClass","")).stylize({display:"none",position:"fixed",zIndex:10001,left:"50%",top:"38.1966%",maxHeight:"90%",boxSizing:"border-box",width:i,"-ms-transform":"translate(-50%,-38.1966%)","-moz-transform":"translate(-50%,-38.1966%)","-webkit-transform":"translate(-50%,-38.1966%)","-o-transform":"translate(-50%,-38.1966%)",transform:"translate(-50%,-38.1966%)"}).stylize(e("modalStyles",{overflow:"auto",backgroundColor:"white",padding:"20px",borderRadius:"5px"})).html(e("content")).attr("id",n).attr("role","dialog").attr("aria-labelledby",e("ariaLabelledBy")).attr("aria-describedby",e("ariaDescribedBy",n)).onClick(function(e){new A(e.target).anyAncestor(function(e){return/\bpico-close\b/.test(e.elem.className)})&&t()})}function n(e,t){if(t("closeButton",!0))return e.child("button").html(t("closeHtml","&#xD7;")).clazz("pico-close").clazz(t("closeClass","")).stylize(t("closeStyles",{borderRadius:"2px",border:0,padding:0,cursor:"pointer",height:"15px",width:"15px",position:"absolute",top:"5px",right:"5px",fontSize:"16px",textAlign:"center",lineHeight:"15px",background:"#CCC"})).attr("aria-label",t("close-label","Close"))}function b(e){return function(){return e().elem}}var y=C(),w=C();function r(n,r){function t(e,t){return(e.msMatchesSelector||e.webkitMatchesSelector||e.matches).call(e,t)}function o(e){return!(I(e)||t(e,":disabled")||e.hasAttribute("contenteditable"))&&(e.hasAttribute("tabindex")||t(e,"input,select,textarea,button,a[href],area[href],iframe"))}function s(e){for(var t=e.getElementsByTagName("*"),i=0;i<t.length;i++)if(o(t[i]))return t[i]}function o(e){for(var t=e.getElementsByTagName("*"),i=t.length;i--;)if(o(t[i]))return t[i]}var e;n.beforeShow(function(){e=document.activeElement}),n.afterShow(function(){if(r()){var e=s(n.modalElem());e&&e.focus()}}),n.afterClose(function(){r()&&e&&e.focus(),e=null}),w.watch(function(e){if(r()&&n.isVisible()){var t=s(n.modalElem()),i=function(e){for(var t=e.getElementsByTagName("*"),i=t.length;i--;)if(o(t[i]))return t[i]}(n.modalElem());(e.shiftKey?t:i)===document.activeElement&&((e.shiftKey?i:t).focus(),e.preventDefault())}})}function o(e,t){var i,n=new A(document.body);e.beforeShow(function(){i=n.elem.style.overflow,t()&&n.stylize({overflow:"hidden"})}),e.afterClose(function(){n.stylize({overflow:i})})}return document.documentElement.addEventListener("keydown",function(e){var t=e.which||e.keyCode;27===t?y.trigger():9===t&&w.trigger(e)}),function(n){(function(e){return"string"==typeof e}(n)||f(n))&&(n={content:n});var r=C(),t=C(),i=C(),o=C(),s=C();function a(e,t){var i=n[e];return"function"==typeof i&&(i=i(t)),void 0===i?t:i}var l,c,h=m.bind(window,"modal"),d=m.bind(window,"overlay"),u=m.bind(window,"close");function g(e){d().hide(),h().hide(),s.trigger(l,e)}function p(e){o.trigger(l,e)&&g(e)}function e(e){return function(){return e.apply(this,arguments),l}}function m(e,t){if(!c){var i=function(e,t){var i=e("width","auto");"number"==typeof i&&(i+="px");var n=e("modalId","pico-"+v++);return A.make(e("parent")).clazz("pico-content").clazz(e("modalClass","")).stylize({display:"none",position:"fixed",zIndex:10001,left:"50%",top:"38.1966%",maxHeight:"90%",boxSizing:"border-box",width:i,"-ms-transform":"translate(-50%,-38.1966%)","-moz-transform":"translate(-50%,-38.1966%)","-webkit-transform":"translate(-50%,-38.1966%)","-o-transform":"translate(-50%,-38.1966%)",transform:"translate(-50%,-38.1966%)"}).stylize(e("modalStyles",{overflow:"auto",backgroundColor:"white",padding:"20px",borderRadius:"5px"})).html(e("content")).attr("id",n).attr("role","dialog").attr("aria-labelledby",e("ariaLabelledBy")).attr("aria-describedby",e("ariaDescribedBy",n)).onClick(function(e){new A(e.target).anyAncestor(function(e){return/\bpico-close\b/.test(e.elem.className)})&&t()})}(a,p);c={modal:i,overlay:function(e,t){return A.make(e("parent")).clazz("pico-overlay").clazz(e("overlayClass","")).stylize({display:"none",position:"fixed",top:"0px",left:"0px",height:"100%",width:"100%",zIndex:1e4}).stylize(e("overlayStyles",{opacity:.5,background:"#000"})).onClick(function(){e("overlayClose",!0)&&t()})}(a,p),close:function(e,t){if(t("closeButton",!0))return e.child("button").html(t("closeHtml","&#xD7;")).clazz("pico-close").clazz(t("closeClass","")).stylize(t("closeStyles",{borderRadius:"2px",border:0,padding:0,cursor:"pointer",height:"15px",width:"15px",position:"absolute",top:"5px",right:"5px",fontSize:"16px",textAlign:"center",lineHeight:"15px",background:"#CCC"})).attr("aria-label",t("close-label","Close"))}(i,a)},r.trigger(l,t)}return c[e]}return function(n,r){function t(e,t){return(e.msMatchesSelector||e.webkitMatchesSelector||e.matches).call(e,t)}function o(e){return!(I(e)||t(e,":disabled")||e.hasAttribute("contenteditable"))&&(e.hasAttribute("tabindex")||t(e,"input,select,textarea,button,a[href],area[href],iframe"))}function s(e){for(var t=e.getElementsByTagName("*"),i=0;i<t.length;i++)if(o(t[i]))return t[i]}var e;n.beforeShow(function(){e=document.activeElement}),n.afterShow(function(){if(r()){var e=s(n.modalElem());e&&e.focus()}}),n.afterClose(function(){r()&&e&&e.focus(),e=null}),w.watch(function(e){if(r()&&n.isVisible()){var t=s(n.modalElem()),i=function(e){for(var t=e.getElementsByTagName("*"),i=t.length;i--;)if(o(t[i]))return t[i]}(n.modalElem());(e.shiftKey?t:i)===document.activeElement&&((e.shiftKey?i:t).focus(),e.preventDefault())}})}(l={modalElem:b(h),closeElem:b(u),overlayElem:b(d),buildDom:e(m.bind(null,null)),isVisible:function(){return!!(c&&h&&h().isVisible())},show:function(e){return t.trigger(l,e)&&(d().show(),u(),h().show(),i.trigger(l,e)),this},close:e(p),forceClose:e(g),destroy:function(){h().destroy(),d().destroy(),d=h=u=void 0},options:function(t){Object.keys(t).map(function(e){n[e]=t[e]})},afterCreate:e(r.watch),beforeShow:e(t.watch),afterShow:e(i.watch),beforeClose:e(o.watch),afterClose:e(s.watch)},a.bind(null,"focus",!0)),function(e,t){var i,n=new A(document.body);e.beforeShow(function(){i=n.elem.style.overflow,t()&&n.stylize({overflow:"hidden"})}),e.afterClose(function(){n.stylize({overflow:i})})}(l,a.bind(null,"bodyOverflow",!0)),y.watch(function(){a("escCloses",!0)&&l.isVisible()&&l.close()}),l}})?n.apply(t,r):n)||(e.exports=o)}()},function(e,t,i){"use strict";function n(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}i.d(t,"a",function(){return r});var r=function(){function o(e){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,o),this.errorTableVisible=e.errorTableVisible,this.onToggleVisibility=e.onToggleVisibility,this.onFocusLine=e.onFocusLine||function(){},this.onChangeHeight=e.onChangeHeight,this.dom={};var t=document.createElement("div");t.className="jsoneditor-validation-errors-container",this.dom.validationErrorsContainer=t;var i=document.createElement("div");i.style.display="none",i.className="jsoneditor-additional-errors fadein",i.innerHTML="Scroll for more &#9663;",this.dom.additionalErrorsIndication=i,t.appendChild(i);var n=document.createElement("span");n.className="jsoneditor-validation-error-icon",n.style.display="none",this.dom.validationErrorIcon=n;var r=document.createElement("span");r.className="jsoneditor-validation-error-count",r.style.display="none",this.dom.validationErrorCount=r,this.dom.parseErrorIndication=document.createElement("span"),this.dom.parseErrorIndication.className="jsoneditor-parse-error-icon",this.dom.parseErrorIndication.style.display="none"}return function(e,t,i){t&&n(e.prototype,t),i&&n(e,i)}(o,[{key:"getErrorTable",value:function(){return this.dom.validationErrorsContainer}},{key:"getErrorCounter",value:function(){return this.dom.validationErrorCount}},{key:"getWarningIcon",value:function(){return this.dom.validationErrorIcon}},{key:"getErrorIcon",value:function(){return this.dom.parseErrorIndication}},{key:"toggleTableVisibility",value:function(){this.errorTableVisible=!this.errorTableVisible,this.onToggleVisibility(this.errorTableVisible)}},{key:"setErrors",value:function(e,o){var s=this;if(this.dom.validationErrors&&(this.dom.validationErrors.parentNode.removeChild(this.dom.validationErrors),this.dom.validationErrors=null,this.dom.additionalErrorsIndication.style.display="none"),this.errorTableVisible&&0<e.length){var t=document.createElement("div");t.className="jsoneditor-validation-errors",t.innerHTML='<table class="jsoneditor-text-errors"><tbody></tbody></table>';var a=t.getElementsByTagName("tbody")[0];e.forEach(function(t){var e,i;if(e="string"==typeof t?'<td colspan="2"><pre>'+t+"</pre></td>":"<td>"+(t.dataPath||"")+"</td><td><pre>"+t.message+"</pre></td>",isNaN(t.line)){if(t.dataPath){var n=o.find(function(e){return e.path===t.dataPath});n&&(i=n.line+1)}}else i=t.line;var r=document.createElement("tr");r.className=isNaN(i)?"":"jump-to-line","error"===t.type?r.className+=" parse-error":r.className+=" validation-error",r.innerHTML='<td><button class="jsoneditor-schema-error"></button></td><td style="white-space:nowrap;">'+(isNaN(i)?"":"Ln "+i)+"</td>"+e,r.onclick=function(){s.onFocusLine(i)},a.appendChild(r)}),this.dom.validationErrors=t,this.dom.validationErrorsContainer.appendChild(t),this.dom.additionalErrorsIndication.title=e.length+" errors total",this.dom.validationErrorsContainer.clientHeight<this.dom.validationErrorsContainer.scrollHeight?(this.dom.additionalErrorsIndication.style.display="block",this.dom.validationErrorsContainer.onscroll=function(){s.dom.additionalErrorsIndication.style.display=0<s.dom.validationErrorsContainer.clientHeight&&0===s.dom.validationErrorsContainer.scrollTop?"block":"none"}):this.dom.validationErrorsContainer.onscroll=void 0;var i=this.dom.validationErrorsContainer.clientHeight+(this.dom.statusBar?this.dom.statusBar.clientHeight:0);this.onChangeHeight(i)}else this.onChangeHeight(0);var n=e.filter(function(e){return"error"!==e.type}).length;if(0<n?(this.dom.validationErrorCount.style.display="inline",this.dom.validationErrorCount.innerText=n,this.dom.validationErrorCount.onclick=this.toggleTableVisibility.bind(this),this.dom.validationErrorIcon.style.display="inline",this.dom.validationErrorIcon.title=n+" schema validation error(s) found",this.dom.validationErrorIcon.onclick=this.toggleTableVisibility.bind(this)):(this.dom.validationErrorCount.style.display="none",this.dom.validationErrorIcon.style.display="none"),e.some(function(e){return"error"===e.type})){var r=e[0].line;this.dom.parseErrorIndication.style.display="block",this.dom.parseErrorIndication.title=isNaN(r)?"parse error - check that the json is valid":"parse error on line "+r,this.dom.parseErrorIndication.onclick=this.toggleTableVisibility.bind(this)}else this.dom.parseErrorIndication.style.display="none"}}]),o}()},function(e,t){e.exports=function(e){return e.webpackPolyfill||(e.deprecate=function(){},e.paths=[],e.children||(e.children=[]),Object.defineProperty(e,"loaded",{enumerable:!0,get:function(){return e.l}}),Object.defineProperty(e,"id",{enumerable:!0,get:function(){return e.i}}),e.webpackPolyfill=1),e}},function(e,t,i){"use strict";var m=i(44),f=i(17),C=i(5),l=i(24),n=i(46);function c(e,t,i){var n=this._refs[i];if("string"==typeof n){if(!this._refs[n])return c.call(this,e,t,n);n=this._refs[n]}if((n=n||this._schemas[i])instanceof l)return u(n.schema,this._opts.inlineRefs)?n.schema:n.validate||this._compile(n);var r,o,s,a=h.call(this,t,i);return a&&(r=a.schema,t=a.root,s=a.baseId),r instanceof l?o=r.validate||e.call(this,r.schema,t,void 0,s):void 0!==r&&(o=u(r,this._opts.inlineRefs)?r:e.call(this,r,t,void 0,s)),o}function h(e,t){var i=m.parse(t),n=g(i),r=I(this._getId(e.schema));if(0===Object.keys(e.schema).length||n!==r){var o=A(n),s=this._refs[o];if("string"==typeof s)return function(e,t,i){var n=h.call(this,e,t);if(n){var r=n.schema,o=n.baseId;e=n.root;var s=this._getId(r);return s&&(o=p(o,s)),a.call(this,i,o,r,e)}}.call(this,e,s,i);if(s instanceof l)s.validate||this._compile(s),e=s;else{if(!((s=this._schemas[o])instanceof l))return;if(s.validate||this._compile(s),o==A(t))return{schema:s,root:e,baseId:r};e=s}if(!e.schema)return;r=I(this._getId(e.schema))}return a.call(this,i,r,e.schema,e)}(e.exports=c).normalizeId=A,c.fullPath=I,c.url=p,c.ids=function(e){var t=A(this._getId(e)),d={"":t},u={"":I(t,!1)},g={},p=this;return n(e,{allKeys:!0},function(e,t,i,n,r,o,s){if(""!==t){var a=p._getId(e),l=d[n],c=u[n]+"/"+r;if(void 0!==s&&(c+="/"+("number"==typeof s?s:C.escapeFragment(s))),"string"==typeof a){a=l=A(l?m.resolve(l,a):a);var h=p._refs[a];if("string"==typeof h&&(h=p._refs[h]),h&&h.schema){if(!f(e,h.schema))throw new Error('id "'+a+'" resolves to more than one schema')}else if(a!=A(c))if("#"==a[0]){if(g[a]&&!f(e,g[a]))throw new Error('id "'+a+'" resolves to more than one schema');g[a]=e}else p._refs[a]=c}d[t]=l,u[t]=c}}),g},c.inlineRef=u,c.schema=h;var d=C.toHash(["properties","patternProperties","enum","dependencies","definitions"]);function a(e,t,i,n){if(e.fragment=e.fragment||"","/"==e.fragment.slice(0,1)){for(var r=e.fragment.split("/"),o=1;o<r.length;o++){var s=r[o];if(s){if(void 0===(i=i[s=C.unescapeFragment(s)]))break;var a;if(!d[s]&&((a=this._getId(i))&&(t=p(t,a)),i.$ref)){var l=p(t,i.$ref),c=h.call(this,n,l);c&&(i=c.schema,n=c.root,t=c.baseId)}}}return void 0!==i&&i!==n.schema?{schema:i,root:n,baseId:t}:void 0}}var s=C.toHash(["type","format","pattern","maxLength","minLength","maxProperties","minProperties","maxItems","minItems","maximum","minimum","uniqueItems","multipleOf","required","enum"]);function u(e,t){return!1!==t&&(void 0===t||!0===t?function e(t){var i;if(Array.isArray(t)){for(var n=0;n<t.length;n++)if("object"==typeof(i=t[n])&&!e(i))return!1}else for(var r in t){if("$ref"==r)return!1;if("object"==typeof(i=t[r])&&!e(i))return!1}return!0}(e):t?function e(t){var i,n=0;if(Array.isArray(t)){for(var r=0;r<t.length;r++)if("object"==typeof(i=t[r])&&(n+=e(i)),n==1/0)return 1/0}else for(var o in t){if("$ref"==o)return 1/0;if(s[o])n++;else if("object"==typeof(i=t[o])&&(n+=e(i)+1),n==1/0)return 1/0}return n}(e)<=t:void 0)}function I(e,t){return!1!==t&&(e=A(e)),g(m.parse(e))}function g(e){return m.serialize(e).split("#")[0]+"#"}var r=/#\/?$/;function A(e){return e?e.replace(r,""):""}function p(e,t){return t=A(t),m.resolve(e,t)}},function(e,t,i){"use strict";var g=Array.isArray,p=Object.keys,m=Object.prototype.hasOwnProperty;e.exports=function e(t,i){if(t===i)return!0;if(t&&i&&"object"==typeof t&&"object"==typeof i){var n,r,o,s=g(t),a=g(i);if(s&&a){if((r=t.length)!=i.length)return!1;for(n=r;0!=n--;)if(!e(t[n],i[n]))return!1;return!0}if(s!=a)return!1;var l=t instanceof Date,c=i instanceof Date;if(l!=c)return!1;if(l&&c)return t.getTime()==i.getTime();var h=t instanceof RegExp,d=i instanceof RegExp;if(h!=d)return!1;if(h&&d)return t.toString()==i.toString();var u=p(t);if((r=u.length)!==p(i).length)return!1;for(n=r;0!=n--;)if(!m.call(i,u[n]))return!1;for(n=r;0!=n--;)if(!e(t[o=u[n]],i[o]))return!1;return!0}return t!=t&&i!=i}},function(e,t,i){"use strict";var n=i(16);function r(e,t,i){this.message=i||r.message(e,t),this.missingRef=n.url(e,t),this.missingSchema=n.normalizeId(n.fullPath(this.missingRef))}function o(e){return e.prototype=Object.create(Error.prototype),e.prototype.constructor=e}e.exports={Validation:o(function(e){this.message="validation failed",this.errors=e,this.ajv=this.validation=!0}),MissingRef:o(r)},r.message=function(e,t){return"can't resolve reference "+t+" from id "+e}},function(e,t,i){var n;if(window.ace)n=window.ace;else try{n=i(35),i(36),i(37);var r=i(38);n.config.setModuleUrl("ace/mode/json_worker",r)}catch(e){}e.exports=n},function(e,t,i){"use strict";i.r(t);var n=i(19),y=i.n(n),r=i(4),o=i.n(r),w=i(1),S=i(7),x=i(14),k=i(0);var s=i(6),a=i(8),l=i(2),R=i(33);function E(e){return(E="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}i.d(t,"textModeMixins",function(){return d});var c={},B="ace/theme/jsoneditor";function h(){try{this.format()}catch(e){}}c.create=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};void 0===t.statusBar&&(t.statusBar=!0),t.mainMenuBar=!1!==t.mainMenuBar,t.enableSort=!1!==t.enableSort,t.enableTransform=!1!==t.enableTransform,"number"==typeof(this.options=t).indentation?this.indentation=Number(t.indentation):this.indentation=2;var i=t.ace?t.ace:y.a;this.mode="code"===t.mode?"code":"text","code"===this.mode&&void 0===i&&(this.mode="text",console.warn("Failed to load Ace editor, falling back to plain text mode. Please use a JSONEditor bundle including Ace, or pass Ace as via the configuration option `ace`.")),this.theme=t.theme||B,this.theme===B&&i&&Object(R.tryRequireThemeJsonEditor)(),t.onTextSelectionChange&&this.onTextSelectionChange(t.onTextSelectionChange);var n=this;if(this.container=e,this.dom={},this.aceEditor=void 0,this.textarea=void 0,this.validateSchema=null,this.annotations=[],this._debouncedValidate=Object(k.debounce)(this.validate.bind(this),this.DEBOUNCE_INTERVAL),this.width=e.clientWidth,this.height=e.clientHeight,this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode,this.frame.onclick=function(e){e.preventDefault()},this.frame.onkeydown=function(e){n._onKeyDown(e)},this.content=document.createElement("div"),this.content.className="jsoneditor-outer",this.options.mainMenuBar){Object(k.addClassName)(this.content,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu);var r=document.createElement("button");r.type="button",r.className="jsoneditor-format",r.title="Format JSON data, with proper indentation and line feeds (Ctrl+\\)",this.menu.appendChild(r),r.onclick=function(){try{n.format(),n._onChange()}catch(e){n._onError(e)}};var o=document.createElement("button");if(o.type="button",o.className="jsoneditor-compact",o.title="Compact JSON data, remove all whitespaces (Ctrl+Shift+\\)",this.menu.appendChild(o),o.onclick=function(){try{n.compact(),n._onChange()}catch(e){n._onError(e)}},this.options.enableSort){var s=document.createElement("button");s.type="button",s.className="jsoneditor-sort",s.title=Object(w.c)("sortTitleShort"),s.onclick=function(){n._showSortModal()},this.menu.appendChild(s)}if(this.options.enableTransform){var a=document.createElement("button");a.type="button",a.title=Object(w.c)("transformTitleShort"),a.className="jsoneditor-transform",a.onclick=function(){n._showTransformModal()},this.menu.appendChild(a)}var l=document.createElement("button");if(l.type="button",l.className="jsoneditor-repair",l.title="Repair JSON: fix quotes and escape characters, remove comments and JSONP notation, turn JavaScript objects into JSON.",this.menu.appendChild(l),l.onclick=function(){try{n.repair(),n._onChange()}catch(e){n._onError(e)}},this.options&&this.options.modes&&this.options.modes.length&&(this.modeSwitcher=new S.a(this.menu,this.options.modes,this.options.mode,function(e){n.setMode(e),n.modeSwitcher.focus()})),"code"===this.mode){var c=document.createElement("a");c.appendChild(document.createTextNode("powered by ace")),c.href="http://ace.ajax.org",c.target="_blank",c.className="jsoneditor-poweredBy",c.onclick=function(){window.open(c.href,c.target)},this.menu.appendChild(c)}}var h=this.options.onEditable&&E("function"===this.options.onEditable)&&!this.options.onEditable({});if(this.frame.appendChild(this.content),this.container.appendChild(this.frame),"code"===this.mode){this.editorDom=document.createElement("div"),this.editorDom.style.height="100%",this.editorDom.style.width="100%",this.content.appendChild(this.editorDom);var d=i.edit(this.editorDom),u=d.getSession();d.$blockScrolling=1/0,d.setTheme(this.theme),d.setOptions({readOnly:h}),d.setShowPrintMargin(!1),d.setFontSize("13px"),u.setMode("ace/mode/json"),u.setTabSize(this.indentation),u.setUseSoftTabs(!0),u.setUseWrapMode(!0);var g=u.setAnnotations;u.setAnnotations=function(e){g.call(this,e&&e.length?e:n.annotations)},d.commands.bindKey("Ctrl-L",null),d.commands.bindKey("Command-L",null),(this.aceEditor=d).on("change",this._onChange.bind(this)),d.on("changeSelection",this._onSelect.bind(this))}else{var p=document.createElement("textarea");p.className="jsoneditor-text",p.spellcheck=!1,this.content.appendChild(p),this.textarea=p,this.textarea.readOnly=h,null===this.textarea.oninput?this.textarea.oninput=this._onChange.bind(this):this.textarea.onchange=this._onChange.bind(this),p.onselect=this._onSelect.bind(this),p.onmousedown=this._onMouseDown.bind(this),p.onblur=this._onBlur.bind(this)}if(this.errorTable=new x.a({errorTableVisible:"text"===this.mode,onToggleVisibility:function(){n.validate()},onFocusLine:function(e){n.isFocused=!0,isNaN(e)||n.setTextSelection({row:e,column:1},{row:e,column:1e3})},onChangeHeight:function(e){var t=e+(n.dom.statusBar?n.dom.statusBar.clientHeight:0)+1;n.content.style.marginBottom=-t+"px",n.content.style.paddingBottom=t+"px"}}),this.frame.appendChild(this.errorTable.getErrorTable()),t.statusBar){Object(k.addClassName)(this.content,"has-status-bar"),this.curserInfoElements={};var m=document.createElement("div");(this.dom.statusBar=m).className="jsoneditor-statusbar",this.frame.appendChild(m);var f=document.createElement("span");f.className="jsoneditor-curserinfo-label",f.innerText="Ln:";var C=document.createElement("span");C.className="jsoneditor-curserinfo-val",C.innerText="1",m.appendChild(f),
m.appendChild(C);var I=document.createElement("span");I.className="jsoneditor-curserinfo-label",I.innerText="Col:";var A=document.createElement("span");A.className="jsoneditor-curserinfo-val",A.innerText="1",m.appendChild(I),m.appendChild(A),this.curserInfoElements.colVal=A,this.curserInfoElements.lnVal=C;var v=document.createElement("span");v.className="jsoneditor-curserinfo-label",v.innerText="characters selected",v.style.display="none";var b=document.createElement("span");b.className="jsoneditor-curserinfo-count",b.innerText="0",b.style.display="none",this.curserInfoElements.countLabel=v,this.curserInfoElements.countVal=b,m.appendChild(b),m.appendChild(v),m.appendChild(this.errorTable.getErrorCounter()),m.appendChild(this.errorTable.getWarningIcon()),m.appendChild(this.errorTable.getErrorIcon())}this.setSchema(this.options.schema,this.options.schemaRefs)},c._onChange=function(){if(!this.onChangeDisabled){if(this._debouncedValidate(),this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(e){console.error("Error in onChangeText callback: ",e)}}},c._showSortModal=function(){var n=this,e=this.options.modalAnchor||l.a,r=this.get();Object(s.a)(e,r,function(e){if(Array.isArray(r)){var t=Object(k.sort)(r,e.path,e.direction);n.sortedBy=e,n.set(t)}if(Object(k.isObject)(r)){var i=Object(k.sortObjectKeys)(r,e.direction);n.sortedBy=e,n.set(i)}},n.sortedBy)},c._showTransformModal=function(){var i=this,e=this.options.modalAnchor||l.a,n=this.get();Object(a.a)(e,n,function(e){var t=o.a.search(n,e);i.set(t)})},c._onSelect=function(){this._updateCursorInfo(),this._emitSelectionChange()},c._onKeyDown=function(e){var t=!1;220===(e.which||e.keyCode)&&e.ctrlKey&&(e.shiftKey?this.compact():this.format(),this._onChange(),t=!0),t&&(e.preventDefault(),e.stopPropagation()),this._updateCursorInfo(),this._emitSelectionChange()},c._onMouseDown=function(){this._updateCursorInfo(),this._emitSelectionChange()},c._onBlur=function(){var e=this;setTimeout(function(){e.isFocused||(e._updateCursorInfo(),e._emitSelectionChange()),e.isFocused=!1})},c._updateCursorInfo=function(){var t,i,n,r=this;if(this.textarea)setTimeout(function(){var e=Object(k.getInputSelection)(r.textarea);e.startIndex!==e.endIndex&&(n=e.endIndex-e.startIndex),i=n&&r.cursorInfo&&r.cursorInfo.line===e.end.row&&r.cursorInfo.column===e.end.column?(t=e.start.row,e.start.column):(t=e.end.row,e.end.column),r.cursorInfo={line:t,column:i,count:n},r.options.statusBar&&s()},0);else if(this.aceEditor&&this.curserInfoElements){var e=this.aceEditor.getCursorPosition(),o=this.aceEditor.getSelectedText();t=e.row+1,i=e.column+1,n=o.length,r.cursorInfo={line:t,column:i,count:n},this.options.statusBar&&s()}function s(){r.curserInfoElements.countVal.innerText!==n&&(r.curserInfoElements.countVal.innerText=n,r.curserInfoElements.countVal.style.display=n?"inline":"none",r.curserInfoElements.countLabel.style.display=n?"inline":"none"),r.curserInfoElements.lnVal.innerText=t,r.curserInfoElements.colVal.innerText=i}},c._emitSelectionChange=function(){if(this._selectionChangedHandler){var e=this.getTextSelection();this._selectionChangedHandler(e.start,e.end,e.text)}},c._refreshAnnotations=function(){var e=this.aceEditor&&this.aceEditor.getSession();if(e){var t=e.getAnnotations().filter(function(e){return"error"===e.type});e.setAnnotations(t)}},c.destroy=function(){this.aceEditor&&(this.aceEditor.destroy(),this.aceEditor=null),this.frame&&this.container&&this.frame.parentNode===this.container&&this.container.removeChild(this.frame),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this.textarea=null,this._debouncedValidate=null},c.compact=function(){var e=this.get(),t=JSON.stringify(e);this._setText(t,!1)},c.format=function(){var e=this.get(),t=JSON.stringify(e,null,this.indentation);this._setText(t,!1)},c.repair=function(){var e=this.getText(),t=Object(k.repair)(e);this._setText(t,!1)},c.focus=function(){this.textarea&&this.textarea.focus(),this.aceEditor&&this.aceEditor.focus()},c.resize=function(){if(this.aceEditor){this.aceEditor.resize(!1)}},c.set=function(e){this.setText(JSON.stringify(e,null,this.indentation))},c.update=function(e){this.updateText(JSON.stringify(e,null,this.indentation))},c.get=function(){var e=this.getText();return Object(k.parse)(e)},c.getText=function(){return this.textarea?this.textarea.value:this.aceEditor?this.aceEditor.getValue():""},c._setText=function(e,t){var i=!0===this.options.escapeUnicode?Object(k.escapeUnicodeChars)(e):e;if(this.textarea&&(this.textarea.value=i),this.aceEditor&&(this.onChangeDisabled=!0,this.aceEditor.setValue(i,-1),this.onChangeDisabled=!1,t)){var n=this;setTimeout(function(){n.aceEditor&&n.aceEditor.session.getUndoManager().reset()},0)}this._debouncedValidate()},c.setText=function(e){this._setText(e,!0)},c.updateText=function(e){this.getText()!==e&&this._setText(e,!1)},c.validate=function(){var e,i=[],n=[];try{if(e=this.get(),this.validateSchema)this.validateSchema(e)||(i=this.validateSchema.errors.map(function(e){return e.type="validation",Object(k.improveSchemaError)(e)}));this.validationSequence=(this.validationSequence||0)+1;var r=this,o=this.validationSequence;(function(e,t){if(!t)return Promise.resolve([]);try{var i=t(e);return(Object(k.isPromise)(i)?i:Promise.resolve(i)).then(function(e){return Array.isArray(e)?e.filter(function(e){var t=Object(k.isValidValidationError)(e);return t||console.warn('Ignoring a custom validation error with invalid structure. Expected structure: {path: [...], message: "..."}. Actual error:',e),t}).map(function(e){return{dataPath:Object(k.stringifyPath)(e.path),message:e.message}}):[]})}catch(e){return Promise.reject(e)}})(e,this.options.onValidate).then(function(e){if(o===r.validationSequence){var t=i.concat(n).concat(e);r._renderErrors(t)}}).catch(function(e){console.error("Custom validation function did throw an error",e)})}catch(e){if(this.getText()){var t,s=/\w*line\s*(\d+)\w*/g.exec(e.message);s&&(t=+s[1]),n=[{type:"error",message:e.message.replace(/\n/g,"<br>"),line:t}]}this._renderErrors(n)}},c._renderErrors=function(n){var e=this.getText(),t=[];n.reduce(function(e,t){return"string"==typeof t.dataPath&&-1===e.indexOf(t.dataPath)&&e.push(t.dataPath),e},t);var i=Object(k.getPositionForPath)(e,t);if(this.aceEditor&&(this.annotations=i.map(function(t){var e=n.filter(function(e){return e.dataPath===t.path}),i=e.map(function(e){return e.message}).join("\n");return i?{row:t.line,column:t.column,text:"Schema validation error"+(1!==e.length?"s":"")+": \n"+i,type:"warning",source:"jsoneditor"}:{}}),this._refreshAnnotations()),this.errorTable.setErrors(n,i),this.aceEditor){this.aceEditor.resize(!1)}},c.getTextSelection=function(){var e={};if(this.textarea){var t=Object(k.getInputSelection)(this.textarea);return this.cursorInfo&&this.cursorInfo.line===t.end.row&&this.cursorInfo.column===t.end.column?(e.start=t.end,e.end=t.start):e=t,{start:e.start,end:e.end,text:this.textarea.value.substring(t.startIndex,t.endIndex)}}if(this.aceEditor){var i=this.aceEditor.getSelection(),n=this.aceEditor.getSelectedText(),r=i.getRange(),o=i.getSelectionLead();return o.row===r.end.row&&o.column===r.end.column?e=r:(e.start=r.end,e.end=r.start),{start:{row:e.start.row+1,column:e.start.column+1},end:{row:e.end.row+1,column:e.end.column+1},text:n}}},c.onTextSelectionChange=function(e){"function"==typeof e&&(this._selectionChangedHandler=Object(k.debounce)(e,this.DEBOUNCE_INTERVAL))},c.setTextSelection=function(e,t){if(e&&t)if(this.textarea){var i=Object(k.getIndexForPosition)(this.textarea,e.row,e.column),n=Object(k.getIndexForPosition)(this.textarea,t.row,t.column);if(-1<i&&-1<n){if(this.textarea.setSelectionRange)this.textarea.focus(),this.textarea.setSelectionRange(i,n);else if(this.textarea.createTextRange){var r=this.textarea.createTextRange();r.collapse(!0),r.moveEnd("character",n),r.moveStart("character",i),r.select()}var o=(this.textarea.value.match(/\n/g)||[]).length+1,s=this.textarea.scrollHeight/o,a=e.row*s;this.textarea.scrollTop=a>this.textarea.clientHeight?a-this.textarea.clientHeight/2:0}}else if(this.aceEditor){var l={start:{row:e.row-1,column:e.column-1},end:{row:t.row-1,column:t.column-1}};this.aceEditor.selection.setRange(l),this.aceEditor.scrollToLine(e.row-1,!0)}};var d=[{mode:"text",mixin:c,data:"text",load:h},{mode:"code",mixin:c,data:"text",load:h}]},function(e,t,i){var n,r=((n={trace:function(){},yy:{},symbols_:{error:2,JSONString:3,STRING:4,JSONNumber:5,NUMBER:6,JSONNullLiteral:7,NULL:8,JSONBooleanLiteral:9,TRUE:10,FALSE:11,JSONText:12,JSONValue:13,EOF:14,JSONObject:15,JSONArray:16,"{":17,"}":18,JSONMemberList:19,JSONMember:20,":":21,",":22,"[":23,"]":24,JSONElementList:25,$accept:0,$end:1},terminals_:{2:"error",4:"STRING",6:"NUMBER",8:"NULL",10:"TRUE",11:"FALSE",14:"EOF",17:"{",18:"}",21:":",22:",",23:"[",24:"]"},productions_:[0,[3,1],[5,1],[7,1],[9,1],[9,1],[12,2],[13,1],[13,1],[13,1],[13,1],[13,1],[13,1],[15,2],[15,3],[20,3],[19,1],[19,3],[16,2],[16,3],[25,1],[25,3]],performAction:function(e,t,i,n,r,o){var s=o.length-1;switch(r){case 1:this.$=e.replace(/\\(\\|")/g,"$1").replace(/\\n/g,"\n").replace(/\\r/g,"\r").replace(/\\t/g,"\t").replace(/\\v/g,"\v").replace(/\\f/g,"\f").replace(/\\b/g,"\b");break;case 2:this.$=Number(e);break;case 3:this.$=null;break;case 4:this.$=!0;break;case 5:this.$=!1;break;case 6:return this.$=o[s-1];case 13:this.$={};break;case 14:this.$=o[s-1];break;case 15:this.$=[o[s-2],o[s]];break;case 16:this.$={},this.$[o[s][0]]=o[s][1];break;case 17:this.$=o[s-2],o[s-2][o[s][0]]=o[s][1];break;case 18:this.$=[];break;case 19:this.$=o[s-1];break;case 20:this.$=[o[s]];break;case 21:this.$=o[s-2],o[s-2].push(o[s])}},table:[{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],12:1,13:2,15:7,16:8,17:[1,14],23:[1,15]},{1:[3]},{14:[1,16]},{14:[2,7],18:[2,7],22:[2,7],24:[2,7]},{14:[2,8],18:[2,8],22:[2,8],24:[2,8]},{14:[2,9],18:[2,9],22:[2,9],24:[2,9]},{14:[2,10],18:[2,10],22:[2,10],24:[2,10]},{14:[2,11],18:[2,11],22:[2,11],24:[2,11]},{14:[2,12],18:[2,12],22:[2,12],24:[2,12]},{14:[2,3],18:[2,3],22:[2,3],24:[2,3]},{14:[2,4],18:[2,4],22:[2,4],24:[2,4]},{14:[2,5],18:[2,5],22:[2,5],24:[2,5]},{14:[2,1],18:[2,1],21:[2,1],22:[2,1],24:[2,1]},{14:[2,2],18:[2,2],22:[2,2],24:[2,2]},{3:20,4:[1,12],18:[1,17],19:18,20:19},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:23,15:7,16:8,17:[1,14],23:[1,15],24:[1,21],25:22},{1:[2,6]},{14:[2,13],18:[2,13],22:[2,13],24:[2,13]},{18:[1,24],22:[1,25]},{18:[2,16],22:[2,16]},{21:[1,26]},{14:[2,18],18:[2,18],22:[2,18],24:[2,18]},{22:[1,28],24:[1,27]},{22:[2,20],24:[2,20]},{14:[2,14],18:[2,14],22:[2,14],24:[2,14]},{3:20,4:[1,12],20:29},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:30,15:7,16:8,17:[1,14],23:[1,15]},{14:[2,19],18:[2,19],22:[2,19],24:[2,19]},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:31,15:7,16:8,17:[1,14],23:[1,15]},{18:[2,17],22:[2,17]},{18:[2,15],22:[2,15]},{22:[2,21],24:[2,21]}],defaultActions:{16:[2,6]},parseError:function(e){throw new Error(e)},parse:function(e){var t=this,i=[0],n=[null],r=[],o=this.table,s="",a=0,l=0,c=0;this.lexer.setInput(e),this.lexer.yy=this.yy,this.yy.lexer=this.lexer,void 0===this.lexer.yylloc&&(this.lexer.yylloc={});var h=this.lexer.yylloc;function d(){var e;return"number"!=typeof(e=t.lexer.lex()||1)&&(e=t.symbols_[e]||e),e}r.push(h),"function"==typeof this.yy.parseError&&(this.parseError=this.yy.parseError);for(var u,g,p,m,f,C,I,A,v,b,y={};;){if(p=i[i.length-1],void 0===(m=this.defaultActions[p]?this.defaultActions[p]:(null==u&&(u=d()),o[p]&&o[p][u]))||!m.length||!m[0]){if(!c){for(C in v=[],o[p])this.terminals_[C]&&2<C&&v.push("'"+this.terminals_[C]+"'");var w="";w=this.lexer.showPosition?"Parse error on line "+(a+1)+":\n"+this.lexer.showPosition()+"\nExpecting "+v.join(", ")+", got '"+this.terminals_[u]+"'":"Parse error on line "+(a+1)+": Unexpected "+(1==u?"end of input":"'"+(this.terminals_[u]||u)+"'"),this.parseError(w,{text:this.lexer.match,token:this.terminals_[u]||u,line:this.lexer.yylineno,loc:h,expected:v})}if(3==c){if(1==u)throw new Error(w||"Parsing halted.");l=this.lexer.yyleng,s=this.lexer.yytext,a=this.lexer.yylineno,h=this.lexer.yylloc,u=d()}for(;!(2..toString()in o[p]);){if(0==p)throw new Error(w||"Parsing halted.");b=1,i.length=i.length-2*b,n.length=n.length-b,r.length=r.length-b,p=i[i.length-1]}g=u,u=2,m=o[p=i[i.length-1]]&&o[p][2],c=3}if(m[0]instanceof Array&&1<m.length)throw new Error("Parse Error: multiple actions possible at state: "+p+", token: "+u);switch(m[0]){case 1:i.push(u),n.push(this.lexer.yytext),r.push(this.lexer.yylloc),i.push(m[1]),u=null,g?(u=g,g=null):(l=this.lexer.yyleng,s=this.lexer.yytext,a=this.lexer.yylineno,h=this.lexer.yylloc,0<c&&c--);break;case 2:if(I=this.productions_[m[1]][1],y.$=n[n.length-I],y._$={first_line:r[r.length-(I||1)].first_line,last_line:r[r.length-1].last_line,first_column:r[r.length-(I||1)].first_column,last_column:r[r.length-1].last_column},void 0!==(f=this.performAction.call(y,s,l,a,this.yy,m[1],n,r)))return f;I&&(i=i.slice(0,-1*I*2),n=n.slice(0,-1*I),r=r.slice(0,-1*I)),i.push(this.productions_[m[1]][0]),n.push(y.$),r.push(y._$),A=o[i[i.length-2]][i[i.length-1]],i.push(A);break;case 3:return!0}}return!0}}).lexer={EOF:1,parseError:function(e,t){if(!this.yy.parseError)throw new Error(e);this.yy.parseError(e,t)},setInput:function(e){return this._input=e,this._more=this._less=this.done=!1,this.yylineno=this.yyleng=0,this.yytext=this.matched=this.match="",this.conditionStack=["INITIAL"],this.yylloc={first_line:1,first_column:0,last_line:1,last_column:0},this},input:function(){var e=this._input[0];return this.yytext+=e,this.yyleng++,this.match+=e,this.matched+=e,e.match(/\n/)&&this.yylineno++,this._input=this._input.slice(1),e},unput:function(e){return this._input=e+this._input,this},more:function(){return this._more=!0,this},less:function(e){this._input=this.match.slice(e)+this._input},pastInput:function(){var e=this.matched.substr(0,this.matched.length-this.match.length);return(20<e.length?"...":"")+e.substr(-20).replace(/\n/g,"")},upcomingInput:function(){var e=this.match;return e.length<20&&(e+=this._input.substr(0,20-e.length)),(e.substr(0,20)+(20<e.length?"...":"")).replace(/\n/g,"")},showPosition:function(){var e=this.pastInput(),t=new Array(e.length+1).join("-");return e+this.upcomingInput()+"\n"+t+"^"},next:function(){if(this.done)return this.EOF;var e,t,i,n,r;this._input||(this.done=!0),this._more||(this.yytext="",this.match="");for(var o=this._currentRules(),s=0;s<o.length&&(!(i=this._input.match(this.rules[o[s]]))||t&&!(i[0].length>t[0].length)||(t=i,n=s,this.options.flex));s++);return t?((r=t[0].match(/\n.*/g))&&(this.yylineno+=r.length),this.yylloc={first_line:this.yylloc.last_line,last_line:this.yylineno+1,first_column:this.yylloc.last_column,last_column:r?r[r.length-1].length-1:this.yylloc.last_column+t[0].length},this.yytext+=t[0],this.match+=t[0],this.yyleng=this.yytext.length,this._more=!1,this._input=this._input.slice(t[0].length),this.matched+=t[0],e=this.performAction.call(this,this.yy,this,o[n],this.conditionStack[this.conditionStack.length-1]),this.done&&this._input&&(this.done=!1),e||void 0):""===this._input?this.EOF:void this.parseError("Lexical error on line "+(this.yylineno+1)+". Unrecognized text.\n"+this.showPosition(),{text:"",token:null,line:this.yylineno})},lex:function(){var e=this.next();return void 0!==e?e:this.lex()},begin:function(e){this.conditionStack.push(e)},popState:function(){return this.conditionStack.pop()},_currentRules:function(){return this.conditions[this.conditionStack[this.conditionStack.length-1]].rules},topState:function(){return this.conditionStack[this.conditionStack.length-2]},pushState:function(e){this.begin(e)},options:{},performAction:function(e,t,i){switch(i){case 0:break;case 1:return 6;case 2:return t.yytext=t.yytext.substr(1,t.yyleng-2),4;case 3:return 17;case 4:return 18;case 5:return 23;case 6:return 24;case 7:return 22;case 8:return 21;case 9:return 10;case 10:return 11;case 11:return 8;case 12:return 14;case 13:return"INVALID"}},rules:[/^(?:\s+)/,/^(?:(-?([0-9]|[1-9][0-9]+))(\.[0-9]+)?([eE][-+]?[0-9]+)?\b)/,/^(?:"(?:\\[\\"bfnrt/]|\\u[a-fA-F0-9]{4}|[^\\\0-\x09\x0a-\x1f"])*")/,/^(?:\{)/,/^(?:\})/,/^(?:\[)/,/^(?:\])/,/^(?:,)/,/^(?::)/,/^(?:true\b)/,/^(?:false\b)/,/^(?:null\b)/,/^(?:$)/,/^(?:.)/],conditions:{INITIAL:{rules:[0,1,2,3,4,5,6,7,8,9,10,11,12,13],inclusive:!0}}},n);t.parser=r,t.parse=r.parse.bind(r)},function(e,t){e.exports=function(){throw new Error("define cannot be used indirect")}},function(e,t){function i(e){"remove"in e||Object.defineProperty(e,"remove",{configurable:!0,enumerable:!0,writable:!0,value:function(){void 0!==this.parentNode&&this.parentNode.removeChild(this)}})}"undefined"!=typeof Element&&(void 0!==window.Element&&i(window.Element.prototype),void 0!==window.CharacterData&&i(window.CharacterData.prototype),void 0!==window.DocumentType&&i(window.DocumentType.prototype)),Array.prototype.find||(Array.prototype.find=function(e){for(var t=0;t<this.length;t++){var i=this[t];if(e.call(this,i,t,this))return i}}),String.prototype.trim||(String.prototype.trim=function(){return this.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,"")})},function(e,t,i){"use strict";var n=i(5);e.exports=function(e){n.copy(e,this)}},function(e,t,i){"use strict";e.exports=function(e,t){"function"==typeof(t=t||{})&&(t={cmp:t});var o,l="boolean"==typeof t.cycles&&t.cycles,c=t.cmp&&(o=t.cmp,function(r){return function(e,t){var i={key:e,value:r[e]},n={key:t,value:r[t]};return o(i,n)}}),h=[];return function e(t){if(t&&t.toJSON&&"function"==typeof t.toJSON&&(t=t.toJSON()),void 0!==t){if("number"==typeof t)return isFinite(t)?""+t:"null";if("object"!=typeof t)return JSON.stringify(t);var i,n;if(Array.isArray(t)){for(n="[",i=0;i<t.length;i++)i&&(n+=","),n+=e(t[i])||"null";return n+"]"}if(null===t)return"null";if(-1!==h.indexOf(t)){if(l)return JSON.stringify("__cycle__");throw new TypeError("Converting circular structure to JSON")}var r=h.push(t)-1,o=Object.keys(t).sort(c&&c(t));for(n="",i=0;i<o.length;i++){var s=o[i],a=e(t[s]);a&&(n&&(n+=","),n+=JSON.stringify(s)+":"+a)}return h.splice(r,1),"{"+n+"}"}}(e)}},function(e,t,i){"use strict";e.exports=function(n,e){var t="",i=!0===n.schema.$async,r=n.util.schemaHasRulesExcept(n.schema,n.RULES.all,"$ref"),o=n.self._getId(n.schema);if(n.opts.strictKeywords){var s=n.util.schemaUnknownRules(n.schema,n.RULES.keywords);if(s){var a="unknown keyword: "+s;if("log"!==n.opts.strictKeywords)throw new Error(a);n.logger.warn(a)}}if(n.isTop&&(t+=" var validate = ",i&&(n.async=!0,t+="async "),t+="function(data, dataPath, parentData, parentDataProperty, rootData) { 'use strict'; ",o&&(n.opts.sourceCode||n.opts.processCode)&&(t+=" /*# sourceURL="+o+" */ ")),"boolean"==typeof n.schema||!r&&!n.schema.$ref){e="false schema";var l=n.level,c=n.dataLevel,h=n.schema[e],d=n.schemaPath+n.util.getProperty(e),u=n.errSchemaPath+"/"+e,g=!n.opts.allErrors,p="data"+(c||""),m="valid"+l;if(!1===n.schema){n.isTop?g=!0:t+=" var "+m+" = false; ",(z=z||[]).push(t),t="",!1!==n.createErrors?(t+=" { keyword: 'false schema' , dataPath: (dataPath || '') + "+n.errorPath+" , schemaPath: "+n.util.toQuotedString(u)+" , params: {} ",!1!==n.opts.messages&&(t+=" , message: 'boolean schema is false' "),n.opts.verbose&&(t+=" , schema: false , parentSchema: validate.schema"+n.schemaPath+" , data: "+p+" "),t+=" } "):t+=" {} ";var f=t;t=z.pop(),!n.compositeRule&&g?n.async?t+=" throw new ValidationError(["+f+"]); ":t+=" validate.errors = ["+f+"]; return false; ":t+=" var err = "+f+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; "}else n.isTop?t+=i?" return data; ":" validate.errors = null; return true; ":t+=" var "+m+" = true; ";return n.isTop&&(t+=" }; return validate; "),t}if(n.isTop){var C=n.isTop;l=n.level=0,c=n.dataLevel=0,p="data";if(n.rootId=n.resolve.fullPath(n.self._getId(n.root.schema)),n.baseId=n.baseId||n.rootId,delete n.isTop,n.dataPathArr=[void 0],void 0!==n.schema.default&&n.opts.useDefaults&&n.opts.strictDefaults){var I="default is ignored in the schema root";if("log"!==n.opts.strictDefaults)throw new Error(I);n.logger.warn(I)}t+=" var vErrors = null; ",t+=" var errors = 0;     ",t+=" if (rootData === undefined) rootData = data; "}else{l=n.level,p="data"+((c=n.dataLevel)||"");if(o&&(n.baseId=n.resolve.url(n.baseId,o)),i&&!n.async)throw new Error("async schema in sync schema");t+=" var errs_"+l+" = errors;"}m="valid"+l,g=!n.opts.allErrors;var A="",v="",b=n.schema.type,y=Array.isArray(b);if(b&&n.opts.nullable&&!0===n.schema.nullable&&(y?-1==b.indexOf("null")&&(b=b.concat("null")):"null"!=b&&(b=[b,"null"],y=!0)),y&&1==b.length&&(b=b[0],y=!1),n.schema.$ref&&r){if("fail"==n.opts.extendRefs)throw new Error('$ref: validation keywords used in schema at path "'+n.errSchemaPath+'" (see option extendRefs)');!0!==n.opts.extendRefs&&(r=!1,n.logger.warn('$ref: keywords ignored in schema at path "'+n.errSchemaPath+'"'))}if(n.schema.$comment&&n.opts.$comment&&(t+=" "+n.RULES.all.$comment.code(n,"$comment")),b){if(n.opts.coerceTypes)var w=n.util.coerceToTypes(n.opts.coerceTypes,b);var S=n.RULES.types[b];if(w||y||!0===S||S&&!U(S)){d=n.schemaPath+".type",u=n.errSchemaPath+"/type",d=n.schemaPath+".type",u=n.errSchemaPath+"/type";var x=y?"checkDataTypes":"checkDataType";if(t+=" if ("+n.util[x](b,p,!0)+") { ",w){var k="dataType"+l,R="coerced"+l;t+=" var "+k+" = typeof "+p+"; ","array"==n.opts.coerceTypes&&(t+=" if ("+k+" == 'object' && Array.isArray("+p+")) "+k+" = 'array'; "),t+=" var "+R+" = undefined; ";var E="",B=w;if(B)for(var G,Z=-1,T=B.length-1;Z<T;)G=B[Z+=1],Z&&(t+=" if ("+R+" === undefined) { ",E+="}"),"array"==n.opts.coerceTypes&&"array"!=G&&(t+=" if ("+k+" == 'array' && "+p+".length == 1) { "+R+" = "+p+" = "+p+"[0]; "+k+" = typeof "+p+";  } "),"string"==G?t+=" if ("+k+" == 'number' || "+k+" == 'boolean') "+R+" = '' + "+p+"; else if ("+p+" === null) "+R+" = ''; ":"number"==G||"integer"==G?(t+=" if ("+k+" == 'boolean' || "+p+" === null || ("+k+" == 'string' && "+p+" && "+p+" == +"+p+" ","integer"==G&&(t+=" && !("+p+" % 1)"),t+=")) "+R+" = +"+p+"; "):"boolean"==G?t+=" if ("+p+" === 'false' || "+p+" === 0 || "+p+" === null) "+R+" = false; else if ("+p+" === 'true' || "+p+" === 1) "+R+" = true; ":"null"==G?t+=" if ("+p+" === '' || "+p+" === 0 || "+p+" === false) "+R+" = null; ":"array"==n.opts.coerceTypes&&"array"==G&&(t+=" if ("+k+" == 'string' || "+k+" == 'number' || "+k+" == 'boolean' || "+p+" == null) "+R+" = ["+p+"]; ");(z=z||[]).push(t+=" "+E+" if ("+R+" === undefined) {   "),t="",!1!==n.createErrors?(t+=" { keyword: 'type' , dataPath: (dataPath || '') + "+n.errorPath+" , schemaPath: "+n.util.toQuotedString(u)+" , params: { type: '",t+=y?""+b.join(","):""+b,t+="' } ",!1!==n.opts.messages&&(t+=" , message: 'should be ",t+=y?""+b.join(","):""+b,t+="' "),n.opts.verbose&&(t+=" , schema: validate.schema"+d+" , parentSchema: validate.schema"+n.schemaPath+" , data: "+p+" "),t+=" } "):t+=" {} ";f=t;t=z.pop(),!n.compositeRule&&g?n.async?t+=" throw new ValidationError(["+f+"]); ":t+=" validate.errors = ["+f+"]; return false; ":t+=" var err = "+f+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",t+=" } else {  ";var W=c?"data"+(c-1||""):"parentData";t+=" "+p+" = "+R+"; ",c||(t+="if ("+W+" !== undefined)"),t+=" "+W+"["+(c?n.dataPathArr[c]:"parentDataProperty")+"] = "+R+"; } "}else{(z=z||[]).push(t),t="",!1!==n.createErrors?(t+=" { keyword: 'type' , dataPath: (dataPath || '') + "+n.errorPath+" , schemaPath: "+n.util.toQuotedString(u)+" , params: { type: '",t+=y?""+b.join(","):""+b,t+="' } ",!1!==n.opts.messages&&(t+=" , message: 'should be ",t+=y?""+b.join(","):""+b,t+="' "),n.opts.verbose&&(t+=" , schema: validate.schema"+d+" , parentSchema: validate.schema"+n.schemaPath+" , data: "+p+" "),t+=" } "):t+=" {} ";f=t;t=z.pop(),!n.compositeRule&&g?n.async?t+=" throw new ValidationError(["+f+"]); ":t+=" validate.errors = ["+f+"]; return false; ":t+=" var err = "+f+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; "}t+=" } "}}if(n.schema.$ref&&!r)t+=" "+n.RULES.all.$ref.code(n,"$ref")+" ",g&&(t+=" } if (errors === ",t+=C?"0":"errs_"+l,t+=") { ",v+="}");else{var _=n.RULES;if(_)for(var H=-1,L=_.length-1;H<L;)if(U(S=_[H+=1])){if(S.type&&(t+=" if ("+n.util.checkDataType(S.type,p)+") { "),n.opts.useDefaults)if("object"==S.type&&n.schema.properties){h=n.schema.properties;var $=Object.keys(h);if($)for(var V,N=-1,O=$.length-1;N<O;){if(void 0!==(K=h[V=$[N+=1]]).default){var F=p+n.util.getProperty(V);if(n.compositeRule){if(n.opts.strictDefaults){I="default is ignored for: "+F;if("log"!==n.opts.strictDefaults)throw new Error(I);n.logger.warn(I)}}else t+=" if ("+F+" === undefined ","empty"==n.opts.useDefaults&&(t+=" || "+F+" === null || "+F+" === '' "),t+=" ) "+F+" = ","shared"==n.opts.useDefaults?t+=" "+n.useDefault(K.default)+" ":t+=" "+JSON.stringify(K.default)+" ",t+="; "}}}else if("array"==S.type&&Array.isArray(n.schema.items)){var P=n.schema.items;if(P){Z=-1;for(var K,M=P.length-1;Z<M;)if(void 0!==(K=P[Z+=1]).default){F=p+"["+Z+"]";if(n.compositeRule){if(n.opts.strictDefaults){I="default is ignored for: "+F;if("log"!==n.opts.strictDefaults)throw new Error(I);n.logger.warn(I)}}else t+=" if ("+F+" === undefined ","empty"==n.opts.useDefaults&&(t+=" || "+F+" === null || "+F+" === '' "),t+=" ) "+F+" = ","shared"==n.opts.useDefaults?t+=" "+n.useDefault(K.default)+" ":t+=" "+JSON.stringify(K.default)+" ",t+="; "}}}var D=S.rules;if(D)for(var j,X=-1,Y=D.length-1;X<Y;)if(Q(j=D[X+=1])){var J=j.code(n,j.keyword,S.type);J&&(t+=" "+J+" ",g&&(A+="}"))}if(g&&(t+=" "+A+" ",A=""),S.type&&(t+=" } ",b&&b===S.type&&!w)){t+=" else { ";var z;d=n.schemaPath+".type",u=n.errSchemaPath+"/type";(z=z||[]).push(t),t="",!1!==n.createErrors?(t+=" { keyword: 'type' , dataPath: (dataPath || '') + "+n.errorPath+" , schemaPath: "+n.util.toQuotedString(u)+" , params: { type: '",t+=y?""+b.join(","):""+b,t+="' } ",!1!==n.opts.messages&&(t+=" , message: 'should be ",t+=y?""+b.join(","):""+b,t+="' "),n.opts.verbose&&(t+=" , schema: validate.schema"+d+" , parentSchema: validate.schema"+n.schemaPath+" , data: "+p+" "),t+=" } "):t+=" {} ";f=t;t=z.pop(),!n.compositeRule&&g?n.async?t+=" throw new ValidationError(["+f+"]); ":t+=" validate.errors = ["+f+"]; return false; ":t+=" var err = "+f+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",t+=" } "}g&&(t+=" if (errors === ",t+=C?"0":"errs_"+l,t+=") { ",v+="}")}}function U(e){for(var t=e.rules,i=0;i<t.length;i++)if(Q(t[i]))return!0}function Q(e){return void 0!==n.schema[e.keyword]||e.implements&&function(e){for(var t=e.implements,i=0;i<t.length;i++)if(void 0!==n.schema[t[i]])return!0}(e)}return g&&(t+=" "+v+" "),C?(i?(t+=" if (errors === 0) return data;           ",t+=" else throw new ValidationError(vErrors); "):(t+=" validate.errors = vErrors; ",t+=" return errors === 0;       "),t+=" }; return validate;"):t+=" var "+m+" = errors === errs_"+l+";",t=n.util.cleanUpCode(t),C&&(t=n.util.finalCleanUpCode(t,i)),t}},function(e,t,i){"use strict";e.exports=function(e,t){var i,n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||""),d=e.opts.$data&&s&&s.$data;i=d?(n+=" var schema"+r+" = "+e.util.getData(s.$data,o,e.dataPathArr)+"; ","schema"+r):s;var u="maximum"==t,g=u?"exclusiveMaximum":"exclusiveMinimum",p=e.schema[g],m=e.opts.$data&&p&&p.$data,f=u?"<":">",C=u?">":"<",I=void 0;if(m){var A=e.util.getData(p.$data,o,e.dataPathArr),v="exclusive"+r,b="exclType"+r,y="exclIsNumber"+r,w="' + "+(k="op"+r)+" + '";n+=" var schemaExcl"+r+" = "+A+"; ";var S;I=g;(S=S||[]).push(n+=" var "+v+"; var "+b+" = typeof "+(A="schemaExcl"+r)+"; if ("+b+" != 'boolean' && "+b+" != 'undefined' && "+b+" != 'number') { "),n="",!1!==e.createErrors?(n+=" { keyword: '"+(I||"_exclusiveLimit")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: {} ",!1!==e.opts.messages&&(n+=" , message: '"+g+" should be boolean' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var x=n;n=S.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+x+"]); ":n+=" validate.errors = ["+x+"]; return false; ":n+=" var err = "+x+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",n+=" } else if ( ",d&&(n+=" ("+i+" !== undefined && typeof "+i+" != 'number') || "),n+=" "+b+" == 'number' ? ( ("+v+" = "+i+" === undefined || "+A+" "+f+"= "+i+") ? "+h+" "+C+"= "+A+" : "+h+" "+C+" "+i+" ) : ( ("+v+" = "+A+" === true) ? "+h+" "+C+"= "+i+" : "+h+" "+C+" "+i+" ) || "+h+" !== "+h+") { var op"+r+" = "+v+" ? '"+f+"' : '"+f+"='; ",void 0===s&&(I=g,l=e.errSchemaPath+"/"+g,i=A,d=m)}else{w=f;if((y="number"==typeof p)&&d){var k="'"+w+"'";n+=" if ( ",d&&(n+=" ("+i+" !== undefined && typeof "+i+" != 'number') || "),n+=" ( "+i+" === undefined || "+p+" "+f+"= "+i+" ? "+h+" "+C+"= "+p+" : "+h+" "+C+" "+i+" ) || "+h+" !== "+h+") { "}else{y&&void 0===s?(v=!0,I=g,l=e.errSchemaPath+"/"+g,i=p,C+="="):(y&&(i=Math[u?"min":"max"](p,s)),p===(!y||i)?(v=!0,I=g,l=e.errSchemaPath+"/"+g,C+="="):(v=!1,w+="="));k="'"+w+"'";n+=" if ( ",d&&(n+=" ("+i+" !== undefined && typeof "+i+" != 'number') || "),n+=" "+h+" "+C+" "+i+" || "+h+" !== "+h+") { "}}I=I||t,(S=S||[]).push(n),n="",!1!==e.createErrors?(n+=" { keyword: '"+(I||"_limit")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { comparison: "+k+", limit: "+i+", exclusive: "+v+" } ",!1!==e.opts.messages&&(n+=" , message: 'should be "+w+" ",n+=d?"' + "+i:i+"'"),e.opts.verbose&&(n+=" , schema:  ",n+=d?"validate.schema"+a:""+s,n+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";x=n;return n=S.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+x+"]); ":n+=" validate.errors = ["+x+"]; return false; ":n+=" var err = "+x+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",n+=" } ",c&&(n+=" else { "),n}},function(e,t,i){"use strict";e.exports=function(e,t){var i,n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||""),d=e.opts.$data&&s&&s.$data;i=d?(n+=" var schema"+r+" = "+e.util.getData(s.$data,o,e.dataPathArr)+"; ","schema"+r):s,n+="if ( ",d&&(n+=" ("+i+" !== undefined && typeof "+i+" != 'number') || "),n+=" "+h+".length "+("maxItems"==t?">":"<")+" "+i+") { ";var u=t,g=g||[];g.push(n),n="",!1!==e.createErrors?(n+=" { keyword: '"+(u||"_limitItems")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { limit: "+i+" } ",!1!==e.opts.messages&&(n+=" , message: 'should NOT have ",n+="maxItems"==t?"more":"fewer",n+=" than ",n+=d?"' + "+i+" + '":""+s,n+=" items' "),e.opts.verbose&&(n+=" , schema:  ",n+=d?"validate.schema"+a:""+s,n+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var p=n;return n=g.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+p+"]); ":n+=" validate.errors = ["+p+"]; return false; ":n+=" var err = "+p+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",n+="} ",c&&(n+=" else { "),n}},function(e,t,i){"use strict";e.exports=function(e,t){var i,n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||""),d=e.opts.$data&&s&&s.$data;i=d?(n+=" var schema"+r+" = "+e.util.getData(s.$data,o,e.dataPathArr)+"; ","schema"+r):s;var u="maxLength"==t?">":"<";n+="if ( ",d&&(n+=" ("+i+" !== undefined && typeof "+i+" != 'number') || "),!1===e.opts.unicode?n+=" "+h+".length ":n+=" ucs2length("+h+") ",n+=" "+u+" "+i+") { ";var g=t,p=p||[];p.push(n),n="",!1!==e.createErrors?(n+=" { keyword: '"+(g||"_limitLength")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { limit: "+i+" } ",!1!==e.opts.messages&&(n+=" , message: 'should NOT be ",n+="maxLength"==t?"longer":"shorter",n+=" than ",n+=d?"' + "+i+" + '":""+s,n+=" characters' "),e.opts.verbose&&(n+=" , schema:  ",n+=d?"validate.schema"+a:""+s,n+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var m=n;return n=p.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+m+"]); ":n+=" validate.errors = ["+m+"]; return false; ":n+=" var err = "+m+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",n+="} ",c&&(n+=" else { "),n}},function(e,t,i){"use strict";e.exports=function(e,t){var i,n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||""),d=e.opts.$data&&s&&s.$data;i=d?(n+=" var schema"+r+" = "+e.util.getData(s.$data,o,e.dataPathArr)+"; ","schema"+r):s,n+="if ( ",d&&(n+=" ("+i+" !== undefined && typeof "+i+" != 'number') || "),n+=" Object.keys("+h+").length "+("maxProperties"==t?">":"<")+" "+i+") { ";var u=t,g=g||[];g.push(n),n="",!1!==e.createErrors?(n+=" { keyword: '"+(u||"_limitProperties")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { limit: "+i+" } ",!1!==e.opts.messages&&(n+=" , message: 'should NOT have ",n+="maxProperties"==t?"more":"fewer",n+=" than ",n+=d?"' + "+i+" + '":""+s,n+=" properties' "),e.opts.verbose&&(n+=" , schema:  ",n+=d?"validate.schema"+a:""+s,n+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var p=n;return n=g.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+p+"]); ":n+=" validate.errors = ["+p+"]; return false; ":n+=" var err = "+p+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",n+="} ",c&&(n+=" else { "),n}},function(e){e.exports=JSON.parse('{"$schema":"http://json-schema.org/draft-07/schema#","$id":"http://json-schema.org/draft-07/schema#","title":"Core schema meta-schema","definitions":{"schemaArray":{"type":"array","minItems":1,"items":{"$ref":"#"}},"nonNegativeInteger":{"type":"integer","minimum":0},"nonNegativeIntegerDefault0":{"allOf":[{"$ref":"#/definitions/nonNegativeInteger"},{"default":0}]},"simpleTypes":{"enum":["array","boolean","integer","null","number","object","string"]},"stringArray":{"type":"array","items":{"type":"string"},"uniqueItems":true,"default":[]}},"type":["object","boolean"],"properties":{"$id":{"type":"string","format":"uri-reference"},"$schema":{"type":"string","format":"uri"},"$ref":{"type":"string","format":"uri-reference"},"$comment":{"type":"string"},"title":{"type":"string"},"description":{"type":"string"},"default":true,"readOnly":{"type":"boolean","default":false},"examples":{"type":"array","items":true},"multipleOf":{"type":"number","exclusiveMinimum":0},"maximum":{"type":"number"},"exclusiveMaximum":{"type":"number"},"minimum":{"type":"number"},"exclusiveMinimum":{"type":"number"},"maxLength":{"$ref":"#/definitions/nonNegativeInteger"},"minLength":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"pattern":{"type":"string","format":"regex"},"additionalItems":{"$ref":"#"},"items":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/schemaArray"}],"default":true},"maxItems":{"$ref":"#/definitions/nonNegativeInteger"},"minItems":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"uniqueItems":{"type":"boolean","default":false},"contains":{"$ref":"#"},"maxProperties":{"$ref":"#/definitions/nonNegativeInteger"},"minProperties":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"required":{"$ref":"#/definitions/stringArray"},"additionalProperties":{"$ref":"#"},"definitions":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"properties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"patternProperties":{"type":"object","additionalProperties":{"$ref":"#"},"propertyNames":{"format":"regex"},"default":{}},"dependencies":{"type":"object","additionalProperties":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/stringArray"}]}},"propertyNames":{"$ref":"#"},"const":true,"enum":{"type":"array","items":true,"minItems":1,"uniqueItems":true},"type":{"anyOf":[{"$ref":"#/definitions/simpleTypes"},{"type":"array","items":{"$ref":"#/definitions/simpleTypes"},"minItems":1,"uniqueItems":true}]},"format":{"type":"string"},"contentMediaType":{"type":"string"},"contentEncoding":{"type":"string"},"if":{"$ref":"#"},"then":{"$ref":"#"},"else":{"$ref":"#"},"allOf":{"$ref":"#/definitions/schemaArray"},"anyOf":{"$ref":"#/definitions/schemaArray"},"oneOf":{"$ref":"#/definitions/schemaArray"},"not":{"$ref":"#"}},"default":true}')},function(e,t,i){"use strict";var y={b:"\b",f:"\f",n:"\n",r:"\r",t:"\t",'"':'"',"/":"/","\\":"\\"},w="a".charCodeAt();t.parse=function(r,e,t){var n={},i=0,o=0,s=0,a=t&&t.bigint&&"undefined"!=typeof BigInt;return{data:l("",!0),pointers:n};function l(e,t){var i;c(),f(e,"value");var n=u();switch(n){case"t":d("rue"),i=!0;break;case"f":d("alse"),i=!1;break;case"n":d("ull"),i=null;break;case'"':i=h();break;case"[":i=function(e){c();var t=[],i=0;if("]"==u())return t;g();for(;;){var n=e+"/"+i;t.push(l(n)),c();var r=u();if("]"==r)break;","!=r&&v(),c(),i++}return t}(e);break;case"{":i=function(e){c();var t={};if("}"==u())return t;g();for(;;){var i=I();'"'!=u()&&v();var n=h(),r=e+"/"+S(n);C(r,"key",i),f(r,"keyEnd"),c(),":"!=u()&&v(),c(),t[n]=l(r),c();var o=u();if("}"==o)break;","!=o&&v(),c()}return t}(e);break;default:g(),0<="-0123456789".indexOf(n)?i=function(){var e="",t=!0;"-"==r[s]&&(e+=u());e+="0"==r[s]?u():m(),"."==r[s]&&(e+=u()+m(),t=!1);"e"!=r[s]&&"E"!=r[s]||(e+=u(),"+"!=r[s]&&"-"!=r[s]||(e+=u()),e+=m(),t=!1);var i=+e;return a&&t&&(i>Number.MAX_SAFE_INTEGER||i<Number.MIN_SAFE_INTEGER)?BigInt(e):i}():A()}return f(e,"valueEnd"),c(),t&&s<r.length&&A(),i}function c(){e:for(;s<r.length;){switch(r[s]){case" ":o++;break;case"\t":o+=4;break;case"\r":o=0;break;case"\n":o=0,i++;break;default:break e}s++}}function h(){for(var e,t="";'"'!=(e=u());)"\\"==e?(e=u())in y?t+=y[e]:"u"==e?t+=p():v():t+=e;return t}function d(e){for(var t=0;t<e.length;t++)u()!==e[t]&&v()}function u(){b();var e=r[s];return s++,o++,e}function g(){s--,o--}function p(){for(var e=4,t=0;e--;){t<<=4;var i=u().toLowerCase();"a"<=i&&i<="f"?t+=i.charCodeAt()-w+10:"0"<=i&&i<="9"?t+=+i:v()}return String.fromCharCode(t)}function m(){for(var e="";"0"<=r[s]&&r[s]<="9";)e+=u();if(e.length)return e;b(),A()}function f(e,t){C(e,t,I())}function C(e,t,i){n[e]=n[e]||{},n[e][t]=i}function I(){return{line:i,column:o,pos:s}}function A(){throw new SyntaxError("Unexpected token "+r[s]+" in JSON at position "+s)}function v(){g(),A()}function b(){if(s>=r.length)throw new SyntaxError("Unexpected end of JSON input")}},t.stringify=function(e,t,i){if(A(e)){var n,r,o=0,g="object"==typeof i?i.space:i;switch(typeof g){case"number":var s=10<g?10:g<0?0:Math.floor(g);g=s&&I(s," "),r=n=s;break;case"string":g=g.slice(0,10);for(var a=r=n=0;a<g.length;a++){switch(g[a]){case" ":r++;break;case"\t":r+=4;break;case"\r":r=0;break;case"\n":r=0,o++;break;default:throw new Error("whitespace characters not allowed in JSON")}n++}break;default:g=void 0}var l="",c={},h=0,d=0,u=0,p=i&&i.es6&&"function"==typeof Map;return function c(h,d,u){C(u,"value");switch(typeof h){case"number":case"bigint":case"boolean":m(""+h);break;case"string":m(v(h));break;case"object":null===h?m("null"):"function"==typeof h.toJSON?m(v(h.toJSON())):Array.isArray(h)?e():p?h.constructor.BYTES_PER_ELEMENT?e():h instanceof Map?i():h instanceof Set?i(!0):t():t()}C(u,"valueEnd");function e(){if(h.length){m("[");for(var e=d+1,t=0;t<h.length;t++){t&&m(","),f(e);var i=A(h[t])?h[t]:null,n=u+"/"+t;c(i,e,n)}f(d),m("]")}else m("[]")}function t(){var e=Object.keys(h);if(e.length){m("{");for(var t=d+1,i=0;i<e.length;i++){var n=e[i],r=h[n];if(A(r)){i&&m(",");var o=u+"/"+S(n);f(t),C(o,"key"),m(v(n)),C(o,"keyEnd"),m(":"),g&&m(" "),c(r,t,o)}}f(d),m("}")}else m("{}")}function i(e){if(h.size){m("{");for(var t=d+1,i=!0,n=h.entries(),r=n.next();!r.done;){var o=r.value,s=o[0],a=!!e||o[1];if(A(a)){i||m(","),i=!1;var l=u+"/"+S(s);f(t),C(l,"key"),m(v(s)),C(l,"keyEnd"),m(":"),g&&m(" "),c(a,t,l)}r=n.next()}f(d),m("}")}else m("{}")}}(e,0,""),{json:l,pointers:c}}function m(e){d+=e.length,u+=e.length,l+=e}function f(e){if(g){for(l+="\n"+I(e,g),h++,d=0;e--;)o?(h+=o,d=r):d+=r,u+=n;u+=1}}function C(e,t){c[e]=c[e]||{},c[e][t]={line:h,column:d,pos:u}}function I(e,t){return Array(e+1).join(t)}};var n=["number","bigint","boolean","string","object"];function A(e){return 0<=n.indexOf(typeof e)}var r=/"|\\/g,o=/[\b]/g,s=/\f/g,a=/\n/g,l=/\r/g,c=/\t/g;function v(e){return'"'+(e=e.replace(r,"\\$&").replace(s,"\\f").replace(o,"\\b").replace(a,"\\n").replace(l,"\\r").replace(c,"\\t"))+'"'}var h=/~/g,d=/\//g;function S(e){return e.replace(h,"~0").replace(d,"~1")}},function(e,t,i){t.tryRequireThemeJsonEditor=function(){try{i(40)}catch(e){console.error(e)}}},function(e,t,r){"use strict";var i=r(19),n=r(12),o=r(78).treeModeMixins,s=r(20).textModeMixins,a=r(79).previewModeMixins,l=r(0),c=l.clear,h=l.extend,d=l.getInternetExplorerVersion,u=l.parse,g=(0,r(41).tryRequireAjv)();function p(e,t,i){if(!(this instanceof p))throw new Error('JSONEditor constructor called without "new".');var n=d();if(-1!==n&&n<9)throw new Error("Unsupported browser, IE9 or newer required. Please install the newest version of your browser.");t&&(t.error&&(console.warn('Option "error" has been renamed to "onError"'),t.onError=t.error,delete t.error),t.change&&(console.warn('Option "change" has been renamed to "onChange"'),t.onChange=t.change,delete t.change),t.editable&&(console.warn('Option "editable" has been renamed to "onEditable"'),t.onEditable=t.editable,delete t.editable),t.onChangeJSON&&("text"!==t.mode&&"code"!==t.mode&&(!t.modes||-1===t.modes.indexOf("text")&&-1===t.modes.indexOf("code"))||console.warn('Option "onChangeJSON" is not applicable to modes "text" and "code". Use "onChangeText" or "onChange" instead.')),t&&Object.keys(t).forEach(function(e){-1===p.VALID_OPTIONS.indexOf(e)&&console.warn('Unknown option "'+e+'". This option will be ignored')})),arguments.length&&this._create(e,t,i)}"undefined"==typeof Promise&&console.error("Promise undefined. Please load a Promise polyfill in the browser in order to use JSONEditor"),p.modes={},p.prototype.DEBOUNCE_INTERVAL=150,p.VALID_OPTIONS=["ajv","schema","schemaRefs","templates","ace","theme","autocomplete","onChange","onChangeJSON","onChangeText","onEditable","onError","onEvent","onModeChange","onNodeName","onValidate","onCreateMenu","onSelectionChange","onTextSelectionChange","onClassName","colorPicker","onColorPicker","timestampTag","escapeUnicode","history","search","mode","modes","name","indentation","sortObjectKeys","navigationBar","statusBar","mainMenuBar","languages","language","enableSort","enableTransform","maxVisibleChilds"],p.prototype._create=function(e,t,i){this.container=e,this.options=t||{},this.json=i||{};var n=this.options.mode||this.options.modes&&this.options.modes[0]||"tree";this.setMode(n)},p.prototype.destroy=function(){},p.prototype.set=function(e){this.json=e},p.prototype.get=function(){return this.json},p.prototype.setText=function(e){this.json=u(e)},p.prototype.getText=function(){return JSON.stringify(this.json)},p.prototype.setName=function(e){this.options||(this.options={}),this.options.name=e},p.prototype.getName=function(){return this.options&&this.options.name},p.prototype.setMode=function(e){if(e!==this.options.mode||!this.create){var t,i,n=this.container,r=h({},this.options),o=r.mode;r.mode=e;var s=p.modes[e];if(!s)throw new Error('Unknown mode "'+r.mode+'"');try{var a="text"===s.data;if(i=this.getName(),t=this[a?"getText":"get"](),this.destroy(),c(this),h(this,s.mixin),this.create(n,r),this.setName(i),this[a?"setText":"set"](t),"function"==typeof s.load)try{s.load.call(this)}catch(e){console.error(e)}if("function"==typeof r.onModeChange&&e!==o)try{r.onModeChange(e,o)}catch(e){console.error(e)}}catch(e){this._onError(e)}}},p.prototype.getMode=function(){return this.options.mode},p.prototype._onError=function(e){if(!this.options||"function"!=typeof this.options.onError)throw e;this.options.onError(e)},p.prototype.setSchema=function(e,t){if(e){var i;try{this.options.ajv?i=this.options.ajv:((i=g({allErrors:!0,verbose:!0,schemaId:"auto",$data:!0})).addMetaSchema(r(76)),i.addMetaSchema(r(77)))}catch(e){console.warn("Failed to create an instance of Ajv, JSON Schema validation is not available. Please use a JSONEditor bundle including Ajv, or pass an instance of Ajv as via the configuration option `ajv`.")}if(i){if(t){for(var n in t)i.removeSchema(n),t[n]&&i.addSchema(t[n],n);this.options.schemaRefs=t}this.validateSchema=i.compile(e),this.options.schema=e,this.validate()}this.refresh()}else this.validateSchema=null,this.options.schema=null,this.options.schemaRefs=null,this.validate(),this.refresh()},p.prototype.validate=function(){},p.prototype.refresh=function(){},p.registerMode=function(e){var t,i;if(Array.isArray(e))for(t=0;t<e.length;t++)p.registerMode(e[t]);else{if(!("mode"in e))throw new Error('Property "mode" missing');if(!("mixin"in e))throw new Error('Property "mixin" missing');if(!("data"in e))throw new Error('Property "data" missing');var n=e.mode;if(n in p.modes)throw new Error('Mode "'+n+'" already registered');if("function"!=typeof e.mixin.create)throw new Error('Required function "create" missing on mixin');var r=["setMode","registerMode","modes"];for(t=0;t<r.length;t++)if((i=r[t])in e.mixin)throw new Error('Reserved property "'+i+'" not allowed in mixin');p.modes[n]=e}},p.registerMode(o),p.registerMode(s),p.registerMode(a),p.ace=i,p.Ajv=g,p.VanillaPicker=n,p.default=p,e.exports=p},function(e,t,A){(function(i){!function(){var e=function(){return this}();e||"undefined"==typeof window||(e=window);var o=function(e,t,i){"string"==typeof e?(2==arguments.length&&(i=t),o.modules[e]||(o.payloads[e]=i,o.modules[e]=null)):o.original?o.original.apply(this,arguments):(console.error("dropping module because define wasn't a string."),console.trace())};o.modules={},o.payloads={};function s(e,t,i){if("string"==typeof t){var n=c(e,t);if(null!=n)return i&&i(),n}else if("[object Array]"===Object.prototype.toString.call(t)){for(var r=[],o=0,s=t.length;o<s;++o){var a=c(e,t[o]);if(null==a&&l.original)return;r.push(a)}return i&&i.apply(null,r)||!0}}var t,i,l=function(e,t){var i=s("",e,t);return null==i&&l.original?l.original.apply(this,arguments):i},a=function(e,t){if(-1!==t.indexOf("!")){var i=t.split("!");return a(e,i[0])+"!"+a(e,i[1])}if("."==t.charAt(0))for(t=e.split("/").slice(0,-1).join("/")+"/"+t;-1!==t.indexOf(".")&&n!=t;){var n=t;t=t.replace(/\/\.\//,"/").replace(/[^\/]+\/\.\.\//,"")}return t},c=function(e,i){i=a(e,i);var t=o.modules[i];if(!t){if("function"==typeof(t=o.payloads[i])){var n={},r={id:i,uri:"",exports:n,packaged:!0};n=t(function(e,t){return s(i,e,t)},n,r)||r.exports,o.modules[i]=n,delete o.payloads[i]}t=o.modules[i]=n||t}return t};i=e,(t="ace")&&(e[t]||(e[t]={}),i=e[t]),i.define&&i.define.packaged||(o.original=i.define,i.define=o,i.define.packaged=!0),i.require&&i.require.packaged||(l.original=i.require,i.require=l,i.require.packaged=!0)}(),ace.define("ace/lib/regexp",["require","exports","module"],function(e,t,i){"use strict";var n,o={exec:RegExp.prototype.exec,test:RegExp.prototype.test,match:String.prototype.match,replace:String.prototype.replace,split:String.prototype.split},s=void 0===o.exec.call(/()??/,"")[1],a=(n=/^/g,o.test.call(n,""),!n.lastIndex);a&&s||(RegExp.prototype.exec=function(e){var t,i,n=o.exec.apply(this,arguments);if("string"==typeof e&&n){if(!s&&1<n.length&&-1<function(e,t,i){if(Array.prototype.indexOf)return e.indexOf(t,i);for(var n=i||0;n<e.length;n++)if(e[n]===t)return n;return-1}(n,"")&&(i=RegExp(this.source,o.replace.call(function(e){return(e.global?"g":"")+(e.ignoreCase?"i":"")+(e.multiline?"m":"")+(e.extended?"x":"")+(e.sticky?"y":"")}(this),"g","")),o.replace.call(e.slice(n.index),i,function(){for(var e=1;e<arguments.length-2;e++)void 0===arguments[e]&&(n[e]=void 0)})),this._xregexp&&this._xregexp.captureNames)for(var r=1;r<n.length;r++)(t=this._xregexp.captureNames[r-1])&&(n[t]=n[r]);!a&&this.global&&!n[0].length&&this.lastIndex>n.index&&this.lastIndex--}return n},a||(RegExp.prototype.test=function(e){var t=o.exec.call(this,e);return t&&this.global&&!t[0].length&&this.lastIndex>t.index&&this.lastIndex--,!!t}))}),ace.define("ace/lib/es5-shim",["require","exports","module"],function(e,t,i){function o(){}Function.prototype.bind||(Function.prototype.bind=function(t){var i=this;if("function"!=typeof i)throw new TypeError("Function.prototype.bind called on incompatible "+i);var n=u.call(arguments,1),r=function(){if(this instanceof r){var e=i.apply(this,n.concat(u.call(arguments)));return Object(e)===e?e:this}return i.apply(t,n.concat(u.call(arguments)))};return i.prototype&&(o.prototype=i.prototype,r.prototype=new o,o.prototype=null),r});var r,s,a,l,c,n=Function.prototype.call,h=Array.prototype,d=Object.prototype,u=h.slice,g=n.bind(d.toString),p=n.bind(d.hasOwnProperty);if((c=p(d,"__defineGetter__"))&&(r=n.bind(d.__defineGetter__),s=n.bind(d.__defineSetter__),a=n.bind(d.__lookupGetter__),l=n.bind(d.__lookupSetter__)),2!=[1,2].splice(0).length)if(function(){function e(e){var t=new Array(e+2);return t[0]=t[1]=0,t}var t,i=[];if(i.splice.apply(i,e(20)),i.splice.apply(i,e(26)),t=i.length,i.splice(5,0,"XXX"),i.length,t+1==i.length)return 1}()){var m=Array.prototype.splice;Array.prototype.splice=function(e,t){return arguments.length?m.apply(this,[void 0===e?0:e,void 0===t?this.length-e:t].concat(u.call(arguments,2))):[]}}else Array.prototype.splice=function(e,t){var i=this.length;0<e?i<e&&(e=i):null==e?e=0:e<0&&(e=Math.max(i+e,0)),e+t<i||(t=i-e);var n=this.slice(e,e+t),r=u.call(arguments,2),o=r.length;if(e===i)o&&this.push.apply(this,r);else{var s=Math.min(t,i-e),a=e+s,l=a+o-s,c=i-a,h=i-s;if(l<a)for(var d=0;d<c;++d)this[l+d]=this[a+d];else if(a<l)for(d=c;d--;)this[l+d]=this[a+d];if(o&&e===h)this.length=h,this.push.apply(this,r);else for(this.length=h+o,d=0;d<o;++d)this[e+d]=r[d]}return n};Array.isArray||(Array.isArray=function(e){return"[object Array]"==g(e)});var f,C=Object("a"),I="a"!=C[0]||!(0 in C);if(Array.prototype.forEach||(Array.prototype.forEach=function(e,t){var i=Z(this),n=I&&"[object String]"==g(this)?this.split(""):i,r=t,o=-1,s=n.length>>>0;if("[object Function]"!=g(e))throw new TypeError;for(;++o<s;)o in n&&e.call(r,n[o],o,i)}),Array.prototype.map||(Array.prototype.map=function(e,t){var i=Z(this),n=I&&"[object String]"==g(this)?this.split(""):i,r=n.length>>>0,o=Array(r),s=t;if("[object Function]"!=g(e))throw new TypeError(e+" is not a function");for(var a=0;a<r;a++)a in n&&(o[a]=e.call(s,n[a],a,i));return o}),Array.prototype.filter||(Array.prototype.filter=function(e,t){var i,n=Z(this),r=I&&"[object String]"==g(this)?this.split(""):n,o=r.length>>>0,s=[],a=t;if("[object Function]"!=g(e))throw new TypeError(e+" is not a function");for(var l=0;l<o;l++)l in r&&(i=r[l],e.call(a,i,l,n)&&s.push(i));return s}),Array.prototype.every||(Array.prototype.every=function(e,t){var i=Z(this),n=I&&"[object String]"==g(this)?this.split(""):i,r=n.length>>>0,o=t;if("[object Function]"!=g(e))throw new TypeError(e+" is not a function");for(var s=0;s<r;s++)if(s in n&&!e.call(o,n[s],s,i))return!1;return!0}),Array.prototype.some||(Array.prototype.some=function(e,t){var i=Z(this),n=I&&"[object String]"==g(this)?this.split(""):i,r=n.length>>>0,o=t;if("[object Function]"!=g(e))throw new TypeError(e+" is not a function");for(var s=0;s<r;s++)if(s in n&&e.call(o,n[s],s,i))return!0;return!1}),Array.prototype.reduce||(Array.prototype.reduce=function(e,t){var i=Z(this),n=I&&"[object String]"==g(this)?this.split(""):i,r=n.length>>>0;if("[object Function]"!=g(e))throw new TypeError(e+" is not a function");if(!r&&1==arguments.length)throw new TypeError("reduce of empty array with no initial value");var o,s=0;if(2<=arguments.length)o=t;else for(;;){if(s in n){o=n[s++];break}if(++s>=r)throw new TypeError("reduce of empty array with no initial value")}for(;s<r;s++)s in n&&(o=e.call(void 0,o,n[s],s,i));return o}),Array.prototype.reduceRight||(Array.prototype.reduceRight=function(e,t){var i=Z(this),n=I&&"[object String]"==g(this)?this.split(""):i,r=n.length>>>0;if("[object Function]"!=g(e))throw new TypeError(e+" is not a function");if(!r&&1==arguments.length)throw new TypeError("reduceRight of empty array with no initial value");var o,s=r-1;if(2<=arguments.length)o=t;else for(;;){if(s in n){o=n[s--];break}if(--s<0)throw new TypeError("reduceRight of empty array with no initial value")}for(;s in this&&(o=e.call(void 0,o,n[s],s,i)),s--;);return o}),Array.prototype.indexOf&&-1==[0,1].indexOf(1,2)||(Array.prototype.indexOf=function(e,t){var i=I&&"[object String]"==g(this)?this.split(""):Z(this),n=i.length>>>0;if(!n)return-1;var r=0;for(1<arguments.length&&(r=G(t)),r=0<=r?r:Math.max(0,n+r);r<n;r++)if(r in i&&i[r]===e)return r;return-1}),Array.prototype.lastIndexOf&&-1==[0,1].lastIndexOf(0,-3)||(Array.prototype.lastIndexOf=function(e,t){var i=I&&"[object String]"==g(this)?this.split(""):Z(this),n=i.length>>>0;if(!n)return-1;var r=n-1;for(1<arguments.length&&(r=Math.min(r,G(t))),r=0<=r?r:n-Math.abs(r);0<=r;r--)if(r in i&&e===i[r])return r;return-1}),Object.getPrototypeOf||(Object.getPrototypeOf=function(e){return e.__proto__||(e.constructor?e.constructor.prototype:d)}),!Object.getOwnPropertyDescriptor){Object.getOwnPropertyDescriptor=function(e,t){if("object"!=typeof e&&"function"!=typeof e||null===e)throw new TypeError("Object.getOwnPropertyDescriptor called on a non-object: "+e);if(p(e,t)){var i;if(i={enumerable:!0,configurable:!0},c){var n=e.__proto__;e.__proto__=d;var r=a(e,t),o=l(e,t);if(e.__proto__=n,r||o)return r&&(i.get=r),o&&(i.set=o),i}return i.value=e[t],i}}}Object.getOwnPropertyNames||(Object.getOwnPropertyNames=function(e){return Object.keys(e)}),Object.create||(f=null===Object.prototype.__proto__?function(){return{__proto__:null}}:function(){var e={};for(var t in e)e[t]=null;return e.constructor=e.hasOwnProperty=e.propertyIsEnumerable=e.isPrototypeOf=e.toLocaleString=e.toString=e.valueOf=e.__proto__=null,e},Object.create=function(e,t){var i;if(null===e)i=f();else{if("object"!=typeof e)throw new TypeError("typeof prototype["+typeof e+"] != 'object'");function n(){}n.prototype=e,(i=new n).__proto__=e}return void 0!==t&&Object.defineProperties(i,t),i});function A(e){try{return Object.defineProperty(e,"sentinel",{}),"sentinel"in e}catch(e){}}if(Object.defineProperty){var v=A({}),b="undefined"==typeof document||A(document.createElement("div"));if(!v||!b)var y=Object.defineProperty}if(!Object.defineProperty||y){Object.defineProperty=function(e,t,i){if("object"!=typeof e&&"function"!=typeof e||null===e)throw new TypeError("Object.defineProperty called on non-object: "+e);if("object"!=typeof i&&"function"!=typeof i||null===i)throw new TypeError("Property description must be an object: "+i);if(y)try{return y.call(Object,e,t,i)}catch(e){}if(p(i,"value"))if(c&&(a(e,t)||l(e,t))){var n=e.__proto__;e.__proto__=d,delete e[t],e[t]=i.value,e.__proto__=n}else e[t]=i.value;else{if(!c)throw new TypeError("getters & setters can not be defined on this javascript engine");p(i,"get")&&r(e,t,i.get),p(i,"set")&&s(e,t,i.set)}return e}}Object.defineProperties||(Object.defineProperties=function(e,t){for(var i in t)p(t,i)&&Object.defineProperty(e,i,t[i]);return e}),Object.seal||(Object.seal=function(e){return e}),Object.freeze||(Object.freeze=function(e){return e});try{Object.freeze(function(){})}catch(e){Object.freeze=function(t){return function(e){return"function"==typeof e?e:t(e)}}(Object.freeze)}if(Object.preventExtensions||(Object.preventExtensions=function(e){return e}),Object.isSealed||(Object.isSealed=function(){return!1}),Object.isFrozen||(Object.isFrozen=function(){return!1}),Object.isExtensible||(Object.isExtensible=function(e){if(Object(e)===e)throw new TypeError;for(var t="";p(e,t);)t+="?";e[t]=!0;var i=p(e,t);return delete e[t],i}),!Object.keys){var w=!0,S=["toString","toLocaleString","valueOf","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","constructor"],x=S.length;for(var k in{toString:null})w=!1;Object.keys=function(e){if("object"!=typeof e&&"function"!=typeof e||null===e)throw new TypeError("Object.keys called on a non-object");var t=[];for(var i in e)p(e,i)&&t.push(i);if(w)for(var n=0,r=x;n<r;n++){var o=S[n];p(e,o)&&t.push(o)}return t}}Date.now||(Date.now=function(){return(new Date).getTime()});var R="\t\n\v\f\r                　\u2028\u2029\ufeff";if(!String.prototype.trim){R="["+R+"]";var E=new RegExp("^"+R+R+"*"),B=new RegExp(R+R+"*$");String.prototype.trim=function(){return String(this).replace(E,"").replace(B,"")}}function G(e){return(e=+e)!=e?e=0:0!==e&&e!==1/0&&e!==-1/0&&(e=(0<e||-1)*Math.floor(Math.abs(e))),e}var Z=function(e){if(null==e)throw new TypeError("can't convert "+e+" to object");return Object(e)}}),ace.define("ace/lib/fixoldbrowsers",["require","exports","module","ace/lib/regexp","ace/lib/es5-shim"],function(e,t,i){"use strict";e("./regexp"),e("./es5-shim"),"undefined"==typeof Element||Element.prototype.remove||Object.defineProperty(Element.prototype,"remove",{enumerable:!1,writable:!0,configurable:!0,value:function(){this.parentNode&&this.parentNode.removeChild(this)}})}),ace.define("ace/lib/useragent",["require","exports","module"],function(e,t,i){"use strict";t.OS={LINUX:"LINUX",MAC:"MAC",WINDOWS:"WINDOWS"},t.getOS=function(){return t.isMac?t.OS.MAC:t.isLinux?t.OS.LINUX:t.OS.WINDOWS};var n="object"==typeof navigator?navigator:{},r=(/mac|win|linux/i.exec(n.platform)||["other"])[0].toLowerCase(),o=n.userAgent||"",s=n.appName||"";t.isWin="win"==r,t.isMac="mac"==r,t.isLinux="linux"==r,t.isIE="Microsoft Internet Explorer"==s||0<=s.indexOf("MSAppHost")?parseFloat((o.match(/(?:MSIE |Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/)||[])[1]):parseFloat((o.match(/(?:Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/)||[])[1]),t.isOldIE=t.isIE&&t.isIE<9,t.isGecko=t.isMozilla=o.match(/ Gecko\/\d+/),t.isOpera="object"==typeof opera&&"[object Opera]"==Object.prototype.toString.call(window.opera),t.isWebKit=parseFloat(o.split("WebKit/")[1])||void 0,t.isChrome=parseFloat(o.split(" Chrome/")[1])||void 0,t.isEdge=parseFloat(o.split(" Edge/")[1])||void 0,t.isAIR=0<=o.indexOf("AdobeAIR"),t.isAndroid=0<=o.indexOf("Android"),t.isChromeOS=0<=o.indexOf(" CrOS "),t.isIOS=/iPad|iPhone|iPod/.test(o)&&!window.MSStream,t.isIOS&&(t.isMac=!0),t.isMobile=t.isIOS||t.isAndroid}),ace.define("ace/lib/dom",["require","exports","module","ace/lib/useragent"],function(e,a,t){"use strict";var i=e("./useragent");if(a.buildDom=function e(t,i,n){if("string"==typeof t&&t){var r=document.createTextNode(t);return i&&i.appendChild(r),r}if(!Array.isArray(t))return t;if("string"!=typeof t[0]||!t[0]){for(var o=[],s=0;s<t.length;s++){var a=e(t[s],i,n);a&&o.push(a)}return o}var l=document.createElement(t[0]),c=t[1],h=1;c&&"object"==typeof c&&!Array.isArray(c)&&(h=2);for(s=h;s<t.length;s++)e(t[s],l,n);return 2==h&&Object.keys(c).forEach(function(e){var t=c[e];"class"===e?l.className=Array.isArray(t)?t.join(" "):t:"function"==typeof t||"value"==e?l[e]=t:"ref"===e?n&&(n[t]=l):null!=t&&l.setAttribute(e,t)}),i&&i.appendChild(l),l},a.getDocumentHead=function(e){return(e=e||document).head||e.getElementsByTagName("head")[0]||e.documentElement},a.createElement=function(e,t){return document.createElementNS?document.createElementNS(t||"http://www.w3.org/1999/xhtml",e):document.createElement(e)},a.removeChildren=function(e){e.innerHTML=""},a.createTextNode=function(e,t){return(t?t.ownerDocument:document).createTextNode(e)},a.createFragment=function(e){return(e?e.ownerDocument:document).createDocumentFragment()},a.hasCssClass=function(e,t){return-1!==(e.className+"").split(/\s+/g).indexOf(t)},a.addCssClass=function(e,t){a.hasCssClass(e,t)||(e.className+=" "+t)},a.removeCssClass=function(e,t){for(var i=e.className.split(/\s+/g);;){var n=i.indexOf(t);if(-1==n)break;i.splice(n,1)}e.className=i.join(" ")},a.toggleCssClass=function(e,t){for(var i=e.className.split(/\s+/g),n=!0;;){var r=i.indexOf(t);if(-1==r)break;n=!1,i.splice(r,1)}return n&&i.push(t),e.className=i.join(" "),n},a.setCssClass=function(e,t,i){i?a.addCssClass(e,t):a.removeCssClass(e,t)},a.hasCssString=function(e,t){var i,n=0;if(i=(t=t||document).querySelectorAll("style"))for(;n<i.length;)if(i[n++].id===e)return!0},a.importCssString=function(e,t,i){var n=i;i&&i.getRootNode&&(n=i.getRootNode())&&n!=i||(n=document);var r=n.ownerDocument||n;if(t&&a.hasCssString(t,n))return null;t&&(e+="\n/*# sourceURL=ace/css/"+t+" */");var o=a.createElement("style");o.appendChild(r.createTextNode(e)),t&&(o.id=t),n==r&&(n=a.getDocumentHead(r)),n.insertBefore(o,n.firstChild)},a.importCssStylsheet=function(e,t){a.buildDom(["link",{rel:"stylesheet",href:e}],a.getDocumentHead(t))},a.scrollbarWidth=function(e){var t=a.createElement("ace_inner");t.style.width="100%",t.style.minWidth="0px",t.style.height="200px",t.style.display="block";var i=a.createElement("ace_outer"),n=i.style;n.position="absolute",n.left="-10000px",n.overflow="hidden",n.width="200px",n.minWidth="0px",n.height="150px",n.display="block",i.appendChild(t);var r=e.documentElement;r.appendChild(i);var o=t.offsetWidth;n.overflow="scroll";var s=t.offsetWidth;return o==s&&(s=i.clientWidth),r.removeChild(i),o-s},"undefined"==typeof document&&(a.importCssString=function(){}),a.computedStyle=function(e,t){return window.getComputedStyle(e,"")||{}},a.setStyle=function(e,t,i){e[t]!==i&&(e[t]=i)},a.HAS_CSS_ANIMATION=!1,a.HAS_CSS_TRANSFORMS=!1,a.HI_DPI=!i.isWin||"undefined"!=typeof window&&1.5<=window.devicePixelRatio,"undefined"!=typeof document){var n=document.createElement("div");a.HI_DPI&&void 0!==n.style.transform&&(a.HAS_CSS_TRANSFORMS=!0),i.isEdge||void 0===n.style.animationName||(a.HAS_CSS_ANIMATION=!0),n=null}a.HAS_CSS_TRANSFORMS?a.translate=function(e,t,i){e.style.transform="translate("+Math.round(t)+"px, "+Math.round(i)+"px)"}:a.translate=function(e,t,i){e.style.top=Math.round(i)+"px",e.style.left=Math.round(t)+"px"}}),ace.define("ace/lib/oop",["require","exports","module"],function(e,i,t){"use strict";i.inherits=function(e,t){e.super_=t,e.prototype=Object.create(t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}})},i.mixin=function(e,t){for(var i in t)e[i]=t[i];return e},i.implement=function(e,t){i.mixin(e,t)}}),ace.define("ace/lib/keys",["require","exports","module","ace/lib/oop"],function(e,t,i){"use strict";var n=e("./oop"),r=function(){var e,t,i={MODIFIER_KEYS:{16:"Shift",17:"Ctrl",18:"Alt",224:"Meta",91:"MetaLeft",92:"MetaRight",93:"ContextMenu"},KEY_MODS:{ctrl:1,alt:2,option:2,shift:4,super:8,meta:8,command:8,cmd:8},FUNCTION_KEYS:{8:"Backspace",9:"Tab",13:"Return",19:"Pause",27:"Esc",32:"Space",33:"PageUp",34:"PageDown",35:"End",36:"Home",37:"Left",38:"Up",39:"Right",40:"Down",44:"Print",45:"Insert",46:"Delete",96:"Numpad0",97:"Numpad1",98:"Numpad2",99:"Numpad3",100:"Numpad4",101:"Numpad5",102:"Numpad6",103:"Numpad7",104:"Numpad8",105:"Numpad9","-13":"NumpadEnter",112:"F1",113:"F2",114:"F3",115:"F4",116:"F5",117:"F6",118:"F7",119:"F8",120:"F9",121:"F10",122:"F11",123:"F12",144:"Numlock",145:"Scrolllock"},PRINTABLE_KEYS:{32:" ",48:"0",49:"1",50:"2",51:"3",52:"4",53:"5",54:"6",55:"7",56:"8",57:"9",59:";",61:"=",65:"a",66:"b",67:"c",68:"d",69:"e",70:"f",71:"g",72:"h",73:"i",74:"j",75:"k",76:"l",77:"m",78:"n",79:"o",80:"p",81:"q",82:"r",83:"s",84:"t",85:"u",86:"v",87:"w",88:"x",89:"y",90:"z",107:"+",109:"-",110:".",186:";",187:"=",188:",",189:"-",190:".",191:"/",192:"`",219:"[",220:"\\",221:"]",222:"'",111:"/",106:"*"}};for(t in i.FUNCTION_KEYS)e=i.FUNCTION_KEYS[t].toLowerCase(),i[e]=parseInt(t,10);for(t in i.PRINTABLE_KEYS
)e=i.PRINTABLE_KEYS[t].toLowerCase(),i[e]=parseInt(t,10);return n.mixin(i,i.MODIFIER_KEYS),n.mixin(i,i.PRINTABLE_KEYS),n.mixin(i,i.FUNCTION_KEYS),i.enter=i.return,i.escape=i.esc,i.del=i.delete,i[173]="-",function(){for(var e=["cmd","ctrl","alt","shift"],t=Math.pow(2,e.length);t--;)i.KEY_MODS[t]=e.filter(function(e){return t&i.KEY_MODS[e]}).join("-")+"-"}(),i.KEY_MODS[0]="",i.KEY_MODS[-1]="input-",i}();n.mixin(t,r),t.keyCodeToString=function(e){var t=r[e];return"string"!=typeof t&&(t=String.fromCharCode(e)),t.toLowerCase()}}),ace.define("ace/lib/event",["require","exports","module","ace/lib/keys","ace/lib/useragent"],function(e,d,t){"use strict";var o=e("./keys"),u=e("./useragent"),s=null,a=0;d.addListener=function(e,t,i){if(e.addEventListener)return e.addEventListener(t,i,!1);if(e.attachEvent){var n=function(){i.call(e,window.event)};i._wrapper=n,e.attachEvent("on"+t,n)}},d.removeListener=function(e,t,i){if(e.removeEventListener)return e.removeEventListener(t,i,!1);e.detachEvent&&e.detachEvent("on"+t,i._wrapper||i)},d.stopEvent=function(e){return d.stopPropagation(e),d.preventDefault(e),!1},d.stopPropagation=function(e){e.stopPropagation?e.stopPropagation():e.cancelBubble=!0},d.preventDefault=function(e){e.preventDefault?e.preventDefault():e.returnValue=!1},d.getButton=function(e){return"dblclick"==e.type?0:"contextmenu"==e.type||u.isMac&&e.ctrlKey&&!e.altKey&&!e.shiftKey?2:e.preventDefault?e.button:{1:0,2:2,4:1}[e.button]},d.capture=function(e,t,i){function n(e){t&&t(e),i&&i(e),d.removeListener(document,"mousemove",t,!0),d.removeListener(document,"mouseup",n,!0),d.removeListener(document,"dragstart",n,!0)}return d.addListener(document,"mousemove",t,!0),d.addListener(document,"mouseup",n,!0),d.addListener(document,"dragstart",n,!0),n},d.addMouseWheelListener=function(e,t){"onmousewheel"in e?d.addListener(e,"mousewheel",function(e){void 0!==e.wheelDeltaX?(e.wheelX=-e.wheelDeltaX/8,e.wheelY=-e.wheelDeltaY/8):(e.wheelX=0,e.wheelY=-e.wheelDelta/8),t(e)}):"onwheel"in e?d.addListener(e,"wheel",function(e){switch(e.deltaMode){case e.DOM_DELTA_PIXEL:e.wheelX=.35*e.deltaX||0,e.wheelY=.35*e.deltaY||0;break;case e.DOM_DELTA_LINE:case e.DOM_DELTA_PAGE:e.wheelX=5*(e.deltaX||0),e.wheelY=5*(e.deltaY||0)}t(e)}):d.addListener(e,"DOMMouseScroll",function(e){e.axis&&e.axis==e.HORIZONTAL_AXIS?(e.wheelX=5*(e.detail||0),e.wheelY=0):(e.wheelX=0,e.wheelY=5*(e.detail||0)),t(e)})},d.addMultiMouseDownListener=function(e,i,n,r){var o,s,a,l=0,c={2:"dblclick",3:"tripleclick",4:"quadclick"};function t(e){if(0!==d.getButton(e)?l=0:1<e.detail?4<++l&&(l=1):l=1,u.isIE){var t=5<Math.abs(e.clientX-o)||5<Math.abs(e.clientY-s);a&&!t||(l=1),a&&clearTimeout(a),a=setTimeout(function(){a=null},i[l-1]||600),1==l&&(o=e.clientX,s=e.clientY)}if(e._clicks=l,n[r]("mousedown",e),4<l)l=0;else if(1<l)return n[r](c[l],e)}function h(e){l=2,a&&clearTimeout(a),a=setTimeout(function(){a=null},i[l-1]||600),n[r]("mousedown",e),n[r](c[l],e)}Array.isArray(e)||(e=[e]),e.forEach(function(e){d.addListener(e,"mousedown",t),u.isOldIE&&d.addListener(e,"dblclick",h)})};var l=!u.isMac||!u.isOpera||"KeyboardEvent"in window?function(e){return 0|(e.ctrlKey?1:0)|(e.altKey?2:0)|(e.shiftKey?4:0)|(e.metaKey?8:0)}:function(e){return 0|(e.metaKey?1:0)|(e.altKey?2:0)|(e.shiftKey?4:0)|(e.ctrlKey?8:0)};function c(e,t,i){var n=l(t);if(!u.isMac&&s){if(t.getModifierState&&(t.getModifierState("OS")||t.getModifierState("Win"))&&(n|=8),s.altGr){if(3==(3&n))return;s.altGr=0}if(18===i||17===i){var r="location"in t?t.location:t.keyLocation;if(17===i&&1===r)1==s[i]&&(a=t.timeStamp);else if(18===i&&3===n&&2===r){t.timeStamp-a<50&&(s.altGr=!0)}}}if((i in o.MODIFIER_KEYS&&(i=-1),!n&&13===i)&&(3===(r="location"in t?t.location:t.keyLocation)&&(e(t,n,-i),t.defaultPrevented)))return;if(u.isChromeOS&&8&n){if(e(t,n,i),t.defaultPrevented)return;n&=-9}return!!(n||i in o.FUNCTION_KEYS||i in o.PRINTABLE_KEYS)&&e(t,n,i)}function h(){s=Object.create(null)}if(d.getModifierString=function(e){return o.KEY_MODS[l(e)]},d.addCommandKeyListener=function(e,i){var t=d.addListener;if(u.isOldGecko||u.isOpera&&!("KeyboardEvent"in window)){var n=null;t(e,"keydown",function(e){n=e.keyCode}),t(e,"keypress",function(e){return c(i,e,n)})}else{var r=null;t(e,"keydown",function(e){s[e.keyCode]=(s[e.keyCode]||0)+1;var t=c(i,e,e.keyCode);return r=e.defaultPrevented,t}),t(e,"keypress",function(e){r&&(e.ctrlKey||e.altKey||e.shiftKey||e.metaKey)&&(d.stopEvent(e),r=null)}),t(e,"keyup",function(e){s[e.keyCode]=null}),s||(h(),t(window,"focus",h))}},"object"==typeof window&&window.postMessage&&!u.isOldIE){var g=1;d.nextTick=function(t,i){i=i||window;var n="zero-timeout-message-"+g++,r=function(e){e.data==n&&(d.stopPropagation(e),d.removeListener(i,"message",r),t())};d.addListener(i,"message",r),i.postMessage(n,"*")}}d.$idleBlocked=!1,d.onIdle=function(t,e){return setTimeout(function e(){d.$idleBlocked?setTimeout(e,100):t()},e)},d.$idleBlockId=null,d.blockIdle=function(e){d.$idleBlockId&&clearTimeout(d.$idleBlockId),d.$idleBlocked=!0,d.$idleBlockId=setTimeout(function(){d.$idleBlocked=!1},e||100)},d.nextFrame="object"==typeof window&&(window.requestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||window.msRequestAnimationFrame||window.oRequestAnimationFrame),d.nextFrame?d.nextFrame=d.nextFrame.bind(window):d.nextFrame=function(e){setTimeout(e,17)}}),ace.define("ace/range",["require","exports","module"],function(e,t,i){"use strict";function o(e,t,i,n){this.start={row:e,column:t},this.end={row:i,column:n}}(function(){this.isEqual=function(e){return this.start.row===e.start.row&&this.end.row===e.end.row&&this.start.column===e.start.column&&this.end.column===e.end.column},this.toString=function(){return"Range: ["+this.start.row+"/"+this.start.column+"] -> ["+this.end.row+"/"+this.end.column+"]"},this.contains=function(e,t){return 0==this.compare(e,t)},this.compareRange=function(e){var t,i=e.end,n=e.start;return 1==(t=this.compare(i.row,i.column))?1==(t=this.compare(n.row,n.column))?2:0==t?1:0:-1==t?-2:-1==(t=this.compare(n.row,n.column))?-1:1==t?42:0},this.comparePoint=function(e){return this.compare(e.row,e.column)},this.containsRange=function(e){return 0==this.comparePoint(e.start)&&0==this.comparePoint(e.end)},this.intersects=function(e){var t=this.compareRange(e);return-1==t||0==t||1==t},this.isEnd=function(e,t){return this.end.row==e&&this.end.column==t},this.isStart=function(e,t){return this.start.row==e&&this.start.column==t},this.setStart=function(e,t){"object"==typeof e?(this.start.column=e.column,this.start.row=e.row):(this.start.row=e,this.start.column=t)},this.setEnd=function(e,t){"object"==typeof e?(this.end.column=e.column,this.end.row=e.row):(this.end.row=e,this.end.column=t)},this.inside=function(e,t){return 0==this.compare(e,t)&&(!this.isEnd(e,t)&&!this.isStart(e,t))},this.insideStart=function(e,t){return 0==this.compare(e,t)&&!this.isEnd(e,t)},this.insideEnd=function(e,t){return 0==this.compare(e,t)&&!this.isStart(e,t)},this.compare=function(e,t){return this.isMultiLine()||e!==this.start.row?e<this.start.row?-1:e>this.end.row?1:this.start.row===e?t>=this.start.column?0:-1:this.end.row===e?t<=this.end.column?0:1:0:t<this.start.column?-1:t>this.end.column?1:0},this.compareStart=function(e,t){return this.start.row==e&&this.start.column==t?-1:this.compare(e,t)},this.compareEnd=function(e,t){return this.end.row==e&&this.end.column==t?1:this.compare(e,t)},this.compareInside=function(e,t){return this.end.row==e&&this.end.column==t?1:this.start.row==e&&this.start.column==t?-1:this.compare(e,t)},this.clipRows=function(e,t){if(this.end.row>t)var i={row:t+1,column:0};else if(this.end.row<e)i={row:e,column:0};if(this.start.row>t)var n={row:t+1,column:0};else if(this.start.row<e)n={row:e,column:0};return o.fromPoints(n||this.start,i||this.end)},this.extend=function(e,t){var i=this.compare(e,t);if(0==i)return this;if(-1==i)var n={row:e,column:t};else var r={row:e,column:t};return o.fromPoints(n||this.start,r||this.end)},this.isEmpty=function(){return this.start.row===this.end.row&&this.start.column===this.end.column},this.isMultiLine=function(){return this.start.row!==this.end.row},this.clone=function(){return o.fromPoints(this.start,this.end)},this.collapseRows=function(){return 0==this.end.column?new o(this.start.row,0,Math.max(this.start.row,this.end.row-1),0):new o(this.start.row,0,this.end.row,0)},this.toScreenRange=function(e){var t=e.documentToScreenPosition(this.start),i=e.documentToScreenPosition(this.end);return new o(t.row,t.column,i.row,i.column)},this.moveBy=function(e,t){this.start.row+=e,this.start.column+=t,this.end.row+=e,this.end.column+=t}}).call(o.prototype),o.fromPoints=function(e,t){return new o(e.row,e.column,t.row,t.column)},o.comparePoints=function(e,t){return e.row-t.row||e.column-t.column},o.comparePoints=function(e,t){return e.row-t.row||e.column-t.column},t.Range=o}),ace.define("ace/lib/lang",["require","exports","module"],function(e,t,i){"use strict";t.last=function(e){return e[e.length-1]},t.stringReverse=function(e){return e.split("").reverse().join("")},t.stringRepeat=function(e,t){for(var i="";0<t;)1&t&&(i+=e),(t>>=1)&&(e+=e);return i};var n=/^\s\s*/,r=/\s\s*$/;t.stringTrimLeft=function(e){return e.replace(n,"")},t.stringTrimRight=function(e){return e.replace(r,"")},t.copyObject=function(e){var t={};for(var i in e)t[i]=e[i];return t},t.copyArray=function(e){for(var t=[],i=0,n=e.length;i<n;i++)e[i]&&"object"==typeof e[i]?t[i]=this.copyObject(e[i]):t[i]=e[i];return t},t.deepCopy=function e(t){if("object"!=typeof t||!t)return t;var i;if(Array.isArray(t)){i=[];for(var n=0;n<t.length;n++)i[n]=e(t[n]);return i}if("[object Object]"!==Object.prototype.toString.call(t))return t;for(var n in i={},t)i[n]=e(t[n]);return i},t.arrayToMap=function(e){for(var t={},i=0;i<e.length;i++)t[e[i]]=1;return t},t.createMap=function(e){var t=Object.create(null);for(var i in e)t[i]=e[i];return t},t.arrayRemove=function(e,t){for(var i=0;i<=e.length;i++)t===e[i]&&e.splice(i,1)},t.escapeRegExp=function(e){return e.replace(/([.*+?^${}()|[\]\/\\])/g,"\\$1")},t.escapeHTML=function(e){return(""+e).replace(/&/g,"&#38;").replace(/"/g,"&#34;").replace(/'/g,"&#39;").replace(/</g,"&#60;")},t.getMatchOffsets=function(e,t){var i=[];return e.replace(t,function(e){i.push({offset:arguments[arguments.length-2],length:e.length})}),i},t.deferredCall=function(e){function t(){i=null,e()}var i=null,n=function(e){return n.cancel(),i=setTimeout(t,e||0),n};return(n.schedule=n).call=function(){return this.cancel(),e(),n},n.cancel=function(){return clearTimeout(i),i=null,n},n.isPending=function(){return i},n},t.delayedCall=function(e,t){function i(){r=null,e()}function n(e){null==r&&(r=setTimeout(i,e||t))}var r=null;return n.delay=function(e){r&&clearTimeout(r),r=setTimeout(i,e||t)},(n.schedule=n).call=function(){this.cancel(),e()},n.cancel=function(){r&&clearTimeout(r),r=null},n.isPending=function(){return r},n}}),ace.define("ace/clipboard",["require","exports","module"],function(e,t,i){"use strict";var n;i.exports={lineMode:!1,pasteCancelled:function(){return!!(n&&n>Date.now()-50)||(n=!1)},cancel:function(){n=Date.now()}}}),ace.define("ace/keyboard/textinput",["require","exports","module","ace/lib/event","ace/lib/useragent","ace/lib/dom","ace/lib/lang","ace/clipboard","ace/lib/keys"],function(e,t,i){"use strict";var T=e("../lib/event"),W=e("../lib/useragent"),_=e("../lib/dom"),H=e("../lib/lang"),L=e("../clipboard"),$=W.isChrome<18,V=W.isIE,N=63<W.isChrome,O=e("../lib/keys"),F=O.KEY_MODS,P=W.isIOS,K=P?/\s/:/\n/;t.TextInput=function(e,d){var u=_.createElement("textarea");u.className="ace_text-input",u.setAttribute("wrap","off"),u.setAttribute("autocorrect","off"),u.setAttribute("autocapitalize","off"),u.setAttribute("spellcheck",!1),u.style.opacity="0",e.insertBefore(u,e.firstChild);var c=!1,g=!1,h=!1,p=!1,l="";W.isMobile||(u.style.fontSize="1px");var m=!1,t=!1,f="",C=0,I=0,A=0;try{var v=document.activeElement===u}catch(e){}T.addListener(u,"blur",function(e){t||(d.onBlur(e),v=!1)}),T.addListener(u,"focus",function(e){if(!t){if(v=!0,W.isEdge)try{if(!document.hasFocus())return}catch(e){}d.onFocus(e),W.isEdge?setTimeout(b):b()}}),this.$focusScroll=!1,this.focus=function(){if(l||N||"browser"==this.$focusScroll)return u.focus({preventScroll:!0});var e=u.style.top;u.style.position="fixed",u.style.top="0px";try{var t=0!=u.getBoundingClientRect().top}catch(e){return}var i=[];if(t)for(var n=u.parentElement;n&&1==n.nodeType;)i.push(n),n.setAttribute("ace_nocontext",!0),n=!n.parentElement&&n.getRootNode?n.getRootNode().host:n.parentElement;u.focus({preventScroll:!0}),t&&i.forEach(function(e){e.removeAttribute("ace_nocontext")}),setTimeout(function(){u.style.position="","0px"==u.style.top&&(u.style.top=e)},0)},this.blur=function(){u.blur()},this.isFocused=function(){return v},d.on("beforeEndOperation",function(){d.curOp&&"insertstring"==d.curOp.command.name||(h&&(f=u.value="",k()),b())});var b=P?function(e){if(v&&(!c||e)&&!p){var t="\n ab"+(e=e||"")+"cde fg\n";t!=u.value&&(u.value=f=t);var i=4+(e.length||(d.selection.isEmpty()?0:1));4==C&&I==i||u.setSelectionRange(4,i),C=4,I=i}}:function(){if(!h&&!p&&(v||w)){h=!0;var e=d.selection,t=e.getRange(),i=e.cursor.row,n=t.start.column,r=t.end.column,o=d.session.getLine(i);if(t.start.row!=i){var s=d.session.getLine(i-1);n=t.start.row<i-1?0:n,r+=s.length+1,o=s+"\n"+o}else if(t.end.row!=i){var a=d.session.getLine(i+1);r=t.end.row>i+1?a.length:r,r+=o.length+1,o=o+"\n"+a}400<o.length&&(n<400&&r<400?o=o.slice(0,400):(o="\n",n=0,r=1));var l=o+"\n\n";if(l!=f&&(u.value=f=l,C=I=l.length),w&&(C=u.selectionStart,I=u.selectionEnd),I!=r||C!=n||u.selectionEnd!=I)try{u.setSelectionRange(n,r),C=n,I=r}catch(e){}h=!1}};v&&d.onFocus();var i=null;this.setInputHandler=function(e){i=e};function n(e,t){if(w=w&&!1,g)return b(),e&&d.onPaste(e),g=!1,"";for(var i=u.selectionStart,n=u.selectionEnd,r=C,o=f.length-I,s=e,a=e.length-i,l=e.length-n,c=0;0<r&&f[c]==e[c];)c++,r--;for(s=s.slice(c),c=1;0<o&&f.length-c>C-1&&f[f.length-c]==e[e.length-c];)c++,o--;a-=c-1,l-=c-1;var h=s.length-c+1;return h<0&&(r=-h,h=0),s=s.slice(0,h),t||s||a||r||o||l?(p=!0,s&&!r&&!o&&!a&&!l||m?d.onTextInput(s):d.onTextInput(s,{extendLeft:r,extendRight:o,restoreStart:a,restoreEnd:l}),p=!1,f=e,C=i,I=n,A=l,s):""}function r(e){if(h)return x();if(e&&e.inputType){if("historyUndo"==e.inputType)return d.execCommand("undo");if("historyRedo"==e.inputType)return d.execCommand("redo")}var t=u.value,i=n(t,!0);(500<t.length||K.test(i))&&b()}function o(e,t){var i=d.getCopyText();if(!i)return T.preventDefault(e);S(e,i)?(P&&(b(i),c=i,setTimeout(function(){c=!1},10)),t?d.onCut():d.onCopy(),T.preventDefault(e)):(c=!0,u.value=i,u.select(),setTimeout(function(){c=!1,b(),t?d.onCut():d.onCopy()}))}function s(e){o(e,!0)}function a(e){o(e,!1)}function y(e){var t=S(e);L.pasteCancelled()||("string"==typeof t?(t&&d.onPaste(t,e),W.isIE&&setTimeout(b),T.preventDefault(e)):(u.value="",g=!0))}var w=!(this.getInputHandler=function(){return i}),S=function(e,t,i){var n=e.clipboardData||window.clipboardData;if(n&&!$){var r=V||i?"Text":"text/plain";try{return t?!1!==n.setData(r,t):n.getData(r)}catch(e){if(!i)return S(e,t,!0)}}};T.addCommandKeyListener(u,d.onCommandKey.bind(d)),T.addListener(u,"select",function(e){h||(c?c=!1:function(e){return 0===e.selectionStart&&e.selectionEnd>=f.length&&e.value===f&&f&&e.selectionEnd!==I}(u)&&(d.selectAll(),b()))}),T.addListener(u,"input",r),T.addListener(u,"cut",s),T.addListener(u,"copy",a),T.addListener(u,"paste",y),"oncut"in u&&"oncopy"in u&&"onpaste"in u||T.addListener(e,"keydown",function(e){if((!W.isMac||e.metaKey)&&e.ctrlKey)switch(e.keyCode){case 67:a(e);break;case 86:y(e);break;case 88:s(e)}});var x=function(){if(h&&d.onCompositionUpdate&&!d.$readOnly){if(m)return R();if(h.useTextareaForIME)d.onCompositionUpdate(u.value);else{var e=u.value;n(e),h.markerRange&&(h.context&&(h.markerRange.start.column=h.selectionStart=h.context.compositionStartOffset),h.markerRange.end.column=h.markerRange.start.column+I-h.selectionStart+A)}}},k=function(e){d.onCompositionEnd&&!d.$readOnly&&(h=!1,d.onCompositionEnd(),d.off("mousedown",R),e&&r())};function R(){t=!0,u.blur(),u.focus(),t=!1}var E,B=H.delayedCall(x,50).schedule.bind(null,null);function G(){clearTimeout(E),E=setTimeout(function(){l&&(u.style.cssText=l,l=""),d.renderer.$isMousePressed=!1,d.renderer.$keepTextAreaAtCursor&&d.renderer.$moveTextAreaToCursor()},0)}T.addListener(u,"compositionstart",function(e){if(!h&&d.onCompositionStart&&!d.$readOnly&&(h={},!m)){setTimeout(x,0),d.on("mousedown",R);var t=d.getSelectionRange();t.end.row=t.start.row,t.end.column=t.start.column,h.markerRange=t,h.selectionStart=C,d.onCompositionStart(h),h.useTextareaForIME?(u.value="",f="",I=C=0):(u.msGetInputContext&&(h.context=u.msGetInputContext()),u.getInputContext&&(h.context=u.getInputContext()))}}),T.addListener(u,"compositionupdate",x),T.addListener(u,"keyup",function(e){27==e.keyCode&&u.value.length<u.selectionStart&&(h||(f=u.value),C=I=-1,b()),B()}),T.addListener(u,"keydown",B),T.addListener(u,"compositionend",k),this.getElement=function(){return u},this.setCommandMode=function(e){m=e,u.readOnly=!1},this.setReadOnly=function(e){m||(u.readOnly=e)},this.setCopyWithEmptySelection=function(e){},this.onContextMenu=function(e){w=!0,b(),d._emit("nativecontextmenu",{target:d,domEvent:e}),this.moveToMouse(e,!0)},this.moveToMouse=function(e,t){l=l||u.style.cssText,u.style.cssText=(t?"z-index:100000;":"")+(W.isIE?"opacity:0.1;":"")+"text-indent: -"+(C+I)*d.renderer.characterWidth*.5+"px;";function i(e){_.translate(u,e.clientX-s-2,Math.min(e.clientY-o-2,a))}var n=d.container.getBoundingClientRect(),r=_.computedStyle(d.container),o=n.top+(parseInt(r.borderTopWidth)||0),s=n.left+(parseInt(n.borderLeftWidth)||0),a=n.bottom-o-u.clientHeight-2;i(e),"mousedown"==e.type&&(d.renderer.$isMousePressed=!0,clearTimeout(E),W.isWin&&T.capture(d.container,i,G))},this.onContextMenuClose=G;function Z(e){d.textInput.onContextMenu(e),G()}T.addListener(u,"mouseup",Z),T.addListener(u,"mousedown",function(e){e.preventDefault(),G()}),T.addListener(d.renderer.scroller,"contextmenu",Z),T.addListener(u,"contextmenu",Z),P&&function(e,s,a){var t=null,l=!1;a.addEventListener("keydown",function(e){t&&clearTimeout(t),l=!0},!0),a.addEventListener("keyup",function(e){t=setTimeout(function(){l=!1},100)},!0);function i(e){if(document.activeElement===a&&!(l||h||s.$mouseHandler.isMousePressed||c)){var t=a.selectionStart,i=a.selectionEnd,n=null,r=0;if(0==t?n=O.up:1==t?n=O.home:I<i&&"\n"==f[i]?n=O.end:t<C&&" "==f[t-1]?(n=O.left,r=F.option):t<C||t==C&&I!=C&&t==i?n=O.left:I<i&&2<f.slice(0,i).split("\n").length?n=O.down:I<i&&" "==f[i-1]?(n=O.right,r=F.option):(I<i||i==I&&I!=C&&t==i)&&(n=O.right),t!==i&&(r|=F.shift),n){if(!s.onCommandKey({},r,n)&&s.commands){n=O.keyCodeToString(n);var o=s.commands.findKeyCommand(r,n);o&&s.execCommand(o)}C=t,I=i,b("")}}}document.addEventListener("selectionchange",i),s.on("destroy",function(){document.removeEventListener("selectionchange",i)})}(0,d,u)}}),ace.define("ace/mouse/default_handlers",["require","exports","module","ace/lib/useragent"],function(e,t,i){"use strict";var o=e("../lib/useragent");function n(t){t.$clickSelection=null;var e=t.editor;e.setDefaultHandler("mousedown",this.onMouseDown.bind(t)),e.setDefaultHandler("dblclick",this.onDoubleClick.bind(t)),e.setDefaultHandler("tripleclick",this.onTripleClick.bind(t)),e.setDefaultHandler("quadclick",this.onQuadClick.bind(t)),e.setDefaultHandler("mousewheel",this.onMouseWheel.bind(t));["select","startSelect","selectEnd","selectAllEnd","selectByWordsEnd","selectByLinesEnd","dragWait","dragWaitEnd","focusWait"].forEach(function(e){t[e]=this[e]},this),t.selectByLines=this.extendSelectionBy.bind(t,"getLineRange"),t.selectByWords=this.extendSelectionBy.bind(t,"getWordRange")}function l(e,t){if(e.start.row==e.end.row)var i=2*t.column-e.start.column-e.end.column;else if(e.start.row!=e.end.row-1||e.start.column||e.end.column)i=2*t.row-e.start.row-e.end.row;else var i=t.column-4;return i<0?{cursor:e.start,anchor:e.end}:{cursor:e.end,anchor:e.start}}(function(){this.onMouseDown=function(e){var t=e.inSelection(),i=e.getDocumentPosition();this.mousedownEvent=e;var n=this.editor,r=e.getButton();return 0!==r?(!n.getSelectionRange().isEmpty()&&1!=r||n.selection.moveToPosition(i),void(2==r&&(n.textInput.onContextMenu(e.domEvent),o.isMozilla||e.preventDefault()))):(this.mousedownEvent.time=Date.now(),!t||n.isFocused()||(n.focus(),!this.$focusTimeout||this.$clickSelection||n.inMultiSelectMode)?(this.captureMouse(e),this.startSelect(i,1<e.domEvent._clicks),e.preventDefault()):(this.setState("focusWait"),void this.captureMouse(e)))},this.startSelect=function(e,t){e=e||this.editor.renderer.screenToTextCoordinates(this.x,this.y);var i=this.editor;this.mousedownEvent&&(this.mousedownEvent.getShiftKey()?i.selection.selectToPosition(e):t||i.selection.moveToPosition(e),t||this.select(),i.renderer.scroller.setCapture&&i.renderer.scroller.setCapture(),i.setStyle("ace_selecting"),this.setState("select"))},this.select=function(){var e,t=this.editor,i=t.renderer.screenToTextCoordinates(this.x,this.y);if(this.$clickSelection){var n=this.$clickSelection.comparePoint(i);if(-1==n)e=this.$clickSelection.end;else if(1==n)e=this.$clickSelection.start;else{var r=l(this.$clickSelection,i);i=r.cursor,e=r.anchor}t.selection.setSelectionAnchor(e.row,e.column)}t.selection.selectToPosition(i),t.renderer.scrollCursorIntoView()},this.extendSelectionBy=function(e){var t,i=this.editor,n=i.renderer.screenToTextCoordinates(this.x,this.y),r=i.selection[e](n.row,n.column);if(this.$clickSelection){var o=this.$clickSelection.comparePoint(r.start),s=this.$clickSelection.comparePoint(r.end);if(-1==o&&s<=0)t=this.$clickSelection.end,r.end.row==n.row&&r.end.column==n.column||(n=r.start);else if(1==s&&0<=o)t=this.$clickSelection.start,r.start.row==n.row&&r.start.column==n.column||(n=r.end);else if(-1==o&&1==s)n=r.end,t=r.start;else{var a=l(this.$clickSelection,n);n=a.cursor,t=a.anchor}i.selection.setSelectionAnchor(t.row,t.column)}i.selection.selectToPosition(n),i.renderer.scrollCursorIntoView()},this.selectEnd=this.selectAllEnd=this.selectByWordsEnd=this.selectByLinesEnd=function(){this.$clickSelection=null,this.editor.unsetStyle("ace_selecting"),this.editor.renderer.scroller.releaseCapture&&this.editor.renderer.scroller.releaseCapture()},this.focusWait=function(){var e=function(e,t,i,n){return Math.sqrt(Math.pow(i-e,2)+Math.pow(n-t,2))}(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y),t=Date.now();(0<e||t-this.mousedownEvent.time>this.$focusTimeout)&&this.startSelect(this.mousedownEvent.getDocumentPosition())},this.onDoubleClick=function(e){var t=e.getDocumentPosition(),i=this.editor,n=i.session.getBracketRange(t);n?(n.isEmpty()&&(n.start.column--,n.end.column++),this.setState("select")):(n=i.selection.getWordRange(t.row,t.column),this.setState("selectByWords")),this.$clickSelection=n,this.select()},this.onTripleClick=function(e){var t=e.getDocumentPosition(),i=this.editor;this.setState("selectByLines");var n=i.getSelectionRange();n.isMultiLine()&&n.contains(t.row,t.column)?(this.$clickSelection=i.selection.getLineRange(n.start.row),this.$clickSelection.end=i.selection.getLineRange(n.end.row).end):this.$clickSelection=i.selection.getLineRange(t.row),this.select()},this.onQuadClick=function(e){var t=this.editor;t.selectAll(),this.$clickSelection=t.getSelectionRange(),this.setState("selectAll")},this.onMouseWheel=function(e){if(!e.getAccelKey()){e.getShiftKey()&&e.wheelY&&!e.wheelX&&(e.wheelX=e.wheelY,e.wheelY=0);var t=this.editor;this.$lastScroll||(this.$lastScroll={t:0,vx:0,vy:0,allowed:0});var i=this.$lastScroll,n=e.domEvent.timeStamp,r=n-i.t,o=r?e.wheelX/r:i.vx,s=r?e.wheelY/r:i.vy;r<550&&(o=(o+i.vx)/2,s=(s+i.vy)/2);var a=Math.abs(o/s),l=!1;if(1<=a&&t.renderer.isScrollableBy(e.wheelX*e.speed,0)&&(l=!0),a<=1&&t.renderer.isScrollableBy(0,e.wheelY*e.speed)&&(l=!0),l)i.allowed=n;else if(n-i.allowed<550){var c=Math.abs(o)<=1.5*Math.abs(i.vx)&&Math.abs(s)<=1.5*Math.abs(i.vy);i.allowed=c?(l=!0,n):0}return i.t=n,i.vx=o,i.vy=s,l?(t.renderer.scrollBy(e.wheelX*e.speed,e.wheelY*e.speed),e.stop()):void 0}}}).call(n.prototype),t.DefaultHandlers=n}),ace.define("ace/tooltip",["require","exports","module","ace/lib/oop","ace/lib/dom"],function(e,t,i){"use strict";e("./lib/oop");var n=e("./lib/dom");function r(e){this.isOpen=!1,this.$element=null,this.$parentNode=e}(function(){this.$init=function(){return this.$element=n.createElement("div"),this.$element.className="ace_tooltip",this.$element.style.display="none",this.$parentNode.appendChild(this.$element),this.$element},this.getElement=function(){return this.$element||this.$init()},this.setText=function(e){this.getElement().textContent=e},this.setHtml=function(e){this.getElement().innerHTML=e},this.setPosition=function(e,t){this.getElement().style.left=e+"px",this.getElement().style.top=t+"px"},this.setClassName=function(e){n.addCssClass(this.getElement(),e)},this.show=function(e,t,i){null!=e&&this.setText(e),null!=t&&null!=i&&this.setPosition(t,i),this.isOpen||(this.getElement().style.display="block",this.isOpen=!0)},this.hide=function(){this.isOpen&&(this.getElement().style.display="none",this.isOpen=!1)},this.getHeight=function(){return this.getElement().offsetHeight},this.getWidth=function(){return this.getElement().offsetWidth},this.destroy=function(){this.isOpen=!1,this.$element&&this.$element.parentNode&&this.$element.parentNode.removeChild(this.$element)}}).call(r.prototype),t.Tooltip=r}),ace.define("ace/mouse/default_gutter_handler",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event","ace/tooltip"],function(e,t,i){"use strict";var n=e("../lib/dom"),r=e("../lib/oop"),o=e("../lib/event"),s=e("../tooltip").Tooltip;function p(e){s.call(this,e)}r.inherits(p,s),function(){this.setPosition=function(e,t){var i=window.innerWidth||document.documentElement.clientWidth,n=window.innerHeight||document.documentElement.clientHeight,r=this.getWidth(),o=this.getHeight();i<(e+=15)+r&&(e-=e+r-i),n<(t+=15)+o&&(t-=20+o),s.prototype.setPosition.call(this,e,t)}}.call(p.prototype),t.GutterHandler=function(s){var i,a,l,c=s.editor,h=c.renderer.$gutterLayer,d=new p(c.container);function u(){i=i&&clearTimeout(i),l&&(d.hide(),l=null,c._signal("hideGutterTooltip",d),c.removeEventListener("mousewheel",u))}function g(e){d.setPosition(e.x,e.y)}s.editor.setDefaultHandler("guttermousedown",function(e){if(c.isFocused()&&0==e.getButton()&&"foldWidgets"!=h.getRegion(e)){var t=e.getDocumentPosition().row,i=c.session.selection;if(e.getShiftKey())i.selectTo(t,0);else{if(2==e.domEvent.detail)return c.selectAll(),e.preventDefault();s.$clickSelection=c.selection.getLineRange(t)}return s.setState("selectByLines"),s.captureMouse(e),e.preventDefault()}}),s.editor.setDefaultHandler("guttermousemove",function(e){var t=e.domEvent.target||e.domEvent.srcElement;if(n.hasCssClass(t,"ace_fold-widget"))return u();l&&s.$tooltipFollowsMouse&&g(e),a=e,i=i||setTimeout(function(){i=null,a&&!s.isMousePressed?function(){var e=a.getDocumentPosition().row,t=h.$annotations[e];if(!t)return u();if(e==c.session.getLength()){var i=c.renderer.pixelToScreenCoordinates(0,a.y).row,n=a.$pos;if(i>c.session.documentToScreenRow(n.row,n.column))return u()}if(l!=t)if(l=t.text.join("<br/>"),d.setHtml(l),d.show(),c._signal("showGutterTooltip",d),c.on("mousewheel",u),s.$tooltipFollowsMouse)g(a);else{var r=a.domEvent.target.getBoundingClientRect(),o=d.getElement().style;o.left=r.right+"px",o.top=r.bottom+"px"}}():u()},50)}),o.addListener(c.renderer.$gutter,"mouseout",function(e){a=null,l&&!i&&(i=setTimeout(function(){i=null,u()},50))}),c.on("changeSession",u)}}),ace.define("ace/mouse/mouse_event",["require","exports","module","ace/lib/event","ace/lib/useragent"],function(e,t,i){"use strict";var n=e("../lib/event"),r=e("../lib/useragent"),o=t.MouseEvent=function(e,t){this.domEvent=e,this.editor=t,this.x=this.clientX=e.clientX,this.y=this.clientY=e.clientY,this.$pos=null,this.$inSelection=null,this.propagationStopped=!1,this.defaultPrevented=!1};(function(){this.stopPropagation=function(){n.stopPropagation(this.domEvent),this.propagationStopped=!0},this.preventDefault=function(){n.preventDefault(this.domEvent),this.defaultPrevented=!0},this.stop=function(){this.stopPropagation(),this.preventDefault()},this.getDocumentPosition=function(){return this.$pos||(this.$pos=this.editor.renderer.screenToTextCoordinates(this.clientX,this.clientY)),this.$pos},this.inSelection=function(){if(null!==this.$inSelection)return this.$inSelection;var e=this.editor.getSelectionRange();if(e.isEmpty())this.$inSelection=!1;else{var t=this.getDocumentPosition();this.$inSelection=e.contains(t.row,t.column)}return this.$inSelection},this.getButton=function(){return n.getButton(this.domEvent)},this.getShiftKey=function(){return this.domEvent.shiftKey},this.getAccelKey=r.isMac?function(){return this.domEvent.metaKey}:function(){return this.domEvent.ctrlKey}}).call(o.prototype)}),ace.define("ace/mouse/dragdrop_handler",["require","exports","module","ace/lib/dom","ace/lib/event","ace/lib/useragent"],function(e,t,i){"use strict";var w=e("../lib/dom"),S=e("../lib/event"),x=e("../lib/useragent");function n(t){var g=t.editor,n=w.createElement("img");n.src="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==",x.isOpera&&(n.style.cssText="width:1px;height:1px;position:fixed;top:0;left:0;z-index:2147483647;opacity:0;");["dragWait","dragWaitEnd","startDrag","dragReadyEnd","onMouseDrag"].forEach(function(e){t[e]=this[e]},this),g.addEventListener("mousedown",this.onMouseDown.bind(t));var i,p,m,e,r,o,s,a,f,l,c,h=g.container,d=0;function u(){var e=o;(function(e,t){var i=Date.now(),n=!t||e.row!=t.row,r=!t||e.column!=t.column;!l||n||r?(g.moveCursorToPosition(e),l=i,c={x:p,y:m}):5<k(c.x,c.y,p,m)?l=null:200<=i-l&&(g.renderer.scrollCursorIntoView(),l=null)})(o=g.renderer.screenToTextCoordinates(p,m),e),function(e,t){var i=Date.now(),n=g.renderer.layerConfig.lineHeight,r=g.renderer.layerConfig.characterWidth,o=g.renderer.scroller.getBoundingClientRect(),s={x:{left:p-o.left,right:o.right-p},y:{top:m-o.top,bottom:o.bottom-m}},a=Math.min(s.x.left,s.x.right),l=Math.min(s.y.top,s.y.bottom),c={row:e.row,column:e.column};a/r<=2&&(c.column+=s.x.left<s.x.right?-3:2),l/n<=1&&(c.row+=s.y.top<s.y.bottom?-1:1);var h=e.row!=c.row,d=e.column!=c.column,u=!t||e.row!=t.row;h||d&&!u?f?200<=i-f&&g.renderer.scrollCursorIntoView(c):f=i:f=null}(o,e)}function C(){r=g.selection.toOrientedRange(),i=g.session.addMarker(r,"ace_selection",g.getSelectionStyle()),g.clearSelection(),g.isFocused()&&g.renderer.$cursorLayer.setBlinking(!1),clearInterval(e),u(),e=setInterval(u,20),d=0,S.addListener(document,"mousemove",v)}function I(){clearInterval(e),g.session.removeMarker(i),i=null,g.selection.fromOrientedRange(r),g.isFocused()&&!a&&g.$resetCursorStyle(),d=0,l=f=o=r=null,S.removeListener(document,"mousemove",v)}this.onDragStart=function(e){if(this.cancelDrag||!h.draggable){var t=this;return setTimeout(function(){t.startSelect(),t.captureMouse(e)},0),e.preventDefault()}r=g.getSelectionRange();var i=e.dataTransfer;i.effectAllowed=g.getReadOnly()?"copy":"copyMove",x.isOpera&&(g.container.appendChild(n),n.scrollTop=0),i.setDragImage&&i.setDragImage(n,0,0),x.isOpera&&g.container.removeChild(n),i.clearData(),i.setData("Text",g.session.getTextRange()),a=!0,this.setState("drag")},this.onDragEnd=function(e){if(h.draggable=!1,a=!1,this.setState(null),!g.getReadOnly()){var t=e.dataTransfer.dropEffect;s||"move"!=t||g.session.remove(g.getSelectionRange()),g.$resetCursorStyle()}this.editor.unsetStyle("ace_dragging"),this.editor.renderer.setCursorStyle("")},this.onDragEnter=function(e){if(!g.getReadOnly()&&b(e.dataTransfer))return p=e.clientX,m=e.clientY,i||C(),d++,e.dataTransfer.dropEffect=s=y(e),S.preventDefault(e)},this.onDragOver=function(e){if(!g.getReadOnly()&&b(e.dataTransfer))return p=e.clientX,m=e.clientY,i||(C(),d++),null!==A&&(A=null),e.dataTransfer.dropEffect=s=y(e),S.preventDefault(e)},this.onDragLeave=function(e){if(--d<=0&&i)return I(),s=null,S.preventDefault(e)},this.onDrop=function(e){if(o){var t=e.dataTransfer;if(a)switch(s){case"move":r=r.contains(o.row,o.column)?{start:o,end:o}:g.moveText(r,o);break;case"copy":r=g.moveText(r,o,!0)}else{var i=t.getData("Text");r={start:o,end:g.session.insert(o,i)},g.focus(),s=null}return I(),S.preventDefault(e)}},S.addListener(h,"dragstart",this.onDragStart.bind(t)),S.addListener(h,"dragend",this.onDragEnd.bind(t)),S.addListener(h,"dragenter",this.onDragEnter.bind(t)),S.addListener(h,"dragover",this.onDragOver.bind(t)),S.addListener(h,"dragleave",this.onDragLeave.bind(t)),S.addListener(h,"drop",this.onDrop.bind(t));var A=null;function v(){null==A&&(A=setTimeout(function(){null!=A&&i&&I()},20))}function b(e){var t=e.types;return!t||Array.prototype.some.call(t,function(e){return"text/plain"==e||"Text"==e})}function y(e){var t=["copy","copymove","all","uninitialized"],i=x.isMac?e.altKey:e.ctrlKey,n="uninitialized";try{n=e.dataTransfer.effectAllowed.toLowerCase()}catch(e){}var r="none";return i&&0<=t.indexOf(n)?r="copy":0<=["move","copymove","linkmove","all","uninitialized"].indexOf(n)?r="move":0<=t.indexOf(n)&&(r="copy"),r}}function k(e,t,i,n){return Math.sqrt(Math.pow(i-e,2)+Math.pow(n-t,2))}(function(){this.dragWait=function(){Date.now()-this.mousedownEvent.time>this.editor.getDragDelay()&&this.startDrag()},this.dragWaitEnd=function(){this.editor.container.draggable=!1,this.startSelect(this.mousedownEvent.getDocumentPosition()),this.selectEnd()},this.dragReadyEnd=function(e){this.editor.$resetCursorStyle(),this.editor.unsetStyle("ace_dragging"),this.editor.renderer.setCursorStyle(""),this.dragWaitEnd()},this.startDrag=function(){this.cancelDrag=!1;var e=this.editor;e.container.draggable=!0,e.renderer.$cursorLayer.setBlinking(!1),e.setStyle("ace_dragging");var t=x.isWin?"default":"move";e.renderer.setCursorStyle(t),this.setState("dragReady")},this.onMouseDrag=function(e){var t=this.editor.container;x.isIE&&"dragReady"==this.state&&3<k(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y)&&t.dragDrop();"dragWait"===this.state&&0<k(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y)&&(t.draggable=!1,this.startSelect(this.mousedownEvent.getDocumentPosition()))},this.onMouseDown=function(e){if(this.$dragEnabled){this.mousedownEvent=e;var t=this.editor,i=e.inSelection(),n=e.getButton();if(1===(e.domEvent.detail||1)&&0===n&&i){if(e.editor.inMultiSelectMode&&(e.getAccelKey()||e.getShiftKey()))return;this.mousedownEvent.time=Date.now();var r=e.domEvent.target||e.domEvent.srcElement;if("unselectable"in r&&(r.unselectable="on"),t.getDragDelay()){if(x.isWebKit)this.cancelDrag=!0,t.container.draggable=!0;this.setState("dragWait")}else this.startDrag();this.captureMouse(e,this.onMouseDrag.bind(this)),e.defaultPrevented=!0}}}}).call(n.prototype),t.DragdropHandler=n}),ace.define("ace/mouse/touch_handler",["require","exports","module","ace/mouse/mouse_event","ace/lib/dom"],function(e,t,i){"use strict";var Z=e("./mouse_event").MouseEvent,s=e("../lib/dom");t.addTouchListeners=function(e,C){var I,A,v,b,y,t,w,S,r,x="scroll",k=0,R=0,E=0,B=0;function n(){function t(e){var t=e.target.getAttribute("action");if("more"==t||!n)return n=!n,function(){var e=C.getCopyText(),t=C.session.getUndoManager().hasUndo();r.replaceChild(s.buildDom(n?["span",!e&&["span",{class:"ace_mobile-button",action:"selectall"},"Select All"],e&&["span",{class:"ace_mobile-button",action:"copy"},"Copy"],e&&["span",{class:"ace_mobile-button",action:"cut"},"Cut"],i&&["span",{class:"ace_mobile-button",action:"paste"},"Paste"],t&&["span",{class:"ace_mobile-button",action:"undo"},"Undo"],["span",{class:"ace_mobile-button",action:"find"},"Find"],["span",{class:"ace_mobile-button",action:"openCommandPallete"},"Pallete"]]:["span"]),r.firstChild)}();"paste"==t?i.readText().then(function(e){C.execCommand(t,e)}):t&&("cut"!=t&&"copy"!=t||(i?i.writeText(C.getCopyText()):document.execCommand("copy")),C.execCommand(t)),r.firstChild.style.display="none",n=!1,"openCommandPallete"!=t&&C.focus()}var i=window.navigator&&window.navigator.clipboard,n=!1;r=s.buildDom(["div",{class:"ace_mobile-menu",ontouchstart:function(e){x="menu",e.stopPropagation(),e.preventDefault(),C.textInput.focus()},ontouchend:function(e){e.stopPropagation(),e.preventDefault(),t(e)},onclick:t},["span"],["span",{class:"ace_mobile-button",action:"more"},"..."]],C.container)}function i(){r||n();var e=C.selection.cursor,t=C.renderer.textToScreenCoordinates(e.row,e.column),i=C.container.getBoundingClientRect();r.style.top=t.pageY-i.top-3+"px",r.style.right="10px",r.style.display="",r.firstChild.style.display="none",C.on("input",o)}function o(e){r&&(r.style.display="none"),C.off("input",o)}function G(){y=null,clearTimeout(y);var e=C.selection.getRange(),t=e.contains(w.row,w.column);!e.isEmpty()&&t||(C.selection.moveToPosition(w),C.selection.selectWord()),x="wait",i()}e.addEventListener("contextmenu",function(e){S&&C.textInput.getElement().focus()}),e.addEventListener("touchstart",function(e){var t=e.touches;if(y||1<t.length)return clearTimeout(y),y=null,v=-1,void(x="zoom");S=C.$mouseHandler.isMousePressed=!0;var i=C.renderer.layerConfig.lineHeight,n=C.renderer.layerConfig.lineHeight,r=e.timeStamp;b=r;var o=t[0],s=o.clientX,a=o.clientY;Math.abs(I-s)+Math.abs(A-a)>i&&(v=-1),I=e.clientX=s,A=e.clientY=a,E=B=0;var l=new Z(e,C);if(w=l.getDocumentPosition(),r-v<500&&1==t.length&&!k)R++,e.preventDefault(),e.button=0,function(){y=null,clearTimeout(y),C.selection.moveToPosition(w);var e=2<=R?C.selection.getLineRange(w.row):C.session.getBracketRange(w);e&&!e.isEmpty()?C.selection.setRange(e):C.selection.selectWord(),x="wait"}();else{R=0;var c=C.selection.cursor,h=C.selection.isEmpty()?c:C.selection.anchor,d=C.renderer.$cursorLayer.getPixelPosition(c,!0),u=C.renderer.$cursorLayer.getPixelPosition(h,!0),g=C.renderer.scroller.getBoundingClientRect(),p=function(e,t){return(e/=n)*e+(t=t/i-.75)*t};if(e.clientX<g.left)return void(x="zoom");var m=p(e.clientX-g.left-d.left,e.clientY-g.top-d.top),f=p(e.clientX-g.left-u.left,e.clientY-g.top-u.top);m<3.5&&f<3.5&&(x=f<m?"cursor":"anchor"),x=f<3.5?"anchor":m<3.5?"cursor":"scroll",y=setTimeout(G,450)}v=r}),e.addEventListener("touchend",function(e){S=C.$mouseHandler.isMousePressed=!1,t&&clearInterval(t),"zoom"==x?(x="",k=0):y?(C.selection.moveToPosition(w),k=0,i()):"scroll"==x?(k+=60,t=setInterval(function(){k--<=0&&(clearInterval(t),t=null),Math.abs(E)<.01&&(E=0),Math.abs(B)<.01&&(B=0),k<20&&(E*=.9),k<20&&(B*=.9);var e=C.session.getScrollTop();C.renderer.scrollBy(10*E,10*B),e==C.session.getScrollTop()&&(k=0)},10),e.preventDefault(),o()):i(),clearTimeout(y),y=null}),e.addEventListener("touchmove",function(e){y&&(clearTimeout(y),y=null);var t=e.touches;if(!(1<t.length||"zoom"==x)){var i=t[0],n=I-i.clientX,r=A-i.clientY;if("wait"==x){if(!(4<n*n+r*r))return e.preventDefault();x="cursor"}I=i.clientX,A=i.clientY,e.clientX=i.clientX,e.clientY=i.clientY;var o=e.timeStamp,s=o-b;if(b=o,"scroll"==x){var a=new Z(e,C);a.speed=1,a.wheelX=n,a.wheelY=r,10*Math.abs(n)<Math.abs(r)&&(n=0),10*Math.abs(r)<Math.abs(n)&&(r=0),0!=s&&(E=n/s,B=r/s),C._emit("mousewheel",a),a.propagationStopped||(E=B=0)}else{var l=new Z(e,C).getDocumentPosition();"cursor"==x?C.selection.moveCursorToPosition(l):"anchor"==x&&C.selection.setSelectionAnchor(l.row,l.column),C.renderer.scrollCursorIntoView(l),e.preventDefault()}}})}}),ace.define("ace/lib/net",["require","exports","module","ace/lib/dom"],function(e,t,i){"use strict";var r=e("./dom");t.get=function(e,t){var i=new XMLHttpRequest;i.open("GET",e,!0),i.onreadystatechange=function(){4===i.readyState&&t(i.responseText)},i.send(null)},t.loadScript=function(e,i){var t=r.getDocumentHead(),n=document.createElement("script");n.src=e,t.appendChild(n),n.onload=n.onreadystatechange=function(e,t){!t&&n.readyState&&"loaded"!=n.readyState&&"complete"!=n.readyState||(n=n.onload=n.onreadystatechange=null,t||i())}},t.qualifyURL=function(e){var t=document.createElement("a");return t.href=e,t.href}}),ace.define("ace/lib/event_emitter",["require","exports","module"],function(e,t,i){"use strict";function o(){this.propagationStopped=!0}function s(){this.defaultPrevented=!0}var n={};n._emit=n._dispatchEvent=function(e,t){this._eventRegistry||(this._eventRegistry={}),this._defaultHandlers||(this._defaultHandlers={});var i=this._eventRegistry[e]||[],n=this._defaultHandlers[e];if(i.length||n){"object"==typeof t&&t||(t={}),t.type||(t.type=e),t.stopPropagation||(t.stopPropagation=o),t.preventDefault||(t.preventDefault=s),i=i.slice();for(var r=0;r<i.length&&(i[r](t,this),!t.propagationStopped);r++);return n&&!t.defaultPrevented?n(t,this):void 0}},n._signal=function(e,t){var i=(this._eventRegistry||{})[e];if(i){i=i.slice();for(var n=0;n<i.length;n++)i[n](t,this)}},n.once=function(t,i){var n=this;if(this.addEventListener(t,function e(){n.removeEventListener(t,e),i.apply(null,arguments)}),!i)return new Promise(function(e){i=e})},n.setDefaultHandler=function(e,t){var i=this._defaultHandlers;if((i=i||(this._defaultHandlers={_disabled_:{}}))[e]){var n=i[e],r=i._disabled_[e];r||(i._disabled_[e]=r=[]),r.push(n);var o=r.indexOf(t);-1!=o&&r.splice(o,1)}i[e]=t},n.removeDefaultHandler=function(e,t){var i=this._defaultHandlers;if(i){var n=i._disabled_[e];if(i[e]==t)n&&this.setDefaultHandler(e,n.pop());else if(n){var r=n.indexOf(t);-1!=r&&n.splice(r,1)}}},n.on=n.addEventListener=function(e,t,i){this._eventRegistry=this._eventRegistry||{};var n=this._eventRegistry[e];return-1==(n=n||(this._eventRegistry[e]=[])).indexOf(t)&&n[i?"unshift":"push"](t),t},n.off=n.removeListener=n.removeEventListener=function(e,t){this._eventRegistry=this._eventRegistry||{};var i=this._eventRegistry[e];if(i){var n=i.indexOf(t);-1!==n&&i.splice(n,1)}},n.removeAllListeners=function(e){this._eventRegistry&&(this._eventRegistry[e]=[])},t.EventEmitter=n}),ace.define("ace/lib/app_config",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(e,t,i){var r=e("./oop"),n=e("./event_emitter").EventEmitter,o={setOptions:function(t){Object.keys(t).forEach(function(e){this.setOption(e,t[e])},this)},getOptions:function(e){var t={};if(e)Array.isArray(e)||(t=e,e=Object.keys(t));else{var i=this.$options;e=Object.keys(i).filter(function(e){return!i[e].hidden})}return e.forEach(function(e){t[e]=this.getOption(e)},this),t},setOption:function(e,t){if(this["$"+e]!==t){var i=this.$options[e];if(!i)return s('misspelled option "'+e+'"');if(i.forwardTo)return this[i.forwardTo]&&this[i.forwardTo].setOption(e,t);i.handlesSet||(this["$"+e]=t),i&&i.set&&i.set.call(this,t)}},getOption:function(e){var t=this.$options[e];return t?t.forwardTo?this[t.forwardTo]&&this[t.forwardTo].getOption(e):t&&t.get?t.get.call(this):this["$"+e]:s('misspelled option "'+e+'"')}};function s(e){"undefined"!=typeof console&&console.warn&&console.warn.apply(console,arguments)}function a(e,t){var i=new Error(e);i.data=t,"object"==typeof console&&console.error&&console.error(i),setTimeout(function(){throw i})}function l(){this.$defaultOptions={}}(function(){r.implement(this,n),this.defineOptions=function(i,e,n){return i.$options||(this.$defaultOptions[e]=i.$options={}),Object.keys(n).forEach(function(e){var t=n[e];"string"==typeof t&&(t={forwardTo:t}),t.name||(t.name=e),"initialValue"in(i.$options[t.name]=t)&&(i["$"+t.name]=t.initialValue)}),r.implement(i,o),this},this.resetOptions=function(i){Object.keys(i.$options).forEach(function(e){var t=i.$options[e];"value"in t&&i.setOption(e,t.value)})},this.setDefaultValue=function(e,t,i){if(!e){for(e in this.$defaultOptions)if(this.$defaultOptions[e][t])break;if(!this.$defaultOptions[e][t])return!1}var n=this.$defaultOptions[e]||(this.$defaultOptions[e]={});n[t]&&(n.forwardTo?this.setDefaultValue(n.forwardTo,t,i):n[t].value=i)},this.setDefaultValues=function(t,i){Object.keys(i).forEach(function(e){this.setDefaultValue(t,e,i[e])},this)},this.warn=s,this.reportError=a}).call(l.prototype),t.AppConfig=l}),ace.define("ace/config",["require","exports","module","ace/lib/lang","ace/lib/oop","ace/lib/net","ace/lib/app_config"],function(p,m,f){var e=p("./lib/lang"),o=(p("./lib/oop"),p("./lib/net")),t=p("./lib/app_config").AppConfig;f.exports=m=new t;var C=function(){return this||"undefined"!=typeof window&&window}(),I={packaged:!1,workerPath:null,modePath:null,themePath:null,basePath:"",suffix:".js",$moduleUrls:{},loadWorkerFromBlob:!0,sharedPopups:!1};m.get=function(e){if(!I.hasOwnProperty(e))throw new Error("Unknown config key: "+e);return I[e]},m.set=function(e,t){if(I.hasOwnProperty(e))I[e]=t;else if(0==this.setDefaultValue("",e,t))throw new Error("Unknown config key: "+e)},m.all=function(){return e.copyObject(I)},m.$modes={},m.moduleUrl=function(e,t){if(I.$moduleUrls[e])return I.$moduleUrls[e];var i=e.split("/"),n="snippets"==(t=t||i[i.length-2]||"")?"/":"-",r=i[i.length-1];if("worker"==t&&"-"==n){var o=new RegExp("^"+t+"[\\-_]|[\\-_]"+t+"$","g");r=r.replace(o,"")}(!r||r==t)&&1<i.length&&(r=i[i.length-2]);var s=I[t+"Path"];return null==s?s=I.basePath:"/"==n&&(t=n=""),s&&"/"!=s.slice(-1)&&(s+="/"),s+t+n+r+this.get("suffix")},m.setModuleUrl=function(e,t){return I.$moduleUrls[e]=t},m.$loading={},m.loadModule=function(i,e){var t,n;Array.isArray(i)&&(n=i[0],i=i[1]);try{t=p(i)}catch(e){}if(t&&!m.$loading[i])return e&&e(t);if(m.$loading[i]||(m.$loading[i]=[]),m.$loading[i].push(e),!(1<m.$loading[i].length)){function r(){p([i],function(t){m._emit("load.module",{name:i,module:t});var e=m.$loading[i];m.$loading[i]=null,e.forEach(function(e){e&&e(t)})})}if(!m.get("packaged"))return r();o.loadScript(m.moduleUrl(i,n),r),s()}};var s=function(){I.basePath||I.workerPath||I.modePath||I.themePath||Object.keys(I.$moduleUrls).length||(console.error("Unable to infer path to ace from script src,","use ace.config.set('basePath', 'path') to enable dynamic loading of modes and themes","or with webpack use ace/webpack-resolver"),s=function(){})};function i(e){if(C&&C.document){I.packaged=e||p.packaged||f.packaged||C.define&&A(22).packaged;for(var t={},i="",n=document.currentScript||document._currentScript,r=(n&&n.ownerDocument||document).getElementsByTagName("script"),o=0;o<r.length;o++){var s=r[o],a=s.src||s.getAttribute("src");if(a){for(var l=s.attributes,c=0,h=l.length;c<h;c++){var d=l[c];0===d.name.indexOf("data-ace-")&&(t[d.name.replace(/^data-ace-/,"").replace(/-(.)/g,function(e,t){return t.toUpperCase()})]=d.value)}var u=a.match(/^(.*)\/ace(\-\w+)?\.js(\?|$)/);u&&(i=u[1])}}for(var g in i&&(t.base=t.base||i,t.packaged=!0),t.basePath=t.base,t.workerPath=t.workerPath||t.base,t.modePath=t.modePath||t.base,t.themePath=t.themePath||t.base,delete t.base,t)void 0!==t[g]&&m.set(g,t[g])}}i(!0),m.init=i,m.version="1.4.7"}),ace.define("ace/mouse/mouse_handler",["require","exports","module","ace/lib/event","ace/lib/useragent","ace/mouse/default_handlers","ace/mouse/default_gutter_handler","ace/mouse/mouse_event","ace/mouse/dragdrop_handler","ace/mouse/touch_handler","ace/config"],function(e,t,i){"use strict";function n(r){var o=this;function e(e){document.hasFocus&&document.hasFocus()&&(r.isFocused()||document.activeElement!=(r.textInput&&r.textInput.getElement()))||window.focus(),r.focus()}this.editor=r,new s(this),new a(this),new l(this);var t=r.renderer.getMouseEventTarget();h.addListener(t,"click",this.onMouseEvent.bind(this,"click")),h.addListener(t,"mousemove",this.onMouseMove.bind(this,"mousemove")),h.addMultiMouseDownListener([t,r.renderer.scrollBarV&&r.renderer.scrollBarV.inner,r.renderer.scrollBarH&&r.renderer.scrollBarH.inner,r.textInput&&r.textInput.getElement()].filter(Boolean),[400,300,250],this,"onMouseEvent"),h.addMouseWheelListener(r.container,this.onMouseWheel.bind(this,"mousewheel")),c(r.container,r);var i=r.renderer.$gutter;h.addListener(i,"mousedown",this.onMouseEvent.bind(this,"guttermousedown")),h.addListener(i,"click",this.onMouseEvent.bind(this,"gutterclick")),h.addListener(i,"dblclick",this.onMouseEvent.bind(this,"gutterdblclick")),h.addListener(i,"mousemove",this.onMouseEvent.bind(this,"guttermousemove")),h.addListener(t,"mousedown",e),h.addListener(i,"mousedown",e),d.isIE&&r.renderer.scrollBarV&&(h.addListener(r.renderer.scrollBarV.element,"mousedown",e),h.addListener(r.renderer.scrollBarH.element,"mousedown",e)),r.on("mousemove",function(e){if(!o.state&&!o.$dragDelay&&o.$dragEnabled){var t=r.renderer.screenToTextCoordinates(e.x,e.y),i=r.session.selection.getRange(),n=r.renderer;!i.isEmpty()&&i.insideStart(t.row,t.column)?n.setCursorStyle("default"):n.setCursorStyle("")}})}var h=e("../lib/event"),d=e("../lib/useragent"),s=e("./default_handlers").DefaultHandlers,a=e("./default_gutter_handler").GutterHandler,u=e("./mouse_event").MouseEvent,l=e("./dragdrop_handler").DragdropHandler,c=e("./touch_handler").addTouchListeners,r=e("../config");(function(){this.onMouseEvent=function(e,t){this.editor._emit(e,new u(t,this.editor))},this.onMouseMove=function(e,t){var i=this.editor._eventRegistry&&this.editor._eventRegistry.mousemove;i&&i.length&&this.editor._emit(e,new u(t,this.editor))},this.onMouseWheel=function(e,t){var i=new u(t,this.editor);i.speed=2*this.$scrollSpeed,i.wheelX=t.wheelX,i.wheelY=t.wheelY,this.editor._emit(e,i)},this.setState=function(e){this.state=e},this.captureMouse=function(e,t){this.x=e.x,this.y=e.y,this.isMousePressed=!0;var i=this.editor,n=this.editor.renderer;n.$isMousePressed=!0;function r(e){if(e){if(d.isWebKit&&!e.which&&s.releaseMouse)return s.releaseMouse();s.x=e.clientX,s.y=e.clientY,t&&t(e),s.mouseEvent=new u(e,s.editor),s.$mouseMoved=!0}}function o(e){i.off("beforeEndOperation",l),clearInterval(c),a(),s[s.state+"End"]&&s[s.state+"End"](e),s.state="",s.isMousePressed=n.$isMousePressed=!1,n.$keepTextAreaAtCursor&&n.$moveTextAreaToCursor(),s.$onCaptureMouseMove=s.releaseMouse=null,e&&s.onMouseEvent("mouseup",e),i.endOperation()}var s=this,a=function(){s[s.state]&&s[s.state](),s.$mouseMoved=!1};if(d.isOldIE&&"dblclick"==e.domEvent.type)return setTimeout(function(){o(e)});var l=function(e){s.releaseMouse&&i.curOp.command.name&&i.curOp.selectionChanged&&(s[s.state+"End"]&&s[s.state+"End"](),s.state="",s.releaseMouse())};i.on("beforeEndOperation",l),i.startOperation({command:{name:"mouse"}}),s.$onCaptureMouseMove=r,s.releaseMouse=h.capture(this.editor.container,r,o);var c=setInterval(a,20)},this.releaseMouse=null,this.cancelContextMenu=function(){var t=function(e){e&&e.domEvent&&"contextmenu"!=e.domEvent.type||(this.editor.off("nativecontextmenu",t),e&&e.domEvent&&h.stopEvent(e.domEvent))}.bind(this);setTimeout(t,10),this.editor.on("nativecontextmenu",t)}}).call(n.prototype),r.defineOptions(n.prototype,"mouseHandler",{scrollSpeed:{initialValue:2},dragDelay:{initialValue:d.isMac?150:0},dragEnabled:{initialValue:!0},focusTimeout:{initialValue:0},tooltipFollowsMouse:{initialValue:!0}}),t.MouseHandler=n}),ace.define("ace/mouse/fold_handler",["require","exports","module","ace/lib/dom"],function(e,t,i){"use strict";var o=e("../lib/dom");t.FoldHandler=function(s){s.on("click",function(e){var t=e.getDocumentPosition(),i=s.session,n=i.getFoldAt(t.row,t.column,1);n&&(e.getAccelKey()?i.removeFold(n):i.expandFold(n),e.stop());var r=e.domEvent&&e.domEvent.target;r&&o.hasCssClass(r,"ace_inline_button")&&o.hasCssClass(r,"ace_toggle_wrap")&&(i.setOption("wrap",!i.getUseWrapMode()),s.renderer.scrollCursorIntoView())}),s.on("gutterclick",function(e){if("foldWidgets"==s.renderer.$gutterLayer.getRegion(e)){var t=e.getDocumentPosition().row,i=s.session;i.foldWidgets&&i.foldWidgets[t]&&s.session.onFoldWidgetClick(t,e),s.isFocused()||s.focus(),e.stop()}}),s.on("gutterdblclick",function(e){if("foldWidgets"==s.renderer.$gutterLayer.getRegion(e)){var t=e.getDocumentPosition().row,i=s.session,n=i.getParentFoldRangeData(t,!0),r=n.range||n.firstRange;if(r){t=r.start.row;var o=i.getFoldAt(t,i.getLine(t).length,1);o?i.removeFold(o):(i.addFold("...",r),s.renderer.scrollCursorIntoView({row:r.start.row,column:0}))}e.stop()}})}}),ace.define("ace/keyboard/keybinding",["require","exports","module","ace/lib/keys","ace/lib/event"],function(e,t,i){"use strict";function n(e){this.$editor=e,this.$data={editor:e},this.$handlers=[],this.setDefaultHandler(e.commands)}var r=e("../lib/keys"),l=e("../lib/event");(function(){this.setDefaultHandler=function(e){this.removeKeyboardHandler(this.$defaultHandler),this.$defaultHandler=e,this.addKeyboardHandler(e,0)},this.setKeyboardHandler=function(e){var t=this.$handlers;if(t[t.length-1]!=e){for(;t[t.length-1]&&t[t.length-1]!=this.$defaultHandler;)this.removeKeyboardHandler(t[t.length-1]);this.addKeyboardHandler(e,1)}},this.addKeyboardHandler=function(e,t){if(e){"function"!=typeof e||e.handleKeyboard||(e.handleKeyboard=e);var i=this.$handlers.indexOf(e);-1!=i&&this.$handlers.splice(i,1),null==t?this.$handlers.push(e):this.$handlers.splice(t,0,e),-1==i&&e.attach&&e.attach(this.$editor)}},this.removeKeyboardHandler=function(e){var t=this.$handlers.indexOf(e);return-1!=t&&(this.$handlers.splice(t,1),e.detach&&e.detach(this.$editor),!0)},this.getKeyboardHandler=function(){return this.$handlers[this.$handlers.length-1]},this.getStatusText=function(){var t=this.$data,i=t.editor;return this.$handlers.map(function(e){return e.getStatusText&&e.getStatusText(i,t)||""}).filter(Boolean).join(" ")},this.$callKeyboardHandlers=function(e,t,i,n){for(var r,o=!1,s=this.$editor.commands,a=this.$handlers.length;a--&&!((r=this.$handlers[a].handleKeyboard(this.$data,e,t,i,n))&&r.command&&((o="null"==r.command||s.exec(r.command,this.$editor,r.args,n))&&n&&-1!=e&&1!=r.passEvent&&1!=r.command.passEvent&&l.stopEvent(n),o)););return o||-1!=e||(r={command:"insertstring"},o=s.exec("insertstring",this.$editor,t)),o&&this.$editor._signal&&this.$editor._signal("keyboardActivity",r),o},this.onCommandKey=function(e,t,i){var n=r.keyCodeToString(i);return this.$callKeyboardHandlers(t,n,i,e)},this.onTextInput=function(e){return this.$callKeyboardHandlers(-1,e)}}).call(n.prototype),t.KeyBinding=n}),ace.define("ace/lib/bidiutil",["require","exports","module"],function(e,l,t){"use strict";var m=0,f=0,C=!1,I=!1,A=!1,v=[[0,3,0,1,0,0,0],[0,3,0,1,2,2,0],[0,3,0,17,2,0,1],[0,3,5,5,4,1,0],[0,3,21,21,4,0,1],[0,3,5,5,4,2,0]],b=[[2,0,1,1,0,1,0],[2,0,1,1,0,2,0],[2,0,2,1,3,2,0],[2,0,2,33,3,1,1]],d=0,u=1,g=2,p=3,y=4,w=5,S=6,x=7,k=8,R=9,E=10,B=11,G=12,Z=13,T=14,W=15,_=16,H=17,L=18,n=[L,L,L,L,L,L,L,L,L,S,w,S,k,w,L,L,L,L,L,L,L,L,L,L,L,L,L,L,w,w,w,S,k,y,y,B,B,B,y,y,y,y,y,E,R,E,R,R,g,g,g,g,g,g,g,g,g,g,R,y,y,y,y,y,y,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,y,y,y,y,y,y,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,y,y,y,y,L,L,L,L,L,L,w,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,R,y,B,B,B,B,y,y,y,y,d,y,y,L,y,y,B,B,g,g,y,d,y,y,y,g,d,y,y,y,y,y],r=[k,k,k,k,k,k,k,k,k,k,k,L,L,L,d,u,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,k,w,Z,T,W,_,H,R,B,B,B,B,B,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,R,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,k];function c(e,t,i){if(!(f<e))if(1!=e||1!=m||I)for(var n,r,o,s,a=i.length,l=0;l<a;){if(t[l]>=e){for(n=l+1;n<a&&t[n]>=e;)n++;for(r=l,o=n-1;r<o;r++,o--)s=i[r],i[r]=i[o],i[o]=s;l=n}l++}else i.reverse()}function $(e,t,i,n){var r,o,s,a,l=t[n];switch(l){case d:case u:C=!1;case y:case p:return l;case g:return C?p:g;case x:return C=!0,u;case k:return y;case R:return n<1||n+1>=t.length||(r=i[n-1])!=g&&r!=p||(o=t[n+1])!=g&&o!=p?y:(C&&(o=p),o==r?o:y);case E:return(r=0<n?i[n-1]:w)==g&&n+1<t.length&&t[n+1]==g?g:y;case B:if(0<n&&i[n-1]==g)return g;if(C)return y;for(a=n+1,s=t.length;a<s&&t[a]==B;)a++;return a<s&&t[a]==g?g:y;case G:for(s=t.length,a=n+1;a<s&&t[a]==G;)a++;if(a<s){var c=e[n],h=1425<=c&&c<=2303||64286==c;if(r=t[a],h&&(r==u||r==x))return u}return n<1||(r=t[n-1])==w?y:i[n-1];case w:return I=!(C=!1),m;case S:return A=!0,y;case Z:case T:case _:case H:case W:C=!1;case L:return y}}function V(e){var t=e.charCodeAt(0),i=t>>8;return 0==i?191<t?d:n[t]:5==i?/[\u0591-\u05f4]/.test(e)?u:d:6==i?/[\u0610-\u061a\u064b-\u065f\u06d6-\u06e4\u06e7-\u06ed]/.test(e)?G:/[\u0660-\u0669\u066b-\u066c]/.test(e)?p:1642==t?B:/[\u06f0-\u06f9]/.test(e)?g:x:32==i&&t<=8287?r[255&t]:254==i&&65136<=t?x:y}l.L=d,l.R=u,l.EN=g,l.ON_R=3,l.AN=4,l.R_H=5,l.B=6,l.RLE=7,l.DOT="·",l.doBidiReorder=function(e,t,i){if(e.length<2)return{};var n=e.split(""),r=new Array(n.length),o=new Array(n.length),s=[];m=i?1:0,function(e,t,i,n){var r=m?b:v,o=null,s=null,a=null,l=0,c=null,h=-1,d=null,u=null,g=[];if(!n)for(d=0,n=[];d<i;d++)n[d]=V(e[d]);for(f=m,A=I=C=!1,u=0;u<i;u++){if(o=l,g[u]=s=$(e,n,g,u),c=240&(l=r[o][s]),l&=15,t[u]=a=r[l][5],0<c)if(16==c){for(d=h;d<u;d++)t[d]=1;h=-1}else h=-1;if(r[l][6])-1==h&&(h=u);else if(-1<h){for(d=h;d<u;d++)t[d]=a;h=-1}n[u]==w&&(t[u]=0),f|=a}if(A)for(d=0;d<i;d++)if(n[d]==S){t[d]=m;for(var p=d-1;0<=p&&n[p]==k;p--)t[p]=m}}(n,s,n.length,t);for(var a=0;a<r.length;r[a]=a,a++);c(2,s,r),c(1,s,r);for(a=0;a<r.length-1;a++)t[a]===p?s[a]=l.AN:s[a]===u&&(t[a]>x&&t[a]<Z||t[a]===y||t[a]===L)?s[a]=l.ON_R:0<a&&"ل"===n[a-1]&&/\u0622|\u0623|\u0625|\u0627/.test(n[a])&&(s[a-1]=s[a]=l.R_H,a++);n[n.length-1]===l.DOT&&(s[n.length-1]=l.B),"‫"===n[0]&&(s[0]=l.RLE);for(a=0;a<r.length;a++)o[a]=s[r[a]];return{logicalFromVisual:r,bidiLevels:o}},l.hasBidiCharacters=function(e,t){for(var i=!1,n=0;n<e.length;n++)t[n]=V(e.charAt(n)),i||t[n]!=u&&t[n]!=x&&t[n]!=p||(i=!0);return i},l.getVisualFromLogicalIdx=function(e,t){for(var i=0;i<t.logicalFromVisual.length;i++)if(t.logicalFromVisual[i]==e)return i;return 0}}),ace.define("ace/bidihandler",["require","exports","module","ace/lib/bidiutil","ace/lib/lang"],function(e,t,i){"use strict";function n(e){this.session=e,this.bidiMap={},this.currentRow=null,this.bidiUtil=a,this.charWidths=[],this.EOL="¬",this.showInvisibles=!0,this.isRtlDir=!1,this.$isRtl=!1,this.line="",this.wrapIndent=0,this.EOF="¶",this.RLE="‫",this.contentWidth=0,this.fontMetrics=null,this.rtlLineOffset=0,this.wrapOffset=0,this.isMoveLeftOperation=!1,this.seenBidi=r.test(e.getValue())}var a=e("./lib/bidiutil"),l=e("./lib/lang"),r=/[\u0590-\u05f4\u0600-\u06ff\u0700-\u08ac\u202B]/;(function(){this.isBidiRow=function(e,t,i){return!!this.seenBidi&&(e!==this.currentRow&&(this.currentRow=e,this.updateRowLine(t,i),this.updateBidiMap()),this.bidiMap.bidiLevels)},this.onChange=function(e){this.seenBidi?this.currentRow=null:"insert"==e.action&&r.test(e.lines.join("\n"))&&(this.seenBidi=!0,this.currentRow=null)},this.getDocumentRow=function(){var e=0,t=this.session.$screenRowCache;if(t.length){var i=this.session.$getRowCacheIndex(t,this.currentRow);0<=i&&(e=this.session.$docRowCache[i])}return e},this.getSplitIndex=function(){var e=0,t=this.session.$screenRowCache;if(t.length)for(var i,n=this.session.$getRowCacheIndex(t,this.currentRow);0<this.currentRow-e&&(i=this.session.$getRowCacheIndex(t,this.currentRow-e-1))===n;)n=i,e++;else e=this.currentRow;return e},this.updateRowLine=function(e,t){void 0===e&&(e=this.getDocumentRow());var i=e===this.session.getLength()-1?this.EOF:this.EOL;if(this.wrapIndent=0,this.line=this.session.getLine(e),this.isRtlDir=this.$isRtl||this.line.charAt(0)===this.RLE,this.session.$useWrapMode){var n=this.session.$wrapData[e];n&&(void 0===t&&(t=this.getSplitIndex()),0<t&&n.length?(this.wrapIndent=n.indent,this.wrapOffset=this.wrapIndent*this.charWidths[a.L],this.line=t<n.length?this.line.substring(n[t-1],n[t]):this.line.substring(n[n.length-1])):this.line=this.line.substring(0,n[t])),t==n.length&&(this.line+=this.showInvisibles?i:a.DOT)}else this.line+=this.showInvisibles?i:a.DOT;var r,o=this.session,s=0;this.line=this.line.replace(/\t|[\u1100-\u2029, \u202F-\uFFE6]/g,function(e,t){return"\t"===e||o.isFullWidth(e.charCodeAt(0))?(r="\t"===e?o.getScreenTabSize(t+s):2,s+=r-1,l.stringRepeat(a.DOT,r)):e}),this.isRtlDir&&(this.fontMetrics.$main.textContent=this.line.charAt(this.line.length-1)==a.DOT?this.line.substr(0,this.line.length-1):this.line,this.rtlLineOffset=this.contentWidth-this.fontMetrics.$main.getBoundingClientRect().width)},this.updateBidiMap=function(){var e=[];a.hasBidiCharacters(this.line,e)||this.isRtlDir?this.bidiMap=a.doBidiReorder(this.line,e,this.isRtlDir):this.bidiMap={}},this.markAsDirty=function(){this.currentRow=null},this.updateCharacterWidths=function(e){if(this.characterWidth!==e.$characterSize.width){this.fontMetrics=e;var t=this.characterWidth=e.$characterSize.width,i=e.$measureCharWidth("ה");this.charWidths[a.L]=this.charWidths[a.EN]=this.charWidths[a.ON_R]=t,this.charWidths[a.R]=this.charWidths[a.AN]=i,this.charWidths[a.R_H]=.45*i,this.charWidths[a.B]=this.charWidths[a.RLE]=0,this.currentRow=null}},this.setShowInvisibles=function(e){this.showInvisibles=e,this.currentRow=null},this.setEolChar=function(e){this.EOL=e},this.setContentWidth=function(e){this.contentWidth=e},this.isRtlLine=function(e){return!!this.$isRtl||(null!=e?this.session.getLine(e).charAt(0)==this.RLE:this.isRtlDir)},this.setRtlDirection=function(e,t){for(var i=e.getCursorPosition(),n=e.selection.getSelectionAnchor().row;n<=i.row;n++)t||e.session.getLine(n).charAt(0)!==e.session.$bidiHandler.RLE?t&&e.session.getLine(n).charAt(0)!==e.session.$bidiHandler.RLE&&e.session.doc.insert({column:0,row:n},e.session.$bidiHandler.RLE):e.session.doc.removeInLine(n,0,1)},this.getPosLeft=function(e){e-=this.wrapIndent;var t=this.line.charAt(0)===this.RLE?1:0,i=t<e?this.session.getOverwrite()?e:e-1:t,n=a.getVisualFromLogicalIdx(i,this.bidiMap),r=this.bidiMap.bidiLevels,o=0;!this.session.getOverwrite()&&e<=t&&r[n]%2!=0&&n++;for(var s=0;s<n;s++)o+=this.charWidths[r[s]];return!this.session.getOverwrite()&&t<e&&r[n]%2==0&&(o+=this.charWidths[r[n]]),this.wrapIndent&&(o+=this.isRtlDir?-1*this.wrapOffset:this.wrapOffset),this.isRtlDir&&(o+=this.rtlLineOffset),o},this.getSelections=function(e,t){var i,n=this.bidiMap,r=n.bidiLevels,o=[],s=0,a=Math.min(e,t)-this.wrapIndent,l=Math.max(e,t)-this.wrapIndent,c=!1,h=!1,d=0;this.wrapIndent&&(s+=this.isRtlDir?-1*this.wrapOffset:this.wrapOffset);for(var u,g=0;g<r.length;g++)u=n.logicalFromVisual[g],i=r[g],(c=a<=u&&u<l)&&!h?d=s:!c&&h&&o.push({left:d,width:s-d}),s+=this.charWidths[i],h=c;if(c&&g===r.length&&o.push({left:d,width:s-d}),this.isRtlDir)for(var p=0;p<o.length;p++)o[p].left+=this.rtlLineOffset;return o},this.offsetToCol=function(e){this.isRtlDir&&(e-=this.rtlLineOffset);var t=0,i=(e=Math.max(e,0),0),n=0,r=this.bidiMap.bidiLevels,o=this.charWidths[r[n]];for(this.wrapIndent&&(e-=this.isRtlDir?-1*this.wrapOffset:this.wrapOffset);i+o/2<e;){if(i+=o,n===r.length-1){o=0;break}o=this.charWidths[r[++n]]}return 0===(t=0<n&&r[n-1]%2!=0&&r[n]%2==0?(e<i&&n--,this.bidiMap.logicalFromVisual[n]):0<n&&r[n-1]%2==0&&r[n]%2!=0?1+(i<e?this.bidiMap.logicalFromVisual[n]:this.bidiMap.logicalFromVisual[n-1]):this.isRtlDir&&n===r.length-1&&0===o&&r[n-1]%2==0||!this.isRtlDir&&0===n&&r[n]%2!=0?1+this.bidiMap.logicalFromVisual[n]:(0<n&&r[n-1]%2!=0&&0!==o&&n--,this.bidiMap.logicalFromVisual[n]))&&this.isRtlDir&&t++,t+this.wrapIndent}}).call(n.prototype),t.BidiHandler=n}),ace.define("ace/selection",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/lib/event_emitter","ace/range"],function(e,t,i){"use strict";function n(e){this.session=e,this.doc=e.getDocument(),this.clearSelection(),this.cursor=this.lead=this.doc.createAnchor(0,0),this.anchor=this.doc.createAnchor(0,0),this.$silent=!1;var t=this;this.cursor.on("change",function(e){t.$cursorChanged=!0,t.$silent||t._emit("changeCursor"),t.$isEmpty||t.$silent||t._emit("changeSelection"),t.$keepDesiredColumnOnChange||e.old.column==e.value.column||(t.$desiredColumn=null)}),this.anchor.on("change",function(){t.$anchorChanged=!0,t.$isEmpty||t.$silent||t._emit("changeSelection")})}var r=e("./lib/oop"),s=e("./lib/lang"),o=e("./lib/event_emitter").EventEmitter,a=e("./range").Range;(function(){r.implement(this,o),this.isEmpty=function(){return this.$isEmpty||this.anchor.row==this.lead.row&&this.anchor.column==this.lead.column},this.isMultiLine=function(){return!this.$isEmpty&&this.anchor.row!=this.cursor.row},this.getCursor=function(){return this.lead.getPosition()},this.setSelectionAnchor=function(e,t){this.$isEmpty=!1,
this.anchor.setPosition(e,t)},this.getAnchor=this.getSelectionAnchor=function(){return this.$isEmpty?this.getSelectionLead():this.anchor.getPosition()},this.getSelectionLead=function(){return this.lead.getPosition()},this.isBackwards=function(){var e=this.anchor,t=this.lead;return e.row>t.row||e.row==t.row&&e.column>t.column},this.getRange=function(){var e=this.anchor,t=this.lead;return this.$isEmpty?a.fromPoints(t,t):this.isBackwards()?a.fromPoints(t,e):a.fromPoints(e,t)},this.clearSelection=function(){this.$isEmpty||(this.$isEmpty=!0,this._emit("changeSelection"))},this.selectAll=function(){this.$setSelection(0,0,Number.MAX_VALUE,Number.MAX_VALUE)},this.setRange=this.setSelectionRange=function(e,t){var i=t?e.end:e.start,n=t?e.start:e.end;this.$setSelection(i.row,i.column,n.row,n.column)},this.$setSelection=function(e,t,i,n){var r=this.$isEmpty,o=this.inMultiSelectMode;this.$silent=!0,this.$cursorChanged=this.$anchorChanged=!1,this.anchor.setPosition(e,t),this.cursor.setPosition(i,n),this.$isEmpty=!a.comparePoints(this.anchor,this.cursor),this.$silent=!1,this.$cursorChanged&&this._emit("changeCursor"),(this.$cursorChanged||this.$anchorChanged||r!=this.$isEmpty||o)&&this._emit("changeSelection")},this.$moveSelection=function(e){var t=this.lead;this.$isEmpty&&this.setSelectionAnchor(t.row,t.column),e.call(this)},this.selectTo=function(e,t){this.$moveSelection(function(){this.moveCursorTo(e,t)})},this.selectToPosition=function(e){this.$moveSelection(function(){this.moveCursorToPosition(e)})},this.moveTo=function(e,t){this.clearSelection(),this.moveCursorTo(e,t)},this.moveToPosition=function(e){this.clearSelection(),this.moveCursorToPosition(e)},this.selectUp=function(){this.$moveSelection(this.moveCursorUp)},this.selectDown=function(){this.$moveSelection(this.moveCursorDown)},this.selectRight=function(){this.$moveSelection(this.moveCursorRight)},this.selectLeft=function(){this.$moveSelection(this.moveCursorLeft)},this.selectLineStart=function(){this.$moveSelection(this.moveCursorLineStart)},this.selectLineEnd=function(){this.$moveSelection(this.moveCursorLineEnd)},this.selectFileEnd=function(){this.$moveSelection(this.moveCursorFileEnd)},this.selectFileStart=function(){this.$moveSelection(this.moveCursorFileStart)},this.selectWordRight=function(){this.$moveSelection(this.moveCursorWordRight)},this.selectWordLeft=function(){this.$moveSelection(this.moveCursorWordLeft)},this.getWordRange=function(e,t){if(void 0===t){var i=e||this.lead;e=i.row,t=i.column}return this.session.getWordRange(e,t)},this.selectWord=function(){this.setSelectionRange(this.getWordRange())},this.selectAWord=function(){var e=this.getCursor(),t=this.session.getAWordRange(e.row,e.column);this.setSelectionRange(t)},this.getLineRange=function(e,t){var i,n="number"==typeof e?e:this.lead.row,r=this.session.getFoldLine(n);return i=r?(n=r.start.row,r.end.row):n,!0===t?new a(n,0,i,this.session.getLine(i).length):new a(n,0,i+1,0)},this.selectLine=function(){this.setSelectionRange(this.getLineRange())},this.moveCursorUp=function(){this.moveCursorBy(-1,0)},this.moveCursorDown=function(){this.moveCursorBy(1,0)},this.wouldMoveIntoSoftTab=function(e,t,i){var n=e.column,r=e.column+t;return i<0&&(n=e.column-t,r=e.column),this.session.isTabStop(e)&&this.doc.getLine(e.row).slice(n,r).split(" ").length-1==t},this.moveCursorLeft=function(){var e,t=this.lead.getPosition();if(e=this.session.getFoldAt(t.row,t.column,-1))this.moveCursorTo(e.start.row,e.start.column);else if(0===t.column)0<t.row&&this.moveCursorTo(t.row-1,this.doc.getLine(t.row-1).length);else{var i=this.session.getTabSize();this.wouldMoveIntoSoftTab(t,i,-1)&&!this.session.getNavigateWithinSoftTabs()?this.moveCursorBy(0,-i):this.moveCursorBy(0,-1)}},this.moveCursorRight=function(){var e,t=this.lead.getPosition();if(e=this.session.getFoldAt(t.row,t.column,1))this.moveCursorTo(e.end.row,e.end.column);else if(this.lead.column==this.doc.getLine(this.lead.row).length)this.lead.row<this.doc.getLength()-1&&this.moveCursorTo(this.lead.row+1,0);else{var i=this.session.getTabSize();t=this.lead;this.wouldMoveIntoSoftTab(t,i,1)&&!this.session.getNavigateWithinSoftTabs()?this.moveCursorBy(0,i):this.moveCursorBy(0,1)}},this.moveCursorLineStart=function(){var e=this.lead.row,t=this.lead.column,i=this.session.documentToScreenRow(e,t),n=this.session.screenToDocumentPosition(i,0),r=this.session.getDisplayLine(e,null,n.row,n.column).match(/^\s*/);r[0].length==t||this.session.$useEmacsStyleLineStart||(n.column+=r[0].length),this.moveCursorToPosition(n)},this.moveCursorLineEnd=function(){var e=this.lead,t=this.session.getDocumentLastRowColumnPosition(e.row,e.column);if(this.lead.column==t.column){var i=this.session.getLine(t.row);if(t.column==i.length){var n=i.search(/\s+$/);0<n&&(t.column=n)}}this.moveCursorTo(t.row,t.column)},this.moveCursorFileEnd=function(){var e=this.doc.getLength()-1,t=this.doc.getLine(e).length;this.moveCursorTo(e,t)},this.moveCursorFileStart=function(){this.moveCursorTo(0,0)},this.moveCursorLongWordRight=function(){var e=this.lead.row,t=this.lead.column,i=this.doc.getLine(e),n=i.substring(t);this.session.nonTokenRe.lastIndex=0,this.session.tokenRe.lastIndex=0;var r=this.session.getFoldAt(e,t,1);if(r)this.moveCursorTo(r.end.row,r.end.column);else{if(this.session.nonTokenRe.exec(n)&&(t+=this.session.nonTokenRe.lastIndex,this.session.nonTokenRe.lastIndex=0,n=i.substring(t)),t>=i.length)return this.moveCursorTo(e,i.length),this.moveCursorRight(),void(e<this.doc.getLength()-1&&this.moveCursorWordRight());this.session.tokenRe.exec(n)&&(t+=this.session.tokenRe.lastIndex,this.session.tokenRe.lastIndex=0),this.moveCursorTo(e,t)}},this.moveCursorLongWordLeft=function(){var e,t=this.lead.row,i=this.lead.column;if(e=this.session.getFoldAt(t,i,-1))this.moveCursorTo(e.start.row,e.start.column);else{var n=this.session.getFoldStringAt(t,i,-1);null==n&&(n=this.doc.getLine(t).substring(0,i));var r=s.stringReverse(n);if(this.session.nonTokenRe.lastIndex=0,this.session.tokenRe.lastIndex=0,this.session.nonTokenRe.exec(r)&&(i-=this.session.nonTokenRe.lastIndex,r=r.slice(this.session.nonTokenRe.lastIndex),this.session.nonTokenRe.lastIndex=0),i<=0)return this.moveCursorTo(t,0),this.moveCursorLeft(),void(0<t&&this.moveCursorWordLeft());this.session.tokenRe.exec(r)&&(i-=this.session.tokenRe.lastIndex,this.session.tokenRe.lastIndex=0),this.moveCursorTo(t,i)}},this.$shortWordEndIndex=function(e){var t,i=0,n=/\s/,r=this.session.tokenRe;if(r.lastIndex=0,this.session.tokenRe.exec(e))i=this.session.tokenRe.lastIndex;else{for(;(t=e[i])&&n.test(t);)i++;if(i<1)for(r.lastIndex=0;(t=e[i])&&!r.test(t);)if(r.lastIndex=0,i++,n.test(t)){if(2<i){i--;break}for(;(t=e[i])&&n.test(t);)i++;if(2<i)break}}return r.lastIndex=0,i},this.moveCursorShortWordRight=function(){var e=this.lead.row,t=this.lead.column,i=this.doc.getLine(e),n=i.substring(t),r=this.session.getFoldAt(e,t,1);if(r)return this.moveCursorTo(r.end.row,r.end.column);if(t==i.length){for(var o=this.doc.getLength();e++,n=this.doc.getLine(e),e<o&&/^\s*$/.test(n););/^\s+/.test(n)||(n=""),t=0}var s=this.$shortWordEndIndex(n);this.moveCursorTo(e,t+s)},this.moveCursorShortWordLeft=function(){var e,t=this.lead.row,i=this.lead.column;if(e=this.session.getFoldAt(t,i,-1))return this.moveCursorTo(e.start.row,e.start.column);var n=this.session.getLine(t).substring(0,i);if(0===i){for(;t--,n=this.doc.getLine(t),0<t&&/^\s*$/.test(n););i=n.length,/\s+$/.test(n)||(n="")}var r=s.stringReverse(n),o=this.$shortWordEndIndex(r);return this.moveCursorTo(t,i-o)},this.moveCursorWordRight=function(){this.session.$selectLongWords?this.moveCursorLongWordRight():this.moveCursorShortWordRight()},this.moveCursorWordLeft=function(){this.session.$selectLongWords?this.moveCursorLongWordLeft():this.moveCursorShortWordLeft()},this.moveCursorBy=function(e,t){var i,n=this.session.documentToScreenPosition(this.lead.row,this.lead.column);0===t&&(0!==e&&(this.session.$bidiHandler.isBidiRow(n.row,this.lead.row)?(i=this.session.$bidiHandler.getPosLeft(n.column),n.column=Math.round(i/this.session.$bidiHandler.charWidths[0])):i=n.column*this.session.$bidiHandler.charWidths[0]),this.$desiredColumn?n.column=this.$desiredColumn:this.$desiredColumn=n.column);var r=this.session.screenToDocumentPosition(n.row+e,n.column,i);0!==e&&0===t&&r.row===this.lead.row&&r.column===this.lead.column&&this.session.lineWidgets&&this.session.lineWidgets[r.row]&&(0<r.row||0<e)&&r.row++,this.moveCursorTo(r.row,r.column+t,0===t)},this.moveCursorToPosition=function(e){this.moveCursorTo(e.row,e.column)},this.moveCursorTo=function(e,t,i){var n=this.session.getFoldAt(e,t,1);n&&(e=n.start.row,t=n.start.column),this.$keepDesiredColumnOnChange=!0;var r=this.session.getLine(e);/[\uDC00-\uDFFF]/.test(r.charAt(t))&&r.charAt(t-1)&&(this.lead.row==e&&this.lead.column==t+1?t-=1:t+=1),this.lead.setPosition(e,t),this.$keepDesiredColumnOnChange=!1,i||(this.$desiredColumn=null)},this.moveCursorToScreen=function(e,t,i){var n=this.session.screenToDocumentPosition(e,t);this.moveCursorTo(n.row,n.column,i)},this.detach=function(){this.lead.detach(),this.anchor.detach(),this.session=this.doc=null},this.fromOrientedRange=function(e){this.setSelectionRange(e,e.cursor==e.start),this.$desiredColumn=e.desiredColumn||this.$desiredColumn},this.toOrientedRange=function(e){var t=this.getRange();return e?(e.start.column=t.start.column,e.start.row=t.start.row,e.end.column=t.end.column,e.end.row=t.end.row):e=t,e.cursor=this.isBackwards()?e.start:e.end,e.desiredColumn=this.$desiredColumn,e},this.getRangeOfMovements=function(e){var t=this.getCursor();try{e(this);var i=this.getCursor();return a.fromPoints(t,i)}catch(e){return a.fromPoints(t,t)}finally{this.moveCursorToPosition(t)}},this.toJSON=function(){if(this.rangeCount)var e=this.ranges.map(function(e){var t=e.clone();return t.isBackwards=e.cursor==e.start,t});else(e=this.getRange()).isBackwards=this.isBackwards();return e},this.fromJSON=function(e){if(null==e.start){if(this.rangeList&&1<e.length){this.toSingleRange(e[0]);for(var t=e.length;t--;){var i=a.fromPoints(e[t].start,e[t].end);e[t].isBackwards&&(i.cursor=i.start),this.addRange(i,!0)}return}e=e[0]}this.rangeList&&this.toSingleRange(e),this.setSelectionRange(e,e.isBackwards)},this.isEqual=function(e){if((e.length||this.rangeCount)&&e.length!=this.rangeCount)return!1;if(!e.length||!this.ranges)return this.getRange().isEqual(e);for(var t=this.ranges.length;t--;)if(!this.ranges[t].isEqual(e[t]))return!1;return!0}}).call(n.prototype),t.Selection=n}),ace.define("ace/tokenizer",["require","exports","module","ace/config"],function(e,t,i){"use strict";function n(e){for(var t in this.states=e,this.regExps={},this.matchMappings={},this.states){for(var i=this.states[t],n=[],r=0,o=this.matchMappings[t]={defaultToken:"text"},s="g",a=[],l=0;l<i.length;l++){var c=i[l];if(c.defaultToken&&(o.defaultToken=c.defaultToken),c.caseInsensitive&&(s="gi"),null!=c.regex){c.regex instanceof RegExp&&(c.regex=c.regex.toString().slice(1,-1));var h=c.regex,d=new RegExp("(?:("+h+")|(.))").exec("a").length-2;Array.isArray(c.token)?1==c.token.length||1==d?c.token=c.token[0]:d-1!=c.token.length?(this.reportError("number of classes and regexp groups doesn't match",{rule:c,groupCount:d-1}),c.token=c.token[0]):(c.tokenArray=c.token,c.token=null,c.onMatch=this.$arrayTokens):"function"!=typeof c.token||c.onMatch||(c.onMatch=1<d?this.$applyToken:c.token),1<d&&(h=/\\\d/.test(c.regex)?c.regex.replace(/\\([0-9]+)/g,function(e,t){return"\\"+(parseInt(t,10)+r+1)}):(d=1,this.removeCapturingGroups(c.regex)),c.splitRegex||"string"==typeof c.token||a.push(c)),o[r]=l,r+=d,n.push(h),c.onMatch||(c.onMatch=null)}}n.length||(o[0]=0,n.push("$")),a.forEach(function(e){e.splitRegex=this.createSplitterRegexp(e.regex,s)},this),this.regExps[t]=new RegExp("("+n.join(")|(")+")|($)",s)}}var r=e("./config"),I=2e3;(function(){this.$setMaxTokenCount=function(e){I=0|e},this.$applyToken=function(e){var t=this.splitRegex.exec(e).slice(1),i=this.token.apply(this,t);if("string"==typeof i)return[{type:i,value:e}];for(var n=[],r=0,o=i.length;r<o;r++)t[r]&&(n[n.length]={type:i[r],value:t[r]});return n},this.$arrayTokens=function(e){if(!e)return[];var t=this.splitRegex.exec(e);if(!t)return"text";for(var i=[],n=this.tokenArray,r=0,o=n.length;r<o;r++)t[r+1]&&(i[i.length]={type:n[r],value:t[r+1]});return i},this.removeCapturingGroups=function(e){return e.replace(/\\.|\[(?:\\.|[^\\\]])*|\(\?[:=!]|(\()/g,function(e,t){return t?"(?:":e})},this.createSplitterRegexp=function(e,t){if(-1!=e.indexOf("(?=")){var s=0,a=!1,l={};e.replace(/(\\.)|(\((?:\?[=!])?)|(\))|([\[\]])/g,function(e,t,i,n,r,o){return a?a="]"!=r:r?a=!0:n?(s==l.stack&&(l.end=o+1,l.stack=-1),s--):i&&(s++,1!=i.length&&(l.stack=s,l.start=o)),e}),null!=l.end&&/^\)*$/.test(e.substr(l.end))&&(e=e.substring(0,l.start)+e.substr(l.end))}return"^"!=e.charAt(0)&&(e="^"+e),"$"!=e.charAt(e.length-1)&&(e+="$"),new RegExp(e,(t||"").replace("g",""))},this.getLineTokens=function(e,t){if(t&&"string"!=typeof t)"#tmp"===(t=(i=t.slice(0))[0])&&(i.shift(),t=i.shift());else var i=[];var n=t||"start",r=this.states[n];r||(n="start",r=this.states[n]);for(var o,s=this.matchMappings[n],a=this.regExps[n],l=[],c=a.lastIndex=0,h=0,d={type:null,value:""};o=a.exec(e);){var u=s.defaultToken,g=null,p=o[0],m=a.lastIndex;if(m-p.length>c){var f=e.substring(c,m-p.length);d.type==u?d.value+=f:(d.type&&l.push(d),d={type:u,value:f})}for(var C=0;C<o.length-2;C++)if(void 0!==o[C+1]){u=(g=r[s[C]]).onMatch?g.onMatch(p,n,i,e):g.token,g.next&&(n="string"==typeof g.next?g.next:g.next(n,i),(r=this.states[n])||(this.reportError("state doesn't exist",n),n="start",r=this.states[n]),s=this.matchMappings[n],c=m,(a=this.regExps[n]).lastIndex=m),g.consumeLineEnd&&(c=m);break}if(p)if("string"==typeof u)g&&!1===g.merge||d.type!==u?(d.type&&l.push(d),d={type:u,value:p}):d.value+=p;else if(u){d.type&&l.push(d),d={type:null,value:""};for(C=0;C<u.length;C++)l.push(u[C])}if(c==e.length)break;if(c=m,h++>I){for(h>2*e.length&&this.reportError("infinite loop with in ace tokenizer",{startState:t,line:e});c<e.length;)d.type&&l.push(d),d={value:e.substring(c,c+=500),type:"overflow"};n="start",i=[];break}}return d.type&&l.push(d),1<i.length&&i[0]!==n&&i.unshift("#tmp",n),{tokens:l,state:i.length?i:n}},this.reportError=r.reportError}).call(n.prototype),t.Tokenizer=n}),ace.define("ace/mode/text_highlight_rules",["require","exports","module","ace/lib/lang"],function(e,t,i){"use strict";function n(){this.$rules={start:[{token:"empty_line",regex:"^$"},{defaultToken:"text"}]}}var c=e("../lib/lang");(function(){this.addRules=function(e,t){if(t)for(var i in e){for(var n=e[i],r=0;r<n.length;r++){var o=n[r];(o.next||o.onMatch)&&("string"==typeof o.next&&0!==o.next.indexOf(t)&&(o.next=t+o.next),o.nextState&&0!==o.nextState.indexOf(t)&&(o.nextState=t+o.nextState))}this.$rules[t+i]=n}else for(var i in e)this.$rules[i]=e[i]},this.getRules=function(){return this.$rules},this.embedRules=function(e,t,i,n,r){var o="function"==typeof e?(new e).getRules():e;if(n)for(var s=0;s<n.length;s++)n[s]=t+n[s];else for(var a in n=[],o)n.push(t+a);if(this.addRules(o,t),i){var l=Array.prototype[r?"push":"unshift"];for(s=0;s<n.length;s++)l.apply(this.$rules[n[s]],c.deepCopy(i))}this.$embeds||(this.$embeds=[]),this.$embeds.push(t)},this.getEmbeds=function(){return this.$embeds};function g(e,t){return"start"==e&&!t.length||t.unshift(this.nextState,e),this.nextState}function p(e,t){return t.shift(),t.shift()||"start"}this.normalizeRules=function(){var d=0,u=this.$rules;Object.keys(u).forEach(function e(t){var i=u[t];i.processed=!0;for(var n=0;n<i.length;n++){var r=i[n],o=null;Array.isArray(r)&&(o=r,r={}),!r.regex&&r.start&&(r.regex=r.start,r.next||(r.next=[]),r.next.push({defaultToken:r.token},{token:r.token+".end",regex:r.end||r.start,next:"pop"}),r.token=r.token+".start",r.push=!0);var s=r.next||r.push;if(s&&Array.isArray(s)){var a=r.stateName;a||("string"!=typeof(a=r.token)&&(a=a[0]||""),u[a]&&(a+=d++)),u[a]=s,e(r.next=a)}else"pop"==s&&(r.next=p);if(r.push&&(r.nextState=r.next||r.push,r.next=g,delete r.push),r.rules)for(var l in r.rules)u[l]?u[l].push&&u[l].push.apply(u[l],r.rules[l]):u[l]=r.rules[l];var c="string"==typeof r?r:r.include;if(c&&(o=Array.isArray(c)?c.map(function(e){return u[e]}):u[c]),o){var h=[n,1].concat(o);r.noEscape&&(h=h.filter(function(e){return!e.next})),i.splice.apply(i,h),n--}r.keywordMap&&(r.token=this.createKeywordMapper(r.keywordMap,r.defaultToken||"text",r.caseInsensitive),delete r.defaultToken)}},this)},this.createKeywordMapper=function(r,t,o,s){var a=Object.create(null);return Object.keys(r).forEach(function(e){var t=r[e];o&&(t=t.toLowerCase());for(var i=t.split(s||"|"),n=i.length;n--;)a[i[n]]=e}),Object.getPrototypeOf(a)&&(a.__proto__=null),this.$keywordList=Object.keys(a),r=null,o?function(e){return a[e.toLowerCase()]||t}:function(e){return a[e]||t}},this.getKeywords=function(){return this.$keywords}}).call(n.prototype),t.TextHighlightRules=n}),ace.define("ace/mode/behaviour",["require","exports","module"],function(e,t,i){"use strict";function n(){this.$behaviours={}}(function(){this.add=function(e,t,i){switch(void 0){case this.$behaviours:this.$behaviours={};case this.$behaviours[e]:this.$behaviours[e]={}}this.$behaviours[e][t]=i},this.addBehaviours=function(e){for(var t in e)for(var i in e[t])this.add(t,i,e[t][i])},this.remove=function(e){this.$behaviours&&this.$behaviours[e]&&delete this.$behaviours[e]},this.inherit=function(e,t){if("function"==typeof e)var i=(new e).getBehaviours(t);else i=e.getBehaviours(t);this.addBehaviours(i)},this.getBehaviours=function(e){if(e){for(var t={},i=0;i<e.length;i++)this.$behaviours[e[i]]&&(t[e[i]]=this.$behaviours[e[i]]);return t}return this.$behaviours}}).call(n.prototype),t.Behaviour=n}),ace.define("ace/token_iterator",["require","exports","module","ace/range"],function(e,t,i){"use strict";function n(e,t,i){this.$session=e,this.$row=t,this.$rowTokens=e.getTokens(t);var n=e.getTokenAt(t,i);this.$tokenIndex=n?n.index:-1}var r=e("./range").Range;(function(){this.stepBackward=function(){for(this.$tokenIndex-=1;this.$tokenIndex<0;){if(this.$row-=1,this.$row<0)return this.$row=0,null;this.$rowTokens=this.$session.getTokens(this.$row),this.$tokenIndex=this.$rowTokens.length-1}return this.$rowTokens[this.$tokenIndex]},this.stepForward=function(){var e;for(this.$tokenIndex+=1;this.$tokenIndex>=this.$rowTokens.length;){if(this.$row+=1,e=e||this.$session.getLength(),this.$row>=e)return this.$row=e-1,null;this.$rowTokens=this.$session.getTokens(this.$row),this.$tokenIndex=0}return this.$rowTokens[this.$tokenIndex]},this.getCurrentToken=function(){return this.$rowTokens[this.$tokenIndex]},this.getCurrentTokenRow=function(){return this.$row},this.getCurrentTokenColumn=function(){var e=this.$rowTokens,t=this.$tokenIndex,i=e[t].start;if(void 0!==i)return i;for(i=0;0<t;)i+=e[t-=1].value.length;return i},this.getCurrentTokenPosition=function(){return{row:this.$row,column:this.getCurrentTokenColumn()}},this.getCurrentTokenRange=function(){var e=this.$rowTokens[this.$tokenIndex],t=this.getCurrentTokenColumn();return new r(this.$row,t,this.$row,t+e.value.length)}}).call(n.prototype),t.TokenIterator=n}),ace.define("ace/mode/behaviour/cstyle",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator","ace/lib/lang"],function(e,t,i){"use strict";function y(e){var t=-1;if(e.multiSelect&&(t=e.selection.index,l.rangeCount!=e.multiSelect.rangeCount&&(l={rangeCount:e.multiSelect.rangeCount})),l[t])return p=l[t];p=l[t]={autoInsertedBrackets:0,autoInsertedRow:-1,autoInsertedLineEnd:"",maybeInsertedBrackets:0,maybeInsertedRow:-1,maybeInsertedLineStart:"",maybeInsertedLineEnd:""}}function w(e,t,i,n){var r=e.end.row-e.start.row;return{text:i+t+n,selection:[0,e.start.column+1,r,e.end.column+(r?0:1)]}}var p,n=e("../../lib/oop"),r=e("../behaviour").Behaviour,o=e("../../token_iterator").TokenIterator,m=e("../../lib/lang"),s=["text","paren.rparen","rparen","paren","punctuation.operator"],a=["text","paren.rparen","rparen","paren","punctuation.operator","comment"],l={},S={'"':'"',"'":"'"},f=function(g){this.add("braces","insertion",function(e,t,i,n,r){var o=i.getCursorPosition(),s=n.doc.getLine(o.row);if("{"==r){y(i);var a=i.getSelectionRange(),l=n.doc.getTextRange(a);if(""!==l&&"{"!==l&&i.getWrapBehavioursEnabled())return w(a,l,"{","}");if(f.isSaneInsertion(i,n))return/[\]\}\)]/.test(s[o.column])||i.inMultiSelectMode||g&&g.braces?(f.recordAutoInsert(i,n,"}"),{text:"{}",selection:[1,1]}):(f.recordMaybeInsert(i,n,"{"),{text:"{",selection:[1,1]})}else if("}"==r){if(y(i),"}"==s.substring(o.column,o.column+1))if(null!==n.$findOpeningBracket("}",{column:o.column+1,row:o.row})&&f.isAutoInsertedClosing(o,s,r))return f.popAutoInsertedClosing(),{text:"",selection:[1,1]}}else{if("\n"==r||"\r\n"==r){y(i);var c="";if(f.isMaybeInsertedClosing(o,s)&&(c=m.stringRepeat("}",p.maybeInsertedBrackets),f.clearMaybeInsertedClosing()),"}"===s.substring(o.column,o.column+1)){var h=n.findMatchingBracket({row:o.row,column:o.column+1},"}");if(!h)return null;var d=this.$getIndent(n.getLine(h.row))}else{if(!c)return void f.clearMaybeInsertedClosing();d=this.$getIndent(s)}var u=d+n.getTabString();return{text:"\n"+u+"\n"+d+c,selection:[1,u.length,1,u.length]}}f.clearMaybeInsertedClosing()}}),this.add("braces","deletion",function(e,t,i,n,r){var o=n.doc.getTextRange(r);if(!r.isMultiLine()&&"{"==o){if(y(i),"}"==n.doc.getLine(r.start.row).substring(r.end.column,r.end.column+1))return r.end.column++,r;p.maybeInsertedBrackets--}}),this.add("parens","insertion",function(e,t,i,n,r){if("("==r){y(i);var o=i.getSelectionRange(),s=n.doc.getTextRange(o);if(""!==s&&i.getWrapBehavioursEnabled())return w(o,s,"(",")");if(f.isSaneInsertion(i,n))return f.recordAutoInsert(i,n,")"),{text:"()",selection:[1,1]}}else if(")"==r){y(i);var a=i.getCursorPosition(),l=n.doc.getLine(a.row);if(")"==l.substring(a.column,a.column+1))if(null!==n.$findOpeningBracket(")",{column:a.column+1,row:a.row})&&f.isAutoInsertedClosing(a,l,r))return f.popAutoInsertedClosing(),{text:"",selection:[1,1]}}}),this.add("parens","deletion",function(e,t,i,n,r){var o=n.doc.getTextRange(r);if(!r.isMultiLine()&&"("==o&&(y(i),")"==n.doc.getLine(r.start.row).substring(r.start.column+1,r.start.column+2)))return r.end.column++,r}),this.add("brackets","insertion",function(e,t,i,n,r){if("["==r){y(i);var o=i.getSelectionRange(),s=n.doc.getTextRange(o);if(""!==s&&i.getWrapBehavioursEnabled())return w(o,s,"[","]");if(f.isSaneInsertion(i,n))return f.recordAutoInsert(i,n,"]"),{text:"[]",selection:[1,1]}}else if("]"==r){y(i);var a=i.getCursorPosition(),l=n.doc.getLine(a.row);if("]"==l.substring(a.column,a.column+1))if(null!==n.$findOpeningBracket("]",{column:a.column+1,row:a.row})&&f.isAutoInsertedClosing(a,l,r))return f.popAutoInsertedClosing(),{text:"",selection:[1,1]}}}),this.add("brackets","deletion",function(e,t,i,n,r){var o=n.doc.getTextRange(r);if(!r.isMultiLine()&&"["==o&&(y(i),"]"==n.doc.getLine(r.start.row).substring(r.start.column+1,r.start.column+2)))return r.end.column++,r}),this.add("string_dquotes","insertion",function(e,t,i,n,r){var o=n.$mode.$quotes||S;if(1==r.length&&o[r]){if(this.lineCommentStart&&-1!=this.lineCommentStart.indexOf(r))return;y(i);var s=r,a=i.getSelectionRange(),l=n.doc.getTextRange(a);if(!(""===l||1==l.length&&o[l])&&i.getWrapBehavioursEnabled())return w(a,l,s,s);if(!l){var c=i.getCursorPosition(),h=n.doc.getLine(c.row),d=h.substring(c.column-1,c.column),u=h.substring(c.column,c.column+1),g=n.getTokenAt(c.row,c.column),p=n.getTokenAt(c.row,c.column+1);if("\\"==d&&g&&/escape/.test(g.type))return null;var m,f=g&&/string|escape/.test(g.type),C=!p||/string|escape/.test(p.type);if(u==s)(m=f!==C)&&/string\.end/.test(p.type)&&(m=!1);else{if(f&&!C)return null;if(f&&C)return null;var I=n.$mode.tokenRe;I.lastIndex=0;var A=I.test(d);I.lastIndex=0;var v=I.test(d);if(A||v)return null;if(u&&!/[\s;,.})\]\\]/.test(u))return null;var b=h[c.column-2];if(d==s&&(b==s||I.test(b)))return null;m=!0}return{text:m?s+s:"",selection:[1,1]}}}}),this.add("string_dquotes","deletion",function(e,t,i,n,r){var o=n.$mode.$quotes||S,s=n.doc.getTextRange(r);if(!r.isMultiLine()&&o.hasOwnProperty(s)&&(y(i),n.doc.getLine(r.start.row).substring(r.start.column+1,r.start.column+2)==s))return r.end.column++,r})};f.isSaneInsertion=function(e,t){var i=e.getCursorPosition(),n=new o(t,i.row,i.column);if(!this.$matchTokenType(n.getCurrentToken()||"text",s)){if(/[)}\]]/.test(e.session.getLine(i.row)[i.column]))return!0;var r=new o(t,i.row,i.column+1);if(!this.$matchTokenType(r.getCurrentToken()||"text",s))return!1}return n.stepForward(),n.getCurrentTokenRow()!==i.row||this.$matchTokenType(n.getCurrentToken()||"text",a)},f.$matchTokenType=function(e,t){return-1<t.indexOf(e.type||e)},f.recordAutoInsert=function(e,t,i){var n=e.getCursorPosition(),r=t.doc.getLine(n.row);this.isAutoInsertedClosing(n,r,p.autoInsertedLineEnd[0])||(p.autoInsertedBrackets=0),p.autoInsertedRow=n.row,p.autoInsertedLineEnd=i+r.substr(n.column),p.autoInsertedBrackets++},f.recordMaybeInsert=function(e,t,i){var n=e.getCursorPosition(),r=t.doc.getLine(n.row);this.isMaybeInsertedClosing(n,r)||(p.maybeInsertedBrackets=0),p.maybeInsertedRow=n.row,p.maybeInsertedLineStart=r.substr(0,n.column)+i,p.maybeInsertedLineEnd=r.substr(n.column),p.maybeInsertedBrackets++},f.isAutoInsertedClosing=function(e,t,i){return 0<p.autoInsertedBrackets&&e.row===p.autoInsertedRow&&i===p.autoInsertedLineEnd[0]&&t.substr(e.column)===p.autoInsertedLineEnd},f.isMaybeInsertedClosing=function(e,t){return 0<p.maybeInsertedBrackets&&e.row===p.maybeInsertedRow&&t.substr(e.column)===p.maybeInsertedLineEnd&&t.substr(0,e.column)==p.maybeInsertedLineStart},f.popAutoInsertedClosing=function(){p.autoInsertedLineEnd=p.autoInsertedLineEnd.substr(1),p.autoInsertedBrackets--},f.clearMaybeInsertedClosing=function(){p&&(p.maybeInsertedBrackets=0,p.maybeInsertedRow=-1)},n.inherits(f,r),t.CstyleBehaviour=f}),ace.define("ace/unicode",["require","exports","module"],function(e,t,i){"use strict";for(var n=[48,9,8,25,5,0,2,25,48,0,11,0,5,0,6,22,2,30,2,457,5,11,15,4,8,0,2,0,18,116,2,1,3,3,9,0,2,2,2,0,2,19,2,82,2,138,2,4,3,155,12,37,3,0,8,38,10,44,2,0,2,1,2,1,2,0,9,26,6,2,30,10,7,61,2,9,5,101,2,7,3,9,2,18,3,0,17,58,3,100,15,53,5,0,6,45,211,57,3,18,2,5,3,11,3,9,2,1,7,6,2,2,2,7,3,1,3,21,2,6,2,0,4,3,3,8,3,1,3,3,9,0,5,1,2,4,3,11,16,2,2,5,5,1,3,21,2,6,2,1,2,1,2,1,3,0,2,4,5,1,3,2,4,0,8,3,2,0,8,15,12,2,2,8,2,2,2,21,2,6,2,1,2,4,3,9,2,2,2,2,3,0,16,3,3,9,18,2,2,7,3,1,3,21,2,6,2,1,2,4,3,8,3,1,3,2,9,1,5,1,2,4,3,9,2,0,17,1,2,5,4,2,2,3,4,1,2,0,2,1,4,1,4,2,4,11,5,4,4,2,2,3,3,0,7,0,15,9,18,2,2,7,2,2,2,22,2,9,2,4,4,7,2,2,2,3,8,1,2,1,7,3,3,9,19,1,2,7,2,2,2,22,2,9,2,4,3,8,2,2,2,3,8,1,8,0,2,3,3,9,19,1,2,7,2,2,2,22,2,15,4,7,2,2,2,3,10,0,9,3,3,9,11,5,3,1,2,17,4,23,2,8,2,0,3,6,4,0,5,5,2,0,2,7,19,1,14,57,6,14,2,9,40,1,2,0,3,1,2,0,3,0,7,3,2,6,2,2,2,0,2,0,3,1,2,12,2,2,3,4,2,0,2,5,3,9,3,1,35,0,24,1,7,9,12,0,2,0,2,0,5,9,2,35,5,19,2,5,5,7,2,35,10,0,58,73,7,77,3,37,11,42,2,0,4,328,2,3,3,6,2,0,2,3,3,40,2,3,3,32,2,3,3,6,2,0,2,3,3,14,2,56,2,3,3,66,5,0,33,15,17,84,13,619,3,16,2,25,6,74,22,12,2,6,12,20,12,19,13,12,2,2,2,1,13,51,3,29,4,0,5,1,3,9,34,2,3,9,7,87,9,42,6,69,11,28,4,11,5,11,11,39,3,4,12,43,5,25,7,10,38,27,5,62,2,28,3,10,7,9,14,0,89,75,5,9,18,8,13,42,4,11,71,55,9,9,4,48,83,2,2,30,14,230,23,280,3,5,3,37,3,5,3,7,2,0,2,0,2,0,2,30,3,52,2,6,2,0,4,2,2,6,4,3,3,5,5,12,6,2,2,6,67,1,20,0,29,0,14,0,17,4,60,12,5,0,4,11,18,0,5,0,3,9,2,0,4,4,7,0,2,0,2,0,2,3,2,10,3,3,6,4,5,0,53,1,2684,46,2,46,2,132,7,6,15,37,11,53,10,0,17,22,10,6,2,6,2,6,2,6,2,6,2,6,2,6,2,6,2,31,48,0,470,1,36,5,2,4,6,1,5,85,3,1,3,2,2,89,2,3,6,40,4,93,18,23,57,15,513,6581,75,20939,53,1164,68,45,3,268,4,27,21,31,3,13,13,1,2,24,9,69,11,1,38,8,3,102,3,1,111,44,25,51,13,68,12,9,7,23,4,0,5,45,3,35,13,28,4,64,15,10,39,54,10,13,3,9,7,22,4,1,5,66,25,2,227,42,2,1,3,9,7,11171,13,22,5,48,8453,301,3,61,3,105,39,6,13,4,6,11,2,12,2,4,2,0,2,1,2,1,2,107,34,362,19,63,3,53,41,11,5,15,17,6,13,1,25,2,33,4,2,134,20,9,8,25,5,0,2,25,12,88,4,5,3,5,3,5,3,2],r=0,o=[],s=0;s<n.length;s+=2)o.push(r+=n[s]),n[s+1]&&o.push(45,r+=n[s+1]);t.wordChars=String.fromCharCode.apply(null,o)}),ace.define("ace/mode/text",["require","exports","module","ace/config","ace/tokenizer","ace/mode/text_highlight_rules","ace/mode/behaviour/cstyle","ace/unicode","ace/lib/lang","ace/token_iterator","ace/range"],function(e,t,i){"use strict";function n(){this.HighlightRules=o}var s=e("../config"),r=e("../tokenizer").Tokenizer,o=e("./text_highlight_rules").TextHighlightRules,a=e("./behaviour/cstyle").CstyleBehaviour,l=e("../unicode"),b=e("../lib/lang"),m=e("../token_iterator").TokenIterator,f=e("../range").Range;(function(){this.$defaultBehaviour=new a,this.tokenRe=new RegExp("^["+l.wordChars+"\\$_]+","g"),this.nonTokenRe=new RegExp("^(?:[^"+l.wordChars+"\\$_]|\\s])+","g"),this.getTokenizer=function(){return this.$tokenizer||(this.$highlightRules=this.$highlightRules||new this.HighlightRules(this.$highlightRuleConfig),this.$tokenizer=new r(this.$highlightRules.getRules())),this.$tokenizer},this.lineCommentStart="",this.blockComment="",this.toggleCommentLines=function(e,r,i,n){var o=r.doc,s=!0,a=!0,l=1/0,c=r.getTabSize(),t=!1;if(this.lineCommentStart){if(Array.isArray(this.lineCommentStart))p=this.lineCommentStart.map(b.escapeRegExp).join("|"),u=this.lineCommentStart[0];else p=b.escapeRegExp(this.lineCommentStart),u=this.lineCommentStart;p=new RegExp("^(\\s*)(?:"+p+") ?"),t=r.getUseSoftTabs();C=function(e,t){var i=e.match(p);if(i){var n=i[1].length,r=i[0].length;d(e,n,r)||" "!=i[0][r-1]||r--,o.removeInLine(t,n,r)}};var h=u+" ",d=(f=function(e,t){s&&!/\S/.test(e)||(d(e,l,l)?o.insertInLine({row:t,column:l},h):o.insertInLine({row:t,column:l},u))},I=function(e,t){return p.test(e)},function(e,t,i){for(var n=0;t--&&" "==e.charAt(t);)n++;if(n%c!=0)return!1;for(n=0;" "==e.charAt(i++);)n++;return 2<c?n%c!=c-1:n%c==0})}else{if(!this.blockComment)return!1;var u=this.blockComment.start,g=this.blockComment.end,p=new RegExp("^(\\s*)(?:"+b.escapeRegExp(u)+")"),m=new RegExp("(?:"+b.escapeRegExp(g)+")\\s*$"),f=function(e,t){I(e,t)||s&&!/\S/.test(e)||(o.insertInLine({row:t,column:e.length},g),o.insertInLine({row:t,column:l},u))},C=function(e,t){var i;(i=e.match(m))&&o.removeInLine(t,e.length-i[0].length,e.length),(i=e.match(p))&&o.removeInLine(t,i[1].length,i[0].length)},I=function(e,t){if(p.test(e))return!0;for(var i=r.getTokens(t),n=0;n<i.length;n++)if("comment"===i[n].type)return!0}}function A(e){for(var t=i;t<=n;t++)e(o.getLine(t),t)}var v=1/0;A(function(e,t){var i=e.search(/\S/);-1!==i?(i<l&&(l=i),a&&!I(e,t)&&(a=!1)):v>e.length&&(v=e.length)}),l==1/0&&(l=v,a=s=!1),t&&l%c!=0&&(l=Math.floor(l/c)*c),A(a?C:f)},this.toggleBlockComment=function(e,t,i,n){var r=this.blockComment;if(r){!r.start&&r[0]&&(r=r[0]);var o,s,a=(g=new m(t,n.row,n.column)).getCurrentToken(),l=(t.selection,t.selection.toOrientedRange());if(a&&/comment/.test(a.type)){for(var c,h;a&&/comment/.test(a.type);){if(-1!=(p=a.value.indexOf(r.start))){var d=g.getCurrentTokenRow(),u=g.getCurrentTokenColumn()+p;c=new f(d,u,d,u+r.start.length);break}a=g.stepBackward()}var g;for(a=(g=new m(t,n.row,n.column)).getCurrentToken();a&&/comment/.test(a.type);){var p;if(-1!=(p=a.value.indexOf(r.end))){d=g.getCurrentTokenRow(),u=g.getCurrentTokenColumn()+p;h=new f(d,u,d,u+r.end.length);break}a=g.stepForward()}h&&t.remove(h),c&&(t.remove(c),o=c.start.row,s=-r.start.length)}else s=r.start.length,o=i.start.row,t.insert(i.end,r.end),t.insert(i.start,r.start);l.start.row==o&&(l.start.column+=s),l.end.row==o&&(l.end.column+=s),t.selection.fromOrientedRange(l)}},this.getNextLineIndent=function(e,t,i){return this.$getIndent(t)},this.checkOutdent=function(e,t,i){return!1},this.autoOutdent=function(e,t,i){},this.$getIndent=function(e){return e.match(/^\s*/)[0]},this.createWorker=function(e){return null},this.createModeDelegates=function(e){for(var n in this.$embeds=[],this.$modes={},e)if(e[n]){var t=e[n],i=t.prototype.$id,r=s.$modes[i];r||(s.$modes[i]=r=new t),s.$modes[n]||(s.$modes[n]=r),this.$embeds.push(n),this.$modes[n]=r}var o=["toggleBlockComment","toggleCommentLines","getNextLineIndent","checkOutdent","autoOutdent","transformAction","getCompletions"];for(n=0;n<o.length;n++)!function(e){var t=o[n],i=e[t];e[o[n]]=function(){return this.$delegator(t,arguments,i)}}(this)},this.$delegator=function(e,t,i){var n=t[0]||"start";if("string"!=typeof n){if(Array.isArray(n[2])){var r=n[2][n[2].length-1];if(s=this.$modes[r])return s[e].apply(s,[n[1]].concat([].slice.call(t,1)))}n=n[0]||"start"}for(var o=0;o<this.$embeds.length;o++)if(this.$modes[this.$embeds[o]]){var s,a=n.split(this.$embeds[o]);if(!a[0]&&a[1])return t[0]=a[1],(s=this.$modes[this.$embeds[o]])[e].apply(s,t)}var l=i.apply(this,t);return i?l:void 0},this.transformAction=function(e,t,i,n,r){if(this.$behaviour){var o=this.$behaviour.getBehaviours();for(var s in o)if(o[s][t]){var a=o[s][t].apply(this,arguments);if(a)return a}}},this.getKeywords=function(e){if(!this.completionKeywords){var t=this.$tokenizer.rules,i=[];for(var n in t)for(var r=t[n],o=0,s=r.length;o<s;o++)if("string"==typeof r[o].token)/keyword|support|storage/.test(r[o].token)&&i.push(r[o].regex);else if("object"==typeof r[o].token)for(var a=0,l=r[o].token.length;a<l;a++)if(/keyword|support|storage/.test(r[o].token[a])){n=r[o].regex.match(/\(.+?\)/g)[a];i.push(n.substr(1,n.length-2))}this.completionKeywords=i}return e?i.concat(this.$keywordList||[]):this.$keywordList},this.$createKeywordList=function(){return this.$highlightRules||this.getTokenizer(),this.$keywordList=this.$highlightRules.$keywordList||[]},this.getCompletions=function(e,t,i,n){return(this.$keywordList||this.$createKeywordList()).map(function(e){return{name:e,value:e,score:0,meta:"keyword"}})},this.$id="ace/mode/text"}).call(n.prototype),t.Mode=n}),ace.define("ace/apply_delta",["require","exports","module"],function(e,t,i){"use strict";t.applyDelta=function(e,t,i){var n=t.start.row,r=t.start.column,o=e[n]||"";switch(t.action){case"insert":if(1===t.lines.length)e[n]=o.substring(0,r)+t.lines[0]+o.substring(r);else{var s=[n,1].concat(t.lines);e.splice.apply(e,s),e[n]=o.substring(0,r)+e[n],e[n+t.lines.length-1]+=o.substring(r)}break;case"remove":var a=t.end.column,l=t.end.row;n===l?e[n]=o.substring(0,r)+o.substring(a):e.splice(n,l-n+1,o.substring(0,r)+e[l].substring(a))}}}),ace.define("ace/anchor",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(e,t,i){"use strict";var n=e("./lib/oop"),r=e("./lib/event_emitter").EventEmitter,o=t.Anchor=function(e,t,i){this.$onChange=this.onChange.bind(this),this.attach(e),void 0===i?this.setPosition(t.row,t.column):this.setPosition(t,i)};(function(){function l(e,t,i){var n=i?e.column<=t.column:e.column<t.column;return e.row<t.row||e.row==t.row&&n}n.implement(this,r),this.getPosition=function(){return this.$clipPositionToDocument(this.row,this.column)},this.getDocument=function(){return this.document},this.$insertRight=!1,this.onChange=function(e){if(!(e.start.row==e.end.row&&e.start.row!=this.row||e.start.row>this.row)){var t=function(e,t,i){var n="insert"==e.action,r=(n?1:-1)*(e.end.row-e.start.row),o=(n?1:-1)*(e.end.column-e.start.column),s=e.start,a=n?s:e.end;if(l(t,s,i))return{row:t.row,column:t.column};if(l(a,t,!i))return{row:t.row+r,column:t.column+(t.row==a.row?o:0)};return{row:s.row,column:s.column}}(e,{row:this.row,column:this.column},this.$insertRight);this.setPosition(t.row,t.column,!0)}},this.setPosition=function(e,t,i){var n;if(n=i?{row:e,column:t}:this.$clipPositionToDocument(e,t),this.row!=n.row||this.column!=n.column){var r={row:this.row,column:this.column};this.row=n.row,this.column=n.column,this._signal("change",{old:r,value:n})}},this.detach=function(){this.document.removeEventListener("change",this.$onChange)},this.attach=function(e){this.document=e||this.document,this.document.on("change",this.$onChange)},this.$clipPositionToDocument=function(e,t){var i={};return e>=this.document.getLength()?(i.row=Math.max(0,this.document.getLength()-1),i.column=this.document.getLine(i.row).length):e<0?(i.row=0,i.column=0):(i.row=e,i.column=Math.min(this.document.getLine(i.row).length,Math.max(0,t))),t<0&&(i.column=0),i}}).call(o.prototype)}),ace.define("ace/document",["require","exports","module","ace/lib/oop","ace/apply_delta","ace/lib/event_emitter","ace/range","ace/anchor"],function(e,t,i){"use strict";function n(e){this.$lines=[""],0===e.length?this.$lines=[""]:Array.isArray(e)?this.insertMergedLines({row:0,column:0},e):this.insert({row:0,column:0},e)}var r=e("./lib/oop"),o=e("./apply_delta").applyDelta,s=e("./lib/event_emitter").EventEmitter,h=e("./range").Range,a=e("./anchor").Anchor;(function(){r.implement(this,s),this.setValue=function(e){var t=this.getLength()-1;this.remove(new h(0,0,t,this.getLine(t).length)),this.insert({row:0,column:0},e)},this.getValue=function(){return this.getAllLines().join(this.getNewLineCharacter())},this.createAnchor=function(e,t){return new a(this,e,t)},0==="aaa".split(/a/).length?this.$split=function(e){return e.replace(/\r\n|\r/g,"\n").split("\n")}:this.$split=function(e){return e.split(/\r\n|\r|\n/)},this.$detectNewLine=function(e){var t=e.match(/^.*?(\r\n|\r|\n)/m);this.$autoNewLine=t?t[1]:"\n",this._signal("changeNewLineMode")},this.getNewLineCharacter=function(){switch(this.$newLineMode){case"windows":return"\r\n";case"unix":return"\n";default:return this.$autoNewLine||"\n"}},this.$autoNewLine="",this.$newLineMode="auto",this.setNewLineMode=function(e){this.$newLineMode!==e&&(this.$newLineMode=e,this._signal("changeNewLineMode"))},this.getNewLineMode=function(){return this.$newLineMode},this.isNewLine=function(e){return"\r\n"==e||"\r"==e||"\n"==e},this.getLine=function(e){return this.$lines[e]||""},this.getLines=function(e,t){return this.$lines.slice(e,t+1)},this.getAllLines=function(){return this.getLines(0,this.getLength())},this.getLength=function(){return this.$lines.length},this.getTextRange=function(e){return this.getLinesForRange(e).join(this.getNewLineCharacter())},this.getLinesForRange=function(e){var t;if(e.start.row===e.end.row)t=[this.getLine(e.start.row).substring(e.start.column,e.end.column)];else{(t=this.getLines(e.start.row,e.end.row))[0]=(t[0]||"").substring(e.start.column);var i=t.length-1;e.end.row-e.start.row==i&&(t[i]=t[i].substring(0,e.end.column))}return t},this.insertLines=function(e,t){return console.warn("Use of document.insertLines is deprecated. Use the insertFullLines method instead."),this.insertFullLines(e,t)},this.removeLines=function(e,t){return console.warn("Use of document.removeLines is deprecated. Use the removeFullLines method instead."),this.removeFullLines(e,t)},this.insertNewLine=function(e){return console.warn("Use of document.insertNewLine is deprecated. Use insertMergedLines(position, ['', '']) instead."),this.insertMergedLines(e,["",""])},this.insert=function(e,t){return this.getLength()<=1&&this.$detectNewLine(t),this.insertMergedLines(e,this.$split(t))},this.insertInLine=function(e,t){var i=this.clippedPos(e.row,e.column),n=this.pos(e.row,e.column+t.length);return this.applyDelta({start:i,end:n,action:"insert",lines:[t]},!0),this.clonePos(n)},this.clippedPos=function(e,t){var i=this.getLength();void 0===e?e=i:e<0?e=0:i<=e&&(e=i-1,t=void 0);var n=this.getLine(e);return null==t&&(t=n.length),{row:e,column:t=Math.min(Math.max(t,0),n.length)}},this.clonePos=function(e){return{row:e.row,column:e.column}},this.pos=function(e,t){return{row:e,column:t}},this.$clipPosition=function(e){var t=this.getLength();return e.row>=t?(e.row=Math.max(0,t-1),e.column=this.getLine(t-1).length):(e.row=Math.max(0,e.row),e.column=Math.min(Math.max(e.column,0),this.getLine(e.row).length)),e},this.insertFullLines=function(e,t){var i=0;i=(e=Math.min(Math.max(e,0),this.getLength()))<this.getLength()?(t=t.concat([""]),0):(t=[""].concat(t),e--,this.$lines[e].length),this.insertMergedLines({row:e,column:i},t)},this.insertMergedLines=function(e,t){var i=this.clippedPos(e.row,e.column),n={row:i.row+t.length-1,column:(1==t.length?i.column:0)+t[t.length-1].length};return this.applyDelta({start:i,end:n,action:"insert",lines:t}),this.clonePos(n)},this.remove=function(e){var t=this.clippedPos(e.start.row,e.start.column),i=this.clippedPos(e.end.row,e.end.column);return this.applyDelta({start:t,end:i,action:"remove",lines:this.getLinesForRange({start:t,end:i})}),this.clonePos(t)},this.removeInLine=function(e,t,i){var n=this.clippedPos(e,t),r=this.clippedPos(e,i);return this.applyDelta({start:n,end:r,action:"remove",lines:this.getLinesForRange({start:n,end:r})},!0),this.clonePos(n)},this.removeFullLines=function(e,t){e=Math.min(Math.max(0,e),this.getLength()-1);var i=(t=Math.min(Math.max(0,t),this.getLength()-1))==this.getLength()-1&&0<e,n=t<this.getLength()-1,r=i?e-1:e,o=i?this.getLine(r).length:0,s=n?t+1:t,a=n?0:this.getLine(s).length,l=new h(r,o,s,a),c=this.$lines.slice(e,t+1);return this.applyDelta({start:l.start,end:l.end,action:"remove",lines:this.getLinesForRange(l)}),c},this.removeNewLine=function(e){e<this.getLength()-1&&0<=e&&this.applyDelta({start:this.pos(e,this.getLine(e).length),end:this.pos(e+1,0),action:"remove",lines:["",""]})},this.replace=function(e,t){return e instanceof h||(e=h.fromPoints(e.start,e.end)),0===t.length&&e.isEmpty()?e.start:t==this.getTextRange(e)?e.end:(this.remove(e),t?this.insert(e.start,t):e.start)},this.applyDeltas=function(e){for(var t=0;t<e.length;t++)this.applyDelta(e[t])},this.revertDeltas=function(e){for(var t=e.length-1;0<=t;t--)this.revertDelta(e[t])},this.applyDelta=function(e,t){var i="insert"==e.action;(i?e.lines.length<=1&&!e.lines[0]:!h.comparePoints(e.start,e.end))||(i&&2e4<e.lines.length?this.$splitAndapplyLargeDelta(e,2e4):(o(this.$lines,e,t),this._signal("change",e)))},this.$splitAndapplyLargeDelta=function(e,t){for(var i=e.lines,n=i.length-t+1,r=e.start.row,o=e.start.column,s=0,a=0;s<n;s=a){a+=t-1;var l=i.slice(s,a);l.push(""),this.applyDelta({start:this.pos(r+s,o),end:this.pos(r+a,o=0),action:e.action,lines:l},!0)}e.lines=i.slice(s),e.start.row=r+s,e.start.column=o,this.applyDelta(e,!0)},this.revertDelta=function(e){this.applyDelta({start:this.clonePos(e.start),end:this.clonePos(e.end),action:"insert"==e.action?"remove":"insert",lines:e.lines.slice()})},this.indexToPosition=function(e,t){for(var i=this.$lines||this.getAllLines(),n=this.getNewLineCharacter().length,r=t||0,o=i.length;r<o;r++)if((e-=i[r].length+n)<0)return{row:r,column:e+i[r].length+n};return{row:o-1,column:e+i[o-1].length+n}},this.positionToIndex=function(e,t){for(var i=this.$lines||this.getAllLines(),n=this.getNewLineCharacter().length,r=0,o=Math.min(e.row,i.length),s=t||0;s<o;++s)r+=i[s].length+n;return r+e.column}}).call(n.prototype),t.Document=n}),ace.define("ace/background_tokenizer",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(e,t,i){"use strict";function n(e,t){this.running=!1,this.lines=[],this.states=[],this.currentLine=0,this.tokenizer=e;var a=this;this.$worker=function(){if(a.running){for(var e=new Date,t=a.currentLine,i=-1,n=a.doc,r=t;a.lines[t];)t++;var o=n.getLength(),s=0;for(a.running=!1;t<o;){for(a.$tokenizeRow(t),i=t;t++,a.lines[t];);if(++s%5==0&&20<new Date-e){a.running=setTimeout(a.$worker,20);break}}a.currentLine=t,-1==i&&(i=t),r<=i&&a.fireUpdateEvent(r,i)}}}var r=e("./lib/oop"),o=e("./lib/event_emitter").EventEmitter;(function(){r.implement(this,o),this.setTokenizer=function(e){this.tokenizer=e,this.lines=[],this.states=[],this.start(0)},this.setDocument=function(e){this.doc=e,this.lines=[],this.states=[],this.stop()},this.fireUpdateEvent=function(e,t){var i={first:e,last:t};this._signal("update",{data:i})},this.start=function(e){this.currentLine=Math.min(e||0,this.currentLine,this.doc.getLength()),this.lines.splice(this.currentLine,this.lines.length),this.states.splice(this.currentLine,this.states.length),this.stop(),this.running=setTimeout(this.$worker,700)},this.scheduleStart=function(){this.running||(this.running=setTimeout(this.$worker,700))},this.$updateOnChange=function(e){var t=e.start.row,i=e.end.row-t;if(0==i)this.lines[t]=null;else if("remove"==e.action)this.lines.splice(t,1+i,null),this.states.splice(t,1+i,null);else{var n=Array(1+i);n.unshift(t,1),this.lines.splice.apply(this.lines,n),this.states.splice.apply(this.states,n)}this.currentLine=Math.min(t,this.currentLine,this.doc.getLength()),this.stop()},this.stop=function(){this.running&&clearTimeout(this.running),this.running=!1},this.getTokens=function(e){return this.lines[e]||this.$tokenizeRow(e)},this.getState=function(e){return this.currentLine==e&&this.$tokenizeRow(e),this.states[e]||"start"},this.$tokenizeRow=function(e){var t=this.doc.getLine(e),i=this.states[e-1],n=this.tokenizer.getLineTokens(t,i,e);return this.states[e]+""!=n.state+""?(this.states[e]=n.state,this.lines[e+1]=null,this.currentLine>e+1&&(this.currentLine=e+1)):this.currentLine==e&&(this.currentLine=e+1),this.lines[e]=n.tokens}}).call(n.prototype),t.BackgroundTokenizer=n}),ace.define("ace/search_highlight",["require","exports","module","ace/lib/lang","ace/lib/oop","ace/range"],function(e,t,i){"use strict";function n(e,t,i){this.setRegexp(e),this.clazz=t,this.type=i||"text"}var c=e("./lib/lang"),h=(e("./lib/oop"),e("./range").Range);(function(){this.MAX_RANGES=500,this.setRegexp=function(e){this.regExp+""!=e+""&&(this.regExp=e,this.cache=[])},this.update=function(e,t,i,n){if(this.regExp)for(var r=n.firstRow,o=n.lastRow,s=r;s<=o;s++){var a=this.cache[s];null==a&&((a=c.getMatchOffsets(i.getLine(s),this.regExp)).length>this.MAX_RANGES&&(a=a.slice(0,this.MAX_RANGES)),a=a.map(function(e){return new h(s,e.offset,s,e.offset+e.length)}),this.cache[s]=a.length?a:"");for(var l=a.length;l--;)t.drawSingleLineMarker(e,a[l].toScreenRange(i),this.clazz,n)}}}).call(n.prototype),t.SearchHighlight=n}),ace.define("ace/edit_session/fold_line",["require","exports","module","ace/range"],function(e,t,i){"use strict";var n=e("../range").Range;function c(e,t){this.foldData=e,Array.isArray(t)?this.folds=t:t=this.folds=[t];var i=t[t.length-1];this.range=new n(t[0].start.row,t[0].start.column,i.end.row,i.end.column),this.start=this.range.start,this.end=this.range.end,this.folds.forEach(function(e){e.setFoldLine(this)},this)}(function(){this.shiftRow=function(t){this.start.row+=t,this.end.row+=t,this.folds.forEach(function(e){e.start.row+=t,e.end.row+=t})},this.addFold=function(e){if(e.sameRow){if(e.start.row<this.startRow||e.endRow>this.endRow)throw new Error("Can't add a fold to this FoldLine as it has no connection");this.folds.push(e),this.folds.sort(function(e,t){return-e.range.compareEnd(t.start.row,t.start.column)}),0<this.range.compareEnd(e.start.row,e.start.column)?(this.end.row=e.end.row,this.end.column=e.end.column):this.range.compareStart(e.end.row,e.end.column)<0&&(this.start.row=e.start.row,this.start.column=e.start.column)}else if(e.start.row==this.end.row)this.folds.push(e),this.end.row=e.end.row,this.end.column=e.end.column;else{if(e.end.row!=this.start.row)throw new Error("Trying to add fold to FoldRow that doesn't have a matching row");this.folds.unshift(e),this.start.row=e.start.row,this.start.column=e.start.column}e.foldLine=this},this.containsRow=function(e){return e>=this.start.row&&e<=this.end.row},this.walk=function(e,t,i){var n,r,o=0,s=this.folds,a=!0;null==t&&(t=this.end.row,i=this.end.column);for(var l=0;l<s.length;l++){if(-1==(r=(n=s[l]).range.compareStart(t,i)))return void e(null,t,i,o,a);if(!e(null,n.start.row,n.start.column,o,a)&&e(n.placeholder,n.start.row,n.start.column,o)||0===r)return;a=!n.sameRow,o=n.end.column}e(null,t,i,o,a)},this.getNextFoldTo=function(e,t){for(var i,n,r=0;r<this.folds.length;r++){if(-1==(n=(i=this.folds[r]).range.compareEnd(e,t)))return{fold:i,kind:"after"};if(0===n)return{fold:i,kind:"inside"}}return null},this.addRemoveChars=function(e,t,i){var n,r,o=this.getNextFoldTo(e,t);if(o)if(n=o.fold,"inside"==o.kind&&n.start.column!=t&&n.start.row!=e)window.console&&window.console.log(e,t,n);else if(n.start.row==e){var s=(r=this.folds).indexOf(n);for(0===s&&(this.start.column+=i);s<r.length;s++){if((n=r[s]).start.column+=i,!n.sameRow)return;n.end.column+=i}this.end.column+=i}},this.split=function(e,t){var i=this.getNextFoldTo(e,t);if(!i||"inside"==i.kind)return null;var n=i.fold,r=this.folds,o=this.foldData,s=r.indexOf(n),a=r[s-1];this.end.row=a.end.row,this.end.column=a.end.column;var l=new c(o,r=r.splice(s,r.length-s));return o.splice(o.indexOf(this)+1,0,l),l},this.merge=function(e){for(var t=e.folds,i=0;i<t.length;i++)this.addFold(t[i]);var n=this.foldData;n.splice(n.indexOf(e),1)},this.toString=function(){var t=[this.range.toString()+": ["];return this.folds.forEach(function(e){t.push("  "+e.toString())}),t.push("]"),t.join("\n")},this.idxToPosition=function(e){for(var t=0,i=0;i<this.folds.length;i++){var n=this.folds[i];if((e-=n.start.column-t)<0)return{row:n.start.row,column:n.start.column+e};if((e-=n.placeholder.length)<0)return n.start;t=n.end.column}return{row:this.end.row,column:this.end.column+e}}}).call(c.prototype),t.FoldLine=c}),ace.define("ace/range_list",["require","exports","module","ace/range"],function(e,t,i){"use strict";function n(){this.ranges=[],this.$bias=1}var l=e("./range").Range.comparePoints;(function(){this.comparePoints=l,this.pointIndex=function(e,t,i){for(var n=this.ranges,r=i||0;r<n.length;r++){var o=n[r],s=l(e,o.end);if(!(0<s)){var a=l(e,o.start);return 0===s?t&&0!==a?-r-2:r:0<a||0===a&&!t?r:-r-1}}return-r-1},this.add=function(e){var t=!e.isEmpty(),i=this.pointIndex(e.start,t);i<0&&(i=-i-1);var n=this.pointIndex(e.end,t,i);return n<0?n=-n-1:n++,this.ranges.splice(i,n-i,e)},this.addList=function(e){for(var t=[],i=e.length;i--;)t.push.apply(t,this.add(e[i]));return t},this.substractPoint=function(e){var t=this.pointIndex(e);if(0<=t)return this.ranges.splice(t,1)},this.merge=function(){for(var e,t=[],i=this.ranges,n=(i=i.sort(function(e,t){return l(e.start,t.start)}))[0],r=1;r<i.length;r++){e=n,n=i[r];var o=l(e.end,n.start);o<0||(0!=o||e.isEmpty()||n.isEmpty())&&(l(e.end,n.end)<0&&(e.end.row=n.end.row,e.end.column=n.end.column),i.splice(r,1),t.push(n),n=e,r--)}return this.ranges=i,t},this.contains=function(e,t){return 0<=this.pointIndex({row:e,column:t})},this.containsPoint=function(e){return 0<=this.pointIndex(e)},this.rangeAtPoint=function(e){var t=this.pointIndex(e);if(0<=t)return this.ranges[t]},this.clipRows=function(e,t){var i=this.ranges;if(i[0].start.row>t||i[i.length-1].start.row<e)return[];var n=this.pointIndex({row:e,column:0});n<0&&(n=-n-1);var r=this.pointIndex({row:t,column:0},n);r<0&&(r=-r-1);for(var o=[],s=n;s<r;s++)o.push(i[s]);return o},this.removeAll=function(){return this.ranges.splice(0,this.ranges.length)},this.attach=function(e){this.session&&this.detach(),this.session=e,this.onChange=this.$onChange.bind(this),this.session.on("change",this.onChange)},this.detach=function(){this.session&&(this.session.removeListener("change",this.onChange),this.session=null)},this.$onChange=function(e){for(var t=e.start,i=e.end,n=t.row,r=i.row,o=this.ranges,s=0,a=o.length;s<a;s++){if((h=o[s]).end.row>=n)break}if("insert"==e.action)for(var l=r-n,c=-t.column+i.column;s<a;s++){if((h=o[s]).start.row>n)break;if(h.start.row==n&&h.start.column>=t.column&&(h.start.column==t.column&&this.$bias<=0||(h.start.column+=c,h.start.row+=l)),h.end.row==n&&h.end.column>=t.column){if(h.end.column==t.column&&this.$bias<0)continue;h.end.column==t.column&&0<c&&s<a-1&&h.end.column>h.start.column&&h.end.column==o[s+1].start.column&&(h.end.column-=c),h.end.column+=c,h.end.row+=l}}else for(l=n-r,c=t.column-i.column;s<a;s++){if((h=o[s]).start.row>r)break;h.end.row<r&&(n<h.end.row||n==h.end.row&&t.column<h.end.column)?(h.end.row=n,h.end.column=t.column):h.end.row==r?h.end.column<=i.column?(l||h.end.column>t.column)&&(h.end.column=t.column,h.end.row=t.row):(h.end.column+=c,h.end.row+=l):h.end.row>r&&(h.end.row+=l),h.start.row<r&&(n<h.start.row||n==h.start.row&&t.column<h.start.column)?(h.start.row=n,h.start.column=t.column):h.start.row==r?h.start.column<=i.column?(l||h.start.column>t.column)&&(h.start.column=t.column,h.start.row=t.row):(h.start.column+=c,h.start.row+=l):h.start.row>r&&(h.start.row+=l)}if(0!=l&&s<a)for(;s<a;s++){var h;(h=o[s]).start.row+=l,h.end.row+=l}}}).call(n.prototype),t.RangeList=n}),ace.define("ace/edit_session/fold",["require","exports","module","ace/range_list","ace/lib/oop"],function(e,t,i){"use strict";var n=e("../range_list").RangeList,r=e("../lib/oop"),o=t.Fold=function(e,t){this.foldLine=null,this.placeholder=t,this.range=e,this.start=e.start,this.end=e.end,this.sameRow=e.start.row==e.end.row,this.subFolds=this.ranges=[]};function d(e,t){e.row-=t.row,0==e.row&&(e.column-=t.column)}function s(e,t){0==e.row&&(e.column+=t.column),e.row+=t.row}r.inherits(o,n),function(){this.toString=function(){return'"'+this.placeholder+'" '+this.range.toString()},this.setFoldLine=function(t){this.foldLine=t,this.subFolds.forEach(function(e){e.setFoldLine(t)})},this.clone=function(){var e=this.range.clone(),t=new o(e,this.placeholder);return this.subFolds.forEach(function(e){t.subFolds.push(e.clone())}),t.collapseChildren=this.collapseChildren,t},this.addSubFold=function(e){if(!this.range.isEqual(e)){!function(e,t){d(e.start,t),d(e.end,t)}(e,this.start);for(var t=e.start.row,i=e.start.column,n=0,r=-1;n<this.subFolds.length&&1==(r=this.subFolds[n].range.compare(t,i));n++);var o=this.subFolds[n],s=0;if(0==r){if(o.range.containsRange(e))return o.addSubFold(e);s=1}t=e.range.end.row,i=e.range.end.column;var a=n;for(r=-1;a<this.subFolds.length&&1==(r=this.subFolds[a].range.compare(t,i));a++);0==r&&a++;for(var l=this.subFolds.splice(n,a-n,e),c=0==r?l.length-1:l.length,h=s;h<c;h++)e.addSubFold(l[h]);return e.setFoldLine(this.foldLine),e}},this.restoreRange=function(e){return function(e,t){s(e.start,t),s(e.end,t)}(e,this.start)}}.call(o.prototype)}),ace.define("ace/edit_session/folding",["require","exports","module","ace/range","ace/edit_session/fold_line","ace/edit_session/fold","ace/token_iterator"],function(e,t,i){"use strict";var h=e("../range").Range,m=e("./fold_line").FoldLine,f=e("./fold").Fold,d=e("../token_iterator").TokenIterator;t.Folding=function(){this.getFoldAt=function(e,t,i){var n=this.getFoldLine(e);if(!n)return null;for(var r=n.folds,o=0;o<r.length;o++){var s=r[o].range;if(s.contains(e,t)){if(1==i&&s.isEnd(e,t)&&!s.isEmpty())continue;if(-1==i&&s.isStart(e,t)&&!s.isEmpty())continue;return r[o]}}},this.getFoldsInRange=function(e){var t=e.start,i=e.end,n=this.$foldData,r=[];t.column+=1,i.column-=1;for(var o=0;o<n.length;o++){var s=n[o].range.compareRange(e);if(2!=s){if(-2==s)break;for(var a=n[o].folds,l=0;l<a.length;l++){var c=a[l];if(-2==(s=c.range.compareRange(e)))break;if(2!=s){if(42==s)break;r.push(c)}}}}return t.column-=1,i.column+=1,r},this.getFoldsInRangeList=function(e){if(Array.isArray(e)){var t=[];e.forEach(function(e){t=t.concat(this.getFoldsInRange(e))},this)}else t=this.getFoldsInRange(e);return t},this.getAllFolds=function(){for(var e=[],t=this.$foldData,i=0;i<t.length;i++)for(var n=0;n<t[i].folds.length;n++)e.push(t[i].folds[n]);return e},this.getFoldStringAt=function(e,t,i,n){if(!(n=n||this.getFoldLine(e)))return null;for(var r,o,s={end:{column:0}},a=0;a<n.folds.length;a++){var l=(o=n.folds[a]).range.compareEnd(e,t);if(-1==l){r=this.getLine(o.start.row).substring(s.end.column,o.start.column);break}if(0===l)return null;s=o}return r=r||this.getLine(o.start.row).substring(s.end.column),-1==i?r.substring(0,t-s.end.column):1==i?r.substring(t-s.end.column):r},this.getFoldLine=function(e,t){var i=this.$foldData,n=0;for(t&&(n=i.indexOf(t)),-1==n&&(n=0);n<i.length;n++){var r=i[n];if(r.start.row<=e&&r.end.row>=e)return r;if(r.end.row>e)return null}return null},this.getNextFoldLine=function(e,t){var i=this.$foldData,n=0;for(t&&(n=i.indexOf(t)),-1==n&&(n=0);n<i.length;n++){var r=i[n];if(r.end.row>=e)return r}return null},this.getFoldedRowCount=function(e,t){for(var i=this.$foldData,n=t-e+1,r=0;r<i.length;r++){var o=i[r],s=o.end.row,a=o.start.row;if(t<=s){a<t&&(e<=a?n-=t-a:n=0);break}e<=s&&(n-=e<=a?s-a:s-e+1)}return n},this.$addFoldLine=function(e){return this.$foldData.push(e),this.$foldData.sort(function(e,t){return e.start.row-t.start.row}),e},this.addFold=function(e,t){var i,n=this.$foldData,r=!1;e instanceof f?i=e:(i=new f(t,e)).collapseChildren=t.collapseChildren,this.$clipRangeToDocument(i.range);var o=i.start.row,s=i.start.column,a=i.end.row,l=i.end.column,c=this.getFoldAt(o,s,1),h=this.getFoldAt(a,l,-1);if(c&&h==c)return c.addSubFold(i);c&&!c.range.isStart(o,s)&&this.removeFold(c),h&&!h.range.isEnd(a,l)&&this.removeFold(h);var d=this.getFoldsInRange(i.range);0<d.length&&(this.removeFolds(d),d.forEach(function(e){i.addSubFold(e)}));for(var u=0;u<n.length;u++){var g=n[u];if(a==g.start.row){g.addFold(i),r=!0;break}if(o==g.end.row){if(g.addFold(i),r=!0,!i.sameRow){var p=n[u+1];if(p&&p.start.row==a){g.merge(p);break}}break}if(a<=g.start.row)break}return r||(g=this.$addFoldLine(new m(this.$foldData,i))),this.$useWrapMode?this.$updateWrapData(g.start.row,g.start.row):this.$updateRowLengthCache(g.start.row,g.start.row),this.$modified=!0,this._signal("changeFold",{data:i,action:"add"}),i},this.addFolds=function(e){e.forEach(function(e){this.addFold(e)},this)},this.removeFold=function(e){var t=e.foldLine,i=t.start.row,n=t.end.row,r=this.$foldData,o=t.folds;if(1==o.length)r.splice(r.indexOf(t),1);else if(t.range.isEnd(e.end.row,e.end.column))o.pop(),t.end.row=o[o.length-1].end.row,t.end.column=o[o.length-1].end.column;else if(t.range.isStart(e.start.row,e.start.column))o.shift(),t.start.row=o[0].start.row,t.start.column=o[0].start.column;else if(e.sameRow)o.splice(o.indexOf(e),1);else{var s=t.split(e.start.row,e.start.column);(o=s.folds).shift(),s.start.row=o[0].start.row,s.start.column=o[0].start.column}this.$updating||(this.$useWrapMode?this.$updateWrapData(i,n):this.$updateRowLengthCache(i,n)),this.$modified=!0,this._signal("changeFold",{data:e,action:"remove"})},this.removeFolds=function(e){for(var t=[],i=0;i<e.length;i++)t.push(e[i]);t.forEach(function(e){this.removeFold(e)},this),this.$modified=!0},this.expandFold=function(t){this.removeFold(t),t.subFolds.forEach(function(e){t.restoreRange(e),this.addFold(e)},this),0<t.collapseChildren&&this.foldAll(t.start.row+1,t.end.row,t.collapseChildren-1),t.subFolds=[]},this.expandFolds=function(e){e.forEach(function(e){this.expandFold(e)},this)},this.unfold=function(e,t){var i,n;if(null==e?(i=new h(0,0,this.getLength(),0),t=!0):i="number"==typeof e?new h(e,0,e,this.getLine(e).length):"row"in e?h.fromPoints(e,e):e,n=this.getFoldsInRangeList(i),t)this.removeFolds(n);else for(var r=n;r.length;)this.expandFolds(r),r=this.getFoldsInRangeList(i);if(n.length)return n},this.isRowFolded=function(e,t){return!!this.getFoldLine(e,t)},this.getRowFoldEnd=function(e,t){var i=this.getFoldLine(e,t);return i?i.end.row:e},this.getRowFoldStart=function(e,t){var i=this.getFoldLine(e,t);return i?i.start.row:e},this.getFoldDisplayLine=function(e,t,i,r,o){null==r&&(r=e.start.row),null==o&&(o=0),null==t&&(t=e.end.row),null==i&&(i=this.getLine(t).length);var s=this.doc,a="";return e.walk(function(e,t,i,n){if(!(t<r)){if(t==r){if(i<o)return;n=Math.max(o,n)}a+=null!=e?e:s.getLine(t).substring(n,i)}},t,i),a},this.getDisplayLine=function(e,t,i,n){var r,o=this.getFoldLine(e);return o?this.getFoldDisplayLine(o,e,t,i,n):(r=this.doc.getLine(e)).substring(n||0,t||r.length)},this.$cloneFoldData=function(){var i=[];return i=this.$foldData.map(function(e){var t=e.folds.map(function(e){return e.clone()});return new m(i,t)})},this.toggleFold=function(e){var t,i,n=this.selection.getRange();if(n.isEmpty()){var r=n.start;if(t=this.getFoldAt(r.row,r.column))return void this.expandFold(t);(i=this.findMatchingBracket(r))?1==n.comparePoint(i)?n.end=i:(n.start=i,n.start.column++,n.end.column--):(i=this.findMatchingBracket({row:r.row,column:r.column+1}))?(1==n.comparePoint(i)?n.end=i:n.start=i,n.start.column++):n=this.getCommentFoldRange(r.row,r.column)||n}else{var o=this.getFoldsInRange(n);if(e&&o.length)return void this.expandFolds(o);1==o.length&&(t=o[0])}if((t=t||this.getFoldAt(n.start.row,n.start.column))&&t.range.toString()==n.toString())this.expandFold(t);else{var s="...";if(!n.isMultiLine()){if((s=this.getTextRange(n)).length<4)return;s=s.trim().substring(0,2)+".."}this.addFold(s,n)}},this.getCommentFoldRange=function(e,t,i){var n=new d(this,e,t),r=n.getCurrentToken(),o=r.type;if(r&&/^comment|string/.test(o)){"comment"==(o=o.match(/comment|string/)[0])&&(o+="|doc-start");var s=new RegExp(o),a=new h;if(1!=i){for(;(r=n.stepBackward())&&s.test(r.type););n.stepForward()}if(a.start.row=n.getCurrentTokenRow(),a.start.column=n.getCurrentTokenColumn()+2,n=new d(this,e,t),-1!=i){var l=-1;do{if(r=n.stepForward(),-1==l){var c=this.getState(n.$row);s.test(c)||(l=n.$row)}else if(n.$row>l)break}while(r&&s.test(r.type));r=n.stepBackward()}else r=n.getCurrentToken();return a.end.row=n.getCurrentTokenRow(),a.end.column=n.getCurrentTokenColumn()+r.value.length-2,a}},this.foldAll=function(e,t,i){null==i&&(i=1e5);var n=this.foldWidgets;if(n){t=t||this.getLength();for(var r=e=e||0;r<t;r++)if(null==n[r]&&(n[r]=this.getFoldWidget(r)),"start"==n[r]){var o=this.getFoldWidgetRange(r);if(o&&o.isMultiLine()&&o.end.row<=t&&o.start.row>=e){r=o.end.row;try{var s=this.addFold("...",o);s&&(s.collapseChildren=i)}catch(e){}}}}},this.$foldStyles={manual:1,markbegin:1,markbeginend:1},this.$foldStyle="markbegin",this.setFoldStyle=function(e){if(!this.$foldStyles[e])throw new Error("invalid fold style: "+e+"["+Object.keys(this.$foldStyles).join(", ")+"]");if(this.$foldStyle!=e){"manual"==(this.$foldStyle=e)&&this.unfold();var t=this.$foldMode;this.$setFolding(null),this.$setFolding(t)}},this.$setFolding=function(e){this.$foldMode!=e&&(this.$foldMode=e,this.off("change",this.$updateFoldWidgets),this.off("tokenizerUpdate",this.$tokenizerUpdateFoldWidgets),this._signal("changeAnnotation"),e&&"manual"!=this.$foldStyle?(this.foldWidgets=[],this.getFoldWidget=e.getFoldWidget.bind(e,this,this.$foldStyle),this.getFoldWidgetRange=e.getFoldWidgetRange.bind(e,this,this.$foldStyle),this.$updateFoldWidgets=this.updateFoldWidgets.bind(this),this.$tokenizerUpdateFoldWidgets=this.tokenizerUpdateFoldWidgets.bind(this),this.on("change",this.$updateFoldWidgets),this.on("tokenizerUpdate",this.$tokenizerUpdateFoldWidgets)):this.foldWidgets=null)},this.getParentFoldRangeData=function(e,t){var i=this.foldWidgets;if(!i||t&&i[e])return{};for(var n,r=e-1;0<=r;){var o=i[r];if(null==o&&(o=i[r]=this.getFoldWidget(r)),"start"==o){var s=this.getFoldWidgetRange(r);if(n=n||s,s&&s.end.row>=e)break}r--}return{range:-1!==r&&s,firstRange:n}},this.onFoldWidgetClick=function(e,t){var i={children:(t=t.domEvent).shiftKey,all:t.ctrlKey||t.metaKey,siblings:t.altKey};if(!this.$toggleFoldWidget(e,i)){var n=t.target||t.srcElement;n&&/ace_fold-widget/.test(n.className)&&(n.className+=" ace_invalid")}},this.$toggleFoldWidget=function(e,t){if(this.getFoldWidget){var i=this.getFoldWidget(e),n=this.getLine(e),r="end"===i?-1:1,o=this.getFoldAt(e,-1==r?0:n.length,r);if(o)return t.children||t.all?this.removeFold(o):this.expandFold(o),o;var s=this.getFoldWidgetRange(e,!0);if(s&&!s.isMultiLine()&&(o=this.getFoldAt(s.start.row,s.start.column,1))&&s.isEqual(o.range))return this.removeFold(o),o;if(t.siblings){var a=this.getParentFoldRangeData(e);if(a.range)var l=a.range.start.row+1,c=a.range.end.row;this.foldAll(l,c,t.all?1e4:0)}else t.children?(c=s?s.end.row:this.getLength(),this.foldAll(e+1,c,t.all?1e4:0)):s&&(t.all&&(s.collapseChildren=1e4),this.addFold("...",s));return s}},this.toggleFoldWidget=function(e){var t=this.selection.getCursor().row;t=this.getRowFoldStart(t);var i=this.$toggleFoldWidget(t,{});if(!i){var n=this.getParentFoldRangeData(t,!0);if(i=n.range||n.firstRange){t=i.start.row;var r=this.getFoldAt(t,this.getLine(t).length,1);r?this.removeFold(r):this.addFold("...",i)}}},this.updateFoldWidgets=function(e){var t=e.start.row,i=e.end.row-t;if(0==i)this.foldWidgets[t]=null;else if("remove"==e.action)this.foldWidgets.splice(t,1+i,
null);else{var n=Array(1+i);n.unshift(t,1),this.foldWidgets.splice.apply(this.foldWidgets,n)}},this.tokenizerUpdateFoldWidgets=function(e){var t=e.data;t.first!=t.last&&this.foldWidgets.length>t.first&&this.foldWidgets.splice(t.first,this.foldWidgets.length)}}}),ace.define("ace/edit_session/bracket_match",["require","exports","module","ace/token_iterator","ace/range"],function(e,t,i){"use strict";var d=e("../token_iterator").TokenIterator,a=e("../range").Range;t.BracketMatch=function(){this.findMatchingBracket=function(e,t){if(0==e.column)return null;var i=t||this.getLine(e.row).charAt(e.column-1);if(""==i)return null;var n=i.match(/([\(\[\{])|([\)\]\}])/);return n?n[1]?this.$findClosingBracket(n[1],e):this.$findOpeningBracket(n[2],e):null},this.getBracketRange=function(e){var t,i=this.getLine(e.row),n=!0,r=i.charAt(e.column-1),o=r&&r.match(/([\(\[\{])|([\)\]\}])/);if(o||(r=i.charAt(e.column),e={row:e.row,column:e.column+1},o=r&&r.match(/([\(\[\{])|([\)\]\}])/),n=!1),!o)return null;if(o[1]){if(!(s=this.$findClosingBracket(o[1],e)))return null;t=a.fromPoints(e,s),n||(t.end.column++,t.start.column--),t.cursor=t.end}else{var s;if(!(s=this.$findOpeningBracket(o[2],e)))return null;t=a.fromPoints(s,e),n||(t.start.column++,t.end.column--),t.cursor=t.start}return t},this.$brackets={")":"(","(":")","]":"[","[":"]","{":"}","}":"{","<":">",">":"<"},this.$findOpeningBracket=function(e,t,i){var n=this.$brackets[e],r=1,o=new d(this,t.row,t.column),s=o.getCurrentToken();if(s=s||o.stepForward()){i=i||new RegExp("(\\.?"+s.type.replace(".","\\.").replace("rparen",".paren").replace(/\b(?:end)\b/,"(?:start|begin|end)")+")+");for(var a=t.column-o.getCurrentTokenColumn()-2,l=s.value;;){for(;0<=a;){var c=l.charAt(a);if(c==n){if(0==(r-=1))return{row:o.getCurrentTokenRow(),column:a+o.getCurrentTokenColumn()}}else c==e&&(r+=1);a-=1}for(;(s=o.stepBackward())&&!i.test(s.type););if(null==s)break;a=(l=s.value).length-1}return null}},this.$findClosingBracket=function(e,t,i){var n=this.$brackets[e],r=1,o=new d(this,t.row,t.column),s=o.getCurrentToken();if(s=s||o.stepForward()){i=i||new RegExp("(\\.?"+s.type.replace(".","\\.").replace("lparen",".paren").replace(/\b(?:start|begin)\b/,"(?:start|begin|end)")+")+");for(var a=t.column-o.getCurrentTokenColumn();;){for(var l=s.value,c=l.length;a<c;){var h=l.charAt(a);if(h==n){if(0==(r-=1))return{row:o.getCurrentTokenRow(),column:a+o.getCurrentTokenColumn()}}else h==e&&(r+=1);a+=1}for(;(s=o.stepForward())&&!i.test(s.type););if(null==s)break;a=0}return null}}}}),ace.define("ace/edit_session",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/bidihandler","ace/config","ace/lib/event_emitter","ace/selection","ace/mode/text","ace/range","ace/document","ace/background_tokenizer","ace/search_highlight","ace/edit_session/folding","ace/edit_session/bracket_match"],function(e,t,i){"use strict";var n=e("./lib/oop"),r=e("./lib/lang"),o=e("./bidihandler").BidiHandler,s=e("./config"),l=e("./lib/event_emitter").EventEmitter,a=e("./selection").Selection,c=e("./mode/text").Mode,h=e("./range").Range,d=e("./document").Document,u=e("./background_tokenizer").BackgroundTokenizer,g=e("./search_highlight").SearchHighlight,p=function(e,t){this.$breakpoints=[],this.$decorations=[],this.$frontMarkers={},this.$backMarkers={},this.$markerId=1,this.$undoSelect=!0,this.$foldData=[],this.id="session"+ ++p.$uid,this.$foldData.toString=function(){return this.join("\n")},this.on("changeFold",this.onChangeFold.bind(this)),this.$onChange=this.onChange.bind(this),"object"==typeof e&&e.getLine||(e=new d(e)),this.setDocument(e),this.selection=new a(this),this.$bidiHandler=new o(this),s.resetOptions(this),this.setMode(t),s._signal("session",this)};p.$uid=0,function(){n.implement(this,l),this.setDocument=function(e){this.doc&&this.doc.removeListener("change",this.$onChange),(this.doc=e).on("change",this.$onChange),this.bgTokenizer&&this.bgTokenizer.setDocument(this.getDocument()),this.resetCaches()},this.getDocument=function(){return this.doc},this.$resetRowCache=function(e){if(!e)return this.$docRowCache=[],void(this.$screenRowCache=[]);var t=this.$docRowCache.length,i=this.$getRowCacheIndex(this.$docRowCache,e)+1;i<t&&(this.$docRowCache.splice(i,t),this.$screenRowCache.splice(i,t))},this.$getRowCacheIndex=function(e,t){for(var i=0,n=e.length-1;i<=n;){var r=i+n>>1,o=e[r];if(o<t)i=1+r;else{if(!(t<o))return r;n=r-1}}return i-1},this.resetCaches=function(){this.$modified=!0,this.$wrapData=[],this.$rowLengthCache=[],this.$resetRowCache(0),this.bgTokenizer&&this.bgTokenizer.start(0)},this.onChangeFold=function(e){var t=e.data;this.$resetRowCache(t.start.row)},this.onChange=function(e){this.$modified=!0,this.$bidiHandler.onChange(e),this.$resetRowCache(e.start.row);var t=this.$updateInternalDataOnChange(e);!this.$fromUndo&&this.$undoManager&&(t&&t.length&&(this.$undoManager.add({action:"removeFolds",folds:t},this.mergeUndoDeltas),this.mergeUndoDeltas=!0),this.$undoManager.add(e,this.mergeUndoDeltas),this.mergeUndoDeltas=!0,this.$informUndoManager.schedule()),this.bgTokenizer&&this.bgTokenizer.$updateOnChange(e),this._signal("change",e)},this.setValue=function(e){this.doc.setValue(e),this.selection.moveTo(0,0),this.$resetRowCache(0),this.setUndoManager(this.$undoManager),this.getUndoManager().reset()},this.getValue=this.toString=function(){return this.doc.getValue()},this.getSelection=function(){return this.selection},this.getState=function(e){return this.bgTokenizer.getState(e)},this.getTokens=function(e){return this.bgTokenizer.getTokens(e)},this.getTokenAt=function(e,t){var i,n=this.bgTokenizer.getTokens(e),r=0;if(null==t){var o=n.length-1;r=this.getLine(e).length}else for(o=0;o<n.length&&!(t<=(r+=n[o].value.length));o++);return(i=n[o])?(i.index=o,i.start=r-i.value.length,i):null},this.setUndoManager=function(e){if(this.$undoManager=e,this.$informUndoManager&&this.$informUndoManager.cancel(),e){var t=this;e.addSession(this),this.$syncInformUndoManager=function(){t.$informUndoManager.cancel(),t.mergeUndoDeltas=!1},this.$informUndoManager=r.delayedCall(this.$syncInformUndoManager)}else this.$syncInformUndoManager=function(){}},this.markUndoGroup=function(){this.$syncInformUndoManager&&this.$syncInformUndoManager()},this.$defaultUndoManager={undo:function(){},redo:function(){},hasUndo:function(){},hasRedo:function(){},reset:function(){},add:function(){},addSelection:function(){},startNewGroup:function(){},addSession:function(){}},this.getUndoManager=function(){return this.$undoManager||this.$defaultUndoManager},this.getTabString=function(){return this.getUseSoftTabs()?r.stringRepeat(" ",this.getTabSize()):"\t"},this.setUseSoftTabs=function(e){this.setOption("useSoftTabs",e)},this.getUseSoftTabs=function(){return this.$useSoftTabs&&!this.$mode.$indentWithTabs},this.setTabSize=function(e){this.setOption("tabSize",e)},this.getTabSize=function(){return this.$tabSize},this.isTabStop=function(e){return this.$useSoftTabs&&e.column%this.$tabSize==0},this.setNavigateWithinSoftTabs=function(e){this.setOption("navigateWithinSoftTabs",e)},this.getNavigateWithinSoftTabs=function(){return this.$navigateWithinSoftTabs},this.$overwrite=!1,this.setOverwrite=function(e){this.setOption("overwrite",e)},this.getOverwrite=function(){return this.$overwrite},this.toggleOverwrite=function(){this.setOverwrite(!this.$overwrite)},this.addGutterDecoration=function(e,t){this.$decorations[e]||(this.$decorations[e]=""),this.$decorations[e]+=" "+t,this._signal("changeBreakpoint",{})},this.removeGutterDecoration=function(e,t){this.$decorations[e]=(this.$decorations[e]||"").replace(" "+t,""),this._signal("changeBreakpoint",{})},this.getBreakpoints=function(){return this.$breakpoints},this.setBreakpoints=function(e){this.$breakpoints=[];for(var t=0;t<e.length;t++)this.$breakpoints[e[t]]="ace_breakpoint";this._signal("changeBreakpoint",{})},this.clearBreakpoints=function(){this.$breakpoints=[],this._signal("changeBreakpoint",{})},this.setBreakpoint=function(e,t){void 0===t&&(t="ace_breakpoint"),t?this.$breakpoints[e]=t:delete this.$breakpoints[e],this._signal("changeBreakpoint",{})},this.clearBreakpoint=function(e){delete this.$breakpoints[e],this._signal("changeBreakpoint",{})},this.addMarker=function(e,t,i,n){var r=this.$markerId++,o={range:e,type:i||"line",renderer:"function"==typeof i?i:null,clazz:t,inFront:!!n,id:r};return n?(this.$frontMarkers[r]=o,this._signal("changeFrontMarker")):(this.$backMarkers[r]=o,this._signal("changeBackMarker")),r},this.addDynamicMarker=function(e,t){if(e.update){var i=this.$markerId++;return e.id=i,e.inFront=!!t,t?(this.$frontMarkers[i]=e,this._signal("changeFrontMarker")):(this.$backMarkers[i]=e,this._signal("changeBackMarker")),e}},this.removeMarker=function(e){var t=this.$frontMarkers[e]||this.$backMarkers[e];t&&(delete(t.inFront?this.$frontMarkers:this.$backMarkers)[e],this._signal(t.inFront?"changeFrontMarker":"changeBackMarker"))},this.getMarkers=function(e){return e?this.$frontMarkers:this.$backMarkers},this.highlight=function(e){if(!this.$searchHighlight){var t=new g(null,"ace_selected-word","text");this.$searchHighlight=this.addDynamicMarker(t)}this.$searchHighlight.setRegexp(e)},this.highlightLines=function(e,t,i,n){"number"!=typeof t&&(i=t,t=e),i=i||"ace_step";var r=new h(e,0,t,1/0);return r.id=this.addMarker(r,i,"fullLine",n),r},this.setAnnotations=function(e){this.$annotations=e,this._signal("changeAnnotation",{})},this.getAnnotations=function(){return this.$annotations||[]},this.clearAnnotations=function(){this.setAnnotations([])},this.$detectNewLine=function(e){var t=e.match(/^.*?(\r?\n)/m);this.$autoNewLine=t?t[1]:"\n"},this.getWordRange=function(e,t){var i=this.getLine(e),n=!1;if(0<t&&(n=!!i.charAt(t-1).match(this.tokenRe)),n=n||!!i.charAt(t).match(this.tokenRe))var r=this.tokenRe;else if(/^\s+$/.test(i.slice(t-1,t+1)))r=/\s/;else r=this.nonTokenRe;var o=t;if(0<o){for(;0<=--o&&i.charAt(o).match(r););o++}for(var s=t;s<i.length&&i.charAt(s).match(r);)s++;return new h(e,o,e,s)},this.getAWordRange=function(e,t){for(var i=this.getWordRange(e,t),n=this.getLine(i.end.row);n.charAt(i.end.column).match(/[ \t]/);)i.end.column+=1;return i},this.setNewLineMode=function(e){this.doc.setNewLineMode(e)},this.getNewLineMode=function(){return this.doc.getNewLineMode()},this.setUseWorker=function(e){this.setOption("useWorker",e)},this.getUseWorker=function(){return this.$useWorker},this.onReloadTokenizer=function(e){var t=e.data;this.bgTokenizer.start(t.first),this._signal("tokenizerUpdate",e)},this.$modes=s.$modes,this.$mode=null,this.$modeId=null,this.setMode=function(e,t){if(e&&"object"==typeof e){if(e.getTokenizer)return this.$onChangeMode(e);var i=e,n=i.path}else n=e||"ace/mode/text";if(this.$modes["ace/mode/text"]||(this.$modes["ace/mode/text"]=new c),this.$modes[n]&&!i)return this.$onChangeMode(this.$modes[n]),void(t&&t());this.$modeId=n,s.loadModule(["mode",n],function(e){if(this.$modeId!==n)return t&&t();this.$modes[n]&&!i?this.$onChangeMode(this.$modes[n]):e&&e.Mode&&(e=new e.Mode(i),i||((this.$modes[n]=e).$id=n),this.$onChangeMode(e)),t&&t()}.bind(this)),this.$mode||this.$onChangeMode(this.$modes["ace/mode/text"],!0)},this.$onChangeMode=function(e,t){if(t||(this.$modeId=e.$id),this.$mode!==e){this.$mode=e,this.$stopWorker(),this.$useWorker&&this.$startWorker();var i=e.getTokenizer();if(void 0!==i.addEventListener){var n=this.onReloadTokenizer.bind(this);i.addEventListener("update",n)}if(this.bgTokenizer)this.bgTokenizer.setTokenizer(i);else{this.bgTokenizer=new u(i);var r=this;this.bgTokenizer.addEventListener("update",function(e){r._signal("tokenizerUpdate",e)})}this.bgTokenizer.setDocument(this.getDocument()),this.tokenRe=e.tokenRe,this.nonTokenRe=e.nonTokenRe,t||(e.attachToSession&&e.attachToSession(this),this.$options.wrapMethod.set.call(this,this.$wrapMethod),this.$setFolding(e.foldingRules),this.bgTokenizer.start(0),this._emit("changeMode"))}},this.$stopWorker=function(){this.$worker&&(this.$worker.terminate(),this.$worker=null)},this.$startWorker=function(){try{this.$worker=this.$mode.createWorker(this)}catch(e){s.warn("Could not load worker",e),this.$worker=null}},this.getMode=function(){return this.$mode},this.$scrollTop=0,this.setScrollTop=function(e){this.$scrollTop===e||isNaN(e)||(this.$scrollTop=e,this._signal("changeScrollTop",e))},this.getScrollTop=function(){return this.$scrollTop},this.$scrollLeft=0,this.setScrollLeft=function(e){this.$scrollLeft===e||isNaN(e)||(this.$scrollLeft=e,this._signal("changeScrollLeft",e))},this.getScrollLeft=function(){return this.$scrollLeft},this.getScreenWidth=function(){return this.$computeWidth(),this.lineWidgets?Math.max(this.getLineWidgetMaxWidth(),this.screenWidth):this.screenWidth},this.getLineWidgetMaxWidth=function(){if(null!=this.lineWidgetsWidth)return this.lineWidgetsWidth;var t=0;return this.lineWidgets.forEach(function(e){e&&e.screenWidth>t&&(t=e.screenWidth)}),this.lineWidgetWidth=t},this.$computeWidth=function(e){if(this.$modified||e){if(this.$modified=!1,this.$useWrapMode)return this.screenWidth=this.$wrapLimit;for(var t=this.doc.getAllLines(),i=this.$rowLengthCache,n=0,r=0,o=this.$foldData[r],s=o?o.start.row:1/0,a=t.length,l=0;l<a;l++){if(s<l){if(a<=(l=o.end.row+1))break;s=(o=this.$foldData[r++])?o.start.row:1/0}null==i[l]&&(i[l]=this.$getStringScreenWidth(t[l])[0]),i[l]>n&&(n=i[l])}this.screenWidth=n}},this.getLine=function(e){return this.doc.getLine(e)},this.getLines=function(e,t){return this.doc.getLines(e,t)},this.getLength=function(){return this.doc.getLength()},this.getTextRange=function(e){return this.doc.getTextRange(e||this.selection.getRange())},this.insert=function(e,t){return this.doc.insert(e,t)},this.remove=function(e){return this.doc.remove(e)},this.removeFullLines=function(e,t){return this.doc.removeFullLines(e,t)},this.undoChanges=function(e,t){if(e.length){this.$fromUndo=!0;for(var i=e.length-1;-1!=i;i--){var n=e[i];"insert"==n.action||"remove"==n.action?this.doc.revertDelta(n):n.folds&&this.addFolds(n.folds)}!t&&this.$undoSelect&&(e.selectionBefore?this.selection.fromJSON(e.selectionBefore):this.selection.setRange(this.$getUndoSelection(e,!0))),this.$fromUndo=!1}},this.redoChanges=function(e,t){if(e.length){this.$fromUndo=!0;for(var i=0;i<e.length;i++){var n=e[i];"insert"!=n.action&&"remove"!=n.action||this.doc.applyDelta(n)}!t&&this.$undoSelect&&(e.selectionAfter?this.selection.fromJSON(e.selectionAfter):this.selection.setRange(this.$getUndoSelection(e,!1))),this.$fromUndo=!1}},this.setUndoSelect=function(e){this.$undoSelect=e},this.$getUndoSelection=function(e,t){function i(e){return t?"insert"!==e.action:"insert"===e.action}for(var n,r,o=0;o<e.length;o++){var s=e[o];s.start&&(n?i(s)?(r=s.start,-1==n.compare(r.row,r.column)&&n.setStart(r),r=s.end,1==n.compare(r.row,r.column)&&n.setEnd(r),!0):(r=s.start,-1==n.compare(r.row,r.column)&&(n=h.fromPoints(s.start,s.start)),!1):i(s)?(n=h.fromPoints(s.start,s.end),!0):(n=h.fromPoints(s.start,s.start),!1))}return n},this.replace=function(e,t){return this.doc.replace(e,t)},this.moveText=function(e,t,i){var n=this.getTextRange(e),r=this.getFoldsInRange(e),o=h.fromPoints(t,t);if(!i){this.remove(e);var s=e.start.row-e.end.row;(c=s?-e.end.column:e.start.column-e.end.column)&&(o.start.row==e.end.row&&o.start.column>e.end.column&&(o.start.column+=c),o.end.row==e.end.row&&o.end.column>e.end.column&&(o.end.column+=c)),s&&o.start.row>=e.end.row&&(o.start.row+=s,o.end.row+=s)}if(o.end=this.insert(o.start,n),r.length){var a=e.start,l=o.start,c=(s=l.row-a.row,l.column-a.column);this.addFolds(r.map(function(e){return(e=e.clone()).start.row==a.row&&(e.start.column+=c),e.end.row==a.row&&(e.end.column+=c),e.start.row+=s,e.end.row+=s,e}))}return o},this.indentRows=function(e,t,i){i=i.replace(/\t/g,this.getTabString());for(var n=e;n<=t;n++)this.doc.insertInLine({row:n,column:0},i)},this.outdentRows=function(e){for(var t=e.collapseRows(),i=new h(0,0,0,0),n=this.getTabSize(),r=t.start.row;r<=t.end.row;++r){var o=this.getLine(r);i.start.row=r,i.end.row=r;for(var s=0;s<n&&" "==o.charAt(s);++s);s<n&&"\t"==o.charAt(s)?(i.start.column=s,i.end.column=s+1):(i.start.column=0,i.end.column=s),this.remove(i)}},this.$moveLines=function(e,t,i){if(e=this.getRowFoldStart(e),t=this.getRowFoldEnd(t),i<0){if((r=this.getRowFoldStart(e+i))<0)return 0;var n=r-e}else if(0<i){var r;if((r=this.getRowFoldEnd(t+i))>this.doc.getLength()-1)return 0;n=r-t}else{e=this.$clipRowToDocument(e);n=(t=this.$clipRowToDocument(t))-e+1}var o=new h(e,0,t,Number.MAX_VALUE),s=this.getFoldsInRange(o).map(function(e){return(e=e.clone()).start.row+=n,e.end.row+=n,e}),a=0==i?this.doc.getLines(e,t):this.doc.removeFullLines(e,t);return this.doc.insertFullLines(e+n,a),s.length&&this.addFolds(s),n},this.moveLinesUp=function(e,t){return this.$moveLines(e,t,-1)},this.moveLinesDown=function(e,t){return this.$moveLines(e,t,1)},this.duplicateLines=function(e,t){return this.$moveLines(e,t,0)},this.$clipRowToDocument=function(e){return Math.max(0,Math.min(e,this.doc.getLength()-1))},this.$clipColumnToRow=function(e,t){return t<0?0:Math.min(this.doc.getLine(e).length,t)},this.$clipPositionToDocument=function(e,t){if(t=Math.max(0,t),e<0)t=e=0;else{var i=this.doc.getLength();t=i<=e?(e=i-1,this.doc.getLine(i-1).length):Math.min(this.doc.getLine(e).length,t)}return{row:e,column:t}},this.$clipRangeToDocument=function(e){e.start.row<0?(e.start.row=0,e.start.column=0):e.start.column=this.$clipColumnToRow(e.start.row,e.start.column);var t=this.doc.getLength()-1;return e.end.row>t?(e.end.row=t,e.end.column=this.doc.getLine(t).length):e.end.column=this.$clipColumnToRow(e.end.row,e.end.column),e},this.$wrapLimit=80,this.$useWrapMode=!1,this.$wrapLimitRange={min:null,max:null},this.setUseWrapMode=function(e){if(e!=this.$useWrapMode){if(this.$useWrapMode=e,this.$modified=!0,this.$resetRowCache(0),e){var t=this.getLength();this.$wrapData=Array(t),this.$updateWrapData(0,t-1)}this._signal("changeWrapMode")}},this.getUseWrapMode=function(){return this.$useWrapMode},this.setWrapLimitRange=function(e,t){this.$wrapLimitRange.min===e&&this.$wrapLimitRange.max===t||(this.$wrapLimitRange={min:e,max:t},this.$modified=!0,this.$bidiHandler.markAsDirty(),this.$useWrapMode&&this._signal("changeWrapMode"))},this.adjustWrapLimit=function(e,t){var i=this.$wrapLimitRange;i.max<0&&(i={min:t,max:t});var n=this.$constrainWrapLimit(e,i.min,i.max);return n!=this.$wrapLimit&&1<n&&(this.$wrapLimit=n,this.$modified=!0,this.$useWrapMode&&(this.$updateWrapData(0,this.getLength()-1),this.$resetRowCache(0),this._signal("changeWrapLimit")),!0)},this.$constrainWrapLimit=function(e,t,i){return t&&(e=Math.max(t,e)),i&&(e=Math.min(i,e)),e},this.getWrapLimit=function(){return this.$wrapLimit},this.setWrapLimit=function(e){this.setWrapLimitRange(e,e)},this.getWrapLimitRange=function(){return{min:this.$wrapLimitRange.min,max:this.$wrapLimitRange.max}},this.$updateInternalDataOnChange=function(e){var t=this.$useWrapMode,i=e.action,n=e.start,r=e.end,o=n.row,s=r.row,a=s-o,l=null;if(this.$updating=!0,0!=a)if("remove"===i){this[t?"$wrapData":"$rowLengthCache"].splice(o,a);var c=this.$foldData;l=this.getFoldsInRange(e),this.removeFolds(l);var h=0;if(m=this.getFoldLine(r.row)){m.addRemoveChars(r.row,r.column,n.column-r.column),m.shiftRow(-a);var d=this.getFoldLine(o);d&&d!==m&&(d.merge(m),m=d),h=c.indexOf(m)+1}for(;h<c.length;h++){(m=c[h]).start.row>=r.row&&m.shiftRow(-a)}s=o}else{var u=Array(a);u.unshift(o,0);var g=t?this.$wrapData:this.$rowLengthCache;g.splice.apply(g,u);c=this.$foldData,h=0;if(m=this.getFoldLine(o)){var p=m.range.compareInside(n.row,n.column);0==p?(m=m.split(n.row,n.column))&&(m.shiftRow(a),m.addRemoveChars(s,0,r.column-n.column)):-1==p&&(m.addRemoveChars(o,0,r.column-n.column),m.shiftRow(a)),h=c.indexOf(m)+1}for(;h<c.length;h++){var m;(m=c[h]).start.row>=o&&m.shiftRow(a)}}else a=Math.abs(e.start.column-e.end.column),"remove"===i&&(l=this.getFoldsInRange(e),this.removeFolds(l),a=-a),(m=this.getFoldLine(o))&&m.addRemoveChars(o,n.column,a);return t&&this.$wrapData.length!=this.doc.getLength()&&console.error("doc.getLength() and $wrapData.length have to be the same!"),this.$updating=!1,t?this.$updateWrapData(o,s):this.$updateRowLengthCache(o,s),l},this.$updateRowLengthCache=function(e,t,i){this.$rowLengthCache[e]=null,this.$rowLengthCache[t]=null},this.$updateWrapData=function(e,t){var s,i,a=this.doc.getAllLines(),n=this.getTabSize(),r=this.$wrapData,o=this.$wrapLimit,l=e;for(t=Math.min(t,a.length-1);l<=t;)(i=this.getFoldLine(l,i))?(s=[],i.walk(function(e,t,i,n){var r;if(null!=e){(r=this.$getDisplayTokens(e,s.length))[0]=p;for(var o=1;o<r.length;o++)r[o]=m}else r=this.$getDisplayTokens(a[t].substring(n,i),s.length);s=s.concat(r)}.bind(this),i.end.row,a[i.end.row].length+1),r[i.start.row]=this.$computeWrapSplits(s,o,n),l=i.end.row+1):(s=this.$getDisplayTokens(a[l]),r[l]=this.$computeWrapSplits(s,o,n),l++)};var p=3,m=4;function a(e){return!(e<4352)&&(4352<=e&&e<=4447||4515<=e&&e<=4519||4602<=e&&e<=4607||9001<=e&&e<=9002||11904<=e&&e<=11929||11931<=e&&e<=12019||12032<=e&&e<=12245||12272<=e&&e<=12283||12288<=e&&e<=12350||12353<=e&&e<=12438||12441<=e&&e<=12543||12549<=e&&e<=12589||12593<=e&&e<=12686||12688<=e&&e<=12730||12736<=e&&e<=12771||12784<=e&&e<=12830||12832<=e&&e<=12871||12880<=e&&e<=13054||13056<=e&&e<=19903||19968<=e&&e<=42124||42128<=e&&e<=42182||43360<=e&&e<=43388||44032<=e&&e<=55203||55216<=e&&e<=55238||55243<=e&&e<=55291||63744<=e&&e<=64255||65040<=e&&e<=65049||65072<=e&&e<=65106||65108<=e&&e<=65126||65128<=e&&e<=65131||65281<=e&&e<=65376||65504<=e&&e<=65510)}this.$computeWrapSplits=function(r,e,o){if(0==r.length)return[];var s=[],t=r.length,a=0,l=0,c=this.$wrapAsCode,h=this.$indentedSoftWrap,d=e<=Math.max(2*o,8)||!1===h?0:Math.floor(e/2);function i(e){for(var t=e-a,i=a;i<e;i++){var n=r[i];12!==n&&2!==n||(t-=1)}s.length||(u=function(){var e=0;if(0===d)return e;if(h)for(var t=0;t<r.length;t++){var i=r[t];if(10==i)e+=1;else{if(11!=i){if(12==i)continue;break}e+=o}}return c&&!1!==h&&(e+=o),Math.min(e,d)}(),s.indent=u),l+=t,s.push(l),a=e}for(var u=0;e-u<t-a;){var n=a+e-u;if(10<=r[n-1]&&10<=r[n])i(n);else if(r[n]!=p&&r[n]!=m){for(var g=Math.max(n-(e-(e>>2)),a-1);g<n&&r[n]<p;)n--;if(c){for(;g<n&&r[n]<p;)n--;for(;g<n&&9==r[n];)n--}else for(;g<n&&r[n]<10;)n--;g<n?i(++n):(2==r[n=a+e]&&n--,i(n-u))}else{for(;n!=a-1&&r[n]!=p;n--);if(a<n){i(n);continue}for(n=a+e;n<r.length&&r[n]==m;n++);if(n==r.length)break;i(n)}}return s},this.$getDisplayTokens=function(e,t){var i,n=[];t=t||0;for(var r=0;r<e.length;r++){var o=e.charCodeAt(r);if(9==o){i=this.getScreenTabSize(n.length+t),n.push(11);for(var s=1;s<i;s++)n.push(12)}else 32==o?n.push(10):39<o&&o<48||57<o&&o<64?n.push(9):4352<=o&&a(o)?n.push(1,2):n.push(1)}return n},this.$getStringScreenWidth=function(e,t,i){if(0==t)return[0,0];var n,r;for(null==t&&(t=1/0),i=i||0,r=0;r<e.length&&(9==(n=e.charCodeAt(r))?i+=this.getScreenTabSize(i):4352<=n&&a(n)?i+=2:i+=1,!(t<i));r++);return[i,r]},this.lineWidgets=null,this.getRowLength=function(e){if(this.lineWidgets)var t=this.lineWidgets[e]&&this.lineWidgets[e].rowCount||0;else t=0;return this.$useWrapMode&&this.$wrapData[e]?this.$wrapData[e].length+1+t:1+t},this.getRowLineCount=function(e){return this.$useWrapMode&&this.$wrapData[e]?this.$wrapData[e].length+1:1},this.getRowWrapIndent=function(e){if(this.$useWrapMode){var t=this.screenToDocumentPosition(e,Number.MAX_VALUE),i=this.$wrapData[t.row];return i.length&&i[0]<t.column?i.indent:0}return 0},this.getScreenLastRowColumn=function(e){var t=this.screenToDocumentPosition(e,Number.MAX_VALUE);return this.documentToScreenColumn(t.row,t.column)},this.getDocumentLastRowColumn=function(e,t){var i=this.documentToScreenRow(e,t);return this.getScreenLastRowColumn(i)},this.getDocumentLastRowColumnPosition=function(e,t){var i=this.documentToScreenRow(e,t);return this.screenToDocumentPosition(i,Number.MAX_VALUE/10)},this.getRowSplitData=function(e){return this.$useWrapMode?this.$wrapData[e]:void 0},this.getScreenTabSize=function(e){return this.$tabSize-(e%this.$tabSize|0)},this.screenToDocumentRow=function(e,t){return this.screenToDocumentPosition(e,t).row},this.screenToDocumentColumn=function(e,t){return this.screenToDocumentPosition(e,t).column},this.screenToDocumentPosition=function(e,t,i){if(e<0)return{row:0,column:0};var n,r,o=0,s=0,a=0,l=0,c=this.$screenRowCache,h=this.$getRowCacheIndex(c,e),d=c.length;if(d&&0<=h){a=c[h],o=this.$docRowCache[h];var u=e>c[d-1]}else u=!d;for(var g=this.getLength()-1,p=this.getNextFoldLine(o),m=p?p.start.row:1/0;a<=e&&!(e<a+(l=this.getRowLength(o))||g<=o);)a+=l,m<++o&&(o=p.end.row+1,m=(p=this.getNextFoldLine(o,p))?p.start.row:1/0),u&&(this.$docRowCache.push(o),this.$screenRowCache.push(a));if(p&&p.start.row<=o)n=this.getFoldDisplayLine(p),o=p.start.row;else{if(a+l<=e||g<o)return{row:g,column:this.getLine(g).length};n=this.getLine(o),p=null}var f=0,C=Math.floor(e-a);if(this.$useWrapMode){var I=this.$wrapData[o];I&&(r=I[C],0<C&&I.length&&(f=I.indent,s=I[C-1]||I[I.length-1],n=n.substring(s)))}return void 0!==i&&this.$bidiHandler.isBidiRow(a+C,o,C)&&(t=this.$bidiHandler.offsetToCol(i)),s+=this.$getStringScreenWidth(n,t-f)[1],this.$useWrapMode&&r<=s&&(s=r-1),p?p.idxToPosition(s):{row:o,column:s}},this.documentToScreenPosition=function(e,t){if(void 0===t)var i=this.$clipPositionToDocument(e.row,e.column);else i=this.$clipPositionToDocument(e,t);e=i.row,t=i.column;var n,r=0,o=null;(n=this.getFoldAt(e,t,1))&&(e=n.start.row,t=n.start.column);var s,a=0,l=this.$docRowCache,c=this.$getRowCacheIndex(l,e),h=l.length;if(h&&0<=c){a=l[c],r=this.$screenRowCache[c];var d=e>l[h-1]}else d=!h;for(var u=this.getNextFoldLine(a),g=u?u.start.row:1/0;a<e;){if(g<=a){if(e<(s=u.end.row+1))break;g=(u=this.getNextFoldLine(s,u))?u.start.row:1/0}else s=a+1;r+=this.getRowLength(a),a=s,d&&(this.$docRowCache.push(a),this.$screenRowCache.push(r))}var p="";o=u&&g<=a?(p=this.getFoldDisplayLine(u,e,t),u.start.row):(p=this.getLine(e).substring(0,t),e);var m=0;if(this.$useWrapMode){var f=this.$wrapData[o];if(f){for(var C=0;p.length>=f[C];)r++,C++;p=p.substring(f[C-1]||0,p.length),m=0<C?f.indent:0}}return{row:r,column:m+this.$getStringScreenWidth(p)[0]}},this.documentToScreenColumn=function(e,t){return this.documentToScreenPosition(e,t).column},this.documentToScreenRow=function(e,t){return this.documentToScreenPosition(e,t).row},this.getScreenLength=function(){var e=0,t=null;if(this.$useWrapMode)for(var i=this.$wrapData.length,n=0,r=(a=0,(t=this.$foldData[a++])?t.start.row:1/0);n<i;){var o=this.$wrapData[n];e+=o?o.length+1:1,r<++n&&(n=t.end.row+1,r=(t=this.$foldData[a++])?t.start.row:1/0)}else{e=this.getLength();for(var s=this.$foldData,a=0;a<s.length;a++)e-=(t=s[a]).end.row-t.start.row}return this.lineWidgets&&(e+=this.$getWidgetScreenLength()),e},this.$setFontMetrics=function(o){this.$enableVarChar&&(this.$getStringScreenWidth=function(e,t,i){if(0===t)return[0,0];var n,r;for(t=t||1/0,i=i||0,r=0;r<e.length&&!(t<(i+="\t"===(n=e.charAt(r))?this.getScreenTabSize(i):o.getCharacterWidth(n)));r++);return[i,r]})},this.destroy=function(){this.bgTokenizer&&(this.bgTokenizer.setDocument(null),this.bgTokenizer=null),this.$stopWorker()},this.isFullWidth=a}.call(p.prototype),e("./edit_session/folding").Folding.call(p.prototype),e("./edit_session/bracket_match").BracketMatch.call(p.prototype),s.defineOptions(p.prototype,"session",{wrap:{set:function(e){if(e&&"off"!=e?"free"==e?e=!0:"printMargin"==e?e=-1:"string"==typeof e&&(e=parseInt(e,10)||!1):e=!1,this.$wrap!=e)if(this.$wrap=e){var t="number"==typeof e?e:null;this.setWrapLimitRange(t,t),this.setUseWrapMode(!0)}else this.setUseWrapMode(!1)},get:function(){return this.getUseWrapMode()?-1==this.$wrap?"printMargin":this.getWrapLimitRange().min?this.$wrap:"free":"off"},handlesSet:!0},wrapMethod:{set:function(e){(e="auto"==e?"text"!=this.$mode.type:"text"!=e)!=this.$wrapAsCode&&(this.$wrapAsCode=e,this.$useWrapMode&&(this.$useWrapMode=!1,this.setUseWrapMode(!0)))},initialValue:"auto"},indentedSoftWrap:{set:function(){this.$useWrapMode&&(this.$useWrapMode=!1,this.setUseWrapMode(!0))},initialValue:!0},firstLineNumber:{set:function(){this._signal("changeBreakpoint")},initialValue:1},useWorker:{set:function(e){this.$useWorker=e,this.$stopWorker(),e&&this.$startWorker()},initialValue:!0},useSoftTabs:{initialValue:!0},tabSize:{set:function(e){0<(e=parseInt(e))&&this.$tabSize!==e&&(this.$modified=!0,this.$rowLengthCache=[],this.$tabSize=e,this._signal("changeTabSize"))},initialValue:4,handlesSet:!0},navigateWithinSoftTabs:{initialValue:!1},foldStyle:{set:function(e){this.setFoldStyle(e)},handlesSet:!0},overwrite:{set:function(e){this._signal("changeOverwrite")},initialValue:!1},newLineMode:{set:function(e){this.doc.setNewLineMode(e)},get:function(){return this.doc.getNewLineMode()},handlesSet:!0},mode:{set:function(e){this.setMode(e)},get:function(){return this.$modeId},handlesSet:!0}}),t.EditSession=p}),ace.define("ace/search",["require","exports","module","ace/lib/lang","ace/lib/oop","ace/range"],function(e,t,i){"use strict";function n(){this.$options={}}var v=e("./lib/lang"),r=e("./lib/oop"),b=e("./range").Range;(function(){this.set=function(e){return r.mixin(this.$options,e),this},this.getOptions=function(){return v.copyObject(this.$options)},this.setOptions=function(e){this.$options=e},this.find=function(e){var r=this.$options,t=this.$matchIterator(e,r);if(!t)return!1;var o=null;return t.forEach(function(e,t,i,n){return o=new b(e,t,i,n),!(t==n&&r.start&&r.start.start&&0!=r.skipCurrent&&o.isEqual(r.start))||(o=null,!1)}),o},this.findAll=function(e){var t=this.$options;if(!t.needle)return[];this.$assembleRegExp(t);var i=t.range,n=i?e.getLines(i.start.row,i.end.row):e.doc.getAllLines(),r=[],o=t.re;if(t.$isMultiLine){var s,a=o.length,l=n.length-a;e:for(var c=o.offset||0;c<=l;c++){for(var h=0;h<a;h++)if(-1==n[c+h].search(o[h]))continue e;var d=n[c],u=n[c+a-1],g=d.length-d.match(o[0])[0].length,p=u.match(o[a-1])[0].length;s&&s.end.row===c&&s.end.column>g||(r.push(s=new b(c,g,c+a-1,p)),2<a&&(c=c+a-2))}}else for(var m=0;m<n.length;m++){var f=v.getMatchOffsets(n[m],o);for(h=0;h<f.length;h++){var C=f[h];r.push(new b(m,C.offset,m,C.offset+C.length))}}if(i){var I=i.start.column,A=i.start.column;for(m=0,h=r.length-1;m<h&&r[m].start.column<I&&r[m].start.row==i.start.row;)m++;for(;m<h&&r[h].end.column>A&&r[h].end.row==i.end.row;)h--;for(r=r.slice(m,h+1),m=0,h=r.length;m<h;m++)r[m].start.row+=i.start.row,r[m].end.row+=i.start.row}return r},this.replace=function(e,t){var i=this.$options,n=this.$assembleRegExp(i);if(i.$isMultiLine)return t;if(n){var r=n.exec(e);if(!r||r[0].length!=e.length)return null;if(t=e.replace(n,t),i.preserveCase){t=t.split("");for(var o=Math.min(e.length,e.length);o--;){var s=e[o];s&&s.toLowerCase()!=s?t[o]=t[o].toUpperCase():t[o]=t[o].toLowerCase()}t=t.join("")}return t}},this.$assembleRegExp=function(e,t){if(e.needle instanceof RegExp)return e.re=e.needle;var i=e.needle;if(!e.needle)return e.re=!1;e.regExp||(i=v.escapeRegExp(i)),e.wholeWord&&(i=function(e,t){function i(e){return/\w/.test(e)||t.regExp?"\\b":""}return i(e[0])+e+i(e[e.length-1])}(i,e));var n=e.caseSensitive?"gm":"gmi";if(e.$isMultiLine=!t&&/[\n\r]/.test(i),e.$isMultiLine)return e.re=this.$assembleMultilineRegExp(i,n);try{var r=new RegExp(i,n)}catch(e){r=!1}return e.re=r},this.$assembleMultilineRegExp=function(e,t){for(var i=e.replace(/\r\n|\r|\n/g,"$\n^").split("\n"),n=[],r=0;r<i.length;r++)try{n.push(new RegExp(i[r],t))}catch(e){return!1}return n},this.$matchIterator=function(h,i){var d=this.$assembleRegExp(i);if(!d)return!1;var l=1==i.backwards,e=0!=i.skipCurrent,t=i.range,n=i.start;(n=n||(t?t[l?"end":"start"]:h.selection.getRange())).start&&(n=n[e!=l?"end":"start"]);var r=t?t.start.row:0,o=t?t.end.row:h.getLength()-1;if(l)var s=function(e){var t=n.row;if(!a(t,n.column,e)){for(t--;r<=t;t--)if(a(t,Number.MAX_VALUE,e))return;if(0!=i.wrap)for(t=o,r=n.row;r<=t;t--)if(a(t,Number.MAX_VALUE,e))return}};else s=function(e){var t=n.row;if(!a(t,n.column,e)){for(t+=1;t<=o;t++)if(a(t,0,e))return;if(0!=i.wrap)for(t=r,o=n.row;t<=o;t++)if(a(t,0,e))return}};if(i.$isMultiLine)var c=d.length,a=function(e,t,i){var n=l?e-c+1:e;if(!(n<0)){var r=h.getLine(n),o=r.search(d[0]);if(!(!l&&o<t||-1===o)){for(var s=1;s<c;s++)if(-1==(r=h.getLine(n+s)).search(d[s]))return;var a=r.match(d[c-1])[0].length;if(!(l&&t<a))return!!i(n,o,n+c-1,a)||void 0}}};else if(l)a=function(e,t,i){var n,r=h.getLine(e),o=[],s=0;for(d.lastIndex=0;n=d.exec(r);){var a=n[0].length;if(s=n.index,!a){if(s>=r.length)break;d.lastIndex=s+=1}if(n.index+a>t)break;o.push(n.index,a)}for(var l=o.length-1;0<=l;l-=2){var c=o[l-1];if(i(e,c,e,c+(a=o[l])))return!0}};else a=function(e,t,i){var n,r,o=h.getLine(e);for(d.lastIndex=t;r=d.exec(o);){var s=r[0].length;if(i(e,n=r.index,e,n+s))return!0;if(!s&&(d.lastIndex=n+=1,n>=o.length))return!1}};return{forEach:s}}}).call(n.prototype),t.Search=n}),ace.define("ace/keyboard/hash_handler",["require","exports","module","ace/lib/keys","ace/lib/useragent"],function(e,t,i){"use strict";var a=e("../lib/keys"),n=e("../lib/useragent"),l=a.KEY_MODS;function r(e,t){this.platform=t||(n.isMac?"mac":"win"),this.commands={},this.commandKeyBinding={},this.addCommands(e),this.$singleCommand=!0}function o(e,t){r.call(this,e,t),this.$singleCommand=!1}o.prototype=r.prototype,function(){function s(e){return"object"==typeof e&&e.bindKey&&e.bindKey.position||(e.isDefault?-100:0)}this.addCommand=function(e){this.commands[e.name]&&this.removeCommand(e),(this.commands[e.name]=e).bindKey&&this._buildKeyHash(e)},this.removeCommand=function(e,t){var i=e&&("string"==typeof e?e:e.name);e=this.commands[i],t||delete this.commands[i];var n=this.commandKeyBinding;for(var r in n){var o=n[r];if(o==e)delete n[r];else if(Array.isArray(o)){var s=o.indexOf(e);-1!=s&&(o.splice(s,1),1==o.length&&(n[r]=o[0]))}}},this.bindKey=function(e,o,s){if("object"==typeof e&&e&&(null==s&&(s=e.position),e=e[this.platform]),e)return"function"==typeof o?this.addCommand({exec:o,bindKey:e,name:o.name||e}):void e.split("|").forEach(function(e){var n="";if(-1!=e.indexOf(" ")){var t=e.split(/\s+/);e=t.pop(),t.forEach(function(e){var t=this.parseKeys(e),i=l[t.hashId]+t.key;n+=(n?" ":"")+i,this._addCommandToBinding(n,"chainKeys")},this),n+=" "}var i=this.parseKeys(e),r=l[i.hashId]+i.key;this._addCommandToBinding(n+r,o,s)},this)},this._addCommandToBinding=function(e,t,i){var n,r=this.commandKeyBinding;if(t)if(!r[e]||this.$singleCommand)r[e]=t;else{Array.isArray(r[e])?-1!=(n=r[e].indexOf(t))&&r[e].splice(n,1):r[e]=[r[e]],"number"!=typeof i&&(i=s(t));var o=r[e];for(n=0;n<o.length;n++){if(i<s(o[n]))break}o.splice(n,0,t)}else delete r[e]},this.addCommands=function(i){i&&Object.keys(i).forEach(function(e){var t=i[e];if(t){if("string"==typeof t)return this.bindKey(t,e);"function"==typeof t&&(t={exec:t}),"object"==typeof t&&(t.name||(t.name=e),this.addCommand(t))}},this)},this.removeCommands=function(t){Object.keys(t).forEach(function(e){this.removeCommand(t[e])},this)},this.bindKeys=function(t){Object.keys(t).forEach(function(e){this.bindKey(e,t[e])},this)},this._buildKeyHash=function(e){this.bindKey(e.bindKey,e)},this.parseKeys=function(e){var t=e.toLowerCase().split(/[\-\+]([\-\+])?/).filter(function(e){return e}),i=t.pop(),n=a[i];if(a.FUNCTION_KEYS[n])i=a.FUNCTION_KEYS[n].toLowerCase();else{if(!t.length)return{key:i,hashId:-1};if(1==t.length&&"shift"==t[0])return{key:i.toUpperCase(),hashId:-1}}for(var r=0,o=t.length;o--;){var s=a.KEY_MODS[t[o]];if(null==s)return"undefined"!=typeof console&&console.error("invalid modifier "+t[o]+" in "+e),!1;r|=s}return{key:i,hashId:r}},this.findKeyCommand=function(e,t){var i=l[e]+t;return this.commandKeyBinding[i]},this.handleKeyboard=function(e,t,i,n){if(!(n<0)){var r=l[t]+i,o=this.commandKeyBinding[r];return e.$keyChain&&(e.$keyChain+=" "+r,o=this.commandKeyBinding[e.$keyChain]||o),!o||"chainKeys"!=o&&"chainKeys"!=o[o.length-1]?(e.$keyChain&&(t&&4!=t||1!=i.length?(-1==t||0<n)&&(e.$keyChain=""):e.$keyChain=e.$keyChain.slice(0,-r.length-1)),{command:o}):(e.$keyChain=e.$keyChain||r,{command:"null"})}},this.getStatusText=function(e,t){return t.$keyChain||""}}.call(r.prototype),t.HashHandler=r,t.MultiHashHandler=o}),ace.define("ace/commands/command_manager",["require","exports","module","ace/lib/oop","ace/keyboard/hash_handler","ace/lib/event_emitter"],function(e,t,i){"use strict";function n(e,t){o.call(this,t,e),this.byName=this.commands,this.setDefaultHandler("exec",function(e){return e.command.exec(e.editor,e.args||{})})}var r=e("../lib/oop"),o=e("../keyboard/hash_handler").MultiHashHandler,s=e("../lib/event_emitter").EventEmitter;r.inherits(n,o),function(){r.implement(this,s),this.exec=function(e,t,i){if(Array.isArray(e)){for(var n=e.length;n--;)if(this.exec(e[n],t,i))return!0;return!1}if("string"==typeof e&&(e=this.commands[e]),!e)return!1;if(t&&t.$readOnly&&!e.readOnly)return!1;if(0!=this.$checkCommandState&&e.isAvailable&&!e.isAvailable(t))return!1;var r={editor:t,command:e,args:i};return r.returnValue=this._emit("exec",r),this._signal("afterExec",r),!1!==r.returnValue},this.toggleRecording=function(e){if(!this.$inReplay)return e&&e._emit("changeStatus"),this.recording?(this.macro.pop(),this.removeEventListener("exec",this.$addCommandToMacro),this.macro.length||(this.macro=this.oldMacro),this.recording=!1):(this.$addCommandToMacro||(this.$addCommandToMacro=function(e){this.macro.push([e.command,e.args])}.bind(this)),this.oldMacro=this.macro,this.macro=[],this.on("exec",this.$addCommandToMacro),this.recording=!0)},this.replay=function(t){if(!this.$inReplay&&this.macro){if(this.recording)return this.toggleRecording(t);try{this.$inReplay=!0,this.macro.forEach(function(e){"string"==typeof e?this.exec(e,t):this.exec(e[0],t,e[1])},this)}finally{this.$inReplay=!1}}},this.trimMacro=function(e){return e.map(function(e){return"string"!=typeof e[0]&&(e[0]=e[0].name),e[1]||(e=e[0]),e})}}.call(n.prototype),t.CommandManager=n}),ace.define("ace/commands/default_commands",["require","exports","module","ace/lib/lang","ace/config","ace/range"],function(e,t,i){"use strict";var c=e("../lib/lang"),n=e("../config"),h=e("../range").Range;function r(e,t){return{win:e,mac:t}}t.commands=[{name:"showSettingsMenu",bindKey:r("Ctrl-,","Command-,"),exec:function(t){n.loadModule("ace/ext/settings_menu",function(e){e.init(t),t.showSettingsMenu()})},readOnly:!0},{name:"goToNextError",bindKey:r("Alt-E","F4"),exec:function(t){n.loadModule("./ext/error_marker",function(e){e.showErrorMarker(t,1)})},scrollIntoView:"animate",readOnly:!0},{name:"goToPreviousError",bindKey:r("Alt-Shift-E","Shift-F4"),exec:function(t){n.loadModule("./ext/error_marker",function(e){e.showErrorMarker(t,-1)})},scrollIntoView:"animate",readOnly:!0},{name:"selectall",description:"Select all",bindKey:r("Ctrl-A","Command-A"),exec:function(e){e.selectAll()},readOnly:!0},{name:"centerselection",description:"Center selection",bindKey:r(null,"Ctrl-L"),exec:function(e){e.centerSelection()},readOnly:!0},{name:"gotoline",description:"Go to line...",bindKey:r("Ctrl-L","Command-L"),exec:function(e,t){"number"!=typeof t||isNaN(t)||e.gotoLine(t),e.prompt({$type:"gotoLine"})},readOnly:!0},{name:"fold",bindKey:r("Alt-L|Ctrl-F1","Command-Alt-L|Command-F1"),exec:function(e){e.session.toggleFold(!1)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"unfold",bindKey:r("Alt-Shift-L|Ctrl-Shift-F1","Command-Alt-Shift-L|Command-Shift-F1"),exec:function(e){e.session.toggleFold(!0)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"toggleFoldWidget",bindKey:r("F2","F2"),exec:function(e){e.session.toggleFoldWidget()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"toggleParentFoldWidget",bindKey:r("Alt-F2","Alt-F2"),exec:function(e){e.session.toggleFoldWidget(!0)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"foldall",description:"Fold all",bindKey:r(null,"Ctrl-Command-Option-0"),exec:function(e){e.session.foldAll()},scrollIntoView:"center",readOnly:!0},{name:"foldOther",description:"Fold other",bindKey:r("Alt-0","Command-Option-0"),exec:function(e){e.session.foldAll(),e.session.unfold(e.selection.getAllRanges())},scrollIntoView:"center",readOnly:!0},{name:"unfoldall",description:"Unfold all",bindKey:r("Alt-Shift-0","Command-Option-Shift-0"),exec:function(e){e.session.unfold()},scrollIntoView:"center",readOnly:!0},{name:"findnext",description:"Find next",bindKey:r("Ctrl-K","Command-G"),exec:function(e){e.findNext()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"findprevious",description:"Find previous",bindKey:r("Ctrl-Shift-K","Command-Shift-G"),exec:function(e){e.findPrevious()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"selectOrFindNext",description:"Select or find next",bindKey:r("Alt-K","Ctrl-G"),exec:function(e){e.selection.isEmpty()?e.selection.selectWord():e.findNext()},readOnly:!0},{name:"selectOrFindPrevious",description:"Select or find previous",bindKey:r("Alt-Shift-K","Ctrl-Shift-G"),exec:function(e){e.selection.isEmpty()?e.selection.selectWord():e.findPrevious()},readOnly:!0},{name:"find",description:"Find",bindKey:r("Ctrl-F","Command-F"),exec:function(t){n.loadModule("ace/ext/searchbox",function(e){e.Search(t)})},readOnly:!0},{name:"overwrite",description:"Overwrite",bindKey:"Insert",exec:function(e){e.toggleOverwrite()},readOnly:!0},{name:"selecttostart",description:"Select to start",bindKey:r("Ctrl-Shift-Home","Command-Shift-Home|Command-Shift-Up"),exec:function(e){e.getSelection().selectFileStart()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"gotostart",description:"Go to start",bindKey:r("Ctrl-Home","Command-Home|Command-Up"),exec:function(e){e.navigateFileStart()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"selectup",description:"Select up",bindKey:r("Shift-Up","Shift-Up|Ctrl-Shift-P"),exec:function(e){e.getSelection().selectUp()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"golineup",description:"Go line up",bindKey:r("Up","Up|Ctrl-P"),exec:function(e,t){e.navigateUp(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttoend",description:"Select to end",bindKey:r("Ctrl-Shift-End","Command-Shift-End|Command-Shift-Down"),exec:function(e){e.getSelection().selectFileEnd()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"gotoend",description:"Go to end",bindKey:r("Ctrl-End","Command-End|Command-Down"),exec:function(e){e.navigateFileEnd()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"selectdown",description:"Select down",bindKey:r("Shift-Down","Shift-Down|Ctrl-Shift-N"),exec:function(e){e.getSelection().selectDown()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"golinedown",description:"Go line down",bindKey:r("Down","Down|Ctrl-N"),exec:function(e,t){e.navigateDown(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectwordleft",description:"Select word left",bindKey:r("Ctrl-Shift-Left","Option-Shift-Left"),exec:function(e){e.getSelection().selectWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotowordleft",description:"Go to word left",bindKey:r("Ctrl-Left","Option-Left"),exec:function(e){e.navigateWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttolinestart",description:"Select to line start",bindKey:r("Alt-Shift-Left","Command-Shift-Left|Ctrl-Shift-A"),exec:function(e){e.getSelection().selectLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotolinestart",description:"Go to line start",bindKey:r("Alt-Left|Home","Command-Left|Home|Ctrl-A"),exec:function(e){e.navigateLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectleft",description:"Select left",bindKey:r("Shift-Left","Shift-Left|Ctrl-Shift-B"),exec:function(e){e.getSelection().selectLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotoleft",description:"Go to left",bindKey:r("Left","Left|Ctrl-B"),exec:function(e,t){e.navigateLeft(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectwordright",description:"Select word right",bindKey:r("Ctrl-Shift-Right","Option-Shift-Right"),exec:function(e){e.getSelection().selectWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotowordright",description:"Go to word right",bindKey:r("Ctrl-Right","Option-Right"),exec:function(e){e.navigateWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttolineend",description:"Select to line end",bindKey:r("Alt-Shift-Right","Command-Shift-Right|Shift-End|Ctrl-Shift-E"),exec:function(e){e.getSelection().selectLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotolineend",description:"Go to line end",bindKey:r("Alt-Right|End","Command-Right|End|Ctrl-E"),exec:function(e){e.navigateLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectright",description:"Select right",bindKey:r("Shift-Right","Shift-Right"),exec:function(e){e.getSelection().selectRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotoright",description:"Go to right",bindKey:r("Right","Right|Ctrl-F"),exec:function(e,t){e.navigateRight(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectpagedown",description:"Select page down",bindKey:"Shift-PageDown",exec:function(e){e.selectPageDown()},readOnly:!0},{name:"pagedown",description:"Page down",bindKey:r(null,"Option-PageDown"),exec:function(e){e.scrollPageDown()},readOnly:!0},{name:"gotopagedown",description:"Go to page down",bindKey:r("PageDown","PageDown|Ctrl-V"),exec:function(e){e.gotoPageDown()},readOnly:!0},{name:"selectpageup",description:"Select page up",bindKey:"Shift-PageUp",exec:function(e){e.selectPageUp()},readOnly:!0},{name:"pageup",description:"Page up",bindKey:r(null,"Option-PageUp"),exec:function(e){e.scrollPageUp()},readOnly:!0},{name:"gotopageup",description:"Go to page up",bindKey:"PageUp",exec:function(e){e.gotoPageUp()},readOnly:!0},{name:"scrollup",description:"Scroll up",bindKey:r("Ctrl-Up",null),exec:function(e){e.renderer.scrollBy(0,-2*e.renderer.layerConfig.lineHeight)},readOnly:!0},{name:"scrolldown",description:"Scroll down",bindKey:r("Ctrl-Down",null),exec:function(e){e.renderer.scrollBy(0,2*e.renderer.layerConfig.lineHeight)},readOnly:!0},{name:"selectlinestart",description:"Select line start",bindKey:"Shift-Home",exec:function(e){e.getSelection().selectLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectlineend",description:"Select line end",bindKey:"Shift-End",exec:function(e){e.getSelection().selectLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"togglerecording",description:"Toggle recording",bindKey:r("Ctrl-Alt-E","Command-Option-E"),exec:function(e){e.commands.toggleRecording(e)},readOnly:!0},{name:"replaymacro",description:"Replay macro",bindKey:r("Ctrl-Shift-E","Command-Shift-E"),exec:function(e){e.commands.replay(e)},readOnly:!0},{name:"jumptomatching",description:"Jump to matching",bindKey:r("Ctrl-\\|Ctrl-P","Command-\\"),exec:function(e){e.jumpToMatching()},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"selecttomatching",description:"Select to matching",bindKey:r("Ctrl-Shift-\\|Ctrl-Shift-P","Command-Shift-\\"),exec:function(e){e.jumpToMatching(!0)},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"expandToMatching",description:"Expand to matching",bindKey:r("Ctrl-Shift-M","Ctrl-Shift-M"),exec:function(e){e.jumpToMatching(!0,!0)},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"passKeysToBrowser",description:"Pass keys to browser",bindKey:r(null,null),exec:function(){},passEvent:!0,readOnly:!0},{name:"copy",description:"Copy",exec:function(e){},readOnly:!0},{name:"cut",description:"Cut",exec:function(e){var t=e.$copyWithEmptySelection&&e.selection.isEmpty()?e.selection.getLineRange():e.selection.getRange();e._emit("cut",t),t.isEmpty()||e.session.remove(t),e.clearSelection()},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"paste",description:"Paste",exec:function(e,t){e.$handlePaste(t)},scrollIntoView:"cursor"},{name:"removeline",description:"Remove line",bindKey:r("Ctrl-D","Command-D"),exec:function(e){e.removeLines()},scrollIntoView:"cursor",multiSelectAction:"forEachLine"},{name:"duplicateSelection",description:"Duplicate selection",bindKey:r("Ctrl-Shift-D","Command-Shift-D"),exec:function(e){e.duplicateSelection()},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"sortlines",description:"Sort lines",bindKey:r("Ctrl-Alt-S","Command-Alt-S"),exec:function(e){e.sortLines()},scrollIntoView:"selection",multiSelectAction:"forEachLine"},{name:"togglecomment",description:"Toggle comment",bindKey:r("Ctrl-/","Command-/"),exec:function(e){e.toggleCommentLines()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"toggleBlockComment",description:"Toggle block comment",bindKey:r("Ctrl-Shift-/","Command-Shift-/"),exec:function(e){e.toggleBlockComment()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"modifyNumberUp",description:"Modify number up",bindKey:r("Ctrl-Shift-Up","Alt-Shift-Up"),exec:function(e){e.modifyNumber(1)},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"modifyNumberDown",description:"Modify number down",bindKey:r("Ctrl-Shift-Down","Alt-Shift-Down"),exec:function(e){e.modifyNumber(-1)},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"replace",description:"Replace",bindKey:r("Ctrl-H","Command-Option-F"),exec:function(t){n.loadModule("ace/ext/searchbox",function(e){e.Search(t,!0)})}},{name:"undo",description:"Undo",bindKey:r("Ctrl-Z","Command-Z"),exec:function(e){e.undo()}},{name:"redo",description:"Redo",bindKey:r("Ctrl-Shift-Z|Ctrl-Y","Command-Shift-Z|Command-Y"),exec:function(e){e.redo()}},{name:"copylinesup",description:"Copy lines up",bindKey:r("Alt-Shift-Up","Command-Option-Up"),exec:function(e){e.copyLinesUp()},scrollIntoView:"cursor"},{name:"movelinesup",description:"Move lines up",bindKey:r("Alt-Up","Option-Up"),exec:function(e){e.moveLinesUp()},scrollIntoView:"cursor"},{name:"copylinesdown",description:"Copy lines down",bindKey:r("Alt-Shift-Down","Command-Option-Down"),exec:function(e){e.copyLinesDown()},scrollIntoView:"cursor"},{name:"movelinesdown",description:"Move lines down",bindKey:r("Alt-Down","Option-Down"),exec:function(e){e.moveLinesDown()},scrollIntoView:"cursor"},{name:"del",description:"Delete",bindKey:r("Delete","Delete|Ctrl-D|Shift-Delete"),exec:function(e){e.remove("right")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"backspace",description:"Backspace",bindKey:r("Shift-Backspace|Backspace","Ctrl-Backspace|Shift-Backspace|Backspace|Ctrl-H"),exec:function(e){e.remove("left")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"cut_or_delete",description:"Cut or delete",bindKey:r("Shift-Delete",null),exec:function(e){if(!e.selection.isEmpty())return!1;e.remove("left")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolinestart",description:"Remove to line start",bindKey:r("Alt-Backspace","Command-Backspace"),exec:function(e){e.removeToLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolineend",description:"Remove to line end",bindKey:r("Alt-Delete","Ctrl-K|Command-Delete"),exec:function(e){e.removeToLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolinestarthard",description:"Remove to line start hard",bindKey:r("Ctrl-Shift-Backspace",null),exec:function(e){var t=e.selection.getRange();t.start.column=0,e.session.remove(t)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolineendhard",description:"Remove to line end hard",bindKey:r("Ctrl-Shift-Delete",null),exec:function(e){var t=e.selection.getRange();t.end.column=Number.MAX_VALUE,e.session.remove(t)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removewordleft",description:"Remove word left",bindKey:r("Ctrl-Backspace","Alt-Backspace|Ctrl-Alt-Backspace"),exec:function(e){e.removeWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removewordright",description:"Remove word right",bindKey:r("Ctrl-Delete","Alt-Delete"),exec:function(e){e.removeWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"outdent",description:"Outdent",bindKey:r("Shift-Tab","Shift-Tab"),exec:function(e){e.blockOutdent()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"indent",description:"Indent",bindKey:r("Tab","Tab"),exec:function(e){e.indent()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"blockoutdent",description:"Block outdent",bindKey:r("Ctrl-[","Ctrl-["),exec:function(e){e.blockOutdent()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"blockindent",description:"Block indent",bindKey:r("Ctrl-]","Ctrl-]"),exec:function(e){e.blockIndent()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"insertstring",description:"Insert string",exec:function(e,t){e.insert(t)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"inserttext",description:"Insert text",exec:function(e,t){e.insert(c.stringRepeat(t.text||"",t.times||1))},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"splitline",description:"Split line",bindKey:r(null,"Ctrl-O"),exec:function(e){e.splitLine()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"transposeletters",description:"Transpose letters",bindKey:r("Alt-Shift-X","Ctrl-T"),exec:function(e){e.transposeLetters()},multiSelectAction:function(e){e.transposeSelections(1)},scrollIntoView:"cursor"},{name:"touppercase",description:"To uppercase",bindKey:r("Ctrl-U","Ctrl-U"),exec:function(e){e.toUpperCase()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"tolowercase",description:"To lowercase",bindKey:r("Ctrl-Shift-U","Ctrl-Shift-U"),exec:function(e){e.toLowerCase()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"expandtoline",description:"Expand to line",bindKey:r("Ctrl-Shift-L","Command-Shift-L"),exec:function(e){var t=e.selection.getRange();t.start.column=t.end.column=0,t.end.row++,e.selection.setRange(t,!1)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"joinlines",description:"Join lines",bindKey:r(null,null),exec:function(e){for(var t=e.selection.isBackwards(),i=t?e.selection.getSelectionLead():e.selection.getSelectionAnchor(),n=t?e.selection.getSelectionAnchor():e.selection.getSelectionLead(),r=e.session.doc.getLine(i.row).length,o=e.session.doc.getTextRange(e.selection.getRange()).replace(/\n\s*/," ").length,s=e.session.doc.getLine(i.row),a=i.row+1;a<=n.row+1;a++){var l=c.stringTrimLeft(c.stringTrimRight(e.session.doc.getLine(a)));0!==l.length&&(l=" "+l),s+=l}n.row+1<e.session.doc.getLength()-1&&(s+=e.session.doc.getNewLineCharacter()),e.clearSelection(),e.session.doc.replace(new h(i.row,0,n.row+2,0),s),0<o?(e.selection.moveCursorTo(i.row,i.column),e.selection.selectTo(i.row,i.column+o)):(r=e.session.doc.getLine(i.row).length>r?r+1:r,e.selection.moveCursorTo(i.row,r))},multiSelectAction:"forEach",readOnly:!0},{name:"invertSelection",description:"Invert selection",bindKey:r(null,null),exec:function(e){var t=e.session.doc.getLength()-1,i=e.session.doc.getLine(t).length,n=e.selection.rangeList.ranges,r=[];n.length<1&&(n=[e.selection.getRange()]);for(var o=0;o<n.length;o++)o==n.length-1&&(n[o].end.row===t&&n[o].end.column===i||r.push(new h(n[o].end.row,n[o].end.column,t,i))),0===o?0===n[o].start.row&&0===n[o].start.column||r.push(new h(0,0,n[o].start.row,n[o].start.column)):r.push(new h(n[o-1].end.row,n[o-1].end.column,n[o].start.row,n[o].start.column));e.exitMultiSelectMode(),e.clearSelection();for(o=0;o<r.length;o++)e.selection.addRange(r[o],!1)},readOnly:!0,scrollIntoView:"none"},{name:"openCommandPallete",description:"Open command pallete",bindKey:r("F1","F1"),exec:function(e){e.prompt({$type:"commands"})},readOnly:!0},{name:"modeSelect",description:"Change language mode...",bindKey:r(null,null),exec:function(e){e.prompt({$type:"modes"})},readOnly:!0}]}),ace.define("ace/editor",["require","exports","module","ace/lib/fixoldbrowsers","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/lib/useragent","ace/keyboard/textinput","ace/mouse/mouse_handler","ace/mouse/fold_handler","ace/keyboard/keybinding","ace/edit_session","ace/search","ace/range","ace/lib/event_emitter","ace/commands/command_manager","ace/commands/default_commands","ace/config","ace/token_iterator","ace/clipboard"],function(e,t,i){"use strict";e("./lib/fixoldbrowsers");var o=e("./lib/oop"),n=e("./lib/dom"),f=e("./lib/lang"),r=e("./lib/useragent"),s=e("./keyboard/textinput").TextInput,a=e("./mouse/mouse_handler").MouseHandler,l=e("./mouse/fold_handler").FoldHandler,c=e("./keyboard/keybinding").KeyBinding,h=e("./edit_session").EditSession,d=e("./search").Search,m=e("./range").Range,u=e("./lib/event_emitter").EventEmitter,g=e("./commands/command_manager").CommandManager,p=e("./commands/default_commands").commands,C=e("./config"),I=e("./token_iterator").TokenIterator,A=e("./clipboard"),v=function(e,t,i){var n=e.getContainerElement();this.container=n,this.renderer=e,this.id="editor"+ ++v.$uid,this.commands=new g(r.isMac?"mac":"win",p),"object"==typeof document&&(this.textInput=new s(e.getTextAreaContainer(),this),this.renderer.textarea=this.textInput.getElement(),this.$mouseHandler=new a(this),new l(this)),this.keyBinding=new c(this),this.$search=(new d).set({wrap:!0}),this.$historyTracker=this.$historyTracker.bind(this),this.commands.on("exec",this.$historyTracker),this.$initOperationListeners(),this._$emitInputEvent=f.delayedCall(function(){this._signal("input",{}),this.session&&this.session.bgTokenizer&&this.session.bgTokenizer.scheduleStart()}.bind(this)),this.on("change",function(e,t){t._$emitInputEvent.schedule(31)}),this.setSession(t||i&&i.session||new h("")),C.resetOptions(this),i&&this.setOptions(i),C._signal("editor",this)};v.$uid=0,function(){o.implement(this,u),this.$initOperationListeners=function(){this.commands.on("exec",this.startOperation.bind(this),!0),this.commands.on("afterExec",this.endOperation.bind(this),!0),this.$opResetTimer=f.delayedCall(this.endOperation.bind(this,!0)),this.on("change",function(){this.curOp||(this.startOperation(),this.curOp.selectionBefore=this.$lastSel),this.curOp.docChanged=!0}.bind(this),!0),this.on("changeSelection",function(){this.curOp||(this.startOperation(),this.curOp.selectionBefore=this.$lastSel),this.curOp.selectionChanged=!0}.bind(this),!0)},this.curOp=null,this.prevOp={},this.startOperation=function(e){if(this.curOp){if(!e||this.curOp.command)return;this.prevOp=this.curOp}e||(this.previousCommand=null,e={}),this.$opResetTimer.schedule(),this.curOp=this.session.curOp={command:e.command||{},args:e.args,scrollTop:this.renderer.scrollTop},this.curOp.selectionBefore=this.selection.toJSON()},this.endOperation=function(e){if(this.curOp){if(e&&!1===e.returnValue)return this.curOp=null;if(1==e&&this.curOp.command&&"mouse"==this.curOp.command.name)return;if(this._signal("beforeEndOperation"),!this.curOp)return;var t=this.curOp.command,i=t&&t.scrollIntoView;if(i){switch(i){case"center-animate":i="animate";case"center":this.renderer.scrollCursorIntoView(null,.5);break;case"animate":case"cursor":this.renderer.scrollCursorIntoView();break;case"selectionPart":var n=this.selection.getRange(),r=this.renderer.layerConfig;(n.start.row>=r.lastRow||n.end.row<=r.firstRow)&&this.renderer.scrollSelectionIntoView(this.selection.anchor,this.selection.lead)}"animate"==i&&this.renderer.animateScrolling(this.curOp.scrollTop)}var o=this.selection.toJSON();this.curOp.selectionAfter=o,this.$lastSel=this.selection.toJSON(),this.session.getUndoManager().addSelection(o),this.prevOp=this.curOp,this.curOp=null}},this.$mergeableCommands=["backspace","del","insertstring"],this.$historyTracker=function(e){if(this.$mergeUndoDeltas){var t=this.prevOp,i=this.$mergeableCommands,n=t.command&&e.command.name==t.command.name;if("insertstring"==e.command.name){var r=e.args;void 0===this.mergeNextCommand&&(this.mergeNextCommand=!0),n=n&&this.mergeNextCommand&&(!/\s/.test(r)||/\s/.test(t.args)),this.mergeNextCommand=!0}else n=n&&-1!==i.indexOf(e.command.name);"always"!=this.$mergeUndoDeltas&&2e3<Date.now()-this.sequenceStartTime&&(n=!1),n?this.session.mergeUndoDeltas=!0:-1!==i.indexOf(e.command.name)&&(this.sequenceStartTime=Date.now())}},this.setKeyboardHandler=function(t,i){if(t&&"string"==typeof t&&"ace"!=t){this.$keybindingId=t;var n=this;C.loadModule(["keybinding",t],function(e){n.$keybindingId==t&&n.keyBinding.setKeyboardHandler(e&&e.handler),i&&i()})}else this.$keybindingId=null,this.keyBinding.setKeyboardHandler(t),i&&i()},this.getKeyboardHandler=function(){return this.keyBinding.getKeyboardHandler()},this.setSession=function(e){if(this.session!=e){this.curOp&&this.endOperation(),this.curOp={};var t=this.session;if(t){this.session.off("change",this.$onDocumentChange),this.session.off("changeMode",this.$onChangeMode),this.session.off("tokenizerUpdate",this.$onTokenizerUpdate),this.session.off("changeTabSize",this.$onChangeTabSize),this.session.off("changeWrapLimit",this.$onChangeWrapLimit),this.session.off("changeWrapMode",this.$onChangeWrapMode),this.session.off("changeFold",this.$onChangeFold),this.session.off("changeFrontMarker",this.$onChangeFrontMarker),this.session.off("changeBackMarker",this.$onChangeBackMarker),this.session.off("changeBreakpoint",this.$onChangeBreakpoint),this.session.off("changeAnnotation",this.$onChangeAnnotation),this.session.off("changeOverwrite",this.$onCursorChange),this.session.off("changeScrollTop",this.$onScrollTopChange),this.session.off("changeScrollLeft",this.$onScrollLeftChange);var i=this.session.getSelection();i.off("changeCursor",this.$onCursorChange),i.off("changeSelection",this.$onSelectionChange)}(this.session=e)?(this.$onDocumentChange=this.onDocumentChange.bind(this),e.on("change",this.$onDocumentChange),this.renderer.setSession(e),this.$onChangeMode=this.onChangeMode.bind(this),e.on("changeMode",this.$onChangeMode),this.$onTokenizerUpdate=this.onTokenizerUpdate.bind(this),e.on("tokenizerUpdate",this.$onTokenizerUpdate),this.$onChangeTabSize=this.renderer.onChangeTabSize.bind(this.renderer),e.on("changeTabSize",this.$onChangeTabSize),this.$onChangeWrapLimit=this.onChangeWrapLimit.bind(this),e.on("changeWrapLimit",this.$onChangeWrapLimit),this.$onChangeWrapMode=this.onChangeWrapMode.bind(this),e.on("changeWrapMode",this.$onChangeWrapMode),this.$onChangeFold=this.onChangeFold.bind(this),e.on("changeFold",this.$onChangeFold),this.$onChangeFrontMarker=this.onChangeFrontMarker.bind(this),this.session.on("changeFrontMarker",this.$onChangeFrontMarker),this.$onChangeBackMarker=this.onChangeBackMarker.bind(this),this.session.on("changeBackMarker",this.$onChangeBackMarker),this.$onChangeBreakpoint=this.onChangeBreakpoint.bind(this),this.session.on("changeBreakpoint",this.$onChangeBreakpoint),this.$onChangeAnnotation=this.onChangeAnnotation.bind(this),this.session.on("changeAnnotation",this.$onChangeAnnotation),this.$onCursorChange=this.onCursorChange.bind(this),this.session.on("changeOverwrite",this.$onCursorChange),this.$onScrollTopChange=this.onScrollTopChange.bind(this),this.session.on("changeScrollTop",this.$onScrollTopChange),this.$onScrollLeftChange=this.onScrollLeftChange.bind(this),this.session.on("changeScrollLeft",this.$onScrollLeftChange),this.selection=e.getSelection(),this.selection.on("changeCursor",this.$onCursorChange),this.$onSelectionChange=this.onSelectionChange.bind(this),this.selection.on("changeSelection",this.$onSelectionChange),this.onChangeMode(),this.onCursorChange(),
this.onScrollTopChange(),this.onScrollLeftChange(),this.onSelectionChange(),this.onChangeFrontMarker(),this.onChangeBackMarker(),this.onChangeBreakpoint(),this.onChangeAnnotation(),this.session.getUseWrapMode()&&this.renderer.adjustWrapLimit(),this.renderer.updateFull()):(this.selection=null,this.renderer.setSession(e)),this._signal("changeSession",{session:e,oldSession:t}),this.curOp=null,t&&t._signal("changeEditor",{oldEditor:this}),e&&e._signal("changeEditor",{editor:this}),e&&e.bgTokenizer&&e.bgTokenizer.scheduleStart()}},this.getSession=function(){return this.session},this.setValue=function(e,t){return this.session.doc.setValue(e),t?1==t?this.navigateFileEnd():-1==t&&this.navigateFileStart():this.selectAll(),e},this.getValue=function(){return this.session.getValue()},this.getSelection=function(){return this.selection},this.resize=function(e){this.renderer.onResize(e)},this.setTheme=function(e,t){this.renderer.setTheme(e,t)},this.getTheme=function(){return this.renderer.getTheme()},this.setStyle=function(e){this.renderer.setStyle(e)},this.unsetStyle=function(e){this.renderer.unsetStyle(e)},this.getFontSize=function(){return this.getOption("fontSize")||n.computedStyle(this.container).fontSize},this.setFontSize=function(e){this.setOption("fontSize",e)},this.$highlightBrackets=function(){if(this.session.$bracketHighlight&&(this.session.removeMarker(this.session.$bracketHighlight),this.session.$bracketHighlight=null),!this.$highlightPending){var n=this;this.$highlightPending=!0,setTimeout(function(){n.$highlightPending=!1;var e=n.session;if(e&&e.bgTokenizer){var t=e.findMatchingBracket(n.getCursorPosition());if(t)var i=new m(t.row,t.column,t.row,t.column+1);else if(e.$mode.getMatching)i=e.$mode.getMatching(n.session);i&&(e.$bracketHighlight=e.addMarker(i,"ace_bracket","text"))}},50)}},this.$highlightTags=function(){if(!this.$highlightTagPending){var d=this;this.$highlightTagPending=!0,setTimeout(function(){d.$highlightTagPending=!1;var e=d.session;if(e&&e.bgTokenizer){var t=d.getCursorPosition(),i=new I(d.session,t.row,t.column),n=i.getCurrentToken();if(!n||!/\b(?:tag-open|tag-name)/.test(n.type))return e.removeMarker(e.$tagHighlight),void(e.$tagHighlight=null);if(-1==n.type.indexOf("tag-open")||(n=i.stepForward())){var r=n.value,o=0,s=i.stepBackward();if("<"==s.value)for(;s=n,(n=i.stepForward())&&n.value===r&&-1!==n.type.indexOf("tag-name")&&("<"===s.value?o++:"</"===s.value&&o--),n&&0<=o;);else{for(;n=s,s=i.stepBackward(),n&&n.value===r&&-1!==n.type.indexOf("tag-name")&&("<"===s.value?o++:"</"===s.value&&o--),s&&o<=0;);i.stepForward()}if(!n)return e.removeMarker(e.$tagHighlight),void(e.$tagHighlight=null);var a=i.getCurrentTokenRow(),l=i.getCurrentTokenColumn(),c=new m(a,l,a,l+n.value.length),h=e.$backMarkers[e.$tagHighlight];e.$tagHighlight&&null!=h&&0!==c.compareRange(h.range)&&(e.removeMarker(e.$tagHighlight),e.$tagHighlight=null),e.$tagHighlight||(e.$tagHighlight=e.addMarker(c,"ace_bracket","text"))}}},50)}},this.focus=function(){var e=this;setTimeout(function(){e.isFocused()||e.textInput.focus()}),this.textInput.focus()},this.isFocused=function(){return this.textInput.isFocused()},this.blur=function(){this.textInput.blur()},this.onFocus=function(e){this.$isFocused||(this.$isFocused=!0,this.renderer.showCursor(),this.renderer.visualizeFocus(),this._emit("focus",e))},this.onBlur=function(e){this.$isFocused&&(this.$isFocused=!1,this.renderer.hideCursor(),this.renderer.visualizeBlur(),this._emit("blur",e))},this.$cursorChange=function(){this.renderer.updateCursor()},this.onDocumentChange=function(e){var t=this.session.$useWrapMode,i=e.start.row==e.end.row?e.end.row:1/0;this.renderer.updateLines(e.start.row,i,t),this._signal("change",e),this.$cursorChange(),this.$updateHighlightActiveLine()},this.onTokenizerUpdate=function(e){var t=e.data;this.renderer.updateLines(t.first,t.last)},this.onScrollTopChange=function(){this.renderer.scrollToY(this.session.getScrollTop())},this.onScrollLeftChange=function(){this.renderer.scrollToX(this.session.getScrollLeft())},this.onCursorChange=function(){this.$cursorChange(),this.$highlightBrackets(),this.$highlightTags(),this.$updateHighlightActiveLine(),this._signal("changeSelection")},this.$updateHighlightActiveLine=function(){var e,t=this.getSession();if(this.$highlightActiveLine&&("line"==this.$selectionStyle&&this.selection.isMultiLine()||(e=this.getCursorPosition()),this.renderer.theme&&this.renderer.theme.$selectionColorConflict&&!this.selection.isEmpty()&&(e=!1),!this.renderer.$maxLines||1!==this.session.getLength()||1<this.renderer.$minLines||(e=!1)),t.$highlightLineMarker&&!e)t.removeMarker(t.$highlightLineMarker.id),t.$highlightLineMarker=null;else if(!t.$highlightLineMarker&&e){var i=new m(e.row,e.column,e.row,1/0);i.id=t.addMarker(i,"ace_active-line","screenLine"),t.$highlightLineMarker=i}else e&&(t.$highlightLineMarker.start.row=e.row,t.$highlightLineMarker.end.row=e.row,t.$highlightLineMarker.start.column=e.column,t._signal("changeBackMarker"))},this.onSelectionChange=function(e){var t=this.session;if(t.$selectionMarker&&t.removeMarker(t.$selectionMarker),t.$selectionMarker=null,this.selection.isEmpty())this.$updateHighlightActiveLine();else{var i=this.selection.getRange(),n=this.getSelectionStyle();t.$selectionMarker=t.addMarker(i,"ace_selection",n)}var r=this.$highlightSelectedWord&&this.$getSelectionHighLightRegexp();this.session.highlight(r),this._signal("changeSelection")},this.$getSelectionHighLightRegexp=function(){var e=this.session,t=this.getSelectionRange();if(!t.isEmpty()&&!t.isMultiLine()){var i=t.start.column,n=t.end.column,r=e.getLine(t.start.row),o=r.substring(i,n);if(!(5e3<o.length)&&/[\w\d]/.test(o)){var s=this.$search.$assembleRegExp({wholeWord:!0,caseSensitive:!0,needle:o}),a=r.substring(i-1,n+1);if(s.test(a))return s}}},this.onChangeFrontMarker=function(){this.renderer.updateFrontMarkers()},this.onChangeBackMarker=function(){this.renderer.updateBackMarkers()},this.onChangeBreakpoint=function(){this.renderer.updateBreakpoints()},this.onChangeAnnotation=function(){this.renderer.setAnnotations(this.session.getAnnotations())},this.onChangeMode=function(e){this.renderer.updateText(),this._emit("changeMode",e)},this.onChangeWrapLimit=function(){this.renderer.updateFull()},this.onChangeWrapMode=function(){this.renderer.onResize(!0)},this.onChangeFold=function(){this.$updateHighlightActiveLine(),this.renderer.updateFull()},this.getSelectedText=function(){return this.session.getTextRange(this.getSelectionRange())},this.getCopyText=function(){var e=this.getSelectedText(),t=this.session.doc.getNewLineCharacter(),i=!1;if(!e&&this.$copyWithEmptySelection){i=!0;for(var n=this.selection.getAllRanges(),r=0;r<n.length;r++){var o=n[r];r&&n[r-1].start.row==o.start.row||(e+=this.session.getLine(o.start.row)+t)}}var s={text:e};return this._signal("copy",s),A.lineMode=i?s.text:"",s.text},this.onCopy=function(){this.commands.exec("copy",this)},this.onCut=function(){this.commands.exec("cut",this)},this.onPaste=function(e,t){var i={text:e,event:t};this.commands.exec("paste",this,i)},this.$handlePaste=function(e){"string"==typeof e&&(e={text:e}),this._signal("paste",e);var t=e.text,i=t==A.lineMode,n=this.session;if(!this.inMultiSelectMode||this.inVirtualSelectionMode)i?n.insert({row:this.selection.lead.row,column:0},t):this.insert(t);else if(i)this.selection.rangeList.ranges.forEach(function(e){n.insert({row:e.start.row,column:0},t)});else{var r=t.split(/\r\n|\r|\n/),o=this.selection.rangeList.ranges,s=!(2!=r.length||r[0]&&r[1]);if(r.length!=o.length||s)return this.commands.exec("insertstring",this,t);for(var a=o.length;a--;){var l=o[a];l.isEmpty()||n.remove(l),n.insert(l.start,r[a])}}},this.execCommand=function(e,t){return this.commands.exec(e,this,t)},this.insert=function(e,t){var i=this.session,n=i.getMode(),r=this.getCursorPosition();if(this.getBehavioursEnabled()&&!t){var o=n.transformAction(i.getState(r.row),"insertion",this,i,e);o&&(e!==o.text&&(this.inVirtualSelectionMode||(this.session.mergeUndoDeltas=!1,this.mergeNextCommand=!1)),e=o.text)}if("\t"==e&&(e=this.session.getTabString()),this.selection.isEmpty()){if(this.session.getOverwrite()&&-1==e.indexOf("\n")){(s=new m.fromPoints(r,r)).end.column+=e.length,this.session.remove(s)}}else{var s=this.getSelectionRange();r=this.session.remove(s),this.clearSelection()}if("\n"==e||"\r\n"==e){var a=i.getLine(r.row);if(r.column>a.search(/\S|$/)){var l=a.substr(r.column).search(/\S|$/);i.doc.removeInLine(r.row,r.column,r.column+l)}}this.clearSelection();var c=r.column,h=i.getState(r.row),d=(a=i.getLine(r.row),n.checkOutdent(h,a,e));if(i.insert(r,e),o&&o.selection&&(2==o.selection.length?this.selection.setSelectionRange(new m(r.row,c+o.selection[0],r.row,c+o.selection[1])):this.selection.setSelectionRange(new m(r.row+o.selection[0],o.selection[1],r.row+o.selection[2],o.selection[3]))),i.getDocument().isNewLine(e)){var u=n.getNextLineIndent(h,a.slice(0,r.column),i.getTabString());i.insert({row:r.row+1,column:0},u)}d&&n.autoOutdent(h,i,r.row)},this.onTextInput=function(e,t){if(!t)return this.keyBinding.onTextInput(e);this.startOperation({command:{name:"insertstring"}});var i=this.applyComposition.bind(this,e,t);this.selection.rangeCount?this.forEachSelection(i):i(),this.endOperation()},this.applyComposition=function(e,t){var i;(t.extendLeft||t.extendRight)&&((i=this.selection.getRange()).start.column-=t.extendLeft,i.end.column+=t.extendRight,this.selection.setRange(i),e||i.isEmpty()||this.remove());!e&&this.selection.isEmpty()||this.insert(e,!0),(t.restoreStart||t.restoreEnd)&&((i=this.selection.getRange()).start.column-=t.restoreStart,i.end.column-=t.restoreEnd,this.selection.setRange(i))},this.onCommandKey=function(e,t,i){return this.keyBinding.onCommandKey(e,t,i)},this.setOverwrite=function(e){this.session.setOverwrite(e)},this.getOverwrite=function(){return this.session.getOverwrite()},this.toggleOverwrite=function(){this.session.toggleOverwrite()},this.setScrollSpeed=function(e){this.setOption("scrollSpeed",e)},this.getScrollSpeed=function(){return this.getOption("scrollSpeed")},this.setDragDelay=function(e){this.setOption("dragDelay",e)},this.getDragDelay=function(){return this.getOption("dragDelay")},this.setSelectionStyle=function(e){this.setOption("selectionStyle",e)},this.getSelectionStyle=function(){return this.getOption("selectionStyle")},this.setHighlightActiveLine=function(e){this.setOption("highlightActiveLine",e)},this.getHighlightActiveLine=function(){return this.getOption("highlightActiveLine")},this.setHighlightGutterLine=function(e){this.setOption("highlightGutterLine",e)},this.getHighlightGutterLine=function(){return this.getOption("highlightGutterLine")},this.setHighlightSelectedWord=function(e){this.setOption("highlightSelectedWord",e)},this.getHighlightSelectedWord=function(){return this.$highlightSelectedWord},this.setAnimatedScroll=function(e){this.renderer.setAnimatedScroll(e)},this.getAnimatedScroll=function(){return this.renderer.getAnimatedScroll()},this.setShowInvisibles=function(e){this.renderer.setShowInvisibles(e)},this.getShowInvisibles=function(){return this.renderer.getShowInvisibles()},this.setDisplayIndentGuides=function(e){this.renderer.setDisplayIndentGuides(e)},this.getDisplayIndentGuides=function(){return this.renderer.getDisplayIndentGuides()},this.setShowPrintMargin=function(e){this.renderer.setShowPrintMargin(e)},this.getShowPrintMargin=function(){return this.renderer.getShowPrintMargin()},this.setPrintMarginColumn=function(e){this.renderer.setPrintMarginColumn(e)},this.getPrintMarginColumn=function(){return this.renderer.getPrintMarginColumn()},this.setReadOnly=function(e){this.setOption("readOnly",e)},this.getReadOnly=function(){return this.getOption("readOnly")},this.setBehavioursEnabled=function(e){this.setOption("behavioursEnabled",e)},this.getBehavioursEnabled=function(){return this.getOption("behavioursEnabled")},this.setWrapBehavioursEnabled=function(e){this.setOption("wrapBehavioursEnabled",e)},this.getWrapBehavioursEnabled=function(){return this.getOption("wrapBehavioursEnabled")},this.setShowFoldWidgets=function(e){this.setOption("showFoldWidgets",e)},this.getShowFoldWidgets=function(){return this.getOption("showFoldWidgets")},this.setFadeFoldWidgets=function(e){this.setOption("fadeFoldWidgets",e)},this.getFadeFoldWidgets=function(){return this.getOption("fadeFoldWidgets")},this.remove=function(e){this.selection.isEmpty()&&("left"==e?this.selection.selectLeft():this.selection.selectRight());var t=this.getSelectionRange();if(this.getBehavioursEnabled()){var i=this.session,n=i.getState(t.start.row),r=i.getMode().transformAction(n,"deletion",this,i,t);if(0===t.end.column){var o=i.getTextRange(t);if("\n"==o[o.length-1]){var s=i.getLine(t.end.row);/^\s+$/.test(s)&&(t.end.column=s.length)}}r&&(t=r)}this.session.remove(t),this.clearSelection()},this.removeWordRight=function(){this.selection.isEmpty()&&this.selection.selectWordRight(),this.session.remove(this.getSelectionRange()),this.clearSelection()},this.removeWordLeft=function(){this.selection.isEmpty()&&this.selection.selectWordLeft(),this.session.remove(this.getSelectionRange()),this.clearSelection()},this.removeToLineStart=function(){this.selection.isEmpty()&&this.selection.selectLineStart(),this.selection.isEmpty()&&this.selection.selectLeft(),this.session.remove(this.getSelectionRange()),this.clearSelection()},this.removeToLineEnd=function(){this.selection.isEmpty()&&this.selection.selectLineEnd();var e=this.getSelectionRange();e.start.column==e.end.column&&e.start.row==e.end.row&&(e.end.column=0,e.end.row++),this.session.remove(e),this.clearSelection()},this.splitLine=function(){this.selection.isEmpty()||(this.session.remove(this.getSelectionRange()),this.clearSelection());var e=this.getCursorPosition();this.insert("\n"),this.moveCursorToPosition(e)},this.transposeLetters=function(){if(this.selection.isEmpty()){var e=this.getCursorPosition(),t=e.column;if(0!==t){var i,n,r=this.session.getLine(e.row);n=t<r.length?(i=r.charAt(t)+r.charAt(t-1),new m(e.row,t-1,e.row,t+1)):(i=r.charAt(t-1)+r.charAt(t-2),new m(e.row,t-2,e.row,t)),this.session.replace(n,i),this.session.selection.moveToPosition(n.end)}}},this.toLowerCase=function(){var e=this.getSelectionRange();this.selection.isEmpty()&&this.selection.selectWord();var t=this.getSelectionRange(),i=this.session.getTextRange(t);this.session.replace(t,i.toLowerCase()),this.selection.setSelectionRange(e)},this.toUpperCase=function(){var e=this.getSelectionRange();this.selection.isEmpty()&&this.selection.selectWord();var t=this.getSelectionRange(),i=this.session.getTextRange(t);this.session.replace(t,i.toUpperCase()),this.selection.setSelectionRange(e)},this.indent=function(){var e=this.session,t=this.getSelectionRange();if(!(t.start.row<t.end.row)){if(t.start.column<t.end.column){var i=e.getTextRange(t);if(!/^\s+$/.test(i)){c=this.$getSelectedRows();return void e.indentRows(c.first,c.last,"\t")}}var n=e.getLine(t.start.row),r=t.start,o=e.getTabSize(),s=e.documentToScreenColumn(r.row,r.column);if(this.session.getUseSoftTabs())var a=o-s%o,l=f.stringRepeat(" ",a);else{for(a=s%o;" "==n[t.start.column-1]&&a;)t.start.column--,a--;this.selection.setSelectionRange(t),l="\t"}return this.insert(l)}var c=this.$getSelectedRows();e.indentRows(c.first,c.last,"\t")},this.blockIndent=function(){var e=this.$getSelectedRows();this.session.indentRows(e.first,e.last,"\t")},this.blockOutdent=function(){var e=this.session.getSelection();this.session.outdentRows(e.getRange())},this.sortLines=function(){for(var e=this.$getSelectedRows(),t=this.session,i=[],n=e.first;n<=e.last;n++)i.push(t.getLine(n));i.sort(function(e,t){return e.toLowerCase()<t.toLowerCase()?-1:e.toLowerCase()>t.toLowerCase()?1:0});var r=new m(0,0,0,0);for(n=e.first;n<=e.last;n++){var o=t.getLine(n);r.start.row=n,r.end.row=n,r.end.column=o.length,t.replace(r,i[n-e.first])}},this.toggleCommentLines=function(){var e=this.session.getState(this.getCursorPosition().row),t=this.$getSelectedRows();this.session.getMode().toggleCommentLines(e,this.session,t.first,t.last)},this.toggleBlockComment=function(){var e=this.getCursorPosition(),t=this.session.getState(e.row),i=this.getSelectionRange();this.session.getMode().toggleBlockComment(t,this.session,i,e)},this.getNumberAt=function(e,t){var i=/[\-]?[0-9]+(?:\.[0-9]+)?/g;i.lastIndex=0;for(var n=this.session.getLine(e);i.lastIndex<t;){var r=i.exec(n);if(r.index<=t&&r.index+r[0].length>=t)return{value:r[0],start:r.index,end:r.index+r[0].length}}return null},this.modifyNumber=function(e){var t=this.selection.getCursor().row,i=this.selection.getCursor().column,n=new m(t,i-1,t,i),r=this.session.getTextRange(n);if(!isNaN(parseFloat(r))&&isFinite(r)){var o=this.getNumberAt(t,i);if(o){var s=0<=o.value.indexOf(".")?o.start+o.value.indexOf(".")+1:o.end,a=o.start+o.value.length-s,l=parseFloat(o.value);l*=Math.pow(10,a),s!==o.end&&i<s?e*=Math.pow(10,o.end-i-1):e*=Math.pow(10,o.end-i),l+=e;var c=(l/=Math.pow(10,a)).toFixed(a),h=new m(t,o.start,t,o.end);this.session.replace(h,c),this.moveCursorTo(t,Math.max(o.start+1,i+c.length-o.value.length))}}else this.toggleWord()},this.$toggleWordPairs=[["first","last"],["true","false"],["yes","no"],["width","height"],["top","bottom"],["right","left"],["on","off"],["x","y"],["get","set"],["max","min"],["horizontal","vertical"],["show","hide"],["add","remove"],["up","down"],["before","after"],["even","odd"],["in","out"],["inside","outside"],["next","previous"],["increase","decrease"],["attach","detach"],["&&","||"],["==","!="]],this.toggleWord=function(){var i=this.selection.getCursor().row,e=this.selection.getCursor().column;this.selection.selectWord();var n=this.getSelectedText(),r=this.selection.getWordRange().start.column,t=n.replace(/([a-z]+|[A-Z]+)(?=[A-Z_]|$)/g,"$1 ").split(/\s/),o=e-r-1;o<0&&(o=0);var s=0,a=0,l=this;n.match(/[A-Za-z0-9_]+/)&&t.forEach(function(e,t){a=s+e.length,s<=o&&o<=a&&(n=e,l.selection.clearSelection(),l.moveCursorTo(i,s+r),l.selection.selectTo(i,a+r)),s=a});for(var c,h=this.$toggleWordPairs,d=0;d<h.length;d++)for(var u=h[d],g=0;g<=1;g++){var p=+!g,m=n.match(new RegExp("^\\s?_?("+f.escapeRegExp(u[g])+")\\s?$","i"));if(m)n.match(new RegExp("([_]|^|\\s)("+f.escapeRegExp(m[1])+")($|\\s)","g"))&&(c=n.replace(new RegExp(f.escapeRegExp(u[g]),"i"),function(e){var t=u[p];return e.toUpperCase()==e?t=t.toUpperCase():e.charAt(0).toUpperCase()==e.charAt(0)&&(t=t.substr(0,0)+u[p].charAt(0).toUpperCase()+t.substr(1)),t}),this.insert(c),c="")}},this.removeLines=function(){var e=this.$getSelectedRows();this.session.removeFullLines(e.first,e.last),this.clearSelection()},this.duplicateSelection=function(){var e=this.selection,t=this.session,i=e.getRange(),n=e.isBackwards();if(i.isEmpty()){var r=i.start.row;t.duplicateLines(r,r)}else{var o=n?i.start:i.end,s=t.insert(o,t.getTextRange(i),!1);i.start=o,i.end=s,e.setSelectionRange(i,n)}},this.moveLinesDown=function(){this.$moveLines(1,!1)},this.moveLinesUp=function(){this.$moveLines(-1,!1)},this.moveText=function(e,t,i){return this.session.moveText(e,t,i)},this.copyLinesUp=function(){this.$moveLines(-1,!0)},this.copyLinesDown=function(){this.$moveLines(1,!0)},this.$moveLines=function(e,t){var i,n,r=this.selection;if(!r.inMultiSelectMode||this.inVirtualSelectionMode){var o=r.toOrientedRange();i=this.$getSelectedRows(o),n=this.session.$moveLines(i.first,i.last,t?0:e),t&&-1==e&&(n=0),o.moveBy(n,0),r.fromOrientedRange(o)}else{var s=r.rangeList.ranges;r.rangeList.detach(this.session),this.inVirtualSelectionMode=!0;for(var a=0,l=0,c=s.length,h=0;h<c;h++){var d=h;s[h].moveBy(a,0);for(var u=(i=this.$getSelectedRows(s[h])).first,g=i.last;++h<c;){l&&s[h].moveBy(l,0);var p=this.$getSelectedRows(s[h]);if(t&&p.first!=g)break;if(!t&&p.first>g+1)break;g=p.last}for(h--,a=this.session.$moveLines(u,g,t?0:e),t&&-1==e&&(d=h+1);d<=h;)s[d].moveBy(a,0),d++;t||(a=0),l+=a}r.fromOrientedRange(r.ranges[0]),r.rangeList.attach(this.session),this.inVirtualSelectionMode=!1}},this.$getSelectedRows=function(e){return e=(e||this.getSelectionRange()).collapseRows(),{first:this.session.getRowFoldStart(e.start.row),last:this.session.getRowFoldEnd(e.end.row)}},this.onCompositionStart=function(e){this.renderer.showComposition(e)},this.onCompositionUpdate=function(e){this.renderer.setCompositionText(e)},this.onCompositionEnd=function(){this.renderer.hideComposition()},this.getFirstVisibleRow=function(){return this.renderer.getFirstVisibleRow()},this.getLastVisibleRow=function(){return this.renderer.getLastVisibleRow()},this.isRowVisible=function(e){return e>=this.getFirstVisibleRow()&&e<=this.getLastVisibleRow()},this.isRowFullyVisible=function(e){return e>=this.renderer.getFirstFullyVisibleRow()&&e<=this.renderer.getLastFullyVisibleRow()},this.$getVisibleRowCount=function(){return this.renderer.getScrollBottomRow()-this.renderer.getScrollTopRow()+1},this.$moveByPage=function(e,t){var i=this.renderer,n=this.renderer.layerConfig,r=e*Math.floor(n.height/n.lineHeight);!0===t?this.selection.$moveSelection(function(){this.moveCursorBy(r,0)}):!1===t&&(this.selection.moveCursorBy(r,0),this.selection.clearSelection());var o=i.scrollTop;i.scrollBy(0,r*n.lineHeight),null!=t&&i.scrollCursorIntoView(null,.5),i.animateScrolling(o)},this.selectPageDown=function(){this.$moveByPage(1,!0)},this.selectPageUp=function(){this.$moveByPage(-1,!0)},this.gotoPageDown=function(){this.$moveByPage(1,!1)},this.gotoPageUp=function(){this.$moveByPage(-1,!1)},this.scrollPageDown=function(){this.$moveByPage(1)},this.scrollPageUp=function(){this.$moveByPage(-1)},this.scrollToRow=function(e){this.renderer.scrollToRow(e)},this.scrollToLine=function(e,t,i,n){this.renderer.scrollToLine(e,t,i,n)},this.centerSelection=function(){var e=this.getSelectionRange(),t={row:Math.floor(e.start.row+(e.end.row-e.start.row)/2),column:Math.floor(e.start.column+(e.end.column-e.start.column)/2)};this.renderer.alignCursor(t,.5)},this.getCursorPosition=function(){return this.selection.getCursor()},this.getCursorPositionScreen=function(){return this.session.documentToScreenPosition(this.getCursorPosition())},this.getSelectionRange=function(){return this.selection.getRange()},this.selectAll=function(){this.selection.selectAll()},this.clearSelection=function(){this.selection.clearSelection()},this.moveCursorTo=function(e,t){this.selection.moveCursorTo(e,t)},this.moveCursorToPosition=function(e){this.selection.moveCursorToPosition(e)},this.jumpToMatching=function(e,t){var i=this.getCursorPosition(),n=new I(this.session,i.row,i.column),r=n.getCurrentToken(),o=r||n.stepForward();if(o){var s,a,l=!1,c={},h=i.column-o.start,d={")":"(","(":"(","]":"[","[":"[","{":"{","}":"{"};do{if(o.value.match(/[{}()\[\]]/g)){for(;h<o.value.length&&!l;h++)if(d[o.value[h]])switch(a=d[o.value[h]]+"."+o.type.replace("rparen","lparen"),isNaN(c[a])&&(c[a]=0),o.value[h]){case"(":case"[":case"{":c[a]++;break;case")":case"]":case"}":c[a]--,-1===c[a]&&(s="bracket",l=!0)}}else-1!==o.type.indexOf("tag-name")&&(isNaN(c[o.value])&&(c[o.value]=0),"<"===r.value?c[o.value]++:"</"===r.value&&c[o.value]--,-1===c[o.value]&&(s="tag",l=!0));l||(r=o,o=n.stepForward(),h=0)}while(o&&!l);if(s){var u,g;if("bracket"===s)(u=this.session.getBracketRange(i))||(g=(u=new m(n.getCurrentTokenRow(),n.getCurrentTokenColumn()+h-1,n.getCurrentTokenRow(),n.getCurrentTokenColumn()+h-1)).start,(t||g.row===i.row&&Math.abs(g.column-i.column)<2)&&(u=this.session.getBracketRange(g)));else if("tag"===s){if(!o||-1===o.type.indexOf("tag-name"))return;var p=o.value;if(0===(u=new m(n.getCurrentTokenRow(),n.getCurrentTokenColumn()-2,n.getCurrentTokenRow(),n.getCurrentTokenColumn()-2)).compare(i.row,i.column))for(l=!1;o=r,(r=n.stepBackward())&&(-1!==r.type.indexOf("tag-close")&&u.setEnd(n.getCurrentTokenRow(),n.getCurrentTokenColumn()+1),o.value===p&&-1!==o.type.indexOf("tag-name")&&("<"===r.value?c[p]++:"</"===r.value&&c[p]--,0===c[p]&&(l=!0))),r&&!l;);o&&o.type.indexOf("tag-name")&&(g=u.start).row==i.row&&Math.abs(g.column-i.column)<2&&(g=u.end)}(g=u&&u.cursor||g)&&(e?u&&t?this.selection.setRange(u):u&&u.isEqual(this.getSelectionRange())?this.clearSelection():this.selection.selectTo(g.row,g.column):this.selection.moveTo(g.row,g.column))}}},this.gotoLine=function(e,t,i){this.selection.clearSelection(),this.session.unfold({row:e-1,column:t||0}),this.exitMultiSelectMode&&this.exitMultiSelectMode(),this.moveCursorTo(e-1,t||0),this.isRowFullyVisible(e-1)||this.scrollToLine(e-1,!0,i)},this.navigateTo=function(e,t){this.selection.moveTo(e,t)},this.navigateUp=function(e){if(this.selection.isMultiLine()&&!this.selection.isBackwards()){var t=this.selection.anchor.getPosition();return this.moveCursorToPosition(t)}this.selection.clearSelection(),this.selection.moveCursorBy(-e||-1,0)},this.navigateDown=function(e){if(this.selection.isMultiLine()&&this.selection.isBackwards()){var t=this.selection.anchor.getPosition();return this.moveCursorToPosition(t)}this.selection.clearSelection(),this.selection.moveCursorBy(e||1,0)},this.navigateLeft=function(e){if(this.selection.isEmpty())for(e=e||1;e--;)this.selection.moveCursorLeft();else{var t=this.getSelectionRange().start;this.moveCursorToPosition(t)}this.clearSelection()},this.navigateRight=function(e){if(this.selection.isEmpty())for(e=e||1;e--;)this.selection.moveCursorRight();else{var t=this.getSelectionRange().end;this.moveCursorToPosition(t)}this.clearSelection()},this.navigateLineStart=function(){this.selection.moveCursorLineStart(),this.clearSelection()},this.navigateLineEnd=function(){this.selection.moveCursorLineEnd(),this.clearSelection()},this.navigateFileEnd=function(){this.selection.moveCursorFileEnd(),this.clearSelection()},this.navigateFileStart=function(){this.selection.moveCursorFileStart(),this.clearSelection()},this.navigateWordRight=function(){this.selection.moveCursorWordRight(),this.clearSelection()},this.navigateWordLeft=function(){this.selection.moveCursorWordLeft(),this.clearSelection()},this.replace=function(e,t){t&&this.$search.set(t);var i=this.$search.find(this.session),n=0;return i&&(this.$tryReplace(i,e)&&(n=1),this.selection.setSelectionRange(i),this.renderer.scrollSelectionIntoView(i.start,i.end)),n},this.replaceAll=function(e,t){t&&this.$search.set(t);var i=this.$search.findAll(this.session),n=0;if(!i.length)return n;var r=this.getSelectionRange();this.selection.moveTo(0,0);for(var o=i.length-1;0<=o;--o)this.$tryReplace(i[o],e)&&n++;return this.selection.setSelectionRange(r),n},this.$tryReplace=function(e,t){var i=this.session.getTextRange(e);return null!==(t=this.$search.replace(i,t))?(e.end=this.session.replace(e,t),e):null},this.getLastSearchOptions=function(){return this.$search.getOptions()},this.find=function(e,t,i){t=t||{},"string"==typeof e||e instanceof RegExp?t.needle=e:"object"==typeof e&&o.mixin(t,e);var n=this.selection.getRange();null==t.needle&&((e=this.session.getTextRange(n)||this.$search.$options.needle)||(n=this.session.getWordRange(n.start.row,n.start.column),e=this.session.getTextRange(n)),this.$search.set({needle:e})),this.$search.set(t),t.start||this.$search.set({start:n});var r=this.$search.find(this.session);return t.preventScroll?r:r?(this.revealRange(r,i),r):(t.backwards?n.start=n.end:n.end=n.start,void this.selection.setRange(n))},this.findNext=function(e,t){this.find({skipCurrent:!0,backwards:!1},e,t)},this.findPrevious=function(e,t){this.find(e,{skipCurrent:!0,backwards:!0},t)},this.revealRange=function(e,t){this.session.unfold(e),this.selection.setSelectionRange(e);var i=this.renderer.scrollTop;this.renderer.scrollSelectionIntoView(e.start,e.end,.5),!1!==t&&this.renderer.animateScrolling(i)},this.undo=function(){this.session.getUndoManager().undo(this.session),this.renderer.scrollCursorIntoView(null,.5)},this.redo=function(){this.session.getUndoManager().redo(this.session),this.renderer.scrollCursorIntoView(null,.5)},this.destroy=function(){this.renderer.destroy(),this._signal("destroy",this),this.session&&this.session.destroy()},this.setAutoScrollEditorIntoView=function(e){if(e){var r,o=this,s=!1;this.$scrollAnchor||(this.$scrollAnchor=document.createElement("div"));var a=this.$scrollAnchor;a.style.cssText="position:absolute",this.container.insertBefore(a,this.container.firstChild);var t=this.on("changeSelection",function(){s=!0}),i=this.renderer.on("beforeRender",function(){s&&(r=o.renderer.container.getBoundingClientRect())}),n=this.renderer.on("afterRender",function(){if(s&&r&&(o.isFocused()||o.searchBox&&o.searchBox.isFocused())){var e=o.renderer,t=e.$cursorLayer.$pixelPos,i=e.layerConfig,n=t.top-i.offset;null!=(s=0<=t.top&&n+r.top<0||!(t.top<i.height&&t.top+r.top+i.lineHeight>window.innerHeight)&&null)&&(a.style.top=n+"px",a.style.left=t.left+"px",a.style.height=i.lineHeight+"px",a.scrollIntoView(s)),s=r=null}});this.setAutoScrollEditorIntoView=function(e){e||(delete this.setAutoScrollEditorIntoView,this.off("changeSelection",t),this.renderer.off("afterRender",n),this.renderer.off("beforeRender",i))}}},this.$resetCursorStyle=function(){var e=this.$cursorStyle||"ace",t=this.renderer.$cursorLayer;t&&(t.setSmoothBlinking(/smooth/.test(e)),t.isBlinking=!this.$readOnly&&"wide"!=e,n.setCssClass(t.element,"ace_slim-cursors",/slim/.test(e)))},this.prompt=function(t,i,n){var r=this;C.loadModule("./ext/prompt",function(e){e.prompt(r,t,i,n)})}}.call(v.prototype),C.defineOptions(v.prototype,"editor",{selectionStyle:{set:function(e){this.onSelectionChange(),this._signal("changeSelectionStyle",{data:e})},initialValue:"line"},highlightActiveLine:{set:function(){this.$updateHighlightActiveLine()},initialValue:!0},highlightSelectedWord:{set:function(e){this.$onSelectionChange()},initialValue:!0},readOnly:{set:function(e){this.textInput.setReadOnly(e),this.$resetCursorStyle()},initialValue:!1},copyWithEmptySelection:{set:function(e){this.textInput.setCopyWithEmptySelection(e)},initialValue:!1},cursorStyle:{set:function(e){this.$resetCursorStyle()},values:["ace","slim","smooth","wide"],initialValue:"ace"},mergeUndoDeltas:{values:[!1,!0,"always"],initialValue:!0},behavioursEnabled:{initialValue:!0},wrapBehavioursEnabled:{initialValue:!0},autoScrollEditorIntoView:{set:function(e){this.setAutoScrollEditorIntoView(e)}},keyboardHandler:{set:function(e){this.setKeyboardHandler(e)},get:function(){return this.$keybindingId},handlesSet:!0},value:{set:function(e){this.session.setValue(e)},get:function(){return this.getValue()},handlesSet:!0,hidden:!0},session:{set:function(e){this.setSession(e)},get:function(){return this.session},handlesSet:!0,hidden:!0},showLineNumbers:{set:function(e){this.renderer.$gutterLayer.setShowLineNumbers(e),this.renderer.$loop.schedule(this.renderer.CHANGE_GUTTER),e&&this.$relativeLineNumbers?b.attach(this):b.detach(this)},initialValue:!0},relativeLineNumbers:{set:function(e){this.$showLineNumbers&&e?b.attach(this):b.detach(this)}},placeholder:{set:function(e){this.$updatePlaceholder||(this.$updatePlaceholder=function(){var e=this.renderer.$composition||this.getValue();if(e&&this.renderer.placeholderNode)this.renderer.off("afterRender",this.$updatePlaceholder),n.removeCssClass(this.container,"ace_hasPlaceholder"),this.renderer.placeholderNode.remove(),this.renderer.placeholderNode=null;else if(!e&&!this.renderer.placeholderNode){this.renderer.on("afterRender",this.$updatePlaceholder),n.addCssClass(this.container,"ace_hasPlaceholder");var t=n.createElement("div");t.className="ace_placeholder",t.textContent=this.$placeholder||"",this.renderer.placeholderNode=t,this.renderer.content.appendChild(this.renderer.placeholderNode)}}.bind(this),this.on("input",this.$updatePlaceholder)),this.$updatePlaceholder()}},hScrollBarAlwaysVisible:"renderer",vScrollBarAlwaysVisible:"renderer",highlightGutterLine:"renderer",animatedScroll:"renderer",showInvisibles:"renderer",showPrintMargin:"renderer",printMarginColumn:"renderer",printMargin:"renderer",fadeFoldWidgets:"renderer",showFoldWidgets:"renderer",displayIndentGuides:"renderer",showGutter:"renderer",fontSize:"renderer",fontFamily:"renderer",maxLines:"renderer",minLines:"renderer",scrollPastEnd:"renderer",fixedWidthGutter:"renderer",theme:"renderer",hasCssTransforms:"renderer",maxPixelHeight:"renderer",useTextareaForIME:"renderer",scrollSpeed:"$mouseHandler",dragDelay:"$mouseHandler",dragEnabled:"$mouseHandler",focusTimeout:"$mouseHandler",tooltipFollowsMouse:"$mouseHandler",firstLineNumber:"session",overwrite:"session",newLineMode:"session",useWorker:"session",useSoftTabs:"session",navigateWithinSoftTabs:"session",tabSize:"session",wrap:"session",indentedSoftWrap:"session",foldStyle:"session",mode:"session"});var b={getText:function(e,t){return(Math.abs(e.selection.lead.row-t)||t+1+(t<9?"·":""))+""},getWidth:function(e,t,i){return Math.max(t.toString().length,(i.lastRow+1).toString().length,2)*i.characterWidth},update:function(e,t){t.renderer.$loop.schedule(t.renderer.CHANGE_GUTTER)},attach:function(e){e.renderer.$gutterLayer.$renderer=this,e.on("changeSelection",this.update),this.update(null,e)},detach:function(e){e.renderer.$gutterLayer.$renderer==this&&(e.renderer.$gutterLayer.$renderer=null),e.off("changeSelection",this.update),this.update(null,e)}};t.Editor=v}),ace.define("ace/undomanager",["require","exports","module","ace/range"],function(e,t,i){"use strict";function n(){this.$maxRev=0,this.$fromUndo=!1,this.reset()}(function(){this.addSession=function(e){this.$session=e},this.add=function(e,t,i){this.$fromUndo||e!=this.$lastDelta&&(!1!==t&&this.lastDeltas||(this.lastDeltas=[],this.$undoStack.push(this.lastDeltas),e.id=this.$rev=++this.$maxRev),"remove"!=e.action&&"insert"!=e.action||(this.$lastDelta=e),this.lastDeltas.push(e))},this.addSelection=function(e,t){this.selections.push({value:e,rev:t||this.$rev})},this.startNewGroup=function(){return this.lastDeltas=null,this.$rev},this.markIgnored=function(e,t){null==t&&(t=this.$rev+1);for(var i=this.$undoStack,n=i.length;n--;){var r=i[n][0];if(r.id<=e)break;r.id<t&&(r.ignore=!0)}this.lastDeltas=null},this.getSelection=function(e,t){for(var i=this.selections,n=i.length;n--;){var r=i[n];if(r.rev<e)return t&&(r=i[n+1]),r}},this.getRevision=function(){return this.$rev},this.getDeltas=function(e,t){null==t&&(t=this.$rev+1);for(var i=this.$undoStack,n=null,r=0,o=i.length;o--;){var s=i[o][0];if(s.id<t&&!n&&(n=o+1),s.id<=e){r=o+1;break}}return i.slice(r,n)},this.getChangedRanges=function(e,t){null==t&&(t=this.$rev+1)},this.getChangedLines=function(e,t){null==t&&(t=this.$rev+1)},this.undo=function(e,t){this.lastDeltas=null;var i=this.$undoStack;if(function(e,t){for(var i=t;i--;){var n=e[i];if(n&&!n[0].ignore){for(;i<t-1;){var r=h(e[i],e[i+1]);e[i]=r[0],e[i+1]=r[1],i++}return!0}}}(i,i.length)){e=e||this.$session,this.$redoStackBaseRev!==this.$rev&&this.$redoStack.length&&(this.$redoStack=[]),this.$fromUndo=!0;var n=i.pop(),r=null;return n&&n.length&&(r=e.undoChanges(n,t),this.$redoStack.push(n),this.$syncRev()),this.$fromUndo=!1,r}},this.redo=function(e,t){if(this.lastDeltas=null,e=e||this.$session,this.$fromUndo=!0,this.$redoStackBaseRev!=this.$rev){var i=this.getDeltas(this.$redoStackBaseRev,this.$rev+1);!function(e,t){for(var i=0;i<t.length;i++)for(var n=t[i],r=0;r<n.length;r++)m(e,n[r])}(this.$redoStack,i),this.$redoStackBaseRev=this.$rev,this.$redoStack.forEach(function(e){e[0].id=++this.$maxRev},this)}var n=this.$redoStack.pop(),r=null;return n&&(r=e.redoChanges(n,t),this.$undoStack.push(n),this.$syncRev()),this.$fromUndo=!1,r},this.$syncRev=function(){var e=this.$undoStack,t=e[e.length-1],i=t&&t[0].id||0;this.$redoStackBaseRev=i,this.$rev=i},this.reset=function(){this.lastDeltas=null,this.$lastDelta=null,this.$undoStack=[],this.$redoStack=[],this.$rev=0,this.mark=0,this.$redoStackBaseRev=this.$rev,this.selections=[]},this.canUndo=function(){return 0<this.$undoStack.length},this.canRedo=function(){return 0<this.$redoStack.length},this.bookmark=function(e){null==e&&(e=this.$rev),this.mark=e},this.isAtBookmark=function(){return this.$rev===this.mark},this.toJSON=function(){},this.fromJSON=function(){},this.hasUndo=this.canUndo,this.hasRedo=this.canRedo,this.isClean=this.isAtBookmark,this.markClean=this.bookmark,this.$prettyPrint=function(e){return e?r(e):r(this.$undoStack)+"\n---\n"+r(this.$redoStack)}}).call(n.prototype);var s=e("./range").Range,a=s.comparePoints;s.comparePoints;function l(e){return{row:e.row,column:e.column}}function r(e){if(e=e||this,Array.isArray(e))return e.map(r).join("\n");var t="";return e.action?(t="insert"==e.action?"+":"-",t+="["+e.lines+"]"):e.value&&(t=Array.isArray(e.value)?e.value.map(o).join("\n"):o(e.value)),e.start&&(t+=o(e)),(e.id||e.rev)&&(t+="\t("+(e.id||e.rev)+")"),t}function o(e){return e.start.row+":"+e.start.column+"=>"+e.end.row+":"+e.end.column}function c(e,t){var i="insert"==e.action,n="insert"==t.action;if(i&&n)if(0<=a(t.start,e.end))u(t,e,-1);else{if(!(a(t.start,e.start)<=0))return null;u(e,t,1)}else if(i&&!n)if(0<=a(t.start,e.end))u(t,e,-1);else{if(!(a(t.end,e.start)<=0))return null;u(e,t,-1)}else if(!i&&n)if(0<=a(t.start,e.start))u(t,e,1);else{if(!(a(t.start,e.start)<=0))return null;u(e,t,1)}else if(!i&&!n)if(0<=a(t.start,e.start))u(t,e,1);else{if(!(a(t.end,e.start)<=0))return null;u(e,t,-1)}return[t,e]}function h(e,t){for(var i=e.length;i--;)for(var n=0;n<t.length;n++)if(!c(e[i],t[n])){for(;i<e.length;){for(;n--;)c(t[n],e[i]);n=t.length,i++}return[e,t]}return e.selectionBefore=t.selectionBefore=e.selectionAfter=t.selectionAfter=null,[t,e]}function d(e,t){var i="insert"==e.action,n="insert"==t.action;if(i&&n)a(e.start,t.start)<0?u(t,e,1):u(e,t,1);else if(i&&!n)0<=a(e.start,t.end)?u(e,t,-1):(a(e.start,t.start)<=0||u(e,s.fromPoints(t.start,e.start),-1),u(t,e,1));else if(!i&&n)0<=a(t.start,e.end)?u(t,e,-1):(a(t.start,e.start)<=0||u(t,s.fromPoints(e.start,t.start),-1),u(e,t,1));else if(!i&&!n)if(0<=a(t.start,e.end))u(t,e,-1);else{var r,o;if(!(a(t.end,e.start)<=0))return a(e.start,t.start)<0&&(e=p(r=e,t.start)),0<a(e.end,t.end)&&(o=p(e,t.end)),g(t.end,e.start,e.end,-1),o&&!r&&(e.lines=o.lines,e.start=o.start,e.end=o.end,o=e),[t,r,o].filter(Boolean);u(e,t,-1)}return[t,e]}function u(e,t,i){g(e.start,t.start,t.end,i),g(e.end,t.start,t.end,i)}function g(e,t,i,n){e.row==(1==n?t:i).row&&(e.column+=n*(i.column-t.column)),e.row+=n*(i.row-t.row)}function p(e,t){var i=e.lines,n=e.end;e.end=l(t);var r=e.end.row-e.start.row,o=i.splice(r,i.length),s=r?t.column:t.column-e.start.column;return i.push(o[0].substring(0,s)),o[0]=o[0].substr(s),{start:l(t),end:n,lines:o,action:e.action}}function m(e,t){t=function(e){return{start:l(e.start),end:l(e.end),action:e.action,lines:e.lines.slice()}}(t);for(var i=e.length;i--;){for(var n=e[i],r=0;r<n.length;r++){var o=d(n[r],t);t=o[0],2!=o.length&&(o[2]?(n.splice(r+1,1,o[1],o[2]),r++):o[1]||(n.splice(r,1),r--))}n.length||e.splice(i,1)}return e}t.UndoManager=n}),ace.define("ace/layer/lines",["require","exports","module","ace/lib/dom"],function(e,t,i){"use strict";function n(e,t){this.element=e,this.canvasHeight=t||5e5,this.element.style.height=2*this.canvasHeight+"px",this.cells=[],this.cellCache=[],this.$offsetCoefficient=0}var s=e("../lib/dom");(function(){this.moveContainer=function(e){s.translate(this.element,0,-e.firstRowScreen*e.lineHeight%this.canvasHeight-e.offset*this.$offsetCoefficient)},this.pageChanged=function(e,t){return Math.floor(e.firstRowScreen*e.lineHeight/this.canvasHeight)!==Math.floor(t.firstRowScreen*t.lineHeight/this.canvasHeight)},this.computeLineTop=function(e,t,i){var n=t.firstRowScreen*t.lineHeight,r=Math.floor(n/this.canvasHeight);return i.documentToScreenRow(e,0)*t.lineHeight-r*this.canvasHeight},this.computeLineHeight=function(e,t,i){return t.lineHeight*i.getRowLength(e)},this.getLength=function(){return this.cells.length},this.get=function(e){return this.cells[e]},this.shift=function(){this.$cacheCell(this.cells.shift())},this.pop=function(){this.$cacheCell(this.cells.pop())},this.push=function(e){if(Array.isArray(e)){this.cells.push.apply(this.cells,e);for(var t=s.createFragment(this.element),i=0;i<e.length;i++)t.appendChild(e[i].element);this.element.appendChild(t)}else this.cells.push(e),this.element.appendChild(e.element)},this.unshift=function(e){if(Array.isArray(e)){this.cells.unshift.apply(this.cells,e);for(var t=s.createFragment(this.element),i=0;i<e.length;i++)t.appendChild(e[i].element);this.element.firstChild?this.element.insertBefore(t,this.element.firstChild):this.element.appendChild(t)}else this.cells.unshift(e),this.element.insertAdjacentElement("afterbegin",e.element)},this.last=function(){return this.cells.length?this.cells[this.cells.length-1]:null},this.$cacheCell=function(e){e&&(e.element.remove(),this.cellCache.push(e))},this.createCell=function(e,t,i,n){var r=this.cellCache.pop();if(!r){var o=s.createElement("div");n&&n(o),this.element.appendChild(o),r={element:o,text:"",row:e}}return r.row=e,r}}).call(n.prototype),t.Lines=n}),ace.define("ace/layer/gutter",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/lang","ace/lib/event_emitter","ace/layer/lines"],function(e,t,i){"use strict";function n(e){this.element=I.createElement("div"),this.element.className="ace_layer ace_gutter-layer",e.appendChild(this.element),this.setShowFoldWidgets(this.$showFoldWidgets),this.gutterWidth=0,this.$annotations=[],this.$updateAnnotations=this.$updateAnnotations.bind(this),this.$lines=new s(this.element),this.$lines.$offsetCoefficient=1}var I=e("../lib/dom"),r=e("../lib/oop"),a=e("../lib/lang"),o=e("../lib/event_emitter").EventEmitter,s=e("./lines").Lines;function c(e){var t=document.createTextNode("");e.appendChild(t);var i=I.createElement("span");return e.appendChild(i),e}(function(){r.implement(this,o),this.setSession=function(e){this.session&&this.session.removeEventListener("change",this.$updateAnnotations),(this.session=e)&&e.on("change",this.$updateAnnotations)},this.addGutterDecoration=function(e,t){window.console&&console.warn&&console.warn("deprecated use session.addGutterDecoration"),this.session.addGutterDecoration(e,t)},this.removeGutterDecoration=function(e,t){window.console&&console.warn&&console.warn("deprecated use session.removeGutterDecoration"),this.session.removeGutterDecoration(e,t)},this.setAnnotations=function(e){this.$annotations=[];for(var t=0;t<e.length;t++){var i=e[t],n=i.row,r=this.$annotations[n];r=r||(this.$annotations[n]={text:[]});var o=i.text;o=o?a.escapeHTML(o):i.html||"",-1===r.text.indexOf(o)&&r.text.push(o);var s=i.type;"error"==s?r.className=" ace_error":"warning"==s&&" ace_error"!=r.className?r.className=" ace_warning":"info"!=s||r.className||(r.className=" ace_info")}},this.$updateAnnotations=function(e){if(this.$annotations.length){var t=e.start.row,i=e.end.row-t;if(0==i);else if("remove"==e.action)this.$annotations.splice(t,1+i,null);else{var n=new Array(1+i);n.unshift(t,1),this.$annotations.splice.apply(this.$annotations,n)}}},this.update=function(e){this.config=e;var t=this.session,i=e.firstRow,n=Math.min(e.lastRow+e.gutterOffset,t.getLength()-1);this.oldLastRow=n,this.config=e,this.$lines.moveContainer(e),this.$updateCursorRow();for(var r=t.getNextFoldLine(i),o=r?r.start.row:1/0,s=null,a=-1,l=i;;){if(o<l&&(l=r.end.row+1,o=(r=t.getNextFoldLine(l,r))?r.start.row:1/0),n<l){for(;this.$lines.getLength()>a+1;)this.$lines.pop();break}(s=this.$lines.get(++a))?s.row=l:(s=this.$lines.createCell(l,e,this.session,c),this.$lines.push(s)),this.$renderCell(s,e,r,l),l++}this._signal("afterRender"),this.$updateGutterWidth(e)},this.$updateGutterWidth=function(e){var t=this.session,i=t.gutterRenderer||this.$renderer,n=t.$firstLineNumber,r=this.$lines.last()?this.$lines.last().text:"";(this.$fixedWidth||t.$useWrapMode)&&(r=t.getLength()+n-1);var o=i?i.getWidth(t,r,e):r.toString().length*e.characterWidth,s=this.$padding||this.$computePadding();(o+=s.left+s.right)===this.gutterWidth||isNaN(o)||(this.gutterWidth=o,this.element.parentNode.style.width=this.element.style.width=Math.ceil(this.gutterWidth)+"px",this._signal("changeGutterWidth",o))},this.$updateCursorRow=function(){if(this.$highlightGutterLine){var e=this.session.selection.getCursor();this.$cursorRow!==e.row&&(this.$cursorRow=e.row)}},this.updateLineHighlight=function(){if(this.$highlightGutterLine){var e=this.session.selection.cursor.row;if(this.$cursorRow=e,!this.$cursorCell||this.$cursorCell.row!=e){this.$cursorCell&&(this.$cursorCell.element.className=this.$cursorCell.element.className.replace("ace_gutter-active-line ",""));var t=this.$lines.cells;this.$cursorCell=null;for(var i=0;i<t.length;i++){var n=t[i];if(n.row>=this.$cursorRow){if(n.row>this.$cursorRow){var r=this.session.getFoldLine(this.$cursorRow);if(!(0<i&&r&&r.start.row==t[i-1].row))break;n=t[i-1]}n.element.className="ace_gutter-active-line "+n.element.className,this.$cursorCell=n;break}}}}},this.scrollLines=function(e){var t=this.config;if(this.config=e,this.$updateCursorRow(),this.$lines.pageChanged(t,e))return this.update(e);this.$lines.moveContainer(e);var i=Math.min(e.lastRow+e.gutterOffset,this.session.getLength()-1),n=this.oldLastRow;if(this.oldLastRow=i,!t||n<e.firstRow)return this.update(e);if(i<t.firstRow)return this.update(e);if(t.firstRow<e.firstRow)for(var r=this.session.getFoldedRowCount(t.firstRow,e.firstRow-1);0<r;r--)this.$lines.shift();if(i<n)for(r=this.session.getFoldedRowCount(i+1,n);0<r;r--)this.$lines.pop();e.firstRow<t.firstRow&&this.$lines.unshift(this.$renderLines(e,e.firstRow,t.firstRow-1)),n<i&&this.$lines.push(this.$renderLines(e,n+1,i)),this.updateLineHighlight(),this._signal("afterRender"),this.$updateGutterWidth(e)},this.$renderLines=function(e,t,i){for(var n=[],r=t,o=this.session.getNextFoldLine(r),s=o?o.start.row:1/0;s<r&&(r=o.end.row+1,s=(o=this.session.getNextFoldLine(r,o))?o.start.row:1/0),!(i<r);){var a=this.$lines.createCell(r,e,this.session,c);this.$renderCell(a,e,o,r),n.push(a),r++}return n},this.$renderCell=function(e,t,i,n){var r=e.element,o=this.session,s=r.childNodes[0],a=r.childNodes[1],l=o.$firstLineNumber,c=o.$breakpoints,h=o.$decorations,d=o.gutterRenderer||this.$renderer,u=this.$showFoldWidgets&&o.foldWidgets,g=i?i.start.row:Number.MAX_VALUE,p="ace_gutter-cell ";if(this.$highlightGutterLine&&(n==this.$cursorRow||i&&n<this.$cursorRow&&g<=n&&this.$cursorRow<=i.end.row)&&(p+="ace_gutter-active-line ",this.$cursorCell!=e&&(this.$cursorCell&&(this.$cursorCell.element.className=this.$cursorCell.element.className.replace("ace_gutter-active-line ","")),this.$cursorCell=e)),c[n]&&(p+=c[n]),h[n]&&(p+=h[n]),this.$annotations[n]&&(p+=this.$annotations[n].className),r.className!=p&&(r.className=p),u){var m=u[n];null==m&&(m=u[n]=o.getFoldWidget(n))}if(m){p="ace_fold-widget ace_"+m;"start"==m&&n==g&&n<i.end.row?p+=" ace_closed":p+=" ace_open",a.className!=p&&(a.className=p);var f=t.lineHeight+"px";I.setStyle(a.style,"height",f),I.setStyle(a.style,"display","inline-block")}else a&&I.setStyle(a.style,"display","none");var C=(d?d.getText(o,n):n+l).toString();return C!==s.data&&(s.data=C),I.setStyle(e.element.style,"height",this.$lines.computeLineHeight(n,t,o)+"px"),I.setStyle(e.element.style,"top",this.$lines.computeLineTop(n,t,o)+"px"),e.text=C,e},this.$fixedWidth=!1,this.$highlightGutterLine=!0,this.$renderer="",this.setHighlightGutterLine=function(e){this.$highlightGutterLine=e},this.$showLineNumbers=!0,this.$renderer="",this.setShowLineNumbers=function(e){this.$renderer=!e&&{getWidth:function(){return 0},getText:function(){return""}}},this.getShowLineNumbers=function(){return this.$showLineNumbers},this.$showFoldWidgets=!0,this.setShowFoldWidgets=function(e){e?I.addCssClass(this.element,"ace_folding-enabled"):I.removeCssClass(this.element,"ace_folding-enabled"),this.$showFoldWidgets=e,this.$padding=null},this.getShowFoldWidgets=function(){return this.$showFoldWidgets},this.$computePadding=function(){if(!this.element.firstChild)return{left:0,right:0};var e=I.computedStyle(this.element.firstChild);return this.$padding={},this.$padding.left=(parseInt(e.borderLeftWidth)||0)+(parseInt(e.paddingLeft)||0)+1,this.$padding.right=(parseInt(e.borderRightWidth)||0)+(parseInt(e.paddingRight)||0),this.$padding},this.getRegion=function(e){var t=this.$padding||this.$computePadding(),i=this.element.getBoundingClientRect();return e.x<t.left+i.left?"markers":this.$showFoldWidgets&&e.x>i.right-t.right?"foldWidgets":void 0}}).call(n.prototype),t.Gutter=n}),ace.define("ace/layer/marker",["require","exports","module","ace/range","ace/lib/dom"],function(e,t,i){"use strict";function n(e){this.element=r.createElement("div"),this.element.className="ace_layer ace_marker-layer",e.appendChild(this.element)}var g=e("../range").Range,r=e("../lib/dom");(function(){this.$padding=0,this.setPadding=function(e){this.$padding=e},this.setSession=function(e){this.session=e},this.setMarkers=function(e){this.markers=e},this.elt=function(e,t){var i=-1!=this.i&&this.element.childNodes[this.i];i?this.i++:(i=document.createElement("div"),this.element.appendChild(i),this.i=-1),i.style.cssText=t,i.className=e},this.update=function(e){if(e){var t;for(var i in this.config=e,this.i=0,this.markers){var n=this.markers[i];if(n.range){var r=n.range.clipRows(e.firstRow,e.lastRow);if(!r.isEmpty())if(r=r.toScreenRange(this.session),n.renderer){var o=this.$getTop(r.start.row,e),s=this.$padding+r.start.column*e.characterWidth;n.renderer(t,r,s,o,e)}else"fullLine"==n.type?this.drawFullLineMarker(t,r,n.clazz,e):"screenLine"==n.type?this.drawScreenLineMarker(t,r,n.clazz,e):r.isMultiLine()?"text"==n.type?this.drawTextMarker(t,r,n.clazz,e):this.drawMultiLineMarker(t,r,n.clazz,e):this.drawSingleLineMarker(t,r,n.clazz+" ace_start ace_br15",e)}else n.update(t,this,this.session,e)}if(-1!=this.i)for(;this.i<this.element.childElementCount;)this.element.removeChild(this.element.lastChild)}},this.$getTop=function(e,t){return(e-t.firstRowScreen)*t.lineHeight},this.drawTextMarker=function(e,t,i,n,r){for(var o=this.session,s=t.start.row,a=t.end.row,l=s,c=0,h=0,d=o.getScreenLastRowColumn(l),u=new g(l,t.start.column,l,h);l<=a;l++)u.start.row=u.end.row=l,u.start.column=l==s?t.start.column:o.getRowWrapIndent(l),c=h,h=u.end.column=d,d=l+1<a?o.getScreenLastRowColumn(l+1):l==a?0:t.end.column,this.drawSingleLineMarker(e,u,i+(l==s?" ace_start":"")+" ace_br"+((l==s||l==s+1&&t.start.column?1:0)|(c<h?2:0)|(d<h?4:0)|(l==a?8:0)),n,l==a?0:1,r)},this.drawMultiLineMarker=function(e,t,i,n,r){var o=this.$padding,s=n.lineHeight,a=this.$getTop(t.start.row,n),l=o+t.start.column*n.characterWidth;(r=r||"",this.session.$bidiHandler.isBidiRow(t.start.row))?((c=t.clone()).end.row=c.start.row,c.end.column=this.session.getLine(c.start.row).length,this.drawBidiSingleLineMarker(e,c,i+" ace_br1 ace_start",n,null,r)):this.elt(i+" ace_br1 ace_start","height:"+s+"px;right:0;top:"+a+"px;left:"+l+"px;"+(r||""));if(this.session.$bidiHandler.isBidiRow(t.end.row)){var c;(c=t.clone()).start.row=c.end.row,c.start.column=0,this.drawBidiSingleLineMarker(e,c,i+" ace_br12",n,null,r)}else{a=this.$getTop(t.end.row,n);var h=t.end.column*n.characterWidth;this.elt(i+" ace_br12","height:"+s+"px;width:"+h+"px;top:"+a+"px;left:"+o+"px;"+(r||""))}if(!((s=(t.end.row-t.start.row-1)*n.lineHeight)<=0)){a=this.$getTop(t.start.row+1,n);var d=(t.start.column?1:0)|(t.end.column?0:8);this.elt(i+(d?" ace_br"+d:""),"height:"+s+"px;right:0;top:"+a+"px;left:"+o+"px;"+(r||""))}},this.drawSingleLineMarker=function(e,t,i,n,r,o){if(this.session.$bidiHandler.isBidiRow(t.start.row))return this.drawBidiSingleLineMarker(e,t,i,n,r,o);var s=n.lineHeight,a=(t.end.column+(r||0)-t.start.column)*n.characterWidth,l=this.$getTop(t.start.row,n),c=this.$padding+t.start.column*n.characterWidth;this.elt(i,"height:"+s+"px;width:"+a+"px;top:"+l+"px;left:"+c+"px;"+(o||""))},this.drawBidiSingleLineMarker=function(e,t,i,n,r,o){var s=n.lineHeight,a=this.$getTop(t.start.row,n),l=this.$padding;this.session.$bidiHandler.getSelections(t.start.column,t.end.column).forEach(function(e){this.elt(i,"height:"+s+"px;width:"+e.width+(r||0)+"px;top:"+a+"px;left:"+(l+e.left)+"px;"+(o||""))},this)},this.drawFullLineMarker=function(e,t,i,n,r){var o=this.$getTop(t.start.row,n),s=n.lineHeight;t.start.row!=t.end.row&&(s+=this.$getTop(t.end.row,n)-o),this.elt(i,"height:"+s+"px;top:"+o+"px;left:0;right:0;"+(r||""))},this.drawScreenLineMarker=function(e,t,i,n,r){var o=this.$getTop(t.start.row,n),s=n.lineHeight;this.elt(i,"height:"+s+"px;top:"+o+"px;left:0;right:0;"+(r||""))}}).call(n.prototype),t.Marker=n}),ace.define("ace/layer/text",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/layer/lines","ace/lib/event_emitter"],function(e,t,i){"use strict";function n(e){this.dom=c,this.element=this.dom.createElement("div"),this.element.className="ace_layer ace_text-layer",e.appendChild(this.element),this.$updateEolChar=this.$updateEolChar.bind(this),this.$lines=new o(this.element)}var r=e("../lib/oop"),c=e("../lib/dom"),I=e("../lib/lang"),o=e("./lines").Lines,s=e("../lib/event_emitter").EventEmitter;(function(){r.implement(this,s),this.EOF_CHAR="¶",this.EOL_CHAR_LF="¬",this.EOL_CHAR_CRLF="¤",this.EOL_CHAR=this.EOL_CHAR_LF,this.TAB_CHAR="—",this.SPACE_CHAR="·",this.$padding=0,this.MAX_LINE_LENGTH=1e4,this.$updateEolChar=function(){var e=this.session.doc,t="\n"==e.getNewLineCharacter()&&"windows"!=e.getNewLineMode()?this.EOL_CHAR_LF:this.EOL_CHAR_CRLF;if(this.EOL_CHAR!=t)return this.EOL_CHAR=t,!0},this.setPadding=function(e){this.$padding=e,this.element.style.margin="0 "+e+"px"},this.getLineHeight=function(){return this.$fontMetrics.$characterSize.height||0},this.getCharacterWidth=function(){return this.$fontMetrics.$characterSize.width||0},this.$setFontMetrics=function(e){this.$fontMetrics=e,this.$fontMetrics.on("changeCharacterSize",function(e){this._signal("changeCharacterSize",e)}.bind(this)),this.$pollSizeChanges()},this.checkForSizeChanges=function(){this.$fontMetrics.checkForSizeChanges()},this.$pollSizeChanges=function(){return this.$pollSizeChangesTimer=this.$fontMetrics.$pollSizeChanges()},this.setSession=function(e){(this.session=e)&&this.$computeTabString()},this.showInvisibles=!1,this.setShowInvisibles=function(e){return this.showInvisibles!=e&&(this.showInvisibles=e,this.$computeTabString(),!0)},this.displayIndentGuides=!0,this.setDisplayIndentGuides=function(e){return this.displayIndentGuides!=e&&(this.displayIndentGuides=e,this.$computeTabString(),!0)},this.$tabStrings=[],this.onChangeTabSize=this.$computeTabString=function(){var e=this.session.getTabSize();this.tabSize=e;for(var t=this.$tabStrings=[0],i=1;i<e+1;i++){if(this.showInvisibles)(n=this.dom.createElement("span")).className="ace_invisible ace_invisible_tab",n.textContent=I.stringRepeat(this.TAB_CHAR,i),t.push(n);else t.push(this.dom.createTextNode(I.stringRepeat(" ",i),this.element))}if(this.displayIndentGuides){this.$indentGuideRe=/\s\S| \t|\t |\s$/;var n,r="ace_indent-guide",o="",s="";if(this.showInvisibles){r+=" ace_invisible",o=" ace_invisible_space",s=" ace_invisible_tab";var a=I.stringRepeat(this.SPACE_CHAR,this.tabSize),l=I.stringRepeat(this.TAB_CHAR,this.tabSize)}else l=a=I.stringRepeat(" ",this.tabSize);(n=this.dom.createElement("span")).className=r+o,n.textContent=a,this.$tabStrings[" "]=n,(n=this.dom.createElement("span")).className=r+s,n.textContent=l,this.$tabStrings["\t"]=n}},this.updateLines=function(e,t,i){if(this.config.lastRow!=e.lastRow||this.config.firstRow!=e.firstRow)return this.update(e);this.config=e;for(var n=Math.max(t,e.firstRow),r=Math.min(i,e.lastRow),o=this.element.childNodes,s=0,a=e.firstRow;a<n;a++){if(l=this.session.getFoldLine(a)){if(l.containsRow(n)){n=l.start.row;break}a=l.end.row}s++}for(var l,c=!1,h=(a=n,(l=this.session.getNextFoldLine(a))?l.start.row:1/0);h<a&&(a=l.end.row+1,h=(l=this.session.getNextFoldLine(a,l))?l.start.row:1/0),!(r<a);){var d=o[s++];if(d){this.dom.removeChildren(d),this.$renderLine(d,a,a==h&&l),c&&(d.style.top=this.$lines.computeLineTop(a,e,this.session)+"px");var u=e.lineHeight*this.session.getRowLength(a)+"px";d.style.height!=u&&(c=!0,d.style.height=u)}a++}if(c)for(;s<this.$lines.cells.length;){var g=this.$lines.cells[s++];g.element.style.top=this.$lines.computeLineTop(g.row,e,this.session)+"px"}},this.scrollLines=function(e){var t=this.config;if(this.config=e,this.$lines.pageChanged(t,e))return this.update(e);this.$lines.moveContainer(e);var i=e.lastRow,n=t?t.lastRow:-1;if(!t||n<e.firstRow)return this.update(e);if(i<t.firstRow)return this.update(e);if(!t||t.lastRow<e.firstRow)return this.update(e);if(e.lastRow<t.firstRow)return this.update(e);if(t.firstRow<e.firstRow)for(var r=this.session.getFoldedRowCount(t.firstRow,e.firstRow-1);0<r;r--)this.$lines.shift();if(t.lastRow>e.lastRow)for(r=this.session.getFoldedRowCount(e.lastRow+1,t.lastRow);0<r;r--)this.$lines.pop();e.firstRow<t.firstRow&&this.$lines.unshift(this.$renderLinesFragment(e,e.firstRow,t.firstRow-1)),e.lastRow>t.lastRow&&this.$lines.push(this.$renderLinesFragment(e,t.lastRow+1,e.lastRow))},this.$renderLinesFragment=function(e,t,i){for(var n=[],r=t,o=this.session.getNextFoldLine(r),s=o?o.start.row:1/0;s<r&&(r=o.end.row+1,s=(o=this.session.getNextFoldLine(r,o))?o.start.row:1/0),!(i<r);){var a=this.$lines.createCell(r,e,this.session),l=a.element;this.dom.removeChildren(l),c.setStyle(l.style,"height",this.$lines.computeLineHeight(r,e,this.session)+"px"),c.setStyle(l.style,"top",this.$lines.computeLineTop(r,e,this.session)+"px"),this.$renderLine(l,r,r==s&&o),this.$useLineGroups()?l.className="ace_line_group":l.className="ace_line",n.push(a),r++}return n},this.update=function(e){this.$lines.moveContainer(e);for(var t=(this.config=e).firstRow,i=e.lastRow,n=this.$lines;n.getLength();)n.pop();n.push(this.$renderLinesFragment(e,t,i))},this.$textToken={text:!0,rparen:!0,lparen:!0},this.$renderToken=function(e,t,i,n){for(var r,o=this,s=/(\t)|( +)|([\x00-\x1f\x80-\xa0\xad\u1680\u180E\u2000-\u200f\u2028\u2029\u202F\u205F\uFEFF\uFFF9-\uFFFC]+)|(\u3000)|([\u1100-\u115F\u11A3-\u11A7\u11FA-\u11FF\u2329-\u232A\u2E80-\u2E99\u2E9B-\u2EF3\u2F00-\u2FD5\u2FF0-\u2FFB\u3001-\u303E\u3041-\u3096\u3099-\u30FF\u3105-\u312D\u3131-\u318E\u3190-\u31BA\u31C0-\u31E3\u31F0-\u321E\u3220-\u3247\u3250-\u32FE\u3300-\u4DBF\u4E00-\uA48C\uA490-\uA4C6\uA960-\uA97C\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFAFF\uFE10-\uFE19\uFE30-\uFE52\uFE54-\uFE66\uFE68-\uFE6B\uFF01-\uFF60\uFFE0-\uFFE6]|[\uD800-\uDBFF][\uDC00-\uDFFF])/g,a=this.dom.createFragment(this.element),l=0;r=s.exec(n);){var c=r[1],h=r[2],d=r[3],u=r[4],g=r[5];if(o.showInvisibles||!h){var p=l!=r.index?n.slice(l,r.index):"";if(l=r.index+r[0].length,p&&a.appendChild(this.dom.createTextNode(p,this.element)),c){var m=o.session.getScreenTabSize(t+r.index);a.appendChild(o.$tabStrings[m].cloneNode(!0)),t+=m-1}else if(h){if(o.showInvisibles)(C=this.dom.createElement("span")).className="ace_invisible ace_invisible_space",C.textContent=I.stringRepeat(o.SPACE_CHAR,h.length),a.appendChild(C);else a.appendChild(this.com.createTextNode(h,this.element))}else if(d){(C=this.dom.createElement("span")).className="ace_invisible ace_invisible_space ace_invalid",C.textContent=I.stringRepeat(o.SPACE_CHAR,d.length),a.appendChild(C)}else if(u){t+=1,(C=this.dom.createElement("span")).style.width=2*o.config.characterWidth+"px",C.className=o.showInvisibles?"ace_cjk ace_invisible ace_invisible_space":"ace_cjk",C.textContent=o.showInvisibles?o.SPACE_CHAR:u,a.appendChild(C)}else if(g){t+=1,(C=this.dom.createElement("span")).style.width=2*o.config.characterWidth+"px",C.className="ace_cjk",C.textContent=g,a.appendChild(C)}}}if(a.appendChild(this.dom.createTextNode(l?n.slice(l):n,this.element)),this.$textToken[i.type])e.appendChild(a);else{var f="ace_"+i.type.replace(/\./g," ace_"),C=this.dom.createElement("span");"fold"==i.type&&(C.style.width=i.value.length*this.config.characterWidth+"px"),C.className=f,C.appendChild(a),e.appendChild(C)}return t+n.length},this.renderIndentGuide=function(e,t,i){var n=t.search(this.$indentGuideRe);if(n<=0||i<=n)return t;if(" "==t[0]){for(var r=(n-=n%this.tabSize)/this.tabSize,o=0;o<r;o++)e.appendChild(this.$tabStrings[" "].cloneNode(!0));return t.substr(n)}if("\t"!=t[0])return t;for(o=0;o<n;o++)e.appendChild(this.$tabStrings["\t"].cloneNode(!0));return t.substr(n)},this.$createLineElement=function(e){var t=this.dom.createElement("div");return t.className="ace_line",t.style.height=this.config.lineHeight+"px",t},this.$renderWrappedLine=function(e,t,i){var n=0,r=0,o=i[0],s=0,a=this.$createLineElement();e.appendChild(a);for(var l=0;l<t.length;l++){var c=t[l],h=c.value;if(0==l&&this.displayIndentGuides){if(n=h.length,!(h=this.renderIndentGuide(a,h,o)))continue;n-=h.length}if(n+h.length<o)s=this.$renderToken(a,s,c,h),n+=h.length;else{for(;n+h.length>=o;)s=this.$renderToken(a,s,c,h.substring(0,o-n)),h=h.substring(o-n),n=o,a=this.$createLineElement(),e.appendChild(a),a.appendChild(this.dom.createTextNode(I.stringRepeat(" ",i.indent),this.element)),s=0,o=i[++r]||Number.MAX_VALUE;0!=h.length&&(n+=h.length,s=this.$renderToken(a,s,c,h))}}i[i.length-1]>this.MAX_LINE_LENGTH&&this.$renderOverflowMessage(a,s,null,"",!0)},this.$renderSimpleLine=function(e,t){var i=0,n=t[0],r=n.value;this.displayIndentGuides&&(r=this.renderIndentGuide(e,r)),r&&(i=this.$renderToken(e,i,n,r));for(var o=1;o<t.length;o++){if(i+(r=(n=t[o]).value).length>this.MAX_LINE_LENGTH)return this.$renderOverflowMessage(e,i,n,r);i=this.$renderToken(e,i,n,r)}},this.$renderOverflowMessage=function(e,t,i,n,r){i&&this.$renderToken(e,t,i,n.slice(0,this.MAX_LINE_LENGTH-t));var o=this.dom.createElement("span");o.className="ace_inline_button ace_keyword ace_toggle_wrap",o.textContent=r?"<hide>":"<click to see more...>",e.appendChild(o)},this.$renderLine=function(e,t,i){if(i||0==i||(i=this.session.getFoldLine(t)),i)var n=this.$getFoldLineTokens(t,i);else n=this.session.getTokens(t);var r=e;if(n.length){var o=this.session.getRowSplitData(t);if(o&&o.length){this.$renderWrappedLine(e,n,o);r=e.lastChild}else{r=e;this.$useLineGroups()&&(r=this.$createLineElement(),e.appendChild(r)),this.$renderSimpleLine(r,n)}}else this.$useLineGroups()&&(r=this.$createLineElement(),e.appendChild(r));if(this.showInvisibles&&r){i&&(t=i.end.row);var s=this.dom.createElement("span");s.className="ace_invisible ace_invisible_eol",s.textContent=t==this.session.getLength()-1?this.EOF_CHAR:this.EOL_CHAR,r.appendChild(s)}},this.$getFoldLineTokens=function(e,t){var o=this.session,s=[];var a=o.getTokens(e);return t.walk(function(e,t,i,n,r){null!=e?s.push({type:"fold",value:e}):(r&&(a=o.getTokens(t)),a.length&&function(e,t,i){for(var n=0,r=0;r+e[n].value.length<t;)if(r+=e[n].value.length,++n==e.length)return;for(r!=t&&((o=e[n].value.substring(t-r)).length>i-t&&(o=o.substring(0,i-t)),s.push({type:e[n].type,value:o}),r=t+o.length,n+=1);r<i&&n<e.length;){var o;(o=e[n].value).length+r>i?s.push({type:e[n].type,value:o.substring(0,i-r)}):s.push(e[n]),r+=o.length,n+=1}}(a,n,i))},t.end.row,this.session.getLine(t.end.row).length),s},this.$useLineGroups=function(){return this.session.getUseWrapMode()},this.destroy=function(){}}).call(n.prototype),t.Text=n}),ace.define("ace/layer/cursor",["require","exports","module","ace/lib/dom"],function(e,t,i){"use strict";function n(e){this.element=c.createElement("div"),this.element.className="ace_layer ace_cursor-layer",e.appendChild(this.element),this.isVisible=!1,this.isBlinking=!0,this.blinkInterval=1e3,this.smoothBlinking=!1,this.cursors=[],this.cursor=this.addCursor(),c.addCssClass(this.element,"ace_hidden-cursors"),this.$updateCursors=this.$updateOpacity.bind(this)}var c=e("../lib/dom");(function(){this.$updateOpacity=function(e){for(var t=this.cursors,i=t.length;i--;)c.setStyle(t[i].style,"opacity",e?"":"0")},this.$startCssAnimation=function(){for(var e=this.cursors,t=e.length;t--;)e[t].style.animationDuration=this.blinkInterval+"ms";setTimeout(function(){c.addCssClass(this.element,"ace_animate-blinking")}.bind(this))},this.$stopCssAnimation=function(){c.removeCssClass(this.element,"ace_animate-blinking")},this.$padding=0,this.setPadding=function(e){this.$padding=e},this.setSession=function(e){this.session=e},this.setBlinking=function(e){e!=this.isBlinking&&(this.isBlinking=e,this.restartTimer())},this.setBlinkInterval=function(e){
e!=this.blinkInterval&&(this.blinkInterval=e,this.restartTimer())},this.setSmoothBlinking=function(e){e!=this.smoothBlinking&&(this.smoothBlinking=e,c.setCssClass(this.element,"ace_smooth-blinking",e),this.$updateCursors(!0),this.restartTimer())},this.addCursor=function(){var e=c.createElement("div");return e.className="ace_cursor",this.element.appendChild(e),this.cursors.push(e),e},this.removeCursor=function(){if(1<this.cursors.length){var e=this.cursors.pop();return e.parentNode.removeChild(e),e}},this.hideCursor=function(){this.isVisible=!1,c.addCssClass(this.element,"ace_hidden-cursors"),this.restartTimer()},this.showCursor=function(){this.isVisible=!0,c.removeCssClass(this.element,"ace_hidden-cursors"),this.restartTimer()},this.restartTimer=function(){var e=this.$updateCursors;if(clearInterval(this.intervalId),clearTimeout(this.timeoutId),this.$stopCssAnimation(),this.smoothBlinking&&c.removeCssClass(this.element,"ace_smooth-blinking"),e(!0),this.isBlinking&&this.blinkInterval&&this.isVisible)if(this.smoothBlinking&&setTimeout(function(){c.addCssClass(this.element,"ace_smooth-blinking")}.bind(this)),c.HAS_CSS_ANIMATION)this.$startCssAnimation();else{var t=function(){this.timeoutId=setTimeout(function(){e(!1)},.6*this.blinkInterval)}.bind(this);this.intervalId=setInterval(function(){e(!0),t()},this.blinkInterval),t()}else this.$stopCssAnimation()},this.getPixelPosition=function(e,t){if(!this.config||!this.session)return{left:0,top:0};e=e||this.session.selection.getCursor();var i=this.session.documentToScreenPosition(e);return{left:this.$padding+(this.session.$bidiHandler.isBidiRow(i.row,e.row)?this.session.$bidiHandler.getPosLeft(i.column):i.column*this.config.characterWidth),top:(i.row-(t?this.config.firstRowScreen:0))*this.config.lineHeight}},this.isCursorInView=function(e,t){return 0<=e.top&&e.top<t.maxHeight},this.update=function(e){this.config=e;var t=this.session.$selectionMarkers,i=0,n=0;void 0!==t&&0!==t.length||(t=[{cursor:null}]);i=0;for(var r=t.length;i<r;i++){var o=this.getPixelPosition(t[i].cursor,!0);if(!((o.top>e.height+e.offset||o.top<0)&&1<i)){var s=this.cursors[n++]||this.addCursor(),a=s.style;this.drawCursor?this.drawCursor(s,o,e,t[i],this.session):this.isCursorInView(o,e)?(c.setStyle(a,"display","block"),c.translate(s,o.left,o.top),c.setStyle(a,"width",Math.round(e.characterWidth)+"px"),c.setStyle(a,"height",e.lineHeight+"px")):c.setStyle(a,"display","none")}}for(;this.cursors.length>n;)this.removeCursor();var l=this.session.getOverwrite();this.$setOverwrite(l),this.$pixelPos=o,this.restartTimer()},this.drawCursor=null,this.$setOverwrite=function(e){e!=this.overwrite&&((this.overwrite=e)?c.addCssClass(this.element,"ace_overwrite-cursors"):c.removeCssClass(this.element,"ace_overwrite-cursors"))},this.destroy=function(){clearInterval(this.intervalId),clearTimeout(this.timeoutId)}}).call(n.prototype),t.Cursor=n}),ace.define("ace/scrollbar",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/event","ace/lib/event_emitter"],function(e,t,i){"use strict";function n(e){this.element=o.createElement("div"),this.element.className="ace_scrollbar ace_scrollbar"+this.classSuffix,this.inner=o.createElement("div"),this.inner.className="ace_scrollbar-inner",this.inner.textContent=" ",this.element.appendChild(this.inner),e.appendChild(this.element),this.setVisible(!1),this.skipEvent=!1,s.addListener(this.element,"scroll",this.onScroll.bind(this)),s.addListener(this.element,"mousedown",s.preventDefault)}var r=e("./lib/oop"),o=e("./lib/dom"),s=e("./lib/event"),a=e("./lib/event_emitter").EventEmitter;(function(){r.implement(this,a),this.setVisible=function(e){this.element.style.display=e?"":"none",this.isVisible=e,this.coeff=1}}).call(n.prototype);function l(e,t){n.call(this,e),this.scrollTop=0,this.scrollHeight=0,t.$scrollbarWidth=this.width=o.scrollbarWidth(e.ownerDocument),this.inner.style.width=this.element.style.width=(this.width||15)+5+"px",this.$minWidth=0}r.inherits(l,n),function(){this.classSuffix="-v",this.onScroll=function(){if(!this.skipEvent){if(this.scrollTop=this.element.scrollTop,1!=this.coeff){var e=this.element.clientHeight/this.scrollHeight;this.scrollTop=this.scrollTop*(1-e)/(this.coeff-e)}this._emit("scroll",{data:this.scrollTop})}this.skipEvent=!1},this.getWidth=function(){return Math.max(this.isVisible?this.width:0,this.$minWidth||0)},this.setHeight=function(e){this.element.style.height=e+"px"},this.setInnerHeight=this.setScrollHeight=function(e){32768<(this.scrollHeight=e)?(this.coeff=32768/e,e=32768):1!=this.coeff&&(this.coeff=1),this.inner.style.height=e+"px"},this.setScrollTop=function(e){this.scrollTop!=e&&(this.skipEvent=!0,this.scrollTop=e,this.element.scrollTop=e*this.coeff)}}.call(l.prototype);function c(e,t){n.call(this,e),this.scrollLeft=0,this.height=t.$scrollbarWidth,this.inner.style.height=this.element.style.height=(this.height||15)+5+"px"}r.inherits(c,n),function(){this.classSuffix="-h",this.onScroll=function(){this.skipEvent||(this.scrollLeft=this.element.scrollLeft,this._emit("scroll",{data:this.scrollLeft})),this.skipEvent=!1},this.getHeight=function(){return this.isVisible?this.height:0},this.setWidth=function(e){this.element.style.width=e+"px"},this.setInnerWidth=function(e){this.inner.style.width=e+"px"},this.setScrollWidth=function(e){this.inner.style.width=e+"px"},this.setScrollLeft=function(e){this.scrollLeft!=e&&(this.skipEvent=!0,this.scrollLeft=this.element.scrollLeft=e)}}.call(c.prototype),t.ScrollBar=l,t.ScrollBarV=l,t.ScrollBarH=c,t.VScrollBar=l,t.HScrollBar=c}),ace.define("ace/renderloop",["require","exports","module","ace/lib/event"],function(e,t,i){"use strict";function n(e,t){this.onRender=e,this.pending=!1,this.changes=0,this.$recursionLimit=2,this.window=t||window;var i=this;this._flush=function(e){i.pending=!1;var t=i.changes;if(t&&(r.blockIdle(100),i.changes=0,i.onRender(t)),i.changes){if(i.$recursionLimit--<0)return;i.schedule()}else i.$recursionLimit=2}}var r=e("./lib/event");(function(){this.schedule=function(e){this.changes=this.changes|e,this.changes&&!this.pending&&(r.nextFrame(this._flush),this.pending=!0)},this.clear=function(e){var t=this.changes;return this.changes=0,t}}).call(n.prototype),t.RenderLoop=n}),ace.define("ace/layer/font_metrics",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/lib/event","ace/lib/useragent","ace/lib/event_emitter"],function(e,t,i){var n=e("../lib/oop"),r=e("../lib/dom"),o=e("../lib/lang"),s=e("../lib/event"),a=e("../lib/useragent"),l=e("../lib/event_emitter").EventEmitter,c="function"==typeof ResizeObserver,h=t.FontMetrics=function(e){this.el=r.createElement("div"),this.$setMeasureNodeStyles(this.el.style,!0),this.$main=r.createElement("div"),this.$setMeasureNodeStyles(this.$main.style),this.$measureNode=r.createElement("div"),this.$setMeasureNodeStyles(this.$measureNode.style),this.el.appendChild(this.$main),this.el.appendChild(this.$measureNode),e.appendChild(this.el),this.$measureNode.innerHTML=o.stringRepeat("X",256),this.$characterSize={width:0,height:0},c?this.$addObserver():this.checkForSizeChanges()};(function(){n.implement(this,l),this.$characterSize={width:0,height:0},this.$setMeasureNodeStyles=function(e,t){e.width=e.height="auto",e.left=e.top="0px",e.visibility="hidden",e.position="absolute",e.whiteSpace="pre",a.isIE<8?e["font-family"]="inherit":e.font="inherit",e.overflow=t?"hidden":"visible"},this.checkForSizeChanges=function(e){if(void 0===e&&(e=this.$measureSizes()),e&&(this.$characterSize.width!==e.width||this.$characterSize.height!==e.height)){this.$measureNode.style.fontWeight="bold";var t=this.$measureSizes();this.$measureNode.style.fontWeight="",this.$characterSize=e,this.charSizes=Object.create(null),this.allowBoldFonts=t&&t.width===e.width&&t.height===e.height,this._emit("changeCharacterSize",{data:e})}},this.$addObserver=function(){var i=this;this.$observer=new window.ResizeObserver(function(e){var t=e[0].contentRect;i.checkForSizeChanges({height:t.height,width:t.width/256})}),this.$observer.observe(this.$measureNode)},this.$pollSizeChanges=function(){if(this.$pollSizeChangesTimer||this.$observer)return this.$pollSizeChangesTimer;var t=this;return this.$pollSizeChangesTimer=s.onIdle(function e(){t.checkForSizeChanges(),s.onIdle(e,500)},500)},this.setPolling=function(e){e?this.$pollSizeChanges():this.$pollSizeChangesTimer&&(clearInterval(this.$pollSizeChangesTimer),this.$pollSizeChangesTimer=0)},this.$measureSizes=function(e){var t={height:(e||this.$measureNode).clientHeight,width:(e||this.$measureNode).clientWidth/256};return 0===t.width||0===t.height?null:t},this.$measureCharWidth=function(e){return this.$main.innerHTML=o.stringRepeat(e,256),this.$main.getBoundingClientRect().width/256},this.getCharacterWidth=function(e){var t=this.charSizes[e];return void 0===t&&(t=this.charSizes[e]=this.$measureCharWidth(e)/this.$characterSize.width),t},this.destroy=function(){clearInterval(this.$pollSizeChangesTimer),this.$observer&&this.$observer.disconnect(),this.el&&this.el.parentNode&&this.el.parentNode.removeChild(this.el)},this.$getZoom=function e(t){return t?(window.getComputedStyle(t).zoom||1)*e(t.parentElement):1},this.$initTransformMeasureNodes=function(){function e(e,t){return["div",{style:"position: absolute;top:"+e+"px;left:"+t+"px;"}]}this.els=r.buildDom([e(0,0),e(200,0),e(0,200),e(200,200)],this.el)},this.transformCoordinates=function(e,t){e=e&&o(1/this.$getZoom(this.el),e);function i(e,t,i){var n=e[1]*t[0]-e[0]*t[1];return[(-t[1]*i[0]+t[0]*i[1])/n,(+e[1]*i[0]-e[0]*i[1])/n]}function n(e,t){return[e[0]-t[0],e[1]-t[1]]}function r(e,t){return[e[0]+t[0],e[1]+t[1]]}function o(e,t){return[e*t[0],e*t[1]]}function s(e){var t=e.getBoundingClientRect();return[t.left,t.top]}this.els||this.$initTransformMeasureNodes();var a=s(this.els[0]),l=s(this.els[1]),c=s(this.els[2]),h=s(this.els[3]),d=i(n(h,l),n(h,c),n(r(l,c),r(h,a))),u=o(1+d[0],n(l,a)),g=o(1+d[1],n(c,a));if(t){var p=t;return r(o(1/(d[0]*p[0]/200+d[1]*p[1]/200+1)/200,r(o(p[0],u),o(p[1],g))),a)}var m=n(e,a);return o(200,i(n(u,o(d[0],m)),n(g,o(d[1],m)),m))}}).call(h.prototype)}),ace.define("ace/virtual_renderer",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/config","ace/layer/gutter","ace/layer/marker","ace/layer/text","ace/layer/cursor","ace/scrollbar","ace/scrollbar","ace/renderloop","ace/layer/font_metrics","ace/lib/event_emitter","ace/lib/useragent"],function(e,t,i){"use strict";var n=e("./lib/oop"),h=e("./lib/dom"),o=e("./config"),r=e("./layer/gutter").Gutter,s=e("./layer/marker").Marker,a=e("./layer/text").Text,l=e("./layer/cursor").Cursor,c=e("./scrollbar").HScrollBar,d=e("./scrollbar").VScrollBar,u=e("./renderloop").RenderLoop,g=e("./layer/font_metrics").FontMetrics,p=e("./lib/event_emitter").EventEmitter,m='.ace_br1 {border-top-left-radius    : 3px;}.ace_br2 {border-top-right-radius   : 3px;}.ace_br3 {border-top-left-radius    : 3px; border-top-right-radius:    3px;}.ace_br4 {border-bottom-right-radius: 3px;}.ace_br5 {border-top-left-radius    : 3px; border-bottom-right-radius: 3px;}.ace_br6 {border-top-right-radius   : 3px; border-bottom-right-radius: 3px;}.ace_br7 {border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-right-radius: 3px;}.ace_br8 {border-bottom-left-radius : 3px;}.ace_br9 {border-top-left-radius    : 3px; border-bottom-left-radius:  3px;}.ace_br10{border-top-right-radius   : 3px; border-bottom-left-radius:  3px;}.ace_br11{border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-left-radius:  3px;}.ace_br12{border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}.ace_br13{border-top-left-radius    : 3px; border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}.ace_br14{border-top-right-radius   : 3px; border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}.ace_br15{border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-right-radius: 3px; border-bottom-left-radius: 3px;}.ace_editor {position: relative;overflow: hidden;font: 12px/normal \'Monaco\', \'Menlo\', \'Ubuntu Mono\', \'Consolas\', \'source-code-pro\', monospace;direction: ltr;text-align: left;-webkit-tap-highlight-color: rgba(0, 0, 0, 0);}.ace_scroller {position: absolute;overflow: hidden;top: 0;bottom: 0;background-color: inherit;-ms-user-select: none;-moz-user-select: none;-webkit-user-select: none;user-select: none;cursor: text;}.ace_content {position: absolute;box-sizing: border-box;min-width: 100%;contain: style size layout;}.ace_dragging .ace_scroller:before{position: absolute;top: 0;left: 0;right: 0;bottom: 0;content: \'\';background: rgba(250, 250, 250, 0.01);z-index: 1000;}.ace_dragging.ace_dark .ace_scroller:before{background: rgba(0, 0, 0, 0.01);}.ace_selecting, .ace_selecting * {cursor: text !important;}.ace_gutter {position: absolute;overflow : hidden;width: auto;top: 0;bottom: 0;left: 0;cursor: default;z-index: 4;-ms-user-select: none;-moz-user-select: none;-webkit-user-select: none;user-select: none;contain: style size layout;}.ace_gutter-active-line {position: absolute;left: 0;right: 0;}.ace_scroller.ace_scroll-left {box-shadow: 17px 0 16px -16px rgba(0, 0, 0, 0.4) inset;}.ace_gutter-cell {position: absolute;top: 0;left: 0;right: 0;padding-left: 19px;padding-right: 6px;background-repeat: no-repeat;}.ace_gutter-cell.ace_error {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAABOFBMVEX/////////QRswFAb/Ui4wFAYwFAYwFAaWGAfDRymzOSH/PxswFAb/SiUwFAYwFAbUPRvjQiDllog5HhHdRybsTi3/Tyv9Tir+Syj/UC3////XurebMBIwFAb/RSHbPx/gUzfdwL3kzMivKBAwFAbbvbnhPx66NhowFAYwFAaZJg8wFAaxKBDZurf/RB6mMxb/SCMwFAYwFAbxQB3+RB4wFAb/Qhy4Oh+4QifbNRcwFAYwFAYwFAb/QRzdNhgwFAYwFAbav7v/Uy7oaE68MBK5LxLewr/r2NXewLswFAaxJw4wFAbkPRy2PyYwFAaxKhLm1tMwFAazPiQwFAaUGAb/QBrfOx3bvrv/VC/maE4wFAbRPBq6MRO8Qynew8Dp2tjfwb0wFAbx6eju5+by6uns4uH9/f36+vr/GkHjAAAAYnRSTlMAGt+64rnWu/bo8eAA4InH3+DwoN7j4eLi4xP99Nfg4+b+/u9B/eDs1MD1mO7+4PHg2MXa347g7vDizMLN4eG+Pv7i5evs/v79yu7S3/DV7/498Yv24eH+4ufQ3Ozu/v7+y13sRqwAAADLSURBVHjaZc/XDsFgGIBhtDrshlitmk2IrbHFqL2pvXf/+78DPokj7+Fz9qpU/9UXJIlhmPaTaQ6QPaz0mm+5gwkgovcV6GZzd5JtCQwgsxoHOvJO15kleRLAnMgHFIESUEPmawB9ngmelTtipwwfASilxOLyiV5UVUyVAfbG0cCPHig+GBkzAENHS0AstVF6bacZIOzgLmxsHbt2OecNgJC83JERmePUYq8ARGkJx6XtFsdddBQgZE2nPR6CICZhawjA4Fb/chv+399kfR+MMMDGOQAAAABJRU5ErkJggg==");background-repeat: no-repeat;background-position: 2px center;}.ace_gutter-cell.ace_warning {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAAAmVBMVEX///8AAAD///8AAAAAAABPSzb/5sAAAAB/blH/73z/ulkAAAAAAAD85pkAAAAAAAACAgP/vGz/rkDerGbGrV7/pkQICAf////e0IsAAAD/oED/qTvhrnUAAAD/yHD/njcAAADuv2r/nz//oTj/p064oGf/zHAAAAA9Nir/tFIAAAD/tlTiuWf/tkIAAACynXEAAAAAAAAtIRW7zBpBAAAAM3RSTlMAABR1m7RXO8Ln31Z36zT+neXe5OzooRDfn+TZ4p3h2hTf4t3k3ucyrN1K5+Xaks52Sfs9CXgrAAAAjklEQVR42o3PbQ+CIBQFYEwboPhSYgoYunIqqLn6/z8uYdH8Vmdnu9vz4WwXgN/xTPRD2+sgOcZjsge/whXZgUaYYvT8QnuJaUrjrHUQreGczuEafQCO/SJTufTbroWsPgsllVhq3wJEk2jUSzX3CUEDJC84707djRc5MTAQxoLgupWRwW6UB5fS++NV8AbOZgnsC7BpEAAAAABJRU5ErkJggg==");background-position: 2px center;}.ace_gutter-cell.ace_info {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAAAAAA6mKC9AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAAJ0Uk5TAAB2k804AAAAPklEQVQY02NgIB68QuO3tiLznjAwpKTgNyDbMegwisCHZUETUZV0ZqOquBpXj2rtnpSJT1AEnnRmL2OgGgAAIKkRQap2htgAAAAASUVORK5CYII=");background-position: 2px center;}.ace_dark .ace_gutter-cell.ace_info {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQBAMAAADt3eJSAAAAJFBMVEUAAAChoaGAgIAqKiq+vr6tra1ZWVmUlJSbm5s8PDxubm56enrdgzg3AAAAAXRSTlMAQObYZgAAAClJREFUeNpjYMAPdsMYHegyJZFQBlsUlMFVCWUYKkAZMxZAGdxlDMQBAG+TBP4B6RyJAAAAAElFTkSuQmCC");}.ace_scrollbar {contain: strict;position: absolute;right: 0;bottom: 0;z-index: 6;}.ace_scrollbar-inner {position: absolute;cursor: text;left: 0;top: 0;}.ace_scrollbar-v{overflow-x: hidden;overflow-y: scroll;top: 0;}.ace_scrollbar-h {overflow-x: scroll;overflow-y: hidden;left: 0;}.ace_print-margin {position: absolute;height: 100%;}.ace_text-input {position: absolute;z-index: 0;width: 0.5em;height: 1em;opacity: 0;background: transparent;-moz-appearance: none;appearance: none;border: none;resize: none;outline: none;overflow: hidden;font: inherit;padding: 0 1px;margin: 0 -1px;contain: strict;-ms-user-select: text;-moz-user-select: text;-webkit-user-select: text;user-select: text;white-space: pre!important;}.ace_text-input.ace_composition {background: transparent;color: inherit;z-index: 1000;opacity: 1;}.ace_composition_placeholder { color: transparent }.ace_composition_marker { border-bottom: 1px solid;position: absolute;border-radius: 0;margin-top: 1px;}[ace_nocontext=true] {transform: none!important;filter: none!important;perspective: none!important;clip-path: none!important;mask : none!important;contain: none!important;perspective: none!important;mix-blend-mode: initial!important;z-index: auto;}.ace_layer {z-index: 1;position: absolute;overflow: hidden;word-wrap: normal;white-space: pre;height: 100%;width: 100%;box-sizing: border-box;pointer-events: none;}.ace_gutter-layer {position: relative;width: auto;text-align: right;pointer-events: auto;height: 1000000px;contain: style size layout;}.ace_text-layer {font: inherit !important;position: absolute;height: 1000000px;width: 1000000px;contain: style size layout;}.ace_text-layer > .ace_line, .ace_text-layer > .ace_line_group {contain: style size layout;position: absolute;top: 0;left: 0;right: 0;}.ace_hidpi .ace_text-layer,.ace_hidpi .ace_gutter-layer,.ace_hidpi .ace_content,.ace_hidpi .ace_gutter {contain: strict;will-change: transform;}.ace_hidpi .ace_text-layer > .ace_line, .ace_hidpi .ace_text-layer > .ace_line_group {contain: strict;}.ace_cjk {display: inline-block;text-align: center;}.ace_cursor-layer {z-index: 4;}.ace_cursor {z-index: 4;position: absolute;box-sizing: border-box;border-left: 2px solid;transform: translatez(0);}.ace_multiselect .ace_cursor {border-left-width: 1px;}.ace_slim-cursors .ace_cursor {border-left-width: 1px;}.ace_overwrite-cursors .ace_cursor {border-left-width: 0;border-bottom: 1px solid;}.ace_hidden-cursors .ace_cursor {opacity: 0.2;}.ace_hasPlaceholder .ace_hidden-cursors .ace_cursor {opacity: 0;}.ace_smooth-blinking .ace_cursor {transition: opacity 0.18s;}.ace_animate-blinking .ace_cursor {animation-duration: 1000ms;animation-timing-function: step-end;animation-name: blink-ace-animate;animation-iteration-count: infinite;}.ace_animate-blinking.ace_smooth-blinking .ace_cursor {animation-duration: 1000ms;animation-timing-function: ease-in-out;animation-name: blink-ace-animate-smooth;}@keyframes blink-ace-animate {from, to { opacity: 1; }60% { opacity: 0; }}@keyframes blink-ace-animate-smooth {from, to { opacity: 1; }45% { opacity: 1; }60% { opacity: 0; }85% { opacity: 0; }}.ace_marker-layer .ace_step, .ace_marker-layer .ace_stack {position: absolute;z-index: 3;}.ace_marker-layer .ace_selection {position: absolute;z-index: 5;}.ace_marker-layer .ace_bracket {position: absolute;z-index: 6;}.ace_marker-layer .ace_active-line {position: absolute;z-index: 2;}.ace_marker-layer .ace_selected-word {position: absolute;z-index: 4;box-sizing: border-box;}.ace_line .ace_fold {box-sizing: border-box;display: inline-block;height: 11px;margin-top: -2px;vertical-align: middle;background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII="),url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACJJREFUeNpi+P//fxgTAwPDBxDxD078RSX+YeEyDFMCIMAAI3INmXiwf2YAAAAASUVORK5CYII=");background-repeat: no-repeat, repeat-x;background-position: center center, top left;color: transparent;border: 1px solid black;border-radius: 2px;cursor: pointer;pointer-events: auto;}.ace_dark .ace_fold {}.ace_fold:hover{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII="),url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACBJREFUeNpi+P//fz4TAwPDZxDxD5X4i5fLMEwJgAADAEPVDbjNw87ZAAAAAElFTkSuQmCC");}.ace_tooltip {background-color: #FFF;background-image: linear-gradient(to bottom, transparent, rgba(0, 0, 0, 0.1));border: 1px solid gray;border-radius: 1px;box-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);color: black;max-width: 100%;padding: 3px 4px;position: fixed;z-index: 999999;box-sizing: border-box;cursor: default;white-space: pre;word-wrap: break-word;line-height: normal;font-style: normal;font-weight: normal;letter-spacing: normal;pointer-events: none;}.ace_folding-enabled > .ace_gutter-cell {padding-right: 13px;}.ace_fold-widget {box-sizing: border-box;margin: 0 -12px 0 1px;display: none;width: 11px;vertical-align: top;background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42mWKsQ0AMAzC8ixLlrzQjzmBiEjp0A6WwBCSPgKAXoLkqSot7nN3yMwR7pZ32NzpKkVoDBUxKAAAAABJRU5ErkJggg==");background-repeat: no-repeat;background-position: center;border-radius: 3px;border: 1px solid transparent;cursor: pointer;}.ace_folding-enabled .ace_fold-widget {display: inline-block;   }.ace_fold-widget.ace_end {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42m3HwQkAMAhD0YzsRchFKI7sAikeWkrxwScEB0nh5e7KTPWimZki4tYfVbX+MNl4pyZXejUO1QAAAABJRU5ErkJggg==");}.ace_fold-widget.ace_closed {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAGCAYAAAAG5SQMAAAAOUlEQVR42jXKwQkAMAgDwKwqKD4EwQ26sSOkVWjgIIHAzPiCgaqiqnJHZnKICBERHN194O5b9vbLuAVRL+l0YWnZAAAAAElFTkSuQmCCXA==");}.ace_fold-widget:hover {border: 1px solid rgba(0, 0, 0, 0.3);background-color: rgba(255, 255, 255, 0.2);box-shadow: 0 1px 1px rgba(255, 255, 255, 0.7);}.ace_fold-widget:active {border: 1px solid rgba(0, 0, 0, 0.4);background-color: rgba(0, 0, 0, 0.05);box-shadow: 0 1px 1px rgba(255, 255, 255, 0.8);}.ace_dark .ace_fold-widget {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAHklEQVQIW2P4//8/AzoGEQ7oGCaLLAhWiSwB146BAQCSTPYocqT0AAAAAElFTkSuQmCC");}.ace_dark .ace_fold-widget.ace_end {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAH0lEQVQIW2P4//8/AxQ7wNjIAjDMgC4AxjCVKBirIAAF0kz2rlhxpAAAAABJRU5ErkJggg==");}.ace_dark .ace_fold-widget.ace_closed {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAFCAYAAACAcVaiAAAAHElEQVQIW2P4//+/AxAzgDADlOOAznHAKgPWAwARji8UIDTfQQAAAABJRU5ErkJggg==");}.ace_dark .ace_fold-widget:hover {box-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);background-color: rgba(255, 255, 255, 0.1);}.ace_dark .ace_fold-widget:active {box-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);}.ace_inline_button {border: 1px solid lightgray;display: inline-block;margin: -1px 8px;padding: 0 5px;pointer-events: auto;cursor: pointer;}.ace_inline_button:hover {border-color: gray;background: rgba(200,200,200,0.2);display: inline-block;pointer-events: auto;}.ace_fold-widget.ace_invalid {background-color: #FFB4B4;border-color: #DE5555;}.ace_fade-fold-widgets .ace_fold-widget {transition: opacity 0.4s ease 0.05s;opacity: 0;}.ace_fade-fold-widgets:hover .ace_fold-widget {transition: opacity 0.05s ease 0.05s;opacity:1;}.ace_underline {text-decoration: underline;}.ace_bold {font-weight: bold;}.ace_nobold .ace_bold {font-weight: normal;}.ace_italic {font-style: italic;}.ace_error-marker {background-color: rgba(255, 0, 0,0.2);position: absolute;z-index: 9;}.ace_highlight-marker {background-color: rgba(255, 255, 0,0.2);position: absolute;z-index: 8;}.ace_mobile-menu {position: absolute;line-height: 1.5;border-radius: 4px;-ms-user-select: none;-moz-user-select: none;-webkit-user-select: none;user-select: none;background: white;box-shadow: 1px 3px 2px grey;border: 1px solid #dcdcdc;color: black;}.ace_dark > .ace_mobile-menu {background: #333;color: #ccc;box-shadow: 1px 3px 2px grey;border: 1px solid #444;}.ace_mobile-button {padding: 2px;cursor: pointer;overflow: hidden;}.ace_mobile-button:hover {background-color: #eee;opacity:1;}.ace_mobile-button:active {background-color: #ddd;}.ace_placeholder {font-family: arial;transform: scale(0.9);opacity: 0.7;transform-origin: left;text-indent: 10px;}',f=e("./lib/useragent"),C=f.isIE;h.importCssString(m,"ace_editor.css");function I(e,t){var i=this;this.container=e||h.createElement("div"),h.addCssClass(this.container,"ace_editor"),h.HI_DPI&&h.addCssClass(this.container,"ace_hidpi"),this.setTheme(t),this.$gutter=h.createElement("div"),this.$gutter.className="ace_gutter",this.container.appendChild(this.$gutter),this.$gutter.setAttribute("aria-hidden",!0),this.scroller=h.createElement("div"),this.scroller.className="ace_scroller",this.container.appendChild(this.scroller),this.content=h.createElement("div"),this.content.className="ace_content",this.scroller.appendChild(this.content),this.$gutterLayer=new r(this.$gutter),this.$gutterLayer.on("changeGutterWidth",this.onGutterResize.bind(this)),this.$markerBack=new s(this.content);var n=this.$textLayer=new a(this.content);this.canvas=n.element,this.$markerFront=new s(this.content),this.$cursorLayer=new l(this.content),this.$horizScroll=!1,this.$vScroll=!1,this.scrollBar=this.scrollBarV=new d(this.container,this),this.scrollBarH=new c(this.container,this),this.scrollBarV.addEventListener("scroll",function(e){i.$scrollAnimation||i.session.setScrollTop(e.data-i.scrollMargin.top)}),this.scrollBarH.addEventListener("scroll",function(e){i.$scrollAnimation||i.session.setScrollLeft(e.data-i.scrollMargin.left)}),this.scrollTop=0,this.scrollLeft=0,this.cursorPos={row:0,column:0},this.$fontMetrics=new g(this.container),this.$textLayer.$setFontMetrics(this.$fontMetrics),this.$textLayer.addEventListener("changeCharacterSize",function(e){i.updateCharacterSize(),i.onResize(!0,i.gutterWidth,i.$size.width,i.$size.height),i._signal("changeCharacterSize",e)}),this.$size={width:0,height:0,scrollerHeight:0,scrollerWidth:0,$dirty:!0},this.layerConfig={width:1,padding:0,firstRow:0,firstRowScreen:0,lastRow:0,lineHeight:0,characterWidth:0,minHeight:1,maxHeight:1,offset:0,height:1,gutterOffset:1},this.scrollMargin={left:0,right:0,top:0,bottom:0,v:0,h:0},this.margin={left:0,right:0,top:0,bottom:0,v:0,h:0},this.$keepTextAreaAtCursor=!f.isIOS,this.$loop=new u(this.$renderChanges.bind(this),this.container.ownerDocument.defaultView),this.$loop.schedule(this.CHANGE_FULL),this.updateCharacterSize(),this.setPadding(4),o.resetOptions(this),o._signal("renderer",this)}(function(){this.CHANGE_CURSOR=1,this.CHANGE_MARKER=2,this.CHANGE_GUTTER=4,this.CHANGE_SCROLL=8,this.CHANGE_LINES=16,this.CHANGE_TEXT=32,this.CHANGE_SIZE=64,this.CHANGE_MARKER_BACK=128,this.CHANGE_MARKER_FRONT=256,this.CHANGE_FULL=512,this.CHANGE_H_SCROLL=1024,n.implement(this,p),this.updateCharacterSize=function(){this.$textLayer.allowBoldFonts!=this.$allowBoldFonts&&(this.$allowBoldFonts=this.$textLayer.allowBoldFonts,this.setStyle("ace_nobold",!this.$allowBoldFonts)),this.layerConfig.characterWidth=this.characterWidth=this.$textLayer.getCharacterWidth(),this.layerConfig.lineHeight=this.lineHeight=this.$textLayer.getLineHeight(),this.$updatePrintMargin(),h.setStyle(this.scroller.style,"line-height",this.lineHeight+"px")},this.setSession=function(e){this.session&&this.session.doc.off("changeNewLineMode",this.onChangeNewLineMode),(this.session=e)&&this.scrollMargin.top&&e.getScrollTop()<=0&&e.setScrollTop(-this.scrollMargin.top),this.$cursorLayer.setSession(e),this.$markerBack.setSession(e),this.$markerFront.setSession(e),this.$gutterLayer.setSession(e),this.$textLayer.setSession(e),e&&(this.$loop.schedule(this.CHANGE_FULL),this.session.$setFontMetrics(this.$fontMetrics),this.scrollBarH.scrollLeft=this.scrollBarV.scrollTop=null,this.onChangeNewLineMode=this.onChangeNewLineMode.bind(this),this.onChangeNewLineMode(),this.session.doc.on("changeNewLineMode",this.onChangeNewLineMode))},this.updateLines=function(e,t,i){if(void 0===t&&(t=1/0),this.$changedLines?(this.$changedLines.firstRow>e&&(this.$changedLines.firstRow=e),this.$changedLines.lastRow<t&&(this.$changedLines.lastRow=t)):this.$changedLines={firstRow:e,lastRow:t},this.$changedLines.lastRow<this.layerConfig.firstRow){if(!i)return;this.$changedLines.lastRow=this.layerConfig.lastRow}this.$changedLines.firstRow>this.layerConfig.lastRow||this.$loop.schedule(this.CHANGE_LINES)},this.onChangeNewLineMode=function(){this.$loop.schedule(this.CHANGE_TEXT),this.$textLayer.$updateEolChar(),this.session.$bidiHandler.setEolChar(this.$textLayer.EOL_CHAR)},this.onChangeTabSize=function(){this.$loop.schedule(this.CHANGE_TEXT|this.CHANGE_MARKER),this.$textLayer.onChangeTabSize()},this.updateText=function(){this.$loop.schedule(this.CHANGE_TEXT)},this.updateFull=function(e){e?this.$renderChanges(this.CHANGE_FULL,!0):this.$loop.schedule(this.CHANGE_FULL)},this.updateFontSize=function(){this.$textLayer.checkForSizeChanges()},this.$changes=0,this.$updateSizeAsync=function(){this.$loop.pending?this.$size.$dirty=!0:this.onResize()},this.onResize=function(e,t,i,n){if(!(2<this.resizing)){0<this.resizing?this.resizing++:this.resizing=e?1:0;var r=this.container;n=n||(r.clientHeight||r.scrollHeight),i=i||(r.clientWidth||r.scrollWidth);var o=this.$updateCachedSize(e,t,i,n);if(!this.$size.scrollerHeight||!i&&!n)return this.resizing=0;e&&(this.$gutterLayer.$padding=null),e?this.$renderChanges(o|this.$changes,!0):this.$loop.schedule(o|this.$changes),this.resizing&&(this.resizing=0),this.scrollBarV.scrollLeft=this.scrollBarV.scrollTop=null}},this.$updateCachedSize=function(e,t,i,n){n-=this.$extraHeight||0;var r=0,o=this.$size,s={width:o.width,height:o.height,scrollerHeight:o.scrollerHeight,scrollerWidth:o.scrollerWidth};if(n&&(e||o.height!=n)&&(o.height=n,r|=this.CHANGE_SIZE,o.scrollerHeight=o.height,this.$horizScroll&&(o.scrollerHeight-=this.scrollBarH.getHeight()),this.scrollBarV.element.style.bottom=this.scrollBarH.getHeight()+"px",r|=this.CHANGE_SCROLL),i&&(e||o.width!=i)){r|=this.CHANGE_SIZE,o.width=i,null==t&&(t=this.$showGutter?this.$gutter.offsetWidth:0),this.gutterWidth=t,h.setStyle(this.scrollBarH.element.style,"left",t+"px"),h.setStyle(this.scroller.style,"left",t+this.margin.left+"px"),o.scrollerWidth=Math.max(0,i-t-this.scrollBarV.getWidth()-this.margin.h),h.setStyle(this.$gutter.style,"left",this.margin.left+"px");var a=this.scrollBarV.getWidth()+"px";h.setStyle(this.scrollBarH.element.style,"right",a),h.setStyle(this.scroller.style,"right",a),h.setStyle(this.scroller.style,"bottom",this.scrollBarH.getHeight()),(this.session&&this.session.getUseWrapMode()&&this.adjustWrapLimit()||e)&&(r|=this.CHANGE_FULL)}return o.$dirty=!i||!n,r&&this._signal("resize",s),r},this.onGutterResize=function(e){var t=this.$showGutter?e:0;t!=this.gutterWidth&&(this.$changes|=this.$updateCachedSize(!0,t,this.$size.width,this.$size.height)),this.session.getUseWrapMode()&&this.adjustWrapLimit()?this.$loop.schedule(this.CHANGE_FULL):this.$size.$dirty?this.$loop.schedule(this.CHANGE_FULL):this.$computeLayerConfig()},this.adjustWrapLimit=function(){var e=this.$size.scrollerWidth-2*this.$padding,t=Math.floor(e/this.characterWidth);return this.session.adjustWrapLimit(t,this.$showPrintMargin&&this.$printMarginColumn)},this.setAnimatedScroll=function(e){this.setOption("animatedScroll",e)},this.getAnimatedScroll=function(){return this.$animatedScroll},this.setShowInvisibles=function(e){this.setOption("showInvisibles",e),this.session.$bidiHandler.setShowInvisibles(e)},this.getShowInvisibles=function(){return this.getOption("showInvisibles")},this.getDisplayIndentGuides=function(){return this.getOption("displayIndentGuides")},this.setDisplayIndentGuides=function(e){this.setOption("displayIndentGuides",e)},this.setShowPrintMargin=function(e){this.setOption("showPrintMargin",e)},this.getShowPrintMargin=function(){return this.getOption("showPrintMargin")},this.setPrintMarginColumn=function(e){this.setOption("printMarginColumn",e)},this.getPrintMarginColumn=function(){return this.getOption("printMarginColumn")},this.getShowGutter=function(){return this.getOption("showGutter")},this.setShowGutter=function(e){return this.setOption("showGutter",e)},this.getFadeFoldWidgets=function(){return this.getOption("fadeFoldWidgets")},this.setFadeFoldWidgets=function(e){this.setOption("fadeFoldWidgets",e)},this.setHighlightGutterLine=function(e){this.setOption("highlightGutterLine",e)},this.getHighlightGutterLine=function(){return this.getOption("highlightGutterLine")},this.$updatePrintMargin=function(){if(this.$showPrintMargin||this.$printMarginEl){if(!this.$printMarginEl){var e=h.createElement("div");e.className="ace_layer ace_print-margin-layer",this.$printMarginEl=h.createElement("div"),this.$printMarginEl.className="ace_print-margin",e.appendChild(this.$printMarginEl),this.content.insertBefore(e,this.content.firstChild)}var t=this.$printMarginEl.style;t.left=Math.round(this.characterWidth*this.$printMarginColumn+this.$padding)+"px",t.visibility=this.$showPrintMargin?"visible":"hidden",this.session&&-1==this.session.$wrap&&this.adjustWrapLimit()}},this.getContainerElement=function(){return this.container},this.getMouseEventTarget=function(){return this.scroller},this.getTextAreaContainer=function(){return this.container},this.$moveTextAreaToCursor=function(){if(!this.$isMousePressed){var e=this.textarea.style,t=this.$composition;if(this.$keepTextAreaAtCursor||t){var i=this.$cursorLayer.$pixelPos;if(i){t&&t.markerRange&&(i=this.$cursorLayer.getPixelPosition(t.markerRange.start,!0));var n=this.layerConfig,r=i.top,o=i.left;r-=n.offset;var s=t&&t.useTextareaForIME?this.lineHeight:C?0:1;if(r<0||r>n.height-s)h.translate(this.textarea,0,0);else{var a=1,l=this.$size.height-s;if(t)if(t.useTextareaForIME){var c=this.textarea.value;a=this.characterWidth*this.session.$getStringScreenWidth(c)[0]}else r+=this.lineHeight+2;else r+=this.lineHeight;(o-=this.scrollLeft)>this.$size.scrollerWidth-a&&(o=this.$size.scrollerWidth-a),o+=this.gutterWidth+this.margin.left,h.setStyle(e,"height",s+"px"),h.setStyle(e,"width",a+"px"),h.translate(this.textarea,Math.min(o,this.$size.scrollerWidth-a),Math.min(r,l))}}}else h.translate(this.textarea,-100,0)}},this.getFirstVisibleRow=function(){return this.layerConfig.firstRow},this.getFirstFullyVisibleRow=function(){return this.layerConfig.firstRow+(0===this.layerConfig.offset?0:1)},this.getLastFullyVisibleRow=function(){var e=this.layerConfig,t=e.lastRow;return this.session.documentToScreenRow(t,0)*e.lineHeight-this.session.getScrollTop()>e.height-e.lineHeight?t-1:t},this.getLastVisibleRow=function(){return this.layerConfig.lastRow},this.$padding=null,this.setPadding=function(e){this.$padding=e,this.$textLayer.setPadding(e),this.$cursorLayer.setPadding(e),this.$markerFront.setPadding(e),this.$markerBack.setPadding(e),this.$loop.schedule(this.CHANGE_FULL),this.$updatePrintMargin()},this.setScrollMargin=function(e,t,i,n){var r=this.scrollMargin;r.top=0|e,r.bottom=0|t,r.right=0|n,r.left=0|i,r.v=r.top+r.bottom,r.h=r.left+r.right,r.top&&this.scrollTop<=0&&this.session&&this.session.setScrollTop(-r.top),this.updateFull()},this.setMargin=function(e,t,i,n){var r=this.margin;r.top=0|e,r.bottom=0|t,r.right=0|n,r.left=0|i,r.v=r.top+r.bottom,r.h=r.left+r.right,this.$updateCachedSize(!0,this.gutterWidth,this.$size.width,this.$size.height),this.updateFull()},this.getHScrollBarAlwaysVisible=function(){return this.$hScrollBarAlwaysVisible},this.setHScrollBarAlwaysVisible=function(e){this.setOption("hScrollBarAlwaysVisible",e)},this.getVScrollBarAlwaysVisible=function(){return this.$vScrollBarAlwaysVisible},this.setVScrollBarAlwaysVisible=function(e){this.setOption("vScrollBarAlwaysVisible",e)},this.$updateScrollBarV=function(){var e=this.layerConfig.maxHeight,t=this.$size.scrollerHeight;!this.$maxLines&&this.$scrollPastEnd&&(e-=(t-this.lineHeight)*this.$scrollPastEnd,this.scrollTop>e-t&&(e=this.scrollTop+t,this.scrollBarV.scrollTop=null)),this.scrollBarV.setScrollHeight(e+this.scrollMargin.v),this.scrollBarV.setScrollTop(this.scrollTop+this.scrollMargin.top)},this.$updateScrollBarH=function(){this.scrollBarH.setScrollWidth(this.layerConfig.width+2*this.$padding+this.scrollMargin.h),this.scrollBarH.setScrollLeft(this.scrollLeft+this.scrollMargin.left)},this.$frozen=!1,this.freeze=function(){this.$frozen=!0},this.unfreeze=function(){this.$frozen=!1},this.$renderChanges=function(e,t){if(this.$changes&&(e|=this.$changes,this.$changes=0),this.session&&this.container.offsetWidth&&!this.$frozen&&(e||t)){if(this.$size.$dirty)return this.$changes|=e,this.onResize(!0);this.lineHeight||this.$textLayer.checkForSizeChanges(),this._signal("beforeRender"),this.session&&this.session.$bidiHandler&&this.session.$bidiHandler.updateCharacterWidths(this.$fontMetrics);var i=this.layerConfig;if(e&this.CHANGE_FULL||e&this.CHANGE_SIZE||e&this.CHANGE_TEXT||e&this.CHANGE_LINES||e&this.CHANGE_SCROLL||e&this.CHANGE_H_SCROLL){if(e|=this.$computeLayerConfig()|this.$loop.clear(),i.firstRow!=this.layerConfig.firstRow&&i.firstRowScreen==this.layerConfig.firstRowScreen){var n=this.scrollTop+(i.firstRow-this.layerConfig.firstRow)*this.lineHeight;0<n&&(this.scrollTop=n,e|=this.CHANGE_SCROLL,e|=this.$computeLayerConfig()|this.$loop.clear())}i=this.layerConfig,this.$updateScrollBarV(),e&this.CHANGE_H_SCROLL&&this.$updateScrollBarH(),h.translate(this.content,-this.scrollLeft,-i.offset);var r=i.width+2*this.$padding+"px",o=i.minHeight+"px";h.setStyle(this.content.style,"width",r),h.setStyle(this.content.style,"height",o)}if(e&this.CHANGE_H_SCROLL&&(h.translate(this.content,-this.scrollLeft,-i.offset),this.scroller.className=this.scrollLeft<=0?"ace_scroller":"ace_scroller ace_scroll-left"),e&this.CHANGE_FULL)return this.$changedLines=null,this.$textLayer.update(i),this.$showGutter&&this.$gutterLayer.update(i),this.$markerBack.update(i),this.$markerFront.update(i),this.$cursorLayer.update(i),this.$moveTextAreaToCursor(),void this._signal("afterRender");if(e&this.CHANGE_SCROLL)return this.$changedLines=null,e&this.CHANGE_TEXT||e&this.CHANGE_LINES?this.$textLayer.update(i):this.$textLayer.scrollLines(i),this.$showGutter&&(e&this.CHANGE_GUTTER||e&this.CHANGE_LINES?this.$gutterLayer.update(i):this.$gutterLayer.scrollLines(i)),this.$markerBack.update(i),this.$markerFront.update(i),this.$cursorLayer.update(i),this.$moveTextAreaToCursor(),void this._signal("afterRender");e&this.CHANGE_TEXT?(this.$changedLines=null,this.$textLayer.update(i),this.$showGutter&&this.$gutterLayer.update(i)):e&this.CHANGE_LINES?(this.$updateLines()||e&this.CHANGE_GUTTER&&this.$showGutter)&&this.$gutterLayer.update(i):e&this.CHANGE_TEXT||e&this.CHANGE_GUTTER?this.$showGutter&&this.$gutterLayer.update(i):e&this.CHANGE_CURSOR&&this.$highlightGutterLine&&this.$gutterLayer.updateLineHighlight(i),e&this.CHANGE_CURSOR&&(this.$cursorLayer.update(i),this.$moveTextAreaToCursor()),e&(this.CHANGE_MARKER|this.CHANGE_MARKER_FRONT)&&this.$markerFront.update(i),e&(this.CHANGE_MARKER|this.CHANGE_MARKER_BACK)&&this.$markerBack.update(i),this._signal("afterRender")}else this.$changes|=e},this.$autosize=function(){var e=this.session.getScreenLength()*this.lineHeight,t=this.$maxLines*this.lineHeight,i=Math.min(t,Math.max((this.$minLines||1)*this.lineHeight,e))+this.scrollMargin.v+(this.$extraHeight||0);this.$horizScroll&&(i+=this.scrollBarH.getHeight()),this.$maxPixelHeight&&i>this.$maxPixelHeight&&(i=this.$maxPixelHeight);var n=!(i<=2*this.lineHeight)&&t<e;if(i!=this.desiredHeight||this.$size.height!=this.desiredHeight||n!=this.$vScroll){n!=this.$vScroll&&(this.$vScroll=n,this.scrollBarV.setVisible(n));var r=this.container.clientWidth;this.container.style.height=i+"px",this.$updateCachedSize(!0,this.$gutterWidth,r,i),this.desiredHeight=i,this._signal("autosize")}},this.$computeLayerConfig=function(){var e=this.session,t=this.$size,i=t.height<=2*this.lineHeight,n=this.session.getScreenLength()*this.lineHeight,r=this.$getLongestLine(),o=!i&&(this.$hScrollBarAlwaysVisible||t.scrollerWidth-r-2*this.$padding<0),s=this.$horizScroll!==o;s&&(this.$horizScroll=o,this.scrollBarH.setVisible(o));var a=this.$vScroll;this.$maxLines&&1<this.lineHeight&&this.$autosize();var l=t.scrollerHeight+this.lineHeight,c=!this.$maxLines&&this.$scrollPastEnd?(t.scrollerHeight-this.lineHeight)*this.$scrollPastEnd:0;n+=c;var h=this.scrollMargin;this.session.setScrollTop(Math.max(-h.top,Math.min(this.scrollTop,n-t.scrollerHeight+h.bottom))),this.session.setScrollLeft(Math.max(-h.left,Math.min(this.scrollLeft,r+2*this.$padding-t.scrollerWidth+h.right)));var d=!i&&(this.$vScrollBarAlwaysVisible||t.scrollerHeight-n+c<0||this.scrollTop>h.top),u=a!==d;u&&(this.$vScroll=d,this.scrollBarV.setVisible(d));var g,p,m=this.scrollTop%this.lineHeight,f=Math.ceil(l/this.lineHeight)-1,C=Math.max(0,Math.round((this.scrollTop-m)/this.lineHeight)),I=C+f,A=this.lineHeight;C=e.screenToDocumentRow(C,0);var v=e.getFoldLine(C);v&&(C=v.start.row),g=e.documentToScreenRow(C,0),p=e.getRowLength(C)*A,I=Math.min(e.screenToDocumentRow(I,0),e.getLength()-1),l=t.scrollerHeight+e.getRowLength(I)*A+p,m=this.scrollTop-g*A;var b=0;return this.layerConfig.width==r&&!s||(b=this.CHANGE_H_SCROLL),(s||u)&&(b|=this.$updateCachedSize(!0,this.gutterWidth,t.width,t.height),this._signal("scrollbarVisibilityChanged"),u&&(r=this.$getLongestLine())),this.layerConfig={width:r,padding:this.$padding,firstRow:C,firstRowScreen:g,lastRow:I,lineHeight:A,characterWidth:this.characterWidth,minHeight:l,maxHeight:n,offset:m,gutterOffset:A?Math.max(0,Math.ceil((m+t.height-t.scrollerHeight)/A)):0,height:this.$size.scrollerHeight},this.session.$bidiHandler&&this.session.$bidiHandler.setContentWidth(r-this.$padding),b},this.$updateLines=function(){if(this.$changedLines){var e=this.$changedLines.firstRow,t=this.$changedLines.lastRow;this.$changedLines=null;var i=this.layerConfig;if(!(e>i.lastRow+1||t<i.firstRow))return t===1/0?(this.$showGutter&&this.$gutterLayer.update(i),void this.$textLayer.update(i)):(this.$textLayer.updateLines(i,e,t),!0)}},this.$getLongestLine=function(){var e=this.session.getScreenWidth();return this.showInvisibles&&!this.session.$useWrapMode&&(e+=1),this.$textLayer&&e>this.$textLayer.MAX_LINE_LENGTH&&(e=this.$textLayer.MAX_LINE_LENGTH+30),Math.max(this.$size.scrollerWidth-2*this.$padding,Math.round(e*this.characterWidth))},this.updateFrontMarkers=function(){this.$markerFront.setMarkers(this.session.getMarkers(!0)),this.$loop.schedule(this.CHANGE_MARKER_FRONT)},this.updateBackMarkers=function(){this.$markerBack.setMarkers(this.session.getMarkers()),this.$loop.schedule(this.CHANGE_MARKER_BACK)},this.addGutterDecoration=function(e,t){this.$gutterLayer.addGutterDecoration(e,t)},this.removeGutterDecoration=function(e,t){this.$gutterLayer.removeGutterDecoration(e,t)},this.updateBreakpoints=function(e){this.$loop.schedule(this.CHANGE_GUTTER)},this.setAnnotations=function(e){this.$gutterLayer.setAnnotations(e),this.$loop.schedule(this.CHANGE_GUTTER)},this.updateCursor=function(){this.$loop.schedule(this.CHANGE_CURSOR)},this.hideCursor=function(){this.$cursorLayer.hideCursor()},this.showCursor=function(){this.$cursorLayer.showCursor()},this.scrollSelectionIntoView=function(e,t,i){this.scrollCursorIntoView(e,i),this.scrollCursorIntoView(t,i)},this.scrollCursorIntoView=function(e,t,i){if(0!==this.$size.scrollerHeight){var n=this.$cursorLayer.getPixelPosition(e),r=n.left,o=n.top,s=i&&i.top||0,a=i&&i.bottom||0,l=this.$scrollAnimation?this.session.getScrollTop():this.scrollTop;o<l+s?(t&&l+s>o+this.lineHeight&&(o-=t*this.$size.scrollerHeight),0===o&&(o=-this.scrollMargin.top),this.session.setScrollTop(o)):l+this.$size.scrollerHeight-a<o+this.lineHeight&&(t&&l+this.$size.scrollerHeight-a<o-this.lineHeight&&(o+=t*this.$size.scrollerHeight),this.session.setScrollTop(o+this.lineHeight+a-this.$size.scrollerHeight));var c=this.scrollLeft;r<c?(r<this.$padding+2*this.layerConfig.characterWidth&&(r=-this.scrollMargin.left),this.session.setScrollLeft(r)):c+this.$size.scrollerWidth<r+this.characterWidth?this.session.setScrollLeft(Math.round(r+this.characterWidth-this.$size.scrollerWidth)):c<=this.$padding&&r-c<this.characterWidth&&this.session.setScrollLeft(0)}},this.getScrollTop=function(){return this.session.getScrollTop()},this.getScrollLeft=function(){return this.session.getScrollLeft()},this.getScrollTopRow=function(){return this.scrollTop/this.lineHeight},this.getScrollBottomRow=function(){return Math.max(0,Math.floor((this.scrollTop+this.$size.scrollerHeight)/this.lineHeight)-1)},this.scrollToRow=function(e){this.session.setScrollTop(e*this.lineHeight)},this.alignCursor=function(e,t){"number"==typeof e&&(e={row:e,column:0});var i=this.$cursorLayer.getPixelPosition(e),n=this.$size.scrollerHeight-this.lineHeight,r=i.top-n*(t||0);return this.session.setScrollTop(r),r},this.STEPS=8,this.$calcSteps=function(e,t){var i,n,r=0,o=this.STEPS,s=[];for(r=0;r<o;++r)s.push((i=r/this.STEPS,(t-(n=e))*(Math.pow(i-1,3)+1)+n));return s},this.scrollToLine=function(e,t,i,n){var r=this.$cursorLayer.getPixelPosition({row:e,column:0}).top;t&&(r-=this.$size.scrollerHeight/2);var o=this.scrollTop;this.session.setScrollTop(r),!1!==i&&this.animateScrolling(o,n)},this.animateScrolling=function(e,t){var i=this.scrollTop;if(this.$animatedScroll){var n=this;if(e!=i){if(this.$scrollAnimation){var r=this.$scrollAnimation.steps;if(r.length&&(e=r[0])==i)return}var o=n.$calcSteps(e,i);this.$scrollAnimation={from:e,to:i,steps:o},clearInterval(this.$timer),n.session.setScrollTop(o.shift()),n.session.$scrollTop=i,this.$timer=setInterval(function(){o.length?(n.session.setScrollTop(o.shift()),n.session.$scrollTop=i):null!=i?(n.session.$scrollTop=-1,n.session.setScrollTop(i),i=null):(n.$timer=clearInterval(n.$timer),n.$scrollAnimation=null,t&&t())},10)}}},this.scrollToY=function(e){this.scrollTop!==e&&(this.$loop.schedule(this.CHANGE_SCROLL),this.scrollTop=e)},this.scrollToX=function(e){this.scrollLeft!==e&&(this.scrollLeft=e),this.$loop.schedule(this.CHANGE_H_SCROLL)},this.scrollTo=function(e,t){this.session.setScrollTop(t),this.session.setScrollLeft(t)},this.scrollBy=function(e,t){t&&this.session.setScrollTop(this.session.getScrollTop()+t),e&&this.session.setScrollLeft(this.session.getScrollLeft()+e)},this.isScrollableBy=function(e,t){return t<0&&this.session.getScrollTop()>=1-this.scrollMargin.top||(0<t&&this.session.getScrollTop()+this.$size.scrollerHeight-this.layerConfig.maxHeight<-1+this.scrollMargin.bottom||(e<0&&this.session.getScrollLeft()>=1-this.scrollMargin.left||(0<e&&this.session.getScrollLeft()+this.$size.scrollerWidth-this.layerConfig.width<-1+this.scrollMargin.right||void 0)))},this.pixelToScreenCoordinates=function(e,t){var i;if(this.$hasCssTransforms){i={top:0,left:0};var n=this.$fontMetrics.transformCoordinates([e,t]);e=n[1]-this.gutterWidth-this.margin.left,t=n[0]}else i=this.scroller.getBoundingClientRect();var r=e+this.scrollLeft-i.left-this.$padding,o=r/this.characterWidth,s=Math.floor((t+this.scrollTop-i.top)/this.lineHeight),a=this.$blockCursor?Math.floor(o):Math.round(o);return{row:s,column:a,side:0<o-a?1:-1,offsetX:r}},this.screenToTextCoordinates=function(e,t){var i;if(this.$hasCssTransforms){i={top:0,left:0};var n=this.$fontMetrics.transformCoordinates([e,t]);e=n[1]-this.gutterWidth-this.margin.left,t=n[0]}else i=this.scroller.getBoundingClientRect();var r=e+this.scrollLeft-i.left-this.$padding,o=r/this.characterWidth,s=this.$blockCursor?Math.floor(o):Math.round(o),a=Math.floor((t+this.scrollTop-i.top)/this.lineHeight);return this.session.screenToDocumentPosition(a,Math.max(s,0),r)},this.textToScreenCoordinates=function(e,t){var i=this.scroller.getBoundingClientRect(),n=this.session.documentToScreenPosition(e,t),r=this.$padding+(this.session.$bidiHandler.isBidiRow(n.row,e)?this.session.$bidiHandler.getPosLeft(n.column):Math.round(n.column*this.characterWidth)),o=n.row*this.lineHeight;return{pageX:i.left+r-this.scrollLeft,pageY:i.top+o-this.scrollTop}},this.visualizeFocus=function(){h.addCssClass(this.container,"ace_focus")},this.visualizeBlur=function(){h.removeCssClass(this.container,"ace_focus")},this.showComposition=function(e){(this.$composition=e).cssText||(e.cssText=this.textarea.style.cssText),e.useTextareaForIME=this.$useTextareaForIME,this.$useTextareaForIME?(h.addCssClass(this.textarea,"ace_composition"),this.textarea.style.cssText="",this.$moveTextAreaToCursor(),this.$cursorLayer.element.style.display="none"):e.markerId=this.session.addMarker(e.markerRange,"ace_composition_marker","text")},this.setCompositionText=function(e){var t=this.session.selection.cursor;this.addToken(e,"composition_placeholder",t.row,t.column),this.$moveTextAreaToCursor()},this.hideComposition=function(){this.$composition&&(this.$composition.markerId&&this.session.removeMarker(this.$composition.markerId),h.removeCssClass(this.textarea,"ace_composition"),this.textarea.style.cssText=this.$composition.cssText,this.$composition=null,this.$cursorLayer.element.style.display="")},this.addToken=function(e,t,i,n){var r=this.session;r.bgTokenizer.lines[i]=null;var o={type:t,value:e},s=r.getTokens(i);if(null==n)s.push(o);else for(var a=0,l=0;l<s.length;l++){var c=s[l];if(n<=(a+=c.value.length)){var h=c.value.length-(a-n),d=c.value.slice(0,h),u=c.value.slice(h);s.splice(l,1,{type:c.type,value:d},o,{type:c.type,value:u});break}}this.updateLines(i,i)},this.setTheme=function(i,n){var r=this;if(this.$themeId=i,r._dispatchEvent("themeChange",{theme:i}),i&&"string"!=typeof i)t(i);else{var e=i||this.$options.theme.initialValue;o.loadModule(["theme",e],t)}function t(e){if(r.$themeId!=i)return n&&n();if(!e||!e.cssClass)throw new Error("couldn't load module "+i+" or it didn't call define");e.$id&&(r.$themeId=e.$id),h.importCssString(e.cssText,e.cssClass,r.container),r.theme&&h.removeCssClass(r.container,r.theme.cssClass);var t="padding"in e?e.padding:"padding"in(r.theme||{})?4:r.$padding;r.$padding&&t!=r.$padding&&r.setPadding(t),r.$theme=e.cssClass,r.theme=e,h.addCssClass(r.container,e.cssClass),h.setCssClass(r.container,"ace_dark",e.isDark),r.$size&&(r.$size.width=0,r.$updateSizeAsync()),r._dispatchEvent("themeLoaded",{theme:e}),n&&n()}},this.getTheme=function(){return this.$themeId},this.setStyle=function(e,t){h.setCssClass(this.container,e,!1!==t)},this.unsetStyle=function(e){h.removeCssClass(this.container,e)},this.setCursorStyle=function(e){h.setStyle(this.scroller.style,"cursor",e)},this.setMouseCursor=function(e){h.setStyle(this.scroller.style,"cursor",e)},this.attachToShadowRoot=function(){h.importCssString(m,"ace_editor.css",this.container)},this.destroy=function(){this.freeze(),this.$fontMetrics.destroy(),this.$cursorLayer.destroy()}}).call(I.prototype),o.defineOptions(I.prototype,"renderer",{animatedScroll:{initialValue:!1},showInvisibles:{set:function(e){this.$textLayer.setShowInvisibles(e)&&this.$loop.schedule(this.CHANGE_TEXT)},initialValue:!1},showPrintMargin:{set:function(){this.$updatePrintMargin()},initialValue:!0},printMarginColumn:{set:function(){this.$updatePrintMargin()},initialValue:80},printMargin:{set:function(e){"number"==typeof e&&(this.$printMarginColumn=e),this.$showPrintMargin=!!e,this.$updatePrintMargin()},get:function(){return this.$showPrintMargin&&this.$printMarginColumn}},showGutter:{set:function(e){this.$gutter.style.display=e?"block":"none",this.$loop.schedule(this.CHANGE_FULL),this.onGutterResize()},initialValue:!0},fadeFoldWidgets:{set:function(e){h.setCssClass(this.$gutter,"ace_fade-fold-widgets",e)},initialValue:!1},showFoldWidgets:{set:function(e){this.$gutterLayer.setShowFoldWidgets(e),this.$loop.schedule(this.CHANGE_GUTTER)},initialValue:!0},displayIndentGuides:{set:function(e){this.$textLayer.setDisplayIndentGuides(e)&&this.$loop.schedule(this.CHANGE_TEXT)},initialValue:!0},highlightGutterLine:{set:function(e){this.$gutterLayer.setHighlightGutterLine(e),this.$loop.schedule(this.CHANGE_GUTTER)},initialValue:!0},hScrollBarAlwaysVisible:{set:function(e){this.$hScrollBarAlwaysVisible&&this.$horizScroll||this.$loop.schedule(this.CHANGE_SCROLL)},initialValue:!1},vScrollBarAlwaysVisible:{set:function(e){this.$vScrollBarAlwaysVisible&&this.$vScroll||this.$loop.schedule(this.CHANGE_SCROLL)},initialValue:!1},fontSize:{set:function(e){"number"==typeof e&&(e+="px"),this.container.style.fontSize=e,this.updateFontSize()},initialValue:12},fontFamily:{set:function(e){this.container.style.fontFamily=e,this.updateFontSize()}},maxLines:{set:function(e){this.updateFull()}},minLines:{set:function(e){this.$minLines<562949953421311||(this.$minLines=0),this.updateFull()}},maxPixelHeight:{set:function(e){this.updateFull()},initialValue:0},scrollPastEnd:{set:function(e){e=+e||0,this.$scrollPastEnd!=e&&(this.$scrollPastEnd=e,this.$loop.schedule(this.CHANGE_SCROLL))},initialValue:0,handlesSet:!0},fixedWidthGutter:{set:function(e){this.$gutterLayer.$fixedWidth=!!e,this.$loop.schedule(this.CHANGE_GUTTER)}},theme:{set:function(e){this.setTheme(e)},get:function(){return this.$themeId||this.theme},initialValue:"./theme/textmate",handlesSet:!0},hasCssTransforms:{},useTextareaForIME:{initialValue:!f.isMobile&&!f.isIE}}),t.VirtualRenderer=I}),ace.define("ace/worker/worker_client",["require","exports","module","ace/lib/oop","ace/lib/net","ace/lib/event_emitter","ace/config"],function(a,e,t){"use strict";var i=a("../lib/oop"),n=a("../lib/net"),c=a("../lib/event_emitter").EventEmitter,h=a("../config");function l(e){if("undefined"==typeof Worker)return{postMessage:function(){},terminate:function(){}};if(h.get("loadWorkerFromBlob")){var t=function(e){var t="importScripts('"+n.qualifyURL(e)+"');";try{return new Blob([t],{type:"application/javascript"})}catch(e){var i=new(window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder);return i.append(t),i.getBlob("application/javascript")}}(e),i=(window.URL||window.webkitURL).createObjectURL(t);return new Worker(i)}return new Worker(e)}function d(e){e.postMessage||(e=this.$createWorkerFromOldConfig.apply(this,arguments)),this.$worker=e,this.$sendDeltaQueue=this.$sendDeltaQueue.bind(this),this.changeListener=this.changeListener.bind(this),this.onMessage=this.onMessage.bind(this),this.callbackId=1,this.callbacks={},this.$worker.onmessage=this.onMessage}(function(){i.implement(this,c),this.$createWorkerFromOldConfig=function(e,t,i,n,r){if(a.nameToUrl&&!a.toUrl&&(a.toUrl=a.nameToUrl),h.get("packaged")||!a.toUrl)n=n||h.moduleUrl(t,"worker");else{var o=this.$normalizePath;n=n||o(a.toUrl("ace/worker/worker.js",null,"_"));var s={};e.forEach(function(e){s[e]=o(a.toUrl(e,null,"_").replace(/(\.js)?(\?.*)?$/,""))})}return this.$worker=l(n),r&&this.send("importScripts",r),this.$worker.postMessage({init:!0,tlns:s,module:t,classname:i}),this.$worker},this.onMessage=function(e){var t=e.data;switch(t.type){case"event":this._signal(t.name,{data:t.data});break;case"call":var i=this.callbacks[t.id];i&&(i(t.data),delete this.callbacks[t.id]);break;case"error":this.reportError(t.data);break;case"log":window.console&&console.log&&console.log.apply(console,t.data)}},this.reportError=function(e){window.console&&console.error&&console.error(e)},this.$normalizePath=function(e){return n.qualifyURL(e)},this.terminate=function(){this._signal("terminate",{}),this.deltaQueue=null,this.$worker.terminate(),this.$worker=null,this.$doc&&this.$doc.off("change",this.changeListener),this.$doc=null},this.send=function(e,t){this.$worker.postMessage({command:e,args:t})},this.call=function(e,t,i){if(i){var n=this.callbackId++;this.callbacks[n]=i,t.push(n)}this.send(e,t)},this.emit=function(e,t){try{t.data&&t.data.err&&(t.data.err={message:t.data.err.message,stack:t.data.err.stack,code:t.data.err.code}),this.$worker.postMessage({event:e,data:{data:t.data}})}catch(e){console.error(e.stack)}},this.attachToDocument=function(e){this.$doc&&this.terminate(),this.$doc=e,this.call("setValue",[e.getValue()]),e.on("change",this.changeListener)},this.changeListener=function(e){this.deltaQueue||(this.deltaQueue=[],setTimeout(this.$sendDeltaQueue,0)),"insert"==e.action?this.deltaQueue.push(e.start,e.lines):this.deltaQueue.push(e.start,e.end)},this.$sendDeltaQueue=function(){var e=this.deltaQueue;e&&(this.deltaQueue=null,50<e.length&&e.length>this.$doc.getLength()>>1?this.call("setValue",[this.$doc.getValue()]):this.emit("change",{data:e}))}}).call(d.prototype);e.UIWorkerClient=function(e,t,i){var n=null,r=!1,o=Object.create(c),s=[],a=new d({messageBuffer:s,terminate:function(){},postMessage:function(e){s.push(e),n&&(r?setTimeout(l):l())}});a.setEmitSync=function(e){r=e};var l=function(){var e=s.shift();e.command?n[e.command].apply(n,e.args):e.event&&o._signal(e.event,e.data)};return o.postMessage=function(e){a.onMessage({data:e})},o.callback=function(e,t){this.postMessage({type:"call",id:t,data:e})},o.emit=function(e,t){this.postMessage({type:"event",name:e,data:t})},h.loadModule(["worker",t],function(e){for(n=new e[i](o);s.length;)l()}),a},e.WorkerClient=d,e.createWorker=l}),ace.define("ace/placeholder",["require","exports","module","ace/range","ace/lib/event_emitter","ace/lib/oop"],function(e,t,i){"use strict";function n(e,t,i,n,r,o){var s=this;this.length=t,this.session=e,this.doc=e.getDocument(),this.mainClass=r,this.othersClass=o,this.$onUpdate=this.onUpdate.bind(this),this.doc.on("change",this.$onUpdate),this.$others=n,this.$onCursorChange=function(){setTimeout(function(){s.onCursorChange()})},this.$pos=i;var a=e.getUndoManager().$undoStack||e.getUndoManager().$undostack||{length:-1};this.$undoStackDepth=a.length,this.setup(),e.selection.on("changeCursor",this.$onCursorChange)}var l=e("./range").Range,r=e("./lib/event_emitter").EventEmitter,o=e("./lib/oop");(function(){o.implement(this,r),this.setup=function(){var i=this,n=this.doc,e=this.session;this.selectionBefore=e.selection.toJSON(),e.selection.inMultiSelectMode&&e.selection.toSingleRange(),this.pos=n.createAnchor(this.$pos.row,this.$pos.column);var t=this.pos;t.$insertRight=!0,t.detach(),t.markerId=e.addMarker(new l(t.row,t.column,t.row,t.column+this.length),this.mainClass,null,!1),this.others=[],this.$others.forEach(function(e){var t=n.createAnchor(e.row,e.column);t.$insertRight=!0,t.detach(),i.others.push(t)}),e.setUndoSelect(!1)},this.showOtherMarkers=function(){if(!this.othersActive){var t=this.session,i=this;this.othersActive=!0,this.others.forEach(function(e){e.markerId=t.addMarker(new l(e.row,e.column,e.row,e.column+i.length),i.othersClass,null,!1)})}},this.hideOtherMarkers=function(){if(this.othersActive){this.othersActive=!1;for(var e=0;e<this.others.length;e++)this.session.removeMarker(this.others[e].markerId)}},this.onUpdate=function(e){if(this.$updating)return this.updateAnchors(e);var t=e;if(t.start.row===t.end.row&&t.start.row===this.pos.row){this.$updating=!0;var i="insert"===e.action?t.end.column-t.start.column:t.start.column-t.end.column,n=t.start.column>=this.pos.column&&t.start.column<=this.pos.column+this.length+1,r=t.start.column-this.pos.column;if(this.updateAnchors(e),n&&(this.length+=i),n&&!this.session.$fromUndo)if("insert"===e.action)for(var o=this.others.length-1;0<=o;o--){var s={row:(a=this.others[o]).row,column:a.column+r};this.doc.insertMergedLines(s,e.lines)}else if("remove"===e.action)for(o=this.others.length-1;0<=o;o--){var a;s={row:(a=this.others[o]).row,column:a.column+r};this.doc.remove(new l(s.row,s.column,s.row,s.column-i))}this.$updating=!1,this.updateMarkers()}},this.updateAnchors=function(e){this.pos.onChange(e);for(var t=this.others.length;t--;)this.others[t].onChange(e);this.updateMarkers()},this.updateMarkers=function(){if(!this.$updating){var i=this,n=this.session,e=function(e,t){n.removeMarker(e.markerId),e.markerId=n.addMarker(new l(e.row,e.column,e.row,e.column+i.length),t,null,!1)};e(this.pos,this.mainClass);for(var t=this.others.length;t--;)e(this.others[t],this.othersClass)}},this.onCursorChange=function(e){if(!this.$updating&&this.session){var t=this.session.selection.getCursor();t.row===this.pos.row&&t.column>=this.pos.column&&t.column<=this.pos.column+this.length?(this.showOtherMarkers(),this._emit("cursorEnter",e)):(this.hideOtherMarkers(),this._emit("cursorLeave",e))}},this.detach=function(){this.session.removeMarker(this.pos&&this.pos.markerId),this.hideOtherMarkers(),this.doc.removeEventListener("change",this.$onUpdate),this.session.selection.removeEventListener("changeCursor",this.$onCursorChange),this.session.setUndoSelect(!0),this.session=null},this.cancel=function(){if(-1!==this.$undoStackDepth){for(var e=this.session.getUndoManager(),t=(e.$undoStack||e.$undostack).length-this.$undoStackDepth,i=0;i<t;i++)e.undo(this.session,!0);this.selectionBefore&&this.session.selection.fromJSON(this.selectionBefore)}}}).call(n.prototype),t.PlaceHolder=n}),ace.define("ace/mouse/multi_select_handler",["require","exports","module","ace/lib/event","ace/lib/useragent"],function(e,t,i){var k=e("../lib/event"),R=e("../lib/useragent");function E(e,t){return e.row==t.row&&e.column==t.column}t.onMouseDown=function(e){var t=e.domEvent,i=t.altKey,n=t.shiftKey,r=t.ctrlKey,o=e.getAccelKey(),s=e.getButton();if(r&&R.isMac&&(s=t.button),e.editor.inMultiSelectMode&&2==s)e.editor.textInput.onContextMenu(e.domEvent);else if(r||i||o){if(0===s){var a,l=e.editor,c=l.selection,h=l.inMultiSelectMode,d=e.getDocumentPosition(),u=c.getCursor(),g=e.inSelection()||c.isEmpty()&&E(d,u),p=e.x,m=e.y,f=l.session,C=l.renderer.pixelToScreenCoordinates(p,m),I=C;if(l.$mouseHandler.$enableJumpToDef)r&&i||o&&i?a=n?"block":"add":i&&l.$blockSelectEnabled&&(a="block");else if(o&&!i){if(a="add",!h&&n)return}else i&&l.$blockSelectEnabled&&(a="block");if(a&&R.isMac&&t.ctrlKey&&l.$mouseHandler.cancelContextMenu(),"add"==a){if(!h&&g)return;if(!h){var A=c.toOrientedRange();l.addSelectionMarker(A)}var v=c.rangeList.rangeAtPoint(d);l.inVirtualSelectionMode=!0,n&&(v=null,A=c.ranges[0]||A,l.removeSelectionMarker(A)),l.once("mouseup",function(){var e=c.toOrientedRange();v&&e.isEmpty()&&E(v.cursor,e.cursor)?c.substractPoint(e.cursor):(n?c.substractPoint(A.cursor):A&&(l.removeSelectionMarker(A),c.addRange(A)),c.addRange(e)),l.inVirtualSelectionMode=!1})}else if("block"==a){var b;e.stop(),l.inVirtualSelectionMode=!0;function y(){var e=l.renderer.pixelToScreenCoordinates(p,m),t=f.screenToDocumentPosition(e.row,e.column,e.offsetX);E(I,e)&&E(t,c.lead)||(I=e,l.selection.moveToPosition(t),l.renderer.scrollCursorIntoView(),l.removeSelectionMarkers(w),w=c.rectangularRangeBlock(I,C),l.$mouseHandler.$clickSelection&&1==w.length&&w[0].isEmpty()&&(w[0]=l.$mouseHandler.$clickSelection.clone()),w.forEach(l.addSelectionMarker,l),l.updateSelectionMarkers())}var w=[];h&&!o?c.toSingleRange():!h&&o&&(b=c.toOrientedRange(),l.addSelectionMarker(b)),n?C=f.documentToScreenPosition(c.lead):c.moveToPosition(d),I={row:-1,column:-1};var S=y;k.capture(l.container,function(e){p=e.clientX,m=e.clientY},function(e){y(),clearInterval(x),l.removeSelectionMarkers(w),w.length||(w=[c.toOrientedRange()]),b&&(l.removeSelectionMarker(b),c.toSingleRange(b));for(var t=0;t<w.length;t++)c.addRange(w[t]);l.inVirtualSelectionMode=!1,l.$mouseHandler.$clickSelection=null});var x=setInterval(function(){S()},20);return e.preventDefault()}}}else 0===s&&e.editor.inMultiSelectMode&&e.editor.exitMultiSelectMode()}}),ace.define("ace/commands/multi_select_commands",["require","exports","module","ace/keyboard/hash_handler"],function(e,t,i){t.defaultCommands=[{name:"addCursorAbove",description:"Add cursor above",exec:function(e){e.selectMoreLines(-1)},bindKey:{win:"Ctrl-Alt-Up",mac:"Ctrl-Alt-Up"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorBelow",description:"Add cursor below",exec:function(e){
e.selectMoreLines(1)},bindKey:{win:"Ctrl-Alt-Down",mac:"Ctrl-Alt-Down"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorAboveSkipCurrent",description:"Add cursor above (skip current)",exec:function(e){e.selectMoreLines(-1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Up",mac:"Ctrl-Alt-Shift-Up"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorBelowSkipCurrent",description:"Add cursor below (skip current)",exec:function(e){e.selectMoreLines(1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Down",mac:"Ctrl-Alt-Shift-Down"},scrollIntoView:"cursor",readOnly:!0},{name:"selectMoreBefore",description:"Select more before",exec:function(e){e.selectMore(-1)},bindKey:{win:"Ctrl-Alt-Left",mac:"Ctrl-Alt-Left"},scrollIntoView:"cursor",readOnly:!0},{name:"selectMoreAfter",description:"Select more after",exec:function(e){e.selectMore(1)},bindKey:{win:"Ctrl-Alt-Right",mac:"Ctrl-Alt-Right"},scrollIntoView:"cursor",readOnly:!0},{name:"selectNextBefore",description:"Select next before",exec:function(e){e.selectMore(-1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Left",mac:"Ctrl-Alt-Shift-Left"},scrollIntoView:"cursor",readOnly:!0},{name:"selectNextAfter",description:"Select next after",exec:function(e){e.selectMore(1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Right",mac:"Ctrl-Alt-Shift-Right"},scrollIntoView:"cursor",readOnly:!0},{name:"splitIntoLines",description:"Split into lines",exec:function(e){e.multiSelect.splitIntoLines()},bindKey:{win:"Ctrl-Alt-L",mac:"Ctrl-Alt-L"},readOnly:!0},{name:"alignCursors",description:"Align cursors",exec:function(e){e.alignCursors()},bindKey:{win:"Ctrl-Alt-A",mac:"Ctrl-Alt-A"},scrollIntoView:"cursor"},{name:"findAll",description:"Find all",exec:function(e){e.findAll()},bindKey:{win:"Ctrl-Alt-K",mac:"Ctrl-Alt-G"},scrollIntoView:"cursor",readOnly:!0}],t.multiSelectCommands=[{name:"singleSelection",description:"Single selection",bindKey:"esc",exec:function(e){e.exitMultiSelectMode()},scrollIntoView:"cursor",readOnly:!0,isAvailable:function(e){return e&&e.inMultiSelectMode}}];var n=e("../keyboard/hash_handler").HashHandler;t.keyboardHandler=new n(t.multiSelectCommands)}),ace.define("ace/multi_select",["require","exports","module","ace/range_list","ace/range","ace/selection","ace/mouse/multi_select_handler","ace/lib/event","ace/lib/lang","ace/commands/multi_select_commands","ace/search","ace/edit_session","ace/editor","ace/config"],function(e,t,i){var n=e("./range_list").RangeList,v=e("./range").Range,m=e("./selection").Selection,r=e("./mouse/multi_select_handler").onMouseDown,o=e("./lib/event"),f=e("./lib/lang"),s=e("./commands/multi_select_commands");t.commands=s.defaultCommands.concat(s.multiSelectCommands);var a=new(e("./search").Search);var l=e("./edit_session").EditSession;(function(){this.getSelectionMarkers=function(){return this.$selectionMarkers}}).call(l.prototype),function(){this.ranges=null,this.rangeList=null,this.addRange=function(e,t){if(e){if(!this.inMultiSelectMode&&0===this.rangeCount){var i=this.toOrientedRange();if(this.rangeList.add(i),this.rangeList.add(e),2!=this.rangeList.ranges.length)return this.rangeList.removeAll(),t||this.fromOrientedRange(e);this.rangeList.removeAll(),this.rangeList.add(i),this.$onAddRange(i)}e.cursor||(e.cursor=e.end);var n=this.rangeList.add(e);return this.$onAddRange(e),n.length&&this.$onRemoveRange(n),1<this.rangeCount&&!this.inMultiSelectMode&&(this._signal("multiSelect"),this.inMultiSelectMode=!0,this.session.$undoSelect=!1,this.rangeList.attach(this.session)),t||this.fromOrientedRange(e)}},this.toSingleRange=function(e){e=e||this.ranges[0];var t=this.rangeList.removeAll();t.length&&this.$onRemoveRange(t),e&&this.fromOrientedRange(e)},this.substractPoint=function(e){var t=this.rangeList.substractPoint(e);if(t)return this.$onRemoveRange(t),t[0]},this.mergeOverlappingRanges=function(){var e=this.rangeList.merge();e.length&&this.$onRemoveRange(e)},this.$onAddRange=function(e){this.rangeCount=this.rangeList.ranges.length,this.ranges.unshift(e),this._signal("addRange",{range:e})},this.$onRemoveRange=function(e){if(this.rangeCount=this.rangeList.ranges.length,1==this.rangeCount&&this.inMultiSelectMode){var t=this.rangeList.ranges.pop();e.push(t),this.rangeCount=0}for(var i=e.length;i--;){var n=this.ranges.indexOf(e[i]);this.ranges.splice(n,1)}this._signal("removeRange",{ranges:e}),0===this.rangeCount&&this.inMultiSelectMode&&(this.inMultiSelectMode=!1,this._signal("singleSelect"),this.session.$undoSelect=!0,this.rangeList.detach(this.session)),(t=t||this.ranges[0])&&!t.isEqual(this.getRange())&&this.fromOrientedRange(t)},this.$initRangeList=function(){this.rangeList||(this.rangeList=new n,this.ranges=[],this.rangeCount=0)},this.getAllRanges=function(){return this.rangeCount?this.rangeList.ranges.concat():[this.getRange()]},this.splitIntoLines=function(){if(1<this.rangeCount){var e=this.rangeList.ranges,t=e[e.length-1],i=v.fromPoints(e[0].start,t.end);this.toSingleRange(),this.setSelectionRange(i,t.cursor==t.start)}else{i=this.getRange();var n=this.isBackwards(),r=i.start.row,o=i.end.row;if(r==o){if(n)var s=i.end,a=i.start;else s=i.start,a=i.end;return this.addRange(v.fromPoints(a,a)),void this.addRange(v.fromPoints(s,s))}var l=[],c=this.getLineRange(r,!0);c.start.column=i.start.column,l.push(c);for(var h=r+1;h<o;h++)l.push(this.getLineRange(h,!0));(c=this.getLineRange(o,!0)).end.column=i.end.column,l.push(c),l.forEach(this.addRange,this)}},this.toggleBlockSelection=function(){if(1<this.rangeCount){var e=this.rangeList.ranges,t=e[e.length-1],i=v.fromPoints(e[0].start,t.end);this.toSingleRange(),this.setSelectionRange(i,t.cursor==t.start)}else{var n=this.session.documentToScreenPosition(this.cursor),r=this.session.documentToScreenPosition(this.anchor);this.rectangularRangeBlock(n,r).forEach(this.addRange,this)}},this.rectangularRangeBlock=function(e,t,i){var n=[],r=e.column<t.column;if(r)var o=e.column,s=t.column,a=e.offsetX,l=t.offsetX;else o=t.column,s=e.column,a=t.offsetX,l=e.offsetX;var c,h,d,u=e.row<t.row;if(u)var g=e.row,p=t.row;else g=t.row,p=e.row;o<0&&(o=0),g<0&&(g=0),g==p&&(i=!0);for(var m=g;m<=p;m++){var f=v.fromPoints(this.session.screenToDocumentPosition(m,o,a),this.session.screenToDocumentPosition(m,s,l));if(f.isEmpty()){if(c&&(h=f.end,d=c,h.row==d.row&&h.column==d.column))break;c=f.end}f.cursor=r?f.start:f.end,n.push(f)}if(u&&n.reverse(),!i){for(var C=n.length-1;n[C].isEmpty()&&0<C;)C--;if(0<C)for(var I=0;n[I].isEmpty();)I++;for(var A=C;I<=A;A--)n[A].isEmpty()&&n.splice(A,1)}return n}}.call(m.prototype);var c=e("./editor").Editor;function h(e){e.$multiselectOnSessionChange||(e.$onAddRange=e.$onAddRange.bind(e),e.$onRemoveRange=e.$onRemoveRange.bind(e),e.$onMultiSelect=e.$onMultiSelect.bind(e),e.$onSingleSelect=e.$onSingleSelect.bind(e),e.$multiselectOnSessionChange=t.onSessionChange.bind(e),e.$checkMultiselectChange=e.$checkMultiselectChange.bind(e),e.$multiselectOnSessionChange(e),e.on("changeSession",e.$multiselectOnSessionChange),e.on("mousedown",r),e.commands.addCommands(s.defaultCommands),function(i){if(!i.textInput)return;var e=i.textInput.getElement(),n=!1;function r(e){n&&(i.renderer.setMouseCursor(""),n=!1)}o.addListener(e,"keydown",function(e){var t=18==e.keyCode&&!(e.ctrlKey||e.shiftKey||e.metaKey);i.$blockSelectEnabled&&t?n||(i.renderer.setMouseCursor("crosshair"),n=!0):n&&r()}),o.addListener(e,"keyup",r),o.addListener(e,"blur",r)}(e))}(function(){this.updateSelectionMarkers=function(){this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.addSelectionMarker=function(e){e.cursor||(e.cursor=e.end);var t=this.getSelectionStyle();return e.marker=this.session.addMarker(e,"ace_selection",t),this.session.$selectionMarkers.push(e),this.session.selectionMarkerCount=this.session.$selectionMarkers.length,e},this.removeSelectionMarker=function(e){if(e.marker){this.session.removeMarker(e.marker);var t=this.session.$selectionMarkers.indexOf(e);-1!=t&&this.session.$selectionMarkers.splice(t,1),this.session.selectionMarkerCount=this.session.$selectionMarkers.length}},this.removeSelectionMarkers=function(e){for(var t=this.session.$selectionMarkers,i=e.length;i--;){var n=e[i];if(n.marker){this.session.removeMarker(n.marker);var r=t.indexOf(n);-1!=r&&t.splice(r,1)}}this.session.selectionMarkerCount=t.length},this.$onAddRange=function(e){this.addSelectionMarker(e.range),this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.$onRemoveRange=function(e){this.removeSelectionMarkers(e.ranges),this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.$onMultiSelect=function(e){this.inMultiSelectMode||(this.inMultiSelectMode=!0,this.setStyle("ace_multiselect"),this.keyBinding.addKeyboardHandler(s.keyboardHandler),this.commands.setDefaultHandler("exec",this.$onMultiSelectExec),this.renderer.updateCursor(),this.renderer.updateBackMarkers())},this.$onSingleSelect=function(e){this.session.multiSelect.inVirtualMode||(this.inMultiSelectMode=!1,this.unsetStyle("ace_multiselect"),this.keyBinding.removeKeyboardHandler(s.keyboardHandler),this.commands.removeDefaultHandler("exec",this.$onMultiSelectExec),this.renderer.updateCursor(),this.renderer.updateBackMarkers(),this._emit("changeSelection"))},this.$onMultiSelectExec=function(e){var t=e.command,i=e.editor;if(i.multiSelect){if(t.multiSelectAction)n="forEach"==t.multiSelectAction?i.forEachSelection(t,e.args):"forEachLine"==t.multiSelectAction?i.forEachSelection(t,e.args,!0):"single"==t.multiSelectAction?(i.exitMultiSelectMode(),t.exec(i,e.args||{})):t.multiSelectAction(i,e.args||{});else{var n=t.exec(i,e.args||{});i.multiSelect.addRange(i.multiSelect.toOrientedRange()),i.multiSelect.mergeOverlappingRanges()}return n}},this.forEachSelection=function(e,t,i){if(!this.inVirtualSelectionMode){var n,r=i&&i.keepOrder,o=1==i||i&&i.$byLines,s=this.session,a=this.selection,l=a.rangeList,c=(r?a:l).ranges;if(!c.length)return e.exec?e.exec(this,t||{}):e(this,t||{});var h=a._eventRegistry;a._eventRegistry={};var d=new m(s);this.inVirtualSelectionMode=!0;for(var u=c.length;u--;){if(o)for(;0<u&&c[u].start.row==c[u-1].end.row;)u--;d.fromOrientedRange(c[u]),d.index=u,this.selection=s.selection=d;var g=e.exec?e.exec(this,t||{}):e(this,t||{});n||void 0===g||(n=g),d.toOrientedRange(c[u])}d.detach(),this.selection=s.selection=a,this.inVirtualSelectionMode=!1,a._eventRegistry=h,a.mergeOverlappingRanges(),a.ranges[0]&&a.fromOrientedRange(a.ranges[0]);var p=this.renderer.$scrollAnimation;return this.onCursorChange(),this.onSelectionChange(),p&&p.from==p.to&&this.renderer.animateScrolling(p.from),n}},this.exitMultiSelectMode=function(){this.inMultiSelectMode&&!this.inVirtualSelectionMode&&this.multiSelect.toSingleRange()},this.getSelectedText=function(){var e="";if(this.inMultiSelectMode&&!this.inVirtualSelectionMode){for(var t=this.multiSelect.rangeList.ranges,i=[],n=0;n<t.length;n++)i.push(this.session.getTextRange(t[n]));var r=this.session.getDocument().getNewLineCharacter();(e=i.join(r)).length==(i.length-1)*r.length&&(e="")}else this.selection.isEmpty()||(e=this.session.getTextRange(this.getSelectionRange()));return e},this.$checkMultiselectChange=function(e,t){if(this.inMultiSelectMode&&!this.inVirtualSelectionMode){var i=this.multiSelect.ranges[0];if(this.multiSelect.isEmpty()&&t==this.multiSelect.anchor)return;var n=t==this.multiSelect.anchor?i.cursor==i.start?i.end:i.start:i.cursor;n.row!=t.row||this.session.$clipPositionToDocument(n.row,n.column).column!=t.column?this.multiSelect.toSingleRange(this.multiSelect.toOrientedRange()):this.multiSelect.mergeOverlappingRanges()}},this.findAll=function(e,t,i){if((t=t||{}).needle=e||t.needle,null==t.needle){var n=this.selection.isEmpty()?this.selection.getWordRange():this.selection.getRange();t.needle=this.session.getTextRange(n)}this.$search.set(t);var r=this.$search.findAll(this.session);if(!r.length)return 0;var o=this.multiSelect;i||o.toSingleRange(r[0]);for(var s=r.length;s--;)o.addRange(r[s],!0);return n&&o.rangeList.rangeAtPoint(n.start)&&o.addRange(n,!0),r.length},this.selectMoreLines=function(e,t){var i=this.selection.toOrientedRange(),n=i.cursor==i.end,r=this.session.documentToScreenPosition(i.cursor);this.selection.$desiredColumn&&(r.column=this.selection.$desiredColumn);var o,s=this.session.screenToDocumentPosition(r.row+e,r.column);if(i.isEmpty())l=s;else var a=this.session.documentToScreenPosition(n?i.end:i.start),l=this.session.screenToDocumentPosition(a.row+e,a.column);n?(o=v.fromPoints(s,l)).cursor=o.start:(o=v.fromPoints(l,s)).cursor=o.end;if(o.desiredColumn=r.column,this.selection.inMultiSelectMode){if(t)var c=i.cursor}else this.selection.addRange(i);this.selection.addRange(o),c&&this.selection.substractPoint(c)},this.transposeSelections=function(e){for(var t=this.session,i=t.multiSelect,n=i.ranges,r=n.length;r--;){if((a=n[r]).isEmpty()){var o=t.getWordRange(a.start.row,a.start.column);a.start.row=o.start.row,a.start.column=o.start.column,a.end.row=o.end.row,a.end.column=o.end.column}}i.mergeOverlappingRanges();var s=[];for(r=n.length;r--;){var a=n[r];s.unshift(t.getTextRange(a))}e<0?s.unshift(s.pop()):s.push(s.shift());for(r=n.length;r--;){o=(a=n[r]).clone();t.replace(a,s[r]),a.start.row=o.start.row,a.start.column=o.start.column}i.fromOrientedRange(i.ranges[0])},this.selectMore=function(e,t,i){var n=this.session,r=n.multiSelect.toOrientedRange();if(!r.isEmpty()||((r=n.getWordRange(r.start.row,r.start.column)).cursor=-1==e?r.start:r.end,this.multiSelect.addRange(r),!i)){var o=n.getTextRange(r),s=function(e,t,i){return a.$options.wrap=!0,a.$options.needle=t,a.$options.backwards=-1==i,a.find(e)}(n,o,e);s&&(s.cursor=-1==e?s.start:s.end,this.session.unfold(s),this.multiSelect.addRange(s),this.renderer.scrollCursorIntoView(null,.5)),t&&this.multiSelect.substractPoint(r.cursor)}},this.alignCursors=function(){var o=this.session,t=o.multiSelect,e=t.ranges,i=-1,n=e.filter(function(e){if(e.cursor.row==i)return!0;i=e.cursor.row});if(e.length&&n.length!=e.length-1){n.forEach(function(e){t.substractPoint(e.cursor)});var s=0,a=1/0,l=e.map(function(e){var t=e.cursor,i=o.getLine(t.row).substr(t.column).search(/\S/g);return-1==i&&(i=0),t.column>s&&(s=t.column),i<a&&(a=i),i});e.forEach(function(e,t){var i=e.cursor,n=s-i.column,r=l[t]-a;r<n?o.insert(i,f.stringRepeat(" ",n-r)):o.remove(new v(i.row,i.column,i.row,i.column-n+r)),e.start.column=e.end.column=s,e.start.row=e.end.row=i.row,e.cursor=e.end}),t.fromOrientedRange(e[0]),this.renderer.updateCursor(),this.renderer.updateBackMarkers()}else{var r=this.selection.getRange(),c=r.start.row,h=r.end.row,d=c==h;if(d){for(var u,g=this.session.getLength();u=this.session.getLine(h),/[=:]/.test(u)&&++h<g;);for(;u=this.session.getLine(c),/[=:]/.test(u)&&0<--c;);c<0&&(c=0),g<=h&&(h=g-1)}var p=this.session.removeFullLines(c,h);p=this.$reAlignText(p,d),this.session.insert({row:c,column:0},p.join("\n")+"\n"),d||(r.start.column=0,r.end.column=p[p.length-1].length),this.selection.setRange(r)}},this.$reAlignText=function(e,t){var i,n,r,o=!0,s=!0;return e.map(function(e){var t=e.match(/(\s*)(.*?)(\s*)([=:].*)/);return t?(null==i?(i=t[1].length,n=t[2].length,r=t[3].length):(i+n+r!=t[1].length+t[2].length+t[3].length&&(s=!1),i!=t[1].length&&(o=!1),i>t[1].length&&(i=t[1].length),n<t[2].length&&(n=t[2].length),r>t[3].length&&(r=t[3].length)),t):[e]}).map(t?l:o?s?function(e){return e[2]?a(i+n-e[2].length)+e[2]+a(r)+e[4].replace(/^([=:])\s+/,"$1 "):e[0]}:l:function(e){return e[2]?a(i)+e[2]+a(r)+e[4].replace(/^([=:])\s+/,"$1 "):e[0]});function a(e){return f.stringRepeat(" ",e)}function l(e){return e[2]?a(i)+e[2]+a(n-e[2].length+r)+e[4].replace(/^([=:])\s+/,"$1 "):e[0]}}}).call(c.prototype),t.onSessionChange=function(e){var t=e.session;t&&!t.multiSelect&&(t.$selectionMarkers=[],t.selection.$initRangeList(),t.multiSelect=t.selection),this.multiSelect=t&&t.multiSelect;var i=e.oldSession;i&&(i.multiSelect.off("addRange",this.$onAddRange),i.multiSelect.off("removeRange",this.$onRemoveRange),i.multiSelect.off("multiSelect",this.$onMultiSelect),i.multiSelect.off("singleSelect",this.$onSingleSelect),i.multiSelect.lead.off("change",this.$checkMultiselectChange),i.multiSelect.anchor.off("change",this.$checkMultiselectChange)),t&&(t.multiSelect.on("addRange",this.$onAddRange),t.multiSelect.on("removeRange",this.$onRemoveRange),t.multiSelect.on("multiSelect",this.$onMultiSelect),t.multiSelect.on("singleSelect",this.$onSingleSelect),t.multiSelect.lead.on("change",this.$checkMultiselectChange),t.multiSelect.anchor.on("change",this.$checkMultiselectChange)),t&&this.inMultiSelectMode!=t.selection.inMultiSelectMode&&(t.selection.inMultiSelectMode?this.$onMultiSelect():this.$onSingleSelect())},t.MultiSelect=h,e("./config").defineOptions(c.prototype,"editor",{enableMultiselect:{set:function(e){h(this),e?(this.on("changeSession",this.$multiselectOnSessionChange),this.on("mousedown",r)):(this.off("changeSession",this.$multiselectOnSessionChange),this.off("mousedown",r))},value:!0},enableBlockSelect:{set:function(e){this.$blockSelectEnabled=e},value:!0}})}),ace.define("ace/mode/folding/fold_mode",["require","exports","module","ace/range"],function(e,t,i){"use strict";var g=e("../../range").Range,n=t.FoldMode=function(){};(function(){this.foldingStartMarker=null,this.foldingStopMarker=null,this.getFoldWidget=function(e,t,i){var n=e.getLine(i);return this.foldingStartMarker.test(n)?"start":"markbeginend"==t&&this.foldingStopMarker&&this.foldingStopMarker.test(n)?"end":""},this.getFoldWidgetRange=function(e,t,i){return null},this.indentationBlock=function(e,t,i){var n=/\S/,r=e.getLine(t),o=r.search(n);if(-1!=o){for(var s=i||r.length,a=e.getLength(),l=t,c=t;++t<a;){var h=e.getLine(t).search(n);if(-1!=h){if(h<=o){var d=e.getTokenAt(t,0);if(!d||"string"!==d.type)break}c=t}}if(l<c){var u=e.getLine(c).length;return new g(l,s,c,u)}}},this.openingBracketBlock=function(e,t,i,n,r){var o={row:i,column:n+1},s=e.$findClosingBracket(t,o,r);if(s){var a=e.foldWidgets[s.row];return null==a&&(a=e.getFoldWidget(s.row)),"start"==a&&s.row>o.row&&(s.row--,s.column=e.getLine(s.row).length),g.fromPoints(o,s)}},this.closingBracketBlock=function(e,t,i,n,r){var o={row:i,column:n},s=e.$findOpeningBracket(t,o);if(s)return s.column++,o.column--,g.fromPoints(s,o)}}).call(n.prototype)}),ace.define("ace/theme/textmate",["require","exports","module","ace/lib/dom"],function(e,t,i){"use strict";t.isDark=!1,t.cssClass="ace-tm",t.cssText='.ace-tm .ace_gutter {background: #f0f0f0;color: #333;}.ace-tm .ace_print-margin {width: 1px;background: #e8e8e8;}.ace-tm .ace_fold {background-color: #6B72E6;}.ace-tm {background-color: #FFFFFF;color: black;}.ace-tm .ace_cursor {color: black;}.ace-tm .ace_invisible {color: rgb(191, 191, 191);}.ace-tm .ace_storage,.ace-tm .ace_keyword {color: blue;}.ace-tm .ace_constant {color: rgb(197, 6, 11);}.ace-tm .ace_constant.ace_buildin {color: rgb(88, 72, 246);}.ace-tm .ace_constant.ace_language {color: rgb(88, 92, 246);}.ace-tm .ace_constant.ace_library {color: rgb(6, 150, 14);}.ace-tm .ace_invalid {background-color: rgba(255, 0, 0, 0.1);color: red;}.ace-tm .ace_support.ace_function {color: rgb(60, 76, 114);}.ace-tm .ace_support.ace_constant {color: rgb(6, 150, 14);}.ace-tm .ace_support.ace_type,.ace-tm .ace_support.ace_class {color: rgb(109, 121, 222);}.ace-tm .ace_keyword.ace_operator {color: rgb(104, 118, 135);}.ace-tm .ace_string {color: rgb(3, 106, 7);}.ace-tm .ace_comment {color: rgb(76, 136, 107);}.ace-tm .ace_comment.ace_doc {color: rgb(0, 102, 255);}.ace-tm .ace_comment.ace_doc.ace_tag {color: rgb(128, 159, 191);}.ace-tm .ace_constant.ace_numeric {color: rgb(0, 0, 205);}.ace-tm .ace_variable {color: rgb(49, 132, 149);}.ace-tm .ace_xml-pe {color: rgb(104, 104, 91);}.ace-tm .ace_entity.ace_name.ace_function {color: #0000A2;}.ace-tm .ace_heading {color: rgb(12, 7, 255);}.ace-tm .ace_list {color:rgb(185, 6, 144);}.ace-tm .ace_meta.ace_tag {color:rgb(0, 22, 142);}.ace-tm .ace_string.ace_regex {color: rgb(255, 0, 0)}.ace-tm .ace_marker-layer .ace_selection {background: rgb(181, 213, 255);}.ace-tm.ace_multiselect .ace_selection.ace_start {box-shadow: 0 0 3px 0px white;}.ace-tm .ace_marker-layer .ace_step {background: rgb(252, 255, 0);}.ace-tm .ace_marker-layer .ace_stack {background: rgb(164, 229, 101);}.ace-tm .ace_marker-layer .ace_bracket {margin: -1px 0 0 -1px;border: 1px solid rgb(192, 192, 192);}.ace-tm .ace_marker-layer .ace_active-line {background: rgba(0, 0, 0, 0.07);}.ace-tm .ace_gutter-active-line {background-color : #dcdcdc;}.ace-tm .ace_marker-layer .ace_selected-word {background: rgb(250, 250, 255);border: 1px solid rgb(200, 200, 250);}.ace-tm .ace_indent-guide {background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y;}',t.$id="ace/theme/textmate",e("../lib/dom").importCssString(t.cssText,t.cssClass)}),ace.define("ace/line_widgets",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/range"],function(e,t,i){"use strict";e("./lib/oop");var o=e("./lib/dom");e("./range").Range;function n(e){this.session=e,(this.session.widgetManager=this).session.getRowLength=this.getRowLength,this.session.$getWidgetScreenLength=this.$getWidgetScreenLength,this.updateOnChange=this.updateOnChange.bind(this),this.renderWidgets=this.renderWidgets.bind(this),this.measureWidgets=this.measureWidgets.bind(this),this.session._changedWidgets=[],this.$onChangeEditor=this.$onChangeEditor.bind(this),this.session.on("change",this.updateOnChange),this.session.on("changeFold",this.updateOnFold),this.session.on("changeEditor",this.$onChangeEditor)}(function(){this.getRowLength=function(e){var t;return t=this.lineWidgets&&this.lineWidgets[e]&&this.lineWidgets[e].rowCount||0,this.$useWrapMode&&this.$wrapData[e]?this.$wrapData[e].length+1+t:1+t},this.$getWidgetScreenLength=function(){var t=0;return this.lineWidgets.forEach(function(e){e&&e.rowCount&&!e.hidden&&(t+=e.rowCount)}),t},this.$onChangeEditor=function(e){this.attach(e.editor)},this.attach=function(e){e&&e.widgetManager&&e.widgetManager!=this&&e.widgetManager.detach(),this.editor!=e&&(this.detach(),(this.editor=e)&&(e.widgetManager=this,e.renderer.on("beforeRender",this.measureWidgets),e.renderer.on("afterRender",this.renderWidgets)))},this.detach=function(e){var t=this.editor;if(t){this.editor=null,t.widgetManager=null,t.renderer.off("beforeRender",this.measureWidgets),t.renderer.off("afterRender",this.renderWidgets);var i=this.session.lineWidgets;i&&i.forEach(function(e){e&&e.el&&e.el.parentNode&&(e._inDocument=!1,e.el.parentNode.removeChild(e.el))})}},this.updateOnFold=function(e,t){var i=t.lineWidgets;if(i&&e.action){for(var n=e.data,r=n.start.row,o=n.end.row,s="add"==e.action,a=r+1;a<o;a++)i[a]&&(i[a].hidden=s);i[o]&&(s?i[r]?i[o].hidden=s:i[r]=i[o]:(i[r]==i[o]&&(i[r]=void 0),i[o].hidden=s))}},this.updateOnChange=function(e){var t=this.session.lineWidgets;if(t){var i=e.start.row,n=e.end.row-i;if(0==n);else if("remove"==e.action){t.splice(i+1,n).forEach(function(e){e&&this.removeLineWidget(e)},this),this.$updateRows()}else{var r=new Array(n);r.unshift(i,0),t.splice.apply(t,r),this.$updateRows()}}},this.$updateRows=function(){var e=this.session.lineWidgets;if(e){var i=!0;e.forEach(function(e,t){if(e)for(i=!1,e.row=t;e.$oldWidget;)e.$oldWidget.row=t,e=e.$oldWidget}),i&&(this.session.lineWidgets=null)}},this.addLineWidget=function(e){this.session.lineWidgets||(this.session.lineWidgets=new Array(this.session.getLength()));var t=this.session.lineWidgets[e.row];t&&(e.$oldWidget=t).el&&t.el.parentNode&&(t.el.parentNode.removeChild(t.el),t._inDocument=!1),(this.session.lineWidgets[e.row]=e).session=this.session;var i=this.editor.renderer;e.html&&!e.el&&(e.el=o.createElement("div"),e.el.innerHTML=e.html),e.el&&(o.addCssClass(e.el,"ace_lineWidgetContainer"),e.el.style.position="absolute",e.el.style.zIndex=5,i.container.appendChild(e.el),e._inDocument=!0),e.coverGutter||(e.el.style.zIndex=3),null==e.pixelHeight&&(e.pixelHeight=e.el.offsetHeight),null==e.rowCount&&(e.rowCount=e.pixelHeight/i.layerConfig.lineHeight);var n=this.session.getFoldAt(e.row,0);if(e.$fold=n){var r=this.session.lineWidgets;e.row!=n.end.row||r[n.start.row]?e.hidden=!0:r[n.start.row]=e}return this.session._emit("changeFold",{data:{start:{row:e.row}}}),this.$updateRows(),this.renderWidgets(null,i),this.onWidgetChanged(e),e},this.removeLineWidget=function(e){if(e._inDocument=!1,e.session=null,e.el&&e.el.parentNode&&e.el.parentNode.removeChild(e.el),e.editor&&e.editor.destroy)try{e.editor.destroy()}catch(e){}if(this.session.lineWidgets){var t=this.session.lineWidgets[e.row];if(t==e)this.session.lineWidgets[e.row]=e.$oldWidget,e.$oldWidget&&this.onWidgetChanged(e.$oldWidget);else for(;t;){if(t.$oldWidget==e){t.$oldWidget=e.$oldWidget;break}t=t.$oldWidget}}this.session._emit("changeFold",{data:{start:{row:e.row}}}),this.$updateRows()},this.getWidgetsAtRow=function(e){for(var t=this.session.lineWidgets,i=t&&t[e],n=[];i;)n.push(i),i=i.$oldWidget;return n},this.onWidgetChanged=function(e){this.session._changedWidgets.push(e),this.editor&&this.editor.renderer.updateFull()},this.measureWidgets=function(e,t){var i=this.session._changedWidgets,n=t.layerConfig;if(i&&i.length){for(var r=1/0,o=0;o<i.length;o++){var s=i[o];if(s&&s.el&&s.session==this.session){if(!s._inDocument){if(this.session.lineWidgets[s.row]!=s)continue;s._inDocument=!0,t.container.appendChild(s.el)}s.h=s.el.offsetHeight,s.fixedWidth||(s.w=s.el.offsetWidth,s.screenWidth=Math.ceil(s.w/n.characterWidth));var a=s.h/n.lineHeight;s.coverLine&&(a-=this.session.getRowLineCount(s.row))<0&&(a=0),s.rowCount!=a&&(s.rowCount=a,s.row<r&&(r=s.row))}}r!=1/0&&(this.session._emit("changeFold",{data:{start:{row:r}}}),this.session.lineWidgetWidth=null),this.session._changedWidgets=[]}},this.renderWidgets=function(e,t){var i=t.layerConfig,n=this.session.lineWidgets;if(n){for(var r=Math.min(this.firstRow,i.firstRow),o=Math.max(this.lastRow,i.lastRow,n.length);0<r&&!n[r];)r--;this.firstRow=i.firstRow,this.lastRow=i.lastRow,t.$cursorLayer.config=i;for(var s=r;s<=o;s++){var a=n[s];if(a&&a.el)if(a.hidden)a.el.style.top=-100-(a.pixelHeight||0)+"px";else{a._inDocument||(a._inDocument=!0,t.container.appendChild(a.el));var l=t.$cursorLayer.getPixelPosition({row:s,column:0},!0).top;a.coverLine||(l+=i.lineHeight*this.session.getRowLineCount(a.row)),a.el.style.top=l-i.offset+"px";var c=a.coverGutter?0:t.gutterWidth;a.fixedWidth||(c-=t.scrollLeft),a.el.style.left=c+"px",a.fullWidth&&a.screenWidth&&(a.el.style.minWidth=i.width+2*i.padding+"px"),a.fixedWidth?a.el.style.right=t.scrollBar.getWidth()+"px":a.el.style.right=""}}}}}).call(n.prototype),t.LineWidgets=n}),ace.define("ace/ext/error_marker",["require","exports","module","ace/line_widgets","ace/lib/dom","ace/range"],function(e,t,i){"use strict";var p=e("../line_widgets").LineWidgets,m=e("../lib/dom"),a=e("../range").Range;function f(e,t,i){var n=e.getAnnotations().sort(a.comparePoints);if(n.length){var r=function(e,t,i){for(var n=0,r=e.length-1;n<=r;){var o=n+r>>1,s=i(t,e[o]);if(0<s)n=1+o;else{if(!(s<0))return o;r=o-1}}return-(n+1)}(n,{row:t,column:-1},a.comparePoints);r<0&&(r=-r-1),r>=n.length?r=0<i?0:n.length-1:0===r&&i<0&&(r=n.length-1);var o=n[r];if(o&&i){if(o.row===t){for(;(o=n[r+=i])&&o.row===t;);if(!o)return n.slice()}var s=[];for(t=o.row;s[i<0?"unshift":"push"](o),(o=n[r+=i])&&o.row==t;);return s.length&&s}}}t.showErrorMarker=function(e,t){var i=e.session;i.widgetManager||(i.widgetManager=new p(i),i.widgetManager.attach(e));var n=e.getCursorPosition(),r=n.row,o=i.widgetManager.getWidgetsAtRow(r).filter(function(e){return"errorMarker"==e.type})[0];o?o.destroy():r-=t;var s,a=f(i,r,t);if(a){var l=a[0];n.column=(l.pos&&"number"!=typeof l.column?l.pos.sc:l.column)||0,n.row=l.row,s=e.renderer.$gutterLayer.$annotations[n.row]}else{if(o)return;s={text:["Looks good!"],className:"ace_ok"}}e.session.unfold(n.row),e.selection.moveToPosition(n);var c={row:n.row,fixedWidth:!0,coverGutter:!0,el:m.createElement("div"),type:"errorMarker"},h=c.el.appendChild(m.createElement("div")),d=c.el.appendChild(m.createElement("div"));d.className="error_widget_arrow "+s.className;var u=e.renderer.$cursorLayer.getPixelPosition(n).left;d.style.left=u+e.renderer.gutterWidth-5+"px",c.el.className="error_widget_wrapper",h.className="error_widget "+s.className,h.innerHTML=s.text.join("<br>"),h.appendChild(m.createElement("div"));function g(e,t,i){if(0===t&&("esc"===i||"return"===i))return c.destroy(),{command:"null"}}c.destroy=function(){e.$mouseHandler.isMousePressed||(e.keyBinding.removeKeyboardHandler(g),i.widgetManager.removeLineWidget(c),e.off("changeSelection",c.destroy),e.off("changeSession",c.destroy),e.off("mouseup",c.destroy),e.off("change",c.destroy))},e.keyBinding.addKeyboardHandler(g),e.on("changeSelection",c.destroy),e.on("changeSession",c.destroy),e.on("mouseup",c.destroy),e.on("change",c.destroy),e.session.widgetManager.addLineWidget(c),c.el.onmousedown=e.focus.bind(e),e.renderer.scrollCursorIntoView(null,.5,{bottom:c.el.offsetHeight})},m.importCssString("    .error_widget_wrapper {        background: inherit;        color: inherit;        border:none    }    .error_widget {        border-top: solid 2px;        border-bottom: solid 2px;        margin: 5px 0;        padding: 10px 40px;        white-space: pre-wrap;    }    .error_widget.ace_error, .error_widget_arrow.ace_error{        border-color: #ff5a5a    }    .error_widget.ace_warning, .error_widget_arrow.ace_warning{        border-color: #F1D817    }    .error_widget.ace_info, .error_widget_arrow.ace_info{        border-color: #5a5a5a    }    .error_widget.ace_ok, .error_widget_arrow.ace_ok{        border-color: #5aaa5a    }    .error_widget_arrow {        position: absolute;        border: solid 5px;        border-top-color: transparent!important;        border-right-color: transparent!important;        border-left-color: transparent!important;        top: -5px;    }","")}),ace.define("ace/ace",["require","exports","module","ace/lib/fixoldbrowsers","ace/lib/dom","ace/lib/event","ace/range","ace/editor","ace/edit_session","ace/undomanager","ace/virtual_renderer","ace/worker/worker_client","ace/keyboard/hash_handler","ace/placeholder","ace/multi_select","ace/mode/folding/fold_mode","ace/theme/textmate","ace/ext/error_marker","ace/config"],function(e,l,t){"use strict";e("./lib/fixoldbrowsers");var c=e("./lib/dom"),h=e("./lib/event"),i=e("./range").Range,d=e("./editor").Editor,n=e("./edit_session").EditSession,r=e("./undomanager").UndoManager,u=e("./virtual_renderer").VirtualRenderer;e("./worker/worker_client"),e("./keyboard/hash_handler"),e("./placeholder"),e("./multi_select"),e("./mode/folding/fold_mode"),e("./theme/textmate"),e("./ext/error_marker"),l.config=e("./config"),l.require=e,l.define=A(22),l.edit=function(e,t){if("string"==typeof e){var i=e;if(!(e=document.getElementById(i)))throw new Error("ace.edit can't find div #"+i)}if(e&&e.env&&e.env.editor instanceof d)return e.env.editor;var n="";if(e&&/input|textarea/i.test(e.tagName)){var r=e;n=r.value,e=c.createElement("pre"),r.parentNode.replaceChild(e,r)}else e&&(n=e.textContent,e.innerHTML="");var o=l.createEditSession(n),s=new d(new u(e),o,t),a={document:o,editor:s,onResize:s.resize.bind(s,null)};return r&&(a.textarea=r),h.addListener(window,"resize",a.onResize),s.on("destroy",function(){h.removeListener(window,"resize",a.onResize),a.editor.container.env=null}),s.container.env=s.env=a,s},l.createEditSession=function(e,t){var i=new n(e,t);return i.setUndoManager(new r),i},l.Range=i,l.Editor=d,l.EditSession=n,l.UndoManager=r,l.VirtualRenderer=u,l.version=l.config.version}),ace.require(["ace/ace"],function(e){for(var t in e&&(e.config.init(!0),e.define=ace.define),window.ace||(window.ace=e),e)e.hasOwnProperty(t)&&(window.ace[t]=e[t]);window.ace.default=window.ace,i&&(i.exports=window.ace)})}).call(this,A(15)(e))},function(e,t,i){(function(t){ace.define("ace/mode/json_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(e,t,i){"use strict";function n(){this.$rules={start:[{token:"variable",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]\\s*(?=:)'},{token:"string",regex:'"',next:"string"},{token:"constant.numeric",regex:"0[xX][0-9a-fA-F]+\\b"},{token:"constant.numeric",regex:"[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"},{token:"constant.language.boolean",regex:"(?:true|false)\\b"},{token:"text",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},{token:"comment",regex:"\\/\\/.*$"},{token:"comment.start",regex:"\\/\\*",next:"comment"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{token:"text",regex:"\\s+"}],string:[{token:"constant.language.escape",regex:/\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|["\\\/bfnrt])/},{token:"string",regex:'"|$',next:"start"},{defaultToken:"string"}],comment:[{token:"comment.end",regex:"\\*\\/",next:"start"},{defaultToken:"comment"}]}}var r=e("../lib/oop"),o=e("./text_highlight_rules").TextHighlightRules;r.inherits(n,o),t.JsonHighlightRules=n}),ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(e,t,i){"use strict";function n(){}var s=e("../range").Range;(function(){this.checkOutdent=function(e,t){return!!/^\s+$/.test(e)&&/^\s*\}/.test(t)},this.autoOutdent=function(e,t){var i=e.getLine(t).match(/^(\s*\})/);if(!i)return 0;var n=i[1].length,r=e.findMatchingBracket({row:t,column:n});if(!r||r.row==t)return 0;var o=this.$getIndent(e.getLine(r.row));e.replace(new s(t,0,t,n-1),o)},this.$getIndent=function(e){return e.match(/^\s*/)[0]}}).call(n.prototype),t.MatchingBraceOutdent=n}),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(e,t,i){"use strict";var n=e("../../lib/oop"),h=e("../../range").Range,r=e("./fold_mode").FoldMode,o=t.FoldMode=function(e){e&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+e.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+e.end)))};n.inherits(o,r),function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/,this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/,this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/,this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/,this._getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(e,t,i){var n=e.getLine(i);if(this.singleLineBlockCommentRe.test(n)&&!this.startRegionRe.test(n)&&!this.tripleStarBlockCommentRe.test(n))return"";var r=this._getFoldWidgetBase(e,t,i);return!r&&this.startRegionRe.test(n)?"start":r},this.getFoldWidgetRange=function(e,t,i,n){var r,o=e.getLine(i);if(this.startRegionRe.test(o))return this.getCommentRegionBlock(e,o,i);if(r=o.match(this.foldingStartMarker)){var s=r.index;if(r[1])return this.openingBracketBlock(e,r[1],i,s);var a=e.getCommentFoldRange(i,s+r[0].length,1);return a&&!a.isMultiLine()&&(n?a=this.getSectionRange(e,i):"all"!=t&&(a=null)),a}if("markbegin"!==t&&(r=o.match(this.foldingStopMarker))){s=r.index+r[0].length;return r[1]?this.closingBracketBlock(e,r[1],i,s):e.getCommentFoldRange(i,s,-1)}},this.getSectionRange=function(e,t){for(var i=e.getLine(t),n=i.search(/\S/),r=t,o=i.length,s=t+=1,a=e.getLength();++t<a;){var l=(i=e.getLine(t)).search(/\S/);if(-1!==l){if(l<n)break;var c=this.getFoldWidgetRange(e,"all",t);if(c){if(c.start.row<=r)break;if(c.isMultiLine())t=c.end.row;else if(n==l)break}s=t}}return new h(r,o,s,e.getLine(s).length)},this.getCommentRegionBlock=function(e,t,i){for(var n=t.search(/\s*$/),r=e.getLength(),o=i,s=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,a=1;++i<r;){t=e.getLine(i);var l=s.exec(t);if(l&&(l[1]?a--:a++,!a))break}if(o<i)return new h(o,n,i,t.length)}}.call(o.prototype)}),ace.define("ace/mode/json",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/json_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle","ace/worker/worker_client"],function(e,t,i){"use strict";function n(){this.HighlightRules=s,this.$outdent=new a,this.$behaviour=new l,this.foldingRules=new c}var r=e("../lib/oop"),o=e("./text").Mode,s=e("./json_highlight_rules").JsonHighlightRules,a=e("./matching_brace_outdent").MatchingBraceOutdent,l=e("./behaviour/cstyle").CstyleBehaviour,c=e("./folding/cstyle").FoldMode,h=e("../worker/worker_client").WorkerClient;r.inherits(n,o),function(){this.getNextLineIndent=function(e,t,i){var n=this.$getIndent(t);"start"==e&&t.match(/^.*[\{\(\[]\s*$/)&&(n+=i);return n},this.checkOutdent=function(e,t,i){return this.$outdent.checkOutdent(t,i)},this.autoOutdent=function(e,t,i){this.$outdent.autoOutdent(t,i)},this.createWorker=function(t){var e=new h(["ace"],"ace/mode/json_worker","JsonWorker");return e.attachToDocument(t.getDocument()),e.on("annotate",function(e){t.setAnnotations(e.data)}),e.on("terminate",function(){t.clearAnnotations()}),e},this.$id="ace/mode/json"}.call(n.prototype),t.Mode=n}),ace.require(["ace/mode/json"],function(e){t&&(t.exports=e)})}).call(this,i(15)(e))},function(e,t,i){(function(t){ace.define("ace/ext/searchbox",["require","exports","module","ace/lib/dom","ace/lib/lang","ace/lib/event","ace/keyboard/hash_handler","ace/lib/keys"],function(e,t,i){"use strict";var r=e("../lib/dom"),n=e("../lib/lang"),s=e("../lib/event"),o='.ace_search {background-color: #ddd;color: #666;border: 1px solid #cbcbcb;border-top: 0 none;overflow: hidden;margin: 0;padding: 4px 6px 0 4px;position: absolute;top: 0;z-index: 99;white-space: normal;}.ace_search.left {border-left: 0 none;border-radius: 0px 0px 5px 0px;left: 0;}.ace_search.right {border-radius: 0px 0px 0px 5px;border-right: 0 none;right: 0;}.ace_search_form, .ace_replace_form {margin: 0 20px 4px 0;overflow: hidden;line-height: 1.9;}.ace_replace_form {margin-right: 0;}.ace_search_form.ace_nomatch {outline: 1px solid red;}.ace_search_field {border-radius: 3px 0 0 3px;background-color: white;color: black;border: 1px solid #cbcbcb;border-right: 0 none;outline: 0;padding: 0;font-size: inherit;margin: 0;line-height: inherit;padding: 0 6px;min-width: 17em;vertical-align: top;min-height: 1.8em;box-sizing: content-box;}.ace_searchbtn {border: 1px solid #cbcbcb;line-height: inherit;display: inline-block;padding: 0 6px;background: #fff;border-right: 0 none;border-left: 1px solid #dcdcdc;cursor: pointer;margin: 0;position: relative;color: #666;}.ace_searchbtn:last-child {border-radius: 0 3px 3px 0;border-right: 1px solid #cbcbcb;}.ace_searchbtn:disabled {background: none;cursor: default;}.ace_searchbtn:hover {background-color: #eef1f6;}.ace_searchbtn.prev, .ace_searchbtn.next {padding: 0px 0.7em}.ace_searchbtn.prev:after, .ace_searchbtn.next:after {content: "";border: solid 2px #888;width: 0.5em;height: 0.5em;border-width:  2px 0 0 2px;display:inline-block;transform: rotate(-45deg);}.ace_searchbtn.next:after {border-width: 0 2px 2px 0 ;}.ace_searchbtn_close {background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAcCAYAAABRVo5BAAAAZ0lEQVR42u2SUQrAMAhDvazn8OjZBilCkYVVxiis8H4CT0VrAJb4WHT3C5xU2a2IQZXJjiQIRMdkEoJ5Q2yMqpfDIo+XY4k6h+YXOyKqTIj5REaxloNAd0xiKmAtsTHqW8sR2W5f7gCu5nWFUpVjZwAAAABJRU5ErkJggg==) no-repeat 50% 0;border-radius: 50%;border: 0 none;color: #656565;cursor: pointer;font: 16px/16px Arial;padding: 0;height: 14px;width: 14px;top: 9px;right: 7px;position: absolute;}.ace_searchbtn_close:hover {background-color: #656565;background-position: 50% 100%;color: white;}.ace_button {margin-left: 2px;cursor: pointer;-webkit-user-select: none;-moz-user-select: none;-o-user-select: none;-ms-user-select: none;user-select: none;overflow: hidden;opacity: 0.7;border: 1px solid rgba(100,100,100,0.23);padding: 1px;box-sizing:    border-box!important;color: black;}.ace_button:hover {background-color: #eee;opacity:1;}.ace_button:active {background-color: #ddd;}.ace_button.checked {border-color: #3399ff;opacity:1;}.ace_search_options{margin-bottom: 3px;text-align: right;-webkit-user-select: none;-moz-user-select: none;-o-user-select: none;-ms-user-select: none;user-select: none;clear: both;}.ace_search_counter {float: left;font-family: arial;padding: 0 8px;}',a=e("../keyboard/hash_handler").HashHandler,l=e("../lib/keys");r.importCssString(o,"ace_searchbox");function c(e,t,i){var n=r.createElement("div");r.buildDom(["div",{class:"ace_search right"},["span",{action:"hide",class:"ace_searchbtn_close"}],["div",{class:"ace_search_form"},["input",{class:"ace_search_field",placeholder:"Search for",spellcheck:"false"}],["span",{action:"findPrev",class:"ace_searchbtn prev"},"​"],["span",{action:"findNext",class:"ace_searchbtn next"},"​"],["span",{action:"findAll",class:"ace_searchbtn",title:"Alt-Enter"},"All"]],["div",{class:"ace_replace_form"},["input",{class:"ace_search_field",placeholder:"Replace with",spellcheck:"false"}],["span",{action:"replaceAndFindNext",class:"ace_searchbtn"},"Replace"],["span",{action:"replaceAll",class:"ace_searchbtn"},"All"]],["div",{class:"ace_search_options"},["span",{action:"toggleReplace",class:"ace_button",title:"Toggle Replace mode",style:"float:left;margin-top:-2px;padding:0 5px;"},"+"],["span",{class:"ace_search_counter"}],["span",{action:"toggleRegexpMode",class:"ace_button",title:"RegExp Search"},".*"],["span",{action:"toggleCaseSensitive",class:"ace_button",title:"CaseSensitive Search"},"Aa"],["span",{action:"toggleWholeWords",class:"ace_button",title:"Whole Word Search"},"\\b"],["span",{action:"searchInSelection",class:"ace_button",title:"Search In Selection"},"S"]]],n),this.element=n.firstChild,this.setSession=this.setSession.bind(this),this.$init(),this.setEditor(e),r.importCssString(o,"ace_searchbox",e.container)}(function(){this.setEditor=function(e){e.searchBox=this,e.renderer.scroller.appendChild(this.element),this.editor=e},this.setSession=function(e){this.searchRange=null,this.$syncOptions(!0)},this.$initElements=function(e){this.searchBox=e.querySelector(".ace_search_form"),this.replaceBox=e.querySelector(".ace_replace_form"),this.searchOption=e.querySelector("[action=searchInSelection]"),this.replaceOption=e.querySelector("[action=toggleReplace]"),this.regExpOption=e.querySelector("[action=toggleRegexpMode]"),this.caseSensitiveOption=e.querySelector("[action=toggleCaseSensitive]"),this.wholeWordOption=e.querySelector("[action=toggleWholeWords]"),this.searchInput=this.searchBox.querySelector(".ace_search_field"),this.replaceInput=this.replaceBox.querySelector(".ace_search_field"),this.searchCounter=e.querySelector(".ace_search_counter")},this.$init=function(){var e=this.element;this.$initElements(e);var o=this;s.addListener(e,"mousedown",function(e){setTimeout(function(){o.activeInput.focus()},0),s.stopPropagation(e)}),s.addListener(e,"click",function(e){var t=(e.target||e.srcElement).getAttribute("action");t&&o[t]?o[t]():o.$searchBarKb.commands[t]&&o.$searchBarKb.commands[t].exec(o),s.stopPropagation(e)}),s.addCommandKeyListener(e,function(e,t,i){var n=l.keyCodeToString(i),r=o.$searchBarKb.findKeyCommand(t,n);r&&r.exec&&(r.exec(o),s.stopEvent(e))}),this.$onChange=n.delayedCall(function(){o.find(!1,!1)}),s.addListener(this.searchInput,"input",function(){o.$onChange.schedule(20)}),s.addListener(this.searchInput,"focus",function(){o.activeInput=o.searchInput,o.searchInput.value&&o.highlight()}),s.addListener(this.replaceInput,"focus",function(){o.activeInput=o.replaceInput,o.searchInput.value&&o.highlight()})},this.$closeSearchBarKb=new a([{bindKey:"Esc",name:"closeSearchBar",exec:function(e){e.searchBox.hide()}}]),this.$searchBarKb=new a,this.$searchBarKb.bindKeys({"Ctrl-f|Command-f":function(e){var t=e.isReplace=!e.isReplace;e.replaceBox.style.display=t?"":"none",e.replaceOption.checked=!1,e.$syncOptions(),e.searchInput.focus()},"Ctrl-H|Command-Option-F":function(e){e.editor.getReadOnly()||(e.replaceOption.checked=!0,e.$syncOptions(),e.replaceInput.focus())},"Ctrl-G|Command-G":function(e){e.findNext()},"Ctrl-Shift-G|Command-Shift-G":function(e){e.findPrev()},esc:function(e){setTimeout(function(){e.hide()})},Return:function(e){e.activeInput==e.replaceInput&&e.replace(),e.findNext()},"Shift-Return":function(e){e.activeInput==e.replaceInput&&e.replace(),e.findPrev()},"Alt-Return":function(e){e.activeInput==e.replaceInput&&e.replaceAll(),e.findAll()},Tab:function(e){(e.activeInput==e.replaceInput?e.searchInput:e.replaceInput).focus()}}),this.$searchBarKb.addCommands([{name:"toggleRegexpMode",bindKey:{win:"Alt-R|Alt-/",mac:"Ctrl-Alt-R|Ctrl-Alt-/"},exec:function(e){e.regExpOption.checked=!e.regExpOption.checked,e.$syncOptions()}},{name:"toggleCaseSensitive",bindKey:{win:"Alt-C|Alt-I",mac:"Ctrl-Alt-R|Ctrl-Alt-I"},exec:function(e){e.caseSensitiveOption.checked=!e.caseSensitiveOption.checked,e.$syncOptions()}},{name:"toggleWholeWords",bindKey:{win:"Alt-B|Alt-W",mac:"Ctrl-Alt-B|Ctrl-Alt-W"},exec:function(e){e.wholeWordOption.checked=!e.wholeWordOption.checked,e.$syncOptions()}},{name:"toggleReplace",exec:function(e){e.replaceOption.checked=!e.replaceOption.checked,e.$syncOptions()}},{name:"searchInSelection",exec:function(e){e.searchOption.checked=!e.searchRange,e.setSearchRange(e.searchOption.checked&&e.editor.getSelectionRange()),e.$syncOptions()}}]),this.setSearchRange=function(e){(this.searchRange=e)?this.searchRangeMarker=this.editor.session.addMarker(e,"ace_active-line"):this.searchRangeMarker&&(this.editor.session.removeMarker(this.searchRangeMarker),this.searchRangeMarker=null)},this.$syncOptions=function(e){r.setCssClass(this.replaceOption,"checked",this.searchRange),r.setCssClass(this.searchOption,"checked",this.searchOption.checked),this.replaceOption.textContent=this.replaceOption.checked?"-":"+",r.setCssClass(this.regExpOption,"checked",this.regExpOption.checked),r.setCssClass(this.wholeWordOption,"checked",this.wholeWordOption.checked),r.setCssClass(this.caseSensitiveOption,"checked",this.caseSensitiveOption.checked);var t=this.editor.getReadOnly();this.replaceOption.style.display=t?"none":"",this.replaceBox.style.display=this.replaceOption.checked&&!t?"":"none",this.find(!1,!1,e)},this.highlight=function(e){this.editor.session.highlight(e||this.editor.$search.$options.re),this.editor.renderer.updateBackMarkers()},this.find=function(e,t,i){var n=!this.editor.find(this.searchInput.value,{skipCurrent:e,backwards:t,wrap:!0,regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked,preventScroll:i,range:this.searchRange})&&this.searchInput.value;r.setCssClass(this.searchBox,"ace_nomatch",n),this.editor._emit("findSearchBox",{match:!n}),this.highlight(),this.updateCounter()},this.updateCounter=function(){var e=this.editor,t=e.$search.$options.re,i=0,n=0;if(t){var r=this.searchRange?e.session.getTextRange(this.searchRange):e.getValue(),o=e.session.doc.positionToIndex(e.selection.anchor);this.searchRange&&(o-=e.session.doc.positionToIndex(this.searchRange.start));for(var s,a=t.lastIndex=0;(s=t.exec(r))&&(i++,(a=s.index)<=o&&n++,!(999<i))&&(s[0]||(t.lastIndex=a+=1,!(a>=r.length))););}this.searchCounter.textContent=n+" of "+(999<i?"999+":i)},this.findNext=function(){this.find(!0,!1)},this.findPrev=function(){this.find(!0,!0)},this.findAll=function(){var e=!this.editor.findAll(this.searchInput.value,{regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked})&&this.searchInput.value;r.setCssClass(this.searchBox,"ace_nomatch",e),this.editor._emit("findSearchBox",{match:!e}),this.highlight(),this.hide()},this.replace=function(){this.editor.getReadOnly()||this.editor.replace(this.replaceInput.value)},this.replaceAndFindNext=function(){this.editor.getReadOnly()||(this.editor.replace(this.replaceInput.value),this.findNext())},this.replaceAll=function(){this.editor.getReadOnly()||this.editor.replaceAll(this.replaceInput.value)},this.hide=function(){this.active=!1,this.setSearchRange(null),this.editor.off("changeSession",this.setSession),this.element.style.display="none",this.editor.keyBinding.removeKeyboardHandler(this.$closeSearchBarKb),this.editor.focus()},this.show=function(e,t){this.active=!0,this.editor.on("changeSession",this.setSession),this.element.style.display="",this.replaceOption.checked=t,e&&(this.searchInput.value=e),this.searchInput.focus(),this.searchInput.select(),this.editor.keyBinding.addKeyboardHandler(this.$closeSearchBarKb),this.$syncOptions(!0)},this.isFocused=function(){var e=document.activeElement;return e==this.searchInput||e==this.replaceInput}}).call(c.prototype),t.SearchBox=c,t.Search=function(e,t){(e.searchBox||new c(e)).show(e.session.getTextRange(),t)}}),ace.require(["ace/ext/searchbox"],function(e){t&&(t.exports=e)})}).call(this,i(15)(e))},function(e,t){
e.exports="data:application/javascript;base64,Im5vIHVzZSBzdHJpY3QiOwohKGZ1bmN0aW9uKHdpbmRvdykgewppZiAodHlwZW9mIHdpbmRvdy53aW5kb3cgIT0gInVuZGVmaW5lZCIgJiYgd2luZG93LmRvY3VtZW50KQogICAgcmV0dXJuOwppZiAod2luZG93LnJlcXVpcmUgJiYgd2luZG93LmRlZmluZSkKICAgIHJldHVybjsKCmlmICghd2luZG93LmNvbnNvbGUpIHsKICAgIHdpbmRvdy5jb25zb2xlID0gZnVuY3Rpb24oKSB7CiAgICAgICAgdmFyIG1zZ3MgPSBBcnJheS5wcm90b3R5cGUuc2xpY2UuY2FsbChhcmd1bWVudHMsIDApOwogICAgICAgIHBvc3RNZXNzYWdlKHt0eXBlOiAibG9nIiwgZGF0YTogbXNnc30pOwogICAgfTsKICAgIHdpbmRvdy5jb25zb2xlLmVycm9yID0KICAgIHdpbmRvdy5jb25zb2xlLndhcm4gPSAKICAgIHdpbmRvdy5jb25zb2xlLmxvZyA9CiAgICB3aW5kb3cuY29uc29sZS50cmFjZSA9IHdpbmRvdy5jb25zb2xlOwp9CndpbmRvdy53aW5kb3cgPSB3aW5kb3c7CndpbmRvdy5hY2UgPSB3aW5kb3c7Cgp3aW5kb3cub25lcnJvciA9IGZ1bmN0aW9uKG1lc3NhZ2UsIGZpbGUsIGxpbmUsIGNvbCwgZXJyKSB7CiAgICBwb3N0TWVzc2FnZSh7dHlwZTogImVycm9yIiwgZGF0YTogewogICAgICAgIG1lc3NhZ2U6IG1lc3NhZ2UsCiAgICAgICAgZGF0YTogZXJyLmRhdGEsCiAgICAgICAgZmlsZTogZmlsZSwKICAgICAgICBsaW5lOiBsaW5lLCAKICAgICAgICBjb2w6IGNvbCwKICAgICAgICBzdGFjazogZXJyLnN0YWNrCiAgICB9fSk7Cn07Cgp3aW5kb3cubm9ybWFsaXplTW9kdWxlID0gZnVuY3Rpb24ocGFyZW50SWQsIG1vZHVsZU5hbWUpIHsKICAgIC8vIG5vcm1hbGl6ZSBwbHVnaW4gcmVxdWlyZXMKICAgIGlmIChtb2R1bGVOYW1lLmluZGV4T2YoIiEiKSAhPT0gLTEpIHsKICAgICAgICB2YXIgY2h1bmtzID0gbW9kdWxlTmFtZS5zcGxpdCgiISIpOwogICAgICAgIHJldHVybiB3aW5kb3cubm9ybWFsaXplTW9kdWxlKHBhcmVudElkLCBjaHVua3NbMF0pICsgIiEiICsgd2luZG93Lm5vcm1hbGl6ZU1vZHVsZShwYXJlbnRJZCwgY2h1bmtzWzFdKTsKICAgIH0KICAgIC8vIG5vcm1hbGl6ZSByZWxhdGl2ZSByZXF1aXJlcwogICAgaWYgKG1vZHVsZU5hbWUuY2hhckF0KDApID09ICIuIikgewogICAgICAgIHZhciBiYXNlID0gcGFyZW50SWQuc3BsaXQoIi8iKS5zbGljZSgwLCAtMSkuam9pbigiLyIpOwogICAgICAgIG1vZHVsZU5hbWUgPSAoYmFzZSA/IGJhc2UgKyAiLyIgOiAiIikgKyBtb2R1bGVOYW1lOwogICAgICAgIAogICAgICAgIHdoaWxlIChtb2R1bGVOYW1lLmluZGV4T2YoIi4iKSAhPT0gLTEgJiYgcHJldmlvdXMgIT0gbW9kdWxlTmFtZSkgewogICAgICAgICAgICB2YXIgcHJldmlvdXMgPSBtb2R1bGVOYW1lOwogICAgICAgICAgICBtb2R1bGVOYW1lID0gbW9kdWxlTmFtZS5yZXBsYWNlKC9eXC5cLy8sICIiKS5yZXBsYWNlKC9cL1wuXC8vLCAiLyIpLnJlcGxhY2UoL1teXC9dK1wvXC5cLlwvLywgIiIpOwogICAgICAgIH0KICAgIH0KICAgIAogICAgcmV0dXJuIG1vZHVsZU5hbWU7Cn07Cgp3aW5kb3cucmVxdWlyZSA9IGZ1bmN0aW9uIHJlcXVpcmUocGFyZW50SWQsIGlkKSB7CiAgICBpZiAoIWlkKSB7CiAgICAgICAgaWQgPSBwYXJlbnRJZDsKICAgICAgICBwYXJlbnRJZCA9IG51bGw7CiAgICB9CiAgICBpZiAoIWlkLmNoYXJBdCkKICAgICAgICB0aHJvdyBuZXcgRXJyb3IoIndvcmtlci5qcyByZXF1aXJlKCkgYWNjZXB0cyBvbmx5IChwYXJlbnRJZCwgaWQpIGFzIGFyZ3VtZW50cyIpOwoKICAgIGlkID0gd2luZG93Lm5vcm1hbGl6ZU1vZHVsZShwYXJlbnRJZCwgaWQpOwoKICAgIHZhciBtb2R1bGUgPSB3aW5kb3cucmVxdWlyZS5tb2R1bGVzW2lkXTsKICAgIGlmIChtb2R1bGUpIHsKICAgICAgICBpZiAoIW1vZHVsZS5pbml0aWFsaXplZCkgewogICAgICAgICAgICBtb2R1bGUuaW5pdGlhbGl6ZWQgPSB0cnVlOwogICAgICAgICAgICBtb2R1bGUuZXhwb3J0cyA9IG1vZHVsZS5mYWN0b3J5KCkuZXhwb3J0czsKICAgICAgICB9CiAgICAgICAgcmV0dXJuIG1vZHVsZS5leHBvcnRzOwogICAgfQogICAKICAgIGlmICghd2luZG93LnJlcXVpcmUudGxucykKICAgICAgICByZXR1cm4gY29uc29sZS5sb2coInVuYWJsZSB0byBsb2FkICIgKyBpZCk7CiAgICAKICAgIHZhciBwYXRoID0gcmVzb2x2ZU1vZHVsZUlkKGlkLCB3aW5kb3cucmVxdWlyZS50bG5zKTsKICAgIGlmIChwYXRoLnNsaWNlKC0zKSAhPSAiLmpzIikgcGF0aCArPSAiLmpzIjsKICAgIAogICAgd2luZG93LnJlcXVpcmUuaWQgPSBpZDsKICAgIHdpbmRvdy5yZXF1aXJlLm1vZHVsZXNbaWRdID0ge307IC8vIHByZXZlbnQgaW5maW5pdGUgbG9vcCBvbiBicm9rZW4gbW9kdWxlcwogICAgaW1wb3J0U2NyaXB0cyhwYXRoKTsKICAgIHJldHVybiB3aW5kb3cucmVxdWlyZShwYXJlbnRJZCwgaWQpOwp9OwpmdW5jdGlvbiByZXNvbHZlTW9kdWxlSWQoaWQsIHBhdGhzKSB7CiAgICB2YXIgdGVzdFBhdGggPSBpZCwgdGFpbCA9ICIiOwogICAgd2hpbGUgKHRlc3RQYXRoKSB7CiAgICAgICAgdmFyIGFsaWFzID0gcGF0aHNbdGVzdFBhdGhdOwogICAgICAgIGlmICh0eXBlb2YgYWxpYXMgPT0gInN0cmluZyIpIHsKICAgICAgICAgICAgcmV0dXJuIGFsaWFzICsgdGFpbDsKICAgICAgICB9IGVsc2UgaWYgKGFsaWFzKSB7CiAgICAgICAgICAgIHJldHVybiAgYWxpYXMubG9jYXRpb24ucmVwbGFjZSgvXC8qJC8sICIvIikgKyAodGFpbCB8fCBhbGlhcy5tYWluIHx8IGFsaWFzLm5hbWUpOwogICAgICAgIH0gZWxzZSBpZiAoYWxpYXMgPT09IGZhbHNlKSB7CiAgICAgICAgICAgIHJldHVybiAiIjsKICAgICAgICB9CiAgICAgICAgdmFyIGkgPSB0ZXN0UGF0aC5sYXN0SW5kZXhPZigiLyIpOwogICAgICAgIGlmIChpID09PSAtMSkgYnJlYWs7CiAgICAgICAgdGFpbCA9IHRlc3RQYXRoLnN1YnN0cihpKSArIHRhaWw7CiAgICAgICAgdGVzdFBhdGggPSB0ZXN0UGF0aC5zbGljZSgwLCBpKTsKICAgIH0KICAgIHJldHVybiBpZDsKfQp3aW5kb3cucmVxdWlyZS5tb2R1bGVzID0ge307CndpbmRvdy5yZXF1aXJlLnRsbnMgPSB7fTsKCndpbmRvdy5kZWZpbmUgPSBmdW5jdGlvbihpZCwgZGVwcywgZmFjdG9yeSkgewogICAgaWYgKGFyZ3VtZW50cy5sZW5ndGggPT0gMikgewogICAgICAgIGZhY3RvcnkgPSBkZXBzOwogICAgICAgIGlmICh0eXBlb2YgaWQgIT0gInN0cmluZyIpIHsKICAgICAgICAgICAgZGVwcyA9IGlkOwogICAgICAgICAgICBpZCA9IHdpbmRvdy5yZXF1aXJlLmlkOwogICAgICAgIH0KICAgIH0gZWxzZSBpZiAoYXJndW1lbnRzLmxlbmd0aCA9PSAxKSB7CiAgICAgICAgZmFjdG9yeSA9IGlkOwogICAgICAgIGRlcHMgPSBbXTsKICAgICAgICBpZCA9IHdpbmRvdy5yZXF1aXJlLmlkOwogICAgfQogICAgCiAgICBpZiAodHlwZW9mIGZhY3RvcnkgIT0gImZ1bmN0aW9uIikgewogICAgICAgIHdpbmRvdy5yZXF1aXJlLm1vZHVsZXNbaWRdID0gewogICAgICAgICAgICBleHBvcnRzOiBmYWN0b3J5LAogICAgICAgICAgICBpbml0aWFsaXplZDogdHJ1ZQogICAgICAgIH07CiAgICAgICAgcmV0dXJuOwogICAgfQoKICAgIGlmICghZGVwcy5sZW5ndGgpCiAgICAgICAgLy8gSWYgdGhlcmUgaXMgbm8gZGVwZW5kZW5jaWVzLCB3ZSBpbmplY3QgInJlcXVpcmUiLCAiZXhwb3J0cyIgYW5kCiAgICAgICAgLy8gIm1vZHVsZSIgYXMgZGVwZW5kZW5jaWVzLCB0byBwcm92aWRlIENvbW1vbkpTIGNvbXBhdGliaWxpdHkuCiAgICAgICAgZGVwcyA9IFsicmVxdWlyZSIsICJleHBvcnRzIiwgIm1vZHVsZSJdOwoKICAgIHZhciByZXEgPSBmdW5jdGlvbihjaGlsZElkKSB7CiAgICAgICAgcmV0dXJuIHdpbmRvdy5yZXF1aXJlKGlkLCBjaGlsZElkKTsKICAgIH07CgogICAgd2luZG93LnJlcXVpcmUubW9kdWxlc1tpZF0gPSB7CiAgICAgICAgZXhwb3J0czoge30sCiAgICAgICAgZmFjdG9yeTogZnVuY3Rpb24oKSB7CiAgICAgICAgICAgIHZhciBtb2R1bGUgPSB0aGlzOwogICAgICAgICAgICB2YXIgcmV0dXJuRXhwb3J0cyA9IGZhY3RvcnkuYXBwbHkodGhpcywgZGVwcy5zbGljZSgwLCBmYWN0b3J5Lmxlbmd0aCkubWFwKGZ1bmN0aW9uKGRlcCkgewogICAgICAgICAgICAgICAgc3dpdGNoIChkZXApIHsKICAgICAgICAgICAgICAgICAgICAvLyBCZWNhdXNlICJyZXF1aXJlIiwgImV4cG9ydHMiIGFuZCAibW9kdWxlIiBhcmVuJ3QgYWN0dWFsCiAgICAgICAgICAgICAgICAgICAgLy8gZGVwZW5kZW5jaWVzLCB3ZSBtdXN0IGhhbmRsZSB0aGVtIHNlcGVyYXRlbHkuCiAgICAgICAgICAgICAgICAgICAgY2FzZSAicmVxdWlyZSI6IHJldHVybiByZXE7CiAgICAgICAgICAgICAgICAgICAgY2FzZSAiZXhwb3J0cyI6IHJldHVybiBtb2R1bGUuZXhwb3J0czsKICAgICAgICAgICAgICAgICAgICBjYXNlICJtb2R1bGUiOiAgcmV0dXJuIG1vZHVsZTsKICAgICAgICAgICAgICAgICAgICAvLyBCdXQgZm9yIGFsbCBvdGhlciBkZXBlbmRlbmNpZXMsIHdlIGNhbiBqdXN0IGdvIGFoZWFkIGFuZAogICAgICAgICAgICAgICAgICAgIC8vIHJlcXVpcmUgdGhlbS4KICAgICAgICAgICAgICAgICAgICBkZWZhdWx0OiAgICAgICAgcmV0dXJuIHJlcShkZXApOwogICAgICAgICAgICAgICAgfQogICAgICAgICAgICB9KSk7CiAgICAgICAgICAgIGlmIChyZXR1cm5FeHBvcnRzKQogICAgICAgICAgICAgICAgbW9kdWxlLmV4cG9ydHMgPSByZXR1cm5FeHBvcnRzOwogICAgICAgICAgICByZXR1cm4gbW9kdWxlOwogICAgICAgIH0KICAgIH07Cn07CndpbmRvdy5kZWZpbmUuYW1kID0ge307CnJlcXVpcmUudGxucyA9IHt9Owp3aW5kb3cuaW5pdEJhc2VVcmxzICA9IGZ1bmN0aW9uIGluaXRCYXNlVXJscyh0b3BMZXZlbE5hbWVzcGFjZXMpIHsKICAgIGZvciAodmFyIGkgaW4gdG9wTGV2ZWxOYW1lc3BhY2VzKQogICAgICAgIHJlcXVpcmUudGxuc1tpXSA9IHRvcExldmVsTmFtZXNwYWNlc1tpXTsKfTsKCndpbmRvdy5pbml0U2VuZGVyID0gZnVuY3Rpb24gaW5pdFNlbmRlcigpIHsKCiAgICB2YXIgRXZlbnRFbWl0dGVyID0gd2luZG93LnJlcXVpcmUoImFjZS9saWIvZXZlbnRfZW1pdHRlciIpLkV2ZW50RW1pdHRlcjsKICAgIHZhciBvb3AgPSB3aW5kb3cucmVxdWlyZSgiYWNlL2xpYi9vb3AiKTsKICAgIAogICAgdmFyIFNlbmRlciA9IGZ1bmN0aW9uKCkge307CiAgICAKICAgIChmdW5jdGlvbigpIHsKICAgICAgICAKICAgICAgICBvb3AuaW1wbGVtZW50KHRoaXMsIEV2ZW50RW1pdHRlcik7CiAgICAgICAgICAgICAgICAKICAgICAgICB0aGlzLmNhbGxiYWNrID0gZnVuY3Rpb24oZGF0YSwgY2FsbGJhY2tJZCkgewogICAgICAgICAgICBwb3N0TWVzc2FnZSh7CiAgICAgICAgICAgICAgICB0eXBlOiAiY2FsbCIsCiAgICAgICAgICAgICAgICBpZDogY2FsbGJhY2tJZCwKICAgICAgICAgICAgICAgIGRhdGE6IGRhdGEKICAgICAgICAgICAgfSk7CiAgICAgICAgfTsKICAgIAogICAgICAgIHRoaXMuZW1pdCA9IGZ1bmN0aW9uKG5hbWUsIGRhdGEpIHsKICAgICAgICAgICAgcG9zdE1lc3NhZ2UoewogICAgICAgICAgICAgICAgdHlwZTogImV2ZW50IiwKICAgICAgICAgICAgICAgIG5hbWU6IG5hbWUsCiAgICAgICAgICAgICAgICBkYXRhOiBkYXRhCiAgICAgICAgICAgIH0pOwogICAgICAgIH07CiAgICAgICAgCiAgICB9KS5jYWxsKFNlbmRlci5wcm90b3R5cGUpOwogICAgCiAgICByZXR1cm4gbmV3IFNlbmRlcigpOwp9OwoKdmFyIG1haW4gPSB3aW5kb3cubWFpbiA9IG51bGw7CnZhciBzZW5kZXIgPSB3aW5kb3cuc2VuZGVyID0gbnVsbDsKCndpbmRvdy5vbm1lc3NhZ2UgPSBmdW5jdGlvbihlKSB7CiAgICB2YXIgbXNnID0gZS5kYXRhOwogICAgaWYgKG1zZy5ldmVudCAmJiBzZW5kZXIpIHsKICAgICAgICBzZW5kZXIuX3NpZ25hbChtc2cuZXZlbnQsIG1zZy5kYXRhKTsKICAgIH0KICAgIGVsc2UgaWYgKG1zZy5jb21tYW5kKSB7CiAgICAgICAgaWYgKG1haW5bbXNnLmNvbW1hbmRdKQogICAgICAgICAgICBtYWluW21zZy5jb21tYW5kXS5hcHBseShtYWluLCBtc2cuYXJncyk7CiAgICAgICAgZWxzZSBpZiAod2luZG93W21zZy5jb21tYW5kXSkKICAgICAgICAgICAgd2luZG93W21zZy5jb21tYW5kXS5hcHBseSh3aW5kb3csIG1zZy5hcmdzKTsKICAgICAgICBlbHNlCiAgICAgICAgICAgIHRocm93IG5ldyBFcnJvcigiVW5rbm93biBjb21tYW5kOiIgKyBtc2cuY29tbWFuZCk7CiAgICB9CiAgICBlbHNlIGlmIChtc2cuaW5pdCkgewogICAgICAgIHdpbmRvdy5pbml0QmFzZVVybHMobXNnLnRsbnMpOwogICAgICAgIHJlcXVpcmUoImFjZS9saWIvZXM1LXNoaW0iKTsKICAgICAgICBzZW5kZXIgPSB3aW5kb3cuc2VuZGVyID0gd2luZG93LmluaXRTZW5kZXIoKTsKICAgICAgICB2YXIgY2xhenogPSByZXF1aXJlKG1zZy5tb2R1bGUpW21zZy5jbGFzc25hbWVdOwogICAgICAgIG1haW4gPSB3aW5kb3cubWFpbiA9IG5ldyBjbGF6eihzZW5kZXIpOwogICAgfQp9Owp9KSh0aGlzKTsKCmFjZS5kZWZpbmUoImFjZS9saWIvb29wIixbXSwgZnVuY3Rpb24ocmVxdWlyZSwgZXhwb3J0cywgbW9kdWxlKSB7CiJ1c2Ugc3RyaWN0IjsKCmV4cG9ydHMuaW5oZXJpdHMgPSBmdW5jdGlvbihjdG9yLCBzdXBlckN0b3IpIHsKICAgIGN0b3Iuc3VwZXJfID0gc3VwZXJDdG9yOwogICAgY3Rvci5wcm90b3R5cGUgPSBPYmplY3QuY3JlYXRlKHN1cGVyQ3Rvci5wcm90b3R5cGUsIHsKICAgICAgICBjb25zdHJ1Y3RvcjogewogICAgICAgICAgICB2YWx1ZTogY3RvciwKICAgICAgICAgICAgZW51bWVyYWJsZTogZmFsc2UsCiAgICAgICAgICAgIHdyaXRhYmxlOiB0cnVlLAogICAgICAgICAgICBjb25maWd1cmFibGU6IHRydWUKICAgICAgICB9CiAgICB9KTsKfTsKCmV4cG9ydHMubWl4aW4gPSBmdW5jdGlvbihvYmosIG1peGluKSB7CiAgICBmb3IgKHZhciBrZXkgaW4gbWl4aW4pIHsKICAgICAgICBvYmpba2V5XSA9IG1peGluW2tleV07CiAgICB9CiAgICByZXR1cm4gb2JqOwp9OwoKZXhwb3J0cy5pbXBsZW1lbnQgPSBmdW5jdGlvbihwcm90bywgbWl4aW4pIHsKICAgIGV4cG9ydHMubWl4aW4ocHJvdG8sIG1peGluKTsKfTsKCn0pOwoKYWNlLmRlZmluZSgiYWNlL3JhbmdlIixbXSwgZnVuY3Rpb24ocmVxdWlyZSwgZXhwb3J0cywgbW9kdWxlKSB7CiJ1c2Ugc3RyaWN0IjsKdmFyIGNvbXBhcmVQb2ludHMgPSBmdW5jdGlvbihwMSwgcDIpIHsKICAgIHJldHVybiBwMS5yb3cgLSBwMi5yb3cgfHwgcDEuY29sdW1uIC0gcDIuY29sdW1uOwp9Owp2YXIgUmFuZ2UgPSBmdW5jdGlvbihzdGFydFJvdywgc3RhcnRDb2x1bW4sIGVuZFJvdywgZW5kQ29sdW1uKSB7CiAgICB0aGlzLnN0YXJ0ID0gewogICAgICAgIHJvdzogc3RhcnRSb3csCiAgICAgICAgY29sdW1uOiBzdGFydENvbHVtbgogICAgfTsKCiAgICB0aGlzLmVuZCA9IHsKICAgICAgICByb3c6IGVuZFJvdywKICAgICAgICBjb2x1bW46IGVuZENvbHVtbgogICAgfTsKfTsKCihmdW5jdGlvbigpIHsKICAgIHRoaXMuaXNFcXVhbCA9IGZ1bmN0aW9uKHJhbmdlKSB7CiAgICAgICAgcmV0dXJuIHRoaXMuc3RhcnQucm93ID09PSByYW5nZS5zdGFydC5yb3cgJiYKICAgICAgICAgICAgdGhpcy5lbmQucm93ID09PSByYW5nZS5lbmQucm93ICYmCiAgICAgICAgICAgIHRoaXMuc3RhcnQuY29sdW1uID09PSByYW5nZS5zdGFydC5jb2x1bW4gJiYKICAgICAgICAgICAgdGhpcy5lbmQuY29sdW1uID09PSByYW5nZS5lbmQuY29sdW1uOwogICAgfTsKICAgIHRoaXMudG9TdHJpbmcgPSBmdW5jdGlvbigpIHsKICAgICAgICByZXR1cm4gKCJSYW5nZTogWyIgKyB0aGlzLnN0YXJ0LnJvdyArICIvIiArIHRoaXMuc3RhcnQuY29sdW1uICsKICAgICAgICAgICAgIl0gLT4gWyIgKyB0aGlzLmVuZC5yb3cgKyAiLyIgKyB0aGlzLmVuZC5jb2x1bW4gKyAiXSIpOwogICAgfTsKCiAgICB0aGlzLmNvbnRhaW5zID0gZnVuY3Rpb24ocm93LCBjb2x1bW4pIHsKICAgICAgICByZXR1cm4gdGhpcy5jb21wYXJlKHJvdywgY29sdW1uKSA9PSAwOwogICAgfTsKICAgIHRoaXMuY29tcGFyZVJhbmdlID0gZnVuY3Rpb24ocmFuZ2UpIHsKICAgICAgICB2YXIgY21wLAogICAgICAgICAgICBlbmQgPSByYW5nZS5lbmQsCiAgICAgICAgICAgIHN0YXJ0ID0gcmFuZ2Uuc3RhcnQ7CgogICAgICAgIGNtcCA9IHRoaXMuY29tcGFyZShlbmQucm93LCBlbmQuY29sdW1uKTsKICAgICAgICBpZiAoY21wID09IDEpIHsKICAgICAgICAgICAgY21wID0gdGhpcy5jb21wYXJlKHN0YXJ0LnJvdywgc3RhcnQuY29sdW1uKTsKICAgICAgICAgICAgaWYgKGNtcCA9PSAxKSB7CiAgICAgICAgICAgICAgICByZXR1cm4gMjsKICAgICAgICAgICAgfSBlbHNlIGlmIChjbXAgPT0gMCkgewogICAgICAgICAgICAgICAgcmV0dXJuIDE7CiAgICAgICAgICAgIH0gZWxzZSB7CiAgICAgICAgICAgICAgICByZXR1cm4gMDsKICAgICAgICAgICAgfQogICAgICAgIH0gZWxzZSBpZiAoY21wID09IC0xKSB7CiAgICAgICAgICAgIHJldHVybiAtMjsKICAgICAgICB9IGVsc2UgewogICAgICAgICAgICBjbXAgPSB0aGlzLmNvbXBhcmUoc3RhcnQucm93LCBzdGFydC5jb2x1bW4pOwogICAgICAgICAgICBpZiAoY21wID09IC0xKSB7CiAgICAgICAgICAgICAgICByZXR1cm4gLTE7CiAgICAgICAgICAgIH0gZWxzZSBpZiAoY21wID09IDEpIHsKICAgICAgICAgICAgICAgIHJldHVybiA0MjsKICAgICAgICAgICAgfSBlbHNlIHsKICAgICAgICAgICAgICAgIHJldHVybiAwOwogICAgICAgICAgICB9CiAgICAgICAgfQogICAgfTsKICAgIHRoaXMuY29tcGFyZVBvaW50ID0gZnVuY3Rpb24ocCkgewogICAgICAgIHJldHVybiB0aGlzLmNvbXBhcmUocC5yb3csIHAuY29sdW1uKTsKICAgIH07CiAgICB0aGlzLmNvbnRhaW5zUmFuZ2UgPSBmdW5jdGlvbihyYW5nZSkgewogICAgICAgIHJldHVybiB0aGlzLmNvbXBhcmVQb2ludChyYW5nZS5zdGFydCkgPT0gMCAmJiB0aGlzLmNvbXBhcmVQb2ludChyYW5nZS5lbmQpID09IDA7CiAgICB9OwogICAgdGhpcy5pbnRlcnNlY3RzID0gZnVuY3Rpb24ocmFuZ2UpIHsKICAgICAgICB2YXIgY21wID0gdGhpcy5jb21wYXJlUmFuZ2UocmFuZ2UpOwogICAgICAgIHJldHVybiAoY21wID09IC0xIHx8IGNtcCA9PSAwIHx8IGNtcCA9PSAxKTsKICAgIH07CiAgICB0aGlzLmlzRW5kID0gZnVuY3Rpb24ocm93LCBjb2x1bW4pIHsKICAgICAgICByZXR1cm4gdGhpcy5lbmQucm93ID09IHJvdyAmJiB0aGlzLmVuZC5jb2x1bW4gPT0gY29sdW1uOwogICAgfTsKICAgIHRoaXMuaXNTdGFydCA9IGZ1bmN0aW9uKHJvdywgY29sdW1uKSB7CiAgICAgICAgcmV0dXJuIHRoaXMuc3RhcnQucm93ID09IHJvdyAmJiB0aGlzLnN0YXJ0LmNvbHVtbiA9PSBjb2x1bW47CiAgICB9OwogICAgdGhpcy5zZXRTdGFydCA9IGZ1bmN0aW9uKHJvdywgY29sdW1uKSB7CiAgICAgICAgaWYgKHR5cGVvZiByb3cgPT0gIm9iamVjdCIpIHsKICAgICAgICAgICAgdGhpcy5zdGFydC5jb2x1bW4gPSByb3cuY29sdW1uOwogICAgICAgICAgICB0aGlzLnN0YXJ0LnJvdyA9IHJvdy5yb3c7CiAgICAgICAgfSBlbHNlIHsKICAgICAgICAgICAgdGhpcy5zdGFydC5yb3cgPSByb3c7CiAgICAgICAgICAgIHRoaXMuc3RhcnQuY29sdW1uID0gY29sdW1uOwogICAgICAgIH0KICAgIH07CiAgICB0aGlzLnNldEVuZCA9IGZ1bmN0aW9uKHJvdywgY29sdW1uKSB7CiAgICAgICAgaWYgKHR5cGVvZiByb3cgPT0gIm9iamVjdCIpIHsKICAgICAgICAgICAgdGhpcy5lbmQuY29sdW1uID0gcm93LmNvbHVtbjsKICAgICAgICAgICAgdGhpcy5lbmQucm93ID0gcm93LnJvdzsKICAgICAgICB9IGVsc2UgewogICAgICAgICAgICB0aGlzLmVuZC5yb3cgPSByb3c7CiAgICAgICAgICAgIHRoaXMuZW5kLmNvbHVtbiA9IGNvbHVtbjsKICAgICAgICB9CiAgICB9OwogICAgdGhpcy5pbnNpZGUgPSBmdW5jdGlvbihyb3csIGNvbHVtbikgewogICAgICAgIGlmICh0aGlzLmNvbXBhcmUocm93LCBjb2x1bW4pID09IDApIHsKICAgICAgICAgICAgaWYgKHRoaXMuaXNFbmQocm93LCBjb2x1bW4pIHx8IHRoaXMuaXNTdGFydChyb3csIGNvbHVtbikpIHsKICAgICAgICAgICAgICAgIHJldHVybiBmYWxzZTsKICAgICAgICAgICAgfSBlbHNlIHsKICAgICAgICAgICAgICAgIHJldHVybiB0cnVlOwogICAgICAgICAgICB9CiAgICAgICAgfQogICAgICAgIHJldHVybiBmYWxzZTsKICAgIH07CiAgICB0aGlzLmluc2lkZVN0YXJ0ID0gZnVuY3Rpb24ocm93LCBjb2x1bW4pIHsKICAgICAgICBpZiAodGhpcy5jb21wYXJlKHJvdywgY29sdW1uKSA9PSAwKSB7CiAgICAgICAgICAgIGlmICh0aGlzLmlzRW5kKHJvdywgY29sdW1uKSkgewogICAgICAgICAgICAgICAgcmV0dXJuIGZhbHNlOwogICAgICAgICAgICB9IGVsc2UgewogICAgICAgICAgICAgICAgcmV0dXJuIHRydWU7CiAgICAgICAgICAgIH0KICAgICAgICB9CiAgICAgICAgcmV0dXJuIGZhbHNlOwogICAgfTsKICAgIHRoaXMuaW5zaWRlRW5kID0gZnVuY3Rpb24ocm93LCBjb2x1bW4pIHsKICAgICAgICBpZiAodGhpcy5jb21wYXJlKHJvdywgY29sdW1uKSA9PSAwKSB7CiAgICAgICAgICAgIGlmICh0aGlzLmlzU3RhcnQocm93LCBjb2x1bW4pKSB7CiAgICAgICAgICAgICAgICByZXR1cm4gZmFsc2U7CiAgICAgICAgICAgIH0gZWxzZSB7CiAgICAgICAgICAgICAgICByZXR1cm4gdHJ1ZTsKICAgICAgICAgICAgfQogICAgICAgIH0KICAgICAgICByZXR1cm4gZmFsc2U7CiAgICB9OwogICAgdGhpcy5jb21wYXJlID0gZnVuY3Rpb24ocm93LCBjb2x1bW4pIHsKICAgICAgICBpZiAoIXRoaXMuaXNNdWx0aUxpbmUoKSkgewogICAgICAgICAgICBpZiAocm93ID09PSB0aGlzLnN0YXJ0LnJvdykgewogICAgICAgICAgICAgICAgcmV0dXJuIGNvbHVtbiA8IHRoaXMuc3RhcnQuY29sdW1uID8gLTEgOiAoY29sdW1uID4gdGhpcy5lbmQuY29sdW1uID8gMSA6IDApOwogICAgICAgICAgICB9CiAgICAgICAgfQoKICAgICAgICBpZiAocm93IDwgdGhpcy5zdGFydC5yb3cpCiAgICAgICAgICAgIHJldHVybiAtMTsKCiAgICAgICAgaWYgKHJvdyA+IHRoaXMuZW5kLnJvdykKICAgICAgICAgICAgcmV0dXJuIDE7CgogICAgICAgIGlmICh0aGlzLnN0YXJ0LnJvdyA9PT0gcm93KQogICAgICAgICAgICByZXR1cm4gY29sdW1uID49IHRoaXMuc3RhcnQuY29sdW1uID8gMCA6IC0xOwoKICAgICAgICBpZiAodGhpcy5lbmQucm93ID09PSByb3cpCiAgICAgICAgICAgIHJldHVybiBjb2x1bW4gPD0gdGhpcy5lbmQuY29sdW1uID8gMCA6IDE7CgogICAgICAgIHJldHVybiAwOwogICAgfTsKICAgIHRoaXMuY29tcGFyZVN0YXJ0ID0gZnVuY3Rpb24ocm93LCBjb2x1bW4pIHsKICAgICAgICBpZiAodGhpcy5zdGFydC5yb3cgPT0gcm93ICYmIHRoaXMuc3RhcnQuY29sdW1uID09IGNvbHVtbikgewogICAgICAgICAgICByZXR1cm4gLTE7CiAgICAgICAgfSBlbHNlIHsKICAgICAgICAgICAgcmV0dXJuIHRoaXMuY29tcGFyZShyb3csIGNvbHVtbik7CiAgICAgICAgfQogICAgfTsKICAgIHRoaXMuY29tcGFyZUVuZCA9IGZ1bmN0aW9uKHJvdywgY29sdW1uKSB7CiAgICAgICAgaWYgKHRoaXMuZW5kLnJvdyA9PSByb3cgJiYgdGhpcy5lbmQuY29sdW1uID09IGNvbHVtbikgewogICAgICAgICAgICByZXR1cm4gMTsKICAgICAgICB9IGVsc2UgewogICAgICAgICAgICByZXR1cm4gdGhpcy5jb21wYXJlKHJvdywgY29sdW1uKTsKICAgICAgICB9CiAgICB9OwogICAgdGhpcy5jb21wYXJlSW5zaWRlID0gZnVuY3Rpb24ocm93LCBjb2x1bW4pIHsKICAgICAgICBpZiAodGhpcy5lbmQucm93ID09IHJvdyAmJiB0aGlzLmVuZC5jb2x1bW4gPT0gY29sdW1uKSB7CiAgICAgICAgICAgIHJldHVybiAxOwogICAgICAgIH0gZWxzZSBpZiAodGhpcy5zdGFydC5yb3cgPT0gcm93ICYmIHRoaXMuc3RhcnQuY29sdW1uID09IGNvbHVtbikgewogICAgICAgICAgICByZXR1cm4gLTE7CiAgICAgICAgfSBlbHNlIHsKICAgICAgICAgICAgcmV0dXJuIHRoaXMuY29tcGFyZShyb3csIGNvbHVtbik7CiAgICAgICAgfQogICAgfTsKICAgIHRoaXMuY2xpcFJvd3MgPSBmdW5jdGlvbihmaXJzdFJvdywgbGFzdFJvdykgewogICAgICAgIGlmICh0aGlzLmVuZC5yb3cgPiBsYXN0Um93KQogICAgICAgICAgICB2YXIgZW5kID0ge3JvdzogbGFzdFJvdyArIDEsIGNvbHVtbjogMH07CiAgICAgICAgZWxzZSBpZiAodGhpcy5lbmQucm93IDwgZmlyc3RSb3cpCiAgICAgICAgICAgIHZhciBlbmQgPSB7cm93OiBmaXJzdFJvdywgY29sdW1uOiAwfTsKCiAgICAgICAgaWYgKHRoaXMuc3RhcnQucm93ID4gbGFzdFJvdykKICAgICAgICAgICAgdmFyIHN0YXJ0ID0ge3JvdzogbGFzdFJvdyArIDEsIGNvbHVtbjogMH07CiAgICAgICAgZWxzZSBpZiAodGhpcy5zdGFydC5yb3cgPCBmaXJzdFJvdykKICAgICAgICAgICAgdmFyIHN0YXJ0ID0ge3JvdzogZmlyc3RSb3csIGNvbHVtbjogMH07CgogICAgICAgIHJldHVybiBSYW5nZS5mcm9tUG9pbnRzKHN0YXJ0IHx8IHRoaXMuc3RhcnQsIGVuZCB8fCB0aGlzLmVuZCk7CiAgICB9OwogICAgdGhpcy5leHRlbmQgPSBmdW5jdGlvbihyb3csIGNvbHVtbikgewogICAgICAgIHZhciBjbXAgPSB0aGlzLmNvbXBhcmUocm93LCBjb2x1bW4pOwoKICAgICAgICBpZiAoY21wID09IDApCiAgICAgICAgICAgIHJldHVybiB0aGlzOwogICAgICAgIGVsc2UgaWYgKGNtcCA9PSAtMSkKICAgICAgICAgICAgdmFyIHN0YXJ0ID0ge3Jvdzogcm93LCBjb2x1bW46IGNvbHVtbn07CiAgICAgICAgZWxzZQogICAgICAgICAgICB2YXIgZW5kID0ge3Jvdzogcm93LCBjb2x1bW46IGNvbHVtbn07CgogICAgICAgIHJldHVybiBSYW5nZS5mcm9tUG9pbnRzKHN0YXJ0IHx8IHRoaXMuc3RhcnQsIGVuZCB8fCB0aGlzLmVuZCk7CiAgICB9OwoKICAgIHRoaXMuaXNFbXB0eSA9IGZ1bmN0aW9uKCkgewogICAgICAgIHJldHVybiAodGhpcy5zdGFydC5yb3cgPT09IHRoaXMuZW5kLnJvdyAmJiB0aGlzLnN0YXJ0LmNvbHVtbiA9PT0gdGhpcy5lbmQuY29sdW1uKTsKICAgIH07CiAgICB0aGlzLmlzTXVsdGlMaW5lID0gZnVuY3Rpb24oKSB7CiAgICAgICAgcmV0dXJuICh0aGlzLnN0YXJ0LnJvdyAhPT0gdGhpcy5lbmQucm93KTsKICAgIH07CiAgICB0aGlzLmNsb25lID0gZnVuY3Rpb24oKSB7CiAgICAgICAgcmV0dXJuIFJhbmdlLmZyb21Qb2ludHModGhpcy5zdGFydCwgdGhpcy5lbmQpOwogICAgfTsKICAgIHRoaXMuY29sbGFwc2VSb3dzID0gZnVuY3Rpb24oKSB7CiAgICAgICAgaWYgKHRoaXMuZW5kLmNvbHVtbiA9PSAwKQogICAgICAgICAgICByZXR1cm4gbmV3IFJhbmdlKHRoaXMuc3RhcnQucm93LCAwLCBNYXRoLm1heCh0aGlzLnN0YXJ0LnJvdywgdGhpcy5lbmQucm93LTEpLCAwKTsKICAgICAgICBlbHNlCiAgICAgICAgICAgIHJldHVybiBuZXcgUmFuZ2UodGhpcy5zdGFydC5yb3csIDAsIHRoaXMuZW5kLnJvdywgMCk7CiAgICB9OwogICAgdGhpcy50b1NjcmVlblJhbmdlID0gZnVuY3Rpb24oc2Vzc2lvbikgewogICAgICAgIHZhciBzY3JlZW5Qb3NTdGFydCA9IHNlc3Npb24uZG9jdW1lbnRUb1NjcmVlblBvc2l0aW9uKHRoaXMuc3RhcnQpOwogICAgICAgIHZhciBzY3JlZW5Qb3NFbmQgPSBzZXNzaW9uLmRvY3VtZW50VG9TY3JlZW5Qb3NpdGlvbih0aGlzLmVuZCk7CgogICAgICAgIHJldHVybiBuZXcgUmFuZ2UoCiAgICAgICAgICAgIHNjcmVlblBvc1N0YXJ0LnJvdywgc2NyZWVuUG9zU3RhcnQuY29sdW1uLAogICAgICAgICAgICBzY3JlZW5Qb3NFbmQucm93LCBzY3JlZW5Qb3NFbmQuY29sdW1uCiAgICAgICAgKTsKICAgIH07CiAgICB0aGlzLm1vdmVCeSA9IGZ1bmN0aW9uKHJvdywgY29sdW1uKSB7CiAgICAgICAgdGhpcy5zdGFydC5yb3cgKz0gcm93OwogICAgICAgIHRoaXMuc3RhcnQuY29sdW1uICs9IGNvbHVtbjsKICAgICAgICB0aGlzLmVuZC5yb3cgKz0gcm93OwogICAgICAgIHRoaXMuZW5kLmNvbHVtbiArPSBjb2x1bW47CiAgICB9OwoKfSkuY2FsbChSYW5nZS5wcm90b3R5cGUpOwpSYW5nZS5mcm9tUG9pbnRzID0gZnVuY3Rpb24oc3RhcnQsIGVuZCkgewogICAgcmV0dXJuIG5ldyBSYW5nZShzdGFydC5yb3csIHN0YXJ0LmNvbHVtbiwgZW5kLnJvdywgZW5kLmNvbHVtbik7Cn07ClJhbmdlLmNvbXBhcmVQb2ludHMgPSBjb21wYXJlUG9pbnRzOwoKUmFuZ2UuY29tcGFyZVBvaW50cyA9IGZ1bmN0aW9uKHAxLCBwMikgewogICAgcmV0dXJuIHAxLnJvdyAtIHAyLnJvdyB8fCBwMS5jb2x1bW4gLSBwMi5jb2x1bW47Cn07CgoKZXhwb3J0cy5SYW5nZSA9IFJhbmdlOwp9KTsKCmFjZS5kZWZpbmUoImFjZS9hcHBseV9kZWx0YSIsW10sIGZ1bmN0aW9uKHJlcXVpcmUsIGV4cG9ydHMsIG1vZHVsZSkgewoidXNlIHN0cmljdCI7CgpmdW5jdGlvbiB0aHJvd0RlbHRhRXJyb3IoZGVsdGEsIGVycm9yVGV4dCl7CiAgICBjb25zb2xlLmxvZygiSW52YWxpZCBEZWx0YToiLCBkZWx0YSk7CiAgICB0aHJvdyAiSW52YWxpZCBEZWx0YTogIiArIGVycm9yVGV4dDsKfQoKZnVuY3Rpb24gcG9zaXRpb25JbkRvY3VtZW50KGRvY0xpbmVzLCBwb3NpdGlvbikgewogICAgcmV0dXJuIHBvc2l0aW9uLnJvdyAgICA+PSAwICYmIHBvc2l0aW9uLnJvdyAgICA8ICBkb2NMaW5lcy5sZW5ndGggJiYKICAgICAgICAgICBwb3NpdGlvbi5jb2x1bW4gPj0gMCAmJiBwb3NpdGlvbi5jb2x1bW4gPD0gZG9jTGluZXNbcG9zaXRpb24ucm93XS5sZW5ndGg7Cn0KCmZ1bmN0aW9uIHZhbGlkYXRlRGVsdGEoZG9jTGluZXMsIGRlbHRhKSB7CiAgICBpZiAoZGVsdGEuYWN0aW9uICE9ICJpbnNlcnQiICYmIGRlbHRhLmFjdGlvbiAhPSAicmVtb3ZlIikKICAgICAgICB0aHJvd0RlbHRhRXJyb3IoZGVsdGEsICJkZWx0YS5hY3Rpb24gbXVzdCBiZSAnaW5zZXJ0JyBvciAncmVtb3ZlJyIpOwogICAgaWYgKCEoZGVsdGEubGluZXMgaW5zdGFuY2VvZiBBcnJheSkpCiAgICAgICAgdGhyb3dEZWx0YUVycm9yKGRlbHRhLCAiZGVsdGEubGluZXMgbXVzdCBiZSBhbiBBcnJheSIpOwogICAgaWYgKCFkZWx0YS5zdGFydCB8fCAhZGVsdGEuZW5kKQogICAgICAgdGhyb3dEZWx0YUVycm9yKGRlbHRhLCAiZGVsdGEuc3RhcnQvZW5kIG11c3QgYmUgYW4gcHJlc2VudCIpOwogICAgdmFyIHN0YXJ0ID0gZGVsdGEuc3RhcnQ7CiAgICBpZiAoIXBvc2l0aW9uSW5Eb2N1bWVudChkb2NMaW5lcywgZGVsdGEuc3RhcnQpKQogICAgICAgIHRocm93RGVsdGFFcnJvcihkZWx0YSwgImRlbHRhLnN0YXJ0IG11c3QgYmUgY29udGFpbmVkIGluIGRvY3VtZW50Iik7CiAgICB2YXIgZW5kID0gZGVsdGEuZW5kOwogICAgaWYgKGRlbHRhLmFjdGlvbiA9PSAicmVtb3ZlIiAmJiAhcG9zaXRpb25JbkRvY3VtZW50KGRvY0xpbmVzLCBlbmQpKQogICAgICAgIHRocm93RGVsdGFFcnJvcihkZWx0YSwgImRlbHRhLmVuZCBtdXN0IGNvbnRhaW5lZCBpbiBkb2N1bWVudCBmb3IgJ3JlbW92ZScgYWN0aW9ucyIpOwogICAgdmFyIG51bVJhbmdlUm93cyA9IGVuZC5yb3cgLSBzdGFydC5yb3c7CiAgICB2YXIgbnVtUmFuZ2VMYXN0TGluZUNoYXJzID0gKGVuZC5jb2x1bW4gLSAobnVtUmFuZ2VSb3dzID09IDAgPyBzdGFydC5jb2x1bW4gOiAwKSk7CiAgICBpZiAobnVtUmFuZ2VSb3dzICE9IGRlbHRhLmxpbmVzLmxlbmd0aCAtIDEgfHwgZGVsdGEubGluZXNbbnVtUmFuZ2VSb3dzXS5sZW5ndGggIT0gbnVtUmFuZ2VMYXN0TGluZUNoYXJzKQogICAgICAgIHRocm93RGVsdGFFcnJvcihkZWx0YSwgImRlbHRhLnJhbmdlIG11c3QgbWF0Y2ggZGVsdGEgbGluZXMiKTsKfQoKZXhwb3J0cy5hcHBseURlbHRhID0gZnVuY3Rpb24oZG9jTGluZXMsIGRlbHRhLCBkb05vdFZhbGlkYXRlKSB7CiAgICAKICAgIHZhciByb3cgPSBkZWx0YS5zdGFydC5yb3c7CiAgICB2YXIgc3RhcnRDb2x1bW4gPSBkZWx0YS5zdGFydC5jb2x1bW47CiAgICB2YXIgbGluZSA9IGRvY0xpbmVzW3Jvd10gfHwgIiI7CiAgICBzd2l0Y2ggKGRlbHRhLmFjdGlvbikgewogICAgICAgIGNhc2UgImluc2VydCI6CiAgICAgICAgICAgIHZhciBsaW5lcyA9IGRlbHRhLmxpbmVzOwogICAgICAgICAgICBpZiAobGluZXMubGVuZ3RoID09PSAxKSB7CiAgICAgICAgICAgICAgICBkb2NMaW5lc1tyb3ddID0gbGluZS5zdWJzdHJpbmcoMCwgc3RhcnRDb2x1bW4pICsgZGVsdGEubGluZXNbMF0gKyBsaW5lLnN1YnN0cmluZyhzdGFydENvbHVtbik7CiAgICAgICAgICAgIH0gZWxzZSB7CiAgICAgICAgICAgICAgICB2YXIgYXJncyA9IFtyb3csIDFdLmNvbmNhdChkZWx0YS5saW5lcyk7CiAgICAgICAgICAgICAgICBkb2NMaW5lcy5zcGxpY2UuYXBwbHkoZG9jTGluZXMsIGFyZ3MpOwogICAgICAgICAgICAgICAgZG9jTGluZXNbcm93XSA9IGxpbmUuc3Vic3RyaW5nKDAsIHN0YXJ0Q29sdW1uKSArIGRvY0xpbmVzW3Jvd107CiAgICAgICAgICAgICAgICBkb2NMaW5lc1tyb3cgKyBkZWx0YS5saW5lcy5sZW5ndGggLSAxXSArPSBsaW5lLnN1YnN0cmluZyhzdGFydENvbHVtbik7CiAgICAgICAgICAgIH0KICAgICAgICAgICAgYnJlYWs7CiAgICAgICAgY2FzZSAicmVtb3ZlIjoKICAgICAgICAgICAgdmFyIGVuZENvbHVtbiA9IGRlbHRhLmVuZC5jb2x1bW47CiAgICAgICAgICAgIHZhciBlbmRSb3cgPSBkZWx0YS5lbmQucm93OwogICAgICAgICAgICBpZiAocm93ID09PSBlbmRSb3cpIHsKICAgICAgICAgICAgICAgIGRvY0xpbmVzW3Jvd10gPSBsaW5lLnN1YnN0cmluZygwLCBzdGFydENvbHVtbikgKyBsaW5lLnN1YnN0cmluZyhlbmRDb2x1bW4pOwogICAgICAgICAgICB9IGVsc2UgewogICAgICAgICAgICAgICAgZG9jTGluZXMuc3BsaWNlKAogICAgICAgICAgICAgICAgICAgIHJvdywgZW5kUm93IC0gcm93ICsgMSwKICAgICAgICAgICAgICAgICAgICBsaW5lLnN1YnN0cmluZygwLCBzdGFydENvbHVtbikgKyBkb2NMaW5lc1tlbmRSb3ddLnN1YnN0cmluZyhlbmRDb2x1bW4pCiAgICAgICAgICAgICAgICApOwogICAgICAgICAgICB9CiAgICAgICAgICAgIGJyZWFrOwogICAgfQp9Owp9KTsKCmFjZS5kZWZpbmUoImFjZS9saWIvZXZlbnRfZW1pdHRlciIsW10sIGZ1bmN0aW9uKHJlcXVpcmUsIGV4cG9ydHMsIG1vZHVsZSkgewoidXNlIHN0cmljdCI7Cgp2YXIgRXZlbnRFbWl0dGVyID0ge307CnZhciBzdG9wUHJvcGFnYXRpb24gPSBmdW5jdGlvbigpIHsgdGhpcy5wcm9wYWdhdGlvblN0b3BwZWQgPSB0cnVlOyB9Owp2YXIgcHJldmVudERlZmF1bHQgPSBmdW5jdGlvbigpIHsgdGhpcy5kZWZhdWx0UHJldmVudGVkID0gdHJ1ZTsgfTsKCkV2ZW50RW1pdHRlci5fZW1pdCA9CkV2ZW50RW1pdHRlci5fZGlzcGF0Y2hFdmVudCA9IGZ1bmN0aW9uKGV2ZW50TmFtZSwgZSkgewogICAgdGhpcy5fZXZlbnRSZWdpc3RyeSB8fCAodGhpcy5fZXZlbnRSZWdpc3RyeSA9IHt9KTsKICAgIHRoaXMuX2RlZmF1bHRIYW5kbGVycyB8fCAodGhpcy5fZGVmYXVsdEhhbmRsZXJzID0ge30pOwoKICAgIHZhciBsaXN0ZW5lcnMgPSB0aGlzLl9ldmVudFJlZ2lzdHJ5W2V2ZW50TmFtZV0gfHwgW107CiAgICB2YXIgZGVmYXVsdEhhbmRsZXIgPSB0aGlzLl9kZWZhdWx0SGFuZGxlcnNbZXZlbnROYW1lXTsKICAgIGlmICghbGlzdGVuZXJzLmxlbmd0aCAmJiAhZGVmYXVsdEhhbmRsZXIpCiAgICAgICAgcmV0dXJuOwoKICAgIGlmICh0eXBlb2YgZSAhPSAib2JqZWN0IiB8fCAhZSkKICAgICAgICBlID0ge307CgogICAgaWYgKCFlLnR5cGUpCiAgICAgICAgZS50eXBlID0gZXZlbnROYW1lOwogICAgaWYgKCFlLnN0b3BQcm9wYWdhdGlvbikKICAgICAgICBlLnN0b3BQcm9wYWdhdGlvbiA9IHN0b3BQcm9wYWdhdGlvbjsKICAgIGlmICghZS5wcmV2ZW50RGVmYXVsdCkKICAgICAgICBlLnByZXZlbnREZWZhdWx0ID0gcHJldmVudERlZmF1bHQ7CgogICAgbGlzdGVuZXJzID0gbGlzdGVuZXJzLnNsaWNlKCk7CiAgICBmb3IgKHZhciBpPTA7IGk8bGlzdGVuZXJzLmxlbmd0aDsgaSsrKSB7CiAgICAgICAgbGlzdGVuZXJzW2ldKGUsIHRoaXMpOwogICAgICAgIGlmIChlLnByb3BhZ2F0aW9uU3RvcHBlZCkKICAgICAgICAgICAgYnJlYWs7CiAgICB9CiAgICAKICAgIGlmIChkZWZhdWx0SGFuZGxlciAmJiAhZS5kZWZhdWx0UHJldmVudGVkKQogICAgICAgIHJldHVybiBkZWZhdWx0SGFuZGxlcihlLCB0aGlzKTsKfTsKCgpFdmVudEVtaXR0ZXIuX3NpZ25hbCA9IGZ1bmN0aW9uKGV2ZW50TmFtZSwgZSkgewogICAgdmFyIGxpc3RlbmVycyA9ICh0aGlzLl9ldmVudFJlZ2lzdHJ5IHx8IHt9KVtldmVudE5hbWVdOwogICAgaWYgKCFsaXN0ZW5lcnMpCiAgICAgICAgcmV0dXJuOwogICAgbGlzdGVuZXJzID0gbGlzdGVuZXJzLnNsaWNlKCk7CiAgICBmb3IgKHZhciBpPTA7IGk8bGlzdGVuZXJzLmxlbmd0aDsgaSsrKQogICAgICAgIGxpc3RlbmVyc1tpXShlLCB0aGlzKTsKfTsKCkV2ZW50RW1pdHRlci5vbmNlID0gZnVuY3Rpb24oZXZlbnROYW1lLCBjYWxsYmFjaykgewogICAgdmFyIF9zZWxmID0gdGhpczsKICAgIHRoaXMuYWRkRXZlbnRMaXN0ZW5lcihldmVudE5hbWUsIGZ1bmN0aW9uIG5ld0NhbGxiYWNrKCkgewogICAgICAgIF9zZWxmLnJlbW92ZUV2ZW50TGlzdGVuZXIoZXZlbnROYW1lLCBuZXdDYWxsYmFjayk7CiAgICAgICAgY2FsbGJhY2suYXBwbHkobnVsbCwgYXJndW1lbnRzKTsKICAgIH0pOwogICAgaWYgKCFjYWxsYmFjaykgewogICAgICAgIHJldHVybiBuZXcgUHJvbWlzZShmdW5jdGlvbihyZXNvbHZlKSB7CiAgICAgICAgICAgIGNhbGxiYWNrID0gcmVzb2x2ZTsKICAgICAgICB9KTsKICAgIH0KfTsKCgpFdmVudEVtaXR0ZXIuc2V0RGVmYXVsdEhhbmRsZXIgPSBmdW5jdGlvbihldmVudE5hbWUsIGNhbGxiYWNrKSB7CiAgICB2YXIgaGFuZGxlcnMgPSB0aGlzLl9kZWZhdWx0SGFuZGxlcnM7CiAgICBpZiAoIWhhbmRsZXJzKQogICAgICAgIGhhbmRsZXJzID0gdGhpcy5fZGVmYXVsdEhhbmRsZXJzID0ge19kaXNhYmxlZF86IHt9fTsKICAgIAogICAgaWYgKGhhbmRsZXJzW2V2ZW50TmFtZV0pIHsKICAgICAgICB2YXIgb2xkID0gaGFuZGxlcnNbZXZlbnROYW1lXTsKICAgICAgICB2YXIgZGlzYWJsZWQgPSBoYW5kbGVycy5fZGlzYWJsZWRfW2V2ZW50TmFtZV07CiAgICAgICAgaWYgKCFkaXNhYmxlZCkKICAgICAgICAgICAgaGFuZGxlcnMuX2Rpc2FibGVkX1tldmVudE5hbWVdID0gZGlzYWJsZWQgPSBbXTsKICAgICAgICBkaXNhYmxlZC5wdXNoKG9sZCk7CiAgICAgICAgdmFyIGkgPSBkaXNhYmxlZC5pbmRleE9mKGNhbGxiYWNrKTsKICAgICAgICBpZiAoaSAhPSAtMSkgCiAgICAgICAgICAgIGRpc2FibGVkLnNwbGljZShpLCAxKTsKICAgIH0KICAgIGhhbmRsZXJzW2V2ZW50TmFtZV0gPSBjYWxsYmFjazsKfTsKRXZlbnRFbWl0dGVyLnJlbW92ZURlZmF1bHRIYW5kbGVyID0gZnVuY3Rpb24oZXZlbnROYW1lLCBjYWxsYmFjaykgewogICAgdmFyIGhhbmRsZXJzID0gdGhpcy5fZGVmYXVsdEhhbmRsZXJzOwogICAgaWYgKCFoYW5kbGVycykKICAgICAgICByZXR1cm47CiAgICB2YXIgZGlzYWJsZWQgPSBoYW5kbGVycy5fZGlzYWJsZWRfW2V2ZW50TmFtZV07CiAgICAKICAgIGlmIChoYW5kbGVyc1tldmVudE5hbWVdID09IGNhbGxiYWNrKSB7CiAgICAgICAgaWYgKGRpc2FibGVkKQogICAgICAgICAgICB0aGlzLnNldERlZmF1bHRIYW5kbGVyKGV2ZW50TmFtZSwgZGlzYWJsZWQucG9wKCkpOwogICAgfSBlbHNlIGlmIChkaXNhYmxlZCkgewogICAgICAgIHZhciBpID0gZGlzYWJsZWQuaW5kZXhPZihjYWxsYmFjayk7CiAgICAgICAgaWYgKGkgIT0gLTEpCiAgICAgICAgICAgIGRpc2FibGVkLnNwbGljZShpLCAxKTsKICAgIH0KfTsKCkV2ZW50RW1pdHRlci5vbiA9CkV2ZW50RW1pdHRlci5hZGRFdmVudExpc3RlbmVyID0gZnVuY3Rpb24oZXZlbnROYW1lLCBjYWxsYmFjaywgY2FwdHVyaW5nKSB7CiAgICB0aGlzLl9ldmVudFJlZ2lzdHJ5ID0gdGhpcy5fZXZlbnRSZWdpc3RyeSB8fCB7fTsKCiAgICB2YXIgbGlzdGVuZXJzID0gdGhpcy5fZXZlbnRSZWdpc3RyeVtldmVudE5hbWVdOwogICAgaWYgKCFsaXN0ZW5lcnMpCiAgICAgICAgbGlzdGVuZXJzID0gdGhpcy5fZXZlbnRSZWdpc3RyeVtldmVudE5hbWVdID0gW107CgogICAgaWYgKGxpc3RlbmVycy5pbmRleE9mKGNhbGxiYWNrKSA9PSAtMSkKICAgICAgICBsaXN0ZW5lcnNbY2FwdHVyaW5nID8gInVuc2hpZnQiIDogInB1c2giXShjYWxsYmFjayk7CiAgICByZXR1cm4gY2FsbGJhY2s7Cn07CgpFdmVudEVtaXR0ZXIub2ZmID0KRXZlbnRFbWl0dGVyLnJlbW92ZUxpc3RlbmVyID0KRXZlbnRFbWl0dGVyLnJlbW92ZUV2ZW50TGlzdGVuZXIgPSBmdW5jdGlvbihldmVudE5hbWUsIGNhbGxiYWNrKSB7CiAgICB0aGlzLl9ldmVudFJlZ2lzdHJ5ID0gdGhpcy5fZXZlbnRSZWdpc3RyeSB8fCB7fTsKCiAgICB2YXIgbGlzdGVuZXJzID0gdGhpcy5fZXZlbnRSZWdpc3RyeVtldmVudE5hbWVdOwogICAgaWYgKCFsaXN0ZW5lcnMpCiAgICAgICAgcmV0dXJuOwoKICAgIHZhciBpbmRleCA9IGxpc3RlbmVycy5pbmRleE9mKGNhbGxiYWNrKTsKICAgIGlmIChpbmRleCAhPT0gLTEpCiAgICAgICAgbGlzdGVuZXJzLnNwbGljZShpbmRleCwgMSk7Cn07CgpFdmVudEVtaXR0ZXIucmVtb3ZlQWxsTGlzdGVuZXJzID0gZnVuY3Rpb24oZXZlbnROYW1lKSB7CiAgICBpZiAodGhpcy5fZXZlbnRSZWdpc3RyeSkgdGhpcy5fZXZlbnRSZWdpc3RyeVtldmVudE5hbWVdID0gW107Cn07CgpleHBvcnRzLkV2ZW50RW1pdHRlciA9IEV2ZW50RW1pdHRlcjsKCn0pOwoKYWNlLmRlZmluZSgiYWNlL2FuY2hvciIsW10sIGZ1bmN0aW9uKHJlcXVpcmUsIGV4cG9ydHMsIG1vZHVsZSkgewoidXNlIHN0cmljdCI7Cgp2YXIgb29wID0gcmVxdWlyZSgiLi9saWIvb29wIik7CnZhciBFdmVudEVtaXR0ZXIgPSByZXF1aXJlKCIuL2xpYi9ldmVudF9lbWl0dGVyIikuRXZlbnRFbWl0dGVyOwoKdmFyIEFuY2hvciA9IGV4cG9ydHMuQW5jaG9yID0gZnVuY3Rpb24oZG9jLCByb3csIGNvbHVtbikgewogICAgdGhpcy4kb25DaGFuZ2UgPSB0aGlzLm9uQ2hhbmdlLmJpbmQodGhpcyk7CiAgICB0aGlzLmF0dGFjaChkb2MpOwogICAgCiAgICBpZiAodHlwZW9mIGNvbHVtbiA9PSAidW5kZWZpbmVkIikKICAgICAgICB0aGlzLnNldFBvc2l0aW9uKHJvdy5yb3csIHJvdy5jb2x1bW4pOwogICAgZWxzZQogICAgICAgIHRoaXMuc2V0UG9zaXRpb24ocm93LCBjb2x1bW4pOwp9OwoKKGZ1bmN0aW9uKCkgewoKICAgIG9vcC5pbXBsZW1lbnQodGhpcywgRXZlbnRFbWl0dGVyKTsKICAgIHRoaXMuZ2V0UG9zaXRpb24gPSBmdW5jdGlvbigpIHsKICAgICAgICByZXR1cm4gdGhpcy4kY2xpcFBvc2l0aW9uVG9Eb2N1bWVudCh0aGlzLnJvdywgdGhpcy5jb2x1bW4pOwogICAgfTsKICAgIHRoaXMuZ2V0RG9jdW1lbnQgPSBmdW5jdGlvbigpIHsKICAgICAgICByZXR1cm4gdGhpcy5kb2N1bWVudDsKICAgIH07CiAgICB0aGlzLiRpbnNlcnRSaWdodCA9IGZhbHNlOwogICAgdGhpcy5vbkNoYW5nZSA9IGZ1bmN0aW9uKGRlbHRhKSB7CiAgICAgICAgaWYgKGRlbHRhLnN0YXJ0LnJvdyA9PSBkZWx0YS5lbmQucm93ICYmIGRlbHRhLnN0YXJ0LnJvdyAhPSB0aGlzLnJvdykKICAgICAgICAgICAgcmV0dXJuOwoKICAgICAgICBpZiAoZGVsdGEuc3RhcnQucm93ID4gdGhpcy5yb3cpCiAgICAgICAgICAgIHJldHVybjsKICAgICAgICAgICAgCiAgICAgICAgdmFyIHBvaW50ID0gJGdldFRyYW5zZm9ybWVkUG9pbnQoZGVsdGEsIHtyb3c6IHRoaXMucm93LCBjb2x1bW46IHRoaXMuY29sdW1ufSwgdGhpcy4kaW5zZXJ0UmlnaHQpOwogICAgICAgIHRoaXMuc2V0UG9zaXRpb24ocG9pbnQucm93LCBwb2ludC5jb2x1bW4sIHRydWUpOwogICAgfTsKICAgIAogICAgZnVuY3Rpb24gJHBvaW50c0luT3JkZXIocG9pbnQxLCBwb2ludDIsIGVxdWFsUG9pbnRzSW5PcmRlcikgewogICAgICAgIHZhciBiQ29sSXNBZnRlciA9IGVxdWFsUG9pbnRzSW5PcmRlciA/IHBvaW50MS5jb2x1bW4gPD0gcG9pbnQyLmNvbHVtbiA6IHBvaW50MS5jb2x1bW4gPCBwb2ludDIuY29sdW1uOwogICAgICAgIHJldHVybiAocG9pbnQxLnJvdyA8IHBvaW50Mi5yb3cpIHx8IChwb2ludDEucm93ID09IHBvaW50Mi5yb3cgJiYgYkNvbElzQWZ0ZXIpOwogICAgfQogICAgICAgICAgICAKICAgIGZ1bmN0aW9uICRnZXRUcmFuc2Zvcm1lZFBvaW50KGRlbHRhLCBwb2ludCwgbW92ZUlmRXF1YWwpIHsKICAgICAgICB2YXIgZGVsdGFJc0luc2VydCA9IGRlbHRhLmFjdGlvbiA9PSAiaW5zZXJ0IjsKICAgICAgICB2YXIgZGVsdGFSb3dTaGlmdCA9IChkZWx0YUlzSW5zZXJ0ID8gMSA6IC0xKSAqIChkZWx0YS5lbmQucm93ICAgIC0gZGVsdGEuc3RhcnQucm93KTsKICAgICAgICB2YXIgZGVsdGFDb2xTaGlmdCA9IChkZWx0YUlzSW5zZXJ0ID8gMSA6IC0xKSAqIChkZWx0YS5lbmQuY29sdW1uIC0gZGVsdGEuc3RhcnQuY29sdW1uKTsKICAgICAgICB2YXIgZGVsdGFTdGFydCA9IGRlbHRhLnN0YXJ0OwogICAgICAgIHZhciBkZWx0YUVuZCA9IGRlbHRhSXNJbnNlcnQgPyBkZWx0YVN0YXJ0IDogZGVsdGEuZW5kOyAvLyBDb2xsYXBzZSBpbnNlcnQgcmFuZ2UuCiAgICAgICAgaWYgKCRwb2ludHNJbk9yZGVyKHBvaW50LCBkZWx0YVN0YXJ0LCBtb3ZlSWZFcXVhbCkpIHsKICAgICAgICAgICAgcmV0dXJuIHsKICAgICAgICAgICAgICAgIHJvdzogcG9pbnQucm93LAogICAgICAgICAgICAgICAgY29sdW1uOiBwb2ludC5jb2x1bW4KICAgICAgICAgICAgfTsKICAgICAgICB9CiAgICAgICAgaWYgKCRwb2ludHNJbk9yZGVyKGRlbHRhRW5kLCBwb2ludCwgIW1vdmVJZkVxdWFsKSkgewogICAgICAgICAgICByZXR1cm4gewogICAgICAgICAgICAgICAgcm93OiBwb2ludC5yb3cgKyBkZWx0YVJvd1NoaWZ0LAogICAgICAgICAgICAgICAgY29sdW1uOiBwb2ludC5jb2x1bW4gKyAocG9pbnQucm93ID09IGRlbHRhRW5kLnJvdyA/IGRlbHRhQ29sU2hpZnQgOiAwKQogICAgICAgICAgICB9OwogICAgICAgIH0KICAgICAgICAKICAgICAgICByZXR1cm4gewogICAgICAgICAgICByb3c6IGRlbHRhU3RhcnQucm93LAogICAgICAgICAgICBjb2x1bW46IGRlbHRhU3RhcnQuY29sdW1uCiAgICAgICAgfTsKICAgIH0KICAgIHRoaXMuc2V0UG9zaXRpb24gPSBmdW5jdGlvbihyb3csIGNvbHVtbiwgbm9DbGlwKSB7CiAgICAgICAgdmFyIHBvczsKICAgICAgICBpZiAobm9DbGlwKSB7CiAgICAgICAgICAgIHBvcyA9IHsKICAgICAgICAgICAgICAgIHJvdzogcm93LAogICAgICAgICAgICAgICAgY29sdW1uOiBjb2x1bW4KICAgICAgICAgICAgfTsKICAgICAgICB9IGVsc2UgewogICAgICAgICAgICBwb3MgPSB0aGlzLiRjbGlwUG9zaXRpb25Ub0RvY3VtZW50KHJvdywgY29sdW1uKTsKICAgICAgICB9CgogICAgICAgIGlmICh0aGlzLnJvdyA9PSBwb3Mucm93ICYmIHRoaXMuY29sdW1uID09IHBvcy5jb2x1bW4pCiAgICAgICAgICAgIHJldHVybjsKCiAgICAgICAgdmFyIG9sZCA9IHsKICAgICAgICAgICAgcm93OiB0aGlzLnJvdywKICAgICAgICAgICAgY29sdW1uOiB0aGlzLmNvbHVtbgogICAgICAgIH07CgogICAgICAgIHRoaXMucm93ID0gcG9zLnJvdzsKICAgICAgICB0aGlzLmNvbHVtbiA9IHBvcy5jb2x1bW47CiAgICAgICAgdGhpcy5fc2lnbmFsKCJjaGFuZ2UiLCB7CiAgICAgICAgICAgIG9sZDogb2xkLAogICAgICAgICAgICB2YWx1ZTogcG9zCiAgICAgICAgfSk7CiAgICB9OwogICAgdGhpcy5kZXRhY2ggPSBmdW5jdGlvbigpIHsKICAgICAgICB0aGlzLmRvY3VtZW50LnJlbW92ZUV2ZW50TGlzdGVuZXIoImNoYW5nZSIsIHRoaXMuJG9uQ2hhbmdlKTsKICAgIH07CiAgICB0aGlzLmF0dGFjaCA9IGZ1bmN0aW9uKGRvYykgewogICAgICAgIHRoaXMuZG9jdW1lbnQgPSBkb2MgfHwgdGhpcy5kb2N1bWVudDsKICAgICAgICB0aGlzLmRvY3VtZW50Lm9uKCJjaGFuZ2UiLCB0aGlzLiRvbkNoYW5nZSk7CiAgICB9OwogICAgdGhpcy4kY2xpcFBvc2l0aW9uVG9Eb2N1bWVudCA9IGZ1bmN0aW9uKHJvdywgY29sdW1uKSB7CiAgICAgICAgdmFyIHBvcyA9IHt9OwoKICAgICAgICBpZiAocm93ID49IHRoaXMuZG9jdW1lbnQuZ2V0TGVuZ3RoKCkpIHsKICAgICAgICAgICAgcG9zLnJvdyA9IE1hdGgubWF4KDAsIHRoaXMuZG9jdW1lbnQuZ2V0TGVuZ3RoKCkgLSAxKTsKICAgICAgICAgICAgcG9zLmNvbHVtbiA9IHRoaXMuZG9jdW1lbnQuZ2V0TGluZShwb3Mucm93KS5sZW5ndGg7CiAgICAgICAgfQogICAgICAgIGVsc2UgaWYgKHJvdyA8IDApIHsKICAgICAgICAgICAgcG9zLnJvdyA9IDA7CiAgICAgICAgICAgIHBvcy5jb2x1bW4gPSAwOwogICAgICAgIH0KICAgICAgICBlbHNlIHsKICAgICAgICAgICAgcG9zLnJvdyA9IHJvdzsKICAgICAgICAgICAgcG9zLmNvbHVtbiA9IE1hdGgubWluKHRoaXMuZG9jdW1lbnQuZ2V0TGluZShwb3Mucm93KS5sZW5ndGgsIE1hdGgubWF4KDAsIGNvbHVtbikpOwogICAgICAgIH0KCiAgICAgICAgaWYgKGNvbHVtbiA8IDApCiAgICAgICAgICAgIHBvcy5jb2x1bW4gPSAwOwoKICAgICAgICByZXR1cm4gcG9zOwogICAgfTsKCn0pLmNhbGwoQW5jaG9yLnByb3RvdHlwZSk7Cgp9KTsKCmFjZS5kZWZpbmUoImFjZS9kb2N1bWVudCIsW10sIGZ1bmN0aW9uKHJlcXVpcmUsIGV4cG9ydHMsIG1vZHVsZSkgewoidXNlIHN0cmljdCI7Cgp2YXIgb29wID0gcmVxdWlyZSgiLi9saWIvb29wIik7CnZhciBhcHBseURlbHRhID0gcmVxdWlyZSgiLi9hcHBseV9kZWx0YSIpLmFwcGx5RGVsdGE7CnZhciBFdmVudEVtaXR0ZXIgPSByZXF1aXJlKCIuL2xpYi9ldmVudF9lbWl0dGVyIikuRXZlbnRFbWl0dGVyOwp2YXIgUmFuZ2UgPSByZXF1aXJlKCIuL3JhbmdlIikuUmFuZ2U7CnZhciBBbmNob3IgPSByZXF1aXJlKCIuL2FuY2hvciIpLkFuY2hvcjsKCnZhciBEb2N1bWVudCA9IGZ1bmN0aW9uKHRleHRPckxpbmVzKSB7CiAgICB0aGlzLiRsaW5lcyA9IFsiIl07CiAgICBpZiAodGV4dE9yTGluZXMubGVuZ3RoID09PSAwKSB7CiAgICAgICAgdGhpcy4kbGluZXMgPSBbIiJdOwogICAgfSBlbHNlIGlmIChBcnJheS5pc0FycmF5KHRleHRPckxpbmVzKSkgewogICAgICAgIHRoaXMuaW5zZXJ0TWVyZ2VkTGluZXMoe3JvdzogMCwgY29sdW1uOiAwfSwgdGV4dE9yTGluZXMpOwogICAgfSBlbHNlIHsKICAgICAgICB0aGlzLmluc2VydCh7cm93OiAwLCBjb2x1bW46MH0sIHRleHRPckxpbmVzKTsKICAgIH0KfTsKCihmdW5jdGlvbigpIHsKCiAgICBvb3AuaW1wbGVtZW50KHRoaXMsIEV2ZW50RW1pdHRlcik7CiAgICB0aGlzLnNldFZhbHVlID0gZnVuY3Rpb24odGV4dCkgewogICAgICAgIHZhciBsZW4gPSB0aGlzLmdldExlbmd0aCgpIC0gMTsKICAgICAgICB0aGlzLnJlbW92ZShuZXcgUmFuZ2UoMCwgMCwgbGVuLCB0aGlzLmdldExpbmUobGVuKS5sZW5ndGgpKTsKICAgICAgICB0aGlzLmluc2VydCh7cm93OiAwLCBjb2x1bW46IDB9LCB0ZXh0KTsKICAgIH07CiAgICB0aGlzLmdldFZhbHVlID0gZnVuY3Rpb24oKSB7CiAgICAgICAgcmV0dXJuIHRoaXMuZ2V0QWxsTGluZXMoKS5qb2luKHRoaXMuZ2V0TmV3TGluZUNoYXJhY3RlcigpKTsKICAgIH07CiAgICB0aGlzLmNyZWF0ZUFuY2hvciA9IGZ1bmN0aW9uKHJvdywgY29sdW1uKSB7CiAgICAgICAgcmV0dXJuIG5ldyBBbmNob3IodGhpcywgcm93LCBjb2x1bW4pOwogICAgfTsKICAgIGlmICgiYWFhIi5zcGxpdCgvYS8pLmxlbmd0aCA9PT0gMCkgewogICAgICAgIHRoaXMuJHNwbGl0ID0gZnVuY3Rpb24odGV4dCkgewogICAgICAgICAgICByZXR1cm4gdGV4dC5yZXBsYWNlKC9cclxufFxyL2csICJcbiIpLnNwbGl0KCJcbiIpOwogICAgICAgIH07CiAgICB9IGVsc2UgewogICAgICAgIHRoaXMuJHNwbGl0ID0gZnVuY3Rpb24odGV4dCkgewogICAgICAgICAgICByZXR1cm4gdGV4dC5zcGxpdCgvXHJcbnxccnxcbi8pOwogICAgICAgIH07CiAgICB9CgoKICAgIHRoaXMuJGRldGVjdE5ld0xpbmUgPSBmdW5jdGlvbih0ZXh0KSB7CiAgICAgICAgdmFyIG1hdGNoID0gdGV4dC5tYXRjaCgvXi4qPyhcclxufFxyfFxuKS9tKTsKICAgICAgICB0aGlzLiRhdXRvTmV3TGluZSA9IG1hdGNoID8gbWF0Y2hbMV0gOiAiXG4iOwogICAgICAgIHRoaXMuX3NpZ25hbCgiY2hhbmdlTmV3TGluZU1vZGUiKTsKICAgIH07CiAgICB0aGlzLmdldE5ld0xpbmVDaGFyYWN0ZXIgPSBmdW5jdGlvbigpIHsKICAgICAgICBzd2l0Y2ggKHRoaXMuJG5ld0xpbmVNb2RlKSB7CiAgICAgICAgICBjYXNlICJ3aW5kb3dzIjoKICAgICAgICAgICAgcmV0dXJuICJcclxuIjsKICAgICAgICAgIGNhc2UgInVuaXgiOgogICAgICAgICAgICByZXR1cm4gIlxuIjsKICAgICAgICAgIGRlZmF1bHQ6CiAgICAgICAgICAgIHJldHVybiB0aGlzLiRhdXRvTmV3TGluZSB8fCAiXG4iOwogICAgICAgIH0KICAgIH07CgogICAgdGhpcy4kYXV0b05ld0xpbmUgPSAiIjsKICAgIHRoaXMuJG5ld0xpbmVNb2RlID0gImF1dG8iOwogICAgdGhpcy5zZXROZXdMaW5lTW9kZSA9IGZ1bmN0aW9uKG5ld0xpbmVNb2RlKSB7CiAgICAgICAgaWYgKHRoaXMuJG5ld0xpbmVNb2RlID09PSBuZXdMaW5lTW9kZSkKICAgICAgICAgICAgcmV0dXJuOwoKICAgICAgICB0aGlzLiRuZXdMaW5lTW9kZSA9IG5ld0xpbmVNb2RlOwogICAgICAgIHRoaXMuX3NpZ25hbCgiY2hhbmdlTmV3TGluZU1vZGUiKTsKICAgIH07CiAgICB0aGlzLmdldE5ld0xpbmVNb2RlID0gZnVuY3Rpb24oKSB7CiAgICAgICAgcmV0dXJuIHRoaXMuJG5ld0xpbmVNb2RlOwogICAgfTsKICAgIHRoaXMuaXNOZXdMaW5lID0gZnVuY3Rpb24odGV4dCkgewogICAgICAgIHJldHVybiAodGV4dCA9PSAiXHJcbiIgfHwgdGV4dCA9PSAiXHIiIHx8IHRleHQgPT0gIlxuIik7CiAgICB9OwogICAgdGhpcy5nZXRMaW5lID0gZnVuY3Rpb24ocm93KSB7CiAgICAgICAgcmV0dXJuIHRoaXMuJGxpbmVzW3Jvd10gfHwgIiI7CiAgICB9OwogICAgdGhpcy5nZXRMaW5lcyA9IGZ1bmN0aW9uKGZpcnN0Um93LCBsYXN0Um93KSB7CiAgICAgICAgcmV0dXJuIHRoaXMuJGxpbmVzLnNsaWNlKGZpcnN0Um93LCBsYXN0Um93ICsgMSk7CiAgICB9OwogICAgdGhpcy5nZXRBbGxMaW5lcyA9IGZ1bmN0aW9uKCkgewogICAgICAgIHJldHVybiB0aGlzLmdldExpbmVzKDAsIHRoaXMuZ2V0TGVuZ3RoKCkpOwogICAgfTsKICAgIHRoaXMuZ2V0TGVuZ3RoID0gZnVuY3Rpb24oKSB7CiAgICAgICAgcmV0dXJuIHRoaXMuJGxpbmVzLmxlbmd0aDsKICAgIH07CiAgICB0aGlzLmdldFRleHRSYW5nZSA9IGZ1bmN0aW9uKHJhbmdlKSB7CiAgICAgICAgcmV0dXJuIHRoaXMuZ2V0TGluZXNGb3JSYW5nZShyYW5nZSkuam9pbih0aGlzLmdldE5ld0xpbmVDaGFyYWN0ZXIoKSk7CiAgICB9OwogICAgdGhpcy5nZXRMaW5lc0ZvclJhbmdlID0gZnVuY3Rpb24ocmFuZ2UpIHsKICAgICAgICB2YXIgbGluZXM7CiAgICAgICAgaWYgKHJhbmdlLnN0YXJ0LnJvdyA9PT0gcmFuZ2UuZW5kLnJvdykgewogICAgICAgICAgICBsaW5lcyA9IFt0aGlzLmdldExpbmUocmFuZ2Uuc3RhcnQucm93KS5zdWJzdHJpbmcocmFuZ2Uuc3RhcnQuY29sdW1uLCByYW5nZS5lbmQuY29sdW1uKV07CiAgICAgICAgfSBlbHNlIHsKICAgICAgICAgICAgbGluZXMgPSB0aGlzLmdldExpbmVzKHJhbmdlLnN0YXJ0LnJvdywgcmFuZ2UuZW5kLnJvdyk7CiAgICAgICAgICAgIGxpbmVzWzBdID0gKGxpbmVzWzBdIHx8ICIiKS5zdWJzdHJpbmcocmFuZ2Uuc3RhcnQuY29sdW1uKTsKICAgICAgICAgICAgdmFyIGwgPSBsaW5lcy5sZW5ndGggLSAxOwogICAgICAgICAgICBpZiAocmFuZ2UuZW5kLnJvdyAtIHJhbmdlLnN0YXJ0LnJvdyA9PSBsKQogICAgICAgICAgICAgICAgbGluZXNbbF0gPSBsaW5lc1tsXS5zdWJzdHJpbmcoMCwgcmFuZ2UuZW5kLmNvbHVtbik7CiAgICAgICAgfQogICAgICAgIHJldHVybiBsaW5lczsKICAgIH07CiAgICB0aGlzLmluc2VydExpbmVzID0gZnVuY3Rpb24ocm93LCBsaW5lcykgewogICAgICAgIGNvbnNvbGUud2FybigiVXNlIG9mIGRvY3VtZW50Lmluc2VydExpbmVzIGlzIGRlcHJlY2F0ZWQuIFVzZSB0aGUgaW5zZXJ0RnVsbExpbmVzIG1ldGhvZCBpbnN0ZWFkLiIpOwogICAgICAgIHJldHVybiB0aGlzLmluc2VydEZ1bGxMaW5lcyhyb3csIGxpbmVzKTsKICAgIH07CiAgICB0aGlzLnJlbW92ZUxpbmVzID0gZnVuY3Rpb24oZmlyc3RSb3csIGxhc3RSb3cpIHsKICAgICAgICBjb25zb2xlLndhcm4oIlVzZSBvZiBkb2N1bWVudC5yZW1vdmVMaW5lcyBpcyBkZXByZWNhdGVkLiBVc2UgdGhlIHJlbW92ZUZ1bGxMaW5lcyBtZXRob2QgaW5zdGVhZC4iKTsKICAgICAgICByZXR1cm4gdGhpcy5yZW1vdmVGdWxsTGluZXMoZmlyc3RSb3csIGxhc3RSb3cpOwogICAgfTsKICAgIHRoaXMuaW5zZXJ0TmV3TGluZSA9IGZ1bmN0aW9uKHBvc2l0aW9uKSB7CiAgICAgICAgY29uc29sZS53YXJuKCJVc2Ugb2YgZG9jdW1lbnQuaW5zZXJ0TmV3TGluZSBpcyBkZXByZWNhdGVkLiBVc2UgaW5zZXJ0TWVyZ2VkTGluZXMocG9zaXRpb24sIFsnJywgJyddKSBpbnN0ZWFkLiIpOwogICAgICAgIHJldHVybiB0aGlzLmluc2VydE1lcmdlZExpbmVzKHBvc2l0aW9uLCBbIiIsICIiXSk7CiAgICB9OwogICAgdGhpcy5pbnNlcnQgPSBmdW5jdGlvbihwb3NpdGlvbiwgdGV4dCkgewogICAgICAgIGlmICh0aGlzLmdldExlbmd0aCgpIDw9IDEpCiAgICAgICAgICAgIHRoaXMuJGRldGVjdE5ld0xpbmUodGV4dCk7CiAgICAgICAgCiAgICAgICAgcmV0dXJuIHRoaXMuaW5zZXJ0TWVyZ2VkTGluZXMocG9zaXRpb24sIHRoaXMuJHNwbGl0KHRleHQpKTsKICAgIH07CiAgICB0aGlzLmluc2VydEluTGluZSA9IGZ1bmN0aW9uKHBvc2l0aW9uLCB0ZXh0KSB7CiAgICAgICAgdmFyIHN0YXJ0ID0gdGhpcy5jbGlwcGVkUG9zKHBvc2l0aW9uLnJvdywgcG9zaXRpb24uY29sdW1uKTsKICAgICAgICB2YXIgZW5kID0gdGhpcy5wb3MocG9zaXRpb24ucm93LCBwb3NpdGlvbi5jb2x1bW4gKyB0ZXh0Lmxlbmd0aCk7CiAgICAgICAgCiAgICAgICAgdGhpcy5hcHBseURlbHRhKHsKICAgICAgICAgICAgc3RhcnQ6IHN0YXJ0LAogICAgICAgICAgICBlbmQ6IGVuZCwKICAgICAgICAgICAgYWN0aW9uOiAiaW5zZXJ0IiwKICAgICAgICAgICAgbGluZXM6IFt0ZXh0XQogICAgICAgIH0sIHRydWUpOwogICAgICAgIAogICAgICAgIHJldHVybiB0aGlzLmNsb25lUG9zKGVuZCk7CiAgICB9OwogICAgCiAgICB0aGlzLmNsaXBwZWRQb3MgPSBmdW5jdGlvbihyb3csIGNvbHVtbikgewogICAgICAgIHZhciBsZW5ndGggPSB0aGlzLmdldExlbmd0aCgpOwogICAgICAgIGlmIChyb3cgPT09IHVuZGVmaW5lZCkgewogICAgICAgICAgICByb3cgPSBsZW5ndGg7CiAgICAgICAgfSBlbHNlIGlmIChyb3cgPCAwKSB7CiAgICAgICAgICAgIHJvdyA9IDA7CiAgICAgICAgfSBlbHNlIGlmIChyb3cgPj0gbGVuZ3RoKSB7CiAgICAgICAgICAgIHJvdyA9IGxlbmd0aCAtIDE7CiAgICAgICAgICAgIGNvbHVtbiA9IHVuZGVmaW5lZDsKICAgICAgICB9CiAgICAgICAgdmFyIGxpbmUgPSB0aGlzLmdldExpbmUocm93KTsKICAgICAgICBpZiAoY29sdW1uID09IHVuZGVmaW5lZCkKICAgICAgICAgICAgY29sdW1uID0gbGluZS5sZW5ndGg7CiAgICAgICAgY29sdW1uID0gTWF0aC5taW4oTWF0aC5tYXgoY29sdW1uLCAwKSwgbGluZS5sZW5ndGgpOwogICAgICAgIHJldHVybiB7cm93OiByb3csIGNvbHVtbjogY29sdW1ufTsKICAgIH07CiAgICAKICAgIHRoaXMuY2xvbmVQb3MgPSBmdW5jdGlvbihwb3MpIHsKICAgICAgICByZXR1cm4ge3JvdzogcG9zLnJvdywgY29sdW1uOiBwb3MuY29sdW1ufTsKICAgIH07CiAgICAKICAgIHRoaXMucG9zID0gZnVuY3Rpb24ocm93LCBjb2x1bW4pIHsKICAgICAgICByZXR1cm4ge3Jvdzogcm93LCBjb2x1bW46IGNvbHVtbn07CiAgICB9OwogICAgCiAgICB0aGlzLiRjbGlwUG9zaXRpb24gPSBmdW5jdGlvbihwb3NpdGlvbikgewogICAgICAgIHZhciBsZW5ndGggPSB0aGlzLmdldExlbmd0aCgpOwogICAgICAgIGlmIChwb3NpdGlvbi5yb3cgPj0gbGVuZ3RoKSB7CiAgICAgICAgICAgIHBvc2l0aW9uLnJvdyA9IE1hdGgubWF4KDAsIGxlbmd0aCAtIDEpOwogICAgICAgICAgICBwb3NpdGlvbi5jb2x1bW4gPSB0aGlzLmdldExpbmUobGVuZ3RoIC0gMSkubGVuZ3RoOwogICAgICAgIH0gZWxzZSB7CiAgICAgICAgICAgIHBvc2l0aW9uLnJvdyA9IE1hdGgubWF4KDAsIHBvc2l0aW9uLnJvdyk7CiAgICAgICAgICAgIHBvc2l0aW9uLmNvbHVtbiA9IE1hdGgubWluKE1hdGgubWF4KHBvc2l0aW9uLmNvbHVtbiwgMCksIHRoaXMuZ2V0TGluZShwb3NpdGlvbi5yb3cpLmxlbmd0aCk7CiAgICAgICAgfQogICAgICAgIHJldHVybiBwb3NpdGlvbjsKICAgIH07CiAgICB0aGlzLmluc2VydEZ1bGxMaW5lcyA9IGZ1bmN0aW9uKHJvdywgbGluZXMpIHsKICAgICAgICByb3cgPSBNYXRoLm1pbihNYXRoLm1heChyb3csIDApLCB0aGlzLmdldExlbmd0aCgpKTsKICAgICAgICB2YXIgY29sdW1uID0gMDsKICAgICAgICBpZiAocm93IDwgdGhpcy5nZXRMZW5ndGgoKSkgewogICAgICAgICAgICBsaW5lcyA9IGxpbmVzLmNvbmNhdChbIiJdKTsKICAgICAgICAgICAgY29sdW1uID0gMDsKICAgICAgICB9IGVsc2UgewogICAgICAgICAgICBsaW5lcyA9IFsiIl0uY29uY2F0KGxpbmVzKTsKICAgICAgICAgICAgcm93LS07CiAgICAgICAgICAgIGNvbHVtbiA9IHRoaXMuJGxpbmVzW3Jvd10ubGVuZ3RoOwogICAgICAgIH0KICAgICAgICB0aGlzLmluc2VydE1lcmdlZExpbmVzKHtyb3c6IHJvdywgY29sdW1uOiBjb2x1bW59LCBsaW5lcyk7CiAgICB9OyAgICAKICAgIHRoaXMuaW5zZXJ0TWVyZ2VkTGluZXMgPSBmdW5jdGlvbihwb3NpdGlvbiwgbGluZXMpIHsKICAgICAgICB2YXIgc3RhcnQgPSB0aGlzLmNsaXBwZWRQb3MocG9zaXRpb24ucm93LCBwb3NpdGlvbi5jb2x1bW4pOwogICAgICAgIHZhciBlbmQgPSB7CiAgICAgICAgICAgIHJvdzogc3RhcnQucm93ICsgbGluZXMubGVuZ3RoIC0gMSwKICAgICAgICAgICAgY29sdW1uOiAobGluZXMubGVuZ3RoID09IDEgPyBzdGFydC5jb2x1bW4gOiAwKSArIGxpbmVzW2xpbmVzLmxlbmd0aCAtIDFdLmxlbmd0aAogICAgICAgIH07CiAgICAgICAgCiAgICAgICAgdGhpcy5hcHBseURlbHRhKHsKICAgICAgICAgICAgc3RhcnQ6IHN0YXJ0LAogICAgICAgICAgICBlbmQ6IGVuZCwKICAgICAgICAgICAgYWN0aW9uOiAiaW5zZXJ0IiwKICAgICAgICAgICAgbGluZXM6IGxpbmVzCiAgICAgICAgfSk7CiAgICAgICAgCiAgICAgICAgcmV0dXJuIHRoaXMuY2xvbmVQb3MoZW5kKTsKICAgIH07CiAgICB0aGlzLnJlbW92ZSA9IGZ1bmN0aW9uKHJhbmdlKSB7CiAgICAgICAgdmFyIHN0YXJ0ID0gdGhpcy5jbGlwcGVkUG9zKHJhbmdlLnN0YXJ0LnJvdywgcmFuZ2Uuc3RhcnQuY29sdW1uKTsKICAgICAgICB2YXIgZW5kID0gdGhpcy5jbGlwcGVkUG9zKHJhbmdlLmVuZC5yb3csIHJhbmdlLmVuZC5jb2x1bW4pOwogICAgICAgIHRoaXMuYXBwbHlEZWx0YSh7CiAgICAgICAgICAgIHN0YXJ0OiBzdGFydCwKICAgICAgICAgICAgZW5kOiBlbmQsCiAgICAgICAgICAgIGFjdGlvbjogInJlbW92ZSIsCiAgICAgICAgICAgIGxpbmVzOiB0aGlzLmdldExpbmVzRm9yUmFuZ2Uoe3N0YXJ0OiBzdGFydCwgZW5kOiBlbmR9KQogICAgICAgIH0pOwogICAgICAgIHJldHVybiB0aGlzLmNsb25lUG9zKHN0YXJ0KTsKICAgIH07CiAgICB0aGlzLnJlbW92ZUluTGluZSA9IGZ1bmN0aW9uKHJvdywgc3RhcnRDb2x1bW4sIGVuZENvbHVtbikgewogICAgICAgIHZhciBzdGFydCA9IHRoaXMuY2xpcHBlZFBvcyhyb3csIHN0YXJ0Q29sdW1uKTsKICAgICAgICB2YXIgZW5kID0gdGhpcy5jbGlwcGVkUG9zKHJvdywgZW5kQ29sdW1uKTsKICAgICAgICAKICAgICAgICB0aGlzLmFwcGx5RGVsdGEoewogICAgICAgICAgICBzdGFydDogc3RhcnQsCiAgICAgICAgICAgIGVuZDogZW5kLAogICAgICAgICAgICBhY3Rpb246ICJyZW1vdmUiLAogICAgICAgICAgICBsaW5lczogdGhpcy5nZXRMaW5lc0ZvclJhbmdlKHtzdGFydDogc3RhcnQsIGVuZDogZW5kfSkKICAgICAgICB9LCB0cnVlKTsKICAgICAgICAKICAgICAgICByZXR1cm4gdGhpcy5jbG9uZVBvcyhzdGFydCk7CiAgICB9OwogICAgdGhpcy5yZW1vdmVGdWxsTGluZXMgPSBmdW5jdGlvbihmaXJzdFJvdywgbGFzdFJvdykgewogICAgICAgIGZpcnN0Um93ID0gTWF0aC5taW4oTWF0aC5tYXgoMCwgZmlyc3RSb3cpLCB0aGlzLmdldExlbmd0aCgpIC0gMSk7CiAgICAgICAgbGFzdFJvdyAgPSBNYXRoLm1pbihNYXRoLm1heCgwLCBsYXN0Um93ICksIHRoaXMuZ2V0TGVuZ3RoKCkgLSAxKTsKICAgICAgICB2YXIgZGVsZXRlRmlyc3ROZXdMaW5lID0gbGFzdFJvdyA9PSB0aGlzLmdldExlbmd0aCgpIC0gMSAmJiBmaXJzdFJvdyA+IDA7CiAgICAgICAgdmFyIGRlbGV0ZUxhc3ROZXdMaW5lICA9IGxhc3RSb3cgIDwgdGhpcy5nZXRMZW5ndGgoKSAtIDE7CiAgICAgICAgdmFyIHN0YXJ0Um93ID0gKCBkZWxldGVGaXJzdE5ld0xpbmUgPyBmaXJzdFJvdyAtIDEgICAgICAgICAgICAgICAgICA6IGZpcnN0Um93ICAgICAgICAgICAgICAgICAgICApOwogICAgICAgIHZhciBzdGFydENvbCA9ICggZGVsZXRlRmlyc3ROZXdMaW5lID8gdGhpcy5nZXRMaW5lKHN0YXJ0Um93KS5sZW5ndGggOiAwICAgICAgICAgICAgICAgICAgICAgICAgICAgKTsKICAgICAgICB2YXIgZW5kUm93ICAgPSAoIGRlbGV0ZUxhc3ROZXdMaW5lICA/IGxhc3RSb3cgKyAxICAgICAgICAgICAgICAgICAgIDogbGFzdFJvdyAgICAgICAgICAgICAgICAgICAgICk7CiAgICAgICAgdmFyIGVuZENvbCAgID0gKCBkZWxldGVMYXN0TmV3TGluZSAgPyAwICAgICAgICAgICAgICAgICAgICAgICAgICAgICA6IHRoaXMuZ2V0TGluZShlbmRSb3cpLmxlbmd0aCApOyAKICAgICAgICB2YXIgcmFuZ2UgPSBuZXcgUmFuZ2Uoc3RhcnRSb3csIHN0YXJ0Q29sLCBlbmRSb3csIGVuZENvbCk7CiAgICAgICAgdmFyIGRlbGV0ZWRMaW5lcyA9IHRoaXMuJGxpbmVzLnNsaWNlKGZpcnN0Um93LCBsYXN0Um93ICsgMSk7CiAgICAgICAgCiAgICAgICAgdGhpcy5hcHBseURlbHRhKHsKICAgICAgICAgICAgc3RhcnQ6IHJhbmdlLnN0YXJ0LAogICAgICAgICAgICBlbmQ6IHJhbmdlLmVuZCwKICAgICAgICAgICAgYWN0aW9uOiAicmVtb3ZlIiwKICAgICAgICAgICAgbGluZXM6IHRoaXMuZ2V0TGluZXNGb3JSYW5nZShyYW5nZSkKICAgICAgICB9KTsKICAgICAgICByZXR1cm4gZGVsZXRlZExpbmVzOwogICAgfTsKICAgIHRoaXMucmVtb3ZlTmV3TGluZSA9IGZ1bmN0aW9uKHJvdykgewogICAgICAgIGlmIChyb3cgPCB0aGlzLmdldExlbmd0aCgpIC0gMSAmJiByb3cgPj0gMCkgewogICAgICAgICAgICB0aGlzLmFwcGx5RGVsdGEoewogICAgICAgICAgICAgICAgc3RhcnQ6IHRoaXMucG9zKHJvdywgdGhpcy5nZXRMaW5lKHJvdykubGVuZ3RoKSwKICAgICAgICAgICAgICAgIGVuZDogdGhpcy5wb3Mocm93ICsgMSwgMCksCiAgICAgICAgICAgICAgICBhY3Rpb246ICJyZW1vdmUiLAogICAgICAgICAgICAgICAgbGluZXM6IFsiIiwgIiJdCiAgICAgICAgICAgIH0pOwogICAgICAgIH0KICAgIH07CiAgICB0aGlzLnJlcGxhY2UgPSBmdW5jdGlvbihyYW5nZSwgdGV4dCkgewogICAgICAgIGlmICghKHJhbmdlIGluc3RhbmNlb2YgUmFuZ2UpKQogICAgICAgICAgICByYW5nZSA9IFJhbmdlLmZyb21Qb2ludHMocmFuZ2Uuc3RhcnQsIHJhbmdlLmVuZCk7CiAgICAgICAgaWYgKHRleHQubGVuZ3RoID09PSAwICYmIHJhbmdlLmlzRW1wdHkoKSkKICAgICAgICAgICAgcmV0dXJuIHJhbmdlLnN0YXJ0OwogICAgICAgIGlmICh0ZXh0ID09IHRoaXMuZ2V0VGV4dFJhbmdlKHJhbmdlKSkKICAgICAgICAgICAgcmV0dXJuIHJhbmdlLmVuZDsKCiAgICAgICAgdGhpcy5yZW1vdmUocmFuZ2UpOwogICAgICAgIHZhciBlbmQ7CiAgICAgICAgaWYgKHRleHQpIHsKICAgICAgICAgICAgZW5kID0gdGhpcy5pbnNlcnQocmFuZ2Uuc3RhcnQsIHRleHQpOwogICAgICAgIH0KICAgICAgICBlbHNlIHsKICAgICAgICAgICAgZW5kID0gcmFuZ2Uuc3RhcnQ7CiAgICAgICAgfQogICAgICAgIAogICAgICAgIHJldHVybiBlbmQ7CiAgICB9OwogICAgdGhpcy5hcHBseURlbHRhcyA9IGZ1bmN0aW9uKGRlbHRhcykgewogICAgICAgIGZvciAodmFyIGk9MDsgaTxkZWx0YXMubGVuZ3RoOyBpKyspIHsKICAgICAgICAgICAgdGhpcy5hcHBseURlbHRhKGRlbHRhc1tpXSk7CiAgICAgICAgfQogICAgfTsKICAgIHRoaXMucmV2ZXJ0RGVsdGFzID0gZnVuY3Rpb24oZGVsdGFzKSB7CiAgICAgICAgZm9yICh2YXIgaT1kZWx0YXMubGVuZ3RoLTE7IGk+PTA7IGktLSkgewogICAgICAgICAgICB0aGlzLnJldmVydERlbHRhKGRlbHRhc1tpXSk7CiAgICAgICAgfQogICAgfTsKICAgIHRoaXMuYXBwbHlEZWx0YSA9IGZ1bmN0aW9uKGRlbHRhLCBkb05vdFZhbGlkYXRlKSB7CiAgICAgICAgdmFyIGlzSW5zZXJ0ID0gZGVsdGEuYWN0aW9uID09ICJpbnNlcnQiOwogICAgICAgIGlmIChpc0luc2VydCA/IGRlbHRhLmxpbmVzLmxlbmd0aCA8PSAxICYmICFkZWx0YS5saW5lc1swXQogICAgICAgICAgICA6ICFSYW5nZS5jb21wYXJlUG9pbnRzKGRlbHRhLnN0YXJ0LCBkZWx0YS5lbmQpKSB7CiAgICAgICAgICAgIHJldHVybjsKICAgICAgICB9CiAgICAgICAgCiAgICAgICAgaWYgKGlzSW5zZXJ0ICYmIGRlbHRhLmxpbmVzLmxlbmd0aCA+IDIwMDAwKSB7CiAgICAgICAgICAgIHRoaXMuJHNwbGl0QW5kYXBwbHlMYXJnZURlbHRhKGRlbHRhLCAyMDAwMCk7CiAgICAgICAgfQogICAgICAgIGVsc2UgewogICAgICAgICAgICBhcHBseURlbHRhKHRoaXMuJGxpbmVzLCBkZWx0YSwgZG9Ob3RWYWxpZGF0ZSk7CiAgICAgICAgICAgIHRoaXMuX3NpZ25hbCgiY2hhbmdlIiwgZGVsdGEpOwogICAgICAgIH0KICAgIH07CiAgICAKICAgIHRoaXMuJHNwbGl0QW5kYXBwbHlMYXJnZURlbHRhID0gZnVuY3Rpb24oZGVsdGEsIE1BWCkgewogICAgICAgIHZhciBsaW5lcyA9IGRlbHRhLmxpbmVzOwogICAgICAgIHZhciBsID0gbGluZXMubGVuZ3RoIC0gTUFYICsgMTsKICAgICAgICB2YXIgcm93ID0gZGVsdGEuc3RhcnQucm93OyAKICAgICAgICB2YXIgY29sdW1uID0gZGVsdGEuc3RhcnQuY29sdW1uOwogICAgICAgIGZvciAodmFyIGZyb20gPSAwLCB0byA9IDA7IGZyb20gPCBsOyBmcm9tID0gdG8pIHsKICAgICAgICAgICAgdG8gKz0gTUFYIC0gMTsKICAgICAgICAgICAgdmFyIGNodW5rID0gbGluZXMuc2xpY2UoZnJvbSwgdG8pOwogICAgICAgICAgICBjaHVuay5wdXNoKCIiKTsKICAgICAgICAgICAgdGhpcy5hcHBseURlbHRhKHsKICAgICAgICAgICAgICAgIHN0YXJ0OiB0aGlzLnBvcyhyb3cgKyBmcm9tLCBjb2x1bW4pLAogICAgICAgICAgICAgICAgZW5kOiB0aGlzLnBvcyhyb3cgKyB0bywgY29sdW1uID0gMCksCiAgICAgICAgICAgICAgICBhY3Rpb246IGRlbHRhLmFjdGlvbiwKICAgICAgICAgICAgICAgIGxpbmVzOiBjaHVuawogICAgICAgICAgICB9LCB0cnVlKTsKICAgICAgICB9CiAgICAgICAgZGVsdGEubGluZXMgPSBsaW5lcy5zbGljZShmcm9tKTsKICAgICAgICBkZWx0YS5zdGFydC5yb3cgPSByb3cgKyBmcm9tOwogICAgICAgIGRlbHRhLnN0YXJ0LmNvbHVtbiA9IGNvbHVtbjsKICAgICAgICB0aGlzLmFwcGx5RGVsdGEoZGVsdGEsIHRydWUpOwogICAgfTsKICAgIHRoaXMucmV2ZXJ0RGVsdGEgPSBmdW5jdGlvbihkZWx0YSkgewogICAgICAgIHRoaXMuYXBwbHlEZWx0YSh7CiAgICAgICAgICAgIHN0YXJ0OiB0aGlzLmNsb25lUG9zKGRlbHRhLnN0YXJ0KSwKICAgICAgICAgICAgZW5kOiB0aGlzLmNsb25lUG9zKGRlbHRhLmVuZCksCiAgICAgICAgICAgIGFjdGlvbjogKGRlbHRhLmFjdGlvbiA9PSAiaW5zZXJ0IiA/ICJyZW1vdmUiIDogImluc2VydCIpLAogICAgICAgICAgICBsaW5lczogZGVsdGEubGluZXMuc2xpY2UoKQogICAgICAgIH0pOwogICAgfTsKICAgIHRoaXMuaW5kZXhUb1Bvc2l0aW9uID0gZnVuY3Rpb24oaW5kZXgsIHN0YXJ0Um93KSB7CiAgICAgICAgdmFyIGxpbmVzID0gdGhpcy4kbGluZXMgfHwgdGhpcy5nZXRBbGxMaW5lcygpOwogICAgICAgIHZhciBuZXdsaW5lTGVuZ3RoID0gdGhpcy5nZXROZXdMaW5lQ2hhcmFjdGVyKCkubGVuZ3RoOwogICAgICAgIGZvciAodmFyIGkgPSBzdGFydFJvdyB8fCAwLCBsID0gbGluZXMubGVuZ3RoOyBpIDwgbDsgaSsrKSB7CiAgICAgICAgICAgIGluZGV4IC09IGxpbmVzW2ldLmxlbmd0aCArIG5ld2xpbmVMZW5ndGg7CiAgICAgICAgICAgIGlmIChpbmRleCA8IDApCiAgICAgICAgICAgICAgICByZXR1cm4ge3JvdzogaSwgY29sdW1uOiBpbmRleCArIGxpbmVzW2ldLmxlbmd0aCArIG5ld2xpbmVMZW5ndGh9OwogICAgICAgIH0KICAgICAgICByZXR1cm4ge3JvdzogbC0xLCBjb2x1bW46IGluZGV4ICsgbGluZXNbbC0xXS5sZW5ndGggKyBuZXdsaW5lTGVuZ3RofTsKICAgIH07CiAgICB0aGlzLnBvc2l0aW9uVG9JbmRleCA9IGZ1bmN0aW9uKHBvcywgc3RhcnRSb3cpIHsKICAgICAgICB2YXIgbGluZXMgPSB0aGlzLiRsaW5lcyB8fCB0aGlzLmdldEFsbExpbmVzKCk7CiAgICAgICAgdmFyIG5ld2xpbmVMZW5ndGggPSB0aGlzLmdldE5ld0xpbmVDaGFyYWN0ZXIoKS5sZW5ndGg7CiAgICAgICAgdmFyIGluZGV4ID0gMDsKICAgICAgICB2YXIgcm93ID0gTWF0aC5taW4ocG9zLnJvdywgbGluZXMubGVuZ3RoKTsKICAgICAgICBmb3IgKHZhciBpID0gc3RhcnRSb3cgfHwgMDsgaSA8IHJvdzsgKytpKQogICAgICAgICAgICBpbmRleCArPSBsaW5lc1tpXS5sZW5ndGggKyBuZXdsaW5lTGVuZ3RoOwoKICAgICAgICByZXR1cm4gaW5kZXggKyBwb3MuY29sdW1uOwogICAgfTsKCn0pLmNhbGwoRG9jdW1lbnQucHJvdG90eXBlKTsKCmV4cG9ydHMuRG9jdW1lbnQgPSBEb2N1bWVudDsKfSk7CgphY2UuZGVmaW5lKCJhY2UvbGliL2xhbmciLFtdLCBmdW5jdGlvbihyZXF1aXJlLCBleHBvcnRzLCBtb2R1bGUpIHsKInVzZSBzdHJpY3QiOwoKZXhwb3J0cy5sYXN0ID0gZnVuY3Rpb24oYSkgewogICAgcmV0dXJuIGFbYS5sZW5ndGggLSAxXTsKfTsKCmV4cG9ydHMuc3RyaW5nUmV2ZXJzZSA9IGZ1bmN0aW9uKHN0cmluZykgewogICAgcmV0dXJuIHN0cmluZy5zcGxpdCgiIikucmV2ZXJzZSgpLmpvaW4oIiIpOwp9OwoKZXhwb3J0cy5zdHJpbmdSZXBlYXQgPSBmdW5jdGlvbiAoc3RyaW5nLCBjb3VudCkgewogICAgdmFyIHJlc3VsdCA9ICcnOwogICAgd2hpbGUgKGNvdW50ID4gMCkgewogICAgICAgIGlmIChjb3VudCAmIDEpCiAgICAgICAgICAgIHJlc3VsdCArPSBzdHJpbmc7CgogICAgICAgIGlmIChjb3VudCA+Pj0gMSkKICAgICAgICAgICAgc3RyaW5nICs9IHN0cmluZzsKICAgIH0KICAgIHJldHVybiByZXN1bHQ7Cn07Cgp2YXIgdHJpbUJlZ2luUmVnZXhwID0gL15cc1xzKi87CnZhciB0cmltRW5kUmVnZXhwID0gL1xzXHMqJC87CgpleHBvcnRzLnN0cmluZ1RyaW1MZWZ0ID0gZnVuY3Rpb24gKHN0cmluZykgewogICAgcmV0dXJuIHN0cmluZy5yZXBsYWNlKHRyaW1CZWdpblJlZ2V4cCwgJycpOwp9OwoKZXhwb3J0cy5zdHJpbmdUcmltUmlnaHQgPSBmdW5jdGlvbiAoc3RyaW5nKSB7CiAgICByZXR1cm4gc3RyaW5nLnJlcGxhY2UodHJpbUVuZFJlZ2V4cCwgJycpOwp9OwoKZXhwb3J0cy5jb3B5T2JqZWN0ID0gZnVuY3Rpb24ob2JqKSB7CiAgICB2YXIgY29weSA9IHt9OwogICAgZm9yICh2YXIga2V5IGluIG9iaikgewogICAgICAgIGNvcHlba2V5XSA9IG9ialtrZXldOwogICAgfQogICAgcmV0dXJuIGNvcHk7Cn07CgpleHBvcnRzLmNvcHlBcnJheSA9IGZ1bmN0aW9uKGFycmF5KXsKICAgIHZhciBjb3B5ID0gW107CiAgICBmb3IgKHZhciBpPTAsIGw9YXJyYXkubGVuZ3RoOyBpPGw7IGkrKykgewogICAgICAgIGlmIChhcnJheVtpXSAmJiB0eXBlb2YgYXJyYXlbaV0gPT0gIm9iamVjdCIpCiAgICAgICAgICAgIGNvcHlbaV0gPSB0aGlzLmNvcHlPYmplY3QoYXJyYXlbaV0pOwogICAgICAgIGVsc2UgCiAgICAgICAgICAgIGNvcHlbaV0gPSBhcnJheVtpXTsKICAgIH0KICAgIHJldHVybiBjb3B5Owp9OwoKZXhwb3J0cy5kZWVwQ29weSA9IGZ1bmN0aW9uIGRlZXBDb3B5KG9iaikgewogICAgaWYgKHR5cGVvZiBvYmogIT09ICJvYmplY3QiIHx8ICFvYmopCiAgICAgICAgcmV0dXJuIG9iajsKICAgIHZhciBjb3B5OwogICAgaWYgKEFycmF5LmlzQXJyYXkob2JqKSkgewogICAgICAgIGNvcHkgPSBbXTsKICAgICAgICBmb3IgKHZhciBrZXkgPSAwOyBrZXkgPCBvYmoubGVuZ3RoOyBrZXkrKykgewogICAgICAgICAgICBjb3B5W2tleV0gPSBkZWVwQ29weShvYmpba2V5XSk7CiAgICAgICAgfQogICAgICAgIHJldHVybiBjb3B5OwogICAgfQogICAgaWYgKE9iamVjdC5wcm90b3R5cGUudG9TdHJpbmcuY2FsbChvYmopICE9PSAiW29iamVjdCBPYmplY3RdIikKICAgICAgICByZXR1cm4gb2JqOwogICAgCiAgICBjb3B5ID0ge307CiAgICBmb3IgKHZhciBrZXkgaW4gb2JqKQogICAgICAgIGNvcHlba2V5XSA9IGRlZXBDb3B5KG9ialtrZXldKTsKICAgIHJldHVybiBjb3B5Owp9OwoKZXhwb3J0cy5hcnJheVRvTWFwID0gZnVuY3Rpb24oYXJyKSB7CiAgICB2YXIgbWFwID0ge307CiAgICBmb3IgKHZhciBpPTA7IGk8YXJyLmxlbmd0aDsgaSsrKSB7CiAgICAgICAgbWFwW2FycltpXV0gPSAxOwogICAgfQogICAgcmV0dXJuIG1hcDsKCn07CgpleHBvcnRzLmNyZWF0ZU1hcCA9IGZ1bmN0aW9uKHByb3BzKSB7CiAgICB2YXIgbWFwID0gT2JqZWN0LmNyZWF0ZShudWxsKTsKICAgIGZvciAodmFyIGkgaW4gcHJvcHMpIHsKICAgICAgICBtYXBbaV0gPSBwcm9wc1tpXTsKICAgIH0KICAgIHJldHVybiBtYXA7Cn07CmV4cG9ydHMuYXJyYXlSZW1vdmUgPSBmdW5jdGlvbihhcnJheSwgdmFsdWUpIHsKICBmb3IgKHZhciBpID0gMDsgaSA8PSBhcnJheS5sZW5ndGg7IGkrKykgewogICAgaWYgKHZhbHVlID09PSBhcnJheVtpXSkgewogICAgICBhcnJheS5zcGxpY2UoaSwgMSk7CiAgICB9CiAgfQp9OwoKZXhwb3J0cy5lc2NhcGVSZWdFeHAgPSBmdW5jdGlvbihzdHIpIHsKICAgIHJldHVybiBzdHIucmVwbGFjZSgvKFsuKis/XiR7fSgpfFtcXVwvXFxdKS9nLCAnXFwkMScpOwp9OwoKZXhwb3J0cy5lc2NhcGVIVE1MID0gZnVuY3Rpb24oc3RyKSB7CiAgICByZXR1cm4gKCIiICsgc3RyKS5yZXBsYWNlKC8mL2csICImIzM4OyIpLnJlcGxhY2UoLyIvZywgIiYjMzQ7IikucmVwbGFjZSgvJy9nLCAiJiMzOTsiKS5yZXBsYWNlKC88L2csICImIzYwOyIpOwp9OwoKZXhwb3J0cy5nZXRNYXRjaE9mZnNldHMgPSBmdW5jdGlvbihzdHJpbmcsIHJlZ0V4cCkgewogICAgdmFyIG1hdGNoZXMgPSBbXTsKCiAgICBzdHJpbmcucmVwbGFjZShyZWdFeHAsIGZ1bmN0aW9uKHN0cikgewogICAgICAgIG1hdGNoZXMucHVzaCh7CiAgICAgICAgICAgIG9mZnNldDogYXJndW1lbnRzW2FyZ3VtZW50cy5sZW5ndGgtMl0sCiAgICAgICAgICAgIGxlbmd0aDogc3RyLmxlbmd0aAogICAgICAgIH0pOwogICAgfSk7CgogICAgcmV0dXJuIG1hdGNoZXM7Cn07CmV4cG9ydHMuZGVmZXJyZWRDYWxsID0gZnVuY3Rpb24oZmNuKSB7CiAgICB2YXIgdGltZXIgPSBudWxsOwogICAgdmFyIGNhbGxiYWNrID0gZnVuY3Rpb24oKSB7CiAgICAgICAgdGltZXIgPSBudWxsOwogICAgICAgIGZjbigpOwogICAgfTsKCiAgICB2YXIgZGVmZXJyZWQgPSBmdW5jdGlvbih0aW1lb3V0KSB7CiAgICAgICAgZGVmZXJyZWQuY2FuY2VsKCk7CiAgICAgICAgdGltZXIgPSBzZXRUaW1lb3V0KGNhbGxiYWNrLCB0aW1lb3V0IHx8IDApOwogICAgICAgIHJldHVybiBkZWZlcnJlZDsKICAgIH07CgogICAgZGVmZXJyZWQuc2NoZWR1bGUgPSBkZWZlcnJlZDsKCiAgICBkZWZlcnJlZC5jYWxsID0gZnVuY3Rpb24oKSB7CiAgICAgICAgdGhpcy5jYW5jZWwoKTsKICAgICAgICBmY24oKTsKICAgICAgICByZXR1cm4gZGVmZXJyZWQ7CiAgICB9OwoKICAgIGRlZmVycmVkLmNhbmNlbCA9IGZ1bmN0aW9uKCkgewogICAgICAgIGNsZWFyVGltZW91dCh0aW1lcik7CiAgICAgICAgdGltZXIgPSBudWxsOwogICAgICAgIHJldHVybiBkZWZlcnJlZDsKICAgIH07CiAgICAKICAgIGRlZmVycmVkLmlzUGVuZGluZyA9IGZ1bmN0aW9uKCkgewogICAgICAgIHJldHVybiB0aW1lcjsKICAgIH07CgogICAgcmV0dXJuIGRlZmVycmVkOwp9OwoKCmV4cG9ydHMuZGVsYXllZENhbGwgPSBmdW5jdGlvbihmY24sIGRlZmF1bHRUaW1lb3V0KSB7CiAgICB2YXIgdGltZXIgPSBudWxsOwogICAgdmFyIGNhbGxiYWNrID0gZnVuY3Rpb24oKSB7CiAgICAgICAgdGltZXIgPSBudWxsOwogICAgICAgIGZjbigpOwogICAgfTsKCiAgICB2YXIgX3NlbGYgPSBmdW5jdGlvbih0aW1lb3V0KSB7CiAgICAgICAgaWYgKHRpbWVyID09IG51bGwpCiAgICAgICAgICAgIHRpbWVyID0gc2V0VGltZW91dChjYWxsYmFjaywgdGltZW91dCB8fCBkZWZhdWx0VGltZW91dCk7CiAgICB9OwoKICAgIF9zZWxmLmRlbGF5ID0gZnVuY3Rpb24odGltZW91dCkgewogICAgICAgIHRpbWVyICYmIGNsZWFyVGltZW91dCh0aW1lcik7CiAgICAgICAgdGltZXIgPSBzZXRUaW1lb3V0KGNhbGxiYWNrLCB0aW1lb3V0IHx8IGRlZmF1bHRUaW1lb3V0KTsKICAgIH07CiAgICBfc2VsZi5zY2hlZHVsZSA9IF9zZWxmOwoKICAgIF9zZWxmLmNhbGwgPSBmdW5jdGlvbigpIHsKICAgICAgICB0aGlzLmNhbmNlbCgpOwogICAgICAgIGZjbigpOwogICAgfTsKCiAgICBfc2VsZi5jYW5jZWwgPSBmdW5jdGlvbigpIHsKICAgICAgICB0aW1lciAmJiBjbGVhclRpbWVvdXQodGltZXIpOwogICAgICAgIHRpbWVyID0gbnVsbDsKICAgIH07CgogICAgX3NlbGYuaXNQZW5kaW5nID0gZnVuY3Rpb24oKSB7CiAgICAgICAgcmV0dXJuIHRpbWVyOwogICAgfTsKCiAgICByZXR1cm4gX3NlbGY7Cn07Cn0pOwoKYWNlLmRlZmluZSgiYWNlL3dvcmtlci9taXJyb3IiLFtdLCBmdW5jdGlvbihyZXF1aXJlLCBleHBvcnRzLCBtb2R1bGUpIHsKInVzZSBzdHJpY3QiOwoKdmFyIFJhbmdlID0gcmVxdWlyZSgiLi4vcmFuZ2UiKS5SYW5nZTsKdmFyIERvY3VtZW50ID0gcmVxdWlyZSgiLi4vZG9jdW1lbnQiKS5Eb2N1bWVudDsKdmFyIGxhbmcgPSByZXF1aXJlKCIuLi9saWIvbGFuZyIpOwogICAgCnZhciBNaXJyb3IgPSBleHBvcnRzLk1pcnJvciA9IGZ1bmN0aW9uKHNlbmRlcikgewogICAgdGhpcy5zZW5kZXIgPSBzZW5kZXI7CiAgICB2YXIgZG9jID0gdGhpcy5kb2MgPSBuZXcgRG9jdW1lbnQoIiIpOwogICAgCiAgICB2YXIgZGVmZXJyZWRVcGRhdGUgPSB0aGlzLmRlZmVycmVkVXBkYXRlID0gbGFuZy5kZWxheWVkQ2FsbCh0aGlzLm9uVXBkYXRlLmJpbmQodGhpcykpOwogICAgCiAgICB2YXIgX3NlbGYgPSB0aGlzOwogICAgc2VuZGVyLm9uKCJjaGFuZ2UiLCBmdW5jdGlvbihlKSB7CiAgICAgICAgdmFyIGRhdGEgPSBlLmRhdGE7CiAgICAgICAgaWYgKGRhdGFbMF0uc3RhcnQpIHsKICAgICAgICAgICAgZG9jLmFwcGx5RGVsdGFzKGRhdGEpOwogICAgICAgIH0gZWxzZSB7CiAgICAgICAgICAgIGZvciAodmFyIGkgPSAwOyBpIDwgZGF0YS5sZW5ndGg7IGkgKz0gMikgewogICAgICAgICAgICAgICAgaWYgKEFycmF5LmlzQXJyYXkoZGF0YVtpKzFdKSkgewogICAgICAgICAgICAgICAgICAgIHZhciBkID0ge2FjdGlvbjogImluc2VydCIsIHN0YXJ0OiBkYXRhW2ldLCBsaW5lczogZGF0YVtpKzFdfTsKICAgICAgICAgICAgICAgIH0gZWxzZSB7CiAgICAgICAgICAgICAgICAgICAgdmFyIGQgPSB7YWN0aW9uOiAicmVtb3ZlIiwgc3RhcnQ6IGRhdGFbaV0sIGVuZDogZGF0YVtpKzFdfTsKICAgICAgICAgICAgICAgIH0KICAgICAgICAgICAgICAgIGRvYy5hcHBseURlbHRhKGQsIHRydWUpOwogICAgICAgICAgICB9CiAgICAgICAgfQogICAgICAgIGlmIChfc2VsZi4kdGltZW91dCkKICAgICAgICAgICAgcmV0dXJuIGRlZmVycmVkVXBkYXRlLnNjaGVkdWxlKF9zZWxmLiR0aW1lb3V0KTsKICAgICAgICBfc2VsZi5vblVwZGF0ZSgpOwogICAgfSk7Cn07CgooZnVuY3Rpb24oKSB7CiAgICAKICAgIHRoaXMuJHRpbWVvdXQgPSA1MDA7CiAgICAKICAgIHRoaXMuc2V0VGltZW91dCA9IGZ1bmN0aW9uKHRpbWVvdXQpIHsKICAgICAgICB0aGlzLiR0aW1lb3V0ID0gdGltZW91dDsKICAgIH07CiAgICAKICAgIHRoaXMuc2V0VmFsdWUgPSBmdW5jdGlvbih2YWx1ZSkgewogICAgICAgIHRoaXMuZG9jLnNldFZhbHVlKHZhbHVlKTsKICAgICAgICB0aGlzLmRlZmVycmVkVXBkYXRlLnNjaGVkdWxlKHRoaXMuJHRpbWVvdXQpOwogICAgfTsKICAgIAogICAgdGhpcy5nZXRWYWx1ZSA9IGZ1bmN0aW9uKGNhbGxiYWNrSWQpIHsKICAgICAgICB0aGlzLnNlbmRlci5jYWxsYmFjayh0aGlzLmRvYy5nZXRWYWx1ZSgpLCBjYWxsYmFja0lkKTsKICAgIH07CiAgICAKICAgIHRoaXMub25VcGRhdGUgPSBmdW5jdGlvbigpIHsKICAgIH07CiAgICAKICAgIHRoaXMuaXNQZW5kaW5nID0gZnVuY3Rpb24oKSB7CiAgICAgICAgcmV0dXJuIHRoaXMuZGVmZXJyZWRVcGRhdGUuaXNQZW5kaW5nKCk7CiAgICB9OwogICAgCn0pLmNhbGwoTWlycm9yLnByb3RvdHlwZSk7Cgp9KTsKCmFjZS5kZWZpbmUoImFjZS9tb2RlL2pzb24vanNvbl9wYXJzZSIsW10sIGZ1bmN0aW9uKHJlcXVpcmUsIGV4cG9ydHMsIG1vZHVsZSkgewoidXNlIHN0cmljdCI7CgogICAgdmFyIGF0LCAgICAgLy8gVGhlIGluZGV4IG9mIHRoZSBjdXJyZW50IGNoYXJhY3RlcgogICAgICAgIGNoLCAgICAgLy8gVGhlIGN1cnJlbnQgY2hhcmFjdGVyCiAgICAgICAgZXNjYXBlZSA9IHsKICAgICAgICAgICAgJyInOiAgJyInLAogICAgICAgICAgICAnXFwnOiAnXFwnLAogICAgICAgICAgICAnLyc6ICAnLycsCiAgICAgICAgICAgIGI6ICAgICdcYicsCiAgICAgICAgICAgIGY6ICAgICdcZicsCiAgICAgICAgICAgIG46ICAgICdcbicsCiAgICAgICAgICAgIHI6ICAgICdccicsCiAgICAgICAgICAgIHQ6ICAgICdcdCcKICAgICAgICB9LAogICAgICAgIHRleHQsCgogICAgICAgIGVycm9yID0gZnVuY3Rpb24gKG0pIHsKCiAgICAgICAgICAgIHRocm93IHsKICAgICAgICAgICAgICAgIG5hbWU6ICAgICdTeW50YXhFcnJvcicsCiAgICAgICAgICAgICAgICBtZXNzYWdlOiBtLAogICAgICAgICAgICAgICAgYXQ6ICAgICAgYXQsCiAgICAgICAgICAgICAgICB0ZXh0OiAgICB0ZXh0CiAgICAgICAgICAgIH07CiAgICAgICAgfSwKCiAgICAgICAgbmV4dCA9IGZ1bmN0aW9uIChjKSB7CgogICAgICAgICAgICBpZiAoYyAmJiBjICE9PSBjaCkgewogICAgICAgICAgICAgICAgZXJyb3IoIkV4cGVjdGVkICciICsgYyArICInIGluc3RlYWQgb2YgJyIgKyBjaCArICInIik7CiAgICAgICAgICAgIH0KCiAgICAgICAgICAgIGNoID0gdGV4dC5jaGFyQXQoYXQpOwogICAgICAgICAgICBhdCArPSAxOwogICAgICAgICAgICByZXR1cm4gY2g7CiAgICAgICAgfSwKCiAgICAgICAgbnVtYmVyID0gZnVuY3Rpb24gKCkgewoKICAgICAgICAgICAgdmFyIG51bWJlciwKICAgICAgICAgICAgICAgIHN0cmluZyA9ICcnOwoKICAgICAgICAgICAgaWYgKGNoID09PSAnLScpIHsKICAgICAgICAgICAgICAgIHN0cmluZyA9ICctJzsKICAgICAgICAgICAgICAgIG5leHQoJy0nKTsKICAgICAgICAgICAgfQogICAgICAgICAgICB3aGlsZSAoY2ggPj0gJzAnICYmIGNoIDw9ICc5JykgewogICAgICAgICAgICAgICAgc3RyaW5nICs9IGNoOwogICAgICAgICAgICAgICAgbmV4dCgpOwogICAgICAgICAgICB9CiAgICAgICAgICAgIGlmIChjaCA9PT0gJy4nKSB7CiAgICAgICAgICAgICAgICBzdHJpbmcgKz0gJy4nOwogICAgICAgICAgICAgICAgd2hpbGUgKG5leHQoKSAmJiBjaCA+PSAnMCcgJiYgY2ggPD0gJzknKSB7CiAgICAgICAgICAgICAgICAgICAgc3RyaW5nICs9IGNoOwogICAgICAgICAgICAgICAgfQogICAgICAgICAgICB9CiAgICAgICAgICAgIGlmIChjaCA9PT0gJ2UnIHx8IGNoID09PSAnRScpIHsKICAgICAgICAgICAgICAgIHN0cmluZyArPSBjaDsKICAgICAgICAgICAgICAgIG5leHQoKTsKICAgICAgICAgICAgICAgIGlmIChjaCA9PT0gJy0nIHx8IGNoID09PSAnKycpIHsKICAgICAgICAgICAgICAgICAgICBzdHJpbmcgKz0gY2g7CiAgICAgICAgICAgICAgICAgICAgbmV4dCgpOwogICAgICAgICAgICAgICAgfQogICAgICAgICAgICAgICAgd2hpbGUgKGNoID49ICcwJyAmJiBjaCA8PSAnOScpIHsKICAgICAgICAgICAgICAgICAgICBzdHJpbmcgKz0gY2g7CiAgICAgICAgICAgICAgICAgICAgbmV4dCgpOwogICAgICAgICAgICAgICAgfQogICAgICAgICAgICB9CiAgICAgICAgICAgIG51bWJlciA9ICtzdHJpbmc7CiAgICAgICAgICAgIGlmIChpc05hTihudW1iZXIpKSB7CiAgICAgICAgICAgICAgICBlcnJvcigiQmFkIG51bWJlciIpOwogICAgICAgICAgICB9IGVsc2UgewogICAgICAgICAgICAgICAgcmV0dXJuIG51bWJlcjsKICAgICAgICAgICAgfQogICAgICAgIH0sCgogICAgICAgIHN0cmluZyA9IGZ1bmN0aW9uICgpIHsKCiAgICAgICAgICAgIHZhciBoZXgsCiAgICAgICAgICAgICAgICBpLAogICAgICAgICAgICAgICAgc3RyaW5nID0gJycsCiAgICAgICAgICAgICAgICB1ZmZmZjsKCiAgICAgICAgICAgIGlmIChjaCA9PT0gJyInKSB7CiAgICAgICAgICAgICAgICB3aGlsZSAobmV4dCgpKSB7CiAgICAgICAgICAgICAgICAgICAgaWYgKGNoID09PSAnIicpIHsKICAgICAgICAgICAgICAgICAgICAgICAgbmV4dCgpOwogICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gc3RyaW5nOwogICAgICAgICAgICAgICAgICAgIH0gZWxzZSBpZiAoY2ggPT09ICdcXCcpIHsKICAgICAgICAgICAgICAgICAgICAgICAgbmV4dCgpOwogICAgICAgICAgICAgICAgICAgICAgICBpZiAoY2ggPT09ICd1JykgewogICAgICAgICAgICAgICAgICAgICAgICAgICAgdWZmZmYgPSAwOwogICAgICAgICAgICAgICAgICAgICAgICAgICAgZm9yIChpID0gMDsgaSA8IDQ7IGkgKz0gMSkgewogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGhleCA9IHBhcnNlSW50KG5leHQoKSwgMTYpOwogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGlmICghaXNGaW5pdGUoaGV4KSkgewogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBicmVhazsKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9CiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdWZmZmYgPSB1ZmZmZiAqIDE2ICsgaGV4OwogICAgICAgICAgICAgICAgICAgICAgICAgICAgfQogICAgICAgICAgICAgICAgICAgICAgICAgICAgc3RyaW5nICs9IFN0cmluZy5mcm9tQ2hhckNvZGUodWZmZmYpOwogICAgICAgICAgICAgICAgICAgICAgICB9IGVsc2UgaWYgKHR5cGVvZiBlc2NhcGVlW2NoXSA9PT0gJ3N0cmluZycpIHsKICAgICAgICAgICAgICAgICAgICAgICAgICAgIHN0cmluZyArPSBlc2NhcGVlW2NoXTsKICAgICAgICAgICAgICAgICAgICAgICAgfSBlbHNlIHsKICAgICAgICAgICAgICAgICAgICAgICAgICAgIGJyZWFrOwogICAgICAgICAgICAgICAgICAgICAgICB9CiAgICAgICAgICAgICAgICAgICAgfSBlbHNlIGlmIChjaCA9PSAiXG4iIHx8IGNoID09ICJcciIpIHsKICAgICAgICAgICAgICAgICAgICAgICAgYnJlYWs7CiAgICAgICAgICAgICAgICAgICAgfSBlbHNlIHsKICAgICAgICAgICAgICAgICAgICAgICAgc3RyaW5nICs9IGNoOwogICAgICAgICAgICAgICAgICAgIH0KICAgICAgICAgICAgICAgIH0KICAgICAgICAgICAgfQogICAgICAgICAgICBlcnJvcigiQmFkIHN0cmluZyIpOwogICAgICAgIH0sCgogICAgICAgIHdoaXRlID0gZnVuY3Rpb24gKCkgewoKICAgICAgICAgICAgd2hpbGUgKGNoICYmIGNoIDw9ICcgJykgewogICAgICAgICAgICAgICAgbmV4dCgpOwogICAgICAgICAgICB9CiAgICAgICAgfSwKCiAgICAgICAgd29yZCA9IGZ1bmN0aW9uICgpIHsKCiAgICAgICAgICAgIHN3aXRjaCAoY2gpIHsKICAgICAgICAgICAgY2FzZSAndCc6CiAgICAgICAgICAgICAgICBuZXh0KCd0Jyk7CiAgICAgICAgICAgICAgICBuZXh0KCdyJyk7CiAgICAgICAgICAgICAgICBuZXh0KCd1Jyk7CiAgICAgICAgICAgICAgICBuZXh0KCdlJyk7CiAgICAgICAgICAgICAgICByZXR1cm4gdHJ1ZTsKICAgICAgICAgICAgY2FzZSAnZic6CiAgICAgICAgICAgICAgICBuZXh0KCdmJyk7CiAgICAgICAgICAgICAgICBuZXh0KCdhJyk7CiAgICAgICAgICAgICAgICBuZXh0KCdsJyk7CiAgICAgICAgICAgICAgICBuZXh0KCdzJyk7CiAgICAgICAgICAgICAgICBuZXh0KCdlJyk7CiAgICAgICAgICAgICAgICByZXR1cm4gZmFsc2U7CiAgICAgICAgICAgIGNhc2UgJ24nOgogICAgICAgICAgICAgICAgbmV4dCgnbicpOwogICAgICAgICAgICAgICAgbmV4dCgndScpOwogICAgICAgICAgICAgICAgbmV4dCgnbCcpOwogICAgICAgICAgICAgICAgbmV4dCgnbCcpOwogICAgICAgICAgICAgICAgcmV0dXJuIG51bGw7CiAgICAgICAgICAgIH0KICAgICAgICAgICAgZXJyb3IoIlVuZXhwZWN0ZWQgJyIgKyBjaCArICInIik7CiAgICAgICAgfSwKCiAgICAgICAgdmFsdWUsICAvLyBQbGFjZSBob2xkZXIgZm9yIHRoZSB2YWx1ZSBmdW5jdGlvbi4KCiAgICAgICAgYXJyYXkgPSBmdW5jdGlvbiAoKSB7CgogICAgICAgICAgICB2YXIgYXJyYXkgPSBbXTsKCiAgICAgICAgICAgIGlmIChjaCA9PT0gJ1snKSB7CiAgICAgICAgICAgICAgICBuZXh0KCdbJyk7CiAgICAgICAgICAgICAgICB3aGl0ZSgpOwogICAgICAgICAgICAgICAgaWYgKGNoID09PSAnXScpIHsKICAgICAgICAgICAgICAgICAgICBuZXh0KCddJyk7CiAgICAgICAgICAgICAgICAgICAgcmV0dXJuIGFycmF5OyAgIC8vIGVtcHR5IGFycmF5CiAgICAgICAgICAgICAgICB9CiAgICAgICAgICAgICAgICB3aGlsZSAoY2gpIHsKICAgICAgICAgICAgICAgICAgICBhcnJheS5wdXNoKHZhbHVlKCkpOwogICAgICAgICAgICAgICAgICAgIHdoaXRlKCk7CiAgICAgICAgICAgICAgICAgICAgaWYgKGNoID09PSAnXScpIHsKICAgICAgICAgICAgICAgICAgICAgICAgbmV4dCgnXScpOwogICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gYXJyYXk7CiAgICAgICAgICAgICAgICAgICAgfQogICAgICAgICAgICAgICAgICAgIG5leHQoJywnKTsKICAgICAgICAgICAgICAgICAgICB3aGl0ZSgpOwogICAgICAgICAgICAgICAgfQogICAgICAgICAgICB9CiAgICAgICAgICAgIGVycm9yKCJCYWQgYXJyYXkiKTsKICAgICAgICB9LAoKICAgICAgICBvYmplY3QgPSBmdW5jdGlvbiAoKSB7CgogICAgICAgICAgICB2YXIga2V5LAogICAgICAgICAgICAgICAgb2JqZWN0ID0ge307CgogICAgICAgICAgICBpZiAoY2ggPT09ICd7JykgewogICAgICAgICAgICAgICAgbmV4dCgneycpOwogICAgICAgICAgICAgICAgd2hpdGUoKTsKICAgICAgICAgICAgICAgIGlmIChjaCA9PT0gJ30nKSB7CiAgICAgICAgICAgICAgICAgICAgbmV4dCgnfScpOwogICAgICAgICAgICAgICAgICAgIHJldHVybiBvYmplY3Q7ICAgLy8gZW1wdHkgb2JqZWN0CiAgICAgICAgICAgICAgICB9CiAgICAgICAgICAgICAgICB3aGlsZSAoY2gpIHsKICAgICAgICAgICAgICAgICAgICBrZXkgPSBzdHJpbmcoKTsKICAgICAgICAgICAgICAgICAgICB3aGl0ZSgpOwogICAgICAgICAgICAgICAgICAgIG5leHQoJzonKTsKICAgICAgICAgICAgICAgICAgICBpZiAoT2JqZWN0Lmhhc093blByb3BlcnR5LmNhbGwob2JqZWN0LCBrZXkpKSB7CiAgICAgICAgICAgICAgICAgICAgICAgIGVycm9yKCdEdXBsaWNhdGUga2V5ICInICsga2V5ICsgJyInKTsKICAgICAgICAgICAgICAgICAgICB9CiAgICAgICAgICAgICAgICAgICAgb2JqZWN0W2tleV0gPSB2YWx1ZSgpOwogICAgICAgICAgICAgICAgICAgIHdoaXRlKCk7CiAgICAgICAgICAgICAgICAgICAgaWYgKGNoID09PSAnfScpIHsKICAgICAgICAgICAgICAgICAgICAgICAgbmV4dCgnfScpOwogICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gb2JqZWN0OwogICAgICAgICAgICAgICAgICAgIH0KICAgICAgICAgICAgICAgICAgICBuZXh0KCcsJyk7CiAgICAgICAgICAgICAgICAgICAgd2hpdGUoKTsKICAgICAgICAgICAgICAgIH0KICAgICAgICAgICAgfQogICAgICAgICAgICBlcnJvcigiQmFkIG9iamVjdCIpOwogICAgICAgIH07CgogICAgdmFsdWUgPSBmdW5jdGlvbiAoKSB7CgogICAgICAgIHdoaXRlKCk7CiAgICAgICAgc3dpdGNoIChjaCkgewogICAgICAgIGNhc2UgJ3snOgogICAgICAgICAgICByZXR1cm4gb2JqZWN0KCk7CiAgICAgICAgY2FzZSAnWyc6CiAgICAgICAgICAgIHJldHVybiBhcnJheSgpOwogICAgICAgIGNhc2UgJyInOgogICAgICAgICAgICByZXR1cm4gc3RyaW5nKCk7CiAgICAgICAgY2FzZSAnLSc6CiAgICAgICAgICAgIHJldHVybiBudW1iZXIoKTsKICAgICAgICBkZWZhdWx0OgogICAgICAgICAgICByZXR1cm4gY2ggPj0gJzAnICYmIGNoIDw9ICc5JyA/IG51bWJlcigpIDogd29yZCgpOwogICAgICAgIH0KICAgIH07CgogICAgcmV0dXJuIGZ1bmN0aW9uIChzb3VyY2UsIHJldml2ZXIpIHsKICAgICAgICB2YXIgcmVzdWx0OwoKICAgICAgICB0ZXh0ID0gc291cmNlOwogICAgICAgIGF0ID0gMDsKICAgICAgICBjaCA9ICcgJzsKICAgICAgICByZXN1bHQgPSB2YWx1ZSgpOwogICAgICAgIHdoaXRlKCk7CiAgICAgICAgaWYgKGNoKSB7CiAgICAgICAgICAgIGVycm9yKCJTeW50YXggZXJyb3IiKTsKICAgICAgICB9CgogICAgICAgIHJldHVybiB0eXBlb2YgcmV2aXZlciA9PT0gJ2Z1bmN0aW9uJyA/IGZ1bmN0aW9uIHdhbGsoaG9sZGVyLCBrZXkpIHsKICAgICAgICAgICAgdmFyIGssIHYsIHZhbHVlID0gaG9sZGVyW2tleV07CiAgICAgICAgICAgIGlmICh2YWx1ZSAmJiB0eXBlb2YgdmFsdWUgPT09ICdvYmplY3QnKSB7CiAgICAgICAgICAgICAgICBmb3IgKGsgaW4gdmFsdWUpIHsKICAgICAgICAgICAgICAgICAgICBpZiAoT2JqZWN0Lmhhc093blByb3BlcnR5LmNhbGwodmFsdWUsIGspKSB7CiAgICAgICAgICAgICAgICAgICAgICAgIHYgPSB3YWxrKHZhbHVlLCBrKTsKICAgICAgICAgICAgICAgICAgICAgICAgaWYgKHYgIT09IHVuZGVmaW5lZCkgewogICAgICAgICAgICAgICAgICAgICAgICAgICAgdmFsdWVba10gPSB2OwogICAgICAgICAgICAgICAgICAgICAgICB9IGVsc2UgewogICAgICAgICAgICAgICAgICAgICAgICAgICAgZGVsZXRlIHZhbHVlW2tdOwogICAgICAgICAgICAgICAgICAgICAgICB9CiAgICAgICAgICAgICAgICAgICAgfQogICAgICAgICAgICAgICAgfQogICAgICAgICAgICB9CiAgICAgICAgICAgIHJldHVybiByZXZpdmVyLmNhbGwoaG9sZGVyLCBrZXksIHZhbHVlKTsKICAgICAgICB9KHsnJzogcmVzdWx0fSwgJycpIDogcmVzdWx0OwogICAgfTsKfSk7CgphY2UuZGVmaW5lKCJhY2UvbW9kZS9qc29uX3dvcmtlciIsW10sIGZ1bmN0aW9uKHJlcXVpcmUsIGV4cG9ydHMsIG1vZHVsZSkgewoidXNlIHN0cmljdCI7Cgp2YXIgb29wID0gcmVxdWlyZSgiLi4vbGliL29vcCIpOwp2YXIgTWlycm9yID0gcmVxdWlyZSgiLi4vd29ya2VyL21pcnJvciIpLk1pcnJvcjsKdmFyIHBhcnNlID0gcmVxdWlyZSgiLi9qc29uL2pzb25fcGFyc2UiKTsKCnZhciBKc29uV29ya2VyID0gZXhwb3J0cy5Kc29uV29ya2VyID0gZnVuY3Rpb24oc2VuZGVyKSB7CiAgICBNaXJyb3IuY2FsbCh0aGlzLCBzZW5kZXIpOwogICAgdGhpcy5zZXRUaW1lb3V0KDIwMCk7Cn07Cgpvb3AuaW5oZXJpdHMoSnNvbldvcmtlciwgTWlycm9yKTsKCihmdW5jdGlvbigpIHsKCiAgICB0aGlzLm9uVXBkYXRlID0gZnVuY3Rpb24oKSB7CiAgICAgICAgdmFyIHZhbHVlID0gdGhpcy5kb2MuZ2V0VmFsdWUoKTsKICAgICAgICB2YXIgZXJyb3JzID0gW107CiAgICAgICAgdHJ5IHsKICAgICAgICAgICAgaWYgKHZhbHVlKQogICAgICAgICAgICAgICAgcGFyc2UodmFsdWUpOwogICAgICAgIH0gY2F0Y2ggKGUpIHsKICAgICAgICAgICAgdmFyIHBvcyA9IHRoaXMuZG9jLmluZGV4VG9Qb3NpdGlvbihlLmF0LTEpOwogICAgICAgICAgICBlcnJvcnMucHVzaCh7CiAgICAgICAgICAgICAgICByb3c6IHBvcy5yb3csCiAgICAgICAgICAgICAgICBjb2x1bW46IHBvcy5jb2x1bW4sCiAgICAgICAgICAgICAgICB0ZXh0OiBlLm1lc3NhZ2UsCiAgICAgICAgICAgICAgICB0eXBlOiAiZXJyb3IiCiAgICAgICAgICAgIH0pOwogICAgICAgIH0KICAgICAgICB0aGlzLnNlbmRlci5lbWl0KCJhbm5vdGF0ZSIsIGVycm9ycyk7CiAgICB9OwoKfSkuY2FsbChKc29uV29ya2VyLnByb3RvdHlwZSk7Cgp9KTsKCmFjZS5kZWZpbmUoImFjZS9saWIvZXM1LXNoaW0iLFtdLCBmdW5jdGlvbihyZXF1aXJlLCBleHBvcnRzLCBtb2R1bGUpIHsKCmZ1bmN0aW9uIEVtcHR5KCkge30KCmlmICghRnVuY3Rpb24ucHJvdG90eXBlLmJpbmQpIHsKICAgIEZ1bmN0aW9uLnByb3RvdHlwZS5iaW5kID0gZnVuY3Rpb24gYmluZCh0aGF0KSB7IC8vIC5sZW5ndGggaXMgMQogICAgICAgIHZhciB0YXJnZXQgPSB0aGlzOwogICAgICAgIGlmICh0eXBlb2YgdGFyZ2V0ICE9ICJmdW5jdGlvbiIpIHsKICAgICAgICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcigiRnVuY3Rpb24ucHJvdG90eXBlLmJpbmQgY2FsbGVkIG9uIGluY29tcGF0aWJsZSAiICsgdGFyZ2V0KTsKICAgICAgICB9CiAgICAgICAgdmFyIGFyZ3MgPSBzbGljZS5jYWxsKGFyZ3VtZW50cywgMSk7IC8vIGZvciBub3JtYWwgY2FsbAogICAgICAgIHZhciBib3VuZCA9IGZ1bmN0aW9uICgpIHsKCiAgICAgICAgICAgIGlmICh0aGlzIGluc3RhbmNlb2YgYm91bmQpIHsKCiAgICAgICAgICAgICAgICB2YXIgcmVzdWx0ID0gdGFyZ2V0LmFwcGx5KAogICAgICAgICAgICAgICAgICAgIHRoaXMsCiAgICAgICAgICAgICAgICAgICAgYXJncy5jb25jYXQoc2xpY2UuY2FsbChhcmd1bWVudHMpKQogICAgICAgICAgICAgICAgKTsKICAgICAgICAgICAgICAgIGlmIChPYmplY3QocmVzdWx0KSA9PT0gcmVzdWx0KSB7CiAgICAgICAgICAgICAgICAgICAgcmV0dXJuIHJlc3VsdDsKICAgICAgICAgICAgICAgIH0KICAgICAgICAgICAgICAgIHJldHVybiB0aGlzOwoKICAgICAgICAgICAgfSBlbHNlIHsKICAgICAgICAgICAgICAgIHJldHVybiB0YXJnZXQuYXBwbHkoCiAgICAgICAgICAgICAgICAgICAgdGhhdCwKICAgICAgICAgICAgICAgICAgICBhcmdzLmNvbmNhdChzbGljZS5jYWxsKGFyZ3VtZW50cykpCiAgICAgICAgICAgICAgICApOwoKICAgICAgICAgICAgfQoKICAgICAgICB9OwogICAgICAgIGlmKHRhcmdldC5wcm90b3R5cGUpIHsKICAgICAgICAgICAgRW1wdHkucHJvdG90eXBlID0gdGFyZ2V0LnByb3RvdHlwZTsKICAgICAgICAgICAgYm91bmQucHJvdG90eXBlID0gbmV3IEVtcHR5KCk7CiAgICAgICAgICAgIEVtcHR5LnByb3RvdHlwZSA9IG51bGw7CiAgICAgICAgfQogICAgICAgIHJldHVybiBib3VuZDsKICAgIH07Cn0KdmFyIGNhbGwgPSBGdW5jdGlvbi5wcm90b3R5cGUuY2FsbDsKdmFyIHByb3RvdHlwZU9mQXJyYXkgPSBBcnJheS5wcm90b3R5cGU7CnZhciBwcm90b3R5cGVPZk9iamVjdCA9IE9iamVjdC5wcm90b3R5cGU7CnZhciBzbGljZSA9IHByb3RvdHlwZU9mQXJyYXkuc2xpY2U7CnZhciBfdG9TdHJpbmcgPSBjYWxsLmJpbmQocHJvdG90eXBlT2ZPYmplY3QudG9TdHJpbmcpOwp2YXIgb3ducyA9IGNhbGwuYmluZChwcm90b3R5cGVPZk9iamVjdC5oYXNPd25Qcm9wZXJ0eSk7CnZhciBkZWZpbmVHZXR0ZXI7CnZhciBkZWZpbmVTZXR0ZXI7CnZhciBsb29rdXBHZXR0ZXI7CnZhciBsb29rdXBTZXR0ZXI7CnZhciBzdXBwb3J0c0FjY2Vzc29yczsKaWYgKChzdXBwb3J0c0FjY2Vzc29ycyA9IG93bnMocHJvdG90eXBlT2ZPYmplY3QsICJfX2RlZmluZUdldHRlcl9fIikpKSB7CiAgICBkZWZpbmVHZXR0ZXIgPSBjYWxsLmJpbmQocHJvdG90eXBlT2ZPYmplY3QuX19kZWZpbmVHZXR0ZXJfXyk7CiAgICBkZWZpbmVTZXR0ZXIgPSBjYWxsLmJpbmQocHJvdG90eXBlT2ZPYmplY3QuX19kZWZpbmVTZXR0ZXJfXyk7CiAgICBsb29rdXBHZXR0ZXIgPSBjYWxsLmJpbmQocHJvdG90eXBlT2ZPYmplY3QuX19sb29rdXBHZXR0ZXJfXyk7CiAgICBsb29rdXBTZXR0ZXIgPSBjYWxsLmJpbmQocHJvdG90eXBlT2ZPYmplY3QuX19sb29rdXBTZXR0ZXJfXyk7Cn0KaWYgKFsxLDJdLnNwbGljZSgwKS5sZW5ndGggIT0gMikgewogICAgaWYoZnVuY3Rpb24oKSB7IC8vIHRlc3QgSUUgPCA5IHRvIHNwbGljZSBidWcgLSBzZWUgaXNzdWUgIzEzOAogICAgICAgIGZ1bmN0aW9uIG1ha2VBcnJheShsKSB7CiAgICAgICAgICAgIHZhciBhID0gbmV3IEFycmF5KGwrMik7CiAgICAgICAgICAgIGFbMF0gPSBhWzFdID0gMDsKICAgICAgICAgICAgcmV0dXJuIGE7CiAgICAgICAgfQogICAgICAgIHZhciBhcnJheSA9IFtdLCBsZW5ndGhCZWZvcmU7CiAgICAgICAgCiAgICAgICAgYXJyYXkuc3BsaWNlLmFwcGx5KGFycmF5LCBtYWtlQXJyYXkoMjApKTsKICAgICAgICBhcnJheS5zcGxpY2UuYXBwbHkoYXJyYXksIG1ha2VBcnJheSgyNikpOwoKICAgICAgICBsZW5ndGhCZWZvcmUgPSBhcnJheS5sZW5ndGg7IC8vNDYKICAgICAgICBhcnJheS5zcGxpY2UoNSwgMCwgIlhYWCIpOyAvLyBhZGQgb25lIGVsZW1lbnQKCiAgICAgICAgbGVuZ3RoQmVmb3JlICsgMSA9PSBhcnJheS5sZW5ndGgKCiAgICAgICAgaWYgKGxlbmd0aEJlZm9yZSArIDEgPT0gYXJyYXkubGVuZ3RoKSB7CiAgICAgICAgICAgIHJldHVybiB0cnVlOy8vIGhhcyByaWdodCBzcGxpY2UgaW1wbGVtZW50YXRpb24gd2l0aG91dCBidWdzCiAgICAgICAgfQogICAgfSgpKSB7Ly9JRSA2LzcKICAgICAgICB2YXIgYXJyYXlfc3BsaWNlID0gQXJyYXkucHJvdG90eXBlLnNwbGljZTsKICAgICAgICBBcnJheS5wcm90b3R5cGUuc3BsaWNlID0gZnVuY3Rpb24oc3RhcnQsIGRlbGV0ZUNvdW50KSB7CiAgICAgICAgICAgIGlmICghYXJndW1lbnRzLmxlbmd0aCkgewogICAgICAgICAgICAgICAgcmV0dXJuIFtdOwogICAgICAgICAgICB9IGVsc2UgewogICAgICAgICAgICAgICAgcmV0dXJuIGFycmF5X3NwbGljZS5hcHBseSh0aGlzLCBbCiAgICAgICAgICAgICAgICAgICAgc3RhcnQgPT09IHZvaWQgMCA/IDAgOiBzdGFydCwKICAgICAgICAgICAgICAgICAgICBkZWxldGVDb3VudCA9PT0gdm9pZCAwID8gKHRoaXMubGVuZ3RoIC0gc3RhcnQpIDogZGVsZXRlQ291bnQKICAgICAgICAgICAgICAgIF0uY29uY2F0KHNsaWNlLmNhbGwoYXJndW1lbnRzLCAyKSkpCiAgICAgICAgICAgIH0KICAgICAgICB9OwogICAgfSBlbHNlIHsvL0lFOAogICAgICAgIEFycmF5LnByb3RvdHlwZS5zcGxpY2UgPSBmdW5jdGlvbihwb3MsIHJlbW92ZUNvdW50KXsKICAgICAgICAgICAgdmFyIGxlbmd0aCA9IHRoaXMubGVuZ3RoOwogICAgICAgICAgICBpZiAocG9zID4gMCkgewogICAgICAgICAgICAgICAgaWYgKHBvcyA+IGxlbmd0aCkKICAgICAgICAgICAgICAgICAgICBwb3MgPSBsZW5ndGg7CiAgICAgICAgICAgIH0gZWxzZSBpZiAocG9zID09IHZvaWQgMCkgewogICAgICAgICAgICAgICAgcG9zID0gMDsKICAgICAgICAgICAgfSBlbHNlIGlmIChwb3MgPCAwKSB7CiAgICAgICAgICAgICAgICBwb3MgPSBNYXRoLm1heChsZW5ndGggKyBwb3MsIDApOwogICAgICAgICAgICB9CgogICAgICAgICAgICBpZiAoIShwb3MrcmVtb3ZlQ291bnQgPCBsZW5ndGgpKQogICAgICAgICAgICAgICAgcmVtb3ZlQ291bnQgPSBsZW5ndGggLSBwb3M7CgogICAgICAgICAgICB2YXIgcmVtb3ZlZCA9IHRoaXMuc2xpY2UocG9zLCBwb3MrcmVtb3ZlQ291bnQpOwogICAgICAgICAgICB2YXIgaW5zZXJ0ID0gc2xpY2UuY2FsbChhcmd1bWVudHMsIDIpOwogICAgICAgICAgICB2YXIgYWRkID0gaW5zZXJ0Lmxlbmd0aDsgICAgICAgICAgICAKICAgICAgICAgICAgaWYgKHBvcyA9PT0gbGVuZ3RoKSB7CiAgICAgICAgICAgICAgICBpZiAoYWRkKSB7CiAgICAgICAgICAgICAgICAgICAgdGhpcy5wdXNoLmFwcGx5KHRoaXMsIGluc2VydCk7CiAgICAgICAgICAgICAgICB9CiAgICAgICAgICAgIH0gZWxzZSB7CiAgICAgICAgICAgICAgICB2YXIgcmVtb3ZlID0gTWF0aC5taW4ocmVtb3ZlQ291bnQsIGxlbmd0aCAtIHBvcyk7CiAgICAgICAgICAgICAgICB2YXIgdGFpbE9sZFBvcyA9IHBvcyArIHJlbW92ZTsKICAgICAgICAgICAgICAgIHZhciB0YWlsTmV3UG9zID0gdGFpbE9sZFBvcyArIGFkZCAtIHJlbW92ZTsKICAgICAgICAgICAgICAgIHZhciB0YWlsQ291bnQgPSBsZW5ndGggLSB0YWlsT2xkUG9zOwogICAgICAgICAgICAgICAgdmFyIGxlbmd0aEFmdGVyUmVtb3ZlID0gbGVuZ3RoIC0gcmVtb3ZlOwoKICAgICAgICAgICAgICAgIGlmICh0YWlsTmV3UG9zIDwgdGFpbE9sZFBvcykgeyAvLyBjYXNlIEEKICAgICAgICAgICAgICAgICAgICBmb3IgKHZhciBpID0gMDsgaSA8IHRhaWxDb3VudDsgKytpKSB7CiAgICAgICAgICAgICAgICAgICAgICAgIHRoaXNbdGFpbE5ld1BvcytpXSA9IHRoaXNbdGFpbE9sZFBvcytpXTsKICAgICAgICAgICAgICAgICAgICB9CiAgICAgICAgICAgICAgICB9IGVsc2UgaWYgKHRhaWxOZXdQb3MgPiB0YWlsT2xkUG9zKSB7IC8vIGNhc2UgQgogICAgICAgICAgICAgICAgICAgIGZvciAoaSA9IHRhaWxDb3VudDsgaS0tOyApIHsKICAgICAgICAgICAgICAgICAgICAgICAgdGhpc1t0YWlsTmV3UG9zK2ldID0gdGhpc1t0YWlsT2xkUG9zK2ldOwogICAgICAgICAgICAgICAgICAgIH0KICAgICAgICAgICAgICAgIH0gLy8gZWxzZSwgYWRkID09IHJlbW92ZSAobm90aGluZyB0byBkbykKCiAgICAgICAgICAgICAgICBpZiAoYWRkICYmIHBvcyA9PT0gbGVuZ3RoQWZ0ZXJSZW1vdmUpIHsKICAgICAgICAgICAgICAgICAgICB0aGlzLmxlbmd0aCA9IGxlbmd0aEFmdGVyUmVtb3ZlOyAvLyB0cnVuY2F0ZSBhcnJheQogICAgICAgICAgICAgICAgICAgIHRoaXMucHVzaC5hcHBseSh0aGlzLCBpbnNlcnQpOwogICAgICAgICAgICAgICAgfSBlbHNlIHsKICAgICAgICAgICAgICAgICAgICB0aGlzLmxlbmd0aCA9IGxlbmd0aEFmdGVyUmVtb3ZlICsgYWRkOyAvLyByZXNlcnZlcyBzcGFjZQogICAgICAgICAgICAgICAgICAgIGZvciAoaSA9IDA7IGkgPCBhZGQ7ICsraSkgewogICAgICAgICAgICAgICAgICAgICAgICB0aGlzW3BvcytpXSA9IGluc2VydFtpXTsKICAgICAgICAgICAgICAgICAgICB9CiAgICAgICAgICAgICAgICB9CiAgICAgICAgICAgIH0KICAgICAgICAgICAgcmV0dXJuIHJlbW92ZWQ7CiAgICAgICAgfTsKICAgIH0KfQppZiAoIUFycmF5LmlzQXJyYXkpIHsKICAgIEFycmF5LmlzQXJyYXkgPSBmdW5jdGlvbiBpc0FycmF5KG9iaikgewogICAgICAgIHJldHVybiBfdG9TdHJpbmcob2JqKSA9PSAiW29iamVjdCBBcnJheV0iOwogICAgfTsKfQp2YXIgYm94ZWRTdHJpbmcgPSBPYmplY3QoImEiKSwKICAgIHNwbGl0U3RyaW5nID0gYm94ZWRTdHJpbmdbMF0gIT0gImEiIHx8ICEoMCBpbiBib3hlZFN0cmluZyk7CgppZiAoIUFycmF5LnByb3RvdHlwZS5mb3JFYWNoKSB7CiAgICBBcnJheS5wcm90b3R5cGUuZm9yRWFjaCA9IGZ1bmN0aW9uIGZvckVhY2goZnVuIC8qLCB0aGlzcCovKSB7CiAgICAgICAgdmFyIG9iamVjdCA9IHRvT2JqZWN0KHRoaXMpLAogICAgICAgICAgICBzZWxmID0gc3BsaXRTdHJpbmcgJiYgX3RvU3RyaW5nKHRoaXMpID09ICJbb2JqZWN0IFN0cmluZ10iID8KICAgICAgICAgICAgICAgIHRoaXMuc3BsaXQoIiIpIDoKICAgICAgICAgICAgICAgIG9iamVjdCwKICAgICAgICAgICAgdGhpc3AgPSBhcmd1bWVudHNbMV0sCiAgICAgICAgICAgIGkgPSAtMSwKICAgICAgICAgICAgbGVuZ3RoID0gc2VsZi5sZW5ndGggPj4+IDA7CiAgICAgICAgaWYgKF90b1N0cmluZyhmdW4pICE9ICJbb2JqZWN0IEZ1bmN0aW9uXSIpIHsKICAgICAgICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcigpOyAvLyBUT0RPIG1lc3NhZ2UKICAgICAgICB9CgogICAgICAgIHdoaWxlICgrK2kgPCBsZW5ndGgpIHsKICAgICAgICAgICAgaWYgKGkgaW4gc2VsZikgewogICAgICAgICAgICAgICAgZnVuLmNhbGwodGhpc3AsIHNlbGZbaV0sIGksIG9iamVjdCk7CiAgICAgICAgICAgIH0KICAgICAgICB9CiAgICB9Owp9CmlmICghQXJyYXkucHJvdG90eXBlLm1hcCkgewogICAgQXJyYXkucHJvdG90eXBlLm1hcCA9IGZ1bmN0aW9uIG1hcChmdW4gLyosIHRoaXNwKi8pIHsKICAgICAgICB2YXIgb2JqZWN0ID0gdG9PYmplY3QodGhpcyksCiAgICAgICAgICAgIHNlbGYgPSBzcGxpdFN0cmluZyAmJiBfdG9TdHJpbmcodGhpcykgPT0gIltvYmplY3QgU3RyaW5nXSIgPwogICAgICAgICAgICAgICAgdGhpcy5zcGxpdCgiIikgOgogICAgICAgICAgICAgICAgb2JqZWN0LAogICAgICAgICAgICBsZW5ndGggPSBzZWxmLmxlbmd0aCA+Pj4gMCwKICAgICAgICAgICAgcmVzdWx0ID0gQXJyYXkobGVuZ3RoKSwKICAgICAgICAgICAgdGhpc3AgPSBhcmd1bWVudHNbMV07CiAgICAgICAgaWYgKF90b1N0cmluZyhmdW4pICE9ICJbb2JqZWN0IEZ1bmN0aW9uXSIpIHsKICAgICAgICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcihmdW4gKyAiIGlzIG5vdCBhIGZ1bmN0aW9uIik7CiAgICAgICAgfQoKICAgICAgICBmb3IgKHZhciBpID0gMDsgaSA8IGxlbmd0aDsgaSsrKSB7CiAgICAgICAgICAgIGlmIChpIGluIHNlbGYpCiAgICAgICAgICAgICAgICByZXN1bHRbaV0gPSBmdW4uY2FsbCh0aGlzcCwgc2VsZltpXSwgaSwgb2JqZWN0KTsKICAgICAgICB9CiAgICAgICAgcmV0dXJuIHJlc3VsdDsKICAgIH07Cn0KaWYgKCFBcnJheS5wcm90b3R5cGUuZmlsdGVyKSB7CiAgICBBcnJheS5wcm90b3R5cGUuZmlsdGVyID0gZnVuY3Rpb24gZmlsdGVyKGZ1biAvKiwgdGhpc3AgKi8pIHsKICAgICAgICB2YXIgb2JqZWN0ID0gdG9PYmplY3QodGhpcyksCiAgICAgICAgICAgIHNlbGYgPSBzcGxpdFN0cmluZyAmJiBfdG9TdHJpbmcodGhpcykgPT0gIltvYmplY3QgU3RyaW5nXSIgPwogICAgICAgICAgICAgICAgdGhpcy5zcGxpdCgiIikgOgogICAgICAgICAgICAgICAgICAgIG9iamVjdCwKICAgICAgICAgICAgbGVuZ3RoID0gc2VsZi5sZW5ndGggPj4+IDAsCiAgICAgICAgICAgIHJlc3VsdCA9IFtdLAogICAgICAgICAgICB2YWx1ZSwKICAgICAgICAgICAgdGhpc3AgPSBhcmd1bWVudHNbMV07CiAgICAgICAgaWYgKF90b1N0cmluZyhmdW4pICE9ICJbb2JqZWN0IEZ1bmN0aW9uXSIpIHsKICAgICAgICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcihmdW4gKyAiIGlzIG5vdCBhIGZ1bmN0aW9uIik7CiAgICAgICAgfQoKICAgICAgICBmb3IgKHZhciBpID0gMDsgaSA8IGxlbmd0aDsgaSsrKSB7CiAgICAgICAgICAgIGlmIChpIGluIHNlbGYpIHsKICAgICAgICAgICAgICAgIHZhbHVlID0gc2VsZltpXTsKICAgICAgICAgICAgICAgIGlmIChmdW4uY2FsbCh0aGlzcCwgdmFsdWUsIGksIG9iamVjdCkpIHsKICAgICAgICAgICAgICAgICAgICByZXN1bHQucHVzaCh2YWx1ZSk7CiAgICAgICAgICAgICAgICB9CiAgICAgICAgICAgIH0KICAgICAgICB9CiAgICAgICAgcmV0dXJuIHJlc3VsdDsKICAgIH07Cn0KaWYgKCFBcnJheS5wcm90b3R5cGUuZXZlcnkpIHsKICAgIEFycmF5LnByb3RvdHlwZS5ldmVyeSA9IGZ1bmN0aW9uIGV2ZXJ5KGZ1biAvKiwgdGhpc3AgKi8pIHsKICAgICAgICB2YXIgb2JqZWN0ID0gdG9PYmplY3QodGhpcyksCiAgICAgICAgICAgIHNlbGYgPSBzcGxpdFN0cmluZyAmJiBfdG9TdHJpbmcodGhpcykgPT0gIltvYmplY3QgU3RyaW5nXSIgPwogICAgICAgICAgICAgICAgdGhpcy5zcGxpdCgiIikgOgogICAgICAgICAgICAgICAgb2JqZWN0LAogICAgICAgICAgICBsZW5ndGggPSBzZWxmLmxlbmd0aCA+Pj4gMCwKICAgICAgICAgICAgdGhpc3AgPSBhcmd1bWVudHNbMV07CiAgICAgICAgaWYgKF90b1N0cmluZyhmdW4pICE9ICJbb2JqZWN0IEZ1bmN0aW9uXSIpIHsKICAgICAgICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcihmdW4gKyAiIGlzIG5vdCBhIGZ1bmN0aW9uIik7CiAgICAgICAgfQoKICAgICAgICBmb3IgKHZhciBpID0gMDsgaSA8IGxlbmd0aDsgaSsrKSB7CiAgICAgICAgICAgIGlmIChpIGluIHNlbGYgJiYgIWZ1bi5jYWxsKHRoaXNwLCBzZWxmW2ldLCBpLCBvYmplY3QpKSB7CiAgICAgICAgICAgICAgICByZXR1cm4gZmFsc2U7CiAgICAgICAgICAgIH0KICAgICAgICB9CiAgICAgICAgcmV0dXJuIHRydWU7CiAgICB9Owp9CmlmICghQXJyYXkucHJvdG90eXBlLnNvbWUpIHsKICAgIEFycmF5LnByb3RvdHlwZS5zb21lID0gZnVuY3Rpb24gc29tZShmdW4gLyosIHRoaXNwICovKSB7CiAgICAgICAgdmFyIG9iamVjdCA9IHRvT2JqZWN0KHRoaXMpLAogICAgICAgICAgICBzZWxmID0gc3BsaXRTdHJpbmcgJiYgX3RvU3RyaW5nKHRoaXMpID09ICJbb2JqZWN0IFN0cmluZ10iID8KICAgICAgICAgICAgICAgIHRoaXMuc3BsaXQoIiIpIDoKICAgICAgICAgICAgICAgIG9iamVjdCwKICAgICAgICAgICAgbGVuZ3RoID0gc2VsZi5sZW5ndGggPj4+IDAsCiAgICAgICAgICAgIHRoaXNwID0gYXJndW1lbnRzWzFdOwogICAgICAgIGlmIChfdG9TdHJpbmcoZnVuKSAhPSAiW29iamVjdCBGdW5jdGlvbl0iKSB7CiAgICAgICAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoZnVuICsgIiBpcyBub3QgYSBmdW5jdGlvbiIpOwogICAgICAgIH0KCiAgICAgICAgZm9yICh2YXIgaSA9IDA7IGkgPCBsZW5ndGg7IGkrKykgewogICAgICAgICAgICBpZiAoaSBpbiBzZWxmICYmIGZ1bi5jYWxsKHRoaXNwLCBzZWxmW2ldLCBpLCBvYmplY3QpKSB7CiAgICAgICAgICAgICAgICByZXR1cm4gdHJ1ZTsKICAgICAgICAgICAgfQogICAgICAgIH0KICAgICAgICByZXR1cm4gZmFsc2U7CiAgICB9Owp9CmlmICghQXJyYXkucHJvdG90eXBlLnJlZHVjZSkgewogICAgQXJyYXkucHJvdG90eXBlLnJlZHVjZSA9IGZ1bmN0aW9uIHJlZHVjZShmdW4gLyosIGluaXRpYWwqLykgewogICAgICAgIHZhciBvYmplY3QgPSB0b09iamVjdCh0aGlzKSwKICAgICAgICAgICAgc2VsZiA9IHNwbGl0U3RyaW5nICYmIF90b1N0cmluZyh0aGlzKSA9PSAiW29iamVjdCBTdHJpbmddIiA/CiAgICAgICAgICAgICAgICB0aGlzLnNwbGl0KCIiKSA6CiAgICAgICAgICAgICAgICBvYmplY3QsCiAgICAgICAgICAgIGxlbmd0aCA9IHNlbGYubGVuZ3RoID4+PiAwOwogICAgICAgIGlmIChfdG9TdHJpbmcoZnVuKSAhPSAiW29iamVjdCBGdW5jdGlvbl0iKSB7CiAgICAgICAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoZnVuICsgIiBpcyBub3QgYSBmdW5jdGlvbiIpOwogICAgICAgIH0KICAgICAgICBpZiAoIWxlbmd0aCAmJiBhcmd1bWVudHMubGVuZ3RoID09IDEpIHsKICAgICAgICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcigicmVkdWNlIG9mIGVtcHR5IGFycmF5IHdpdGggbm8gaW5pdGlhbCB2YWx1ZSIpOwogICAgICAgIH0KCiAgICAgICAgdmFyIGkgPSAwOwogICAgICAgIHZhciByZXN1bHQ7CiAgICAgICAgaWYgKGFyZ3VtZW50cy5sZW5ndGggPj0gMikgewogICAgICAgICAgICByZXN1bHQgPSBhcmd1bWVudHNbMV07CiAgICAgICAgfSBlbHNlIHsKICAgICAgICAgICAgZG8gewogICAgICAgICAgICAgICAgaWYgKGkgaW4gc2VsZikgewogICAgICAgICAgICAgICAgICAgIHJlc3VsdCA9IHNlbGZbaSsrXTsKICAgICAgICAgICAgICAgICAgICBicmVhazsKICAgICAgICAgICAgICAgIH0KICAgICAgICAgICAgICAgIGlmICgrK2kgPj0gbGVuZ3RoKSB7CiAgICAgICAgICAgICAgICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcigicmVkdWNlIG9mIGVtcHR5IGFycmF5IHdpdGggbm8gaW5pdGlhbCB2YWx1ZSIpOwogICAgICAgICAgICAgICAgfQogICAgICAgICAgICB9IHdoaWxlICh0cnVlKTsKICAgICAgICB9CgogICAgICAgIGZvciAoOyBpIDwgbGVuZ3RoOyBpKyspIHsKICAgICAgICAgICAgaWYgKGkgaW4gc2VsZikgewogICAgICAgICAgICAgICAgcmVzdWx0ID0gZnVuLmNhbGwodm9pZCAwLCByZXN1bHQsIHNlbGZbaV0sIGksIG9iamVjdCk7CiAgICAgICAgICAgIH0KICAgICAgICB9CgogICAgICAgIHJldHVybiByZXN1bHQ7CiAgICB9Owp9CmlmICghQXJyYXkucHJvdG90eXBlLnJlZHVjZVJpZ2h0KSB7CiAgICBBcnJheS5wcm90b3R5cGUucmVkdWNlUmlnaHQgPSBmdW5jdGlvbiByZWR1Y2VSaWdodChmdW4gLyosIGluaXRpYWwqLykgewogICAgICAgIHZhciBvYmplY3QgPSB0b09iamVjdCh0aGlzKSwKICAgICAgICAgICAgc2VsZiA9IHNwbGl0U3RyaW5nICYmIF90b1N0cmluZyh0aGlzKSA9PSAiW29iamVjdCBTdHJpbmddIiA/CiAgICAgICAgICAgICAgICB0aGlzLnNwbGl0KCIiKSA6CiAgICAgICAgICAgICAgICBvYmplY3QsCiAgICAgICAgICAgIGxlbmd0aCA9IHNlbGYubGVuZ3RoID4+PiAwOwogICAgICAgIGlmIChfdG9TdHJpbmcoZnVuKSAhPSAiW29iamVjdCBGdW5jdGlvbl0iKSB7CiAgICAgICAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoZnVuICsgIiBpcyBub3QgYSBmdW5jdGlvbiIpOwogICAgICAgIH0KICAgICAgICBpZiAoIWxlbmd0aCAmJiBhcmd1bWVudHMubGVuZ3RoID09IDEpIHsKICAgICAgICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcigicmVkdWNlUmlnaHQgb2YgZW1wdHkgYXJyYXkgd2l0aCBubyBpbml0aWFsIHZhbHVlIik7CiAgICAgICAgfQoKICAgICAgICB2YXIgcmVzdWx0LCBpID0gbGVuZ3RoIC0gMTsKICAgICAgICBpZiAoYXJndW1lbnRzLmxlbmd0aCA+PSAyKSB7CiAgICAgICAgICAgIHJlc3VsdCA9IGFyZ3VtZW50c1sxXTsKICAgICAgICB9IGVsc2UgewogICAgICAgICAgICBkbyB7CiAgICAgICAgICAgICAgICBpZiAoaSBpbiBzZWxmKSB7CiAgICAgICAgICAgICAgICAgICAgcmVzdWx0ID0gc2VsZltpLS1dOwogICAgICAgICAgICAgICAgICAgIGJyZWFrOwogICAgICAgICAgICAgICAgfQogICAgICAgICAgICAgICAgaWYgKC0taSA8IDApIHsKICAgICAgICAgICAgICAgICAgICB0aHJvdyBuZXcgVHlwZUVycm9yKCJyZWR1Y2VSaWdodCBvZiBlbXB0eSBhcnJheSB3aXRoIG5vIGluaXRpYWwgdmFsdWUiKTsKICAgICAgICAgICAgICAgIH0KICAgICAgICAgICAgfSB3aGlsZSAodHJ1ZSk7CiAgICAgICAgfQoKICAgICAgICBkbyB7CiAgICAgICAgICAgIGlmIChpIGluIHRoaXMpIHsKICAgICAgICAgICAgICAgIHJlc3VsdCA9IGZ1bi5jYWxsKHZvaWQgMCwgcmVzdWx0LCBzZWxmW2ldLCBpLCBvYmplY3QpOwogICAgICAgICAgICB9CiAgICAgICAgfSB3aGlsZSAoaS0tKTsKCiAgICAgICAgcmV0dXJuIHJlc3VsdDsKICAgIH07Cn0KaWYgKCFBcnJheS5wcm90b3R5cGUuaW5kZXhPZiB8fCAoWzAsIDFdLmluZGV4T2YoMSwgMikgIT0gLTEpKSB7CiAgICBBcnJheS5wcm90b3R5cGUuaW5kZXhPZiA9IGZ1bmN0aW9uIGluZGV4T2Yoc291Z2h0IC8qLCBmcm9tSW5kZXggKi8gKSB7CiAgICAgICAgdmFyIHNlbGYgPSBzcGxpdFN0cmluZyAmJiBfdG9TdHJpbmcodGhpcykgPT0gIltvYmplY3QgU3RyaW5nXSIgPwogICAgICAgICAgICAgICAgdGhpcy5zcGxpdCgiIikgOgogICAgICAgICAgICAgICAgdG9PYmplY3QodGhpcyksCiAgICAgICAgICAgIGxlbmd0aCA9IHNlbGYubGVuZ3RoID4+PiAwOwoKICAgICAgICBpZiAoIWxlbmd0aCkgewogICAgICAgICAgICByZXR1cm4gLTE7CiAgICAgICAgfQoKICAgICAgICB2YXIgaSA9IDA7CiAgICAgICAgaWYgKGFyZ3VtZW50cy5sZW5ndGggPiAxKSB7CiAgICAgICAgICAgIGkgPSB0b0ludGVnZXIoYXJndW1lbnRzWzFdKTsKICAgICAgICB9CiAgICAgICAgaSA9IGkgPj0gMCA/IGkgOiBNYXRoLm1heCgwLCBsZW5ndGggKyBpKTsKICAgICAgICBmb3IgKDsgaSA8IGxlbmd0aDsgaSsrKSB7CiAgICAgICAgICAgIGlmIChpIGluIHNlbGYgJiYgc2VsZltpXSA9PT0gc291Z2h0KSB7CiAgICAgICAgICAgICAgICByZXR1cm4gaTsKICAgICAgICAgICAgfQogICAgICAgIH0KICAgICAgICByZXR1cm4gLTE7CiAgICB9Owp9CmlmICghQXJyYXkucHJvdG90eXBlLmxhc3RJbmRleE9mIHx8IChbMCwgMV0ubGFzdEluZGV4T2YoMCwgLTMpICE9IC0xKSkgewogICAgQXJyYXkucHJvdG90eXBlLmxhc3RJbmRleE9mID0gZnVuY3Rpb24gbGFzdEluZGV4T2Yoc291Z2h0IC8qLCBmcm9tSW5kZXggKi8pIHsKICAgICAgICB2YXIgc2VsZiA9IHNwbGl0U3RyaW5nICYmIF90b1N0cmluZyh0aGlzKSA9PSAiW29iamVjdCBTdHJpbmddIiA/CiAgICAgICAgICAgICAgICB0aGlzLnNwbGl0KCIiKSA6CiAgICAgICAgICAgICAgICB0b09iamVjdCh0aGlzKSwKICAgICAgICAgICAgbGVuZ3RoID0gc2VsZi5sZW5ndGggPj4+IDA7CgogICAgICAgIGlmICghbGVuZ3RoKSB7CiAgICAgICAgICAgIHJldHVybiAtMTsKICAgICAgICB9CiAgICAgICAgdmFyIGkgPSBsZW5ndGggLSAxOwogICAgICAgIGlmIChhcmd1bWVudHMubGVuZ3RoID4gMSkgewogICAgICAgICAgICBpID0gTWF0aC5taW4oaSwgdG9JbnRlZ2VyKGFyZ3VtZW50c1sxXSkpOwogICAgICAgIH0KICAgICAgICBpID0gaSA+PSAwID8gaSA6IGxlbmd0aCAtIE1hdGguYWJzKGkpOwogICAgICAgIGZvciAoOyBpID49IDA7IGktLSkgewogICAgICAgICAgICBpZiAoaSBpbiBzZWxmICYmIHNvdWdodCA9PT0gc2VsZltpXSkgewogICAgICAgICAgICAgICAgcmV0dXJuIGk7CiAgICAgICAgICAgIH0KICAgICAgICB9CiAgICAgICAgcmV0dXJuIC0xOwogICAgfTsKfQppZiAoIU9iamVjdC5nZXRQcm90b3R5cGVPZikgewogICAgT2JqZWN0LmdldFByb3RvdHlwZU9mID0gZnVuY3Rpb24gZ2V0UHJvdG90eXBlT2Yob2JqZWN0KSB7CiAgICAgICAgcmV0dXJuIG9iamVjdC5fX3Byb3RvX18gfHwgKAogICAgICAgICAgICBvYmplY3QuY29uc3RydWN0b3IgPwogICAgICAgICAgICBvYmplY3QuY29uc3RydWN0b3IucHJvdG90eXBlIDoKICAgICAgICAgICAgcHJvdG90eXBlT2ZPYmplY3QKICAgICAgICApOwogICAgfTsKfQppZiAoIU9iamVjdC5nZXRPd25Qcm9wZXJ0eURlc2NyaXB0b3IpIHsKICAgIHZhciBFUlJfTk9OX09CSkVDVCA9ICJPYmplY3QuZ2V0T3duUHJvcGVydHlEZXNjcmlwdG9yIGNhbGxlZCBvbiBhICIgKwogICAgICAgICAgICAgICAgICAgICAgICAgIm5vbi1vYmplY3Q6ICI7CiAgICBPYmplY3QuZ2V0T3duUHJvcGVydHlEZXNjcmlwdG9yID0gZnVuY3Rpb24gZ2V0T3duUHJvcGVydHlEZXNjcmlwdG9yKG9iamVjdCwgcHJvcGVydHkpIHsKICAgICAgICBpZiAoKHR5cGVvZiBvYmplY3QgIT0gIm9iamVjdCIgJiYgdHlwZW9mIG9iamVjdCAhPSAiZnVuY3Rpb24iKSB8fCBvYmplY3QgPT09IG51bGwpCiAgICAgICAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoRVJSX05PTl9PQkpFQ1QgKyBvYmplY3QpOwogICAgICAgIGlmICghb3ducyhvYmplY3QsIHByb3BlcnR5KSkKICAgICAgICAgICAgcmV0dXJuOwoKICAgICAgICB2YXIgZGVzY3JpcHRvciwgZ2V0dGVyLCBzZXR0ZXI7CiAgICAgICAgZGVzY3JpcHRvciA9ICB7IGVudW1lcmFibGU6IHRydWUsIGNvbmZpZ3VyYWJsZTogdHJ1ZSB9OwogICAgICAgIGlmIChzdXBwb3J0c0FjY2Vzc29ycykgewogICAgICAgICAgICB2YXIgcHJvdG90eXBlID0gb2JqZWN0Ll9fcHJvdG9fXzsKICAgICAgICAgICAgb2JqZWN0Ll9fcHJvdG9fXyA9IHByb3RvdHlwZU9mT2JqZWN0OwoKICAgICAgICAgICAgdmFyIGdldHRlciA9IGxvb2t1cEdldHRlcihvYmplY3QsIHByb3BlcnR5KTsKICAgICAgICAgICAgdmFyIHNldHRlciA9IGxvb2t1cFNldHRlcihvYmplY3QsIHByb3BlcnR5KTsKICAgICAgICAgICAgb2JqZWN0Ll9fcHJvdG9fXyA9IHByb3RvdHlwZTsKCiAgICAgICAgICAgIGlmIChnZXR0ZXIgfHwgc2V0dGVyKSB7CiAgICAgICAgICAgICAgICBpZiAoZ2V0dGVyKSBkZXNjcmlwdG9yLmdldCA9IGdldHRlcjsKICAgICAgICAgICAgICAgIGlmIChzZXR0ZXIpIGRlc2NyaXB0b3Iuc2V0ID0gc2V0dGVyOwogICAgICAgICAgICAgICAgcmV0dXJuIGRlc2NyaXB0b3I7CiAgICAgICAgICAgIH0KICAgICAgICB9CiAgICAgICAgZGVzY3JpcHRvci52YWx1ZSA9IG9iamVjdFtwcm9wZXJ0eV07CiAgICAgICAgcmV0dXJuIGRlc2NyaXB0b3I7CiAgICB9Owp9CmlmICghT2JqZWN0LmdldE93blByb3BlcnR5TmFtZXMpIHsKICAgIE9iamVjdC5nZXRPd25Qcm9wZXJ0eU5hbWVzID0gZnVuY3Rpb24gZ2V0T3duUHJvcGVydHlOYW1lcyhvYmplY3QpIHsKICAgICAgICByZXR1cm4gT2JqZWN0LmtleXMob2JqZWN0KTsKICAgIH07Cn0KaWYgKCFPYmplY3QuY3JlYXRlKSB7CiAgICB2YXIgY3JlYXRlRW1wdHk7CiAgICBpZiAoT2JqZWN0LnByb3RvdHlwZS5fX3Byb3RvX18gPT09IG51bGwpIHsKICAgICAgICBjcmVhdGVFbXB0eSA9IGZ1bmN0aW9uICgpIHsKICAgICAgICAgICAgcmV0dXJuIHsgIl9fcHJvdG9fXyI6IG51bGwgfTsKICAgICAgICB9OwogICAgfSBlbHNlIHsKICAgICAgICBjcmVhdGVFbXB0eSA9IGZ1bmN0aW9uICgpIHsKICAgICAgICAgICAgdmFyIGVtcHR5ID0ge307CiAgICAgICAgICAgIGZvciAodmFyIGkgaW4gZW1wdHkpCiAgICAgICAgICAgICAgICBlbXB0eVtpXSA9IG51bGw7CiAgICAgICAgICAgIGVtcHR5LmNvbnN0cnVjdG9yID0KICAgICAgICAgICAgZW1wdHkuaGFzT3duUHJvcGVydHkgPQogICAgICAgICAgICBlbXB0eS5wcm9wZXJ0eUlzRW51bWVyYWJsZSA9CiAgICAgICAgICAgIGVtcHR5LmlzUHJvdG90eXBlT2YgPQogICAgICAgICAgICBlbXB0eS50b0xvY2FsZVN0cmluZyA9CiAgICAgICAgICAgIGVtcHR5LnRvU3RyaW5nID0KICAgICAgICAgICAgZW1wdHkudmFsdWVPZiA9CiAgICAgICAgICAgIGVtcHR5Ll9fcHJvdG9fXyA9IG51bGw7CiAgICAgICAgICAgIHJldHVybiBlbXB0eTsKICAgICAgICB9CiAgICB9CgogICAgT2JqZWN0LmNyZWF0ZSA9IGZ1bmN0aW9uIGNyZWF0ZShwcm90b3R5cGUsIHByb3BlcnRpZXMpIHsKICAgICAgICB2YXIgb2JqZWN0OwogICAgICAgIGlmIChwcm90b3R5cGUgPT09IG51bGwpIHsKICAgICAgICAgICAgb2JqZWN0ID0gY3JlYXRlRW1wdHkoKTsKICAgICAgICB9IGVsc2UgewogICAgICAgICAgICBpZiAodHlwZW9mIHByb3RvdHlwZSAhPSAib2JqZWN0IikKICAgICAgICAgICAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoInR5cGVvZiBwcm90b3R5cGVbIisodHlwZW9mIHByb3RvdHlwZSkrIl0gIT0gJ29iamVjdCciKTsKICAgICAgICAgICAgdmFyIFR5cGUgPSBmdW5jdGlvbiAoKSB7fTsKICAgICAgICAgICAgVHlwZS5wcm90b3R5cGUgPSBwcm90b3R5cGU7CiAgICAgICAgICAgIG9iamVjdCA9IG5ldyBUeXBlKCk7CiAgICAgICAgICAgIG9iamVjdC5fX3Byb3RvX18gPSBwcm90b3R5cGU7CiAgICAgICAgfQogICAgICAgIGlmIChwcm9wZXJ0aWVzICE9PSB2b2lkIDApCiAgICAgICAgICAgIE9iamVjdC5kZWZpbmVQcm9wZXJ0aWVzKG9iamVjdCwgcHJvcGVydGllcyk7CiAgICAgICAgcmV0dXJuIG9iamVjdDsKICAgIH07Cn0KCmZ1bmN0aW9uIGRvZXNEZWZpbmVQcm9wZXJ0eVdvcmsob2JqZWN0KSB7CiAgICB0cnkgewogICAgICAgIE9iamVjdC5kZWZpbmVQcm9wZXJ0eShvYmplY3QsICJzZW50aW5lbCIsIHt9KTsKICAgICAgICByZXR1cm4gInNlbnRpbmVsIiBpbiBvYmplY3Q7CiAgICB9IGNhdGNoIChleGNlcHRpb24pIHsKICAgIH0KfQppZiAoT2JqZWN0LmRlZmluZVByb3BlcnR5KSB7CiAgICB2YXIgZGVmaW5lUHJvcGVydHlXb3Jrc09uT2JqZWN0ID0gZG9lc0RlZmluZVByb3BlcnR5V29yayh7fSk7CiAgICB2YXIgZGVmaW5lUHJvcGVydHlXb3Jrc09uRG9tID0gdHlwZW9mIGRvY3VtZW50ID09ICJ1bmRlZmluZWQiIHx8CiAgICAgICAgZG9lc0RlZmluZVByb3BlcnR5V29yayhkb2N1bWVudC5jcmVhdGVFbGVtZW50KCJkaXYiKSk7CiAgICBpZiAoIWRlZmluZVByb3BlcnR5V29ya3NPbk9iamVjdCB8fCAhZGVmaW5lUHJvcGVydHlXb3Jrc09uRG9tKSB7CiAgICAgICAgdmFyIGRlZmluZVByb3BlcnR5RmFsbGJhY2sgPSBPYmplY3QuZGVmaW5lUHJvcGVydHk7CiAgICB9Cn0KCmlmICghT2JqZWN0LmRlZmluZVByb3BlcnR5IHx8IGRlZmluZVByb3BlcnR5RmFsbGJhY2spIHsKICAgIHZhciBFUlJfTk9OX09CSkVDVF9ERVNDUklQVE9SID0gIlByb3BlcnR5IGRlc2NyaXB0aW9uIG11c3QgYmUgYW4gb2JqZWN0OiAiOwogICAgdmFyIEVSUl9OT05fT0JKRUNUX1RBUkdFVCA9ICJPYmplY3QuZGVmaW5lUHJvcGVydHkgY2FsbGVkIG9uIG5vbi1vYmplY3Q6ICIKICAgIHZhciBFUlJfQUNDRVNTT1JTX05PVF9TVVBQT1JURUQgPSAiZ2V0dGVycyAmIHNldHRlcnMgY2FuIG5vdCBiZSBkZWZpbmVkICIgKwogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICJvbiB0aGlzIGphdmFzY3JpcHQgZW5naW5lIjsKCiAgICBPYmplY3QuZGVmaW5lUHJvcGVydHkgPSBmdW5jdGlvbiBkZWZpbmVQcm9wZXJ0eShvYmplY3QsIHByb3BlcnR5LCBkZXNjcmlwdG9yKSB7CiAgICAgICAgaWYgKCh0eXBlb2Ygb2JqZWN0ICE9ICJvYmplY3QiICYmIHR5cGVvZiBvYmplY3QgIT0gImZ1bmN0aW9uIikgfHwgb2JqZWN0ID09PSBudWxsKQogICAgICAgICAgICB0aHJvdyBuZXcgVHlwZUVycm9yKEVSUl9OT05fT0JKRUNUX1RBUkdFVCArIG9iamVjdCk7CiAgICAgICAgaWYgKCh0eXBlb2YgZGVzY3JpcHRvciAhPSAib2JqZWN0IiAmJiB0eXBlb2YgZGVzY3JpcHRvciAhPSAiZnVuY3Rpb24iKSB8fCBkZXNjcmlwdG9yID09PSBudWxsKQogICAgICAgICAgICB0aHJvdyBuZXcgVHlwZUVycm9yKEVSUl9OT05fT0JKRUNUX0RFU0NSSVBUT1IgKyBkZXNjcmlwdG9yKTsKICAgICAgICBpZiAoZGVmaW5lUHJvcGVydHlGYWxsYmFjaykgewogICAgICAgICAgICB0cnkgewogICAgICAgICAgICAgICAgcmV0dXJuIGRlZmluZVByb3BlcnR5RmFsbGJhY2suY2FsbChPYmplY3QsIG9iamVjdCwgcHJvcGVydHksIGRlc2NyaXB0b3IpOwogICAgICAgICAgICB9IGNhdGNoIChleGNlcHRpb24pIHsKICAgICAgICAgICAgfQogICAgICAgIH0KICAgICAgICBpZiAob3ducyhkZXNjcmlwdG9yLCAidmFsdWUiKSkgewoKICAgICAgICAgICAgaWYgKHN1cHBvcnRzQWNjZXNzb3JzICYmIChsb29rdXBHZXR0ZXIob2JqZWN0LCBwcm9wZXJ0eSkgfHwKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBsb29rdXBTZXR0ZXIob2JqZWN0LCBwcm9wZXJ0eSkpKQogICAgICAgICAgICB7CiAgICAgICAgICAgICAgICB2YXIgcHJvdG90eXBlID0gb2JqZWN0Ll9fcHJvdG9fXzsKICAgICAgICAgICAgICAgIG9iamVjdC5fX3Byb3RvX18gPSBwcm90b3R5cGVPZk9iamVjdDsKICAgICAgICAgICAgICAgIGRlbGV0ZSBvYmplY3RbcHJvcGVydHldOwogICAgICAgICAgICAgICAgb2JqZWN0W3Byb3BlcnR5XSA9IGRlc2NyaXB0b3IudmFsdWU7CiAgICAgICAgICAgICAgICBvYmplY3QuX19wcm90b19fID0gcHJvdG90eXBlOwogICAgICAgICAgICB9IGVsc2UgewogICAgICAgICAgICAgICAgb2JqZWN0W3Byb3BlcnR5XSA9IGRlc2NyaXB0b3IudmFsdWU7CiAgICAgICAgICAgIH0KICAgICAgICB9IGVsc2UgewogICAgICAgICAgICBpZiAoIXN1cHBvcnRzQWNjZXNzb3JzKQogICAgICAgICAgICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcihFUlJfQUNDRVNTT1JTX05PVF9TVVBQT1JURUQpOwogICAgICAgICAgICBpZiAob3ducyhkZXNjcmlwdG9yLCAiZ2V0IikpCiAgICAgICAgICAgICAgICBkZWZpbmVHZXR0ZXIob2JqZWN0LCBwcm9wZXJ0eSwgZGVzY3JpcHRvci5nZXQpOwogICAgICAgICAgICBpZiAob3ducyhkZXNjcmlwdG9yLCAic2V0IikpCiAgICAgICAgICAgICAgICBkZWZpbmVTZXR0ZXIob2JqZWN0LCBwcm9wZXJ0eSwgZGVzY3JpcHRvci5zZXQpOwogICAgICAgIH0KCiAgICAgICAgcmV0dXJuIG9iamVjdDsKICAgIH07Cn0KaWYgKCFPYmplY3QuZGVmaW5lUHJvcGVydGllcykgewogICAgT2JqZWN0LmRlZmluZVByb3BlcnRpZXMgPSBmdW5jdGlvbiBkZWZpbmVQcm9wZXJ0aWVzKG9iamVjdCwgcHJvcGVydGllcykgewogICAgICAgIGZvciAodmFyIHByb3BlcnR5IGluIHByb3BlcnRpZXMpIHsKICAgICAgICAgICAgaWYgKG93bnMocHJvcGVydGllcywgcHJvcGVydHkpKQogICAgICAgICAgICAgICAgT2JqZWN0LmRlZmluZVByb3BlcnR5KG9iamVjdCwgcHJvcGVydHksIHByb3BlcnRpZXNbcHJvcGVydHldKTsKICAgICAgICB9CiAgICAgICAgcmV0dXJuIG9iamVjdDsKICAgIH07Cn0KaWYgKCFPYmplY3Quc2VhbCkgewogICAgT2JqZWN0LnNlYWwgPSBmdW5jdGlvbiBzZWFsKG9iamVjdCkgewogICAgICAgIHJldHVybiBvYmplY3Q7CiAgICB9Owp9CmlmICghT2JqZWN0LmZyZWV6ZSkgewogICAgT2JqZWN0LmZyZWV6ZSA9IGZ1bmN0aW9uIGZyZWV6ZShvYmplY3QpIHsKICAgICAgICByZXR1cm4gb2JqZWN0OwogICAgfTsKfQp0cnkgewogICAgT2JqZWN0LmZyZWV6ZShmdW5jdGlvbiAoKSB7fSk7Cn0gY2F0Y2ggKGV4Y2VwdGlvbikgewogICAgT2JqZWN0LmZyZWV6ZSA9IChmdW5jdGlvbiBmcmVlemUoZnJlZXplT2JqZWN0KSB7CiAgICAgICAgcmV0dXJuIGZ1bmN0aW9uIGZyZWV6ZShvYmplY3QpIHsKICAgICAgICAgICAgaWYgKHR5cGVvZiBvYmplY3QgPT0gImZ1bmN0aW9uIikgewogICAgICAgICAgICAgICAgcmV0dXJuIG9iamVjdDsKICAgICAgICAgICAgfSBlbHNlIHsKICAgICAgICAgICAgICAgIHJldHVybiBmcmVlemVPYmplY3Qob2JqZWN0KTsKICAgICAgICAgICAgfQogICAgICAgIH07CiAgICB9KShPYmplY3QuZnJlZXplKTsKfQppZiAoIU9iamVjdC5wcmV2ZW50RXh0ZW5zaW9ucykgewogICAgT2JqZWN0LnByZXZlbnRFeHRlbnNpb25zID0gZnVuY3Rpb24gcHJldmVudEV4dGVuc2lvbnMob2JqZWN0KSB7CiAgICAgICAgcmV0dXJuIG9iamVjdDsKICAgIH07Cn0KaWYgKCFPYmplY3QuaXNTZWFsZWQpIHsKICAgIE9iamVjdC5pc1NlYWxlZCA9IGZ1bmN0aW9uIGlzU2VhbGVkKG9iamVjdCkgewogICAgICAgIHJldHVybiBmYWxzZTsKICAgIH07Cn0KaWYgKCFPYmplY3QuaXNGcm96ZW4pIHsKICAgIE9iamVjdC5pc0Zyb3plbiA9IGZ1bmN0aW9uIGlzRnJvemVuKG9iamVjdCkgewogICAgICAgIHJldHVybiBmYWxzZTsKICAgIH07Cn0KaWYgKCFPYmplY3QuaXNFeHRlbnNpYmxlKSB7CiAgICBPYmplY3QuaXNFeHRlbnNpYmxlID0gZnVuY3Rpb24gaXNFeHRlbnNpYmxlKG9iamVjdCkgewogICAgICAgIGlmIChPYmplY3Qob2JqZWN0KSA9PT0gb2JqZWN0KSB7CiAgICAgICAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoKTsgLy8gVE9ETyBtZXNzYWdlCiAgICAgICAgfQogICAgICAgIHZhciBuYW1lID0gJyc7CiAgICAgICAgd2hpbGUgKG93bnMob2JqZWN0LCBuYW1lKSkgewogICAgICAgICAgICBuYW1lICs9ICc/JzsKICAgICAgICB9CiAgICAgICAgb2JqZWN0W25hbWVdID0gdHJ1ZTsKICAgICAgICB2YXIgcmV0dXJuVmFsdWUgPSBvd25zKG9iamVjdCwgbmFtZSk7CiAgICAgICAgZGVsZXRlIG9iamVjdFtuYW1lXTsKICAgICAgICByZXR1cm4gcmV0dXJuVmFsdWU7CiAgICB9Owp9CmlmICghT2JqZWN0LmtleXMpIHsKICAgIHZhciBoYXNEb250RW51bUJ1ZyA9IHRydWUsCiAgICAgICAgZG9udEVudW1zID0gWwogICAgICAgICAgICAidG9TdHJpbmciLAogICAgICAgICAgICAidG9Mb2NhbGVTdHJpbmciLAogICAgICAgICAgICAidmFsdWVPZiIsCiAgICAgICAgICAgICJoYXNPd25Qcm9wZXJ0eSIsCiAgICAgICAgICAgICJpc1Byb3RvdHlwZU9mIiwKICAgICAgICAgICAgInByb3BlcnR5SXNFbnVtZXJhYmxlIiwKICAgICAgICAgICAgImNvbnN0cnVjdG9yIgogICAgICAgIF0sCiAgICAgICAgZG9udEVudW1zTGVuZ3RoID0gZG9udEVudW1zLmxlbmd0aDsKCiAgICBmb3IgKHZhciBrZXkgaW4geyJ0b1N0cmluZyI6IG51bGx9KSB7CiAgICAgICAgaGFzRG9udEVudW1CdWcgPSBmYWxzZTsKICAgIH0KCiAgICBPYmplY3Qua2V5cyA9IGZ1bmN0aW9uIGtleXMob2JqZWN0KSB7CgogICAgICAgIGlmICgKICAgICAgICAgICAgKHR5cGVvZiBvYmplY3QgIT0gIm9iamVjdCIgJiYgdHlwZW9mIG9iamVjdCAhPSAiZnVuY3Rpb24iKSB8fAogICAgICAgICAgICBvYmplY3QgPT09IG51bGwKICAgICAgICApIHsKICAgICAgICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcigiT2JqZWN0LmtleXMgY2FsbGVkIG9uIGEgbm9uLW9iamVjdCIpOwogICAgICAgIH0KCiAgICAgICAgdmFyIGtleXMgPSBbXTsKICAgICAgICBmb3IgKHZhciBuYW1lIGluIG9iamVjdCkgewogICAgICAgICAgICBpZiAob3ducyhvYmplY3QsIG5hbWUpKSB7CiAgICAgICAgICAgICAgICBrZXlzLnB1c2gobmFtZSk7CiAgICAgICAgICAgIH0KICAgICAgICB9CgogICAgICAgIGlmIChoYXNEb250RW51bUJ1ZykgewogICAgICAgICAgICBmb3IgKHZhciBpID0gMCwgaWkgPSBkb250RW51bXNMZW5ndGg7IGkgPCBpaTsgaSsrKSB7CiAgICAgICAgICAgICAgICB2YXIgZG9udEVudW0gPSBkb250RW51bXNbaV07CiAgICAgICAgICAgICAgICBpZiAob3ducyhvYmplY3QsIGRvbnRFbnVtKSkgewogICAgICAgICAgICAgICAgICAgIGtleXMucHVzaChkb250RW51bSk7CiAgICAgICAgICAgICAgICB9CiAgICAgICAgICAgIH0KICAgICAgICB9CiAgICAgICAgcmV0dXJuIGtleXM7CiAgICB9OwoKfQppZiAoIURhdGUubm93KSB7CiAgICBEYXRlLm5vdyA9IGZ1bmN0aW9uIG5vdygpIHsKICAgICAgICByZXR1cm4gbmV3IERhdGUoKS5nZXRUaW1lKCk7CiAgICB9Owp9CnZhciB3cyA9ICJceDA5XHgwQVx4MEJceDBDXHgwRFx4MjBceEEwXHUxNjgwXHUyMDAwXHUyMDAxXHUyMDAyXHUyMDAzIiArCiAgICAiXHUyMDA0XHUyMDA1XHUyMDA2XHUyMDA3XHUyMDA4XHUyMDA5XHUyMDBBXHUyMDJGXHUyMDVGXHUzMDAwXHUyMDI4IiArCiAgICAiXHUyMDI5XHVGRUZGIjsKaWYgKCFTdHJpbmcucHJvdG90eXBlLnRyaW0pIHsKICAgIHdzID0gIlsiICsgd3MgKyAiXSI7CiAgICB2YXIgdHJpbUJlZ2luUmVnZXhwID0gbmV3IFJlZ0V4cCgiXiIgKyB3cyArIHdzICsgIioiKSwKICAgICAgICB0cmltRW5kUmVnZXhwID0gbmV3IFJlZ0V4cCh3cyArIHdzICsgIiokIik7CiAgICBTdHJpbmcucHJvdG90eXBlLnRyaW0gPSBmdW5jdGlvbiB0cmltKCkgewogICAgICAgIHJldHVybiBTdHJpbmcodGhpcykucmVwbGFjZSh0cmltQmVnaW5SZWdleHAsICIiKS5yZXBsYWNlKHRyaW1FbmRSZWdleHAsICIiKTsKICAgIH07Cn0KCmZ1bmN0aW9uIHRvSW50ZWdlcihuKSB7CiAgICBuID0gK247CiAgICBpZiAobiAhPT0gbikgeyAvLyBpc05hTgogICAgICAgIG4gPSAwOwogICAgfSBlbHNlIGlmIChuICE9PSAwICYmIG4gIT09ICgxLzApICYmIG4gIT09IC0oMS8wKSkgewogICAgICAgIG4gPSAobiA+IDAgfHwgLTEpICogTWF0aC5mbG9vcihNYXRoLmFicyhuKSk7CiAgICB9CiAgICByZXR1cm4gbjsKfQoKZnVuY3Rpb24gaXNQcmltaXRpdmUoaW5wdXQpIHsKICAgIHZhciB0eXBlID0gdHlwZW9mIGlucHV0OwogICAgcmV0dXJuICgKICAgICAgICBpbnB1dCA9PT0gbnVsbCB8fAogICAgICAgIHR5cGUgPT09ICJ1bmRlZmluZWQiIHx8CiAgICAgICAgdHlwZSA9PT0gImJvb2xlYW4iIHx8CiAgICAgICAgdHlwZSA9PT0gIm51bWJlciIgfHwKICAgICAgICB0eXBlID09PSAic3RyaW5nIgogICAgKTsKfQoKZnVuY3Rpb24gdG9QcmltaXRpdmUoaW5wdXQpIHsKICAgIHZhciB2YWwsIHZhbHVlT2YsIHRvU3RyaW5nOwogICAgaWYgKGlzUHJpbWl0aXZlKGlucHV0KSkgewogICAgICAgIHJldHVybiBpbnB1dDsKICAgIH0KICAgIHZhbHVlT2YgPSBpbnB1dC52YWx1ZU9mOwogICAgaWYgKHR5cGVvZiB2YWx1ZU9mID09PSAiZnVuY3Rpb24iKSB7CiAgICAgICAgdmFsID0gdmFsdWVPZi5jYWxsKGlucHV0KTsKICAgICAgICBpZiAoaXNQcmltaXRpdmUodmFsKSkgewogICAgICAgICAgICByZXR1cm4gdmFsOwogICAgICAgIH0KICAgIH0KICAgIHRvU3RyaW5nID0gaW5wdXQudG9TdHJpbmc7CiAgICBpZiAodHlwZW9mIHRvU3RyaW5nID09PSAiZnVuY3Rpb24iKSB7CiAgICAgICAgdmFsID0gdG9TdHJpbmcuY2FsbChpbnB1dCk7CiAgICAgICAgaWYgKGlzUHJpbWl0aXZlKHZhbCkpIHsKICAgICAgICAgICAgcmV0dXJuIHZhbDsKICAgICAgICB9CiAgICB9CiAgICB0aHJvdyBuZXcgVHlwZUVycm9yKCk7Cn0KdmFyIHRvT2JqZWN0ID0gZnVuY3Rpb24gKG8pIHsKICAgIGlmIChvID09IG51bGwpIHsgLy8gdGhpcyBtYXRjaGVzIGJvdGggbnVsbCBhbmQgdW5kZWZpbmVkCiAgICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcigiY2FuJ3QgY29udmVydCAiK28rIiB0byBvYmplY3QiKTsKICAgIH0KICAgIHJldHVybiBPYmplY3Qobyk7Cn07Cgp9KTsK"
},function(e,t,i){e.exports=function(){"use strict";var s=function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")},e=function(){function n(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}return function(e,t,i){return t&&n(e.prototype,t),i&&n(e,i),e}}(),m=function(e,t){if(Array.isArray(e))return e;if(Symbol.iterator in Object(e))return function(e,t){var i=[],n=!0,r=!1,o=void 0;try{for(var s,a=e[Symbol.iterator]();!(n=(s=a.next()).done)&&(i.push(s.value),!t||i.length!==t);n=!0);}catch(e){r=!0,o=e}finally{try{!n&&a.return&&a.return()}finally{if(r)throw o}}return i}(e,t);throw new TypeError("Invalid attempt to destructure non-iterable instance")};String.prototype.startsWith=String.prototype.startsWith||function(e){return 0===this.indexOf(e)},String.prototype.padStart=String.prototype.padStart||function(e,t){for(var i=this;i.length<e;)i=t+i;return i};var n={cb:"0f8ff",tqw:"aebd7",q:"-ffff",qmrn:"7fffd4",zr:"0ffff",bg:"5f5dc",bsq:"e4c4",bck:"---",nch:"ebcd",b:"--ff",bvt:"8a2be2",brwn:"a52a2a",brw:"deb887",ctb:"5f9ea0",hrt:"7fff-",chcT:"d2691e",cr:"7f50",rnw:"6495ed",crns:"8dc",crms:"dc143c",cn:"-ffff",Db:"--8b",Dcn:"-8b8b",Dgnr:"b8860b",Dgr:"a9a9a9",Dgrn:"-64-",Dkhk:"bdb76b",Dmgn:"8b-8b",Dvgr:"556b2f",Drng:"8c-",Drch:"9932cc",Dr:"8b--",Dsmn:"e9967a",Dsgr:"8fbc8f",DsTb:"483d8b",DsTg:"2f4f4f",Dtrq:"-ced1",Dvt:"94-d3",ppnk:"1493",pskb:"-bfff",mgr:"696969",grb:"1e90ff",rbrc:"b22222",rwht:"af0",stg:"228b22",chs:"-ff",gnsb:"dcdcdc",st:"8f8ff",g:"d7-",gnr:"daa520",gr:"808080",grn:"-8-0",grnw:"adff2f",hnw:"0fff0",htpn:"69b4",nnr:"cd5c5c",ng:"4b-82",vr:"0",khk:"0e68c",vnr:"e6e6fa",nrb:"0f5",wngr:"7cfc-",mnch:"acd",Lb:"add8e6",Lcr:"08080",Lcn:"e0ffff",Lgnr:"afad2",Lgr:"d3d3d3",Lgrn:"90ee90",Lpnk:"b6c1",Lsmn:"a07a",Lsgr:"20b2aa",Lskb:"87cefa",LsTg:"778899",Lstb:"b0c4de",Lw:"e0",m:"-ff-",mgrn:"32cd32",nn:"af0e6",mgnt:"-ff",mrn:"8--0",mqm:"66cdaa",mmb:"--cd",mmrc:"ba55d3",mmpr:"9370db",msg:"3cb371",mmsT:"7b68ee","":"-fa9a",mtr:"48d1cc",mmvt:"c71585",mnLb:"191970",ntc:"5fffa",mstr:"e4e1",mccs:"e4b5",vjw:"dead",nv:"--80",c:"df5e6",v:"808-0",vrb:"6b8e23",rng:"a5-",rngr:"45-",rch:"da70d6",pgnr:"eee8aa",pgrn:"98fb98",ptrq:"afeeee",pvtr:"db7093",ppwh:"efd5",pchp:"dab9",pr:"cd853f",pnk:"c0cb",pm:"dda0dd",pwrb:"b0e0e6",prp:"8-080",cc:"663399",r:"--",sbr:"bc8f8f",rb:"4169e1",sbrw:"8b4513",smn:"a8072",nbr:"4a460",sgrn:"2e8b57",ssh:"5ee",snn:"a0522d",svr:"c0c0c0",skb:"87ceeb",sTb:"6a5acd",sTgr:"708090",snw:"afa",n:"-ff7f",stb:"4682b4",tn:"d2b48c",t:"-8080",thst:"d8bfd8",tmT:"6347",trqs:"40e0d0",vt:"ee82ee",whT:"5deb3",wht:"",hts:"5f5f5",w:"-",wgrn:"9acd32"};function o(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:1,i=0<t?e.toFixed(t).replace(/0+$/,"").replace(/\.$/,""):e.toString();return i||"0"}var r=function(){function p(e,t,i,n){s(this,p);var g=this;if(void 0===e);else if(Array.isArray(e))this.rgba=e;else if(void 0===i){var r=e&&""+e;r&&function(e){if(e.startsWith("hsl")){var t=e.match(/([\-\d\.e]+)/g).map(Number),i=m(t,4),n=i[0],r=i[1],o=i[2],s=i[3];void 0===s&&(s=1),n/=360,r/=100,o/=100,g.hsla=[n,r,o,s]}else if(e.startsWith("rgb")){var a=e.match(/([\-\d\.e]+)/g).map(Number),l=m(a,4),c=l[0],h=l[1],d=l[2],u=l[3];void 0===u&&(u=1),g.rgba=[c,h,d,u]}else e.startsWith("#")?g.rgba=p.hexToRgb(e):g.rgba=p.nameToRgb(e)||p.hexToRgb(e)}(r.toLowerCase())}else this.rgba=[e,t,i,void 0===n?1:n]}return e(p,[{key:"printRGB",value:function(e){var t=e?this.rgba:this.rgba.slice(0,3),i=t.map(function(e,t){return o(e,3===t?3:0)});return e?"rgba("+i+")":"rgb("+i+")"}},{key:"printHSL",value:function(e){var i=[360,100,100,1],n=["","%","%",""],t=e?this.hsla:this.hsla.slice(0,3),r=t.map(function(e,t){return o(e*i[t],3===t?3:1)+n[t]});return e?"hsla("+r+")":"hsl("+r+")"}},{key:"printHex",value:function(e){var t=this.hex;return e?t:t.substring(0,7)}},{key:"rgba",get:function(){if(this._rgba)return this._rgba;if(!this._hsla)throw new Error("No color is set");return this._rgba=p.hslToRgb(this._hsla)},set:function(e){3===e.length&&(e[3]=1),this._rgba=e,this._hsla=null}},{key:"rgbString",get:function(){return this.printRGB()}},{key:"rgbaString",get:function(){return this.printRGB(!0)}},{key:"hsla",get:function(){if(this._hsla)return this._hsla;if(!this._rgba)throw new Error("No color is set");return this._hsla=p.rgbToHsl(this._rgba)},set:function(e){3===e.length&&(e[3]=1),this._hsla=e,this._rgba=null}},{key:"hslString",get:function(){return this.printHSL()}},{key:"hslaString",get:function(){return this.printHSL(!0)}},{key:"hex",get:function(){var e=this.rgba,t=e.map(function(e,t){return t<3?e.toString(16):Math.round(255*e).toString(16)});return"#"+t.map(function(e){return e.padStart(2,"0")}).join("")},set:function(e){this.rgba=p.hexToRgb(e)}}],[{key:"hexToRgb",value:function(e){var t=(e.startsWith("#")?e.slice(1):e).replace(/^(\w{3})$/,"$1F").replace(/^(\w)(\w)(\w)(\w)$/,"$1$1$2$2$3$3$4$4").replace(/^(\w{6})$/,"$1FF");if(!t.match(/^([0-9a-fA-F]{8})$/))throw new Error("Unknown hex color; "+e);var i=t.match(/^(\w\w)(\w\w)(\w\w)(\w\w)$/).slice(1).map(function(e){return parseInt(e,16)});return i[3]=i[3]/255,i}},{key:"nameToRgb",value:function(e){var t=e.toLowerCase().replace("at","T").replace(/[aeiouyldf]/g,"").replace("ght","L").replace("rk","D").slice(-5,4),i=n[t];return void 0===i?i:p.hexToRgb(i.replace(/\-/g,"00").padStart(6,"f"))}},{key:"rgbToHsl",value:function(e){var t=m(e,4),i=t[0],n=t[1],r=t[2],o=t[3];i/=255,n/=255,r/=255;var s=Math.max(i,n,r),a=Math.min(i,n,r),l=void 0,c=void 0,h=(s+a)/2;if(s===a)l=c=0;else{var d=s-a;switch(c=.5<h?d/(2-s-a):d/(s+a),s){case i:l=(n-r)/d+(n<r?6:0);break;case n:l=(r-i)/d+2;break;case r:l=(i-n)/d+4}l/=6}return[l,c,h,o]}},{key:"hslToRgb",value:function(e){var t=m(e,4),i=t[0],n=t[1],r=t[2],o=t[3],s=void 0,a=void 0,l=void 0;if(0===n)s=a=l=r;else{var c=function(e,t,i){return i<0&&(i+=1),1<i&&(i-=1),i<1/6?e+6*(t-e)*i:i<.5?t:i<2/3?e+(t-e)*(2/3-i)*6:e},h=r<.5?r*(1+n):r+n-r*n,d=2*r-h;s=c(d,h,i+1/3),a=c(d,h,i),l=c(d,h,i-1/3)}var u=[255*s,255*a,255*l].map(Math.round);return u[3]=o,u}}]),p}(),i=function(){function o(){s(this,o),this._events=[]}return e(o,[{key:"add",value:function(e,t,i){e.addEventListener(t,i,!1),this._events.push({target:e,type:t,handler:i})}},{key:"remove",value:function(i,n,r){this._events=this._events.filter(function(e){var t=!0;return i&&i!==e.target&&(t=!1),n&&n!==e.type&&(t=!1),r&&r!==e.handler&&(t=!1),t&&o._doRemove(e.target,e.type,e.handler),!t})}},{key:"destroy",value:function(){this._events.forEach(function(e){return o._doRemove(e.target,e.type,e.handler)}),this._events=[]}}],[{key:"_doRemove",value:function(e,t,i){e.removeEventListener(t,i,!1)}}]),o}();function a(e,h,d){var u=!1;function g(e,t,i){return Math.max(t,Math.min(e,i))}function n(e,t,i){if(i&&(u=!0),u){e.preventDefault();var n=h.getBoundingClientRect(),r=n.width,o=n.height,s=t.clientX,a=t.clientY,l=g(s-n.left,0,r),c=g(a-n.top,0,o);d(l/r,c/o)}}function t(e,t){var i=void 0===e.buttons?e.which:e.buttons;1===i?n(e,e,t):u=!1}function i(e,t){1===e.touches.length?n(e,e.touches[0],t):u=!1}e.add(h,"mousedown",function(e){t(e,!0)}),e.add(h,"touchstart",function(e){i(e,!0)}),e.add(window,"mousemove",t),e.add(h,"touchmove",i),e.add(window,"mouseup",function(e){u=!1}),e.add(h,"touchend",function(e){u=!1}),e.add(h,"touchcancel",function(e){u=!1})}var l="mousedown",c="focusin";function v(e,t){return(t||document).querySelector(e)}function h(e){e.preventDefault(),e.stopPropagation()}function d(e,t,i,n,r){e.add(t,"keydown",function(e){0<=i.indexOf(e.key)&&(r&&h(e),n(e))})}var u=document.createElement("style");return u.textContent=".picker_wrapper.no_alpha .picker_alpha{display:none}.picker_wrapper.no_editor .picker_editor{position:absolute;z-index:-1;opacity:0}.picker_wrapper.no_cancel .picker_cancel{display:none}.layout_default.picker_wrapper{display:-webkit-box;display:flex;-webkit-box-orient:horizontal;-webkit-box-direction:normal;flex-flow:row wrap;-webkit-box-pack:justify;justify-content:space-between;-webkit-box-align:stretch;align-items:stretch;font-size:10px;width:25em;padding:.5em}.layout_default.picker_wrapper input,.layout_default.picker_wrapper button{font-size:1rem}.layout_default.picker_wrapper>*{margin:.5em}.layout_default.picker_wrapper::before{content:'';display:block;width:100%;height:0;-webkit-box-ordinal-group:2;order:1}.layout_default .picker_slider,.layout_default .picker_selector{padding:1em}.layout_default .picker_hue{width:100%}.layout_default .picker_sl{-webkit-box-flex:1;flex:1 1 auto}.layout_default .picker_sl::before{content:'';display:block;padding-bottom:100%}.layout_default .picker_editor{-webkit-box-ordinal-group:2;order:1;width:6.5rem}.layout_default .picker_editor input{width:100%;height:100%}.layout_default .picker_sample{-webkit-box-ordinal-group:2;order:1;-webkit-box-flex:1;flex:1 1 auto}.layout_default .picker_done,.layout_default .picker_cancel{-webkit-box-ordinal-group:2;order:1}.picker_wrapper{box-sizing:border-box;background:#f2f2f2;box-shadow:0 0 0 1px silver;cursor:default;font-family:sans-serif;color:#444;pointer-events:auto}.picker_wrapper:focus{outline:none}.picker_wrapper button,.picker_wrapper input{box-sizing:border-box;border:none;box-shadow:0 0 0 1px silver;outline:none}.picker_wrapper button:focus,.picker_wrapper button:active,.picker_wrapper input:focus,.picker_wrapper input:active{box-shadow:0 0 2px 1px dodgerblue}.picker_wrapper button{padding:.4em .6em;cursor:pointer;background-color:whitesmoke;background-image:-webkit-gradient(linear, left bottom, left top, from(gainsboro), to(transparent));background-image:-webkit-linear-gradient(bottom, gainsboro, transparent);background-image:linear-gradient(0deg, gainsboro, transparent)}.picker_wrapper button:active{background-image:-webkit-gradient(linear, left bottom, left top, from(transparent), to(gainsboro));background-image:-webkit-linear-gradient(bottom, transparent, gainsboro);background-image:linear-gradient(0deg, transparent, gainsboro)}.picker_wrapper button:hover{background-color:white}.picker_selector{position:absolute;z-index:1;display:block;-webkit-transform:translate(-50%, -50%);transform:translate(-50%, -50%);border:2px solid white;border-radius:100%;box-shadow:0 0 3px 1px #67b9ff;background:currentColor;cursor:pointer}.picker_slider .picker_selector{border-radius:2px}.picker_hue{position:relative;background-image:-webkit-gradient(linear, left top, right top, from(red), color-stop(yellow), color-stop(lime), color-stop(cyan), color-stop(blue), color-stop(magenta), to(red));background-image:-webkit-linear-gradient(left, red, yellow, lime, cyan, blue, magenta, red);background-image:linear-gradient(90deg, red, yellow, lime, cyan, blue, magenta, red);box-shadow:0 0 0 1px silver}.picker_sl{position:relative;box-shadow:0 0 0 1px silver;background-image:-webkit-gradient(linear, left top, left bottom, from(white), color-stop(50%, rgba(255,255,255,0))),-webkit-gradient(linear, left bottom, left top, from(black), color-stop(50%, rgba(0,0,0,0))),-webkit-gradient(linear, left top, right top, from(gray), to(rgba(128,128,128,0)));background-image:-webkit-linear-gradient(top, white, rgba(255,255,255,0) 50%),-webkit-linear-gradient(bottom, black, rgba(0,0,0,0) 50%),-webkit-linear-gradient(left, gray, rgba(128,128,128,0));background-image:linear-gradient(180deg, white, rgba(255,255,255,0) 50%),linear-gradient(0deg, black, rgba(0,0,0,0) 50%),linear-gradient(90deg, gray, rgba(128,128,128,0))}.picker_alpha,.picker_sample{position:relative;background:url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='2' height='2'%3E%3Cpath d='M1,0H0V1H2V2H1' fill='lightgrey'/%3E%3C/svg%3E\") left top/contain white;box-shadow:0 0 0 1px silver}.picker_alpha .picker_selector,.picker_sample .picker_selector{background:none}.picker_editor input{font-family:monospace;padding:.2em .4em}.picker_sample::before{content:'';position:absolute;display:block;width:100%;height:100%;background:currentColor}.picker_arrow{position:absolute;z-index:-1}.picker_wrapper.popup{position:absolute;z-index:2;margin:1.5em}.picker_wrapper.popup,.picker_wrapper.popup .picker_arrow::before,.picker_wrapper.popup .picker_arrow::after{background:#f2f2f2;box-shadow:0 0 10px 1px rgba(0,0,0,0.4)}.picker_wrapper.popup .picker_arrow{width:3em;height:3em;margin:0}.picker_wrapper.popup .picker_arrow::before,.picker_wrapper.popup .picker_arrow::after{content:\"\";display:block;position:absolute;top:0;left:0;z-index:-99}.picker_wrapper.popup .picker_arrow::before{width:100%;height:100%;-webkit-transform:skew(45deg);transform:skew(45deg);-webkit-transform-origin:0 100%;transform-origin:0 100%}.picker_wrapper.popup .picker_arrow::after{width:150%;height:150%;box-shadow:none}.popup.popup_top{bottom:100%;left:0}.popup.popup_top .picker_arrow{bottom:0;left:0;-webkit-transform:rotate(-90deg);transform:rotate(-90deg)}.popup.popup_bottom{top:100%;left:0}.popup.popup_bottom .picker_arrow{top:0;left:0;-webkit-transform:rotate(90deg) scale(1, -1);transform:rotate(90deg) scale(1, -1)}.popup.popup_left{top:0;right:100%}.popup.popup_left .picker_arrow{top:0;right:0;-webkit-transform:scale(-1, 1);transform:scale(-1, 1)}.popup.popup_right{top:0;left:100%}.popup.popup_right .picker_arrow{top:0;left:0}",document.documentElement.firstElementChild.appendChild(u),function(){function t(e){s(this,t),this.settings={popup:"right",layout:"default",alpha:!0,editor:!0,editorFormat:"hex",cancelButton:!1},this._events=new i,this.onChange=null,this.onDone=null,this.onOpen=null,this.onClose=null,this.setOptions(e)}return e(t,[{key:"setOptions",value:function(e){var t=this;if(e){var i=this.settings;if(e instanceof HTMLElement)i.parent=e;else{i.parent&&e.parent&&i.parent!==e.parent&&(this._events.remove(i.parent),this._popupInited=!1),function(e,t,i){for(var n in e)i&&0<=i.indexOf(n)||(t[n]=e[n])}(e,i),e.onChange&&(this.onChange=e.onChange),e.onDone&&(this.onDone=e.onDone),e.onOpen&&(this.onOpen=e.onOpen),e.onClose&&(this.onClose=e.onClose);var n=e.color||e.colour;n&&this._setColor(n)}var r=i.parent;if(r&&i.popup&&!this._popupInited){function o(e){return t.openHandler(e)}this._events.add(r,"click",o),d(this._events,r,[" ","Spacebar","Enter"],o),this._popupInited=!0}else e.parent&&!i.popup&&this.show()}}},{key:"openHandler",value:function(e){if(this.show()){e&&e.preventDefault(),this.settings.parent.style.pointerEvents="none";var t=e&&"keydown"===e.type?this._domEdit:this.domElement;setTimeout(function(){return t.focus()},100),this.onOpen&&this.onOpen(this.colour)}}},{key:"closeHandler",value:function(e){var t=e&&e.type,i=!1;if(e)if(t===l||t===c){var n=(this.__containedEvent||0)+100;e.timeStamp>n&&(i=!0)}else h(e),i=!0;else i=!0;i&&this.hide()&&(this.settings.parent.style.pointerEvents="",t!==l&&this.settings.parent.focus(),this.onClose&&this.onClose(this.colour))}},{key:"movePopup",value:function(e,t){this.closeHandler(),this.setOptions(e),t&&this.openHandler()}},{key:"setColor",value:function(e,t){this._setColor(e,{silent:t})}},{key:"_setColor",value:function(e,t){if("string"==typeof e&&(e=e.trim()),e){t=t||{};var i=void 0;try{i=new r(e)}catch(e){if(t.failSilently)return;throw e}if(!this.settings.alpha){var n=i.hsla;n[3]=1,i.hsla=n}this.colour=this.color=i,this._setHSLA(null,null,null,null,t)}}},{key:"setColour",value:function(e,t){this.setColor(e,t)}},{key:"show",value:function(){if(!this.settings.parent)return!1;if(this.domElement){var e=this._toggleDOM(!0);return this._setPosition(),e}var t=function(e){var t=document.createElement("div");return t.innerHTML=e,t.firstElementChild}(this.settings.template||'<div class="picker_wrapper" tabindex="-1"><div class="picker_arrow"></div><div class="picker_hue picker_slider"><div class="picker_selector"></div></div><div class="picker_sl"><div class="picker_selector"></div></div><div class="picker_alpha picker_slider"><div class="picker_selector"></div></div><div class="picker_editor"><input aria-label="Type a color name or hex value"/></div><div class="picker_sample"></div><div class="picker_done"><button>Ok</button></div><div class="picker_cancel"><button>Cancel</button></div></div>');return this.domElement=t,this._domH=v(".picker_hue",t),this._domSL=v(".picker_sl",t),this._domA=v(".picker_alpha",t),this._domEdit=v(".picker_editor input",t),this._domSample=v(".picker_sample",t),this._domOkay=v(".picker_done button",t),this._domCancel=v(".picker_cancel button",t),t.classList.add("layout_"+this.settings.layout),this.settings.alpha||t.classList.add("no_alpha"),this.settings.editor||t.classList.add("no_editor"),this.settings.cancelButton||t.classList.add("no_cancel"),this._ifPopup(function(){return t.classList.add("popup")}),this._setPosition(),this.colour?this._updateUI():this._setColor("#0cf"),this._bindEvents(),!0}},{key:"hide",value:function(){return this._toggleDOM(!1)}},{key:"destroy",value:function(){this._events.destroy(),this.domElement&&this.settings.parent.removeChild(this.domElement)}},{key:"_bindEvents",value:function(){var i=this,n=this,r=this.domElement,o=this._events;function s(e,t,i){o.add(e,t,i)}s(r,"click",function(e){return e.preventDefault()}),a(o,this._domH,function(e,t){return n._setHSLA(e)}),a(o,this._domSL,function(e,t){return n._setHSLA(null,e,1-t)}),this.settings.alpha&&a(o,this._domA,function(e,t){return n._setHSLA(null,null,null,1-t)});var e=this._domEdit;function t(e){i._ifPopup(function(){return i.closeHandler(e)}),i.onDone&&i.onDone(i.colour)}s(e,"input",function(e){n._setColor(this.value,{fromEditor:!0,failSilently:!0})}),s(e,"focus",function(e){this.selectionStart===this.selectionEnd&&this.select()}),this._ifPopup(function(){function e(e){return i.closeHandler(e)}function t(e){i.__containedEvent=e.timeStamp}s(window,l,e),s(window,c,e),d(o,r,["Esc","Escape"],e),s(r,l,t),s(r,c,t),s(i._domCancel,"click",e)}),s(this._domOkay,"click",t),d(o,r,["Enter"],t)}},{key:"_setPosition",value:function(){var i=this.settings.parent,n=this.domElement;i!==n.parentNode&&i.appendChild(n),this._ifPopup(function(e){"static"===getComputedStyle(i).position&&(i.style.position="relative");var t=!0===e?"popup_right":"popup_"+e;["popup_top","popup_bottom","popup_left","popup_right"].forEach(function(e){e===t?n.classList.add(e):n.classList.remove(e)}),n.classList.add(t)})}},{key:"_setHSLA",value:function(e,t,i,n,r){r=r||{};var o=this.colour,s=o.hsla;[e,t,i,n].forEach(function(e,t){!e&&0!==e||(s[t]=e)}),o.hsla=s,this._updateUI(r),this.onChange&&!r.silent&&this.onChange(o)}},{key:"_updateUI",value:function(e){if(this.domElement){e=e||{};var t=this.colour,i=t.hsla,n="hsl("+360*i[0]+", 100%, 50%)",r=t.hslString,o=t.hslaString,s=this._domH,a=this._domSL,l=this._domA,c=v(".picker_selector",s),h=v(".picker_selector",a),d=v(".picker_selector",l);I(0,c,i[0]),this._domSL.style.backgroundColor=this._domH.style.color=n,I(0,h,i[1]),A(0,h,1-i[2]),a.style.color=r,A(0,d,1-i[3]);var u=r,g=u.replace("hsl","hsla").replace(")",", 0)"),p="linear-gradient("+[u,g]+")";if(this._domA.style.backgroundImage=p+", url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='2' height='2'%3E%3Cpath d='M1,0H0V1H2V2H1' fill='lightgrey'/%3E%3C/svg%3E\")",!e.fromEditor){var m=this.settings.editorFormat,f=this.settings.alpha,C=void 0;switch(m){case"rgb":C=t.printRGB(f);break;case"hsl":C=t.printHSL(f);break;default:C=t.printHex(f)}this._domEdit.value=C}this._domSample.style.color=o}function I(e,t,i){t.style.left=100*i+"%"}function A(e,t,i){t.style.top=100*i+"%"}}},{key:"_ifPopup",value:function(e,t){this.settings.parent&&this.settings.popup?e&&e(this.settings.popup):t&&t()}},{key:"_toggleDOM",value:function(e){var t=this.domElement;if(!t)return!1;var i=e?"":"none",n=t.style.display!==i;return n&&(t.style.display=i),n}}],[{key:"StyleElement",get:function(){return u}}]),t}()}()},function(e,t){window.ace.define("ace/theme/jsoneditor",["require","exports","module","ace/lib/dom"],function(e,t,i){t.isDark=!1,t.cssClass="ace-jsoneditor",t.cssText='.ace-jsoneditor .ace_gutter {\nbackground: #ebebeb;\ncolor: #333\n}\n\n.ace-jsoneditor.ace_editor {\nfont-family: "dejavu sans mono", "droid sans mono", consolas, monaco, "lucida console", "courier new", courier, monospace, sans-serif;\nline-height: 1.3;\nbackground-color: #fff;\n}\n.ace-jsoneditor .ace_print-margin {\nwidth: 1px;\nbackground: #e8e8e8\n}\n.ace-jsoneditor .ace_scroller {\nbackground-color: #FFFFFF\n}\n.ace-jsoneditor .ace_text-layer {\ncolor: gray\n}\n.ace-jsoneditor .ace_variable {\ncolor: #1a1a1a\n}\n.ace-jsoneditor .ace_cursor {\nborder-left: 2px solid #000000\n}\n.ace-jsoneditor .ace_overwrite-cursors .ace_cursor {\nborder-left: 0px;\nborder-bottom: 1px solid #000000\n}\n.ace-jsoneditor .ace_marker-layer .ace_selection {\nbackground: lightgray\n}\n.ace-jsoneditor.ace_multiselect .ace_selection.ace_start {\nbox-shadow: 0 0 3px 0px #FFFFFF;\nborder-radius: 2px\n}\n.ace-jsoneditor .ace_marker-layer .ace_step {\nbackground: rgb(255, 255, 0)\n}\n.ace-jsoneditor .ace_marker-layer .ace_bracket {\nmargin: -1px 0 0 -1px;\nborder: 1px solid #BFBFBF\n}\n.ace-jsoneditor .ace_marker-layer .ace_active-line {\nbackground: #FFFBD1\n}\n.ace-jsoneditor .ace_gutter-active-line {\nbackground-color : #dcdcdc\n}\n.ace-jsoneditor .ace_marker-layer .ace_selected-word {\nborder: 1px solid lightgray\n}\n.ace-jsoneditor .ace_invisible {\ncolor: #BFBFBF\n}\n.ace-jsoneditor .ace_keyword,\n.ace-jsoneditor .ace_meta,\n.ace-jsoneditor .ace_support.ace_constant.ace_property-value {\ncolor: #AF956F\n}\n.ace-jsoneditor .ace_keyword.ace_operator {\ncolor: #484848\n}\n.ace-jsoneditor .ace_keyword.ace_other.ace_unit {\ncolor: #96DC5F\n}\n.ace-jsoneditor .ace_constant.ace_language {\ncolor: darkorange\n}\n.ace-jsoneditor .ace_constant.ace_numeric {\ncolor: red\n}\n.ace-jsoneditor .ace_constant.ace_character.ace_entity {\ncolor: #BF78CC\n}\n.ace-jsoneditor .ace_invalid {\ncolor: #FFFFFF;\nbackground-color: #FF002A;\n}\n.ace-jsoneditor .ace_fold {\nbackground-color: #AF956F;\nborder-color: #000000\n}\n.ace-jsoneditor .ace_storage,\n.ace-jsoneditor .ace_support.ace_class,\n.ace-jsoneditor .ace_support.ace_function,\n.ace-jsoneditor .ace_support.ace_other,\n.ace-jsoneditor .ace_support.ace_type {\ncolor: #C52727\n}\n.ace-jsoneditor .ace_string {\ncolor: green\n}\n.ace-jsoneditor .ace_comment {\ncolor: #BCC8BA\n}\n.ace-jsoneditor .ace_entity.ace_name.ace_tag,\n.ace-jsoneditor .ace_entity.ace_other.ace_attribute-name {\ncolor: #606060\n}\n.ace-jsoneditor .ace_markup.ace_underline {\ntext-decoration: underline\n}\n.ace-jsoneditor .ace_indent-guide {\nbackground: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y\n}',e("../lib/dom").importCssString(t.cssText,t.cssClass)})},function(e,t,i){t.tryRequireAjv=function(){try{return i(42)}catch(e){}}},function(e,t,n){"use strict";var a=n(43),u=n(16),i=n(47),g=n(24),r=n(25),o=n(48),s=n(49),l=n(70),c=n(5);(e.exports=C).prototype.validate=function(e,t){var i;if("string"==typeof e){if(!(i=this.getSchema(e)))throw new Error('no schema with key or ref "'+e+'"')}else{var n=this._addSchema(e);i=n.validate||this._compile(n)}var r=i(t);!0!==i.$async&&(this.errors=i.errors);return r},C.prototype.compile=function(e,t){var i=this._addSchema(e,void 0,t);return i.validate||this._compile(i)},C.prototype.addSchema=function(e,t,i,n){if(Array.isArray(e)){for(var r=0;r<e.length;r++)this.addSchema(e[r],void 0,i,n);return this}var o=this._getId(e);if(void 0!==o&&"string"!=typeof o)throw new Error("schema id must be string");return w(this,t=u.normalizeId(t||o)),this._schemas[t]=this._addSchema(e,i,n,!0),this},C.prototype.addMetaSchema=function(e,t,i){return this.addSchema(e,t,i,!0),this},C.prototype.validateSchema=function(e,t){var i=e.$schema;if(void 0!==i&&"string"!=typeof i)throw new Error("$schema must be a string");if(!(i=i||this._opts.defaultMeta||function(e){var t=e._opts.meta;return e._opts.defaultMeta="object"==typeof t?e._getId(t)||t:e.getSchema(p)?p:void 0,e._opts.defaultMeta}(this)))return this.logger.warn("meta-schema not available"),!(this.errors=null);var n=this.validate(i,e);if(!n&&t){var r="schema is invalid: "+this.errorsText();if("log"!=this._opts.validateSchema)throw new Error(r);this.logger.error(r)}return n},C.prototype.getSchema=function(e){var t=I(this,e);switch(typeof t){case"object":return t.validate||this._compile(t);case"string":return this.getSchema(t);case"undefined":return function(e,t){var i=u.schema.call(e,{schema:{}},t);if(i){var n=i.schema,r=i.root,o=i.baseId,s=a.call(e,n,r,void 0,o);return e._fragments[t]=new g({ref:t,fragment:!0,schema:n,root:r,baseId:o,validate:s}),s}}(this,e)}},C.prototype.removeSchema=function(e){if(e instanceof RegExp)return A(this,this._schemas,e),A(this,this._refs,e),this;switch(typeof e){case"undefined":return A(this,this._schemas),A(this,this._refs),this._cache.clear(),this;case"string":var t=I(this,e);return t&&this._cache.del(t.cacheKey),delete this._schemas[e],delete this._refs[e],this;case"object":var i=this._opts.serialize,n=i?i(e):e;this._cache.del(n);var r=this._getId(e);r&&(r=u.normalizeId(r),delete this._schemas[r],delete this._refs[r])}return this},C.prototype.addFormat=function(e,t){"string"==typeof t&&(t=new RegExp(t));return this._formats[e]=t,this},C.prototype.errorsText=function(e,t){if(!(e=e||this.errors))return"No errors";for(var i=void 0===(t=t||{}).separator?", ":t.separator,n=void 0===t.dataVar?"data":t.dataVar,r="",o=0;o<e.length;o++){var s=e[o];s&&(r+=n+s.dataPath+" "+s.message+i)}return r.slice(0,-i.length)},C.prototype._addSchema=function(e,t,i,n){if("object"!=typeof e&&"boolean"!=typeof e)throw new Error("schema should be object or boolean");var r=this._opts.serialize,o=r?r(e):e,s=this._cache.get(o);if(s)return s;n=n||!1!==this._opts.addUsedSchema;var a=u.normalizeId(this._getId(e));a&&n&&w(this,a);var l,c=!1!==this._opts.validateSchema&&!t;c&&!(l=a&&a==u.normalizeId(e.$schema))&&this.validateSchema(e,!0);var h=u.ids.call(this,e),d=new g({id:a,schema:e,localRefs:h,cacheKey:o,meta:i});"#"!=a[0]&&n&&(this._refs[a]=d);this._cache.put(o,d),c&&l&&this.validateSchema(e,!0);return d},C.prototype._compile=function(i,e){if(i.compiling)return(i.validate=r).schema=i.schema,r.errors=null,r.root=e||r,!0===i.schema.$async&&(r.$async=!0),r;var t,n;i.compiling=!0,i.meta&&(t=this._opts,this._opts=this._metaOpts);try{n=a.call(this,i.schema,e,i.localRefs)}catch(e){throw delete i.validate,e}finally{i.compiling=!1,i.meta&&(this._opts=t)}return i.validate=n,i.refs=n.refs,i.refVal=n.refVal,i.root=n.root,n;function r(){var e=i.validate,t=e.apply(this,arguments);return r.errors=e.errors,t}},C.prototype.compileAsync=n(71);var h=n(72);C.prototype.addKeyword=h.add,C.prototype.getKeyword=h.get,C.prototype.removeKeyword=h.remove,C.prototype.validateKeyword=h.validate;var d=n(18);C.ValidationError=d.Validation,C.MissingRefError=d.MissingRef,C.$dataMetaSchema=l;var p="http://json-schema.org/draft-07/schema",m=["removeAdditional","useDefaults","coerceTypes","strictDefaults"],f=["/properties"];function C(e){if(!(this instanceof C))return new C(e);e=this._opts=c.copy(e)||{},function(e){var t=e._opts.logger;if(!1===t)e.logger={log:S,warn:S,error:S};else{if(void 0===t&&(t=console),!("object"==typeof t&&t.log&&t.warn&&t.error))throw new Error("logger must implement log, warn and error methods");e.logger=t}}(this),this._schemas={},this._refs={},this._fragments={},this._formats=o(e.format),this._cache=e.cache||new i,this._loadingSchemas={},this._compilations=[],this.RULES=s(),this._getId=function(e){switch(e.schemaId){case"auto":return y;case"id":return v;default:return b}}(e),e.loopRequired=e.loopRequired||1/0,"property"==e.errorDataPath&&(e._errorDataPathProperty=!0),void 0===e.serialize&&(e.serialize=r),this._metaOpts=function(e){for(var t=c.copy(e._opts),i=0;i<m.length;i++)delete t[m[i]];return t}(this),e.formats&&function(e){for(var t in e._opts.formats){var i=e._opts.formats[t];e.addFormat(t,i)}}(this),function(e){var t;e._opts.$data&&(t=n(75),e.addMetaSchema(t,t.$id,!0));if(!1===e._opts.meta)return;var i=n(31);e._opts.$data&&(i=l(i,f));e.addMetaSchema(i,p,!0),e._refs["http://json-schema.org/schema"]=p}(this),"object"==typeof e.meta&&this.addMetaSchema(e.meta),e.nullable&&this.addKeyword("nullable",{metaSchema:{type:"boolean"}}),function(e){var t=e._opts.schemas;if(!t)return;if(Array.isArray(t))e.addSchema(t);else for(var i in t)e.addSchema(t[i],i)}(this)}function I(e,t){return t=u.normalizeId(t),e._schemas[t]||e._refs[t]||e._fragments[t]}function A(e,t,i){for(var n in t){var r=t[n];r.meta||i&&!i.test(n)||(e._cache.del(r.cacheKey),delete t[n])}}function v(e){return e.$id&&this.logger.warn("schema $id ignored",e.$id),e.id}function b(e){return e.id&&this.logger.warn("schema id ignored",e.id),e.$id}function y(e){if(e.$id&&e.id&&e.$id!=e.id)throw new Error("schema $id is different from id");return e.$id||e.id}function w(e,t){if(e._schemas[t]||e._refs[t])throw new Error('schema with key or id "'+t+'" already exists')}function S(){}},function(e,t,i){"use strict";var G=i(16),Z=i(5),T=i(18),W=i(25),_=i(26),H=Z.ucs2length,L=i(17),$=T.Validation;function V(e,t,i){var n=r.call(this,e,t,i);return 0<=n?{index:n,compiling:!0}:{index:n=this._compilations.length,compiling:!(this._compilations[n]={schema:e,root:t,baseId:i})}}function N(e,t,i){var n=r.call(this,e,t,i);0<=n&&this._compilations.splice(n,1)}function r(e,t,i){for(var n=0;n<this._compilations.length;n++){var r=this._compilations[n];if(r.schema==e&&r.root==t&&r.baseId==i)return n}return-1}function O(e,t){return"var pattern"+e+" = new RegExp("+Z.toQuotedString(t[e])+");"}function F(e){return"var default"+e+" = defaults["+e+"];"}function P(e,t){return void 0===t[e]?"":"var refVal"+e+" = refVal["+e+"];"}function K(e){return"var customRule"+e+" = customRules["+e+"];"}function M(e,t){if(!e.length)return"";for(var i="",n=0;n<e.length;n++)i+=t(n,e);return i}e.exports=function c(e,h,d,t){var g=this,p=this._opts,u=[void 0],m={},f=[],i={},C=[],n={},I=[];h=h||{schema:e,refVal:u,refs:m};var r=V.call(this,e,h,t);var o=this._compilations[r.index];if(r.compiling)return o.callValidate=l;var A=this._formats;var v=this.RULES;try{var s=b(e,h,d,t);o.validate=s;var a=o.callValidate;return a&&(a.schema=s.schema,a.errors=null,a.refs=s.refs,a.refVal=s.refVal,a.root=s.root,a.$async=s.$async,p.sourceCode&&(a.source=s.source)),s}finally{N.call(this,e,h,t)}function l(){var e=o.validate,t=e.apply(this,arguments);return l.errors=e.errors,t}function b(e,t,i,n){var r=!t||t&&t.schema==e;if(t.schema!=h.schema)return c.call(g,e,t,i,n);var o,s=!0===e.$async,a=_({isTop:!0,schema:e,isRoot:r,baseId:n,root:t,schemaPath:"",errSchemaPath:"#",errorPath:'""',MissingRefError:T.MissingRef,RULES:v,validate:_,util:Z,resolve:G,resolveRef:y,usePattern:R,useDefault:E,useCustomRule:B,opts:p,formats:A,logger:g.logger,self:g});a=M(u,P)+M(f,O)+M(C,F)+M(I,K)+a,p.processCode&&(a=p.processCode(a));try{var l=new Function("self","RULES","formats","root","refVal","defaults","customRules","equal","ucs2length","ValidationError",a);o=l(g,v,A,h,u,C,I,L,H,$),u[0]=o}catch(e){throw g.logger.error("Error compiling schema, function code:",a),e}return o.schema=e,o.errors=null,o.refs=m,o.refVal=u,o.root=r?o:t,s&&(o.$async=!0),!0===p.sourceCode&&(o.source={code:a,patterns:f,defaults:C}),o}function y(e,t,i){t=G.url(e,t);var n,r,o=m[t];if(void 0!==o)return k(n=u[o],r="refVal["+o+"]");if(!i&&h.refs){var s=h.refs[t];if(void 0!==s)return n=h.refVal[s],r=w(t,n),k(n,r)}r=w(t);var a=G.call(g,b,h,t);if(void 0===a){var l=d&&d[t];l&&(a=G.inlineRef(l,p.inlineRefs)?l:c.call(g,l,h,d,e))}if(void 0!==a)return x(t,a),k(a,r);S(t)}function w(e,t){var i=u.length;return u[i]=t,"refVal"+(m[e]=i)}function S(e){delete m[e]}function x(e,t){var i=m[e];u[i]=t}function k(e,t){return"object"==typeof e||"boolean"==typeof e?{code:t,schema:e,inline:!0}:{code:t,$async:e&&!!e.$async}}function R(e){var t=i[e];return void 0===t&&(t=i[e]=f.length,f[t]=e),"pattern"+t}function E(e){switch(typeof e){case"boolean":case"number":return""+e;case"string":return Z.toQuotedString(e);case"object":if(null===e)return"null";var t=W(e),i=n[t];return void 0===i&&(i=n[t]=C.length,C[i]=e),"default"+i}}function B(e,t,i,n){if(!1!==g._opts.validateSchema){var r=e.definition.dependencies;if(r&&!r.every(function(e){return Object.prototype.hasOwnProperty.call(i,e)}))throw new Error("parent schema must have all required keywords: "+r.join(","));var o=e.definition.validateSchema;if(o){var s=o(t);if(!s){var a="keyword schema is invalid: "+g.errorsText(o.errors);if("log"!=g._opts.validateSchema)throw new Error(a);g.logger.error(a)}}}var l,c=e.definition.compile,h=e.definition.inline,d=e.definition.macro;if(c)l=c.call(g,t,i,n);else if(d)l=d.call(g,t,i,n),!1!==p.validateSchema&&g.validateSchema(l,!0);else if(h)l=h.call(g,n,e.keyword,t,i);else if(!(l=e.definition.validate))return;if(void 0===l)throw new Error('custom keyword "'+e.keyword+'"failed to compile');var u=I.length;return I[u]=l,{code:"customRule"+u,validate:l}}}},function(e,t,i){
/** @license URI.js v4.2.1 (c) 2011 Gary Court. License: http://github.com/garycourt/uri-js */
!function(e){"use strict";function J(){for(var e=arguments.length,t=Array(e),i=0;i<e;i++)t[i]=arguments[i];if(1<t.length){t[0]=t[0].slice(0,-1);for(var n=t.length-1,r=1;r<n;++r)t[r]=t[r].slice(1,-1);return t[n]=t[n].slice(1),t.join("")}return t[0]}function z(e){return"(?:"+e+")"}function n(e){return void 0===e?"undefined":null===e?"null":Object.prototype.toString.call(e).split(" ").pop().split("]").shift().toLowerCase()}function g(e){return e.toUpperCase()}function r(e,t){var i=e;if(t)for(var n in t)i[n]=t[n];return i}function t(e){var t="[A-Za-z]",i="[0-9]",n=J(i,"[A-Fa-f]"),r=z(z("%[EFef]"+n+"%"+n+n+"%"+n+n)+"|"+z("%[89A-Fa-f]"+n+"%"+n+n)+"|"+z("%"+n+n)),o="[\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=]",s=J("[\\:\\/\\?\\#\\[\\]\\@]",o),a=e?"[\\xA0-\\u200D\\u2010-\\u2029\\u202F-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]":"[]",l=e?"[\\uE000-\\uF8FF]":"[]",c=J(t,i,"[\\-\\.\\_\\~]",a),h=z(t+J(t,i,"[\\+\\-\\.]")+"*"),d=z(z(r+"|"+J(c,o,"[\\:]"))+"*"),u=(z(z("25[0-5]")+"|"+z("2[0-4]"+i)+"|"+z("1"+i+i)+"|"+z("[1-9]"+i)+"|"+i),z(z("25[0-5]")+"|"+z("2[0-4]"+i)+"|"+z("1"+i+i)+"|"+z("0?[1-9]"+i)+"|0?0?"+i)),g=z(u+"\\."+u+"\\."+u+"\\."+u),p=z(n+"{1,4}"),m=z(z(p+"\\:"+p)+"|"+g),f=z(z(p+"\\:")+"{6}"+m),C=z("\\:\\:"+z(p+"\\:")+"{5}"+m),I=z(z(p)+"?\\:\\:"+z(p+"\\:")+"{4}"+m),A=z(z(z(p+"\\:")+"{0,1}"+p)+"?\\:\\:"+z(p+"\\:")+"{3}"+m),v=z(z(z(p+"\\:")+"{0,2}"+p)+"?\\:\\:"+z(p+"\\:")+"{2}"+m),b=z(z(z(p+"\\:")+"{0,3}"+p)+"?\\:\\:"+p+"\\:"+m),y=z(z(z(p+"\\:")+"{0,4}"+p)+"?\\:\\:"+m),w=z(z(z(p+"\\:")+"{0,5}"+p)+"?\\:\\:"+p),S=z(z(z(p+"\\:")+"{0,6}"+p)+"?\\:\\:"),x=z([f,C,I,A,v,b,y,w,S].join("|")),k=z(z(c+"|"+r)+"+"),R=(z(x+"\\%25"+k),z(x+z("\\%25|\\%(?!"+n+"{2})")+k)),E=z("[vV]"+n+"+\\."+J(c,o,"[\\:]")+"+"),B=z("\\["+z(R+"|"+x+"|"+E)+"\\]"),G=z(z(r+"|"+J(c,o))+"*"),Z=z(B+"|"+g+"(?!"+G+")|"+G),T=z(i+"*"),W=z(z(d+"@")+"?"+Z+z("\\:"+T)+"?"),_=z(r+"|"+J(c,o,"[\\:\\@]")),H=z(_+"*"),L=z(_+"+"),$=z(z(r+"|"+J(c,o,"[\\@]"))+"+"),V=z(z("\\/"+H)+"*"),N=z("\\/"+z(L+V)+"?"),O=z($+V),F=z(L+V),P="(?!"+_+")",K=(z(V+"|"+N+"|"+O+"|"+F+"|"+P),z(z(_+"|"+J("[\\/\\?]",l))+"*")),M=z(z(_+"|[\\/\\?]")+"*"),D=z(z("\\/\\/"+W+V)+"|"+N+"|"+F+"|"+P),j=z(h+"\\:"+D+z("\\?"+K)+"?"+z("\\#"+M)+"?"),X=z(z("\\/\\/"+W+V)+"|"+N+"|"+O+"|"+P),Y=z(X+z("\\?"+K)+"?"+z("\\#"+M)+"?");z(j+"|"+Y),z(h+"\\:"+D+z("\\?"+K)+"?"),z(z("\\/\\/("+z("("+d+")@")+"?("+Z+")"+z("\\:("+T+")")+"?)")+"?("+V+"|"+N+"|"+F+"|"+P+")"),z("\\?("+K+")"),z("\\#("+M+")"),z(z("\\/\\/("+z("("+d+")@")+"?("+Z+")"+z("\\:("+T+")")+"?)")+"?("+V+"|"+N+"|"+O+"|"+P+")"),z("\\?("+K+")"),z("\\#("+M+")"),z(z("\\/\\/("+z("("+d+")@")+"?("+Z+")"+z("\\:("+T+")")+"?)")+"?("+V+"|"+N+"|"+F+"|"+P+")"),z("\\?("+K+")"),z("\\#("+M+")"),z("("+d+")@"),z("\\:("+T+")");return{NOT_SCHEME:new RegExp(J("[^]",t,i,"[\\+\\-\\.]"),"g"),NOT_USERINFO:new RegExp(J("[^\\%\\:]",c,o),"g"),NOT_HOST:new RegExp(J("[^\\%\\[\\]\\:]",c,o),"g"),NOT_PATH:new RegExp(J("[^\\%\\/\\:\\@]",c,o),"g"),NOT_PATH_NOSCHEME:new RegExp(J("[^\\%\\/\\@]",c,o),"g"),NOT_QUERY:new RegExp(J("[^\\%]",c,o,"[\\:\\@\\/\\?]",l),"g"),NOT_FRAGMENT:new RegExp(J("[^\\%]",c,o,"[\\:\\@\\/\\?]"),"g"),ESCAPE:new RegExp(J("[^]",c,o),"g"),UNRESERVED:new RegExp(c,"g"),OTHER_CHARS:new RegExp(J("[^\\%]",c,s),"g"),PCT_ENCODED:new RegExp(r,"g"),IPV4ADDRESS:new RegExp("^("+g+")$"),IPV6ADDRESS:new RegExp("^\\[?("+x+")"+z(z("\\%25|\\%(?!"+n+"{2})")+"("+k+")")+"?\\]?$")}}var a=t(!1),l=t(!0),y=function(e,t){if(Array.isArray(e))return e;if(Symbol.iterator in Object(e))return function(e,t){var i=[],n=!0,r=!1,o=void 0;try{for(var s,a=e[Symbol.iterator]();!(n=(s=a.next()).done)&&(i.push(s.value),!t||i.length!==t);n=!0);}catch(e){r=!0,o=e}finally{try{!n&&a.return&&a.return()}finally{if(r)throw o}}return i}(e,t);throw new TypeError("Invalid attempt to destructure non-iterable instance")},W=2147483647,i=/^xn--/,o=/[^\0-\x7E]/,s=/[\x2E\u3002\uFF0E\uFF61]/g,c={overflow:"Overflow: input needs wider integers to process","not-basic":"Illegal input >= 0x80 (not a basic code point)","invalid-input":"Invalid input"},_=Math.floor,H=String.fromCharCode;function L(e){throw new RangeError(c[e])}function h(e,t){var i=e.split("@"),n="";1<i.length&&(n=i[0]+"@",e=i[1]);var r=(e=e.replace(s,".")).split("."),o=function(e,t){var i=[],n=e.length;for(;n--;)i[n]=t(e[n]);return i}(r,t).join(".");return n+o}function $(e){for(var t=[],i=0,n=e.length;i<n;){var r=e.charCodeAt(i++);if(55296<=r&&r<=56319&&i<n){var o=e.charCodeAt(i++);56320==(64512&o)?t.push(((1023&r)<<10)+(1023&o)+65536):(t.push(r),i--)}else t.push(r)}return t}var f=function(e){return e-48<10?e-22:e-65<26?e-65:e-97<26?e-97:36},V=function(e,t){return e+22+75*(e<26)-((0!=t)<<5)},N=function(e,t,i){var n=0;for(e=i?_(e/700):e>>1,e+=_(e/t);455<e;n+=36)e=_(e/35);return _(n+36*e/(e+38))},d=function(e){var t=[],i=e.length,n=0,r=128,o=72,s=e.lastIndexOf("-");s<0&&(s=0);for(var a=0;a<s;++a)128<=e.charCodeAt(a)&&L("not-basic"),t.push(e.charCodeAt(a));for(var l=0<s?s+1:0;l<i;){for(var c=n,h=1,d=36;;d+=36){i<=l&&L("invalid-input");var u=f(e.charCodeAt(l++));(36<=u||u>_((W-n)/h))&&L("overflow"),n+=u*h;var g=d<=o?1:o+26<=d?26:d-o;if(u<g)break;var p=36-g;h>_(W/p)&&L("overflow"),h*=p}var m=t.length+1;o=N(n-c,m,0==c),_(n/m)>W-r&&L("overflow"),r+=_(n/m),n%=m,t.splice(n++,0,r)}return String.fromCodePoint.apply(String,t)},u=function(e){var t=[],i=(e=$(e)).length,n=128,r=0,o=72,s=!0,a=!1,l=void 0;try{for(var c,h=e[Symbol.iterator]();!(s=(c=h.next()).done);s=!0){var d=c.value;d<128&&t.push(H(d))}}catch(e){a=!0,l=e}finally{try{!s&&h.return&&h.return()}finally{if(a)throw l}}var u=t.length,g=u;for(u&&t.push("-");g<i;){var p=W,m=!0,f=!1,C=void 0;try{for(var I,A=e[Symbol.iterator]();!(m=(I=A.next()).done);m=!0){var v=I.value;n<=v&&v<p&&(p=v)}}catch(e){f=!0,C=e}finally{try{!m&&A.return&&A.return()}finally{if(f)throw C}}var b=g+1;p-n>_((W-r)/b)&&L("overflow"),r+=(p-n)*b,n=p;var y=!0,w=!1,S=void 0;try{for(var x,k=e[Symbol.iterator]();!(y=(x=k.next()).done);y=!0){var R=x.value;if(R<n&&++r>W&&L("overflow"),R==n){for(var E=r,B=36;;B+=36){var G=B<=o?1:o+26<=B?26:B-o;if(E<G)break;var Z=E-G,T=36-G;t.push(H(V(G+Z%T,0))),E=_(Z/T)}t.push(H(V(E,0))),o=N(r,b,g==u),r=0,++g}}}catch(e){w=!0,S=e}finally{try{!y&&k.return&&k.return()}finally{if(w)throw S}}++r,++n}return t.join("")},C={version:"2.1.0",ucs2:{decode:$,encode:function(e){return String.fromCodePoint.apply(String,function(e){if(Array.isArray(e)){for(var t=0,i=Array(e.length);t<e.length;t++)i[t]=e[t];return i}else{return Array.from(e)}}(e))}},decode:d,encode:u,toASCII:function(e){return h(e,function(e){return o.test(e)?"xn--"+u(e):e})},toUnicode:function(e){return h(e,function(e){return i.test(e)?d(e.slice(4).toLowerCase()):e})}},p={};function m(e){var t=e.charCodeAt(0);return t<16?"%0"+t.toString(16).toUpperCase():t<128?"%"+t.toString(16).toUpperCase():t<2048?"%"+(t>>6|192).toString(16).toUpperCase()+"%"+(63&t|128).toString(16).toUpperCase():"%"+(t>>12|224).toString(16).toUpperCase()+"%"+(t>>6&63|128).toString(16).toUpperCase()+"%"+(63&t|128).toString(16).toUpperCase()}function I(e){for(var t="",i=0,n=e.length;i<n;){var r=parseInt(e.substr(i+1,2),16);if(r<128)t+=String.fromCharCode(r),i+=3;else if(194<=r&&r<224){if(6<=n-i){var o=parseInt(e.substr(i+4,2),16);t+=String.fromCharCode((31&r)<<6|63&o)}else t+=e.substr(i,6);i+=6}else if(224<=r){if(9<=n-i){var s=parseInt(e.substr(i+4,2),16),a=parseInt(e.substr(i+7,2),16);t+=String.fromCharCode((15&r)<<12|(63&s)<<6|63&a)}else t+=e.substr(i,9);i+=9}else t+=e.substr(i,3),i+=3}return t}function A(e,i){function t(e){var t=I(e);return t.match(i.UNRESERVED)?t:e}return e.scheme&&(e.scheme=String(e.scheme).replace(i.PCT_ENCODED,t).toLowerCase().replace(i.NOT_SCHEME,"")),void 0!==e.userinfo&&(e.userinfo=String(e.userinfo).replace(i.PCT_ENCODED,t).replace(i.NOT_USERINFO,m).replace(i.PCT_ENCODED,g)),void 0!==e.host&&(e.host=String(e.host).replace(i.PCT_ENCODED,t).toLowerCase().replace(i.NOT_HOST,m).replace(i.PCT_ENCODED,g)),void 0!==e.path&&(e.path=String(e.path).replace(i.PCT_ENCODED,t).replace(e.scheme?i.NOT_PATH:i.NOT_PATH_NOSCHEME,m).replace(i.PCT_ENCODED,g)),void 0!==e.query&&(e.query=String(e.query).replace(i.PCT_ENCODED,t).replace(i.NOT_QUERY,m).replace(i.PCT_ENCODED,g)),void 0!==e.fragment&&(e.fragment=String(e.fragment).replace(i.PCT_ENCODED,t).replace(i.NOT_FRAGMENT,m).replace(i.PCT_ENCODED,g)),e}function w(e){return e.replace(/^0*(.*)/,"$1")||"0"}function S(e,t){var i=e.match(t.IPV4ADDRESS)||[],n=y(i,2),r=n[1];return r?r.split(".").map(w).join("."):e}function v(e,t){var i=e.match(t.IPV6ADDRESS)||[],n=y(i,3),r=n[1],o=n[2];if(r){for(var s=r.toLowerCase().split("::").reverse(),a=y(s,2),l=a[0],c=a[1],h=c?c.split(":").map(w):[],d=l.split(":").map(w),u=t.IPV4ADDRESS.test(d[d.length-1]),g=u?7:8,p=d.length-g,m=Array(g),f=0;f<g;++f)m[f]=h[f]||d[p+f]||"";u&&(m[g-1]=S(m[g-1],t));var C=m.reduce(function(e,t,i){if(!t||"0"===t){var n=e[e.length-1];n&&n.index+n.length===i?n.length++:e.push({index:i,length:1})}return e},[]),I=C.sort(function(e,t){return t.length-e.length})[0],A=void 0;if(I&&1<I.length){var v=m.slice(0,I.index),b=m.slice(I.index+I.length);A=v.join(":")+"::"+b.join(":")}else A=m.join(":");return o&&(A+="%"+o),A}return e}var b=/^(?:([^:\/?#]+):)?(?:\/\/((?:([^\/?#@]*)@)?(\[[^\/?#\]]+\]|[^\/?#:]*)(?:\:(\d*))?))?([^?#]*)(?:\?([^#]*))?(?:#((?:.|\n|\r)*))?/i,x=void 0==="".match(/(){0}/)[1];function k(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},i={},n=!1!==t.iri?l:a;"suffix"===t.reference&&(e=(t.scheme?t.scheme+":":"")+"//"+e);var r=e.match(b);if(r){x?(i.scheme=r[1],i.userinfo=r[3],i.host=r[4],i.port=parseInt(r[5],10),i.path=r[6]||"",i.query=r[7],i.fragment=r[8],isNaN(i.port)&&(i.port=r[5])):(i.scheme=r[1]||void 0,i.userinfo=-1!==e.indexOf("@")?r[3]:void 0,i.host=-1!==e.indexOf("//")?r[4]:void 0,i.port=parseInt(r[5],10),i.path=r[6]||"",i.query=-1!==e.indexOf("?")?r[7]:void 0,i.fragment=-1!==e.indexOf("#")?r[8]:void 0,isNaN(i.port)&&(i.port=e.match(/\/\/(?:.|\n)*\:(?:\/|\?|\#|$)/)?r[4]:void 0)),i.host&&(i.host=v(S(i.host,n),n)),void 0!==i.scheme||void 0!==i.userinfo||void 0!==i.host||void 0!==i.port||i.path||void 0!==i.query?void 0===i.scheme?i.reference="relative":void 0===i.fragment?i.reference="absolute":i.reference="uri":i.reference="same-document",t.reference&&"suffix"!==t.reference&&t.reference!==i.reference&&(i.error=i.error||"URI is not a "+t.reference+" reference.");var o=p[(t.scheme||i.scheme||"").toLowerCase()];if(t.unicodeSupport||o&&o.unicodeSupport)A(i,n);else{if(i.host&&(t.domainHost||o&&o.domainHost))try{i.host=C.toASCII(i.host.replace(n.PCT_ENCODED,I).toLowerCase())}catch(e){i.error=i.error||"Host's domain name can not be converted to ASCII via punycode: "+e}A(i,a)}o&&o.parse&&o.parse(i,t)}else i.error=i.error||"URI can not be parsed.";return i}var R=/^\.\.?\//,E=/^\/\.(\/|$)/,B=/^\/\.\.(\/|$)/,G=/^\/?(?:.|\n)*?(?=\/|$)/;function Z(e){for(var t=[];e.length;)if(e.match(R))e=e.replace(R,"");else if(e.match(E))e=e.replace(E,"/");else if(e.match(B))e=e.replace(B,"/"),t.pop();else if("."===e||".."===e)e="";else{var i=e.match(G);if(!i)throw new Error("Unexpected dot segment condition");var n=i[0];e=e.slice(n.length),t.push(n)}return t.join("")}function T(t){var i=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},e=i.iri?l:a,n=[],r=p[(i.scheme||t.scheme||"").toLowerCase()];if(r&&r.serialize&&r.serialize(t,i),t.host)if(e.IPV6ADDRESS.test(t.host));else if(i.domainHost||r&&r.domainHost)try{t.host=i.iri?C.toUnicode(t.host):C.toASCII(t.host.replace(e.PCT_ENCODED,I).toLowerCase())}catch(e){t.error=t.error||"Host's domain name can not be converted to "+(i.iri?"Unicode":"ASCII")+" via punycode: "+e}A(t,e),"suffix"!==i.reference&&t.scheme&&(n.push(t.scheme),n.push(":"));var o=function(e,t){var i=!1!==t.iri?l:a,n=[];void 0!==e.userinfo&&(n.push(e.userinfo),n.push("@"));void 0!==e.host&&n.push(v(S(String(e.host),i),i).replace(i.IPV6ADDRESS,function(e,t,i){return"["+t+(i?"%25"+i:"")+"]"}));"number"==typeof e.port&&(n.push(":"),n.push(e.port.toString(10)));return n.length?n.join(""):void 0}(t,i);if(void 0!==o&&("suffix"!==i.reference&&n.push("//"),n.push(o),t.path&&"/"!==t.path.charAt(0)&&n.push("/")),void 0!==t.path){var s=t.path;i.absolutePath||r&&r.absolutePath||(s=Z(s)),void 0===o&&(s=s.replace(/^\/\//,"/%2F")),n.push(s)}return void 0!==t.query&&(n.push("?"),n.push(t.query)),void 0!==t.fragment&&(n.push("#"),n.push(t.fragment)),n.join("")}function O(e,t){var i=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{},n=arguments[3],r={};return n||(e=k(T(e,i),i),t=k(T(t,i),i)),!(i=i||{}).tolerant&&t.scheme?(r.scheme=t.scheme,r.userinfo=t.userinfo,r.host=t.host,r.port=t.port,r.path=Z(t.path||""),r.query=t.query):(void 0!==t.userinfo||void 0!==t.host||void 0!==t.port?(r.userinfo=t.userinfo,r.host=t.host,r.port=t.port,r.path=Z(t.path||""),r.query=t.query):(t.path?("/"===t.path.charAt(0)?r.path=Z(t.path):(void 0===e.userinfo&&void 0===e.host&&void 0===e.port||e.path?e.path?r.path=e.path.slice(0,e.path.lastIndexOf("/")+1)+t.path:r.path=t.path:r.path="/"+t.path,r.path=Z(r.path)),r.query=t.query):(r.path=e.path,void 0!==t.query?r.query=t.query:r.query=e.query),r.userinfo=e.userinfo,r.host=e.host,r.port=e.port),r.scheme=e.scheme),r.fragment=t.fragment,r}function F(e,t){return e&&e.toString().replace(t&&t.iri?l.PCT_ENCODED:a.PCT_ENCODED,I)}var P={scheme:"http",domainHost:!0,parse:function(e,t){return e.host||(e.error=e.error||"HTTP URIs must have a host."),e},serialize:function(e,t){return e.port!==("https"!==String(e.scheme).toLowerCase()?80:443)&&""!==e.port||(e.port=void 0),e.path||(e.path="/"),e}},K={scheme:"https",domainHost:P.domainHost,parse:P.parse,serialize:P.serialize},M={},D="[A-Za-z0-9\\-\\.\\_\\~\\xA0-\\u200D\\u2010-\\u2029\\u202F-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]",j="[0-9A-Fa-f]",X=z(z("%[EFef]"+j+"%"+j+j+"%"+j+j)+"|"+z("%[89A-Fa-f]"+j+"%"+j+j)+"|"+z("%"+j+j)),Y=J("[\\!\\$\\%\\'\\(\\)\\*\\+\\,\\-\\.0-9\\<\\>A-Z\\x5E-\\x7E]",'[\\"\\\\]'),U=new RegExp(D,"g"),Q=new RegExp(X,"g"),q=new RegExp(J("[^]","[A-Za-z0-9\\!\\$\\%\\'\\*\\+\\-\\^\\_\\`\\{\\|\\}\\~]","[\\.]",'[\\"]',Y),"g"),ee=new RegExp(J("[^]",D,"[\\!\\$\\'\\(\\)\\*\\+\\,\\;\\:\\@]"),"g"),te=ee;function ie(e){var t=I(e);return t.match(U)?t:e}var ne={scheme:"mailto",parse:function(e,t){var i=e,n=i.to=i.path?i.path.split(","):[];if(i.path=void 0,i.query){for(var r=!1,o={},s=i.query.split("&"),a=0,l=s.length;a<l;++a){var c=s[a].split("=");switch(c[0]){case"to":for(var h=c[1].split(","),d=0,u=h.length;d<u;++d)n.push(h[d]);break;case"subject":i.subject=F(c[1],t);break;case"body":i.body=F(c[1],t);break;default:r=!0,o[F(c[0],t)]=F(c[1],t)}}r&&(i.headers=o)}i.query=void 0;for(var g=0,p=n.length;g<p;++g){var m=n[g].split("@");if(m[0]=F(m[0]),t.unicodeSupport)m[1]=F(m[1],t).toLowerCase();else try{m[1]=C.toASCII(F(m[1],t).toLowerCase())}catch(e){i.error=i.error||"Email address's domain name can not be converted to ASCII via punycode: "+e}n[g]=m.join("@")}return i},serialize:function(e,t){var i=e,n=function(e){return null!=e?e instanceof Array?e:"number"!=typeof e.length||e.split||e.setInterval||e.call?[e]:Array.prototype.slice.call(e):[]}(e.to);if(n){for(var r=0,o=n.length;r<o;++r){var s=String(n[r]),a=s.lastIndexOf("@"),l=s.slice(0,a).replace(Q,ie).replace(Q,g).replace(q,m),c=s.slice(a+1);try{c=t.iri?C.toUnicode(c):C.toASCII(F(c,t).toLowerCase())}catch(e){i.error=i.error||"Email address's domain name can not be converted to "+(t.iri?"Unicode":"ASCII")+" via punycode: "+e}n[r]=l+"@"+c}i.path=n.join(",")}var h=e.headers=e.headers||{};e.subject&&(h.subject=e.subject),e.body&&(h.body=e.body);var d=[];for(var u in h)h[u]!==M[u]&&d.push(u.replace(Q,ie).replace(Q,g).replace(ee,m)+"="+h[u].replace(Q,ie).replace(Q,g).replace(te,m));return d.length&&(i.query=d.join("&")),i}},re=/^([^\:]+)\:(.*)/,oe={scheme:"urn",parse:function(e,t){var i=e.path&&e.path.match(re),n=e;if(i){var r=t.scheme||n.scheme||"urn",o=i[1].toLowerCase(),s=i[2],a=r+":"+(t.nid||o),l=p[a];n.nid=o,n.nss=s,n.path=void 0,l&&(n=l.parse(n,t))}else n.error=n.error||"URN can not be parsed.";return n},serialize:function(e,t){var i=t.scheme||e.scheme||"urn",n=e.nid,r=i+":"+(t.nid||n),o=p[r];o&&(e=o.serialize(e,t));var s=e,a=e.nss;return s.path=(n||t.nid)+":"+a,s}},se=/^[0-9A-Fa-f]{8}(?:\-[0-9A-Fa-f]{4}){3}\-[0-9A-Fa-f]{12}$/,ae={scheme:"urn:uuid",parse:function(e,t){var i=e;return i.uuid=i.nss,i.nss=void 0,t.tolerant||i.uuid&&i.uuid.match(se)||(i.error=i.error||"UUID is not valid."),i},serialize:function(e,t){var i=e;return i.nss=(e.uuid||"").toLowerCase(),i}};p[P.scheme]=P,p[K.scheme]=K,p[ne.scheme]=ne,p[oe.scheme]=oe,p[ae.scheme]=ae,e.SCHEMES=p,e.pctEncChar=m,e.pctDecChars=I,e.parse=k,e.removeDotSegments=Z,e.serialize=T,e.resolveComponents=O,e.resolve=function(e,t,i){var n=r({scheme:"null"},i);return T(O(k(e,n),k(t,n),n,!0),n)},e.normalize=function(e,t){"string"==typeof e?e=T(k(e,t),t):"object"===n(e)&&(e=k(T(e,t),t));return e},e.equal=function(e,t,i){"string"==typeof e?e=T(k(e,i),i):"object"===n(e)&&(e=T(e,i));"string"==typeof t?t=T(k(t,i),i):"object"===n(t)&&(t=T(t,i));return e===t},e.escapeComponent=function(e,t){return e&&e.toString().replace(t&&t.iri?l.ESCAPE:a.ESCAPE,m)},e.unescapeComponent=F,Object.defineProperty(e,"__esModule",{value:!0})}(t)},function(e,t,i){"use strict";e.exports=function(e){for(var t,i=0,n=e.length,r=0;r<n;)i++,55296<=(t=e.charCodeAt(r++))&&t<=56319&&r<n&&56320==(64512&(t=e.charCodeAt(r)))&&r++;return i}},function(e,t,i){"use strict";var m=e.exports=function(e,t,i){"function"==typeof t&&(i=t,t={}),function e(t,i,n,r,o,s,a,l,c,h){if(r&&"object"==typeof r&&!Array.isArray(r)){for(var d in i(r,o,s,a,l,c,h),r){var u=r[d];if(Array.isArray(u)){if(d in m.arrayKeywords)for(var g=0;g<u.length;g++)e(t,i,n,u[g],o+"/"+d+"/"+g,s,o,d,r,g)}else if(d in m.propsKeywords){if(u&&"object"==typeof u)for(var p in u)e(t,i,n,u[p],o+"/"+d+"/"+p.replace(/~/g,"~0").replace(/\//g,"~1"),s,o,d,r,p)}else(d in m.keywords||t.allKeys&&!(d in m.skipKeywords))&&e(t,i,n,u,o+"/"+d,s,o,d,r)}n(r,o,s,a,l,c,h)}}(t,"function"==typeof(i=t.cb||i)?i:i.pre||function(){},i.post||function(){},e,"",e)};m.keywords={additionalItems:!0,items:!0,contains:!0,additionalProperties:!0,propertyNames:!0,not:!0},m.arrayKeywords={items:!0,allOf:!0,anyOf:!0,oneOf:!0},m.propsKeywords={definitions:!0,properties:!0,patternProperties:!0,dependencies:!0},m.skipKeywords={default:!0,enum:!0,const:!0,required:!0,maximum:!0,minimum:!0,exclusiveMaximum:!0,exclusiveMinimum:!0,multipleOf:!0,maxLength:!0,minLength:!0,pattern:!0,format:!0,maxItems:!0,minItems:!0,uniqueItems:!0,maxProperties:!0,minProperties:!0}},function(e,t,i){"use strict";var n=e.exports=function(){this._cache={}};n.prototype.put=function(e,t){this._cache[e]=t},n.prototype.get=function(e){return this._cache[e]},n.prototype.del=function(e){delete this._cache[e]},n.prototype.clear=function(){this._cache={}}},function(e,t,i){"use strict";var n=i(5),o=/^(\d\d\d\d)-(\d\d)-(\d\d)$/,s=[0,31,28,31,30,31,30,31,31,30,31,30,31],a=/^(\d\d):(\d\d):(\d\d)(\.\d+)?(z|[+-]\d\d:\d\d)?$/i,r=/^[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[-0-9a-z]{0,61}[0-9a-z])?)*$/i,l=/^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)(?:\?(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i,c=/^(?:(?:[^\x00-\x20"'<>%\\^`{|}]|%[0-9a-f]{2})|\{[+#./;?&=,!@|]?(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?(?:,(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?)*\})*$/i,h=/^(?:(?:http[s\u017F]?|ftp):\/\/)(?:(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+(?::(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?@)?(?:(?!10(?:\.[0-9]{1,3}){3})(?!127(?:\.[0-9]{1,3}){3})(?!169\.254(?:\.[0-9]{1,3}){2})(?!192\.168(?:\.[0-9]{1,3}){2})(?!172\.(?:1[6-9]|2[0-9]|3[01])(?:\.[0-9]{1,3}){2})(?:[1-9][0-9]?|1[0-9][0-9]|2[01][0-9]|22[0-3])(?:\.(?:1?[0-9]{1,2}|2[0-4][0-9]|25[0-5])){2}(?:\.(?:[1-9][0-9]?|1[0-9][0-9]|2[0-4][0-9]|25[0-4]))|(?:(?:(?:[0-9KSa-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-?)*(?:[0-9KSa-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)(?:\.(?:(?:[0-9KSa-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-?)*(?:[0-9KSa-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)*(?:\.(?:(?:[KSa-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]){2,})))(?::[0-9]{2,5})?(?:\/(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?$/i,d=/^(?:urn:uuid:)?[0-9a-f]{8}-(?:[0-9a-f]{4}-){3}[0-9a-f]{12}$/i,u=/^(?:\/(?:[^~/]|~0|~1)*)*$/,g=/^#(?:\/(?:[a-z0-9_\-.!$&'()*+,;:=@]|%[0-9a-f]{2}|~0|~1)*)*$/i,p=/^(?:0|[1-9][0-9]*)(?:#|(?:\/(?:[^~/]|~0|~1)*)*)$/;function m(e){return e="full"==e?"full":"fast",n.copy(m[e])}function f(e){var t=e.match(o);if(!t)return!1;var i=+t[1],n=+t[2],r=+t[3];return 1<=n&&n<=12&&1<=r&&r<=(2==n&&function(e){return e%4==0&&(e%100!=0||e%400==0)}(i)?29:s[n])}function C(e,t){var i=e.match(a);if(!i)return!1;var n=i[1],r=i[2],o=i[3],s=i[5];return(n<=23&&r<=59&&o<=59||23==n&&59==r&&60==o)&&(!t||s)}(e.exports=m).fast={date:/^\d\d\d\d-[0-1]\d-[0-3]\d$/,time:/^(?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d:\d\d)?$/i,"date-time":/^\d\d\d\d-[0-1]\d-[0-3]\d[t\s](?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d:\d\d)$/i,uri:/^(?:[a-z][a-z0-9+-.]*:)(?:\/?\/)?[^\s]*$/i,"uri-reference":/^(?:(?:[a-z][a-z0-9+-.]*:)?\/?\/)?(?:[^\\\s#][^\s#]*)?(?:#[^\\\s]*)?$/i,"uri-template":c,url:h,email:/^[a-z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?)*$/i,hostname:r,ipv4:/^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,ipv6:/^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,regex:b,uuid:d,"json-pointer":u,"json-pointer-uri-fragment":g,"relative-json-pointer":p},m.full={date:f,time:C,"date-time":function(e){var t=e.split(I);return 2==t.length&&f(t[0])&&C(t[1],!0)},uri:function(e){return A.test(e)&&l.test(e)},"uri-reference":/^(?:[a-z][a-z0-9+\-.]*:)?(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'"()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?(?:\?(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i,"uri-template":c,url:h,email:/^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$/i,hostname:function(e){return e.length<=255&&r.test(e)},ipv4:/^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,ipv6:/^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,regex:b,uuid:d,"json-pointer":u,"json-pointer-uri-fragment":g,"relative-json-pointer":p};var I=/t|\s/i;var A=/\/|:/;var v=/[^\\]\\Z/;function b(e){if(v.test(e))return!1;try{return new RegExp(e),!0}catch(e){return!1}}},function(e,t,i){"use strict";var o=i(50),s=i(5).toHash;e.exports=function(){var n=[{type:"number",rules:[{maximum:["exclusiveMaximum"]},{minimum:["exclusiveMinimum"]},"multipleOf","format"]},{type:"string",rules:["maxLength","minLength","pattern","format"]},{type:"array",rules:["maxItems","minItems","items","contains","uniqueItems"]},{type:"object",rules:["maxProperties","minProperties","required","dependencies","propertyNames",{properties:["additionalProperties","patternProperties"]}]},{rules:["$ref","const","enum","not","anyOf","oneOf","allOf","if"]}],r=["type","$comment"];return n.all=s(r),n.types=s(["number","integer","string","array","object","boolean","null"]),n.forEach(function(e){e.rules=e.rules.map(function(e){var t;if("object"==typeof e){var i=Object.keys(e)[0];t=e[i],e=i,t.forEach(function(e){r.push(e),n.all[e]=!0})}return r.push(e),n.all[e]={keyword:e,code:o[e],implements:t}}),n.all.$comment={keyword:"$comment",code:o.$comment},e.type&&(n.types[e.type]=e)}),n.keywords=s(r.concat(["$schema","$id","id","$data","$async","title","description","default","definitions","examples","readOnly","writeOnly","contentMediaType","contentEncoding","additionalItems","then","else"])),n.custom={},n}},function(e,t,i){"use strict";e.exports={$ref:i(51),allOf:i(52),anyOf:i(53),$comment:i(54),const:i(55),contains:i(56),dependencies:i(57),enum:i(58),format:i(59),if:i(60),items:i(61),maximum:i(27),minimum:i(27),maxItems:i(28),minItems:i(28),maxLength:i(29),minLength:i(29),maxProperties:i(30),minProperties:i(30),multipleOf:i(62),not:i(63),oneOf:i(64),pattern:i(65),properties:i(66),propertyNames:i(67),required:i(68),uniqueItems:i(69),validate:i(26)}},function(e,t,i){"use strict";e.exports=function(e,t){var i,n,r=" ",o=e.level,s=e.dataLevel,a=e.schema[t],l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(s||""),d="valid"+o;if("#"==a||"#/"==a)n=e.isRoot?(i=e.async,"validate"):(i=!0===e.root.schema.$async,"root.refVal[0]");else{var u=e.resolveRef(e.baseId,a,e.isRoot);if(void 0===u){var g=e.MissingRefError.message(e.baseId,a);if("fail"==e.opts.missingRefs){e.logger.error(g),(C=C||[]).push(r),r="",!1!==e.createErrors?(r+=" { keyword: '$ref' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { ref: '"+e.util.escapeQuotes(a)+"' } ",!1!==e.opts.messages&&(r+=" , message: 'can\\'t resolve reference "+e.util.escapeQuotes(a)+"' "),e.opts.verbose&&(r+=" , schema: "+e.util.toQuotedString(a)+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),r+=" } "):r+=" {} ";var p=r;r=C.pop(),!e.compositeRule&&c?e.async?r+=" throw new ValidationError(["+p+"]); ":r+=" validate.errors = ["+p+"]; return false; ":r+=" var err = "+p+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",c&&(r+=" if (false) { ")}else{if("ignore"!=e.opts.missingRefs)throw new e.MissingRefError(e.baseId,a,g);e.logger.warn(g),c&&(r+=" if (true) { ")}}else if(u.inline){var m=e.util.copy(e);m.level++;var f="valid"+m.level;m.schema=u.schema,m.schemaPath="",m.errSchemaPath=a,r+=" "+e.validate(m).replace(/validate\.schema/g,u.code)+" ",c&&(r+=" if ("+f+") { ")}else i=!0===u.$async||e.async&&!1!==u.$async,n=u.code}if(n){var C;(C=C||[]).push(r),r="",e.opts.passContext?r+=" "+n+".call(this, ":r+=" "+n+"( ",r+=" "+h+", (dataPath || '')",'""'!=e.errorPath&&(r+=" + "+e.errorPath);var I=r+=" , "+(s?"data"+(s-1||""):"parentData")+" , "+(s?e.dataPathArr[s]:"parentDataProperty")+", rootData)  ";if(r=C.pop(),i){if(!e.async)throw new Error("async schema referenced by sync schema");c&&(r+=" var "+d+"; "),r+=" try { await "+I+"; ",c&&(r+=" "+d+" = true; "),r+=" } catch (e) { if (!(e instanceof ValidationError)) throw e; if (vErrors === null) vErrors = e.errors; else vErrors = vErrors.concat(e.errors); errors = vErrors.length; ",c&&(r+=" "+d+" = false; "),r+=" } ",c&&(r+=" if ("+d+") { ")}else r+=" if (!"+I+") { if (vErrors === null) vErrors = "+n+".errors; else vErrors = vErrors.concat("+n+".errors); errors = vErrors.length; } ",c&&(r+=" else { ")}return r}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.schema[t],r=e.schemaPath+e.util.getProperty(t),o=e.errSchemaPath+"/"+t,s=!e.opts.allErrors,a=e.util.copy(e),l="";a.level++;var c="valid"+a.level,h=a.baseId,d=!0,u=n;if(u)for(var g,p=-1,m=u.length-1;p<m;)g=u[p+=1],(e.opts.strictKeywords?"object"==typeof g&&0<Object.keys(g).length:e.util.schemaHasRules(g,e.RULES.all))&&(d=!1,a.schema=g,a.schemaPath=r+"["+p+"]",a.errSchemaPath=o+"/"+p,i+="  "+e.validate(a)+" ",a.baseId=h,s&&(i+=" if ("+c+") { ",l+="}"));return s&&(i+=d?" if (true) { ":" "+l.slice(0,-1)+" "),i=e.util.cleanUpCode(i)}},function(e,t,i){"use strict";e.exports=function(t,e){var i=" ",n=t.level,r=t.dataLevel,o=t.schema[e],s=t.schemaPath+t.util.getProperty(e),a=t.errSchemaPath+"/"+e,l=!t.opts.allErrors,c="data"+(r||""),h="valid"+n,d="errs__"+n,u=t.util.copy(t),g="";u.level++;var p="valid"+u.level;if(o.every(function(e){return t.opts.strictKeywords?"object"==typeof e&&0<Object.keys(e).length:t.util.schemaHasRules(e,t.RULES.all)})){var m=u.baseId;i+=" var "+d+" = errors; var "+h+" = false;  ";var f=t.compositeRule;t.compositeRule=u.compositeRule=!0;var C=o;if(C)for(var I,A=-1,v=C.length-1;A<v;)I=C[A+=1],u.schema=I,u.schemaPath=s+"["+A+"]",u.errSchemaPath=a+"/"+A,i+="  "+t.validate(u)+" ",u.baseId=m,i+=" "+h+" = "+h+" || "+p+"; if (!"+h+") { ",g+="}";t.compositeRule=u.compositeRule=f,i+=" "+g+" if (!"+h+") {   var err =   ",!1!==t.createErrors?(i+=" { keyword: 'anyOf' , dataPath: (dataPath || '') + "+t.errorPath+" , schemaPath: "+t.util.toQuotedString(a)+" , params: {} ",!1!==t.opts.messages&&(i+=" , message: 'should match some schema in anyOf' "),t.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+t.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",i+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!t.compositeRule&&l&&(t.async?i+=" throw new ValidationError(vErrors); ":i+=" validate.errors = vErrors; return false; "),i+=" } else {  errors = "+d+"; if (vErrors !== null) { if ("+d+") vErrors.length = "+d+"; else vErrors = null; } ",t.opts.allErrors&&(i+=" } "),i=t.util.cleanUpCode(i)}else l&&(i+=" if (true) { ");return i}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.schema[t],r=e.errSchemaPath+"/"+t,o=(e.opts.allErrors,e.util.toQuotedString(n));return!0===e.opts.$comment?i+=" console.log("+o+");":"function"==typeof e.opts.$comment&&(i+=" self._opts.$comment("+o+", "+e.util.toQuotedString(r)+", validate.root.schema);"),i}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],s=e.schemaPath+e.util.getProperty(t),a=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),h="valid"+n,d=e.opts.$data&&o&&o.$data;d&&(i+=" var schema"+n+" = "+e.util.getData(o.$data,r,e.dataPathArr)+"; "),d||(i+=" var schema"+n+" = validate.schema"+s+";"),i+="var "+h+" = equal("+c+", schema"+n+"); if (!"+h+") {   ";var u=u||[];u.push(i),i="",!1!==e.createErrors?(i+=" { keyword: 'const' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { allowedValue: schema"+n+" } ",!1!==e.opts.messages&&(i+=" , message: 'should be equal to constant' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ";var g=i;return i=u.pop(),!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+g+"]); ":i+=" validate.errors = ["+g+"]; return false; ":i+=" var err = "+g+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+=" }",l&&(i+=" else { "),i}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],s=e.schemaPath+e.util.getProperty(t),a=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),h="valid"+n,d="errs__"+n,u=e.util.copy(e);u.level++;var g="valid"+u.level,p="i"+n,m=u.dataLevel=e.dataLevel+1,f="data"+m,C=e.baseId,I=e.opts.strictKeywords?"object"==typeof o&&0<Object.keys(o).length:e.util.schemaHasRules(o,e.RULES.all);if(i+="var "+d+" = errors;var "+h+";",I){var A=e.compositeRule;e.compositeRule=u.compositeRule=!0,u.schema=o,u.schemaPath=s,u.errSchemaPath=a,i+=" var "+g+" = false; for (var "+p+" = 0; "+p+" < "+c+".length; "+p+"++) { ",u.errorPath=e.util.getPathExpr(e.errorPath,p,e.opts.jsonPointers,!0);var v=c+"["+p+"]";u.dataPathArr[m]=p;var b=e.validate(u);u.baseId=C,e.util.varOccurences(b,f)<2?i+=" "+e.util.varReplace(b,f,v)+" ":i+=" var "+f+" = "+v+"; "+b+" ",i+=" if ("+g+") break; }  ",e.compositeRule=u.compositeRule=A,i+="  if (!"+g+") {"}else i+=" if ("+c+".length == 0) {";var y=y||[];y.push(i),i="",!1!==e.createErrors?(i+=" { keyword: 'contains' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: {} ",!1!==e.opts.messages&&(i+=" , message: 'should contain a valid item' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ";var w=i;return i=y.pop(),!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+w+"]); ":i+=" validate.errors = ["+w+"]; return false; ":i+=" var err = "+w+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+=" } else { ",I&&(i+="  errors = "+d+"; if (vErrors !== null) { if ("+d+") vErrors.length = "+d+"; else vErrors = null; } "),e.opts.allErrors&&(i+=" } "),i=e.util.cleanUpCode(i)}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],s=e.schemaPath+e.util.getProperty(t),a=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),h="errs__"+n,d=e.util.copy(e),u="";d.level++;var g="valid"+d.level,p={},m={},f=e.opts.ownProperties;for(v in o){var C=o[v],I=Array.isArray(C)?m:p;I[v]=C}i+="var "+h+" = errors;";var A=e.errorPath;for(var v in i+="var missing"+n+";",m)if((I=m[v]).length){if(i+=" if ( "+c+e.util.getProperty(v)+" !== undefined ",f&&(i+=" && Object.prototype.hasOwnProperty.call("+c+", '"+e.util.escapeQuotes(v)+"') "),l){i+=" && ( ";var b=I;if(b)for(var y=-1,w=b.length-1;y<w;){B=b[y+=1],y&&(i+=" || "),i+=" ( ( "+(W=c+(T=e.util.getProperty(B)))+" === undefined ",f&&(i+=" || ! Object.prototype.hasOwnProperty.call("+c+", '"+e.util.escapeQuotes(B)+"') "),i+=") && (missing"+n+" = "+e.util.toQuotedString(e.opts.jsonPointers?B:T)+") ) "}i+=")) {  ";var S="missing"+n,x="' + "+S+" + '";e.opts._errorDataPathProperty&&(e.errorPath=e.opts.jsonPointers?e.util.getPathExpr(A,S,!0):A+" + "+S);var k=k||[];k.push(i),i="",!1!==e.createErrors?(i+=" { keyword: 'dependencies' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { property: '"+e.util.escapeQuotes(v)+"', missingProperty: '"+x+"', depsCount: "+I.length+", deps: '"+e.util.escapeQuotes(1==I.length?I[0]:I.join(", "))+"' } ",!1!==e.opts.messages&&(i+=" , message: 'should have ",1==I.length?i+="property "+e.util.escapeQuotes(I[0]):i+="properties "+e.util.escapeQuotes(I.join(", ")),i+=" when property "+e.util.escapeQuotes(v)+" is present' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ";var R=i;i=k.pop(),!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+R+"]); ":i+=" validate.errors = ["+R+"]; return false; ":i+=" var err = "+R+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; "}else{i+=" ) { ";var E=I;if(E)for(var B,G=-1,Z=E.length-1;G<Z;){B=E[G+=1];var T=e.util.getProperty(B),W=(x=e.util.escapeQuotes(B),c+T);e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPath(A,B,e.opts.jsonPointers)),i+=" if ( "+W+" === undefined ",f&&(i+=" || ! Object.prototype.hasOwnProperty.call("+c+", '"+e.util.escapeQuotes(B)+"') "),i+=") {  var err =   ",!1!==e.createErrors?(i+=" { keyword: 'dependencies' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { property: '"+e.util.escapeQuotes(v)+"', missingProperty: '"+x+"', depsCount: "+I.length+", deps: '"+e.util.escapeQuotes(1==I.length?I[0]:I.join(", "))+"' } ",!1!==e.opts.messages&&(i+=" , message: 'should have ",1==I.length?i+="property "+e.util.escapeQuotes(I[0]):i+="properties "+e.util.escapeQuotes(I.join(", ")),i+=" when property "+e.util.escapeQuotes(v)+" is present' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",i+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } "}}i+=" }   ",l&&(u+="}",i+=" else { ")}e.errorPath=A;var _=d.baseId;for(var v in p){C=p[v];(e.opts.strictKeywords?"object"==typeof C&&0<Object.keys(C).length:e.util.schemaHasRules(C,e.RULES.all))&&(i+=" "+g+" = true; if ( "+c+e.util.getProperty(v)+" !== undefined ",f&&(i+=" && Object.prototype.hasOwnProperty.call("+c+", '"+e.util.escapeQuotes(v)+"') "),i+=") { ",d.schema=C,d.schemaPath=s+e.util.getProperty(v),d.errSchemaPath=a+"/"+e.util.escapeFragment(v),i+="  "+e.validate(d)+" ",d.baseId=_,i+=" }  ",l&&(i+=" if ("+g+") { ",u+="}"))}return l&&(i+="   "+u+" if ("+h+" == errors) {"),i=e.util.cleanUpCode(i)}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],s=e.schemaPath+e.util.getProperty(t),a=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),h="valid"+n,d=e.opts.$data&&o&&o.$data;d&&(i+=" var schema"+n+" = "+e.util.getData(o.$data,r,e.dataPathArr)+"; ");var u="i"+n,g="schema"+n;d||(i+=" var "+g+" = validate.schema"+s+";"),i+="var "+h+";",d&&(i+=" if (schema"+n+" === undefined) "+h+" = true; else if (!Array.isArray(schema"+n+")) "+h+" = false; else {"),i+=h+" = false;for (var "+u+"=0; "+u+"<"+g+".length; "+u+"++) if (equal("+c+", "+g+"["+u+"])) { "+h+" = true; break; }",d&&(i+="  }  "),i+=" if (!"+h+") {   ";var p=p||[];p.push(i),i="",!1!==e.createErrors?(i+=" { keyword: 'enum' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { allowedValues: schema"+n+" } ",!1!==e.opts.messages&&(i+=" , message: 'should be equal to one of the allowed values' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ";var m=i;return i=p.pop(),!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+m+"]); ":i+=" validate.errors = ["+m+"]; return false; ":i+=" var err = "+m+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+=" }",l&&(i+=" else { "),i}},function(e,t,i){"use strict";e.exports=function(e,t,i){var n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||"");if(!1===e.opts.format)return c&&(n+=" if (true) { "),n;var d,u=e.opts.$data&&s&&s.$data;d=u?(n+=" var schema"+r+" = "+e.util.getData(s.$data,o,e.dataPathArr)+"; ","schema"+r):s;var g=e.opts.unknownFormats,p=Array.isArray(g);if(u){n+=" var "+(m="format"+r)+" = formats["+d+"]; var "+(f="isObject"+r)+" = typeof "+m+" == 'object' && !("+m+" instanceof RegExp) && "+m+".validate; var "+(C="formatType"+r)+" = "+f+" && "+m+".type || 'string'; if ("+f+") { ",e.async&&(n+=" var async"+r+" = "+m+".async; "),n+=" "+m+" = "+m+".validate; } if (  ",u&&(n+=" ("+d+" !== undefined && typeof "+d+" != 'string') || "),n+=" (","ignore"!=g&&(n+=" ("+d+" && !"+m+" ",p&&(n+=" && self._opts.unknownFormats.indexOf("+d+") == -1 "),n+=") || "),n+=" ("+m+" && "+C+" == '"+i+"' && !(typeof "+m+" == 'function' ? ",e.async?n+=" (async"+r+" ? await "+m+"("+h+") : "+m+"("+h+")) ":n+=" "+m+"("+h+") ",n+=" : "+m+".test("+h+"))))) {"}else{var m;if(!(m=e.formats[s])){if("ignore"==g)return e.logger.warn('unknown format "'+s+'" ignored in schema at path "'+e.errSchemaPath+'"'),c&&(n+=" if (true) { "),n;if(p&&0<=g.indexOf(s))return c&&(n+=" if (true) { "),n;throw new Error('unknown format "'+s+'" is used in schema at path "'+e.errSchemaPath+'"')}var f,C=(f="object"==typeof m&&!(m instanceof RegExp)&&m.validate)&&m.type||"string";if(f){var I=!0===m.async;m=m.validate}if(C!=i)return c&&(n+=" if (true) { "),n;if(I){if(!e.async)throw new Error("async format in sync schema");n+=" if (!(await "+(A="formats"+e.util.getProperty(s)+".validate")+"("+h+"))) { "}else{n+=" if (! ";var A="formats"+e.util.getProperty(s);f&&(A+=".validate"),n+="function"==typeof m?" "+A+"("+h+") ":" "+A+".test("+h+") ",n+=") { "}}var v=v||[];v.push(n),n="",!1!==e.createErrors?(n+=" { keyword: 'format' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { format:  ",n+=u?""+d:""+e.util.toQuotedString(s),n+="  } ",!1!==e.opts.messages&&(n+=" , message: 'should match format \"",n+=u?"' + "+d+" + '":""+e.util.escapeQuotes(s),n+="\"' "),e.opts.verbose&&(n+=" , schema:  ",n+=u?"validate.schema"+a:""+e.util.toQuotedString(s),n+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var b=n;return n=v.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+b+"]); ":n+=" validate.errors = ["+b+"]; return false; ":n+=" var err = "+b+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",n+=" } ",c&&(n+=" else { "),n}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],s=e.schemaPath+e.util.getProperty(t),a=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),h="valid"+n,d="errs__"+n,u=e.util.copy(e);u.level++;var g="valid"+u.level,p=e.schema.then,m=e.schema.else,f=void 0!==p&&(e.opts.strictKeywords?"object"==typeof p&&0<Object.keys(p).length:e.util.schemaHasRules(p,e.RULES.all)),C=void 0!==m&&(e.opts.strictKeywords?"object"==typeof m&&0<Object.keys(m).length:e.util.schemaHasRules(m,e.RULES.all)),I=u.baseId;if(f||C){var A;u.createErrors=!1,u.schema=o,u.schemaPath=s,u.errSchemaPath=a,i+=" var "+d+" = errors; var "+h+" = true;  ";var v=e.compositeRule;e.compositeRule=u.compositeRule=!0,i+="  "+e.validate(u)+" ",u.baseId=I,u.createErrors=!0,i+="  errors = "+d+"; if (vErrors !== null) { if ("+d+") vErrors.length = "+d+"; else vErrors = null; }  ",e.compositeRule=u.compositeRule=v,f?(i+=" if ("+g+") {  ",u.schema=e.schema.then,u.schemaPath=e.schemaPath+".then",u.errSchemaPath=e.errSchemaPath+"/then",i+="  "+e.validate(u)+" ",u.baseId=I,i+=" "+h+" = "+g+"; ",f&&C?i+=" var "+(A="ifClause"+n)+" = 'then'; ":A="'then'",i+=" } ",C&&(i+=" else { ")):i+=" if (!"+g+") { ",C&&(u.schema=e.schema.else,u.schemaPath=e.schemaPath+".else",u.errSchemaPath=e.errSchemaPath+"/else",i+="  "+e.validate(u)+" ",u.baseId=I,i+=" "+h+" = "+g+"; ",f&&C?i+=" var "+(A="ifClause"+n)+" = 'else'; ":A="'else'",i+=" } "),i+=" if (!"+h+") {   var err =   ",!1!==e.createErrors?(i+=" { keyword: 'if' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { failingKeyword: "+A+" } ",!1!==e.opts.messages&&(i+=" , message: 'should match \"' + "+A+" + '\" schema' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",i+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!e.compositeRule&&l&&(e.async?i+=" throw new ValidationError(vErrors); ":i+=" validate.errors = vErrors; return false; "),i+=" }   ",l&&(i+=" else { "),i=e.util.cleanUpCode(i)}else l&&(i+=" if (true) { ");return i}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],s=e.schemaPath+e.util.getProperty(t),a=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),h="valid"+n,d="errs__"+n,u=e.util.copy(e),g="";u.level++;var p="valid"+u.level,m="i"+n,f=u.dataLevel=e.dataLevel+1,C="data"+f,I=e.baseId;if(i+="var "+d+" = errors;var "+h+";",Array.isArray(o)){var A=e.schema.additionalItems;if(!1===A){i+=" "+h+" = "+c+".length <= "+o.length+"; ";var v=a;a=e.errSchemaPath+"/additionalItems",i+="  if (!"+h+") {   ";var b=b||[];b.push(i),i="",!1!==e.createErrors?(i+=" { keyword: 'additionalItems' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { limit: "+o.length+" } ",!1!==e.opts.messages&&(i+=" , message: 'should NOT have more than "+o.length+" items' "),e.opts.verbose&&(i+=" , schema: false , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ";var y=i;i=b.pop(),!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+y+"]); ":i+=" validate.errors = ["+y+"]; return false; ":i+=" var err = "+y+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+=" } ",a=v,l&&(g+="}",i+=" else { ")}var w=o;if(w)for(var S,x=-1,k=w.length-1;x<k;)if(S=w[x+=1],e.opts.strictKeywords?"object"==typeof S&&0<Object.keys(S).length:e.util.schemaHasRules(S,e.RULES.all)){i+=" "+p+" = true; if ("+c+".length > "+x+") { ";var R=c+"["+x+"]";u.schema=S,u.schemaPath=s+"["+x+"]",u.errSchemaPath=a+"/"+x,u.errorPath=e.util.getPathExpr(e.errorPath,x,e.opts.jsonPointers,!0),u.dataPathArr[f]=x;var E=e.validate(u);u.baseId=I,e.util.varOccurences(E,C)<2?i+=" "+e.util.varReplace(E,C,R)+" ":i+=" var "+C+" = "+R+"; "+E+" ",i+=" }  ",l&&(i+=" if ("+p+") { ",g+="}")}if("object"==typeof A&&(e.opts.strictKeywords?"object"==typeof A&&0<Object.keys(A).length:e.util.schemaHasRules(A,e.RULES.all))){u.schema=A,u.schemaPath=e.schemaPath+".additionalItems",u.errSchemaPath=e.errSchemaPath+"/additionalItems",i+=" "+p+" = true; if ("+c+".length > "+o.length+") {  for (var "+m+" = "+o.length+"; "+m+" < "+c+".length; "+m+"++) { ",u.errorPath=e.util.getPathExpr(e.errorPath,m,e.opts.jsonPointers,!0);R=c+"["+m+"]";u.dataPathArr[f]=m;E=e.validate(u);u.baseId=I,e.util.varOccurences(E,C)<2?i+=" "+e.util.varReplace(E,C,R)+" ":i+=" var "+C+" = "+R+"; "+E+" ",l&&(i+=" if (!"+p+") break; "),i+=" } }  ",l&&(i+=" if ("+p+") { ",g+="}")}}else if(e.opts.strictKeywords?"object"==typeof o&&0<Object.keys(o).length:e.util.schemaHasRules(o,e.RULES.all)){u.schema=o,u.schemaPath=s,u.errSchemaPath=a,i+="  for (var "+m+" = 0; "+m+" < "+c+".length; "+m+"++) { ",u.errorPath=e.util.getPathExpr(e.errorPath,m,e.opts.jsonPointers,!0);R=c+"["+m+"]";u.dataPathArr[f]=m;E=e.validate(u);u.baseId=I,e.util.varOccurences(E,C)<2?i+=" "+e.util.varReplace(E,C,R)+" ":i+=" var "+C+" = "+R+"; "+E+" ",l&&(i+=" if (!"+p+") break; "),i+=" }"}return l&&(i+=" "+g+" if ("+d+" == errors) {"),i=e.util.cleanUpCode(i)}},function(e,t,i){"use strict";e.exports=function(e,t){var i,n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||""),d=e.opts.$data&&s&&s.$data;i=d?(n+=" var schema"+r+" = "+e.util.getData(s.$data,o,e.dataPathArr)+"; ","schema"+r):s,n+="var division"+r+";if (",d&&(n+=" "+i+" !== undefined && ( typeof "+i+" != 'number' || "),n+=" (division"+r+" = "+h+" / "+i+", ",e.opts.multipleOfPrecision?n+=" Math.abs(Math.round(division"+r+") - division"+r+") > 1e-"+e.opts.multipleOfPrecision+" ":n+=" division"+r+" !== parseInt(division"+r+") ",n+=" ) ",d&&(n+="  )  "),n+=" ) {   ";var u=u||[];u.push(n),n="",!1!==e.createErrors?(n+=" { keyword: 'multipleOf' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { multipleOf: "+i+" } ",!1!==e.opts.messages&&(n+=" , message: 'should be multiple of ",n+=d?"' + "+i:i+"'"),e.opts.verbose&&(n+=" , schema:  ",n+=d?"validate.schema"+a:""+s,n+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var g=n;return n=u.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+g+"]); ":n+=" validate.errors = ["+g+"]; return false; ":n+=" var err = "+g+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",n+="} ",c&&(n+=" else { "),n}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],s=e.schemaPath+e.util.getProperty(t),a=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),h="errs__"+n,d=e.util.copy(e);d.level++;var u="valid"+d.level;if(e.opts.strictKeywords?"object"==typeof o&&0<Object.keys(o).length:e.util.schemaHasRules(o,e.RULES.all)){d.schema=o,d.schemaPath=s,d.errSchemaPath=a,i+=" var "+h+" = errors;  ";var g,p=e.compositeRule;e.compositeRule=d.compositeRule=!0,d.createErrors=!1,d.opts.allErrors&&(g=d.opts.allErrors,d.opts.allErrors=!1),i+=" "+e.validate(d)+" ",d.createErrors=!0,g&&(d.opts.allErrors=g),e.compositeRule=d.compositeRule=p,i+=" if ("+u+") {   ";var m=m||[];m.push(i),i="",!1!==e.createErrors?(i+=" { keyword: 'not' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: {} ",!1!==e.opts.messages&&(i+=" , message: 'should NOT be valid' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ";var f=i;i=m.pop(),!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+f+"]); ":i+=" validate.errors = ["+f+"]; return false; ":i+=" var err = "+f+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+=" } else {  errors = "+h+"; if (vErrors !== null) { if ("+h+") vErrors.length = "+h+"; else vErrors = null; } ",e.opts.allErrors&&(i+=" } ")}else i+="  var err =   ",!1!==e.createErrors?(i+=" { keyword: 'not' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: {} ",!1!==e.opts.messages&&(i+=" , message: 'should NOT be valid' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",i+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",l&&(i+=" if (false) { ");return i}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],s=e.schemaPath+e.util.getProperty(t),a=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),h="valid"+n,d="errs__"+n,u=e.util.copy(e),g="";u.level++;var p="valid"+u.level,m=u.baseId,f="prevValid"+n,C="passingSchemas"+n;i+="var "+d+" = errors , "+f+" = false , "+h+" = false , "+C+" = null; ";var I=e.compositeRule;e.compositeRule=u.compositeRule=!0;var A=o;if(A)for(var v,b=-1,y=A.length-1;b<y;)v=A[b+=1],(e.opts.strictKeywords?"object"==typeof v&&0<Object.keys(v).length:e.util.schemaHasRules(v,e.RULES.all))?(u.schema=v,u.schemaPath=s+"["+b+"]",u.errSchemaPath=a+"/"+b,i+="  "+e.validate(u)+" ",u.baseId=m):i+=" var "+p+" = true; ",b&&(i+=" if ("+p+" && "+f+") { "+h+" = false; "+C+" = ["+C+", "+b+"]; } else { ",g+="}"),i+=" if ("+p+") { "+h+" = "+f+" = true; "+C+" = "+b+"; }";return e.compositeRule=u.compositeRule=I,i+=g+"if (!"+h+") {   var err =   ",!1!==e.createErrors?(i+=" { keyword: 'oneOf' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { passingSchemas: "+C+" } ",!1!==e.opts.messages&&(i+=" , message: 'should match exactly one schema in oneOf' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",i+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!e.compositeRule&&l&&(e.async?i+=" throw new ValidationError(vErrors); ":i+=" validate.errors = vErrors; return false; "),i+="} else {  errors = "+d+"; if (vErrors !== null) { if ("+d+") vErrors.length = "+d+"; else vErrors = null; }",e.opts.allErrors&&(i+=" } "),i}},function(e,t,i){"use strict";e.exports=function(e,t){var i,n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||""),d=e.opts.$data&&s&&s.$data;i=d?(n+=" var schema"+r+" = "+e.util.getData(s.$data,o,e.dataPathArr)+"; ","schema"+r):s,n+="if ( ",d&&(n+=" ("+i+" !== undefined && typeof "+i+" != 'string') || "),n+=" !"+(d?"(new RegExp("+i+"))":e.usePattern(s))+".test("+h+") ) {   ";var u=u||[];u.push(n),n="",!1!==e.createErrors?(n+=" { keyword: 'pattern' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { pattern:  ",n+=d?""+i:""+e.util.toQuotedString(s),n+="  } ",!1!==e.opts.messages&&(n+=" , message: 'should match pattern \"",n+=d?"' + "+i+" + '":""+e.util.escapeQuotes(s),n+="\"' "),e.opts.verbose&&(n+=" , schema:  ",n+=d?"validate.schema"+a:""+e.util.toQuotedString(s),n+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var g=n;return n=u.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+g+"]); ":n+=" validate.errors = ["+g+"]; return false; ":n+=" var err = "+g+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",n+="} ",c&&(n+=" else { "),n}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],s=e.schemaPath+e.util.getProperty(t),a=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),h="errs__"+n,d=e.util.copy(e),u="";d.level++;var g="valid"+d.level,p="key"+n,m="idx"+n,f=d.dataLevel=e.dataLevel+1,C="data"+f,I="dataProperties"+n,A=Object.keys(o||{}),v=e.schema.patternProperties||{},b=Object.keys(v),y=e.schema.additionalProperties,w=A.length||b.length,S=!1===y,x="object"==typeof y&&Object.keys(y).length,k=e.opts.removeAdditional,R=S||x||k,E=e.opts.ownProperties,B=e.baseId,G=e.schema.required;if(G&&(!e.opts.$data||!G.$data)&&G.length<e.opts.loopRequired)var Z=e.util.toHash(G);if(i+="var "+h+" = errors;var "+g+" = true;",E&&(i+=" var "+I+" = undefined;"),R){if(i+=E?" "+I+" = "+I+" || Object.keys("+c+"); for (var "+m+"=0; "+m+"<"+I+".length; "+m+"++) { var "+p+" = "+I+"["+m+"]; ":" for (var "+p+" in "+c+") { ",w){if(i+=" var isAdditional"+n+" = !(false ",A.length)if(8<A.length)i+=" || validate.schema"+s+".hasOwnProperty("+p+") ";else{var T=A;if(T)for(var W=-1,_=T.length-1;W<_;)X=T[W+=1],i+=" || "+p+" == "+e.util.toQuotedString(X)+" "}if(b.length){var H=b;if(H)for(var L=-1,$=H.length-1;L<$;)ne=H[L+=1],i+=" || "+e.usePattern(ne)+".test("+p+") "}i+=" ); if (isAdditional"+n+") { "}if("all"==k)i+=" delete "+c+"["+p+"]; ";else{var V=e.errorPath,N="' + "+p+" + '";if(e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPathExpr(e.errorPath,p,e.opts.jsonPointers)),S)if(k)i+=" delete "+c+"["+p+"]; ";else{i+=" "+g+" = false; ";var O=a;a=e.errSchemaPath+"/additionalProperties",(ee=ee||[]).push(i),i="",!1!==e.createErrors?(i+=" { keyword: 'additionalProperties' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { additionalProperty: '"+N+"' } ",!1!==e.opts.messages&&(i+=" , message: '",e.opts._errorDataPathProperty?i+="is an invalid additional property":i+="should NOT have additional properties",i+="' "),e.opts.verbose&&(i+=" , schema: false , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ";var F=i;i=ee.pop(),!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+F+"]); ":i+=" validate.errors = ["+F+"]; return false; ":i+=" var err = "+F+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",a=O,l&&(i+=" break; ")}else if(x)if("failing"==k){i+=" var "+h+" = errors;  ";var P=e.compositeRule;e.compositeRule=d.compositeRule=!0,d.schema=y,d.schemaPath=e.schemaPath+".additionalProperties",d.errSchemaPath=e.errSchemaPath+"/additionalProperties",d.errorPath=e.opts._errorDataPathProperty?e.errorPath:e.util.getPathExpr(e.errorPath,p,e.opts.jsonPointers);var K=c+"["+p+"]";d.dataPathArr[f]=p;var M=e.validate(d);d.baseId=B,e.util.varOccurences(M,C)<2?i+=" "+e.util.varReplace(M,C,K)+" ":i+=" var "+C+" = "+K+"; "+M+" ",i+=" if (!"+g+") { errors = "+h+"; if (validate.errors !== null) { if (errors) validate.errors.length = errors; else validate.errors = null; } delete "+c+"["+p+"]; }  ",e.compositeRule=d.compositeRule=P}else{d.schema=y,d.schemaPath=e.schemaPath+".additionalProperties",d.errSchemaPath=e.errSchemaPath+"/additionalProperties",d.errorPath=e.opts._errorDataPathProperty?e.errorPath:e.util.getPathExpr(e.errorPath,p,e.opts.jsonPointers);K=c+"["+p+"]";d.dataPathArr[f]=p;M=e.validate(d);d.baseId=B,e.util.varOccurences(M,C)<2?i+=" "+e.util.varReplace(M,C,K)+" ":i+=" var "+C+" = "+K+"; "+M+" ",l&&(i+=" if (!"+g+") break; ")}e.errorPath=V}w&&(i+=" } "),i+=" }  ",l&&(i+=" if ("+g+") { ",u+="}")}var D=e.opts.useDefaults&&!e.compositeRule;if(A.length){var j=A;if(j)for(var X,Y=-1,J=j.length-1;Y<J;){var z=o[X=j[Y+=1]];if(e.opts.strictKeywords?"object"==typeof z&&0<Object.keys(z).length:e.util.schemaHasRules(z,e.RULES.all)){var U=e.util.getProperty(X),Q=(K=c+U,D&&void 0!==z.default);d.schema=z,d.schemaPath=s+U,d.errSchemaPath=a+"/"+e.util.escapeFragment(X),d.errorPath=e.util.getPath(e.errorPath,X,e.opts.jsonPointers),d.dataPathArr[f]=e.util.toQuotedString(X);M=e.validate(d);if(d.baseId=B,e.util.varOccurences(M,C)<2){M=e.util.varReplace(M,C,K);var q=K}else{q=C;i+=" var "+C+" = "+K+"; "}if(Q)i+=" "+M+" ";else{if(Z&&Z[X]){i+=" if ( "+q+" === undefined ",E&&(i+=" || ! Object.prototype.hasOwnProperty.call("+c+", '"+e.util.escapeQuotes(X)+"') "),i+=") { "+g+" = false; ";V=e.errorPath,O=a;var ee,te=e.util.escapeQuotes(X);e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPath(V,X,e.opts.jsonPointers)),a=e.errSchemaPath+"/required",(ee=ee||[]).push(i),i="",!1!==e.createErrors?(i+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { missingProperty: '"+te+"' } ",!1!==e.opts.messages&&(i+=" , message: '",e.opts._errorDataPathProperty?i+="is a required property":i+="should have required property \\'"+te+"\\'",i+="' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ";F=i;i=ee.pop(),!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+F+"]); ":i+=" validate.errors = ["+F+"]; return false; ":i+=" var err = "+F+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",a=O,e.errorPath=V,i+=" } else { "}else l?(i+=" if ( "+q+" === undefined ",E&&(i+=" || ! Object.prototype.hasOwnProperty.call("+c+", '"+e.util.escapeQuotes(X)+"') "),i+=") { "+g+" = true; } else { "):(i+=" if ("+q+" !== undefined ",E&&(i+=" &&   Object.prototype.hasOwnProperty.call("+c+", '"+e.util.escapeQuotes(X)+"') "),i+=" ) { ");i+=" "+M+" } "}}l&&(i+=" if ("+g+") { ",u+="}")}}if(b.length){var ie=b;if(ie)for(var ne,re=-1,oe=ie.length-1;re<oe;){z=v[ne=ie[re+=1]];if(e.opts.strictKeywords?"object"==typeof z&&0<Object.keys(z).length:e.util.schemaHasRules(z,e.RULES.all)){d.schema=z,d.schemaPath=e.schemaPath+".patternProperties"+e.util.getProperty(ne),d.errSchemaPath=e.errSchemaPath+"/patternProperties/"+e.util.escapeFragment(ne),i+=E?" "+I+" = "+I+" || Object.keys("+c+"); for (var "+m+"=0; "+m+"<"+I+".length; "+m+"++) { var "+p+" = "+I+"["+m+"]; ":" for (var "+p+" in "+c+") { ",i+=" if ("+e.usePattern(ne)+".test("+p+")) { ",d.errorPath=e.util.getPathExpr(e.errorPath,p,e.opts.jsonPointers);K=c+"["+p+"]";d.dataPathArr[f]=p;M=e.validate(d);d.baseId=B,e.util.varOccurences(M,C)<2?i+=" "+e.util.varReplace(M,C,K)+" ":i+=" var "+C+" = "+K+"; "+M+" ",l&&(i+=" if (!"+g+") break; "),i+=" } ",l&&(i+=" else "+g+" = true; "),i+=" }  ",l&&(i+=" if ("+g+") { ",u+="}")}}}return l&&(i+=" "+u+" if ("+h+" == errors) {"),i=e.util.cleanUpCode(i)}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],s=e.schemaPath+e.util.getProperty(t),a=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),h="errs__"+n,d=e.util.copy(e);d.level++;var u="valid"+d.level;if(i+="var "+h+" = errors;",e.opts.strictKeywords?"object"==typeof o&&0<Object.keys(o).length:e.util.schemaHasRules(o,e.RULES.all)){d.schema=o,d.schemaPath=s,d.errSchemaPath=a;var g="key"+n,p="idx"+n,m="i"+n,f="' + "+g+" + '",C="data"+(d.dataLevel=e.dataLevel+1),I="dataProperties"+n,A=e.opts.ownProperties,v=e.baseId;A&&(i+=" var "+I+" = undefined; "),i+=A?" "+I+" = "+I+" || Object.keys("+c+"); for (var "+p+"=0; "+p+"<"+I+".length; "+p+"++) { var "+g+" = "+I+"["+p+"]; ":" for (var "+g+" in "+c+") { ",i+=" var startErrs"+n+" = errors; ";var b=g,y=e.compositeRule;e.compositeRule=d.compositeRule=!0;var w=e.validate(d);d.baseId=v,e.util.varOccurences(w,C)<2?i+=" "+e.util.varReplace(w,C,b)+" ":i+=" var "+C+" = "+b+"; "+w+" ",e.compositeRule=d.compositeRule=y,
i+=" if (!"+u+") { for (var "+m+"=startErrs"+n+"; "+m+"<errors; "+m+"++) { vErrors["+m+"].propertyName = "+g+"; }   var err =   ",!1!==e.createErrors?(i+=" { keyword: 'propertyNames' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { propertyName: '"+f+"' } ",!1!==e.opts.messages&&(i+=" , message: 'property name \\'"+f+"\\' is invalid' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",i+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!e.compositeRule&&l&&(e.async?i+=" throw new ValidationError(vErrors); ":i+=" validate.errors = vErrors; return false; "),l&&(i+=" break; "),i+=" } }"}return l&&(i+="  if ("+h+" == errors) {"),i=e.util.cleanUpCode(i)}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],s=e.schemaPath+e.util.getProperty(t),a=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),h="valid"+n,d=e.opts.$data&&o&&o.$data;d&&(i+=" var schema"+n+" = "+e.util.getData(o.$data,r,e.dataPathArr)+"; ");var u="schema"+n;if(!d)if(o.length<e.opts.loopRequired&&e.schema.properties&&Object.keys(e.schema.properties).length){var g=[],p=o;if(p)for(var m,f=-1,C=p.length-1;f<C;){m=p[f+=1];var I=e.schema.properties[m];I&&(e.opts.strictKeywords?"object"==typeof I&&0<Object.keys(I).length:e.util.schemaHasRules(I,e.RULES.all))||(g[g.length]=m)}}else g=o;if(d||g.length){var A=e.errorPath,v=d||g.length>=e.opts.loopRequired,b=e.opts.ownProperties;if(l)if(i+=" var missing"+n+"; ",v){d||(i+=" var "+u+" = validate.schema"+s+"; ");var y="' + "+(E="schema"+n+"["+(x="i"+n)+"]")+" + '";e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPathExpr(A,E,e.opts.jsonPointers)),i+=" var "+h+" = true; ",d&&(i+=" if (schema"+n+" === undefined) "+h+" = true; else if (!Array.isArray(schema"+n+")) "+h+" = false; else {"),i+=" for (var "+x+" = 0; "+x+" < "+u+".length; "+x+"++) { "+h+" = "+c+"["+u+"["+x+"]] !== undefined ",b&&(i+=" &&   Object.prototype.hasOwnProperty.call("+c+", "+u+"["+x+"]) "),i+="; if (!"+h+") break; } ",d&&(i+="  }  "),(R=R||[]).push(i+="  if (!"+h+") {   "),i="",!1!==e.createErrors?(i+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { missingProperty: '"+y+"' } ",!1!==e.opts.messages&&(i+=" , message: '",e.opts._errorDataPathProperty?i+="is a required property":i+="should have required property \\'"+y+"\\'",i+="' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ";var w=i;i=R.pop(),!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+w+"]); ":i+=" validate.errors = ["+w+"]; return false; ":i+=" var err = "+w+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+=" } else { "}else{i+=" if ( ";var S=g;if(S)for(var x=-1,k=S.length-1;x<k;){G=S[x+=1],x&&(i+=" || "),i+=" ( ( "+(_=c+(W=e.util.getProperty(G)))+" === undefined ",b&&(i+=" || ! Object.prototype.hasOwnProperty.call("+c+", '"+e.util.escapeQuotes(G)+"') "),i+=") && (missing"+n+" = "+e.util.toQuotedString(e.opts.jsonPointers?G:W)+") ) "}i+=") {  ";var R;y="' + "+(E="missing"+n)+" + '";e.opts._errorDataPathProperty&&(e.errorPath=e.opts.jsonPointers?e.util.getPathExpr(A,E,!0):A+" + "+E),(R=R||[]).push(i),i="",!1!==e.createErrors?(i+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { missingProperty: '"+y+"' } ",!1!==e.opts.messages&&(i+=" , message: '",e.opts._errorDataPathProperty?i+="is a required property":i+="should have required property \\'"+y+"\\'",i+="' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ";w=i;i=R.pop(),!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+w+"]); ":i+=" validate.errors = ["+w+"]; return false; ":i+=" var err = "+w+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+=" } else { "}else if(v){d||(i+=" var "+u+" = validate.schema"+s+"; ");var E;y="' + "+(E="schema"+n+"["+(x="i"+n)+"]")+" + '";e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPathExpr(A,E,e.opts.jsonPointers)),d&&(i+=" if ("+u+" && !Array.isArray("+u+")) {  var err =   ",!1!==e.createErrors?(i+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { missingProperty: '"+y+"' } ",!1!==e.opts.messages&&(i+=" , message: '",e.opts._errorDataPathProperty?i+="is a required property":i+="should have required property \\'"+y+"\\'",i+="' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",i+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } else if ("+u+" !== undefined) { "),i+=" for (var "+x+" = 0; "+x+" < "+u+".length; "+x+"++) { if ("+c+"["+u+"["+x+"]] === undefined ",b&&(i+=" || ! Object.prototype.hasOwnProperty.call("+c+", "+u+"["+x+"]) "),i+=") {  var err =   ",!1!==e.createErrors?(i+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { missingProperty: '"+y+"' } ",!1!==e.opts.messages&&(i+=" , message: '",e.opts._errorDataPathProperty?i+="is a required property":i+="should have required property \\'"+y+"\\'",i+="' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",i+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } } ",d&&(i+="  }  ")}else{var B=g;if(B)for(var G,Z=-1,T=B.length-1;Z<T;){G=B[Z+=1];var W=e.util.getProperty(G),_=(y=e.util.escapeQuotes(G),c+W);e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPath(A,G,e.opts.jsonPointers)),i+=" if ( "+_+" === undefined ",b&&(i+=" || ! Object.prototype.hasOwnProperty.call("+c+", '"+e.util.escapeQuotes(G)+"') "),i+=") {  var err =   ",!1!==e.createErrors?(i+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { missingProperty: '"+y+"' } ",!1!==e.opts.messages&&(i+=" , message: '",e.opts._errorDataPathProperty?i+="is a required property":i+="should have required property \\'"+y+"\\'",i+="' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",i+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } "}}e.errorPath=A}else l&&(i+=" if (true) {");return i}},function(e,t,i){"use strict";e.exports=function(e,t){var i,n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||""),d="valid"+r,u=e.opts.$data&&s&&s.$data;if(i=u?(n+=" var schema"+r+" = "+e.util.getData(s.$data,o,e.dataPathArr)+"; ","schema"+r):s,(s||u)&&!1!==e.opts.uniqueItems){u&&(n+=" var "+d+"; if ("+i+" === false || "+i+" === undefined) "+d+" = true; else if (typeof "+i+" != 'boolean') "+d+" = false; else { "),n+=" var i = "+h+".length , "+d+" = true , j; if (i > 1) { ";var g=e.schema.items&&e.schema.items.type,p=Array.isArray(g);if(!g||"object"==g||"array"==g||p&&(0<=g.indexOf("object")||0<=g.indexOf("array")))n+=" outer: for (;i--;) { for (j = i; j--;) { if (equal("+h+"[i], "+h+"[j])) { "+d+" = false; break outer; } } } ";else{n+=" var itemIndices = {}, item; for (;i--;) { var item = "+h+"[i]; ";var m="checkDataType"+(p?"s":"");n+=" if ("+e.util[m](g,"item",!0)+") continue; ",p&&(n+=" if (typeof item == 'string') item = '\"' + item; "),n+=" if (typeof itemIndices[item] == 'number') { "+d+" = false; j = itemIndices[item]; break; } itemIndices[item] = i; } "}n+=" } ",u&&(n+="  }  "),n+=" if (!"+d+") {   ";var f=f||[];f.push(n),n="",!1!==e.createErrors?(n+=" { keyword: 'uniqueItems' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { i: i, j: j } ",!1!==e.opts.messages&&(n+=" , message: 'should NOT have duplicate items (items ## ' + j + ' and ' + i + ' are identical)' "),e.opts.verbose&&(n+=" , schema:  ",n+=u?"validate.schema"+a:""+s,n+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var C=n;n=f.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+C+"]); ":n+=" validate.errors = ["+C+"]; return false; ":n+=" var err = "+C+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",n+=" } ",c&&(n+=" else { ")}else c&&(n+=" if (true) { ");return n}},function(e,t,i){"use strict";var l=["multipleOf","maximum","exclusiveMaximum","minimum","exclusiveMinimum","maxLength","minLength","pattern","additionalItems","maxItems","minItems","uniqueItems","maxProperties","minProperties","required","additionalProperties","enum","format","const"];e.exports=function(e,t){for(var i=0;i<t.length;i++){e=JSON.parse(JSON.stringify(e));var n,r=t[i].split("/"),o=e;for(n=1;n<r.length;n++)o=o[r[n]];for(n=0;n<l.length;n++){var s=l[n],a=o[s];a&&(o[s]={anyOf:[a,{$ref:"https://raw.githubusercontent.com/epoberezkin/ajv/master/lib/refs/data.json#"}]})}}return e}},function(e,t,i){"use strict";var r=i(18).MissingRef;e.exports=function i(t,s,n){var a=this;if("function"!=typeof this._opts.loadSchema)throw new Error("options.loadSchema should be a function");"function"==typeof s&&(n=s,s=void 0);var e=l(t).then(function(){var e=a._addSchema(t,void 0,s);return e.validate||c(e)});n&&e.then(function(e){n(null,e)},n);return e;function l(e){var t=e.$schema;return t&&!a.getSchema(t)?i.call(a,{$ref:t},!0):Promise.resolve()}function c(o){try{return a._compile(o)}catch(e){if(e instanceof r)return t(e);throw e}function t(e){var t=e.missingSchema;if(r(t))throw new Error("Schema "+t+" is loaded but "+e.missingRef+" cannot be resolved");var i=a._loadingSchemas[t];return i||(i=a._loadingSchemas[t]=a._opts.loadSchema(t)).then(n,n),i.then(function(e){if(!r(t))return l(e).then(function(){r(t)||a.addSchema(e,t,void 0,s)})}).then(function(){return c(o)});function n(){delete a._loadingSchemas[t]}function r(e){return a._refs[e]||a._schemas[e]}}}}},function(e,t,i){"use strict";var s=/^[a-z_$][a-z0-9_$-]*$/i,l=i(73),r=i(74);e.exports={add:function(e,t){var a=this.RULES;if(a.keywords[e])throw new Error("Keyword "+e+" is already defined");if(!s.test(e))throw new Error("Keyword "+e+" is not a valid identifier");if(t){this.validateKeyword(t,!0);var i=t.type;if(Array.isArray(i))for(var n=0;n<i.length;n++)o(e,i[n],t);else o(e,i,t);var r=t.metaSchema;r&&(t.$data&&this._opts.$data&&(r={anyOf:[r,{$ref:"https://raw.githubusercontent.com/epoberezkin/ajv/master/lib/refs/data.json#"}]}),t.validateSchema=this.compile(r,!0))}function o(e,t,i){for(var n,r=0;r<a.length;r++){var o=a[r];if(o.type==t){n=o;break}}n||(n={type:t,rules:[]},a.push(n));var s={keyword:e,definition:i,custom:!0,code:l,implements:i.implements};n.rules.push(s),a.custom[e]=s}return a.keywords[e]=a.all[e]=!0,this},get:function(e){var t=this.RULES.custom[e];return t?t.definition:this.RULES.keywords[e]||!1},remove:function(e){var t=this.RULES;delete t.keywords[e],delete t.all[e],delete t.custom[e];for(var i=0;i<t.length;i++)for(var n=t[i].rules,r=0;r<n.length;r++)if(n[r].keyword==e){n.splice(r,1);break}return this},validate:function e(t,i){e.errors=null;var n=this._validateKeyword=this._validateKeyword||this.compile(r,!0);if(n(t))return!0;e.errors=n.errors;{if(i)throw new Error("custom keyword definition is invalid: "+this.errorsText(n.errors));return!1}}}},function(e,t,i){"use strict";e.exports=function(e,t){var i,n,r=" ",o=e.level,s=e.dataLevel,a=e.schema[t],l=e.schemaPath+e.util.getProperty(t),c=e.errSchemaPath+"/"+t,h=!e.opts.allErrors,d="data"+(s||""),u="valid"+o,g="errs__"+o,p=e.opts.$data&&a&&a.$data;n=p?(r+=" var schema"+o+" = "+e.util.getData(a.$data,s,e.dataPathArr)+"; ","schema"+o):a;var m,f,C,I,A,v="definition"+o,b=this.definition,y="";if(p&&b.$data){A="keywordValidate"+o;var w=b.validateSchema;r+=" var "+v+" = RULES.custom['"+t+"'].definition; var "+A+" = "+v+".validate;"}else{if(!(I=e.useCustomRule(this,a,e.schema,e)))return;n="validate.schema"+l,A=I.code,m=b.compile,f=b.inline,C=b.macro}var S=A+".errors",x="i"+o,k="ruleErr"+o,R=b.async;if(R&&!e.async)throw new Error("async keyword in sync schema");if(f||C||(r+=S+" = null;"),r+="var "+g+" = errors;var "+u+";",p&&b.$data&&(y+="}",r+=" if ("+n+" === undefined) { "+u+" = true; } else { ",w&&(y+="}",r+=" "+u+" = "+v+".validateSchema("+n+"); if ("+u+") { ")),f)b.statements?r+=" "+I.validate+" ":r+=" "+u+" = "+I.validate+"; ";else if(C){var E=e.util.copy(e);y="";E.level++;var B="valid"+E.level;E.schema=I.validate,E.schemaPath="";var G=e.compositeRule;e.compositeRule=E.compositeRule=!0;var Z=e.validate(E).replace(/validate\.schema/g,A);e.compositeRule=E.compositeRule=G,r+=" "+Z}else{(H=H||[]).push(r),r="",r+="  "+A+".call( ",e.opts.passContext?r+="this":r+="self",m||!1===b.schema?r+=" , "+d+" ":r+=" , "+n+" , "+d+" , validate.schema"+e.schemaPath+" ",r+=" , (dataPath || '')",'""'!=e.errorPath&&(r+=" + "+e.errorPath);var T=s?"data"+(s-1||""):"parentData",W=s?e.dataPathArr[s]:"parentDataProperty",_=r+=" , "+T+" , "+W+" , rootData )  ";r=H.pop(),!1===b.errors?(r+=" "+u+" = ",R&&(r+="await "),r+=_+"; "):r+=R?" var "+(S="customErrors"+o)+" = null; try { "+u+" = await "+_+"; } catch (e) { "+u+" = false; if (e instanceof ValidationError) "+S+" = e.errors; else throw e; } ":" "+S+" = null; "+u+" = "+_+"; "}if(b.modifying&&(r+=" if ("+T+") "+d+" = "+T+"["+W+"];"),r+=""+y,b.valid)h&&(r+=" if (true) { ");else{var H;r+=" if ( ",void 0===b.valid?(r+=" !",r+=C?""+B:u):r+=" "+!b.valid+" ",r+=") { ",i=this.keyword,(H=H||[]).push(r),(H=H||[]).push(r=""),r="",!1!==e.createErrors?(r+=" { keyword: '"+(i||"custom")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: { keyword: '"+this.keyword+"' } ",!1!==e.opts.messages&&(r+=" , message: 'should pass \""+this.keyword+"\" keyword validation' "),e.opts.verbose&&(r+=" , schema: validate.schema"+l+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),r+=" } "):r+=" {} ";var L=r;r=H.pop(),!e.compositeRule&&h?e.async?r+=" throw new ValidationError(["+L+"]); ":r+=" validate.errors = ["+L+"]; return false; ":r+=" var err = "+L+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";var $=r;r=H.pop(),f?b.errors?"full"!=b.errors&&(r+="  for (var "+x+"="+g+"; "+x+"<errors; "+x+"++) { var "+k+" = vErrors["+x+"]; if ("+k+".dataPath === undefined) "+k+".dataPath = (dataPath || '') + "+e.errorPath+"; if ("+k+".schemaPath === undefined) { "+k+'.schemaPath = "'+c+'"; } ',e.opts.verbose&&(r+=" "+k+".schema = "+n+"; "+k+".data = "+d+"; "),r+=" } "):!1===b.errors?r+=" "+$+" ":(r+=" if ("+g+" == errors) { "+$+" } else {  for (var "+x+"="+g+"; "+x+"<errors; "+x+"++) { var "+k+" = vErrors["+x+"]; if ("+k+".dataPath === undefined) "+k+".dataPath = (dataPath || '') + "+e.errorPath+"; if ("+k+".schemaPath === undefined) { "+k+'.schemaPath = "'+c+'"; } ',e.opts.verbose&&(r+=" "+k+".schema = "+n+"; "+k+".data = "+d+"; "),r+=" } } "):C?(r+="   var err =   ",!1!==e.createErrors?(r+=" { keyword: '"+(i||"custom")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: { keyword: '"+this.keyword+"' } ",!1!==e.opts.messages&&(r+=" , message: 'should pass \""+this.keyword+"\" keyword validation' "),e.opts.verbose&&(r+=" , schema: validate.schema"+l+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),r+=" } "):r+=" {} ",r+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!e.compositeRule&&h&&(e.async?r+=" throw new ValidationError(vErrors); ":r+=" validate.errors = vErrors; return false; ")):!1===b.errors?r+=" "+$+" ":(r+=" if (Array.isArray("+S+")) { if (vErrors === null) vErrors = "+S+"; else vErrors = vErrors.concat("+S+"); errors = vErrors.length;  for (var "+x+"="+g+"; "+x+"<errors; "+x+"++) { var "+k+" = vErrors["+x+"]; if ("+k+".dataPath === undefined) "+k+".dataPath = (dataPath || '') + "+e.errorPath+";  "+k+'.schemaPath = "'+c+'";  ',e.opts.verbose&&(r+=" "+k+".schema = "+n+"; "+k+".data = "+d+"; "),r+=" } } else { "+$+" } "),r+=" } ",h&&(r+=" else { ")}return r}},function(e,t,i){"use strict";var n=i(31);e.exports={$id:"https://github.com/epoberezkin/ajv/blob/master/lib/definition_schema.js",definitions:{simpleTypes:n.definitions.simpleTypes},type:"object",dependencies:{schema:["validate"],$data:["validate"],statements:["inline"],valid:{not:{required:["macro"]}}},properties:{type:n.properties.type,schema:{type:"boolean"},statements:{type:"boolean"},dependencies:{type:"array",items:{type:"string"}},metaSchema:{type:"object"},modifying:{type:"boolean"},valid:{type:"boolean"},$data:{type:"boolean"},async:{type:"boolean"},errors:{anyOf:[{type:"boolean"},{const:"full"}]}}}},function(e){e.exports=JSON.parse('{"$schema":"http://json-schema.org/draft-07/schema#","$id":"https://raw.githubusercontent.com/epoberezkin/ajv/master/lib/refs/data.json#","description":"Meta-schema for $data reference (JSON Schema extension proposal)","type":"object","required":["$data"],"properties":{"$data":{"type":"string","anyOf":[{"format":"relative-json-pointer"},{"format":"json-pointer"}]}},"additionalProperties":false}')},function(e){e.exports=JSON.parse('{"id":"http://json-schema.org/draft-04/schema#","$schema":"http://json-schema.org/draft-04/schema#","description":"Core schema meta-schema","definitions":{"schemaArray":{"type":"array","minItems":1,"items":{"$ref":"#"}},"positiveInteger":{"type":"integer","minimum":0},"positiveIntegerDefault0":{"allOf":[{"$ref":"#/definitions/positiveInteger"},{"default":0}]},"simpleTypes":{"enum":["array","boolean","integer","null","number","object","string"]},"stringArray":{"type":"array","items":{"type":"string"},"minItems":1,"uniqueItems":true}},"type":"object","properties":{"id":{"type":"string"},"$schema":{"type":"string"},"title":{"type":"string"},"description":{"type":"string"},"default":{},"multipleOf":{"type":"number","minimum":0,"exclusiveMinimum":true},"maximum":{"type":"number"},"exclusiveMaximum":{"type":"boolean","default":false},"minimum":{"type":"number"},"exclusiveMinimum":{"type":"boolean","default":false},"maxLength":{"$ref":"#/definitions/positiveInteger"},"minLength":{"$ref":"#/definitions/positiveIntegerDefault0"},"pattern":{"type":"string","format":"regex"},"additionalItems":{"anyOf":[{"type":"boolean"},{"$ref":"#"}],"default":{}},"items":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/schemaArray"}],"default":{}},"maxItems":{"$ref":"#/definitions/positiveInteger"},"minItems":{"$ref":"#/definitions/positiveIntegerDefault0"},"uniqueItems":{"type":"boolean","default":false},"maxProperties":{"$ref":"#/definitions/positiveInteger"},"minProperties":{"$ref":"#/definitions/positiveIntegerDefault0"},"required":{"$ref":"#/definitions/stringArray"},"additionalProperties":{"anyOf":[{"type":"boolean"},{"$ref":"#"}],"default":{}},"definitions":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"properties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"patternProperties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"dependencies":{"type":"object","additionalProperties":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/stringArray"}]}},"enum":{"type":"array","minItems":1,"uniqueItems":true},"type":{"anyOf":[{"$ref":"#/definitions/simpleTypes"},{"type":"array","items":{"$ref":"#/definitions/simpleTypes"},"minItems":1,"uniqueItems":true}]},"format":{"type":"string"},"allOf":{"$ref":"#/definitions/schemaArray"},"anyOf":{"$ref":"#/definitions/schemaArray"},"oneOf":{"$ref":"#/definitions/schemaArray"},"not":{"$ref":"#"}},"dependencies":{"exclusiveMaximum":["maximum"],"exclusiveMinimum":["minimum"]},"default":{}}')},function(e){e.exports=JSON.parse('{"$schema":"http://json-schema.org/draft-06/schema#","$id":"http://json-schema.org/draft-06/schema#","title":"Core schema meta-schema","definitions":{"schemaArray":{"type":"array","minItems":1,"items":{"$ref":"#"}},"nonNegativeInteger":{"type":"integer","minimum":0},"nonNegativeIntegerDefault0":{"allOf":[{"$ref":"#/definitions/nonNegativeInteger"},{"default":0}]},"simpleTypes":{"enum":["array","boolean","integer","null","number","object","string"]},"stringArray":{"type":"array","items":{"type":"string"},"uniqueItems":true,"default":[]}},"type":["object","boolean"],"properties":{"$id":{"type":"string","format":"uri-reference"},"$schema":{"type":"string","format":"uri"},"$ref":{"type":"string","format":"uri-reference"},"title":{"type":"string"},"description":{"type":"string"},"default":{},"examples":{"type":"array","items":{}},"multipleOf":{"type":"number","exclusiveMinimum":0},"maximum":{"type":"number"},"exclusiveMaximum":{"type":"number"},"minimum":{"type":"number"},"exclusiveMinimum":{"type":"number"},"maxLength":{"$ref":"#/definitions/nonNegativeInteger"},"minLength":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"pattern":{"type":"string","format":"regex"},"additionalItems":{"$ref":"#"},"items":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/schemaArray"}],"default":{}},"maxItems":{"$ref":"#/definitions/nonNegativeInteger"},"minItems":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"uniqueItems":{"type":"boolean","default":false},"contains":{"$ref":"#"},"maxProperties":{"$ref":"#/definitions/nonNegativeInteger"},"minProperties":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"required":{"$ref":"#/definitions/stringArray"},"additionalProperties":{"$ref":"#"},"definitions":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"properties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"patternProperties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"dependencies":{"type":"object","additionalProperties":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/stringArray"}]}},"propertyNames":{"$ref":"#"},"const":{},"enum":{"type":"array","minItems":1,"uniqueItems":true},"type":{"anyOf":[{"$ref":"#/definitions/simpleTypes"},{"type":"array","items":{"$ref":"#/definitions/simpleTypes"},"minItems":1,"uniqueItems":true}]},"format":{"type":"string"},"allOf":{"$ref":"#/definitions/schemaArray"},"anyOf":{"$ref":"#/definitions/schemaArray"},"oneOf":{"$ref":"#/definitions/schemaArray"},"not":{"$ref":"#"}},"default":{}}')},function(e,t,i){"use strict";i.r(t);var n=i(12),o=i.n(n);function r(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var s=function(){function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.locked=!1}return function(e,t,i){t&&r(e.prototype,t),i&&r(e,i)}(e,[{key:"highlight",value:function(e){this.locked||(this.node!==e&&(this.node&&this.node.setHighlight(!1),this.node=e,this.node.setHighlight(!0)),this._cancelUnhighlight())}},{key:"unhighlight",value:function(){if(!this.locked){var e=this;this.node&&(this._cancelUnhighlight(),this.unhighlightTimer=setTimeout(function(){e.node.setHighlight(!1),e.node=void 0,e.unhighlightTimer=void 0},0))}}},{key:"_cancelUnhighlight",value:function(){this.unhighlightTimer&&(clearTimeout(this.unhighlightTimer),this.unhighlightTimer=void 0)}},{key:"lock",value:function(){this.locked=!0}},{key:"unlock",value:function(){this.locked=!1}}]),e}(),H=i(0);function a(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var l=function(){function e(t){function o(e){return t.node.findNodeByInternalPath(e)}!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.editor=t,this.history=[],this.index=-1,this.clear(),this.actions={editField:{undo:function(e){o(e.parentPath).childs[e.index].updateField(e.oldValue)},redo:function(e){o(e.parentPath).childs[e.index].updateField(e.newValue)}},editValue:{undo:function(e){o(e.path).updateValue(e.oldValue)},redo:function(e){o(e.path).updateValue(e.newValue)}},changeType:{undo:function(e){o(e.path).changeType(e.oldType)},redo:function(e){o(e.path).changeType(e.newType)}},appendNodes:{undo:function(e){var t=o(e.parentPath);e.paths.map(o).forEach(function(e){t.removeChild(e)})},redo:function(e){var t=o(e.parentPath);e.nodes.forEach(function(e){t.appendChild(e)})}},insertBeforeNodes:{undo:function(e){var t=o(e.parentPath);e.paths.map(o).forEach(function(e){t.removeChild(e)})},redo:function(e){var t=o(e.parentPath),i=o(e.beforePath);e.nodes.forEach(function(e){t.insertBefore(e,i)})}},insertAfterNodes:{undo:function(e){var t=o(e.parentPath);e.paths.map(o).forEach(function(e){t.removeChild(e)})},redo:function(e){var t=o(e.parentPath),i=o(e.afterPath);e.nodes.forEach(function(e){t.insertAfter(e,i),i=e})}},removeNodes:{undo:function(e){var t=o(e.parentPath),i=t.childs[e.index]||t.append;e.nodes.forEach(function(e){t.insertBefore(e,i)})},redo:function(e){var t=o(e.parentPath);e.paths.map(o).forEach(function(e){t.removeChild(e)})}},duplicateNodes:{undo:function(e){var t=o(e.parentPath);e.clonePaths.map(o).forEach(function(e){t.removeChild(e)})},redo:function(e){var n=o(e.parentPath),r=o(e.afterPath);e.paths.map(o).forEach(function(e){var t=e.clone();if("object"===n.type){var i=n.getFieldNames();t.field=Object(H.findUniqueName)(e.field,i)}n.insertAfter(t,r),r=t})}},moveNodes:{undo:function(i){var n=o(i.oldParentPath),e=o(i.newParentPath),r=n.childs[i.oldIndex]||n.append;e.childs.slice(i.newIndex,i.newIndex+i.count).forEach(function(e,t){e.field=i.fieldNames[t],n.moveBefore(e,r)}),null===i.newParentPathRedo&&(i.newParentPathRedo=e.getInternalPath())},redo:function(i){var e=o(i.oldParentPathRedo),n=o(i.newParentPathRedo),r=n.childs[i.newIndexRedo]||n.append;e.childs.slice(i.oldIndexRedo,i.oldIndexRedo+i.count).forEach(function(e,t){e.field=i.fieldNames[t],n.moveBefore(e,r)})}},sort:{undo:function(e){var t=o(e.path);t.hideChilds(),t.childs=e.oldChilds,t.updateDom({updateIndexes:!0}),t.showChilds()},redo:function(e){var t=o(e.path);t.hideChilds(),t.childs=e.newChilds,t.updateDom({updateIndexes:!0}),t.showChilds()}},transform:{undo:function(e){o(e.path).setInternalValue(e.oldValue)},redo:function(e){o(e.path).setInternalValue(e.newValue)}}}}return function(e,t,i){t&&a(e.prototype,t),i&&a(e,i)}(e,[{key:"onChange",value:function(){}},{key:"add",value:function(e,t){this.index++,this.history[this.index]={action:e,params:t,timestamp:new Date},this.index<this.history.length-1&&this.history.splice(this.index+1,this.history.length-this.index-1),this.onChange()}},{key:"clear",value:function(){this.history=[],this.index=-1,this.onChange()}},{key:"canUndo",value:function(){return 0<=this.index}},{key:"canRedo",value:function(){return this.index<this.history.length-1}},{key:"undo",value:function(){if(this.canUndo()){var e=this.history[this.index];if(e){var t=this.actions[e.action];if(t&&t.undo){if(t.undo(e.params),e.params.oldSelection)try{this.editor.setDomSelection(e.params.oldSelection)}catch(e){console.error(e)}}else console.error(new Error('unknown action "'+e.action+'"'))}this.index--,this.onChange()}}},{key:"redo",value:function(){if(this.canRedo()){this.index++;var e=this.history[this.index];if(e){var t=this.actions[e.action];if(t&&t.redo){if(t.redo(e.params),e.params.newSelection)try{this.editor.setDomSelection(e.params.newSelection)}catch(e){console.error(e)}}else console.error(new Error('unknown action "'+e.action+'"'))}this.onChange()}}},{key:"destroy",value:function(){this.editor=null,this.history=[],this.index=-1}}]),e}(),d=i(1);function c(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var h=function(){function h(e,t){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,h);var i=this;this.editor=e,this.timeout=void 0,this.delay=200,this.lastText=void 0,this.results=null,this.dom={},this.dom.container=t;var n=document.createElement("div");(this.dom.wrapper=n).className="jsoneditor-search",t.appendChild(n);var r=document.createElement("div");(this.dom.results=r).className="jsoneditor-results",n.appendChild(r);var o=document.createElement("div");(this.dom.input=o).className="jsoneditor-frame",o.title=Object(d.c)("searchTitle"),n.appendChild(o);var s=document.createElement("button");s.type="button",s.className="jsoneditor-refresh",o.appendChild(s);var a=document.createElement("input");a.type="text",(this.dom.search=a).oninput=function(e){i._onDelayedSearch(e)},a.onchange=function(e){i._onSearch()},a.onkeydown=function(e){i._onKeyDown(e)},a.onkeyup=function(e){i._onKeyUp(e)},s.onclick=function(e){a.select()},o.appendChild(a);var l=document.createElement("button");l.type="button",l.title=Object(d.c)("searchNextResultTitle"),l.className="jsoneditor-next",l.onclick=function(){i.next()},o.appendChild(l);var c=document.createElement("button");c.type="button",c.title=Object(d.c)("searchPreviousResultTitle"),c.className="jsoneditor-previous",c.onclick=function(){i.previous()},o.appendChild(c)}return function(e,t,i){t&&c(e.prototype,t),i&&c(e,i)}(h,[{key:"next",value:function(e){if(this.results){var t=null!==this.resultIndex?this.resultIndex+1:0;t>this.results.length-1&&(t=0),this._setActiveResult(t,e)}}},{key:"previous",value:function(e){if(this.results){var t=this.results.length-1,i=null!==this.resultIndex?this.resultIndex-1:t;i<0&&(i=t),this._setActiveResult(i,e)}}},{key:"_setActiveResult",value:function(e,t){if(this.activeResult){var i=this.activeResult.node;"field"===this.activeResult.elem?delete i.searchFieldActive:delete i.searchValueActive,i.updateDom()}if(!this.results||!this.results[e])return this.resultIndex=void 0,void(this.activeResult=void 0);this.resultIndex=e;var n=this.results[this.resultIndex].node,r=this.results[this.resultIndex].elem;"field"===r?n.searchFieldActive=!0:n.searchValueActive=!0,this.activeResult=this.results[this.resultIndex],n.updateDom(),n.scrollTo(function(){t&&n.focus(r)})}},{key:"_clearDelay",value:function(){void 0!==this.timeout&&(clearTimeout(this.timeout),delete this.timeout)}},{key:"_onDelayedSearch",value:function(){this._clearDelay();var t=this;this.timeout=setTimeout(function(e){t._onSearch()},this.delay)}},{key:"_onSearch",value:function(e){this._clearDelay();var t=this.dom.search.value,i=0<t.length?t:void 0;if(i!==this.lastText||e){this.lastText=i,this.results=this.editor.search(i);var n=this.results[0]?this.results[0].node.MAX_SEARCH_RESULTS:1/0,r=0;if(this.activeResult)for(var o=0;o<this.results.length;o++)if(this.results[o].node===this.activeResult.node){r=o;break}if(this._setActiveResult(r,!1),void 0!==i){var s=this.results.length;this.dom.results.innerHTML=0===s?"no&nbsp;results":1===s?"1&nbsp;result":n<s?n+"+&nbsp;results":s+"&nbsp;results"}else this.dom.results.innerHTML=""}}},{key:"_onKeyDown",value:function(e){var t=e.which;27===t?(this.dom.search.value="",this._onSearch(),e.preventDefault(),e.stopPropagation()):13===t&&(e.ctrlKey?this._onSearch(!0):e.shiftKey?this.previous():this.next(),e.preventDefault(),e.stopPropagation())}},{key:"_onKeyUp",value:function(e){var t=e.keyCode;27!==t&&13!==t&&this._onDelayedSearch(e)}},{key:"clear",value:function(){this.dom.search.value="",this._onSearch()}},{key:"forceSearch",value:function(){this._onSearch(!0)}},{key:"isEmpty",value:function(){return""===this.dom.search.value}},{key:"destroy",value:function(){this.editor=null,this.dom.container.removeChild(this.dom.wrapper),this.dom=null,this.results=null,this.activeResult=null,this._clearDelay()}}]),h}(),u=i(3);function g(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var p=function(){function i(e,t){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,i),e&&(this.root=t,this.path=document.createElement("div"),this.path.className="jsoneditor-treepath",this.path.setAttribute("tabindex",0),this.contentMenuClicked=!1,e.appendChild(this.path),this.reset())}return function(e,t,i){t&&g(e.prototype,t),i&&g(e,i)}(i,[{key:"reset",value:function(){this.path.innerHTML=Object(d.c)("selectNode")}},{key:"setPath",value:function(s){var a=this;this.path.innerHTML="",s&&s.length&&s.forEach(function(i,n){var e,t=document.createElement("span");if(t.className="jsoneditor-treepath-element",t.innerText=i.name,t.onclick=function(e){this.selectionCallback&&this.selectionCallback(e)}.bind(a,i),a.path.appendChild(t),i.children.length&&((e=document.createElement("span")).className="jsoneditor-treepath-seperator",e.innerHTML="&#9658;",e.onclick=function(){a.contentMenuClicked=!0;var t=[];i.children.forEach(function(e){t.push({text:e.name,className:"jsoneditor-type-modes"+(s[n+1]+1&&s[n+1].name===e.name?" jsoneditor-selected":""),click:function(e,t){this.contextMenuCallback&&this.contextMenuCallback(e,t)}.bind(a,i,e.name)})}),new u.a(t).show(e,a.root,!0)},a.path.appendChild(e)),n===s.length-1){var r=(e||t).getBoundingClientRect().right;if(a.path.offsetWidth<r&&(a.path.scrollLeft=r),a.path.scrollLeft){var o=document.createElement("span");o.className="jsoneditor-treepath-show-all-btn",o.title="show all path",o.innerHTML="...",o.onclick=function(e){a.contentMenuClicked=!1,Object(H.addClassName)(a.path,"show-all"),a.path.style.width=a.path.parentNode.getBoundingClientRect().width-10+"px",a.path.onblur=function(){if(a.contentMenuClicked)return a.contentMenuClicked=!1,void a.path.focus();Object(H.removeClassName)(a.path,"show-all"),a.path.onblur=void 0,a.path.style.width="",a.setPath(e)}}.bind(a,s),a.path.insertBefore(o,a.path.firstChild)}}})}},{key:"onSectionSelected",value:function(e){"function"==typeof e&&(this.selectionCallback=e)}},{key:"onContextMenuItemSelected",value:function(e){"function"==typeof e&&(this.contextMenuCallback=e)}}]),i}(),m=i(4),f=i.n(m),C=i(10),I=i.n(C),A=i(11);var v=i(6),b=i(8),y=i(2);function w(e){return(w="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function S(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var R=function(){function _(e,t){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,_),this.editor=e,this.dom={},this.expanded=!1,t&&t instanceof Object?(this.setField(t.field,t.fieldEditable),"value"in t&&this.setValue(t.value,t.type),"internalValue"in t&&this.setInternalValue(t.internalValue)):(this.setField(""),this.setValue(null)),this._debouncedOnChangeValue=Object(H.debounce)(this._onChangeValue.bind(this),_.prototype.DEBOUNCE_INTERVAL),this._debouncedOnChangeField=Object(H.debounce)(this._onChangeField.bind(this),_.prototype.DEBOUNCE_INTERVAL),this.visibleChilds=this.getMaxVisibleChilds()}return function(e,t,i){t&&S(e.prototype,t),i&&S(e,i)}(_,[{key:"getMaxVisibleChilds",value:function(){return this.editor&&this.editor.options&&this.editor.options.maxVisibleChilds?this.editor.options.maxVisibleChilds:x}},{key:"_updateEditability",value:function(){if(this.editable={field:!0,value:!0},this.editor&&(this.editable.field="tree"===this.editor.options.mode,this.editable.value="view"!==this.editor.options.mode,("tree"===this.editor.options.mode||"form"===this.editor.options.mode)&&"function"==typeof this.editor.options.onEditable)){var e=this.editor.options.onEditable({field:this.field,value:this.value,path:this.getPath()});"boolean"==typeof e?(this.editable.field=e,this.editable.value=e):("boolean"==typeof e.field&&(this.editable.field=e.field),"boolean"==typeof e.value&&(this.editable.value=e.value))}}},{key:"getPath",value:function(){for(var e=this,t=[];e;){var i=e.getName();void 0!==i&&t.unshift(i),e=e.parent}return t}},{key:"getInternalPath",value:function(){for(var e=this,t=[];e;)e.parent&&t.unshift(e.getIndex()),e=e.parent;return t}},{key:"getName",value:function(){return this.parent?"array"!==this.parent.type?this.field:this.index:void 0}},{key:"findNodeByPath",value:function(e){if(e){if(0===e.length)return this;if(e.length&&this.childs&&this.childs.length)for(var t=0;t<this.childs.length;++t)if(""+e[0]==""+this.childs[t].getName())return this.childs[t].findNodeByPath(e.slice(1))}}},{key:"findNodeByInternalPath",value:function(e){if(e){for(var t=this,i=0;i<e.length&&t;i++){var n=e[i];t=t.childs[n]}return t}}},{key:"serialize",value:function(){return{value:this.getValue(),path:this.getPath()}}},{key:"findNode",value:function(e){for(var i=Object(H.parsePath)(e),n=this,t=function(){var t=i.shift();if("number"==typeof t){if("array"!==n.type)throw new Error("Cannot get child node at index "+t+": node is no array");n=n.childs[t]}else{if("object"!==n.type)throw new Error("Cannot get child node "+t+": node is no object");n=n.childs.filter(function(e){return e.field===t})[0]}};n&&0<i.length;)t();return n}},{key:"findParents",value:function(){for(var e=[],t=this.parent;t;)e.unshift(t),t=t.parent;return e}},{key:"setError",value:function(e,t){this.error=e,this.errorChild=t,this.dom&&this.dom.tr&&this.updateError()}},{key:"updateError",value:function(){var o=this,s=this.fieldError||this.valueError||this.error,e=this.dom.tdError;if(s&&this.dom&&this.dom.tr){Object(H.addClassName)(this.dom.tr,"jsoneditor-validation-error"),e||(e=document.createElement("td"),this.dom.tdError=e,this.dom.tdValue.parentNode.appendChild(e));var a=document.createElement("button");a.type="button",a.className="jsoneditor-button jsoneditor-schema-error";var t=function(){o.dom.popupAnchor&&o.dom.popupAnchor.destroy()},l=function(){delete o.dom.popupAnchor},i=function(e){var t=o.editor.frame;o.dom.popupAnchor=Object(A.a)(a,t,l,e);var i=a.getBoundingClientRect(),n=120<t.getBoundingClientRect().width-i.x?"jsoneditor-above":"jsoneditor-left",r=document.createElement("div");r.className="jsoneditor-popover "+n,r.appendChild(document.createTextNode(s.message)),o.dom.popupAnchor.appendChild(r)};a.onmouseover=function(){o.dom.popupAnchor||i(!0)},a.onfocus=function(){t(),i(!1)},a.onblur=function(){t()};var n=this.errorChild;for(n&&(a.onclick=function(){n.findParents().forEach(function(e){e.expand(!1)}),n.scrollTo(function(){n.focus()})});e.firstChild;)e.removeChild(e.firstChild);e.appendChild(a)}else this.dom.tr&&Object(H.removeClassName)(this.dom.tr,"jsoneditor-validation-error"),e&&(this.dom.tdError.parentNode.removeChild(this.dom.tdError),delete this.dom.tdError)}},{key:"getIndex",value:function(){if(this.parent){var e=this.parent.childs.indexOf(this);return-1!==e?e:null}return-1}},{key:"setParent",value:function(e){this.parent=e}},{key:"setField",value:function(e,t){this.field=e,this.previousField=e,this.fieldEditable=!0===t}},{key:"getField",value:function(){return void 0===this.field&&this._getDomField(),this.field}},{key:"setValue",value:function(e,t){var i,n,r,o,s,a=this.childs;if(this.type=this._getType(e),t&&t!==this.type){if("string"!==t||"auto"!==this.type)throw new Error('Type mismatch: cannot cast value of type "'+this.type+' to the specified type "'+t+'"');this.type=t}if("array"===this.type){for(this.childs||(this.childs=[]),o=0;o<e.length;o++)void 0===(i=e[o])||i instanceof Function||(o<this.childs.length?((n=this.childs[o]).fieldEditable=!1,n.index=o,n.setValue(i)):(n=new _(this.editor,{value:i}),r=o<this.getMaxVisibleChilds(),this.appendChild(n,r,!1)));for(s=this.childs.length;s>=e.length;s--)this.removeChild(this.childs[s],!1)}else if("object"===this.type){for(this.childs||(this.childs=[]),s=this.childs.length-1;0<=s;s--)E(e,this.childs[s].field)||this.removeChild(this.childs[s],!1);for(var l in o=0,e)E(e,l)&&(void 0===(i=e[l])||i instanceof Function||((n=this.findChildByProperty(l))?(n.setField(l,!0),n.setValue(i)):(n=new _(this.editor,{field:l,value:i}),r=o<this.getMaxVisibleChilds(),this.appendChild(n,r,!1))),o++);!(this.value="")===this.editor.options.sortObjectKeys&&this.sort([],"asc")}else this.hideChilds(),delete this.append,delete this.showMore,delete this.expanded,delete this.childs,this.value=e;Array.isArray(a)!==Array.isArray(this.childs)&&this.recreateDom(),this.updateDom({updateIndexes:!0}),this.previousValue=this.value}},{key:"setInternalValue",value:function(e){var t,i,n,r,o,s=this.childs;if(this.type=e.type,"array"===e.type){for(this.childs||(this.childs=[]),r=0;r<e.childs.length;r++)void 0===(t=e.childs[r])||t instanceof Function||(r<this.childs.length?((i=this.childs[r]).fieldEditable=!1,i.index=r,i.setInternalValue(t)):(i=new _(this.editor,{internalValue:t}),n=r<this.getMaxVisibleChilds(),this.appendChild(i,n,!1)));for(o=this.childs.length;o>=e.childs.length;o--)this.removeChild(this.childs[o],!1)}else if("object"===e.type){for(this.childs||(this.childs=[]),r=0;r<e.childs.length;r++)void 0===(t=e.childs[r])||t instanceof Function||(r<this.childs.length?(delete(i=this.childs[r]).index,i.setField(t.field,!0),i.setInternalValue(t.value)):(i=new _(this.editor,{field:t.field,internalValue:t.value}),n=r<this.getMaxVisibleChilds(),this.appendChild(i,n,!1)));for(o=this.childs.length;o>=e.childs.length;o--)this.removeChild(this.childs[o],!1)}else this.hideChilds(),delete this.append,delete this.showMore,delete this.expanded,delete this.childs,this.value=e.value;Array.isArray(s)!==Array.isArray(this.childs)&&this.recreateDom(),this.updateDom({updateIndexes:!0}),this.previousValue=this.value}},{key:"recreateDom",value:function(){if(this.dom&&this.dom.tr&&this.dom.tr.parentNode){var e=this._detachFromDom();this.clearDom(),this._attachToDom(e)}else this.clearDom()}},{key:"getValue",value:function(){if("array"===this.type){var t=[];return this.childs.forEach(function(e){t.push(e.getValue())}),t}if("object"!==this.type)return void 0===this.value&&this._getDomValue(),this.value;var i={};return this.childs.forEach(function(e){i[e.getField()]=e.getValue()}),i}},{key:"getInternalValue",value:function(){return"array"===this.type?{type:this.type,childs:this.childs.map(function(e){return e.getInternalValue()})}:"object"===this.type?{type:this.type,childs:this.childs.map(function(e){return{field:e.getField(),value:e.getInternalValue()}})}:(void 0===this.value&&this._getDomValue(),{type:this.type,value:this.value})}},{key:"getLevel",value:function(){return this.parent?this.parent.getLevel()+1:0}},{key:"getNodePath",value:function(){var e=this.parent?this.parent.getNodePath():[];return e.push(this),e}},{key:"clone",value:function(){var i=new _(this.editor);if(i.type=this.type,i.field=this.field,i.fieldInnerText=this.fieldInnerText,i.fieldEditable=this.fieldEditable,i.previousField=this.previousField,i.value=this.value,i.valueInnerText=this.valueInnerText,i.previousValue=this.previousValue,i.expanded=this.expanded,i.visibleChilds=this.visibleChilds,this.childs){var n=[];this.childs.forEach(function(e){var t=e.clone();t.setParent(i),n.push(t)}),i.childs=n}else i.childs=void 0;return i}},{key:"expand",value:function(t){this.childs&&(this.expanded=!0,this.dom.expand&&(this.dom.expand.className="jsoneditor-button jsoneditor-expanded"),this.showChilds(),!1!==t&&this.childs.forEach(function(e){e.expand(t)}))}},{key:"collapse",value:function(t){this.childs&&(this.hideChilds(),!1!==t&&this.childs.forEach(function(e){e.collapse(t)}),this.dom.expand&&(this.dom.expand.className="jsoneditor-button jsoneditor-collapsed"),this.expanded=!1)}},{key:"showChilds",value:function(){if(this.childs&&this.expanded){var e,t=this.dom.tr,i=t?t.parentNode:void 0;if(i){var n=this.getAppendDom();n.parentNode||((e=t.nextSibling)?i.insertBefore(n,e):i.appendChild(n));var r=Math.min(this.childs.length,this.visibleChilds);e=this._getNextTr();for(var o=0;o<r;o++){var s=this.childs[o];s.getDom().parentNode||i.insertBefore(s.getDom(),e),s.showChilds()}var a=this.getShowMoreDom();e=this._getNextTr(),a.parentNode||i.insertBefore(a,e),this.showMore.updateDom()}}}},{key:"_getNextTr",value:function(){return this.showMore&&this.showMore.getDom().parentNode?this.showMore.getDom():this.append&&this.append.getDom().parentNode?this.append.getDom():void 0}},{key:"hide",value:function(e){var t=this.dom.tr,i=t?t.parentNode:void 0;i&&i.removeChild(t),this.dom.popupAnchor&&this.dom.popupAnchor.destroy(),this.hideChilds(e)}},{key:"hideChilds",value:function(e){if(this.childs&&this.expanded){var t=this.getAppendDom();t.parentNode&&t.parentNode.removeChild(t),this.childs.forEach(function(e){e.hide()});var i=this.getShowMoreDom();i.parentNode&&i.parentNode.removeChild(i),e&&!e.resetVisibleChilds||(this.visibleChilds=this.getMaxVisibleChilds())}}},{key:"_updateCssClassName",value:function(){if(this.dom.field&&this.editor&&this.editor.options&&"function"==typeof this.editor.options.onClassName&&this.dom.tree){Object(H.removeAllClassNames)(this.dom.tree);var e=this.editor.options.onClassName({path:this.getPath(),field:this.field,value:this.value})||"";Object(H.addClassName)(this.dom.tree,"jsoneditor-values "+e)}}},{key:"recursivelyUpdateCssClassesOnNodes",value:function(){if(this._updateCssClassName(),Array.isArray(this.childs))for(var e=0;e<this.childs.length;e++)this.childs[e].recursivelyUpdateCssClassesOnNodes()}},{key:"expandTo",value:function(){for(var e=this.parent;e;)e.expanded||e.expand(),e=e.parent}},{key:"appendChild",value:function(e,t,i){if(this._hasChilds()){if(e.setParent(this),e.fieldEditable="object"===this.type,"array"===this.type&&(e.index=this.childs.length),"object"===this.type&&void 0===e.field&&e.setField(""),this.childs.push(e),this.expanded&&!1!==t){var n=e.getDom(),r=this._getNextTr(),o=r?r.parentNode:void 0;r&&o&&o.insertBefore(n,r),e.showChilds(),this.visibleChilds++}!1!==i&&(this.updateDom({updateIndexes:!0}),e.updateDom({recurse:!0}))}}},{key:"moveBefore",value:function(e,t){if(this._hasChilds()){var i=this.dom.tr?this.dom.tr.parentNode:void 0;if(i){var n=document.createElement("tr");n.style.height=i.clientHeight+"px",i.appendChild(n)}if(e.parent&&e.parent.removeChild(e),t instanceof $||!t)if(this.childs.length+1>this.visibleChilds){var r=this.childs[this.visibleChilds-1];this.insertBefore(e,r)}else this.appendChild(e);else this.insertBefore(e,t);i&&i.removeChild(n)}}},{key:"insertBefore",value:function(e,t){if(this._hasChilds()){if(this.visibleChilds++,"object"===this.type&&void 0===e.field&&e.setField(""),t===this.append)e.setParent(this),e.fieldEditable="object"===this.type,this.childs.push(e);else{var i=this.childs.indexOf(t);if(-1===i)throw new Error("Node not found");e.setParent(this),e.fieldEditable="object"===this.type,this.childs.splice(i,0,e)}if(this.expanded){var n=e.getDom(),r=t.getDom(),o=r?r.parentNode:void 0;r&&o&&o.insertBefore(n,r),e.showChilds(),this.showChilds()}this.updateDom({updateIndexes:!0}),e.updateDom({recurse:!0})}}},{key:"insertAfter",value:function(e,t){if(this._hasChilds()){var i=this.childs.indexOf(t),n=this.childs[i+1];n?this.insertBefore(e,n):this.appendChild(e)}}},{key:"search",value:function(t,i){Array.isArray(i)||(i=[]);var e=t?t.toLowerCase():void 0;delete this.searchField,delete this.searchValue,void 0!==this.field&&i.length<=this.MAX_SEARCH_RESULTS&&(-1!==String(this.field).toLowerCase().indexOf(e)&&(this.searchField=!0,i.push({node:this,elem:"field"})),this._updateDomField());this._hasChilds()?this.childs&&this.childs.forEach(function(e){e.search(t,i)}):void 0!==this.value&&i.length<=this.MAX_SEARCH_RESULTS&&(-1!==String(this.value).toLowerCase().indexOf(e)&&(this.searchValue=!0,i.push({node:this,elem:"value"})),this._updateDomValue());return i}},{key:"scrollTo",value:function(e){this.expandPathToNode(),this.dom.tr&&this.dom.tr.parentNode&&this.editor.scrollTo(this.dom.tr.offsetTop,e)}},{key:"expandPathToNode",value:function(){for(var e=this;e&&e.parent;){for(var t="array"===e.parent.type?e.index:e.parent.childs.indexOf(e);e.parent.visibleChilds<t+1;)e.parent.visibleChilds+=this.getMaxVisibleChilds();e.parent.expand(!1),e=e.parent}}},{key:"focus",value:function(e){if(_.focusElement=e,this.dom.tr&&this.dom.tr.parentNode){var t=this.dom;switch(e){case"drag":t.drag?t.drag.focus():t.menu.focus();break;case"menu":t.menu.focus();break;case"expand":this._hasChilds()?t.expand.focus():t.field&&this.fieldEditable?(t.field.focus(),Object(H.selectContentEditable)(t.field)):t.value&&!this._hasChilds()?(t.value.focus(),Object(H.selectContentEditable)(t.value)):t.menu.focus();break;case"field":t.field&&this.fieldEditable?(t.field.focus(),Object(H.selectContentEditable)(t.field)):t.value&&!this._hasChilds()?(t.value.focus(),Object(H.selectContentEditable)(t.value)):this._hasChilds()?t.expand.focus():t.menu.focus();break;case"value":default:t.select?t.select.focus():t.value&&!this._hasChilds()?(t.value.focus(),Object(H.selectContentEditable)(t.value)):t.field&&this.fieldEditable?(t.field.focus(),Object(H.selectContentEditable)(t.field)):this._hasChilds()?t.expand.focus():t.menu.focus()}}}},{key:"containsNode",value:function(e){if(this===e)return!0;var t=this.childs;if(t)for(var i=0,n=t.length;i<n;i++)if(t[i].containsNode(e))return!0;return!1}},{key:"removeChild",value:function(e,t){if(this.childs){var i=this.childs.indexOf(e);if(-1!==i){i<this.visibleChilds&&this.expanded&&this.visibleChilds--,e.hide(),delete e.searchField,delete e.searchValue;var n=this.childs.splice(i,1)[0];return n.parent=null,!1!==t&&this.updateDom({updateIndexes:!0}),n}}}},{key:"_remove",value:function(e){this.removeChild(e)}},{key:"changeType",value:function(e){var t=this.type;if(t!==e){if("string"!==e&&"auto"!==e||"string"!==t&&"auto"!==t){var i=this._detachFromDom();this.clearDom(),"object"===(this.type=e)?(this.childs||(this.childs=[]),this.childs.forEach(function(e){e.clearDom(),delete e.index,e.fieldEditable=!0,void 0===e.field&&(e.field="")}),"string"!==t&&"auto"!==t||(this.expanded=!0)):"array"===e?(this.childs||(this.childs=[]),this.childs.forEach(function(e,t){e.clearDom(),e.fieldEditable=!1,e.index=t}),"string"!==t&&"auto"!==t||(this.expanded=!0)):this.expanded=!1,this._attachToDom(i)}else this.type=e;"auto"!==e&&"string"!==e||(this.value="string"===e?String(this.value):Object(H.parseString)(String(this.value)),this.focus()),this.updateDom({updateIndexes:!0})}}},{key:"deepEqual",value:function(e){var t;if("array"===this.type){if(!Array.isArray(e))return!1;if(this.childs.length!==e.length)return!1;for(t=0;t<this.childs.length;t++)if(!this.childs[t].deepEqual(e[t]))return!1}else if("object"===this.type){if("object"!==w(e)||!e)return!1;var i={},n=0;for(t=0;t<this.childs.length;t++){var r=this.childs[t];if(!i[r.field]){if(i[r.field]=!0,n++,!(r.field in e))return!1;if(!r.deepEqual(e[r.field]))return!1}}if(n!==Object.keys(e).length)return!1}else if(this.value!==e)return!1;return!0}},{key:"_getDomValue",value:function(){if(this._clearValueError(),this.dom.value&&"array"!==this.type&&"object"!==this.type&&(this.valueInnerText=Object(H.getInnerText)(this.dom.value)),void 0!==this.valueInnerText)try{var e;if("string"===this.type)e=this._unescapeHTML(this.valueInnerText);else{var t=this._unescapeHTML(this.valueInnerText);e=Object(H.parseString)(t)}e!==this.value&&(this.value=e,this._debouncedOnChangeValue())}catch(e){this._setValueError(Object(d.c)("cannotParseValueError"))}}},{key:"_setValueError",value:function(e){this.valueError={message:e},this.updateError()}},{key:"_clearValueError",value:function(){this.valueError&&(this.valueError=null,this.updateError())}},{key:"_setFieldError",value:function(e){this.fieldError={message:e},this.updateError()}},{key:"_clearFieldError",value:function(){this.fieldError&&(this.fieldError=null,this.updateError())}},{key:"_onChangeValue",value:function(){var e=this.editor.getDomSelection();if(e.range){var t=Object(H.textDiff)(String(this.value),String(this.previousValue));e.range.startOffset=t.start,e.range.endOffset=t.end}var i=this.editor.getDomSelection();if(i.range){var n=Object(H.textDiff)(String(this.previousValue),String(this.value));i.range.startOffset=n.start,i.range.endOffset=n.end}this.editor._onAction("editValue",{path:this.getInternalPath(),oldValue:this.previousValue,newValue:this.value,oldSelection:e,newSelection:i}),this.previousValue=this.value}},{key:"_onChangeField",value:function(){var e=this.editor.getDomSelection(),t=this.previousField||"";if(e.range){var i=Object(H.textDiff)(this.field,t);e.range.startOffset=i.start,e.range.endOffset=i.end}var n=this.editor.getDomSelection();if(n.range){var r=Object(H.textDiff)(t,this.field);n.range.startOffset=r.start,n.range.endOffset=r.end}this.editor._onAction("editField",{parentPath:this.parent.getInternalPath(),index:this.getIndex(),oldValue:this.previousField,newValue:this.field,oldSelection:e,newSelection:n}),this.previousField=this.field}},{key:"_updateDomValue",value:function(){var e=this.dom.value;if(e){var t=["jsoneditor-value"],i=this.value,n="auto"===this.type?Object(H.getType)(i):this.type,r="string"===n&&Object(H.isUrl)(i);if(t.push("jsoneditor-"+n),r&&t.push("jsoneditor-url"),""===String(this.value)&&"array"!==this.type&&"object"!==this.type&&t.push("jsoneditor-empty"),this.searchValueActive&&t.push("jsoneditor-highlight-active"),this.searchValue&&t.push("jsoneditor-highlight"),e.className=t.join(" "),"array"===n||"object"===n){var o=this.childs?this.childs.length:0;e.title=this.type+" containing "+o+" items"}else r&&this.editable.value?e.title=Object(d.c)("openUrl"):e.title="";if("boolean"===n&&this.editable.value?(this.dom.checkbox||(this.dom.checkbox=document.createElement("input"),this.dom.checkbox.type="checkbox",this.dom.tdCheckbox=document.createElement("td"),this.dom.tdCheckbox.className="jsoneditor-tree",this.dom.tdCheckbox.appendChild(this.dom.checkbox),this.dom.tdValue.parentNode.insertBefore(this.dom.tdCheckbox,this.dom.tdValue)),this.dom.checkbox.checked=this.value):this.dom.tdCheckbox&&(this.dom.tdCheckbox.parentNode.removeChild(this.dom.tdCheckbox),delete this.dom.tdCheckbox,delete this.dom.checkbox),this.enum&&this.editable.value){if(!this.dom.select){this.dom.select=document.createElement("select"),this.id=this.field+"_"+(new Date).getUTCMilliseconds(),this.dom.select.id=this.id,this.dom.select.name=this.dom.select.id,this.dom.select.option=document.createElement("option"),this.dom.select.option.value="",this.dom.select.option.innerHTML="--",this.dom.select.appendChild(this.dom.select.option);for(var s=0;s<this.enum.length;s++)this.dom.select.option=document.createElement("option"),this.dom.select.option.value=this.enum[s],this.dom.select.option.innerHTML=this.enum[s],this.dom.select.option.value===this.value&&(this.dom.select.option.selected=!0),this.dom.select.appendChild(this.dom.select.option);this.dom.tdSelect=document.createElement("td"),this.dom.tdSelect.className="jsoneditor-tree",this.dom.tdSelect.appendChild(this.dom.select),this.dom.tdValue.parentNode.insertBefore(this.dom.tdSelect,this.dom.tdValue)}!this.schema||E(this.schema,"oneOf")||E(this.schema,"anyOf")||E(this.schema,"allOf")?delete this.valueFieldHTML:(this.valueFieldHTML=this.dom.tdValue.innerHTML,this.dom.tdValue.style.visibility="hidden",this.dom.tdValue.innerHTML="")}else this.dom.tdSelect&&(this.dom.tdSelect.parentNode.removeChild(this.dom.tdSelect),delete this.dom.tdSelect,delete this.dom.select,this.dom.tdValue.innerHTML=this.valueFieldHTML,this.dom.tdValue.style.visibility="",delete this.valueFieldHTML);this.editable.value&&this.editor.options.colorPicker&&"string"==typeof i&&Object(H.isValidColor)(i)?(this.dom.color||(this.dom.color=document.createElement("div"),this.dom.color.className="jsoneditor-color",this.dom.tdColor=document.createElement("td"),this.dom.tdColor.className="jsoneditor-tree",this.dom.tdColor.appendChild(this.dom.color),this.dom.tdValue.parentNode.insertBefore(this.dom.tdColor,this.dom.tdValue),this.dom.value.style.color="#1A1A1A"),this.dom.color.style.backgroundColor=i):this._deleteDomColor(),this.editor.options.timestampTag&&"number"==typeof i&&9466848e5<i&&!isNaN(new Date(i).valueOf())?(this.dom.date||(this.dom.date=document.createElement("div"),this.dom.date.className="jsoneditor-date",this.dom.value.parentNode.appendChild(this.dom.date)),this.dom.date.innerHTML=new Date(i).toISOString(),this.dom.date.title=new Date(i).toString()):this.dom.date&&(this.dom.date.parentNode.removeChild(this.dom.date),delete this.dom.date),Object(H.stripFormatting)(e),this._updateDomDefault()}}},{key:"_deleteDomColor",value:function(){this.dom.color&&(this.dom.tdColor.parentNode.removeChild(this.dom.tdColor),delete this.dom.tdColor,delete this.dom.color,this.dom.value.style.color="")}},{key:"_updateDomField",value:function(){var e=this.dom.field;if(e){var t=Object(H.makeFieldTooltip)(this.schema,this.editor.options.language);t&&(e.title=t),""===String(this.field)&&"array"!==this.parent.type?Object(H.addClassName)(e,"jsoneditor-empty"):Object(H.removeClassName)(e,"jsoneditor-empty"),this.searchFieldActive?Object(H.addClassName)(e,"jsoneditor-highlight-active"):Object(H.removeClassName)(e,"jsoneditor-highlight-active"),this.searchField?Object(H.addClassName)(e,"jsoneditor-highlight"):Object(H.removeClassName)(e,"jsoneditor-highlight"),Object(H.stripFormatting)(e)}}},{key:"_getDomField",value:function(e){if(this._clearFieldError(),this.dom.field&&this.fieldEditable&&(this.fieldInnerText=Object(H.getInnerText)(this.dom.field)),void 0!==this.fieldInnerText)try{var t=this._unescapeHTML(this.fieldInnerText),i=this.parent.getFieldNames(this);-1!==i.indexOf(t)?e?(t=Object(H.findUniqueName)(t,i))!==this.field&&(this.field=t,this._debouncedOnChangeField()):this._setFieldError(Object(d.c)("duplicateFieldError")):t!==this.field&&(this.field=t,this._debouncedOnChangeField())}catch(e){this._setFieldError(Object(d.c)("cannotParseFieldError"))}}},{key:"_updateDomDefault",value:function(){if(this.schema&&void 0!==this.schema.default&&!this._hasChilds()){var e=this.dom.select?this.dom.select:this.dom.value;e&&(this.value===this.schema.default?(e.title=Object(d.c)("default"),Object(H.addClassName)(e,"jsoneditor-is-default"),Object(H.removeClassName)(e,"jsoneditor-is-not-default")):(e.removeAttribute("title"),Object(H.removeClassName)(e,"jsoneditor-is-default"),Object(H.addClassName)(e,"jsoneditor-is-not-default")))}}},{key:"clearDom",value:function(){this.dom={}}},{key:"getDom",value:function(){var e=this.dom;if(e.tr)return e.tr;if(this._updateEditability(),e.tr=document.createElement("tr"),"tree"===(e.tr.node=this).editor.options.mode){var t=document.createElement("td");if(this.editable.field&&this.parent){var i=document.createElement("button");i.type="button",(e.drag=i).className="jsoneditor-button jsoneditor-dragarea",i.title=Object(d.c)("drag"),t.appendChild(i)}e.tr.appendChild(t);var n=document.createElement("td"),r=document.createElement("button");r.type="button",(e.menu=r).className="jsoneditor-button jsoneditor-contextmenu-button",r.title=Object(d.c)("actionsMenu"),n.appendChild(e.menu),e.tr.appendChild(n)}var o=document.createElement("td");return e.tr.appendChild(o),e.tree=this._createDomTree(),o.appendChild(e.tree),this.updateDom({updateIndexes:!0}),e.tr}},{key:"isVisible",value:function(){return this.dom&&this.dom.tr&&this.dom.tr.parentNode||!1}},{key:"isDescendantOf",value:function(e){for(var t=this.parent;t;){if(t===e)return!0;t=t.parent}return!1}},{key:"_createDomField",value:function(){return document.createElement("div")}},{key:"setHighlight",value:function(t){this.dom.tr&&(t?Object(H.addClassName)(this.dom.tr,"jsoneditor-highlight"):Object(H.removeClassName)(this.dom.tr,"jsoneditor-highlight"),this.append&&this.append.setHighlight(t),this.childs&&this.childs.forEach(function(e){e.setHighlight(t)}))}},{key:"setSelected",value:function(t,e){this.selected=t,this.dom.tr&&(t?Object(H.addClassName)(this.dom.tr,"jsoneditor-selected"):Object(H.removeClassName)(this.dom.tr,"jsoneditor-selected"),e?Object(H.addClassName)(this.dom.tr,"jsoneditor-first"):Object(H.removeClassName)(this.dom.tr,"jsoneditor-first"),this.append&&this.append.setSelected(t),this.showMore&&this.showMore.setSelected(t),this.childs&&this.childs.forEach(function(e){e.setSelected(t)}))}},{key:"updateValue",value:function(e){this.value=e,this.previousValue=e,this.valueError=void 0,this.updateDom()}},{key:"updateField",value:function(e){this.field=e,this.previousField=e,this.fieldError=void 0,this.updateDom()}},{key:"updateDom",value:function(t){var e=this.dom.tree;e&&(e.style.marginLeft=24*this.getLevel()+"px");var i=this.dom.field;if(i){var n;if(this.fieldEditable?(i.contentEditable=this.editable.field,i.spellcheck=!1,i.className="jsoneditor-field"):(i.contentEditable=!1,i.className="jsoneditor-readonly"),void 0!==this.index)n=this.index;else if(void 0!==this.field)n=this.field;else{var r=this.editor.options.schema?_._findSchema(this.editor.options.schema,this.editor.options.schemaRefs||{},this.getPath()):void 0;n=r&&r.title?r.title:this._hasChilds()?this.type:""}i.innerHTML=this._escapeHTML(n),this._updateSchema()}var o=this.dom.value;o&&("array"===this.type?(this.updateNodeName(),Object(H.addClassName)(this.dom.tr,"jsoneditor-expandable")):"object"===this.type?(this.updateNodeName(),Object(H.addClassName)(this.dom.tr,"jsoneditor-expandable")):(o.innerHTML=this._escapeHTML(this.value),Object(H.removeClassName)(this.dom.tr,"jsoneditor-expandable"))),this._updateDomField(),this._updateDomValue(),this._updateCssClassName(),t&&!0===t.updateIndexes&&this._updateDomIndexes(),t&&!0===t.recurse&&this.childs&&this.childs.forEach(function(e){e.updateDom(t)}),this.error&&this.updateError(),this.append&&this.append.updateDom(),this.showMore&&this.showMore.updateDom()}},{key:"_updateSchema",value:function(){this.editor&&this.editor.options&&(this.schema=this.editor.options.schema?_._findSchema(this.editor.options.schema,this.editor.options.schemaRefs||{},this.getPath()):null,this.schema?this.enum=_._findEnum(this.schema):delete this.enum)}},{key:"_updateDomIndexes",value:function(){var e=this.dom.value,t=this.childs;e&&t&&("array"===this.type?t.forEach(function(e,t){e.index=t;var i=e.dom.field;i&&(i.innerHTML=t)}):"object"===this.type&&t.forEach(function(e){void 0!==e.index&&(delete e.index,void 0===e.field&&(e.field=""))}))}},{key:"_createDomValue",value:function(){var e;return"array"===this.type?(e=document.createElement("div")).innerHTML="[...]":"object"===this.type?(e=document.createElement("div")).innerHTML="{...}":(!this.editable.value&&Object(H.isUrl)(this.value)?(e=document.createElement("a")).href=this.value:((e=document.createElement("div")).contentEditable=this.editable.value,e.spellcheck=!1),e.innerHTML=this._escapeHTML(this.value)),e}},{key:"_createDomExpandButton",value:function(){var e=document.createElement("button");return e.type="button",this._hasChilds()?(e.className=this.expanded?"jsoneditor-button jsoneditor-expanded":"jsoneditor-button jsoneditor-collapsed",e.title=Object(d.c)("expandTitle")):(e.className="jsoneditor-button jsoneditor-invisible",e.title=""),e}},{key:"_createDomTree",value:function(){var e=this.dom,t=document.createElement("table"),i=document.createElement("tbody");t.style.borderCollapse="collapse",t.className="jsoneditor-values",t.appendChild(i);var n=document.createElement("tr");i.appendChild(n);var r=document.createElement("td");r.className="jsoneditor-tree",n.appendChild(r),e.expand=this._createDomExpandButton(),r.appendChild(e.expand),e.tdExpand=r;var o=document.createElement("td");o.className="jsoneditor-tree",n.appendChild(o),e.field=this._createDomField(),o.appendChild(e.field),e.tdField=o;var s=document.createElement("td");s.className="jsoneditor-tree",n.appendChild(s),"object"!==this.type&&"array"!==this.type&&(s.appendChild(document.createTextNode(":")),s.className="jsoneditor-separator"),e.tdSeparator=s
;var a=document.createElement("td");return a.className="jsoneditor-tree",n.appendChild(a),e.value=this._createDomValue(),a.appendChild(e.value),e.tdValue=a,t}},{key:"onEvent",value:function(e){var t=e.type,i=e.target||e.srcElement,n=this.dom,r=this,o=this._hasChilds();if("function"==typeof this.editor.options.onEvent&&this._onEvent(e),i!==n.drag&&i!==n.menu||("mouseover"===t?this.editor.highlighter.highlight(this):"mouseout"===t&&this.editor.highlighter.unhighlight()),"click"===t&&i===n.menu){var s=r.editor.highlighter;s.highlight(r),s.lock(),Object(H.addClassName)(n.menu,"jsoneditor-selected"),this.showContextMenu(n.menu,function(){Object(H.removeClassName)(n.menu,"jsoneditor-selected"),s.unlock(),s.unhighlight()})}if("click"===t&&i===n.expand&&o){var a=e.ctrlKey;this._onExpand(a)}"click"!==t||e.target!==r.dom.tdColor&&e.target!==r.dom.color||this._showColorPicker(),"change"===t&&i===n.checkbox&&(this.dom.value.innerHTML=!this.value,this._getDomValue(),this._updateDomDefault()),"change"===t&&i===n.select&&(this.dom.value.innerHTML=n.select.value,this._getDomValue(),this._updateDomValue());var l=n.value;if(i===l)switch(t){case"blur":case"change":this._getDomValue(),this._clearValueError(),this._updateDomValue();var c=this._escapeHTML(this.value);l.innerHTML!==c&&(l.innerHTML=c);break;case"input":this._getDomValue(),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getDomSelection();break;case"click":e.ctrlKey&&this.editable.value&&Object(H.isUrl)(this.value)&&(e.preventDefault(),window.open(this.value,"_blank"));break;case"keyup":this._getDomValue(),this._updateDomValue();break;case"cut":case"paste":setTimeout(function(){r._getDomValue(),r._updateDomValue()},1)}var h=n.field;if(i===h)switch(t){case"blur":this._getDomField(!0),this._updateDomField();var d=this._escapeHTML(this.field);h.innerHTML!==d&&(h.innerHTML=d);break;case"input":this._getDomField(),this._updateSchema(),this._updateDomField(),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getDomSelection();break;case"keyup":this._getDomField(),this._updateDomField();break;case"cut":case"paste":setTimeout(function(){r._getDomField(),r._updateDomField()},1)}var u=n.tree;u&&i===u.parentNode&&"click"===t&&!e.hasMoved&&((void 0!==e.offsetX?e.offsetX<24*(this.getLevel()+1):e.pageX<Object(H.getAbsoluteLeft)(n.tdSeparator))||o?h&&(Object(H.setEndOfContentEditable)(h),h.focus()):l&&!this.enum&&(Object(H.setEndOfContentEditable)(l),l.focus()));(i!==n.tdExpand||o)&&i!==n.tdField&&i!==n.tdSeparator||"click"!==t||e.hasMoved||h&&(Object(H.setEndOfContentEditable)(h),h.focus()),"keydown"===t&&this.onKeyDown(e)}},{key:"_onEvent",value:function(e){var t=e.target;if(t===this.dom.field||t===this.dom.value){var i={field:this.getField(),path:this.getPath()};this._hasChilds()||t!==this.dom.value||(i.value=this.getValue()),this.editor.options.onEvent(i,e)}}},{key:"onKeyDown",value:function(e){var t,i,n,r,o,s,a,l,c,h,d,u,g,p=e.which||e.keyCode,m=e.target||e.srcElement,f=e.ctrlKey,C=e.shiftKey,I=e.altKey,A=!1,v="tree"===this.editor.options.mode,b=0<this.editor.multiselection.nodes.length?this.editor.multiselection.nodes:[this],y=b[0],w=b[b.length-1];if(13===p){if(m===this.dom.value)this.editable.value&&!e.ctrlKey||Object(H.isUrl)(this.value)&&(window.open(this.value,"_blank"),A=!0);else if(m===this.dom.expand){if(this._hasChilds()){var S=e.ctrlKey;this._onExpand(S),m.focus(),A=!0}}}else if(68===p)f&&v&&(_.onDuplicate(b),A=!0);else if(69===p)f&&(this._onExpand(C),m.focus(),A=!0);else if(77===p&&v)f&&(this.showContextMenu(m),A=!0);else if(46===p&&v)f&&(_.onRemove(b),A=!0);else if(45===p&&v)f&&!C?(this._onInsertBefore(),A=!0):f&&C&&(this._onInsertAfter(),A=!0);else if(35===p){if(I){var x=this._lastNode();x&&x.focus(_.focusElement||this._getElementName(m)),A=!0}}else if(36===p){if(I){var k=this._firstNode();k&&k.focus(_.focusElement||this._getElementName(m)),A=!0}}else if(37===p){if(I&&!C){var R=this._previousElement(m);R&&this.focus(this._getElementName(R)),A=!0}else if(I&&C&&v){if(w.expanded){var E=w.getAppendDom();n=E?E.nextSibling:void 0}else{var B=w.getDom();n=B.nextSibling}if(n){i=_.getNodeFromTarget(n),r=n.nextSibling;var G=_.getNodeFromTarget(r);i&&i instanceof $&&1!==w.parent.childs.length&&G&&G.parent&&(o=this.editor.getDomSelection(),s=(a=y.parent).childs[w.getIndex()+1]||a.append,l=y.getIndex(),c=G.getIndex(),h=a.getInternalPath(),d=G.parent.getInternalPath(),b.forEach(function(e){G.parent.moveBefore(e,G)}),this.focus(_.focusElement||this._getElementName(m)),this.editor._onAction("moveNodes",{count:b.length,fieldNames:b.map(L),oldParentPath:a.getInternalPath(),newParentPath:y.parent.getInternalPath(),oldIndex:s.getIndex(),newIndex:y.getIndex(),oldIndexRedo:l,newIndexRedo:c,oldParentPathRedo:h,newParentPathRedo:d,oldSelection:o,newSelection:this.editor.getDomSelection()}))}}}else if(38===p)I&&!C?((t=this._previousNode())&&(this.editor.deselect(!0),t.focus(_.focusElement||this._getElementName(m))),A=!0):!I&&f&&C&&v?((t=this._previousNode())&&((g=this.editor.multiselection).start=g.start||this,g.end=t,u=this.editor._findTopLevelNodes(g.start,g.end),this.editor.select(u),t.focus("field")),A=!0):I&&C&&v&&((t=y._previousNode())&&t.parent&&(o=this.editor.getDomSelection(),s=(a=y.parent).childs[w.getIndex()+1]||a.append,l=y.getIndex(),c=t.getIndex(),h=a.getInternalPath(),d=t.parent.getInternalPath(),b.forEach(function(e){t.parent.moveBefore(e,t)}),this.focus(_.focusElement||this._getElementName(m)),this.editor._onAction("moveNodes",{count:b.length,fieldNames:b.map(L),oldParentPath:a.getInternalPath(),newParentPath:y.parent.getInternalPath(),oldIndex:s.getIndex(),newIndex:y.getIndex(),oldIndexRedo:l,newIndexRedo:c,oldParentPathRedo:h,newParentPathRedo:d,oldSelection:o,newSelection:this.editor.getDomSelection()})),A=!0);else if(39===p){if(I&&!C){var Z=this._nextElement(m);Z&&this.focus(this._getElementName(Z)),A=!0}else if(I&&C&&v){var T=(B=y.getDom()).previousSibling;T&&(t=_.getNodeFromTarget(T))&&t.parent&&!t.isVisible()&&(o=this.editor.getDomSelection(),s=(a=y.parent).childs[w.getIndex()+1]||a.append,l=y.getIndex(),c=t.getIndex(),h=a.getInternalPath(),d=t.parent.getInternalPath(),b.forEach(function(e){t.parent.moveBefore(e,t)}),this.focus(_.focusElement||this._getElementName(m)),this.editor._onAction("moveNodes",{count:b.length,fieldNames:b.map(L),oldParentPath:a.getInternalPath(),newParentPath:y.parent.getInternalPath(),oldIndex:s.getIndex(),newIndex:y.getIndex(),oldIndexRedo:l,newIndexRedo:c,oldParentPathRedo:h,newParentPathRedo:d,oldSelection:o,newSelection:this.editor.getDomSelection()}))}}else if(40===p)if(I&&!C)(i=this._nextNode())&&(this.editor.deselect(!0),i.focus(_.focusElement||this._getElementName(m))),A=!0;else if(!I&&f&&C&&v)(i=this._nextNode())&&((g=this.editor.multiselection).start=g.start||this,g.end=i,u=this.editor._findTopLevelNodes(g.start,g.end),this.editor.select(u),i.focus("field")),A=!0;else if(I&&C&&v){(i=w.expanded?w.append?w.append._nextNode():void 0:w._nextNode())&&!i.isVisible()&&(i=i.parent.showMore),i&&i instanceof $&&(i=w);var W=i&&(i._nextNode()||i.parent.append);W&&W.parent&&(o=this.editor.getDomSelection(),s=(a=y.parent).childs[w.getIndex()+1]||a.append,l=y.getIndex(),c=W.getIndex(),h=a.getInternalPath(),d=W.parent.getInternalPath(),b.forEach(function(e){W.parent.moveBefore(e,W)}),this.focus(_.focusElement||this._getElementName(m)),this.editor._onAction("moveNodes",{count:b.length,fieldNames:b.map(L),oldParentPath:a.getInternalPath(),newParentPath:y.parent.getInternalPath(),oldParentPathRedo:h,newParentPathRedo:d,oldIndexRedo:l,newIndexRedo:c,oldIndex:s.getIndex(),newIndex:y.getIndex(),oldSelection:o,newSelection:this.editor.getDomSelection()})),A=!0}A&&(e.preventDefault(),e.stopPropagation())}},{key:"_onExpand",value:function(e){if(e){var t=this.dom.tr.parentNode,i=t.parentNode,n=i.scrollTop;i.removeChild(t)}this.expanded?this.collapse(e):this.expand(e),e&&(i.appendChild(t),i.scrollTop=n)}},{key:"_showColorPicker",value:function(){if("function"==typeof this.editor.options.onColorPicker&&this.dom.color){var t=this;t._deleteDomColor(),t.updateDom();var e=Object(A.a)(this.dom.color,this.editor.frame);this.editor.options.onColorPicker(e,this.value,function(e){"string"==typeof e&&e!==t.value&&(t._deleteDomColor(),t.value=e,t.updateDom(),t._debouncedOnChangeValue())})}}},{key:"getFieldNames",value:function(t){return"object"===this.type?this.childs.filter(function(e){return e!==t}).map(function(e){return e.field}):[]}},{key:"_onInsertBefore",value:function(e,t,i){var n=this.editor.getDomSelection(),r=new _(this.editor,{field:void 0!==e?e:"",value:void 0!==t?t:"",type:i});r.expand(!0);var o=this.getInternalPath();this.parent.insertBefore(r,this),this.editor.highlighter.unhighlight(),r.focus("field");var s=this.editor.getDomSelection();this.editor._onAction("insertBeforeNodes",{nodes:[r],paths:[r.getInternalPath()],beforePath:o,parentPath:this.parent.getInternalPath(),oldSelection:n,newSelection:s})}},{key:"_onInsertAfter",value:function(e,t,i){var n=this.editor.getDomSelection(),r=new _(this.editor,{field:void 0!==e?e:"",value:void 0!==t?t:"",type:i});r.expand(!0),this.parent.insertAfter(r,this),this.editor.highlighter.unhighlight(),r.focus("field");var o=this.editor.getDomSelection();this.editor._onAction("insertAfterNodes",{nodes:[r],paths:[r.getInternalPath()],afterPath:this.getInternalPath(),parentPath:this.parent.getInternalPath(),oldSelection:n,newSelection:o})}},{key:"_onAppend",value:function(e,t,i){var n=this.editor.getDomSelection(),r=new _(this.editor,{field:void 0!==e?e:"",value:void 0!==t?t:"",type:i});r.expand(!0),this.parent.appendChild(r),this.editor.highlighter.unhighlight(),r.focus("field");var o=this.editor.getDomSelection();this.editor._onAction("appendNodes",{nodes:[r],paths:[r.getInternalPath()],parentPath:this.parent.getInternalPath(),oldSelection:n,newSelection:o})}},{key:"_onChangeType",value:function(e){var t=this.type;if(e!==t){var i=this.editor.getDomSelection();this.changeType(e);var n=this.editor.getDomSelection();this.editor._onAction("changeType",{path:this.getInternalPath(),oldType:t,newType:e,oldSelection:i,newSelection:n})}}},{key:"sort",value:function(s,e){if("string"==typeof s&&(s=Object(H.parsePath)(s)),this._hasChilds()){this.hideChilds();var t=this.childs;this.childs=this.childs.concat();var a="desc"===e?-1:1;"object"===this.type?this.childs.sort(function(e,t){return a*I()(e.field,t.field)}):this.childs.sort(function(e,t){var i=e.getNestedChild(s),n=t.getNestedChild(s);if(!i)return a;if(!n)return-a;var r=i.value,o=n.value;return"string"!=typeof r&&"string"!=typeof o?o<r?a:r<o?-a:0:a*I()(r,o)}),this._updateDomIndexes(),this.editor._onAction("sort",{path:this.getInternalPath(),oldChilds:t,newChilds:this.childs}),this.showChilds()}}},{key:"update",value:function(e){var t=this.getInternalValue();this.setValue(e),this.editor._onAction("transform",{path:this.getInternalPath(),oldValue:t,newValue:this.getInternalValue()})}},{key:"_detachFromDom",value:function(){var e,t=this.dom.tr?this.dom.tr.parentNode:void 0,i=(e=this.expanded?this.getAppendDom():this.getDom())&&e.parentNode?e.nextSibling:void 0;return this.hide({resetVisibleChilds:!1}),{table:t,nextTr:i}}},{key:"_attachToDom",value:function(e){e.table&&(e.nextTr?e.table.insertBefore(this.getDom(),e.nextTr):e.table.appendChild(this.getDom())),this.expanded&&this.showChilds()}},{key:"transform",value:function(e){if(this._hasChilds()){this.hideChilds();try{var t=this.getInternalValue(),i=this.getValue(),n=f.a.search(i,e);this.setValue(n);var r=this.getInternalValue();this.editor._onAction("transform",{path:this.getInternalPath(),oldValue:t,newValue:r}),this.showChilds()}catch(e){this.showChilds(),this.editor._onError(e)}}}},{key:"extract",value:function(){this.editor.node.hideChilds(),this.hideChilds();try{var e=this.editor.node.getInternalValue();this.editor._setRoot(this);var t=this.editor.node.getInternalValue();this.editor._onAction("transform",{path:this.editor.node.getInternalPath(),oldValue:e,newValue:t})}catch(e){this.editor._onError(e)}finally{this.updateDom({recurse:!0}),this.showChilds()}}},{key:"getNestedChild",value:function(e){for(var t=0,i=this;i&&t<e.length;)i=i.findChildByProperty(e[t]),t++;return i}},{key:"findChildByProperty",value:function(t){if("object"===this.type)return this.childs.find(function(e){return e.field===t})}},{key:"getAppendDom",value:function(){return this.append||(this.append=new $(this.editor),this.append.setParent(this)),this.append.getDom()}},{key:"getShowMoreDom",value:function(){return this.showMore||(this.showMore=new Z(this.editor,this)),this.showMore.getDom()}},{key:"nextSibling",value:function(){var e=this.parent.childs.indexOf(this);return this.parent.childs[e+1]||this.parent.append}},{key:"_previousNode",value:function(){var e=null,t=this.getDom();if(t&&t.parentNode)for(var i=t;i=i.previousSibling,e=_.getNodeFromTarget(i),i&&e&&e instanceof $&&!e.isVisible(););return e}},{key:"_nextNode",value:function(){var e=null,t=this.getDom();if(t&&t.parentNode)for(var i=t;i=i.nextSibling,e=_.getNodeFromTarget(i),i&&e&&e instanceof $&&!e.isVisible(););return e}},{key:"_firstNode",value:function(){var e=null,t=this.getDom();if(t&&t.parentNode){var i=t.parentNode.firstChild;e=_.getNodeFromTarget(i)}return e}},{key:"_lastNode",value:function(){var e=null,t=this.getDom();if(t&&t.parentNode){var i=t.parentNode.lastChild;for(e=_.getNodeFromTarget(i);i&&e&&!e.isVisible();)i=i.previousSibling,e=_.getNodeFromTarget(i)}return e}},{key:"_previousElement",value:function(e){var t=this.dom;switch(e){case t.value:if(this.fieldEditable)return t.field;case t.field:if(this._hasChilds())return t.expand;case t.expand:return t.menu;case t.menu:if(t.drag)return t.drag;default:return null}}},{key:"_nextElement",value:function(e){var t=this.dom;switch(e){case t.drag:return t.menu;case t.menu:if(this._hasChilds())return t.expand;case t.expand:if(this.fieldEditable)return t.field;case t.field:if(!this._hasChilds())return t.value;default:return null}}},{key:"_getElementName",value:function(t){var i=this;return Object.keys(this.dom).find(function(e){return i.dom[e]===t})}},{key:"_hasChilds",value:function(){return"array"===this.type||"object"===this.type}},{key:"addTemplates",value:function(t,i){var n=this,e=n.editor.options.templates;if(null!=e){e.length&&t.push({type:"separator"});e.forEach(function(e){t.push({text:e.text,className:e.className||"jsoneditor-type-object",title:e.title,click:i?function(e,t){n._onAppend(e,t)}.bind(this,e.field,e.value):function(e,t){n._onInsertBefore(e,t)}.bind(this,e.field,e.value)})})}}},{key:"showContextMenu",value:function(e,t){var i=this,n=_.TYPE_TITLES,r=[];if(this.editable.value&&r.push({text:Object(d.c)("type"),title:Object(d.c)("typeTitle"),className:"jsoneditor-type-"+this.type,submenu:[{text:Object(d.c)("auto"),className:"jsoneditor-type-auto"+("auto"===this.type?" jsoneditor-selected":""),title:n.auto,click:function(){i._onChangeType("auto")}},{text:Object(d.c)("array"),className:"jsoneditor-type-array"+("array"===this.type?" jsoneditor-selected":""),title:n.array,click:function(){i._onChangeType("array")}},{text:Object(d.c)("object"),className:"jsoneditor-type-object"+("object"===this.type?" jsoneditor-selected":""),title:n.object,click:function(){i._onChangeType("object")}},{text:Object(d.c)("string"),className:"jsoneditor-type-string"+("string"===this.type?" jsoneditor-selected":""),title:n.string,click:function(){i._onChangeType("string")}}]}),this._hasChilds()&&(this.editor.options.enableSort&&r.push({text:Object(d.c)("sort"),title:Object(d.c)("sortTitle",{type:this.type}),className:"jsoneditor-sort-asc",click:function(){i.showSortModal()}}),this.editor.options.enableTransform&&r.push({text:Object(d.c)("transform"),title:Object(d.c)("transformTitle",{type:this.type}),className:"jsoneditor-transform",click:function(){i.showTransformModal()}}),this.parent&&r.push({text:Object(d.c)("extract"),title:Object(d.c)("extractTitle",{type:this.type}),className:"jsoneditor-extract",click:function(){i.extract()}})),this.parent&&this.parent._hasChilds()){r.length&&r.push({type:"separator"});var o=i.parent.childs;if(i===o[o.length-1]){var s=[{text:Object(d.c)("auto"),className:"jsoneditor-type-auto",title:n.auto,click:function(){i._onAppend("","","auto")}},{text:Object(d.c)("array"),className:"jsoneditor-type-array",title:n.array,click:function(){i._onAppend("",[])}},{text:Object(d.c)("object"),className:"jsoneditor-type-object",title:n.object,click:function(){i._onAppend("",{})}},{text:Object(d.c)("string"),className:"jsoneditor-type-string",title:n.string,click:function(){i._onAppend("","","string")}}];i.addTemplates(s,!0),r.push({text:Object(d.c)("appendText"),title:Object(d.c)("appendTitle"),submenuTitle:Object(d.c)("appendSubmenuTitle"),className:"jsoneditor-append",click:function(){i._onAppend("","","auto")},submenu:s})}var a=[{text:Object(d.c)("auto"),className:"jsoneditor-type-auto",title:n.auto,click:function(){i._onInsertBefore("","","auto")}},{text:Object(d.c)("array"),className:"jsoneditor-type-array",title:n.array,click:function(){i._onInsertBefore("",[])}},{text:Object(d.c)("object"),className:"jsoneditor-type-object",title:n.object,click:function(){i._onInsertBefore("",{})}},{text:Object(d.c)("string"),className:"jsoneditor-type-string",title:n.string,click:function(){i._onInsertBefore("","","string")}}];i.addTemplates(a,!1),r.push({text:Object(d.c)("insert"),title:Object(d.c)("insertTitle"),submenuTitle:Object(d.c)("insertSub"),className:"jsoneditor-insert",click:function(){i._onInsertBefore("","","auto")},submenu:a}),this.editable.field&&(r.push({text:Object(d.c)("duplicateText"),title:Object(d.c)("duplicateField"),className:"jsoneditor-duplicate",click:function(){_.onDuplicate(i)}}),r.push({text:Object(d.c)("removeText"),title:Object(d.c)("removeField"),className:"jsoneditor-remove",click:function(){_.onRemove(i)}}))}if(this.editor.options.onCreateMenu){var l=i.getPath();r=this.editor.options.onCreateMenu(r,{type:"single",path:l,paths:[l]})}new u.a(r,{close:t}).show(e,this.editor.frame)}},{key:"showSortModal",value:function(){var n=this,e=this.editor.options.modalAnchor||y.a,t=this.getValue();Object(v.a)(e,t,function(e){var t=e.path,i=Object(H.parsePath)(t);n.sortedBy=e,n.sort(i,e.direction)},n.sortedBy)}},{key:"showTransformModal",value:function(){var t=this,e=this.editor.options.modalAnchor||y.a,i=t.getValue();Object(b.a)(e,i,function(e){t.transform(e)})}},{key:"_getType",value:function(e){return e instanceof Array?"array":e instanceof Object?"object":"string"==typeof e&&"string"!=typeof Object(H.parseString)(e)?"string":"auto"}},{key:"_escapeHTML",value:function(e){if("string"!=typeof e)return String(e);var t=String(e).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/ {2}/g," &nbsp;").replace(/^ /,"&nbsp;").replace(/ $/,"&nbsp;"),i=JSON.stringify(t),n=i.substring(1,i.length-1);return!0===this.editor.options.escapeUnicode&&(n=Object(H.escapeUnicodeChars)(n)),n}},{key:"_unescapeHTML",value:function(e){var t='"'+this._escapeJSON(e)+'"';return Object(H.parse)(t).replace(/&lt;/g,"<").replace(/&gt;/g,">").replace(/&nbsp;|\u00A0/g," ").replace(/&amp;/g,"&")}},{key:"_escapeJSON",value:function(e){for(var t="",i=0;i<e.length;){var n=e.charAt(i);"\n"===n?t+="\\n":"\\"===n?(t+=n,i++,""!==(n=e.charAt(i))&&-1!=='"\\/bfnrtu'.indexOf(n)||(t+="\\"),t+=n):t+='"'===n?'\\"':n,i++}return t}},{key:"updateNodeName",value:function(){var e,t=this.childs?this.childs.length:0;if("object"===this.type||"array"===this.type){if(this.editor.options.onNodeName)try{e=this.editor.options.onNodeName({path:this.getPath(),size:t,type:this.type})}catch(e){console.error("Error in onNodeName callback: ",e)}this.dom.value.innerHTML="object"===this.type?"{"+(e||t)+"}":"["+(e||t)+"]"}}},{key:"recursivelyUpdateNodeName",value:function(){var e;if(this.expanded&&(this.updateNodeName(),"undefined"!==this.childs))for(e in this.childs)this.childs[e].recursivelyUpdateNodeName()}}]),_}();R.prototype.DEBOUNCE_INTERVAL=150,R.prototype.MAX_SEARCH_RESULTS=999;var x=100;function k(e){return e.getInternalPath()}function L(e){return e.getField()}function E(e,t){return Object.prototype.hasOwnProperty.call(e,t)}R.focusElement=void 0,R.select=function(e){setTimeout(function(){Object(H.selectContentEditable)(e)},0)},R.onDragStart=function(t,e){if(!Array.isArray(t))return R.onDragStart([t],e);if(0!==t.length){var i=t[0],n=t[t.length-1],r=i.parent,o=R.getNodeFromTarget(e.target),s=i.editor,a=Object(H.getAbsoluteTop)(o.dom.tr)-Object(H.getAbsoluteTop)(i.dom.tr);s.mousemove||(s.mousemove=Object(H.addEventListener)(window,"mousemove",function(e){R.onDrag(t,e)})),s.mouseup||(s.mouseup=Object(H.addEventListener)(window,"mouseup",function(e){R.onDragEnd(t,e)})),s.highlighter.lock(),s.drag={oldCursor:document.body.style.cursor,oldSelection:s.getDomSelection(),oldPaths:t.map(k),oldParent:r,oldNextNode:r.childs[n.getIndex()+1]||r.append,oldParentPathRedo:r.getInternalPath(),oldIndexRedo:i.getIndex(),mouseX:e.pageX,offsetY:a,level:i.getLevel()},document.body.style.cursor="move",e.preventDefault()}},R.onDrag=function(e,t){if(!Array.isArray(e))return R.onDrag([e],t);if(0!==e.length){var i,n,r,o,s,a,l,c,h,d,u,g=e[0].editor,p=t.pageY-g.drag.offsetY,m=t.pageX,f=!1,C=e[0],I=C.dom.tr,A=Object(H.getAbsoluteTop)(I),v=I.offsetHeight;if(p<A){for(i=I;i=i.previousSibling,a=R.getNodeFromTarget(i),c=i?Object(H.getAbsoluteTop)(i):0,i&&p<c;);a&&!a.parent&&(a=void 0),a||(i=(s=I.parentNode.firstChild)?s.nextSibling:void 0,(a=R.getNodeFromTarget(i))===C&&(a=void 0)),a&&a.isVisible()&&(c=(i=a.dom.tr)?Object(H.getAbsoluteTop)(i):0)+v<p&&(a=void 0),a&&(e.forEach(function(e){a.parent.moveBefore(e,a)}),f=!0)}else{var b=e[e.length-1];if(r=(o=b.expanded&&b.append?b.append.getDom():b.dom.tr)?o.nextSibling:void 0){for(h=Object(H.getAbsoluteTop)(r),n=r;l=R.getNodeFromTarget(n),n&&(d=n.nextSibling?Object(H.getAbsoluteTop)(n.nextSibling):0,u=n?d-h:0,l&&l.parent.childs.length===e.length&&l.parent.childs[e.length-1]===b&&(A+=27),n=n.nextSibling),n&&A+u<p;);if(l&&l.parent){var y=m-g.drag.mouseX,w=Math.round(y/24/2),S=g.drag.level+w,x=l.getLevel();for(i=l.dom.tr&&l.dom.tr.previousSibling;x<S&&i;){if(a=R.getNodeFromTarget(i),e.some(function(e){return e===a||a.isDescendantOf(e)}));else{if(!(a instanceof $))break;var k=a.parent.childs;if(k.length===e.length&&k[e.length-1]===b)break;x=(l=R.getNodeFromTarget(i)).getLevel()}i=i.previousSibling}l instanceof $&&!l.isVisible()&&l.parent.showMore.isVisible()&&(l=l._nextNode()),l&&l.dom.tr&&o.nextSibling!==l.dom.tr&&(e.forEach(function(e){l.parent.moveBefore(e,l)}),f=!0)}}}f&&(g.drag.mouseX=m,g.drag.level=C.getLevel()),g.startAutoScroll(p),t.preventDefault()}},R.onDragEnd=function(e,t){if(!Array.isArray(e))return R.onDrag([e],t);if(0!==e.length){var i=e[0],n=i.editor;e[0]&&e[0].dom.menu.focus();var r=n.drag.oldParent.getInternalPath(),o=i.parent.getInternalPath(),s=n.drag.oldParent===i.parent,a=n.drag.oldNextNode.getIndex(),l=i.getIndex(),c=n.drag.oldParentPathRedo,h=n.drag.oldIndexRedo,d=s&&h<l?l+e.length:l;s&&h===l||n._onAction("moveNodes",{count:e.length,fieldNames:e.map(L),oldParentPath:r,newParentPath:o,oldIndex:a,newIndex:l,oldIndexRedo:h,newIndexRedo:d,oldParentPathRedo:c,newParentPathRedo:null,oldSelection:n.drag.oldSelection,newSelection:n.getDomSelection()}),document.body.style.cursor=n.drag.oldCursor,n.highlighter.unlock(),e.forEach(function(e){e.updateDom(),t.target!==e.dom.drag&&t.target!==e.dom.menu&&n.highlighter.unhighlight()}),delete n.drag,n.mousemove&&(Object(H.removeEventListener)(window,"mousemove",n.mousemove),delete n.mousemove),n.mouseup&&(Object(H.removeEventListener)(window,"mouseup",n.mouseup),delete n.mouseup),n.stopAutoScroll(),t.preventDefault()}},R._findEnum=function(e){if(e.enum)return e.enum;var t=e.oneOf||e.anyOf||e.allOf;if(t){var i=t.filter(function(e){return e.enum});if(0<i.length)return i[0].enum}return null},R._findSchema=function(e,t,i){var n=e,r=n,o=e.oneOf||e.anyOf||e.allOf;o=o||[e];for(var s=0;s<o.length;s++){"$ref"in(n=o[s])&&"string"==typeof n.$ref&&(n=t[n.$ref])&&(r=R._findSchema(n,t,i));for(var a=0;a<i.length&&n;a++){var l=i.slice(a+1,i.length),c=i[a];if("string"!=typeof c||!n.patternProperties||n.properties&&c in n.properties)"string"==typeof c&&n.properties?c in n.properties?(n=n.properties[c])&&(r=R._findSchema(n,t,l)):r=null:"number"==typeof c&&n.items&&(n=n.items)&&(r=R._findSchema(n,t,l));else for(var h in n.patternProperties)c.match(h)&&(r=R._findSchema(n.patternProperties[h],t,l))}}return r===e&&0<i.length?null:r},R.onRemove=function(e){if(!Array.isArray(e))return R.onRemove([e]);if(e&&0<e.length){var t=e[0],i=t.parent,n=t.editor,r=t.getIndex();n.highlighter.unhighlight();var o=n.getDomSelection();R.blurNodes(e);var s=n.getDomSelection(),a=e.map(k);e.forEach(function(e){e.parent._remove(e)}),n._onAction("removeNodes",{nodes:e,paths:a,parentPath:i.getInternalPath(),index:r,oldSelection:o,newSelection:s})}},R.onDuplicate=function(e){if(!Array.isArray(e))return R.onDuplicate([e]);if(e&&0<e.length){var t=e[e.length-1],n=t.parent,i=t.editor;i.deselect(i.multiselection.nodes);var r=i.getDomSelection(),o=t,s=e.map(function(e){var t=e.clone();if("object"===e.parent.type){var i=e.parent.getFieldNames();t.field=Object(H.findUniqueName)(e.field,i)}return n.insertAfter(t,o),o=t});1===e.length?"object"===s[0].parent.type?(s[0].dom.field.innerHTML=e[0].field,s[0].focus("field")):s[0].focus():i.select(s);var a=i.getDomSelection();i._onAction("duplicateNodes",{paths:e.map(k),clonePaths:s.map(k),afterPath:t.getInternalPath(),parentPath:n.getInternalPath(),oldSelection:r,newSelection:a})}},R.getNodeFromTarget=function(e){for(;e;){if(e.node)return e.node;e=e.parentNode}},R.targetIsColorPicker=function(e){var t=R.getNodeFromTarget(e);if(t)for(var i=e&&e.parentNode;i;){if(i===t.dom.color)return!0;i=i.parentNode}return!1},R.blurNodes=function(e){if(Array.isArray(e)){var t=e[0],i=t.parent,n=t.getIndex();i.childs[n+e.length]?i.childs[n+e.length].focus():i.childs[n-1]?i.childs[n-1].focus():i.focus()}else R.blurNodes([e])},R.TYPE_TITLES={auto:Object(d.c)("autoType"),object:Object(d.c)("objectType"),array:Object(d.c)("arrayType"),string:Object(d.c)("stringType")};var B,$=((G.prototype=new(B=R)).getDom=function(){var e=this.dom;if(e.tr)return e.tr;this._updateEditability();var t=document.createElement("tr");if(t.className="jsoneditor-append",t.node=this,e.tr=t,"tree"===this.editor.options.mode){e.tdDrag=document.createElement("td");var i=document.createElement("td");e.tdMenu=i;var n=document.createElement("button");n.type="button",n.className="jsoneditor-button jsoneditor-contextmenu-button",n.title="Click to open the actions menu (Ctrl+M)",e.menu=n,i.appendChild(e.menu)}var r=document.createElement("td"),o=document.createElement("div");return o.innerHTML="("+Object(d.c)("empty")+")",o.className="jsoneditor-readonly",r.appendChild(o),e.td=r,e.text=o,this.updateDom(),t},G.prototype.getPath=function(){return null},G.prototype.getIndex=function(){return null},G.prototype.updateDom=function(e){var t=this.dom,i=t.td;i&&(i.style.paddingLeft=24*this.getLevel()+26+"px");var n=t.text;n&&(n.innerHTML="("+Object(d.c)("empty")+" "+this.parent.type+")");var r=t.tr;this.isVisible()?t.tr.firstChild||(t.tdDrag&&r.appendChild(t.tdDrag),t.tdMenu&&r.appendChild(t.tdMenu),r.appendChild(i)):t.tr.firstChild&&(t.tdDrag&&r.removeChild(t.tdDrag),t.tdMenu&&r.removeChild(t.tdMenu),r.removeChild(i))},G.prototype.isVisible=function(){return 0===this.parent.childs.length},G.prototype.showContextMenu=function(e,t){var i=this,n=B.TYPE_TITLES,r=[{text:Object(d.c)("auto"),className:"jsoneditor-type-auto",title:n.auto,click:function(){i._onAppend("","","auto")}},{text:Object(d.c)("array"),className:"jsoneditor-type-array",title:n.array,click:function(){i._onAppend("",[])}},{text:Object(d.c)("object"),className:"jsoneditor-type-object",title:n.object,click:function(){i._onAppend("",{})}},{text:Object(d.c)("string"),className:"jsoneditor-type-string",title:n.string,click:function(){i._onAppend("","","string")}}];i.addTemplates(r,!0);var o=[{text:Object(d.c)("appendText"),title:Object(d.c)("appendTitleAuto"),submenuTitle:Object(d.c)("appendSubmenuTitle"),className:"jsoneditor-insert",click:function(){i._onAppend("","","auto")},submenu:r}];if(this.editor.options.onCreateMenu){var s=i.parent.getPath();o=this.editor.options.onCreateMenu(o,{type:"append",path:s,paths:[s]})}new u.a(o,{close:t}).show(e,this.editor.frame)},G.prototype.onEvent=function(e){var t=e.type,i=e.target||e.srcElement,n=this.dom;if(i===n.menu&&("mouseover"===t?this.editor.highlighter.highlight(this.parent):"mouseout"===t&&this.editor.highlighter.unhighlight()),"click"===t&&i===n.menu){var r=this.editor.highlighter;r.highlight(this.parent),r.lock(),Object(H.addClassName)(n.menu,"jsoneditor-selected"),this.showContextMenu(n.menu,function(){Object(H.removeClassName)(n.menu,"jsoneditor-selected"),r.unlock(),r.unhighlight()})}"keydown"===t&&this.onKeyDown(e)},G);function G(e){this.editor=e,this.dom={}}var Z=((T.prototype=new R).getDom=function(){if(this.dom.tr)return this.dom.tr;if(this._updateEditability(),!this.dom.tr){var t=this,i=this.parent,e=document.createElement("a");e.appendChild(document.createTextNode(Object(d.c)("showMore"))),e.href="#",e.onclick=function(e){return i.visibleChilds=Math.floor(i.visibleChilds/i.getMaxVisibleChilds()+1)*i.getMaxVisibleChilds(),t.updateDom(),i.showChilds(),e.preventDefault(),!1};var n=document.createElement("a");n.appendChild(document.createTextNode(Object(d.c)("showAll"))),n.href="#",n.onclick=function(e){return i.visibleChilds=1/0,t.updateDom(),i.showChilds(),e.preventDefault(),!1};var r=document.createElement("div"),o=document.createTextNode(this._getShowMoreText());r.className="jsoneditor-show-more",r.appendChild(o),r.appendChild(e),r.appendChild(document.createTextNode(". ")),r.appendChild(n),r.appendChild(document.createTextNode(". "));var s=document.createElement("td");s.appendChild(r);var a=document.createElement("tr");"tree"===this.editor.options.mode&&(a.appendChild(document.createElement("td")),a.appendChild(document.createElement("td"))),a.appendChild(s),a.className="jsoneditor-show-more",this.dom.tr=a,this.dom.moreContents=r,this.dom.moreText=o}return this.updateDom(),this.dom.tr},T.prototype.updateDom=function(e){if(this.isVisible()){if(this.dom.tr.node=this.parent.childs[this.parent.visibleChilds],!this.dom.tr.parentNode){var t=this.parent._getNextTr();t&&t.parentNode.insertBefore(this.dom.tr,t)}this.dom.moreText.nodeValue=this._getShowMoreText(),this.dom.moreContents.style.marginLeft=24*(this.getLevel()+1)+"px"}else this.dom.tr&&this.dom.tr.parentNode&&this.dom.tr.parentNode.removeChild(this.dom.tr)},T.prototype._getShowMoreText=function(){return Object(d.c)("showMoreStatus",{visibleChilds:this.parent.visibleChilds,totalChilds:this.parent.childs.length})+" "},T.prototype.isVisible=function(){return this.parent.expanded&&this.parent.childs.length>this.parent.visibleChilds},T.prototype.onEvent=function(e){"keydown"===e.type&&this.onKeyDown(e)},T);function T(e,t){this.editor=e,this.parent=t,this.dom={}}var W=i(7),_={start:function(e,t){return 0===t.indexOf(e)},contain:function(e,t){return-1<t.indexOf(e)}};i.d(t,"treeModeMixins",function(){return N});var V={};V.create=function(e,t){if(!e)throw new Error("No container element provided.");this.container=e,this.dom={},this.highlighter=new s,this.selection=void 0,this.multiselection={nodes:[]},this.validateSchema=null,this.validationSequence=0,this.errorNodes=[],this.node=null,this.focusTarget=null,this._setOptions(t),t.autocomplete&&(this.autocomplete=function(l){(l=l||{}).filter=l.filter||"start",l.trigger=l.trigger||"keydown",l.confirmKeys=l.confirmKeys||[39,35,9],l.caseSensitive=l.caseSensitive||!1;var r="",o="",s=document.createElement("div");s.style.position="relative",s.style.outline="0",s.style.border="0",s.style.margin="0",s.style.padding="0";var t,c,h=document.createElement("div");function d(e){var t,i;document.createRange?((t=document.createRange()).selectNodeContents(e),t.collapse(!1),(i=window.getSelection()).removeAllRanges(),i.addRange(t)):document.selection&&((t=document.body.createTextRange()).moveToElementText(e),t.collapse(!1),t.select())}function a(e){return void 0===t&&((t=document.createElement("span")).style.visibility="hidden",t.style.position="fixed",t.style.outline="0",t.style.margin="0",t.style.padding="0",t.style.border="0",t.style.left="0",t.style.whiteSpace="pre",t.style.fontSize=r,t.style.fontFamily=o,t.style.fontWeight="normal",document.body.appendChild(t)),t.innerHTML=String(e).replace(/&/g,"&amp;").replace(/"/g,"&quot;").replace(/'/g,"&#39;").replace(/</g,"&lt;").replace(/>/g,"&gt;"),t.getBoundingClientRect().right}h.className="autocomplete dropdown",h.style.position="absolute",h.style.visibility="hidden";var u,g,p,i,m,f={onArrowDown:function(){},onArrowUp:function(){},onEnter:function(){},onTab:function(){},startFrom:0,options:[],element:null,elementHint:null,elementStyle:null,wrapper:s,show:function(e,t,i){var n=this;this.startFrom=t,this.wrapper.remove(),this.elementHint&&(this.elementHint.remove(),this.elementHint=null),""===r&&(r=window.getComputedStyle(e).getPropertyValue("font-size")),""===o&&(o=window.getComputedStyle(e).getPropertyValue("font-family")),h.style.marginLeft="0",h.style.marginTop=e.getBoundingClientRect().height+"px",this.options=i,this.element!==e&&(this.element=e,this.elementStyle={zIndex:this.element.style.zIndex,position:this.element.style.position,backgroundColor:this.element.style.backgroundColor,borderColor:this.element.style.borderColor}),this.element.style.zIndex=3,this.element.style.position="relative",this.element.style.backgroundColor="transparent",this.element.style.borderColor="transparent",this.elementHint=e.cloneNode(),this.elementHint.className="autocomplete hint",this.elementHint.style.zIndex=2,this.elementHint.style.position="absolute",this.elementHint.onfocus=function(){n.element.focus()},this.element.addEventListener&&(this.element.removeEventListener("keydown",b),this.element.addEventListener("keydown",b,!1),this.element.removeEventListener("blur",y),this.element.addEventListener("blur",y,!1)),s.appendChild(this.elementHint),s.appendChild(h),e.parentElement.appendChild(s),this.repaint(e)},setText:function(e){this.element.innerText=e},getText:function(){return this.element.innerText},hideDropDown:function(){this.wrapper.remove(),this.elementHint&&(this.elementHint.remove(),this.elementHint=null,C.hide(),this.element.style.zIndex=this.elementStyle.zIndex,this.element.style.position=this.elementStyle.position,this.element.style.backgroundColor=this.elementStyle.backgroundColor,this.element.style.borderColor=this.elementStyle.borderColor)},repaint:function(e){var t=e.innerText;t=t.replace("\n","");var i=this.options.length,n=t.substring(this.startFrom);c=t.substring(0,this.startFrom);for(var r=0;r<i;r++){var o=this.options[r];if(!l.caseSensitive&&0===o.toLowerCase().indexOf(n.toLowerCase())||l.caseSensitive&&0===o.indexOf(n)){this.elementHint.innerText=c+n+o.substring(n.length),this.elementHint.realInnerText=c+o;break}}h.style.left=a(c)+"px",C.refresh(n,this.options),this.elementHint.style.width=a(this.elementHint.innerText)+10+"px","hidden"===h.style.visibility||(this.elementHint.style.width=a(this.elementHint.innerText)+h.clientWidth+"px")}},C=(u=h,g=[],p=0,i=-1,m={rs:f,hide:function(){u.style.visibility="hidden"},refresh:function(i,e){u.style.visibility="hidden",p=0,u.innerHTML="";var t=window.innerHeight||document.documentElement.clientHeight,n=u.parentNode.getBoundingClientRect(),r=n.top-6,o=t-n.bottom-6;g=[];var s="function"==typeof l.filter?l.filter:_[l.filter],a=s?e.filter(function(e){return s(l.caseSensitive?i:i.toLowerCase(),l.caseSensitive?e:e.toLowerCase(),l)}):[];0!==(g=a.map(function(e){var t=document.createElement("div");return t.className="item",t.onmouseover=I,t.onmouseout=A,t.onmousedown=v,t.__hint=e,t.innerHTML=e.substring(0,i.length)+"<b>"+e.substring(i.length)+"</b>",u.appendChild(t),t})).length&&(1===g.length&&(i.toLowerCase()===g[0].__hint.toLowerCase()&&!l.caseSensitive||i===g[0].__hint&&l.caseSensitive)||g.length<2||(m.highlight(0),3*o<r?(u.style.maxHeight=r+"px",u.style.top="",u.style.bottom="100%"):(u.style.top="100%",u.style.bottom="",u.style.maxHeight=o+"px"),u.style.visibility="visible"))},highlight:function(e){-1!==i&&g[i]&&(g[i].className="item"),g[e].className="item hover",i=e},move:function(e){return"hidden"===u.style.visibility?"":(p+e===-1||p+e===g.length||(p+=e,m.highlight(p)),g[p].__hint)},onmouseselection:function(){}});function I(){this.style.backgroundColor="#ddd"}function A(){this.style.backgroundColor=""}function v(){m.hide(),m.onmouseselection(this.__hint,m.rs)}var b=function(e){var t=(e=e||window.event).keyCode;if(null!=this.elementHint&&33!==t&&34!==t){if(27===t)return f.hideDropDown(),f.element.focus(),e.preventDefault(),void e.stopPropagation();var i=this.element.innerText;if(i=i.replace("\n",""),0<=l.confirmKeys.indexOf(t))return 9===t&&0===this.elementHint.innerText.length&&f.onTab(),void(0<this.elementHint.innerText.length&&this.element.innerText!==this.elementHint.realInnerText&&(this.element.innerText=this.elementHint.realInnerText,f.hideDropDown(),d(this.element),9===t&&(f.element.focus(),e.preventDefault(),e.stopPropagation())));if(13!==t){if(40===t){var n=i.substring(this.startFrom),r=C.move(1);return""===r&&f.onArrowDown(),this.elementHint.innerText=c+n+r.substring(n.length),this.elementHint.realInnerText=c+r,e.preventDefault(),void e.stopPropagation()}if(38===t){var o=i.substring(this.startFrom),s=C.move(-1);""===s&&f.onArrowUp(),this.elementHint.innerText=c+o+s.substring(o.length),this.elementHint.realInnerText=c+s,e.preventDefault(),e.stopPropagation()}}else if(0===this.elementHint.innerText.length)f.onEnter();else{var a="hidden"===h.style.visibility;if(C.hide(),a)return f.hideDropDown(),f.element.focus(),void f.onEnter();this.element.innerText=this.elementHint.realInnerText,f.hideDropDown(),d(this.element),e.preventDefault(),e.stopPropagation()}}}.bind(f),y=function(){f.hideDropDown()};return C.onmouseselection=function(e,t){t.element.innerText=t.elementHint.innerText=c+e,t.hideDropDown(),window.setTimeout(function(){t.element.focus(),d(t.element)},1)},f}(t.autocomplete)),this.options.history&&"view"!==this.options.mode&&(this.history=new l(this)),this._createFrame(),this._createTable()},V.destroy=function(){this.frame&&this.container&&this.frame.parentNode===this.container&&(this.container.removeChild(this.frame),this.frame=null),this.container=null,this.dom=null,this.clear(),this.node=null,this.focusTarget=null,this.selection=null,this.multiselection=null,this.errorNodes=null,this.validateSchema=null,this._debouncedValidate=null,this.history&&(this.history.destroy(),this.history=null),this.searchBox&&(this.searchBox.destroy(),this.searchBox=null),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null)},V._setOptions=function(t){var i=this;this.options={search:!0,history:!0,mode:"tree",name:void 0,schema:null,schemaRefs:null,autocomplete:null,navigationBar:!0,mainMenuBar:!0,onSelectionChange:null,colorPicker:!0,onColorPicker:function(e,t,i){if(o.a){var n=e.getBoundingClientRect().top,r=window.innerHeight;new o.a({parent:e,color:t,popup:r-n<300&&300<n?"top":"bottom",onDone:function(e){var t=1===e.rgba[3]?e.hex.substr(0,7):e.hex;i(t)}}).show()}else console.warn("Cannot open color picker: the `vanilla-picker` library is not included in the bundle. Either use the full bundle or implement your own color picker using `onColorPicker`.")},timestampTag:!0,onEvent:null,enableSort:!0,enableTransform:!0},t&&Object.keys(t).forEach(function(e){i.options[e]=t[e]}),this.setSchema(this.options.schema,this.options.schemaRefs),this._debouncedValidate=Object(H.debounce)(this.validate.bind(this),this.DEBOUNCE_INTERVAL),t.onSelectionChange&&this.onSelectionChange(t.onSelectionChange),Object(d.b)(this.options.languages),Object(d.a)(this.options.language)},V.set=function(e){if(e instanceof Function||void 0===e)this.clear();else{this.content.removeChild(this.table);var t={field:this.options.name,value:e},i=new R(this,t);this._setRoot(i),this.validate();this.node.expand(!1),this.content.appendChild(this.table)}this.history&&this.history.clear(),this.searchBox&&this.searchBox.clear()},V.update=function(e){if(!this.node.deepEqual(e)){var t=this.getSelection();if(this.onChangeDisabled=!0,this.node.update(e),this.onChangeDisabled=!1,this.validate(),this.searchBox&&!this.searchBox.isEmpty()&&this.searchBox.forceSearch(),t&&t.start&&t.end){var i=this.node.findNodeByPath(t.start.path),n=this.node.findNodeByPath(t.end.path);i&&n?this.setSelection(t.start,t.end):this.setSelection({},{})}else this.setSelection({},{})}},V.get=function(){return this.node?this.node.getValue():void 0},V.getText=function(){return JSON.stringify(this.get())},V.setText=function(t){try{this.set(Object(H.parse)(t))}catch(e){var i=Object(H.repair)(t);this.set(Object(H.parse)(i))}},V.updateText=function(t){try{this.update(Object(H.parse)(t))}catch(e){var i=Object(H.repair)(t);this.update(Object(H.parse)(i))}},V.setName=function(e){this.options.name=e,this.node&&this.node.updateField(this.options.name)},V.getName=function(){return this.options.name},V.focus=function(){var e=this.scrollableContent.querySelector("[contenteditable=true]");e?e.focus():this.node.dom.expand?this.node.dom.expand.focus():this.node.dom.menu?this.node.dom.menu.focus():(e=this.frame.querySelector("button"))&&e.focus()},V.clear=function(){this.node&&(this.node.hide(),delete this.node),this.treePath&&this.treePath.reset()},V._setRoot=function(e){this.clear(),(this.node=e).setParent(null),e.setField(this.getName(),!1),delete e.index,this.tbody.appendChild(e.getDom())},V.search=function(e){var t;return this.node?(this.content.removeChild(this.table),t=this.node.search(e),this.content.appendChild(this.table)):t=[],t},V.expandAll=function(){this.node&&(this.content.removeChild(this.table),this.node.expand(),this.content.appendChild(this.table))},V.collapseAll=function(){this.node&&(this.content.removeChild(this.table),this.node.collapse(),this.content.appendChild(this.table))},V._onAction=function(e,t){this.history&&this.history.add(e,t),this._onChange()},V._onChange=function(){if(!this.onChangeDisabled){if(this.selection=this.getDomSelection(),this._debouncedValidate(),this.treePath){var e=this.node&&this.selection?this.node.findNodeByInternalPath(this.selection.path):this.multiselection?this.multiselection.nodes[0]:void 0;e?this._updateTreePath(e.getNodePath()):this.treePath.reset()}if(this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}if(this.options.onChangeJSON)try{this.options.onChangeJSON(this.get())}catch(e){console.error("Error in onChangeJSON callback: ",e)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(e){console.error("Error in onChangeText callback: ",e)}if(this.options.onClassName&&this.node.recursivelyUpdateCssClassesOnNodes(),this.options.onNodeName&&this.node.childs)try{this.node.recursivelyUpdateNodeName()}catch(e){console.error("Error in onNodeName callback: ",e)}}},V.validate=function(){var t=this.node;if(t){var e=t.getValue(),i=[];if(this.validateSchema)this.validateSchema(e)||(i=this.validateSchema.errors.map(function(e){return Object(H.improveSchemaError)(e)}).map(function(e){return{node:t.findNode(e.dataPath),error:e}}).filter(function(e){return null!=e.node}));try{this.validationSequence++;var n=this,r=this.validationSequence;this._validateCustom(e).then(function(e){if(r===n.validationSequence){var t=[].concat(i,e||[]);n._renderValidationErrors(t)}}).catch(function(e){console.error(e)})}catch(e){console.error(e)}}},V._renderValidationErrors=function(e){this.errorNodes&&this.errorNodes.forEach(function(e){e.setError(null)});var t=e.reduce(function(e,t){return t.node.findParents().filter(function(t){return!e.some(function(e){return e[0]===t})}).map(function(e){return[e,t.node]}).concat(e)},[]);this.errorNodes=t.map(function(e){return{node:e[0],child:e[1],error:{message:"object"===e[0].type?"Contains invalid properties":"Contains invalid items"}}}).concat(e).map(function(e){return e.node.setError(e.error,e.child),e.node})},V._validateCustom=function(e){try{if(this.options.onValidate){var i=this.node,t=this.options.onValidate(e);return(Object(H.isPromise)(t)?t:Promise.resolve(t)).then(function(e){return Array.isArray(e)?e.filter(function(e){var t=Object(H.isValidValidationError)(e);return t||console.warn('Ignoring a custom validation error with invalid structure. Expected structure: {path: [...], message: "..."}. Actual error:',e),t}).map(function(e){var t;try{t=e&&e.path?i.findNodeByPath(e.path):null}catch(e){}return t||console.warn("Ignoring validation error: node not found. Path:",e.path,"Error:",e),{node:t,error:e}}).filter(function(e){return e&&e.node&&e.error&&e.error.message}):null})}}catch(e){return Promise.reject(e)}return Promise.resolve(null)},V.refresh=function(){this.node&&this.node.updateDom({recurse:!0})},V.startAutoScroll=function(e){var t=this,i=this.scrollableContent,n=Object(H.getAbsoluteTop)(i),r=i.clientHeight,o=n+r;e<n+24&&0<i.scrollTop?this.autoScrollStep=(n+24-e)/3:o-24<e&&r+i.scrollTop<i.scrollHeight?this.autoScrollStep=(o-24-e)/3:this.autoScrollStep=void 0,this.autoScrollStep?this.autoScrollTimer||(this.autoScrollTimer=setInterval(function(){t.autoScrollStep?i.scrollTop-=t.autoScrollStep:t.stopAutoScroll()},50)):this.stopAutoScroll()},V.stopAutoScroll=function(){this.autoScrollTimer&&(clearTimeout(this.autoScrollTimer),delete this.autoScrollTimer),this.autoScrollStep&&delete this.autoScrollStep},V.setDomSelection=function(e){if(e)if("scrollTop"in e&&this.scrollableContent&&(this.scrollableContent.scrollTop=e.scrollTop),e.paths){var t=this,i=e.paths.map(function(e){return t.node.findNodeByInternalPath(e)});this.select(i)}else{var n=e.path?this.node.findNodeByInternalPath(e.path):null,r=n&&e.domName?n.dom[e.domName]:null;if(e.range&&r){var o=Object.assign({},e.range,{container:r});Object(H.setSelectionOffset)(o)}else n&&n.focus()}},V.getDomSelection=function(){var t=R.getNodeFromTarget(this.focusTarget),i=this.focusTarget,e=t?Object.keys(t.dom).find(function(e){return t.dom[e]===i}):null,n=Object(H.getSelectionOffset)();return n&&"DIV"!==n.container.nodeName&&(n=null),n&&n.container!==i&&(n=null),n&&delete n.container,{path:t?t.getInternalPath():null,domName:e,range:n,paths:0<this.multiselection.length?this.multiselection.nodes.map(function(e){return e.getInternalPath()}):null,scrollTop:this.scrollableContent?this.scrollableContent.scrollTop:0}},V.scrollTo=function(e,n){var r=this.scrollableContent;if(r){var o=this;o.animateTimeout&&(clearTimeout(o.animateTimeout),delete o.animateTimeout),o.animateCallback&&(o.animateCallback(!1),delete o.animateCallback);var t=r.clientHeight,i=r.scrollHeight-t,s=Math.min(Math.max(e-t/4,0),i);!function e(){var t=r.scrollTop,i=s-t;3<Math.abs(i)?(r.scrollTop+=i/3,o.animateCallback=n,o.animateTimeout=setTimeout(e,50)):(n&&n(!0),r.scrollTop=s,delete o.animateTimeout,delete o.animateCallback)}()}else n&&n(!1)},V._createFrame=function(){this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode,this.container.appendChild(this.frame),this.contentOuter=document.createElement("div"),this.contentOuter.className="jsoneditor-outer";var t=this;function i(e){t._onEvent&&t._onEvent(e)}if(this.frame.onclick=function(e){var t=e.target;i(e),"BUTTON"===t.nodeName&&e.preventDefault()},this.frame.oninput=i,this.frame.onchange=i,this.frame.onkeydown=i,this.frame.onkeyup=i,this.frame.oncut=i,this.frame.onpaste=i,this.frame.onmousedown=i,this.frame.onmouseup=i,this.frame.onmouseover=i,this.frame.onmouseout=i,Object(H.addEventListener)(this.frame,"focus",i,!0),Object(H.addEventListener)(this.frame,"blur",i,!0),this.frame.onfocusin=i,this.frame.onfocusout=i,this.options.mainMenuBar){Object(H.addClassName)(this.contentOuter,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu);var e=document.createElement("button");e.type="button",e.className="jsoneditor-expand-all",e.title=Object(d.c)("expandAll"),e.onclick=function(){t.expandAll()},this.menu.appendChild(e);var n=document.createElement("button");if(n.type="button",n.title=Object(d.c)("collapseAll"),n.className="jsoneditor-collapse-all",n.onclick=function(){t.collapseAll()},this.menu.appendChild(n),this.options.enableSort){var r=document.createElement("button");r.type="button",r.className="jsoneditor-sort",r.title=Object(d.c)("sortTitleShort"),r.onclick=function(){t.node.showSortModal()},this.menu.appendChild(r)}if(this.options.enableTransform){var o=document.createElement("button");o.type="button",o.title=Object(d.c)("transformTitleShort"),o.className="jsoneditor-transform",o.onclick=function(){t.node.showTransformModal()},this.menu.appendChild(o)}if(this.history){var s=document.createElement("button");s.type="button",s.className="jsoneditor-undo jsoneditor-separator",s.title=Object(d.c)("undo"),s.onclick=function(){t._onUndo()},this.menu.appendChild(s),this.dom.undo=s;var a=document.createElement("button");a.type="button",a.className="jsoneditor-redo",a.title=Object(d.c)("redo"),a.onclick=function(){t._onRedo()},this.menu.appendChild(a),this.dom.redo=a,this.history.onChange=function(){s.disabled=!t.history.canUndo(),a.disabled=!t.history.canRedo()},this.history.onChange()}if(this.options&&this.options.modes&&this.options.modes.length){var l=this;this.modeSwitcher=new W.a(this.menu,this.options.modes,this.options.mode,function(e){l.setMode(e),l.modeSwitcher.focus()})}this.options.search&&(this.searchBox=new h(this,this.menu))}this.options.navigationBar&&(this.navBar=document.createElement("div"),this.navBar.className="jsoneditor-navigation-bar nav-bar-empty",this.frame.appendChild(this.navBar),this.treePath=new p(this.navBar,this.frame),this.treePath.onSectionSelected(this._onTreePathSectionSelected.bind(this)),this.treePath.onContextMenuItemSelected(this._onTreePathMenuItemSelected.bind(this)))},V._onUndo=function(){this.history&&(this.history.undo(),this._onChange())},V._onRedo=function(){this.history&&(this.history.redo(),this._onChange())},V._onEvent=function(e){if(!R.targetIsColorPicker(e.target)){var t=R.getNodeFromTarget(e.target);if("keydown"===e.type&&this._onKeyDown(e),t&&"focus"===e.type&&(this.focusTarget=e.target,this.options.autocomplete&&"focus"===this.options.autocomplete.trigger&&this._showAutoComplete(e.target)),"mousedown"===e.type&&this._startDragDistance(e),"mousemove"!==e.type&&"mouseup"!==e.type&&"click"!==e.type||this._updateDragDistance(e),t&&this.options&&this.options.navigationBar&&t&&("keydown"===e.type||"mousedown"===e.type)){var i=this;setTimeout(function(){i._updateTreePath(t.getNodePath())})}if(t&&t.selected){if("click"===e.type){if(e.target===t.dom.menu)return void this.showContextMenu(e.target);e.hasMoved||this.deselect()}"mousedown"===e.type&&R.onDragStart(this.multiselection.nodes,e)}else"mousedown"===e.type&&Object(H.hasParentNode)(e.target,this.content)&&(this.deselect(),t&&e.target===t.dom.drag?R.onDragStart(t,e):t&&(e.target===t.dom.field||e.target===t.dom.value||e.target===t.dom.select)||this._onMultiSelectStart(e));t&&t.onEvent(e)}},V._updateTreePath=function(e){if(e&&e.length){Object(H.removeClassName)(this.navBar,"nav-bar-empty");var i=[];e.forEach(function(e){var t={name:n(e),node:e,children:[]};e.childs&&e.childs.length&&e.childs.forEach(function(e){t.children.push({name:n(e),node:e})}),i.push(t)}),this.treePath.setPath(i)}else Object(H.addClassName)(this.navBar,"nav-bar-empty");function n(e){return e.parent?"array"===e.parent.type?e.index:e.field:e.type}},V._onTreePathSectionSelected=function(e){e&&e.node&&(e.node.expandTo(),e.node.focus())},V._onTreePathMenuItemSelected=function(e,t){if(e&&e.children.length){var i=e.children.find(function(e){return e.name===t});i&&i.node&&(this._updateTreePath(i.node.getNodePath()),i.node.expandTo(),i.node.focus())}},V._startDragDistance=function(e){this.dragDistanceEvent={initialTarget:e.target,initialPageX:e.pageX,initialPageY:e.pageY,dragDistance:0,hasMoved:!1}},V._updateDragDistance=function(e){this.dragDistanceEvent||this._startDragDistance(e);var t=e.pageX-this.dragDistanceEvent.initialPageX,i=e.pageY-this.dragDistanceEvent.initialPageY;return this.dragDistanceEvent.dragDistance=Math.sqrt(t*t+i*i),this.dragDistanceEvent.hasMoved=this.dragDistanceEvent.hasMoved||10<this.dragDistanceEvent.dragDistance,e.dragDistance=this.dragDistanceEvent.dragDistance,e.hasMoved=this.dragDistanceEvent.hasMoved,e.dragDistance},V._onMultiSelectStart=function(e){var t=R.getNodeFromTarget(e.target);if("tree"===this.options.mode&&void 0===this.options.onEditable){this.multiselection={start:t||null,end:null,nodes:[]},this._startDragDistance(e);var i=this;this.mousemove||(this.mousemove=Object(H.addEventListener)(window,"mousemove",function(e){i._onMultiSelect(e)})),this.mouseup||(this.mouseup=Object(H.addEventListener)(window,"mouseup",function(e){i._onMultiSelectEnd(e)})),e.preventDefault()}},V._onMultiSelect=function(e){if(e.preventDefault(),this._updateDragDistance(e),e.hasMoved){var t=R.getNodeFromTarget(e.target);t&&(null==this.multiselection.start&&(this.multiselection.start=t),this.multiselection.end=t),this.deselect();var i=this.multiselection.start,n=this.multiselection.end||this.multiselection.start;if(i&&n){if(this.multiselection.nodes=this._findTopLevelNodes(i,n),this.multiselection.nodes&&this.multiselection.nodes.length){var r=this.multiselection.nodes[0];this.multiselection.start===r||this.multiselection.start.isDescendantOf(r)?this.multiselection.direction="down":this.multiselection.direction="up"}this.select(this.multiselection.nodes)}}},V._onMultiSelectEnd=function(){this.multiselection.nodes[0]&&this.multiselection.nodes[0].dom.menu.focus(),this.multiselection.start=null,this.multiselection.end=null,this.mousemove&&(Object(H.removeEventListener)(window,"mousemove",this.mousemove),delete this.mousemove),this.mouseup&&(Object(H.removeEventListener)(window,"mouseup",this.mouseup),delete this.mouseup)},V.deselect=function(e){var t=!!this.multiselection.nodes.length;this.multiselection.nodes.forEach(function(e){e.setSelected(!1)}),this.multiselection.nodes=[],e&&(this.multiselection.start=null,this.multiselection.end=null),t&&this._selectionChangedHandler&&this._selectionChangedHandler()},V.select=function(e){if(!Array.isArray(e))return this.select([e]);if(e){this.deselect(),this.multiselection.nodes=e.slice(0);var t=e[0];if(e.forEach(function(e){e.expandPathToNode(),e.setSelected(!0,e===t)}),this._selectionChangedHandler){var i=this.getSelection();this._selectionChangedHandler(i.start,i.end)}}},V._findTopLevelNodes=function(e,t){for(var i=e.getNodePath(),n=t.getNodePath(),r=0;r<i.length&&i[r]===n[r];)r++;var o=i[r-1],s=i[r],a=n[r];if(s&&a||(o.parent?o=(a=s=o).parent:(s=o.childs[0],a=o.childs[o.childs.length-1])),o&&s&&a){var l=o.childs.indexOf(s),c=o.childs.indexOf(a),h=Math.min(l,c),d=Math.max(l,c);return o.childs.slice(h,d+1)}return[]},V._showAutoComplete=function(t){var i=R.getNodeFromTarget(t),n="";0<=t.className.indexOf("jsoneditor-value")&&(n="value"),0<=t.className.indexOf("jsoneditor-field")&&(n="field");var r=this;setTimeout(function(){if(i&&("focus"===r.options.autocomplete.trigger||0<t.innerText.length)){var e=r.options.autocomplete.getOptions(t.innerText,i.getPath(),n,i.editor);null===e?r.autocomplete.hideDropDown():"function"==typeof e.then?e.then(function(e){null===e?r.autocomplete.hideDropDown():e.options?r.autocomplete.show(t,e.startFrom,e.options):r.autocomplete.show(t,0,e)}).catch(function(e){console.error(e)}):e.options?r.autocomplete.show(t,e.startFrom,e.options):r.autocomplete.show(t,0,e)}else r.autocomplete.hideDropDown()},50)},V._onKeyDown=function(e){var t=e.which||e.keyCode,i=e.altKey,n=e.ctrlKey,r=e.metaKey,o=e.shiftKey,s=!1;if(9===t){var a=this;setTimeout(function(){Object(H.selectContentEditable)(a.focusTarget)},0)}if(this.searchBox)if(n&&70===t)this.searchBox.dom.search.focus(),this.searchBox.dom.search.select(),s=!0;else if(114===t||n&&71===t){o?this.searchBox.previous(!0):this.searchBox.next(!0),s=!0}this.history&&(n&&!o&&90===t?(this._onUndo(),s=!0):n&&o&&90===t&&(this._onRedo(),s=!0)),this.options.autocomplete&&!s&&(n||i||r||1!==e.key.length&&8!==t&&46!==t||(s=!1,this._showAutoComplete(e.target))),s&&(e.preventDefault(),e.stopPropagation())},V._createTable=function(){var e;this.options.navigationBar&&Object(H.addClassName)(this.contentOuter,"has-nav-bar"),this.scrollableContent=document.createElement("div"),this.scrollableContent.className="jsoneditor-tree",this.contentOuter.appendChild(this.scrollableContent),this.content=document.createElement("div"),this.content.className="jsoneditor-tree-inner",this.scrollableContent.appendChild(this.content),this.table=document.createElement("table"),this.table.className="jsoneditor-tree",this.content.appendChild(this.table),this.colgroupContent=document.createElement("colgroup"),"tree"===this.options.mode&&((e=document.createElement("col")).width="24px",this.colgroupContent.appendChild(e)),(e=document.createElement("col")).width="24px",this.colgroupContent.appendChild(e),e=document.createElement("col"),this.colgroupContent.appendChild(e),this.table.appendChild(this.colgroupContent),this.tbody=document.createElement("tbody"),this.table.appendChild(this.tbody),this.frame.appendChild(this.contentOuter)},V.showContextMenu=function(e,t){var i=[],n=this.multiselection.nodes.slice();if(i.push({text:Object(d.c)("duplicateText"),title:Object(d.c)("duplicateTitle"),className:"jsoneditor-duplicate",click:function(){R.onDuplicate(n)}}),i.push({text:Object(d.c)("remove"),title:Object(d.c)("removeTitle"),className:"jsoneditor-remove",click:function(){R.onRemove(n)}}),this.options.onCreateMenu){var r=n.map(function(e){return e.getPath()});i=this.options.onCreateMenu(i,{type:"multiple",path:r[0],paths:r})}new u.a(i,{close:t}).show(e,this.frame)},V.getSelection=function(){var e={start:null,end:null};if(this.multiselection.nodes&&this.multiselection.nodes.length&&this.multiselection.nodes.length){var t=this.multiselection.nodes[0],i=this.multiselection.nodes[this.multiselection.nodes.length-1];"down"===this.multiselection.direction?(e.start=t.serialize(),e.end=i.serialize()):(e.start=i.serialize(),e.end=t.serialize())}return e},V.onSelectionChange=function(e){"function"==typeof e&&(this._selectionChangedHandler=Object(H.debounce)(e,this.DEBOUNCE_INTERVAL))},V.setSelection=function(e,t){e&&e.dom&&e.range&&(console.warn("setSelection/getSelection usage for text selection is deprecated and should not be used, see documentation for supported selection options"),this.setDomSelection(e));var i=this._getNodeInstancesByRange(e,t);i.forEach(function(e){e.expandTo()}),this.select(i)},V._getNodeInstancesByRange=function(e,t){var i,n;e&&e.path&&(i=this.node.findNodeByPath(e.path),t&&t.path&&(n=this.node.findNodeByPath(t.path)));var r=[];if(i instanceof R)if(n instanceof R&&n!==i)if(i.parent===n.parent){t=i.getIndex()<n.getIndex()?(e=i,n):(e=n,i);var o=e;for(r.push(o);o=o.nextSibling(),r.push(o),o&&o!==t;);}else r=this._findTopLevelNodes(i,n);else r.push(i);return r},V.getNodesByRange=function(e,t){var i=this._getNodeInstancesByRange(e,t),n=[];return i.forEach(function(e){n.push(e.serialize())}),n};var N=[{mode:"tree",mixin:V,data:"json"},{mode:"view",mixin:V,data:"json"},{mode:"form",mixin:V,data:"json"}]},function(e,t,i){"use strict";i.r(t);var n=i(4),r=i.n(n),d=i(1),u=i(7),g=i(14),o=i(6),s=i(8),a=i(20),p=i(2),m=i(0);function l(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var f=function(){function n(e,t,i){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,n),this.onChange=e,this.calculateItemSize=t||function(){return 1},this.limit=i,this.items=[],this.index=-1}return function(e,t,i){t&&l(e.prototype,t),i&&l(e,i)}(n,[{key:"add",value:function(e){for(;this._calculateHistorySize()>this.limit&&1<this.items.length;)this.items.shift(),this.index--;this.items=this.items.slice(0,this.index+1),this.items.push(e),this.index++,this.onChange()}},{key:"_calculateHistorySize",value:function(){var t=this.calculateItemSize,i=0;return this.items.forEach(function(e){i+=t(e)}),i}},{key:"undo",value:function(){if(this.canUndo())return this.index--,this.onChange(),this.items[this.index]}},{key:"redo",value:function(){if(this.canRedo())return this.index++,this.onChange(),this.items[this.index]}},{key:"canUndo",value:function(){return 0<this.index}},{key:"canRedo",value:function(){return this.index<this.items.length-1}},{key:"clear",value:function(){this.items=[],this.index=-1,this.onChange()}}]),n}();i.d(t,"previewModeMixins",function(){return C});var c=a.textModeMixins[0].mixin,h={create:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};void 0===t.statusBar&&(t.statusBar=!0),t.mainMenuBar=!1!==t.mainMenuBar,t.enableSort=!1!==t.enableSort,t.enableTransform=!1!==t.enableTransform,"number"==typeof(this.options=t).indentation?this.indentation=Number(t.indentation):this.indentation=2,this.mode="preview";var i=this;if(this.container=e,this.dom={},this.json=void 0,this.text="",this._debouncedValidate=Object(m.debounce)(this.validate.bind(this),this.DEBOUNCE_INTERVAL),this.width=e.clientWidth,this.height=e.clientHeight,this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-preview",this.frame.onclick=function(e){e.preventDefault()},this.content=document.createElement("div"),this.content.className="jsoneditor-outer",this.dom.busy=document.createElement("div"),this.dom.busy.className="jsoneditor-busy",this.dom.busyContent=document.createElement("span"),this.dom.busyContent.innerHTML="busy...",this.dom.busy.appendChild(this.dom.busyContent),this.content.appendChild(this.dom.busy),this.dom.previewContent=document.createElement("pre"),this.dom.previewContent.className="jsoneditor-preview",this.dom.previewText=document.createTextNode(""),this.dom.previewContent.appendChild(this.dom.previewText),this.content.appendChild(this.dom.previewContent),this.options.mainMenuBar){Object(m.addClassName)(this.content,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu);var n=document.createElement("button");n.type="button",n.className="jsoneditor-format",n.title="Format JSON data, with proper indentation and line feeds (Ctrl+\\)",this.menu.appendChild(n),n.onclick=function(){i.executeWithBusyMessage(function(){try{i.format()}catch(e){i._onError(e)}},"formatting...")};var r=document.createElement("button");if(r.type="button",r.className="jsoneditor-compact",r.title="Compact JSON data, remove all whitespaces (Ctrl+Shift+\\)",this.menu.appendChild(r),r.onclick=function(){i.executeWithBusyMessage(function(){try{i.compact()}catch(e){i._onError(e)}},"compacting...")},this.options.enableSort){var o=document.createElement("button");o.type="button",o.className="jsoneditor-sort",o.title=Object(d.c)("sortTitleShort"),o.onclick=function(){i._showSortModal()},this.menu.appendChild(o)}if(this.options.enableTransform){var s=document.createElement("button");s.type="button",s.title=Object(d.c)("transformTitleShort"),s.className="jsoneditor-transform",s.onclick=function(){i._showTransformModal()},this.dom.transform=s,this.menu.appendChild(s)}var a=document.createElement("button");if(a.type="button",a.className="jsoneditor-repair",a.title="Repair JSON: fix quotes and escape characters, remove comments and JSONP notation, turn JavaScript objects into JSON.",this.menu.appendChild(a),!(a.onclick=function(){
void 0===i.json&&i.executeWithBusyMessage(function(){try{i.repair()}catch(e){i._onError(e)}},"repairing...")})!==this.options.history){this.history=new f(function(){i.dom.undo.disabled=!i.history.canUndo(),i.dom.redo.disabled=!i.history.canRedo()},function(e){return 2*e.text.length},p.c);var l=document.createElement("button");l.type="button",l.className="jsoneditor-undo jsoneditor-separator",l.title=Object(d.c)("undo"),l.onclick=function(){var e=i.history.undo();e&&i._applyHistory(e)},this.menu.appendChild(l),this.dom.undo=l;var c=document.createElement("button");c.type="button",c.className="jsoneditor-redo",c.title=Object(d.c)("redo"),c.onclick=function(){var e=i.history.redo();e&&i._applyHistory(e)},this.menu.appendChild(c),this.dom.redo=c,this.history.onChange()}this.options&&this.options.modes&&this.options.modes.length&&(this.modeSwitcher=new u.a(this.menu,this.options.modes,this.options.mode,function(e){i.setMode(e),i.modeSwitcher.focus()}))}if(this.errorTable=new g.a({errorTableVisible:!0,onToggleVisibility:function(){i.validate()},onFocusLine:null,onChangeHeight:function(e){var t=e+(i.dom.statusBar?i.dom.statusBar.clientHeight:0)+1;i.content.style.marginBottom=-t+"px",i.content.style.paddingBottom=t+"px"}}),this.frame.appendChild(this.content),this.frame.appendChild(this.errorTable.getErrorTable()),this.container.appendChild(this.frame),t.statusBar){Object(m.addClassName)(this.content,"has-status-bar");var h=document.createElement("div");(this.dom.statusBar=h).className="jsoneditor-statusbar",this.frame.appendChild(h),this.dom.fileSizeInfo=document.createElement("span"),this.dom.fileSizeInfo.className="jsoneditor-size-info",this.dom.fileSizeInfo.innerText="",h.appendChild(this.dom.fileSizeInfo),this.dom.arrayInfo=document.createElement("span"),this.dom.arrayInfo.className="jsoneditor-size-info",this.dom.arrayInfo.innerText="",h.appendChild(this.dom.arrayInfo),h.appendChild(this.errorTable.getErrorCounter()),h.appendChild(this.errorTable.getWarningIcon()),h.appendChild(this.errorTable.getErrorIcon())}this._renderPreview(),this.setSchema(this.options.schema,this.options.schemaRefs)},_renderPreview:function(){var e=this.getText();this.dom.previewText.nodeValue=Object(m.limitCharacters)(e,p.b),this.dom.fileSizeInfo&&(this.dom.fileSizeInfo.innerText="Size: "+Object(m.formatSize)(e.length)),this.dom.arrayInfo&&(Array.isArray(this.json)?this.dom.arrayInfo.innerText="Array: "+this.json.length+" items":this.dom.arrayInfo.innerText="")},_onChange:function(){if(this._debouncedValidate(),this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}if(this.options.onChangeJSON)try{this.options.onChangeJSON(this.get())}catch(e){console.error("Error in onChangeJSON callback: ",e)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(e){console.error("Error in onChangeText callback: ",e)}}};h._showSortModal=function(){var r=this;this.executeWithBusyMessage(function(){var e=r.options.modalAnchor||p.a,t=r.get();r._renderPreview(),Object(o.a)(e,t,function(e){r.executeWithBusyMessage(function(){!function(e,t){if(Array.isArray(e)){var i=Object(m.sort)(e,t.path,t.direction);r.sortedBy=t,r._setAndFireOnChange(i)}if(Object(m.isObject)(e)){var n=Object(m.sortObjectKeys)(e,t.direction);r.sortedBy=t,r._setAndFireOnChange(n)}}(t,e)},"sorting...")},r.sortedBy)},"parsing...")},h._showTransformModal=function(){var n=this;this.executeWithBusyMessage(function(){var e=n.options.modalAnchor||p.a,i=n.get();n._renderPreview(),Object(s.a)(e,i,function(t){n.executeWithBusyMessage(function(){var e=r.a.search(i,t);n._setAndFireOnChange(e)},"transforming...")})},"parsing...")},h.destroy=function(){this.frame&&this.container&&this.frame.parentNode===this.container&&this.container.removeChild(this.frame),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this._debouncedValidate=null,this.history.clear(),this.history=null},h.compact=function(){var e=this.get(),t=JSON.stringify(e);this._setTextAndFireOnChange(t,e)},h.format=function(){var e=this.get(),t=JSON.stringify(e,null,this.indentation);this._setTextAndFireOnChange(t,e)},h.repair=function(){var e=this.getText(),t=Object(m.repair)(e);this._setTextAndFireOnChange(t)},h.focus=function(){this.dom.transform.focus()},h.set=function(e){this.history&&this.history.clear(),this._set(e)},h.update=function(e){this._set(e)},h._set=function(e){this.text=void 0,this.json=e,this._renderPreview(),this._pushHistory(),this._debouncedValidate()},h._setAndFireOnChange=function(e){this._set(e),this._onChange()},h.get=function(){if(void 0===this.json){var e=this.getText();this.json=Object(m.parse)(e)}return this.json},h.getText=function(){return void 0===this.text&&(this.text=JSON.stringify(this.json,null,this.indentation),!0===this.options.escapeUnicode&&(this.text=Object(m.escapeUnicodeChars)(this.text))),this.text},h.setText=function(e){this.history&&this.history.clear(),this._setText(e)},h.updateText=function(e){this.getText()!==e&&this._setText(e)},h._setText=function(e,t){if(!0===this.options.escapeUnicode?this.text=Object(m.escapeUnicodeChars)(e):this.text=e,this.json=t,this._renderPreview(),void 0===this.json){var i=this;this.executeWithBusyMessage(function(){try{i.json=i.get(),i._renderPreview(),i._pushHistory()}catch(e){}},"parsing...")}else this._pushHistory();this._debouncedValidate()},h._setTextAndFireOnChange=function(e,t){this._setText(e,t),this._onChange()},h._applyHistory=function(e){this.json=e.json,this.text=e.text,this._renderPreview(),this._debouncedValidate()},h._pushHistory=function(){if(this.history){var e={text:this.text,json:this.json};this.history.add(e)}},h.executeWithBusyMessage=function(e,t){if(this.getText().length>p.d){var i=this;Object(m.addClassName)(i.frame,"busy"),i.dom.busyContent.innerText=t,setTimeout(function(){e(),Object(m.removeClassName)(i.frame,"busy"),i.dom.busyContent.innerText=""},100)}else e()},h.validate=c.validate,h._renderErrors=c._renderErrors;var C=[{mode:"preview",mixin:h,data:"json"}]}],r.c=n,r.d=function(e,t,i){r.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:i})},r.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},r.t=function(t,e){if(1&e&&(t=r(t)),8&e)return t;if(4&e&&"object"==typeof t&&t&&t.__esModule)return t;var i=Object.create(null);if(r.r(i),Object.defineProperty(i,"default",{enumerable:!0,value:t}),2&e&&"string"!=typeof t)for(var n in t)r.d(i,n,function(e){return t[e]}.bind(null,n));return i},r.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return r.d(t,"a",t),t},r.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},r.p="",r(r.s=34);function r(e){if(n[e])return n[e].exports;var t=n[e]={i:e,l:!1,exports:{}};return i[e].call(t.exports,t,t.exports,r),t.l=!0,t.exports}var i,n});
//# sourceMappingURL=jsoneditor.map