'use strict';

var EOL = require('./eol');
var helper = require('./helper');

module.exports = function joinRows(rows, join) {
  if (!rows || !helper.isArray(rows)) {
    throw new TypeError('Invalid params "rows" for joinRows.' + ' Must be an array of string.');
  }
  //Merge all rows in a single output with the correct End of Line string
  var r = rows.join(join || EOL || '\n');
  return r;
};