#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = require("fs");
const ContextParser_1 = require("../lib/ContextParser");
const argv = process.argv.slice(2);
if (argv.length !== 2) {
    process.stderr.write(`jsonld-context-parse parses JSON-LD contexts

Usage:
  jsonld-context-parse url http://json-ld.org/contexts/person.jsonld
  jsonld-context-parse file path/to/context.jsonld
  jsonld-context-parse arg '{ "xsd": "http://www.w3.org/2001/XMLSchema#" }'
`);
    process.exit(1);
}
const type = argv[0];
let input;
let external = false;
let baseIRI;
switch (type) {
    case 'url':
        input = argv[1];
        external = true;
        baseIRI = argv[1];
        break;
    case 'file':
        input = JSON.parse((0, fs_1.readFileSync)(argv[1], 'utf8'));
        baseIRI = 'file://' + argv[1];
        break;
    case 'arg':
        input = JSON.parse(argv[1]);
        baseIRI = 'urn:local:';
        break;
    default:
        process.stderr.write(`Unknown context type. Choose from url, file or arg.`);
        process.exit(1);
        break;
}
new ContextParser_1.ContextParser().parse(input, { external, baseIRI })
    .then((context) => {
    process.stdout.write(JSON.stringify(context.getContextRaw(), null, '  '));
    process.stdout.write('\n');
})
    .catch((err) => {
    process.stderr.write(err.message);
    process.stdout.write('\n');
    process.exit(1);
});
//# sourceMappingURL=jsonld-context-parse.js.map