"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ERROR_CODES = exports.ErrorCoded = void 0;
/**
 * An error that has a certain error code.
 *
 * The error code can be any string.
 * All standardized error codes are listed in {@link ERROR_CODES}.
 */
class ErrorCoded extends Error {
    /* istanbul ignore next */
    constructor(message, code) {
        super(message);
        this.code = code;
    }
}
exports.ErrorCoded = ErrorCoded;
/**
 * All standardized JSON-LD error codes.
 * @see https://w3c.github.io/json-ld-api/#dom-jsonlderrorcode
 */
// tslint:disable:object-literal-sort-keys
var ERROR_CODES;
(function (ERROR_CODES) {
    ERROR_CODES["COLLIDING_KEYWORDS"] = "colliding keywords";
    ERROR_CODES["CONFLICTING_INDEXES"] = "conflicting indexes";
    ERROR_CODES["CYCLIC_IRI_MAPPING"] = "cyclic IRI mapping";
    ERROR_CODES["INVALID_ID_VALUE"] = "invalid @id value";
    ERROR_CODES["INVALID_INDEX_VALUE"] = "invalid @index value";
    ERROR_CODES["INVALID_NEST_VALUE"] = "invalid @nest value";
    ERROR_CODES["INVALID_PREFIX_VALUE"] = "invalid @prefix value";
    ERROR_CODES["INVALID_PROPAGATE_VALUE"] = "invalid @propagate value";
    ERROR_CODES["INVALID_REVERSE_VALUE"] = "invalid @reverse value";
    ERROR_CODES["INVALID_IMPORT_VALUE"] = "invalid @import value";
    ERROR_CODES["INVALID_VERSION_VALUE"] = "invalid @version value";
    ERROR_CODES["INVALID_BASE_IRI"] = "invalid base IRI";
    ERROR_CODES["INVALID_CONTAINER_MAPPING"] = "invalid container mapping";
    ERROR_CODES["INVALID_CONTEXT_ENTRY"] = "invalid context entry";
    ERROR_CODES["INVALID_CONTEXT_NULLIFICATION"] = "invalid context nullification";
    ERROR_CODES["INVALID_DEFAULT_LANGUAGE"] = "invalid default language";
    ERROR_CODES["INVALID_INCLUDED_VALUE"] = "invalid @included value";
    ERROR_CODES["INVALID_IRI_MAPPING"] = "invalid IRI mapping";
    ERROR_CODES["INVALID_JSON_LITERAL"] = "invalid JSON literal";
    ERROR_CODES["INVALID_KEYWORD_ALIAS"] = "invalid keyword alias";
    ERROR_CODES["INVALID_LANGUAGE_MAP_VALUE"] = "invalid language map value";
    ERROR_CODES["INVALID_LANGUAGE_MAPPING"] = "invalid language mapping";
    ERROR_CODES["INVALID_LANGUAGE_TAGGED_STRING"] = "invalid language-tagged string";
    ERROR_CODES["INVALID_LANGUAGE_TAGGED_VALUE"] = "invalid language-tagged value";
    ERROR_CODES["INVALID_LOCAL_CONTEXT"] = "invalid local context";
    ERROR_CODES["INVALID_REMOTE_CONTEXT"] = "invalid remote context";
    ERROR_CODES["INVALID_REVERSE_PROPERTY"] = "invalid reverse property";
    ERROR_CODES["INVALID_REVERSE_PROPERTY_MAP"] = "invalid reverse property map";
    ERROR_CODES["INVALID_REVERSE_PROPERTY_VALUE"] = "invalid reverse property value";
    ERROR_CODES["INVALID_SCOPED_CONTEXT"] = "invalid scoped context";
    ERROR_CODES["INVALID_SCRIPT_ELEMENT"] = "invalid script element";
    ERROR_CODES["INVALID_SET_OR_LIST_OBJECT"] = "invalid set or list object";
    ERROR_CODES["INVALID_TERM_DEFINITION"] = "invalid term definition";
    ERROR_CODES["INVALID_TYPE_MAPPING"] = "invalid type mapping";
    ERROR_CODES["INVALID_TYPE_VALUE"] = "invalid type value";
    ERROR_CODES["INVALID_TYPED_VALUE"] = "invalid typed value";
    ERROR_CODES["INVALID_VALUE_OBJECT"] = "invalid value object";
    ERROR_CODES["INVALID_VALUE_OBJECT_VALUE"] = "invalid value object value";
    ERROR_CODES["INVALID_VOCAB_MAPPING"] = "invalid vocab mapping";
    ERROR_CODES["IRI_CONFUSED_WITH_PREFIX"] = "IRI confused with prefix";
    ERROR_CODES["KEYWORD_REDEFINITION"] = "keyword redefinition";
    ERROR_CODES["LOADING_DOCUMENT_FAILED"] = "loading document failed";
    ERROR_CODES["LOADING_REMOTE_CONTEXT_FAILED"] = "loading remote context failed";
    ERROR_CODES["MULTIPLE_CONTEXT_LINK_HEADERS"] = "multiple context link headers";
    ERROR_CODES["PROCESSING_MODE_CONFLICT"] = "processing mode conflict";
    ERROR_CODES["PROTECTED_TERM_REDEFINITION"] = "protected term redefinition";
    ERROR_CODES["CONTEXT_OVERFLOW"] = "context overflow";
    ERROR_CODES["INVALID_BASE_DIRECTION"] = "invalid base direction";
    ERROR_CODES["RECURSIVE_CONTEXT_INCLUSION"] = "recursive context inclusion";
    ERROR_CODES["INVALID_STREAMING_KEY_ORDER"] = "invalid streaming key order";
})(ERROR_CODES = exports.ERROR_CODES || (exports.ERROR_CODES = {}));
//# sourceMappingURL=ErrorCoded.js.map