"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * A tree structure that holds all contexts,
 * based on their position in the JSON object.
 *
 * Positions are identified by a path of keys.
 */
class ContextTree {
    constructor() {
        this.subTrees = {};
    }
    getContext([head, ...tail]) {
        if (!head && !tail.length) {
            return this.context;
        }
        else {
            const subTree = this.subTrees[head];
            return (subTree && subTree.getContext(tail)) || this.context;
        }
    }
    setContext([head, ...tail], context) {
        if (!head && !tail.length) {
            this.context = context;
        }
        else {
            let subTree = this.subTrees[head];
            if (!subTree) {
                subTree = this.subTrees[head] = new ContextTree();
            }
            subTree.setContext(tail, context);
        }
    }
}
exports.ContextTree = ContextTree;
//# sourceMappingURL=ContextTree.js.map