"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Container handler for @language.
 *
 * It assumes that the current key is the language of the current value.
 * This will add this value to the parent node.
 */
class ContainerHandlerLanguage {
    async handle(parsingContext, keys, value, depth) {
        if (Array.isArray(value)) {
            value = value.map((subValue) => ({ '@value': subValue, '@language': keys[depth] }));
        }
        else {
            value = { '@value': value, '@language': keys[depth] };
        }
        await parsingContext.newOnValueJob(keys, value, depth - 1);
    }
}
exports.ContainerHandlerLanguage = ContainerHandlerLanguage;
//# sourceMappingURL=ContainerHandlerLanguage.js.map