import { IContainerHandler } from "../containerhandler/IContainerHandler";
import { ParsingContext } from "../ParsingContext";
import { Util } from "../Util";
import { IEntryHandler } from "./IEntryHandler";
/**
 * Handles values that are part of a container type (like @index),
 * as specified by {@link IContainerHandler}.
 */
export declare class EntryHandlerContainer implements IEntryHandler<IContainerHandler> {
    static readonly CONTAINER_HANDLERS: {
        [id: string]: IContainerHandler;
    };
    isPropertyHandler(): boolean;
    validate(parsingContext: ParsingContext, util: Util, keys: any[], depth: number, inProperty: boolean): Promise<boolean>;
    test(parsingContext: ParsingContext, util: Util, key: any, keys: any[], depth: number): Promise<IContainerHandler>;
    handle(parsingContext: ParsingContext, util: Util, key: any, keys: any[], value: any, depth: number, testResult: IContainerHandler): Promise<any>;
}
