"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ContainerHandlerIndex_1 = require("../containerhandler/ContainerHandlerIndex");
const ContainerHandlerLanguage_1 = require("../containerhandler/ContainerHandlerLanguage");
const Util_1 = require("../Util");
/**
 * Handles values that are part of a container type (like @index),
 * as specified by {@link IContainerHandler}.
 */
class EntryHandlerContainer {
    isPropertyHandler() {
        return false;
    }
    async validate(parsingContext, util, keys, depth, inProperty) {
        return !!await this.test(parsingContext, util, null, keys, depth);
    }
    async test(parsingContext, util, key, keys, depth) {
        return EntryHandlerContainer.CONTAINER_HANDLERS[Util_1.Util.getContextValueContainer(await parsingContext.getContext(keys), keys[depth - 1])];
    }
    async handle(parsingContext, util, key, keys, value, depth, testResult) {
        parsingContext.emittedStack[depth] = false; // We will emit a level higher
        return testResult.handle(parsingContext, keys, value, depth);
    }
}
EntryHandlerContainer.CONTAINER_HANDLERS = {
    '@index': new ContainerHandlerIndex_1.ContainerHandlerIndex(),
    '@language': new ContainerHandlerLanguage_1.ContainerHandlerLanguage(),
};
exports.EntryHandlerContainer = EntryHandlerContainer;
//# sourceMappingURL=EntryHandlerContainer.js.map