import * as RDF from "rdf-js";
import { ParsingContext } from "../ParsingContext";
import { Util } from "../Util";
import { IEntryHandler } from "./IEntryHandler";
/**
 * Interprets keys as predicates.
 * The most common case in JSON-LD processing.
 */
export declare class EntryHandlerPredicate implements IEntryHandler<boolean> {
    /**
     * Handle the given predicate-object by either emitting it,
     * or by placing it in the appropriate stack for later emission when no @graph and/or @id has been defined.
     * @param {ParsingContext} parsingContext A parsing context.
     * @param {Util} util A utility instance.
     * @param {any[]} keys A stack of keys.
     * @param {number} depth The current depth.
     * @param parentKey The parent key.
     * @param {Term} predicate The predicate.
     * @param {Term} object The object.
     * @param {boolean} reverse If the property is reversed.
     * @return {Promise<void>} A promise resolving when handling is done.
     */
    static handlePredicateObject(parsingContext: ParsingContext, util: Util, keys: any[], depth: number, parentKey: any, predicate: RDF.Term, object: RDF.Term, reverse: boolean): Promise<void>;
    isPropertyHandler(): boolean;
    validate(parsingContext: ParsingContext, util: Util, keys: any[], depth: number, inProperty: boolean): Promise<boolean>;
    test(parsingContext: ParsingContext, util: Util, key: any, keys: any[], depth: number): Promise<boolean>;
    handle(parsingContext: ParsingContext, util: Util, key: any, keys: any[], value: any, depth: number, testResult: boolean): Promise<any>;
}
