import { ParsingContext } from "../../ParsingContext";
import { Util } from "../../Util";
import { IEntryHandler } from "../IEntryHandler";
/**
 * An abstract keyword entry handler.
 */
export declare abstract class EntryHandlerKeyword implements IEntryHandler<boolean> {
    private readonly keyword;
    protected constructor(keyword: string);
    isPropertyHandler(): boolean;
    validate(parsingContext: ParsingContext, util: Util, keys: any[], depth: number, inProperty: boolean): Promise<boolean>;
    test(parsingContext: ParsingContext, util: Util, key: any, keys: any[], depth: number): Promise<boolean>;
    abstract handle(parsingContext: ParsingContext, util: Util, key: any, keys: any[], value: any, depth: number, testResult: boolean): Promise<any>;
}
