"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const EntryHandlerKeyword_1 = require("./EntryHandlerKeyword");
/**
 * Handles @context entries.
 */
class EntryHandlerKeywordContext extends EntryHandlerKeyword_1.EntryHandlerKeyword {
    constructor() {
        super('@context');
    }
    async handle(parsingContext, util, key, keys, value, depth) {
        // Error if an out-of-order context was found when support is not enabled.
        if (!parsingContext.allowOutOfOrderContext && parsingContext.processingStack[depth]) {
            parsingContext.emitError(new Error('Found an out-of-order context, while support is not enabled.' +
                '(enable with `allowOutOfOrderContext`)'));
        }
        // Find the parent context to inherit from
        const parentContext = parsingContext.getContext(keys.slice(0, -1));
        // Set the context for this scope
        const context = parsingContext.contextParser.parse(value, { baseIri: parsingContext.baseIRI, parentContext: await parentContext });
        parsingContext.contextTree.setContext(keys.slice(0, -1), context);
        parsingContext.emitContext(value);
        await parsingContext.validateContext(await context);
    }
}
exports.EntryHandlerKeywordContext = EntryHandlerKeywordContext;
//# sourceMappingURL=EntryHandlerKeywordContext.js.map