"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const EntryHandlerKeyword_1 = require("./EntryHandlerKeyword");
/**
 * Handles @id entries.
 */
class EntryHandlerKeywordId extends EntryHandlerKeyword_1.EntryHandlerKeyword {
    constructor() {
        super('@id');
    }
    async handle(parsingContext, util, key, keys, value, depth) {
        // Error if an @id for this node already existed.
        if (parsingContext.idStack[depth] !== undefined) {
            parsingContext.emitError(new Error(`Found duplicate @ids '${parsingContext
                .idStack[depth].value}' and '${value}'`));
        }
        // Save our @id on the stack
        parsingContext.idStack[depth] = await util.resourceToTerm(await parsingContext.getContext(keys), value);
    }
}
exports.EntryHandlerKeywordId = EntryHandlerKeywordId;
//# sourceMappingURL=EntryHandlerKeywordId.js.map