"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Util_1 = require("../../Util");
const EntryHandlerKeyword_1 = require("./EntryHandlerKeyword");
const EntryHandlerPredicate_1 = require("../EntryHandlerPredicate");
/**
 * Handles @graph entries.
 */
class EntryHandlerKeywordType extends EntryHandlerKeyword_1.EntryHandlerKeyword {
    constructor() {
        super('@type');
    }
    async handle(parsingContext, util, key, keys, value, depth) {
        const keyOriginal = keys[depth];
        const parentKey = await util.unaliasKeywordParent(keys, depth);
        // The current identifier identifies an rdf:type predicate.
        // But we only emit it once the node closes,
        // as it's possible that the @type is used to identify the datatype of a literal, which we ignore here.
        const context = await parsingContext.getContext(keys);
        const predicate = util.rdfType;
        const reverse = Util_1.Util.isPropertyReverse(context, keyOriginal, parentKey);
        // Handle multiple values if the value is an array
        if (Array.isArray(value)) {
            for (const element of value) {
                const type = util.createVocabOrBaseTerm(context, element);
                if (type) {
                    await EntryHandlerPredicate_1.EntryHandlerPredicate.handlePredicateObject(parsingContext, util, keys, depth, parentKey, predicate, type, reverse);
                }
            }
        }
        else {
            const type = util.createVocabOrBaseTerm(context, value);
            if (type) {
                await EntryHandlerPredicate_1.EntryHandlerPredicate.handlePredicateObject(parsingContext, util, keys, depth, parentKey, predicate, type, reverse);
            }
        }
    }
}
exports.EntryHandlerKeywordType = EntryHandlerKeywordType;
//# sourceMappingURL=EntryHandlerKeywordType.js.map