import { ParsingContext } from "../../ParsingContext";
import { Util } from "../../Util";
import { IEntryHandler } from "../IEntryHandler";
/**
 * A catch-all for keywords, that will either emit an error or ignore,
 * depending on whether or not the `errorOnInvalidIris` property is set.
 */
export declare class EntryHandlerKeywordUnknownFallback implements IEntryHandler<boolean> {
    private static readonly VALID_KEYWORDS_TYPES;
    isPropertyHandler(): boolean;
    validate(parsingContext: ParsingContext, util: Util, keys: any[], depth: number, inProperty: boolean): Promise<boolean>;
    test(parsingContext: ParsingContext, util: Util, key: any, keys: any[], depth: number): Promise<boolean>;
    handle(parsingContext: ParsingContext, util: Util, key: any, keys: any[], value: any, depth: number): Promise<any>;
}
