"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Util_1 = require("../../Util");
/**
 * A catch-all for keywords, that will either emit an error or ignore,
 * depending on whether or not the `errorOnInvalidIris` property is set.
 */
class EntryHandlerKeywordUnknownFallback {
    isPropertyHandler() {
        return false;
    }
    async validate(parsingContext, util, keys, depth, inProperty) {
        const key = await util.unaliasKeyword(keys[depth], keys, depth);
        if (Util_1.Util.isKeyword(key)) {
            // Don't emit anything inside free-floating lists
            if (!inProperty) {
                if (key === '@list') {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
    async test(parsingContext, util, key, keys, depth) {
        return Util_1.Util.isKeyword(key);
    }
    async handle(parsingContext, util, key, keys, value, depth) {
        const keywordType = EntryHandlerKeywordUnknownFallback.VALID_KEYWORDS_TYPES[key];
        if (keywordType !== undefined) {
            if (keywordType && typeof value !== keywordType) {
                parsingContext.emitError(new Error(`Invalid value type for '${key}' with value '${value}'`));
            }
        }
        else if (parsingContext.errorOnInvalidProperties) {
            parsingContext.emitError(new Error(`Unknown keyword '${key}' with value '${value}'`));
        }
        parsingContext.emittedStack[depth] = false;
    }
}
EntryHandlerKeywordUnknownFallback.VALID_KEYWORDS_TYPES = {
    '@index': 'string',
    '@list': null,
    '@reverse': 'object',
    '@set': null,
    '@value': null,
};
exports.EntryHandlerKeywordUnknownFallback = EntryHandlerKeywordUnknownFallback;
//# sourceMappingURL=EntryHandlerKeywordUnknownFallback.js.map