"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const EntryHandlerKeyword_1 = require("./EntryHandlerKeyword");
/**
 * Handles @value entries.
 */
class EntryHandlerKeywordValue extends EntryHandlerKeyword_1.EntryHandlerKeyword {
    constructor() {
        super('@value');
    }
    async handle(parsingContext, util, key, keys, value, depth) {
        // If the value is valid, indicate that we are processing a literal.
        // The actual value will be determined at the parent level when the @value is part of an object,
        // because we may want to take into account additional entries such as @language.
        // See {@link Util.valueToTerm}
        // Indicate that we are processing a literal, and that no later predicates should be parsed at this depth.
        parsingContext.literalStack[depth] = true;
        // Void any buffers that we may have accumulated up until now
        delete parsingContext.unidentifiedValuesBuffer[depth];
        delete parsingContext.unidentifiedGraphsBuffer[depth];
        // Indicate that we have not emitted at this depth
        parsingContext.emittedStack[depth] = false;
    }
}
exports.EntryHandlerKeywordValue = EntryHandlerKeywordValue;
//# sourceMappingURL=EntryHandlerKeywordValue.js.map