import { jsPlumbInstance, Offset, PointArray } from "../core";
import { EventGenerator } from "../event-generator";
import { Endpoint } from "../endpoint/endpoint-impl";
import { AnchorComputeParams, AnchorId, AnchorOptions, AnchorOrientationHint, Orientation } from "../factory/anchor-factory";
import { AnchorPlacement } from "../anchor-manager";
export declare class Anchor extends EventGenerator {
    instance: jsPlumbInstance;
    type: AnchorId;
    isDynamic: boolean;
    isContinuous: boolean;
    isFloating: boolean;
    cssClass: string;
    elementId: string;
    id: string;
    locked: boolean;
    offsets: [number, number];
    orientation: Orientation;
    x: number;
    y: number;
    timestamp: string;
    lastReturnValue: AnchorPlacement;
    positionFinder: (dropPosition: Offset, elPosition: Offset, elSize: PointArray, constructorParams: any) => any;
    clone: () => Anchor;
    constructor(instance: jsPlumbInstance, params?: AnchorOptions);
    shouldFireEvent(event: string, value: any, originalEvent?: Event): boolean;
    getOrientation(endpoint?: Endpoint): Orientation;
    getCurrentLocation(params: AnchorComputeParams): AnchorPlacement;
    setPosition(x: number, y: number, ox: AnchorOrientationHint, oy: AnchorOrientationHint, overrideLock?: boolean): void;
    compute(params: AnchorComputeParams): AnchorPlacement;
    equals(anchor: Anchor): boolean;
    getCssClass(): string;
    lock(): void;
    unlock(): void;
    isLocked(): boolean;
    over(anchor: Anchor, endpoint: Endpoint): void;
    out(): void;
}
