import { jsPlumbInstance, TypeDescriptor } from "../core";
import { AbstractConnector } from "./abstract-connector";
import { Endpoint } from "../endpoint/endpoint-impl";
import { PaintStyle } from "../styles";
import { Component } from "../component/component";
import { OverlayCapableComponent } from "../component/overlay-capable-component";
import { OverlaySpec } from "../overlay/overlay";
import { AnchorSpec } from "../factory/anchor-factory";
import { ConnectorSpec } from "./abstract-connector";
import { EndpointSpec } from "../endpoint/endpoint";
export interface ConnectionParams {
    id?: string;
    source?: string | any;
    target?: string | any;
    sourceEndpoint?: Endpoint;
    targetEndpoint?: Endpoint;
    scope?: string;
    overlays?: Array<OverlaySpec>;
    connector?: ConnectorSpec;
    type?: string;
    endpoints?: [EndpointSpec, EndpointSpec];
    endpoint?: EndpointSpec;
    endpointStyles?: [PaintStyle, PaintStyle];
    endpointStyle?: PaintStyle;
    endpointHoverStyle?: PaintStyle;
    endpointHoverStyles?: [PaintStyle, PaintStyle];
    outlineStroke?: number;
    outlineWidth?: number;
    uuids?: [string, string];
    deleteEndpointsOnEmpty?: boolean;
    detachable?: boolean;
    reattach?: boolean;
    directed?: boolean;
    cost?: number;
    data?: any;
    cssClass?: string;
    paintStyle?: PaintStyle;
    hoverPaintStyle?: PaintStyle;
    previousConnection?: Connection;
    anchors?: [AnchorSpec, AnchorSpec];
    anchor?: AnchorSpec;
}
export declare class Connection extends OverlayCapableComponent {
    instance: jsPlumbInstance;
    id: string;
    connector: AbstractConnector;
    defaultLabelLocation: number;
    scope: string;
    typeId: string;
    getIdPrefix(): string;
    getDefaultOverlayKey(): string;
    getXY(): {
        x: number;
        y: number;
    };
    previousConnection: Connection;
    sourceId: string;
    targetId: string;
    source: any;
    target: any;
    endpoints: [Endpoint, Endpoint];
    endpointStyles: [PaintStyle, PaintStyle];
    suspendedEndpoint: Endpoint;
    suspendedIndex: number;
    suspendedElement: any;
    suspendedElementId: string;
    suspendedElementType: string;
    _forceReattach: boolean;
    _forceDetach: boolean;
    proxies: Array<{
        ep: Endpoint;
        originalEp: Endpoint;
    }>;
    pending: boolean;
    anchors: [AnchorSpec, AnchorSpec];
    anchor: AnchorSpec;
    floatingIndex: number;
    floatingEndpoint: Endpoint;
    floatingId: string;
    floatingElement: any;
    constructor(instance: jsPlumbInstance, params: ConnectionParams);
    makeEndpoint(isSource: boolean, el: any, elId: string, ep?: Endpoint): Endpoint;
    getTypeDescriptor(): string;
    getAttachedElements(): Array<Component>;
    isDetachable(ep?: Endpoint): boolean;
    setDetachable(detachable: boolean): void;
    isReattach(): boolean;
    setReattach(reattach: boolean): void;
    applyType(t: TypeDescriptor, doNotRepaint: boolean, typeMap: any): void;
    addClass(c: string, informEndpoints?: boolean): void;
    removeClass(c: string, informEndpoints?: boolean): void;
    setVisible(v: boolean): void;
    destroy(force?: boolean): void;
    updateConnectedClass(remove?: boolean): void;
    getUuids(): [string, string];
    getCost(): number;
    setCost(c: number): void;
    isDirected(): boolean;
    getConnector(): AbstractConnector;
    makeConnector(name: string, args: any): AbstractConnector;
    prepareConnector(connectorSpec: ConnectorSpec, typeId?: string): AbstractConnector;
    setPreparedConnector(connector: AbstractConnector, doNotRepaint?: boolean, doNotChangeListenerComponent?: boolean, typeId?: string): void;
    setConnector(connectorSpec: ConnectorSpec, doNotRepaint?: boolean, doNotChangeListenerComponent?: boolean, typeId?: string): void;
    paint(params?: any): void;
    prepareEndpoint(existing: Endpoint, index: number, element?: any, elementId?: string, params?: ConnectionParams): Endpoint;
    private _makeAnchor;
    replaceEndpoint(idx: number, endpointDef: EndpointSpec): void;
}
