/**
 * Conditional rule for @media, @supports
 *
 * @api private
 */
'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var ConditionalRule = (function () {
  function ConditionalRule(selector, styles, options) {
    _classCallCheck(this, ConditionalRule);

    this.type = 'conditional';
    this.selector = selector;
    this.options = options;
    this.rules = this.createChildRules(styles);
  }

  /**
   * A conditional rule always contains child rules.
   *
   * @param {Object} styles
   * @return {Array} rules
   * @api private
   */

  ConditionalRule.prototype.createChildRules = function createChildRules(styles) {
    var rules = {};
    var options = _extends({}, this.options, { parent: this });
    var sheet = options.sheet;
    var jss = options.jss;

    for (var _name in styles) {
      var localOptions = options;
      // We have already a rule in the current style sheet with this name,
      // This new rule is supposed to overwrite the first one, for this we need
      // to ensure it will have the same className/selector.
      var ruleToOverwrite = options.sheet && options.sheet.getRule(_name);
      if (ruleToOverwrite) localOptions = _extends({}, options, { className: ruleToOverwrite.className });
      rules[_name] = (sheet || jss).createRule(_name, styles[_name], localOptions);
    }
    return rules;
  };

  /**
   * Generates a CSS string.
   *
   * @return {String}
   * @api private
   */

  ConditionalRule.prototype.toString = function toString() {
    var str = this.selector + ' {\n';
    for (var _name2 in this.rules) {
      var ruleStr = this.rules[_name2].toString({ indentationLevel: 1 });
      str += ruleStr + '\n';
    }
    str += '}';
    return str;
  };

  return ConditionalRule;
})();

exports['default'] = ConditionalRule;
module.exports = exports['default'];