/**
 * Keyframe rule.
 *
 * @api private
 */
'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var KeyframeRule = (function () {
  function KeyframeRule(selector, frames, options) {
    _classCallCheck(this, KeyframeRule);

    this.type = 'keyframe';
    this.selector = selector;
    this.options = options;
    this.frames = this.formatFrames(frames);
  }

  /**
   * Creates formatted frames where every frame value is a rule instance.
   *
   * @api private
   */

  KeyframeRule.prototype.formatFrames = function formatFrames(frames) {
    var newFrames = {};
    for (var _name in frames) {
      var options = _extends({}, this.options, { named: false, parent: this });
      newFrames[_name] = this.options.jss.createRule(_name, frames[_name], options);
    }
    return newFrames;
  };

  /**
   * Generates a CSS string.
   *
   * @return {String}
   * @api private
   */

  KeyframeRule.prototype.toString = function toString() {
    var str = this.selector + ' {\n';
    var options = { indentationLevel: 1 };
    for (var _name2 in this.frames) {
      str += this.frames[_name2].toString(options) + '\n';
    }
    str += '}';
    return str;
  };

  return KeyframeRule;
})();

exports['default'] = KeyframeRule;
module.exports = exports['default'];