'use strict';

exports.__esModule = true;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj['default'] = obj; return newObj; } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _uid = require('./uid');

var uid = _interopRequireWildcard(_uid);

var _clone = require('./clone');

var _clone2 = _interopRequireDefault(_clone);

/**
 * Class name prefix when generated.
 *
 * @type {String}
 * @api private
 */
var namespacePrefix = 'jss';

/**
 * Indentation string for formatting toString output.
 *
 * @type {String}
 * @api private
 */
var indentWith = '  ';

/**
 * Regular rule.
 *
 * @api private
 */

var Rule = (function () {
  function Rule(selector, style, options) {
    _classCallCheck(this, Rule);

    this.type = 'regular';
    this.id = uid.get();
    this.options = options;
    this.selector = selector;
    if (options.named) {
      // Selector is a rule name, we need to ref it for e.g. for jss-debug.
      this.name = selector;
      this.className = options.className || namespacePrefix + '-' + this.id;
      this.selector = '.' + this.className;
    }
    // We expect style to be plain object.
    this.style = _clone2['default'](style);
  }

  /**
   * Indent a string.
   *
   * http://jsperf.com/array-join-vs-for
   *
   * @param {Number} level
   * @param {String} str
   * @return {String}
   * @api private
   */

  /**
   * Get or set a style property.
   *
   * @param {String} name
   * @param {String|Number} [value]
   * @return {Rule|String|Number}
   * @api public
   */

  Rule.prototype.prop = function prop(name, value) {
    // Its a setter.
    if (value != null) {
      this.style[name] = value;
      // If linked option in StyleSheet is not passed, DOMRule is not defined.
      if (this.DOMRule) this.DOMRule.style[name] = value;
      return this;
    }
    // Its a getter, read the value from the DOM if its not cached.
    if (this.DOMRule && this.style[name] == null) {
      // Cache the value after we have got it from the DOM once.
      this.style[name] = this.DOMRule.style[name];
    }
    return this.style[name];
  };

  /**
   * Apply rule to an element inline.
   *
   * @param {Element} element
   * @return {Rule}
   * @api public
   */

  Rule.prototype.applyTo = function applyTo(element) {
    for (var prop in this.style) {
      var value = this.style[prop];
      if (Array.isArray(value)) {
        for (var i = 0; i < value.length; i++) {
          element.style[prop] = value[i];
        }
      } else element.style[prop] = value;
    }
    return this;
  };

  /**
   * Returns JSON representation of the rule.
   * Nested rules, at-rules and array values are not supported.
   *
   * @return {Object}
   * @api public
   */

  Rule.prototype.toJSON = function toJSON() {
    var style = {};
    for (var prop in this.style) {
      if (typeof this.style[prop] != 'object') {
        style[prop] = this.style[prop];
      }
    }
    return style;
  };

  /**
   * Generates a CSS string.
   *
   * @return {String}
   * @api private
   */

  Rule.prototype.toString = function toString() {
    var _ref = arguments.length <= 0 || arguments[0] === undefined ? { indentationLevel: 0 } : arguments[0];

    var indentationLevel = _ref.indentationLevel;

    var str = indent(indentationLevel, this.selector + ' {');
    indentationLevel++;
    for (var prop in this.style) {
      var value = this.style[prop];
      // We want to generate multiple style with identical property names.
      if (Array.isArray(value)) {
        for (var i = 0; i < value.length; i++) {
          str += '\n' + indent(indentationLevel, prop + ': ' + value[i] + ';');
        }
      } else str += '\n' + indent(indentationLevel, prop + ': ' + value + ';');
    }
    str += '\n' + indent(--indentationLevel, '}');
    return str;
  };

  return Rule;
})();

exports['default'] = Rule;
function indent(level, str) {
  var indentStr = '';
  for (var i = 0; i < level; i++) {
    indentStr += indentWith;
  }return indentStr + str;
}
module.exports = exports['default'];