'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports['default'] = createRule;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _Rule = require('./Rule');

var _Rule2 = _interopRequireDefault(_Rule);

var _SimpleRule = require('./SimpleRule');

var _SimpleRule2 = _interopRequireDefault(_SimpleRule);

var _KeyframeRule = require('./KeyframeRule');

var _KeyframeRule2 = _interopRequireDefault(_KeyframeRule);

var _ConditionalRule = require('./ConditionalRule');

var _ConditionalRule2 = _interopRequireDefault(_ConditionalRule);

/**
 * Map of at rules to corresponding implementation class.
 *
 * @type {Object}
 */
var atRuleClassMap = {
  '@charset': _SimpleRule2['default'],
  '@import': _SimpleRule2['default'],
  '@namespace': _SimpleRule2['default'],
  '@keyframes': _KeyframeRule2['default'],
  '@media': _ConditionalRule2['default'],
  '@supports': _ConditionalRule2['default'],
  '@font-face': _Rule2['default']
};

var atRuleNameRegExp = /^@[^ ]+/;

/**
 * Create rule factory.
 *
 * @param {Object} [selector] if you don't pass selector - it will be generated
 * @param {Object} [style] declarations block
 * @param {Object} [options] rule options
 * @return {Object} rule
 * @api private
 */

function createRule(selector) {
  var style = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];
  var options = arguments.length <= 2 || arguments[2] === undefined ? {} : arguments[2];

  // Is an at-rule.
  if (selector && selector[0] === '@') {
    var _name = atRuleNameRegExp.exec(selector)[0];
    var AtRule = atRuleClassMap[_name];
    // We use regular rule class to handle font rule,
    // font-face rule should not be named.
    if (_name === '@font-face' && options.named) {
      options = _extends({}, options, { named: false });
    }
    return new AtRule(selector, style, options);
  }
  if (options.named == null) options.named = true;
  return new _Rule2['default'](selector, style, options);
}

module.exports = exports['default'];