'use strict';

exports.__esModule = true;
exports.createStyle = createStyle;
exports.appendStyle = appendStyle;
exports.getCssRules = getCssRules;
exports.insertCssRule = insertCssRule;
exports.removeElement = removeElement;
var sheetAttrs = ['title', 'type', 'media'];

/**
 * Create style element, add attributes.
 *
 * @param {StyleSheet} sheet
 * @return {Element}
 * @api private
 */

function createStyle(sheet) {
  var element = document.createElement('style');
  sheetAttrs.forEach(function (name) {
    if (sheet[name]) element.setAttribute(name, sheet[name]);
  });
  return element;
}

/**
 * Insert style element into head.
 *
 * @param {Element} element
 * @api private
 */

function appendStyle(element) {
  document.head.appendChild(element);
}

/**
 * Get cssRules collection from a sheet
 *
 * @param {Element} element
 * @return {CSSRules}
 * @api private
 */

function getCssRules(element) {
  return element && element.sheet && element.sheet.cssRules;
}

/**
 * Insert a rule string into a style element.
 *
 * @param {Element} element
 * @param {String} ruleStr
 * @return {CSSRule}
 * @api private
 */

function insertCssRule(element, ruleStr) {
  var rules = getCssRules(element);
  var nextIndex = rules.length;
  element.sheet.insertRule(ruleStr, nextIndex);
  return rules[nextIndex];
}

/**
 * Remove element from the dom tree.
 *
 * @param {Element} element
 * @api private
 */

function removeElement(element) {
  element.parentNode.removeChild(element);
}

function noDOM() {}
// For serverside rendering all functions will return undefined.
if (typeof document == 'undefined') {
  for (var _name in exports) {
    if (typeof exports[_name] == 'function') {
      exports[_name] = noDOM;
    }
  }
}