'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _warning = require('warning');

var _warning2 = _interopRequireDefault(_warning);

var _StyleSheet = require('../StyleSheet');

var _StyleSheet2 = _interopRequireDefault(_StyleSheet);

var _global = require('./global');

var _global2 = _interopRequireDefault(_global);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var ns = '2f1acc6c3a606b082e5eef5e54414ffb';

if (_global2['default'][ns] == null) _global2['default'][ns] = 0;
// In case we have more than one JSS version.
var jssCounter = _global2['default'][ns]++;

var maxRules = 1e10;

var env = process.env.NODE_ENV;

/**
 * Returns a function which generates unique class names based on counters.
 * When new generator function is created, rule counter is reseted.
 * We need to reset the rule counter for SSR for each request.
 */

exports['default'] = function () {
  var ruleCounter = 0;

  return function (rule, sheet) {
    ruleCounter += 1;

    if (ruleCounter > maxRules) {
      (0, _warning2['default'])(false, '[JSS] You might have a memory leak. Rule counter is at %s.', ruleCounter);
    }

    if (env === 'production') {
      return 'c' + jssCounter + ruleCounter;
    }

    var prefix = sheet ? sheet.options.classNamePrefix || '' : '';
    return prefix + rule.key + '-' + jssCounter + '-' + ruleCounter;
  };
};