import { IError, IDataBase } from "./interfaces";
import { API, EVENT } from "./enums";
export declare type WebWorkerRequest = {
    name: API;
    query?: any;
    onSuccess?: (results?: any) => void;
    onError?: (err: IError) => void;
    onResult?: (cb: (result: any) => Promise<any>) => void;
    beforeExecute?: (cb: (result: any) => Promise<any>) => void;
};
export declare type WebWorkerResult = {
    error?: any;
    result?: any;
};
export declare type SqlWebResult = {
    api: string;
    data: any;
};
export declare type EventQueue = {
    event: EVENT;
    callback: Function;
};
export declare type SetQuery = {
    key: string;
    value: any;
};
export declare type TStringAny = {
    [key: string]: any;
};
export declare type TMiddleware = (request: WebWorkerRequest) => Promise<any>;
export declare type InitDbResult = {
    isCreated: boolean;
    database?: IDataBase;
    oldVersion: number;
    newVersion: number;
};
