import { ConnectionHelper } from "./connection_helper";
import { ISelectQuery, ICountQuery, IInsertQuery, IUpdateQuery, IRemoveQuery, ITranscationQuery, IDataBase, EVENT, IPlugin, IIntersectQuery, IDbInfo, TMiddleware } from "../common";
export declare class Connection extends ConnectionHelper {
    constructor(worker?: Worker);
    /**
     * initiate DataBase
     *
     * @param {IDataBase} dataBase
     * @returns
     * @memberof Connection
     */
    initDb(dataBase: IDataBase): Promise<boolean>;
    /**
     * drop dataBase
     *
     * @returns
     * @memberof Connection
     */
    dropDb(): Promise<void>;
    /**
     * select data from table
     *
     * @template T
     * @param {ISelectQuery} query
     * @returns
     * @memberof Connection
     */
    select<T>(query: ISelectQuery): Promise<T[]>;
    /**
     * get no of record from table
     *
     * @param {ICountQuery} query
     * @returns
     * @memberof Connection
     */
    count(query: ICountQuery): Promise<number>;
    /**
     * insert data into table
     *
     * @template T
     * @param {IInsertQuery} query
     * @returns
     * @memberof Connection
     */
    insert<T>(query: IInsertQuery): Promise<number | T[]>;
    /**
     * update data into table
     *
     * @param {IUpdateQuery} query
     * @returns
     * @memberof Connection
     */
    update(query: IUpdateQuery): Promise<number>;
    /**
     * remove data from table
     *
     * @param {IRemoveQuery} query
     * @returns
     * @memberof Connection
     */
    remove(query: IRemoveQuery): Promise<number>;
    /**
     * delete all data from table
     *
     * @param {string} tableName
     * @returns
     * @memberof Connection
     */
    clear(tableName: string): Promise<void>;
    /**
     * set log status
     *
     * @param {boolean} status
     * @memberof Connection
     */
    set logStatus(status: boolean);
    /**
     * open database
     *
     * @param {string} dbName
     * @returns
     * @memberof Connection
     */
    openDb(dbName: string, version?: any): Promise<IDataBase>;
    /**
     * returns list of database created
     *
     * @returns
     * @memberof Connection
     */
    getDbList(): Promise<[IDbInfo]>;
    /**
     * get the value from keystore table
     *
     * @template T
     * @param {string} key
     * @returns
     * @memberof Connection
     */
    get<T>(key: string): Promise<T>;
    /**
     * set the value in keystore table
     *
     * @param {string} key
     * @param {*} value
     * @returns
     * @memberof Connection
     */
    set(key: string, value: any): Promise<void>;
    /**
     * terminate the connection
     *
     * @returns
     * @memberof Connection
     */
    terminate(): Promise<void>;
    /**
     * execute transaction
     *
     * @template T
     * @param {ITranscationQuery} query
     * @returns
     * @memberof Connection
     */
    transaction<T>(query: ITranscationQuery): Promise<T>;
    on(event: EVENT, eventCallBack: Function): void;
    off(event: EVENT, eventCallBack: Function): void;
    union<T>(query: ISelectQuery[]): Promise<T>;
    intersect<T>(query: IIntersectQuery): Promise<T>;
    addPlugin(plugin: IPlugin, params?: any): any;
    addMiddleware(middleware: TMiddleware | string, forWorker: boolean): Promise<unknown>;
    /**
     * import scripts in jsstore web worker.
     * Scripts method can be called using transaction api.
     *
     * @param {...string[]} urls
     * @returns
     * @memberof Connection
     */
    importScripts(...urls: string[]): Promise<void>;
}
