import { ISelectQuery } from "@/common";
import { IDBUtil } from "@/worker/idbutil";
import { setPushResult, setLimitAndSkipEvaluationAtEnd, removeDuplicates } from "./base_select";
import { ThenEvaluator } from "./then_evaluator";
import { executeWhereUndefinedLogic } from "./not_where";
import { processAggregateQry, processGroupDistinctAggr, processOrderBy } from "./order_by";
import { executeAggregateGroupBy, processGroupBy } from "./group_by";
import { BaseFetch } from "@executors/base_fetch";
import { executeJoinQuery } from "./join";
export declare class Select extends BaseFetch {
    sorted: boolean;
    isOr: boolean;
    isArrayQry: boolean;
    query: ISelectQuery;
    orInfo: {
        results?: any[];
        orQuery: object;
    };
    isSubQuery: boolean;
    protected pushResult: (value: any) => void;
    protected thenEvaluator: ThenEvaluator;
    executeWhereUndefinedLogic: typeof executeWhereUndefinedLogic;
    setLimitAndSkipEvaluationAtEnd_: typeof setLimitAndSkipEvaluationAtEnd;
    setPushResult: typeof setPushResult;
    removeDuplicates: typeof removeDuplicates;
    executeJoinQuery: typeof executeJoinQuery;
    processGroupDistinctAggr: typeof processGroupDistinctAggr;
    processOrderBy: typeof processOrderBy;
    processAggregateQry: typeof processAggregateQry;
    executeAggregateGroupBy: typeof executeAggregateGroupBy;
    processGroupBy: typeof processGroupBy;
    constructor(query: ISelectQuery, util: IDBUtil);
    execute(beforeExecute?: () => Promise<any>): Promise<any>;
    private processWhereArrayQry;
    private initTransaction_;
    private processWhere_;
    private onWhereEvaluated;
    private returnResult_;
    private orQueryFinish_;
    private orQuerySuccess_;
    private processOrLogic_;
}
