import { DbMeta } from "@worker/model";
import { IDB_MODE, InitDbResult } from "@/common";
import { LogHelper } from "@worker/utils";
export declare class IDBUtil {
    db: DbMeta;
    con: IDBDatabase;
    tx: IDBTransaction;
    logger: LogHelper;
    emptyTx(): void;
    createTransactionIfNotExist(tables: string[], mode?: IDB_MODE): void;
    createTransaction(tables: string[], mode?: IDB_MODE): Promise<unknown>;
    keyRange(value: any, op?: any): IDBKeyRange;
    objectStore(name: string): IDBObjectStore;
    abortTransaction(): void;
    close(): Promise<unknown>;
    initDb(db: DbMeta): Promise<InitDbResult>;
}
