import { WebWorkerRequest, IDataBase, IDbInfo } from "@/common";
import { DbMeta } from "./model";
import { IDBUtil } from "./idbutil";
import { LogHelper } from "@worker/utils";
export declare class QueryManager {
    util: IDBUtil;
    get db(): DbMeta;
    middlewares: string[];
    private onQryFinished;
    protected get logger(): LogHelper;
    constructor(fn?: (result: any) => void);
    private executeMiddleware_;
    executeQuery(request: WebWorkerRequest, cb: () => Promise<any>): Promise<any>;
    private callResultMiddleware;
    private callBeforeMiddleware;
    run(request: WebWorkerRequest): void;
    private importScripts_;
    private returnResult_;
    private dropDb;
    closeDb(): Promise<unknown>;
    terminate(): Promise<void>;
    openDb(query: IDbInfo): Promise<DbMeta>;
    initDb(dataBase?: IDataBase): Promise<boolean>;
}
