import { IEditorMimeTypeService } from '@jupyterlab/codeeditor';
import * as nbformat from '@jupyterlab/nbformat';
/**
 * The mime type service for CodeMirror.
 */
export declare class CodeMirrorMimeTypeService implements IEditorMimeTypeService {
    /**
     * Returns a mime type for the given language info.
     *
     * #### Notes
     * If a mime type cannot be found returns the default mime type `text/plain`, never `null`.
     */
    getMimeTypeByLanguage(info: nbformat.ILanguageInfoMetadata): string;
    /**
     * Returns a mime type for the given file path.
     *
     * #### Notes
     * If a mime type cannot be found returns the default mime type `text/plain`, never `null`.
     */
    getMimeTypeByFilePath(path: string): string;
}
