import { CodeEditor } from '@jupyterlab/codeeditor';
import { ITranslator } from '@jupyterlab/translation';
import { VDomModel, VDomRenderer } from '@jupyterlab/ui-components';
import { CommandRegistry } from '@lumino/commands';
/**
 * StatusBar item to change the language syntax highlighting of the file editor.
 */
export declare class EditorSyntaxStatus extends VDomRenderer<EditorSyntaxStatus.Model> {
    /**
     * Construct a new VDomRenderer for the status item.
     */
    constructor(opts: EditorSyntaxStatus.IOptions);
    /**
     * Render the status item.
     */
    render(): JSX.Element | null;
    /**
     * Create a menu for selecting the mode of the editor.
     */
    private _handleClick;
    protected translator: ITranslator;
    private _commands;
    private _popup;
}
/**
 * A namespace for EditorSyntax statics.
 */
export declare namespace EditorSyntaxStatus {
    /**
     * A VDomModel for the current editor/mode combination.
     */
    class Model extends VDomModel {
        /**
         * The current mode for the editor. If no editor is present,
         * returns the empty string.
         */
        get mode(): string;
        /**
         * The current editor for the application editor tracker.
         */
        get editor(): CodeEditor.IEditor | null;
        set editor(editor: CodeEditor.IEditor | null);
        /**
         * If the editor mode changes, update the model.
         */
        private _onMIMETypeChange;
        /**
         * Trigger a rerender of the model.
         */
        private _triggerChange;
        private _mode;
        private _editor;
    }
    /**
     * Options for the EditorSyntax status item.
     */
    interface IOptions {
        /**
         * The application command registry.
         */
        commands: CommandRegistry;
        /**
         * The language translator.
         */
        translator?: ITranslator;
    }
}
