import { ITranslator } from '@jupyterlab/translation';
import { Signal } from '@lumino/signaling';
import { Widget } from '@lumino/widgets';
import { IDisplayState, IFiltersType } from './interfaces';
import { SearchInstance } from './searchinstance';
export declare function createSearchOverlay(options: createSearchOverlay.IOptions): Widget;
declare namespace createSearchOverlay {
    interface IOptions {
        widgetChanged: Signal<SearchInstance, IDisplayState>;
        overlayState: IDisplayState;
        onCaseSensitiveToggled: () => void;
        onRegexToggled: () => void;
        onHighlightNext: () => void;
        onHighlightPrevious: () => void;
        onStartQuery: (r: RegExp, f: IFiltersType) => void;
        onEndSearch: () => void;
        onReplaceCurrent: (t: string) => void;
        onReplaceAll: (t: string) => void;
        isReadOnly: boolean;
        hasOutputs: boolean;
        searchDebounceTime: number;
        translator?: ITranslator;
    }
}
export {};
