import { IDisposable } from '@lumino/disposable';
import { ISignal } from '@lumino/signaling';
export declare class StatusMessage implements IDisposable {
    constructor();
    /**
     * Signal emitted on status changed event.
     */
    get changed(): ISignal<StatusMessage, void>;
    /**
     * Test whether the object is disposed.
     */
    get isDisposed(): boolean;
    /**
     * Dispose the object.
     */
    dispose(): void;
    /**
     * The text message to be shown on the statusbar.
     */
    get message(): string;
    /**
     * Set the text message and (optionally) the timeout to remove it.
     * @param message
     * @param timeout - number of ms to until the message is cleaned;
     *        -1 if the message should stay up indefinitely;
     *        defaults to 3000ms (3 seconds)
     */
    set(message: string, timeout?: number): void;
    /**
     * Clear the status message.
     */
    clear(): void;
    /**
     * Timeout reference used to clear the previous `setTimeout` call.
     */
    private _timer;
    /**
     * Clear the previous `setTimeout` call.
     */
    private _expireTimer;
    /**
     * The text message to be shown on the statusbar
     */
    private _message;
    private _changed;
    private _isDisposed;
}
