// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
import { Token } from '@lumino/coreutils';
export var ILanguageServerManager;
(function (ILanguageServerManager) {
    /**
     * LSP endpoint prefix.
     */
    ILanguageServerManager.URL_NS = 'lsp';
})(ILanguageServerManager || (ILanguageServerManager = {}));
/**
 * @alpha
 *
 * The virtual documents and language server connections manager
 * Require this token in your extension to access the associated virtual
 * document and LS connection of opened documents.
 *
 */
export const ILSPDocumentConnectionManager = new Token('@jupyterlab/lsp:ILSPDocumentConnectionManager');
/**
 * @alpha
 *
 * The language server feature manager. Require this token in your extension
 * to register the client capabilities implemented by your extension.
 *
 */
export const ILSPFeatureManager = new Token('@jupyterlab/lsp:ILSPFeatureManager');
/**
 * @alpha
 *
 * The code extractor manager. Require this token in your extension to
 * register new code extractors. Code extractor allows creating multiple
 * virtual documents from an opened document.
 *
 */
export const ILSPCodeExtractorsManager = new Token('@jupyterlab/lsp:ILSPCodeExtractorsManager');
/**
 * Method strings are reproduced here because a non-typing import of
 * `vscode-languageserver-protocol` is ridiculously expensive.
 */
export var Method;
(function (Method) {
    /** Server notifications */
    let ServerNotification;
    (function (ServerNotification) {
        ServerNotification["PUBLISH_DIAGNOSTICS"] = "textDocument/publishDiagnostics";
        ServerNotification["SHOW_MESSAGE"] = "window/showMessage";
        ServerNotification["LOG_TRACE"] = "$/logTrace";
        ServerNotification["LOG_MESSAGE"] = "window/logMessage";
    })(ServerNotification = Method.ServerNotification || (Method.ServerNotification = {}));
    /** Client notifications */
    let ClientNotification;
    (function (ClientNotification) {
        ClientNotification["DID_CHANGE"] = "textDocument/didChange";
        ClientNotification["DID_CHANGE_CONFIGURATION"] = "workspace/didChangeConfiguration";
        ClientNotification["DID_OPEN"] = "textDocument/didOpen";
        ClientNotification["DID_SAVE"] = "textDocument/didSave";
        ClientNotification["INITIALIZED"] = "initialized";
        ClientNotification["SET_TRACE"] = "$/setTrace";
    })(ClientNotification = Method.ClientNotification || (Method.ClientNotification = {}));
    /** Server requests */
    let ServerRequest;
    (function (ServerRequest) {
        ServerRequest["REGISTER_CAPABILITY"] = "client/registerCapability";
        ServerRequest["SHOW_MESSAGE_REQUEST"] = "window/showMessageRequest";
        ServerRequest["UNREGISTER_CAPABILITY"] = "client/unregisterCapability";
        ServerRequest["WORKSPACE_CONFIGURATION"] = "workspace/configuration";
    })(ServerRequest = Method.ServerRequest || (Method.ServerRequest = {}));
    /** Client requests */
    let ClientRequest;
    (function (ClientRequest) {
        ClientRequest["COMPLETION"] = "textDocument/completion";
        ClientRequest["COMPLETION_ITEM_RESOLVE"] = "completionItem/resolve";
        ClientRequest["DEFINITION"] = "textDocument/definition";
        ClientRequest["DOCUMENT_HIGHLIGHT"] = "textDocument/documentHighlight";
        ClientRequest["DOCUMENT_SYMBOL"] = "textDocument/documentSymbol";
        ClientRequest["HOVER"] = "textDocument/hover";
        ClientRequest["IMPLEMENTATION"] = "textDocument/implementation";
        ClientRequest["INITIALIZE"] = "initialize";
        ClientRequest["REFERENCES"] = "textDocument/references";
        ClientRequest["RENAME"] = "textDocument/rename";
        ClientRequest["SIGNATURE_HELP"] = "textDocument/signatureHelp";
        ClientRequest["TYPE_DEFINITION"] = "textDocument/typeDefinition";
    })(ClientRequest = Method.ClientRequest || (Method.ClientRequest = {}));
})(Method || (Method = {}));
//# sourceMappingURL=tokens.js.map