import { ICellModel } from '@jupyterlab/cells';
import { IObservableList } from '@jupyterlab/observables';
import * as models from '@jupyterlab/shared-models';
import { ISignal } from '@lumino/signaling';
/**
 * A cell list object that supports undo/redo.
 */
export declare class CellList {
    /**
     * Construct the cell list.
     */
    constructor(model: models.ISharedNotebook);
    type: 'List';
    nbmodel: models.ISharedNotebook;
    private _insertCells;
    private onSharedModelChanged;
    /**
     * A signal emitted when the cell list has changed.
     */
    get changed(): ISignal<this, IObservableList.IChangedArgs<ICellModel>>;
    /**
     * Test whether the cell list has been disposed.
     */
    get isDisposed(): boolean;
    /**
     * Test whether the list is empty.
     *
     * @returns `true` if the cell list is empty, `false` otherwise.
     *
     * #### Notes
     * This is a read-only property.
     *
     * #### Complexity
     * Constant.
     *
     * #### Iterator Validity
     * No changes.
     */
    get isEmpty(): boolean;
    /**
     * Get the length of the cell list.
     *
     * @returns The number of cells in the cell list.
     *
     * #### Notes
     * This is a read-only property.
     *
     * #### Complexity
     * Constant.
     *
     * #### Iterator Validity
     * No changes.
     */
    get length(): number;
    /**
     * Create an iterator over the cells in the cell list.
     *
     * @returns A new iterator starting at the front of the cell list.
     */
    [Symbol.iterator](): IterableIterator<ICellModel>;
    /**
     * Dispose of the resources held by the cell list.
     */
    dispose(): void;
    /**
     * Get the cell at the specified index.
     *
     * @param index - The positive integer index of interest.
     *
     * @returns The cell at the specified index.
     *
     * #### Complexity
     * Constant.
     *
     * #### Iterator Validity
     * No changes.
     *
     * #### Undefined Behavior
     * An `index` which is non-integral or out of range.
     */
    get(index: number): ICellModel;
    private _onOrderChanged;
    private _isDisposed;
    private _cellOrder;
    private _cellMap;
    private _changed;
}
