import * as Y from 'yjs';
import * as models from './api';
export declare function convertYMapEventToMapChange(event: Y.YMapEvent<any>): models.MapChange;
/**
 * Creates a mutual exclude function with the following property:
 *
 * ```js
 * const mutex = createMutex()
 * mutex(() => {
 *   // This function is immediately executed
 *   mutex(() => {
 *     // This function is not executed, as the mutex is already active.
 *   })
 * })
 * ```
 */
export declare const createMutex: () => (f: () => void) => void;
