import { ISanitizer } from '@jupyterlab/apputils';
import { INotebookTracker, NotebookPanel } from '@jupyterlab/notebook';
import { ISettingRegistry } from '@jupyterlab/settingregistry';
import { ITranslator } from '@jupyterlab/translation';
import { TableOfContents } from '../../toc';
import { ITableOfContentsRegistry } from '../../tokens';
/**
 * Returns a ToC generator for notebooks.
 *
 * @param tracker - notebook tracker
 * @param widget - table of contents widget
 * @param sanitizer - HTML sanitizer
 * @param translator - Language translator
 * @param settings - advanced settings for toc extension
 * @returns ToC generator capable of parsing notebooks
 */
export declare function createNotebookGenerator(tracker: INotebookTracker, widget: TableOfContents, sanitizer: ISanitizer, translator?: ITranslator, settings?: ISettingRegistry.ISettings): ITableOfContentsRegistry.IGenerator<NotebookPanel>;
