import { IDocumentWidget } from '@jupyterlab/docregistry';
import { FileEditor, IEditorTracker } from '@jupyterlab/fileeditor';
import { ITableOfContentsRegistry as Registry } from '../../tokens';
/**
 * Returns a ToC generator for Python files.
 *
 * @private
 * @param tracker - file editor tracker
 * @returns ToC generator capable of parsing Python files
 */
declare function createPythonGenerator(tracker: IEditorTracker): Registry.IGenerator<IDocumentWidget<FileEditor>>;
/**
 * Exports.
 */
export { createPythonGenerator };
