import { ISignal } from '@lumino/signaling';
import { Widget } from '@lumino/widgets';
import { ITableOfContentsRegistry } from './tokens';
/**
 * Class for registering widgets for which we can generate a table of contents.
 */
export declare class TableOfContentsRegistry implements ITableOfContentsRegistry {
    /**
     * Finds a table of contents generator for a widget.
     *
     * ## Notes
     *
     * -   If unable to find a table of contents generator, the method return `undefined`.
     *
     * @param widget - widget
     * @returns table of contents generator
     */
    find(widget: Widget): ITableOfContentsRegistry.IGenerator | undefined;
    /**
     * Adds a table of contents generator to the registry.
     *
     * @param generator - table of contents generator
     */
    add(generator: ITableOfContentsRegistry.IGenerator): void;
    get collapseChanged(): ISignal<this, ITableOfContentsRegistry.ICollapseChangedArgs>;
    private _collapseChanged;
    private _generators;
}
