import { Token } from '@lumino/coreutils';
/**
 * Table of contents registry token.
 */
export const ITableOfContentsRegistry = new Token('@jupyterlab/toc:ITableOfContentsRegistry');
/**
 * Cell running status
 */
export var RunningStatus;
(function (RunningStatus) {
    /**
     * Cell is idle
     */
    RunningStatus[RunningStatus["Idle"] = -1] = "Idle";
    /**
     * Cell execution is scheduled
     */
    RunningStatus[RunningStatus["Scheduled"] = 0] = "Scheduled";
    /**
     * Cell is running
     */
    RunningStatus[RunningStatus["Running"] = 1] = "Running";
})(RunningStatus || (RunningStatus = {}));
//# sourceMappingURL=tokens.js.map