/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */
import React from 'react';
import { classes } from '../utils';
/**
 * Button component
 *
 * @param props Component properties
 * @returns Component
 */
export function Button(props) {
    const { minimal, small, children, ...others } = props;
    return (React.createElement("button", { ...others, className: classes(props.className, minimal ? 'jp-mod-minimal' : '', small ? 'jp-mod-small' : '', 'jp-Button') }, children));
}
//# sourceMappingURL=button.js.map