'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.formatDate = formatDate;

var _utils = require('../util/utils');

/**
 * A formatDate helper to format date using moment js.
 *
 * @example
 *      {{formatDate 'MM/DD/YYYY' date}}
 *
 * @param formatString based on moment.js
 * @param date
 * @return string
 */
function formatDate(formatString, date) {
    var moment = global.moment;

    if (!moment) {
        moment = require('moment');
    }

    formatString = (0, _utils.isString)(formatString) ? formatString : '';

    return moment(date || new Date()).format(formatString);
}