# karma-jasmine [![Build Status](https://travis-ci.org/karma-runner/karma-jasmine.svg?branch=master)](https://travis-ci.org/karma-runner/karma-jasmine)

> Adapter for the [Jasmine](http://jasmine.github.io/) testing framework.


## Installation

### Jasmine 1.3 ([docs](http://jasmine.github.io/1.3/introduction.html))

The easiest way is to keep `karma-jasmine` as a devDependency in your `package.json`.

```json
{
  "devDependencies": {
    "karma": "~0.12.0",
    "karma-jasmine": "~0.1.0"
  }
}
```

You can simply do it by:
```bash
npm install karma-jasmine --save-dev
```


### Jasmine 2.0 ([docs](http://jasmine.github.io/2.0/introduction.html))

The easiest way is to keep `karma-jasmine` as a devDependency in your `package.json`.
```json
{
  "devDependencies": {
    "karma": "~0.12.0",
    "karma-jasmine": "~0.2.0"
  }
}
```

You can simply do it by:
```bash
npm install karma-jasmine@2_0 --save-dev
```

__Note:__
Since `karma-jasmine 0.3.0` the jasmine library is no longer bundled with `karma-jasmine` and you have to install it on your own. You can simply do it by:
```bash
npm install jasmine-core --save-dev
```
## Configuration
```js
// karma.conf.js
module.exports = function(config) {
  config.set({
    frameworks: ['jasmine'],

    files: [
      '*.js'
    ]
  });
};
```

If you want to run only some tests matching a given pattern you can do this in the following way

```bash
karma start &
karma run -- --grep=<pattern>
```

or

```js
module.exports = function(config) {
  config.set({
    ...
    client: {
      args: ['--grep', '<pattern>'],
      ...
    }
  });
};
```

----

For more information on Karma see the [homepage].


[homepage]: http://karma-runner.github.com
