'use strict';

var kdbush = require('./');
var v8 = require('v8');

var randomInt = (max) => Math.floor(Math.random() * max);
var heapSize = () => v8.getHeapStatistics().used_heap_size / 1000 + ' KB';

let l = 1e6
let points = new Int32Array(l)
for (var i = 0; i < l; i++) {
	points[i*2] = randomInt(1000);
	points[i*2+1] = randomInt(1000);
}

console.log('memory: ' + heapSize());

console.time('index ' + points.length/2 + ' points');
var index = kdbush(points, 64);
console.timeEnd('index ' + points.length/2 + ' points');

console.log('memory: ' + heapSize());

console.time('10000 small bbox queries');
for (i = 0; i < 10000; i++) {
    var p = [randomInt(1000), randomInt(1000)]
    index.range(p[0] - 1, p[1] - 1, p[0] + 1, p[1] + 1);
}
console.timeEnd('10000 small bbox queries');

console.time('10000 small radius queries');
for (i = 0; i < 10000; i++) {
    var p = [randomInt(1000), randomInt(1000)]
    index.within(p[0], p[1], 1);
}
console.timeEnd('10000 small radius queries');
