import EventEmitter, { EmitterParam } from "@scena/event-emitter";
export interface KeyControllerEvent extends EmitterParam {
    inputEvent: KeyboardEvent;
    isToggle: boolean;
    key: string;
    keyCode: number;
    ctrlKey: boolean;
    altKey: boolean;
    shiftKey: boolean;
    metaKey: boolean;
}
export interface OnKeydown extends KeyControllerEvent {
}
export interface OnKeyup extends KeyControllerEvent {
}
export interface OnBlur {
}
export interface KeyconEvents {
    keydown: OnKeydown;
    keyup: OnKeyup;
    blur: OnBlur;
}
export declare type KeyControllerEvents = KeyconEvents;
declare class KeyController extends EventEmitter<KeyconEvents & {
    [text: string]: any;
}> {
    container: Window | Document | HTMLElement;
    static get global(): KeyController;
    static setGlobal(): KeyController;
    ctrlKey: boolean;
    altKey: boolean;
    shiftKey: boolean;
    metaKey: boolean;
    constructor(container?: Window | Document | HTMLElement);
    clear: () => this;
    destroy(): void;
    keydown(comb: string | string[], callback: (e: KeyControllerEvent) => void): this;
    keydown(callback: (e: KeyControllerEvent) => void): this;
    offKeydown(comb: string | string[], callback?: (e: KeyControllerEvent) => void): this;
    offKeydown(callback: (e: KeyControllerEvent) => void): this;
    offKeyup(comb: string | string[], callback?: (e: KeyControllerEvent) => void): this;
    offKeyup(callback: (e: KeyControllerEvent) => void): this;
    keyup(comb: string | string[], callback: (e: KeyControllerEvent) => void): this;
    keyup(callback: (e: KeyControllerEvent) => void): this;
    private addEvent;
    private removeEvent;
    private triggerEvent;
    private keydownEvent;
    private keyupEvent;
    private blur;
}
export default KeyController;
