import { ReactiveAdapter, Ref, ReactiveObject, Observer } from "@cfcs/core";
import KeyController, { KeyControllerEvents, KeyControllerEvent } from "./KeyController";
export interface ReactiveKeyControllerData {
    ref?: Ref<HTMLElement | null | undefined>;
    checker?: (e: KeyControllerEvent) => boolean;
    keys: string | string[];
}
export declare type ReactiveKeyController = ReactiveObject<{
    inst: KeyController;
    keys: string | string[];
    isKeydown: Observer<boolean>;
    destroy(): void;
}>;
export declare const REACTIVE: ReactiveAdapter<ReactiveKeyController, {
    isKeydown: boolean;
}, never, ReactiveKeyControllerData, KeyControllerEvents>;
