/*
Copyright (c) Daybrush
name: keycon
license: MIT
author: Daybrush
repository: git+https://github.com/daybrush/keycon.git
version: 1.4.0
*/
'use strict';

var EventEmitter = require('@scena/event-emitter');
var utils = require('@daybrush/utils');

/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise */

var extendStatics = function (d, b) {
  extendStatics = Object.setPrototypeOf || {
    __proto__: []
  } instanceof Array && function (d, b) {
    d.__proto__ = b;
  } || function (d, b) {
    for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p];
  };
  return extendStatics(d, b);
};
function __extends(d, b) {
  if (typeof b !== "function" && b !== null) throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
  extendStatics(d, b);
  function __() {
    this.constructor = d;
  }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

function createCommonjsModule(fn, module) {
  return module = {
    exports: {}
  }, fn(module, module.exports), module.exports;
}

var keycode = createCommonjsModule(function (module, exports) {
// Source: http://jsfiddle.net/vWx8V/
// http://stackoverflow.com/questions/5603195/full-list-of-javascript-keycodes

/**
 * Conenience method returns corresponding value for given keyName or keyCode.
 *
 * @param {Mixed} keyCode {Number} or keyName {String}
 * @return {Mixed}
 * @api public
 */

function keyCode(searchInput) {
  // Keyboard Events
  if (searchInput && 'object' === typeof searchInput) {
    var hasKeyCode = searchInput.which || searchInput.keyCode || searchInput.charCode;
    if (hasKeyCode) searchInput = hasKeyCode;
  }

  // Numbers
  if ('number' === typeof searchInput) return names[searchInput]

  // Everything else (cast to string)
  var search = String(searchInput);

  // check codes
  var foundNamedKey = codes[search.toLowerCase()];
  if (foundNamedKey) return foundNamedKey

  // check aliases
  var foundNamedKey = aliases[search.toLowerCase()];
  if (foundNamedKey) return foundNamedKey

  // weird character?
  if (search.length === 1) return search.charCodeAt(0)

  return undefined
}

/**
 * Compares a keyboard event with a given keyCode or keyName.
 *
 * @param {Event} event Keyboard event that should be tested
 * @param {Mixed} keyCode {Number} or keyName {String}
 * @return {Boolean}
 * @api public
 */
keyCode.isEventKey = function isEventKey(event, nameOrCode) {
  if (event && 'object' === typeof event) {
    var keyCode = event.which || event.keyCode || event.charCode;
    if (keyCode === null || keyCode === undefined) { return false; }
    if (typeof nameOrCode === 'string') {
      // check codes
      var foundNamedKey = codes[nameOrCode.toLowerCase()];
      if (foundNamedKey) { return foundNamedKey === keyCode; }
    
      // check aliases
      var foundNamedKey = aliases[nameOrCode.toLowerCase()];
      if (foundNamedKey) { return foundNamedKey === keyCode; }
    } else if (typeof nameOrCode === 'number') {
      return nameOrCode === keyCode;
    }
    return false;
  }
};

exports = module.exports = keyCode;

/**
 * Get by name
 *
 *   exports.code['enter'] // => 13
 */

var codes = exports.code = exports.codes = {
  'backspace': 8,
  'tab': 9,
  'enter': 13,
  'shift': 16,
  'ctrl': 17,
  'alt': 18,
  'pause/break': 19,
  'caps lock': 20,
  'esc': 27,
  'space': 32,
  'page up': 33,
  'page down': 34,
  'end': 35,
  'home': 36,
  'left': 37,
  'up': 38,
  'right': 39,
  'down': 40,
  'insert': 45,
  'delete': 46,
  'command': 91,
  'left command': 91,
  'right command': 93,
  'numpad *': 106,
  'numpad +': 107,
  'numpad -': 109,
  'numpad .': 110,
  'numpad /': 111,
  'num lock': 144,
  'scroll lock': 145,
  'my computer': 182,
  'my calculator': 183,
  ';': 186,
  '=': 187,
  ',': 188,
  '-': 189,
  '.': 190,
  '/': 191,
  '`': 192,
  '[': 219,
  '\\': 220,
  ']': 221,
  "'": 222
};

// Helper aliases

var aliases = exports.aliases = {
  'windows': 91,
  '⇧': 16,
  '⌥': 18,
  '⌃': 17,
  '⌘': 91,
  'ctl': 17,
  'control': 17,
  'option': 18,
  'pause': 19,
  'break': 19,
  'caps': 20,
  'return': 13,
  'escape': 27,
  'spc': 32,
  'spacebar': 32,
  'pgup': 33,
  'pgdn': 34,
  'ins': 45,
  'del': 46,
  'cmd': 91
};

/*!
 * Programatically add the following
 */

// lower case chars
for (i = 97; i < 123; i++) codes[String.fromCharCode(i)] = i - 32;

// numbers
for (var i = 48; i < 58; i++) codes[i - 48] = i;

// function keys
for (i = 1; i < 13; i++) codes['f'+i] = i + 111;

// numpad keys
for (i = 0; i < 10; i++) codes['numpad '+i] = i + 96;

/**
 * Get by code
 *
 *   exports.name[13] // => 'Enter'
 */

var names = exports.names = exports.title = {}; // title for backward compat

// Create reverse mapping
for (i in codes) names[codes[i]] = i;

// Add aliases
for (var alias in aliases) {
  codes[alias] = aliases[alias];
}
});
var keycode_1 = keycode.code;
var keycode_2 = keycode.codes;
var keycode_3 = keycode.aliases;
var keycode_4 = keycode.names;
var keycode_5 = keycode.title;

var codeData = {
  "+": "plus",
  "left command": "meta",
  "right command": "meta"
};
var keysSort = {
  shift: 1,
  ctrl: 2,
  alt: 3,
  meta: 4
};
/**
 * @memberof KeyController
 */
function getKey(keyCode, keyName) {
  var key = (keycode_4[keyCode] || keyName || "").toLowerCase();
  for (var name in codeData) {
    key = key.replace(name, codeData[name]);
  }
  return key.replace(/\s/g, "");
}
/**
 * @memberof KeyController
 */
function getCombi(e, key) {
  if (key === void 0) {
    key = getKey(e.keyCode, e.key);
  }
  var keys = getModifierCombi(e);
  keys.indexOf(key) === -1 && keys.push(key);
  return keys.filter(Boolean);
}
/**
 * @memberof KeyController
 */
function getModifierCombi(e) {
  var keys = [e.shiftKey && "shift", e.ctrlKey && "ctrl", e.altKey && "alt", e.metaKey && "meta"];
  return keys.filter(Boolean);
}
/**
 * @memberof KeyController
 */
function getArrangeCombi(keys) {
  var arrangeKeys = keys.slice();
  arrangeKeys.sort(function (prev, next) {
    var prevScore = keysSort[prev] || 5;
    var nextScore = keysSort[next] || 5;
    return prevScore - nextScore;
  });
  return arrangeKeys;
}

var globalKeyController;
/**
 */
var KeyController = /*#__PURE__*/function (_super) {
  __extends(KeyController, _super);
  /**
   *
   */
  function KeyController(container) {
    if (container === void 0) {
      container = window;
    }
    var _this = _super.call(this) || this;
    _this.container = container;
    /**
     */
    _this.ctrlKey = false;
    /**
     */
    _this.altKey = false;
    /**
     *
     */
    _this.shiftKey = false;
    /**
     *
     */
    _this.metaKey = false;
    _this.clear = function () {
      _this.ctrlKey = false;
      _this.altKey = false;
      _this.shiftKey = false;
      _this.metaKey = false;
      return _this;
    };
    _this.keydownEvent = function (e) {
      _this.triggerEvent("keydown", e);
    };
    _this.keyupEvent = function (e) {
      _this.triggerEvent("keyup", e);
    };
    _this.blur = function () {
      _this.clear();
      _this.trigger("blur");
    };
    utils.addEvent(container, "blur", _this.blur);
    utils.addEvent(container, "keydown", _this.keydownEvent);
    utils.addEvent(container, "keyup", _this.keyupEvent);
    return _this;
  }
  var __proto = KeyController.prototype;
  Object.defineProperty(KeyController, "global", {
    /**
     */
    get: function () {
      return globalKeyController || (globalKeyController = new KeyController());
    },
    enumerable: false,
    configurable: true
  });
  KeyController.setGlobal = function () {
    return this.global;
  };
  /**
   *
   */
  __proto.destroy = function () {
    var container = this.container;
    this.clear();
    this.off();
    utils.removeEvent(container, "blur", this.blur);
    utils.removeEvent(container, "keydown", this.keydownEvent);
    utils.removeEvent(container, "keyup", this.keyupEvent);
  };
  /**
   *
   */
  __proto.keydown = function (comb, callback) {
    return this.addEvent("keydown", comb, callback);
  };
  /**
   *
   */
  __proto.offKeydown = function (comb, callback) {
    return this.removeEvent("keydown", comb, callback);
  };
  /**
   *
   */
  __proto.offKeyup = function (comb, callback) {
    return this.removeEvent("keyup", comb, callback);
  };
  /**
   *
   */
  __proto.keyup = function (comb, callback) {
    return this.addEvent("keyup", comb, callback);
  };
  __proto.addEvent = function (type, comb, callback) {
    if (utils.isArray(comb)) {
      this.on("".concat(type, ".").concat(getArrangeCombi(comb).join(".")), callback);
    } else if (utils.isString(comb)) {
      this.on("".concat(type, ".").concat(comb), callback);
    } else {
      this.on(type, comb);
    }
    return this;
  };
  __proto.removeEvent = function (type, comb, callback) {
    if (utils.isArray(comb)) {
      this.off("".concat(type, ".").concat(getArrangeCombi(comb).join(".")), callback);
    } else if (utils.isString(comb)) {
      this.off("".concat(type, ".").concat(comb), callback);
    } else {
      this.off(type, comb);
    }
    return this;
  };
  __proto.triggerEvent = function (type, e) {
    this.ctrlKey = e.ctrlKey;
    this.shiftKey = e.shiftKey;
    this.altKey = e.altKey;
    this.metaKey = e.metaKey;
    var key = getKey(e.keyCode, e.key);
    var isToggle = key === "ctrl" || key === "shift" || key === "meta" || key === "alt";
    var param = {
      key: key,
      isToggle: isToggle,
      inputEvent: e,
      keyCode: e.keyCode,
      ctrlKey: e.ctrlKey,
      altKey: e.altKey,
      shiftKey: e.shiftKey,
      metaKey: e.metaKey
    };
    this.trigger(type, param);
    this.trigger("".concat(type, ".").concat(key), param);
    var combi = getCombi(e, key);
    combi.length > 1 && this.trigger("".concat(type, ".").concat(combi.join(".")), param);
  };
  return KeyController;
}(EventEmitter);

/*
Copyright (c) NAVER Corp.
name: @egjs/component
license: MIT
author: NAVER Corp.
repository: https://github.com/naver/egjs-component
version: 3.0.2
*/
/*! *****************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
function __values(o) {
  var s = typeof Symbol === "function" && Symbol.iterator,
      m = s && o[s],
      i = 0;
  if (m) return m.call(o);
  if (o && typeof o.length === "number") return {
    next: function () {
      if (o && i >= o.length) o = void 0;
      return {
        value: o && o[i++],
        done: !o
      };
    }
  };
  throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}
function __read(o, n) {
  var m = typeof Symbol === "function" && o[Symbol.iterator];
  if (!m) return o;
  var i = m.call(o),
      r,
      ar = [],
      e;

  try {
    while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
  } catch (error) {
    e = {
      error: error
    };
  } finally {
    try {
      if (r && !r.done && (m = i["return"])) m.call(i);
    } finally {
      if (e) throw e.error;
    }
  }

  return ar;
}
function __spread() {
  for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));

  return ar;
}

/*
 * Copyright (c) 2015 NAVER Corp.
 * egjs projects are licensed under the MIT license
 */
var isUndefined = function (value) {
  return typeof value === "undefined";
};

/**
 * Event class to provide additional properties
 * @ko Component에서 추가적인 프로퍼티를 제공하는 이벤트 클래스
 */

var ComponentEvent =
/*#__PURE__*/
function () {
  /**
   * Create a new instance of ComponentEvent.
   * @ko ComponentEvent의 새로운 인스턴스를 생성한다.
   * @param eventType The name of the event.<ko>이벤트 이름.</ko>
   * @param props An object that contains additional event properties.<ko>추가적인 이벤트 프로퍼티 오브젝트.</ko>
   */
  function ComponentEvent(eventType, props) {
    var e_1, _a;

    this._canceled = false;

    if (props) {
      try {
        for (var _b = __values(Object.keys(props)), _c = _b.next(); !_c.done; _c = _b.next()) {
          var key = _c.value; // eslint-disable-next-line @typescript-eslint/no-unsafe-assignment

          this[key] = props[key];
        }
      } catch (e_1_1) {
        e_1 = {
          error: e_1_1
        };
      } finally {
        try {
          if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        } finally {
          if (e_1) throw e_1.error;
        }
      }
    }

    this.eventType = eventType;
  }
  /**
   * Stop the event. {@link ComponentEvent#isCanceled} will return `true` after.
   * @ko 이벤트를 중단한다. 이후 {@link ComponentEvent#isCanceled}가 `true`를 반환한다.
   */


  var __proto = ComponentEvent.prototype;

  __proto.stop = function () {
    this._canceled = true;
  };
  /**
   * Returns a boolean value that indicates whether {@link ComponentEvent#stop} is called before.
   * @ko {@link ComponentEvent#stop}이 호출되었는지 여부를 반환한다.
   * @return {boolean} A boolean value that indicates whether {@link ComponentEvent#stop} is called before.<ko>이전에 {@link ComponentEvent#stop}이 불려졌는지 여부를 반환한다.</ko>
   */


  __proto.isCanceled = function () {
    return this._canceled;
  };

  return ComponentEvent;
}();

/**
 * A class used to manage events in a component
 * @ko 컴포넌트의 이벤트을 관리할 수 있게 하는 클래스
 */

var Component =
/*#__PURE__*/
function () {
  /**
   * @support {"ie": "7+", "ch" : "latest", "ff" : "latest",  "sf" : "latest", "edge" : "latest", "ios" : "7+", "an" : "2.1+ (except 3.x)"}
   */
  function Component() {
    this._eventHandler = {};
  }
  /**
   * Trigger a custom event.
   * @ko 커스텀 이벤트를 발생시킨다
   * @param {string | ComponentEvent} event The name of the custom event to be triggered or an instance of the ComponentEvent<ko>발생할 커스텀 이벤트의 이름 또는 ComponentEvent의 인스턴스</ko>
   * @param {any[]} params Event data to be sent when triggering a custom event <ko>커스텀 이벤트가 발생할 때 전달할 데이터</ko>
   * @return An instance of the component itself<ko>컴포넌트 자신의 인스턴스</ko>
   * @example
   * ```ts
   * import Component, { ComponentEvent } from "@egjs/component";
   *
   * class Some extends Component<{
   *   beforeHi: ComponentEvent<{ foo: number; bar: string }>;
   *   hi: { foo: { a: number; b: boolean } };
   *   someEvent: (foo: number, bar: string) => void;
   *   someOtherEvent: void; // When there's no event argument
   * }> {
   *   some(){
   *     if(this.trigger("beforeHi")){ // When event call to stop return false.
   *       this.trigger("hi");// fire hi event.
   *     }
   *   }
   * }
   *
   * const some = new Some();
   * some.on("beforeHi", e => {
   *   if(condition){
   *     e.stop(); // When event call to stop, `hi` event not call.
   *   }
   *   // `currentTarget` is component instance.
   *   console.log(some === e.currentTarget); // true
   *
   *   typeof e.foo; // number
   *   typeof e.bar; // string
   * });
   * some.on("hi", e => {
   *   typeof e.foo.b; // boolean
   * });
   * // If you want to more know event design. You can see article.
   * // https://github.com/naver/egjs-component/wiki/How-to-make-Component-event-design%3F
   * ```
   */


  var __proto = Component.prototype;

  __proto.trigger = function (event) {
    var params = [];

    for (var _i = 1; _i < arguments.length; _i++) {
      params[_i - 1] = arguments[_i];
    }

    var eventName = event instanceof ComponentEvent ? event.eventType : event;

    var handlers = __spread(this._eventHandler[eventName] || []);

    if (handlers.length <= 0) {
      return this;
    }

    if (event instanceof ComponentEvent) {
      event.currentTarget = this;
      handlers.forEach(function (handler) {
        handler(event);
      });
    } else {
      handlers.forEach(function (handler) {
        // eslint-disable-next-line @typescript-eslint/no-unsafe-call
        handler.apply(void 0, __spread(params));
      });
    }

    return this;
  };
  /**
   * Executed event just one time.
   * @ko 이벤트가 한번만 실행된다.
   * @param {string} eventName The name of the event to be attached or an event name - event handler mapped object.<ko>등록할 이벤트의 이름 또는 이벤트 이름-핸들러 오브젝트</ko>
   * @param {function} handlerToAttach The handler function of the event to be attached <ko>등록할 이벤트의 핸들러 함수</ko>
   * @return An instance of the component itself<ko>컴포넌트 자신의 인스턴스</ko>
   * @example
   * ```ts
   * import Component, { ComponentEvent } from "@egjs/component";
   *
   * class Some extends Component<{
   *   hi: ComponentEvent;
   * }> {
   *   hi() {
   *     alert("hi");
   *   }
   *   thing() {
   *     this.once("hi", this.hi);
   *   }
   * }
   *
   * var some = new Some();
   * some.thing();
   * some.trigger(new ComponentEvent("hi"));
   * // fire alert("hi");
   * some.trigger(new ComponentEvent("hi"));
   * // Nothing happens
   * ```
   */


  __proto.once = function (eventName, handlerToAttach) {
    var _this = this;

    if (typeof eventName === "object" && isUndefined(handlerToAttach)) {
      var eventHash = eventName;

      for (var key in eventHash) {
        this.once(key, eventHash[key]);
      }

      return this;
    } else if (typeof eventName === "string" && typeof handlerToAttach === "function") {
      var listener_1 = function () {
        var args = [];

        for (var _i = 0; _i < arguments.length; _i++) {
          args[_i] = arguments[_i];
        } // eslint-disable-next-line @typescript-eslint/no-unsafe-call


        handlerToAttach.apply(void 0, __spread(args));

        _this.off(eventName, listener_1);
      };

      this.on(eventName, listener_1);
    }

    return this;
  };
  /**
   * Checks whether an event has been attached to a component.
   * @ko 컴포넌트에 이벤트가 등록됐는지 확인한다.
   * @param {string} eventName The name of the event to be attached <ko>등록 여부를 확인할 이벤트의 이름</ko>
   * @return {boolean} Indicates whether the event is attached. <ko>이벤트 등록 여부</ko>
   * @example
   * ```ts
   * import Component from "@egjs/component";
   *
   * class Some extends Component<{
   *   hi: void;
   * }> {
   *   some() {
   *     this.hasOn("hi");// check hi event.
   *   }
   * }
   * ```
   */


  __proto.hasOn = function (eventName) {
    return !!this._eventHandler[eventName];
  };
  /**
   * Attaches an event to a component.
   * @ko 컴포넌트에 이벤트를 등록한다.
   * @param {string} eventName The name of the event to be attached or an event name - event handler mapped object.<ko>등록할 이벤트의 이름 또는 이벤트 이름-핸들러 오브젝트</ko>
   * @param {function} handlerToAttach The handler function of the event to be attached <ko>등록할 이벤트의 핸들러 함수</ko>
   * @return An instance of a component itself<ko>컴포넌트 자신의 인스턴스</ko>
   * @example
   * ```ts
   * import Component, { ComponentEvent } from "@egjs/component";
   *
   * class Some extends Component<{
   *   hi: void;
   * }> {
   *   hi() {
   *     console.log("hi");
   *   }
   *   some() {
   *     this.on("hi",this.hi); //attach event
   *   }
   * }
   * ```
   */


  __proto.on = function (eventName, handlerToAttach) {
    if (typeof eventName === "object" && isUndefined(handlerToAttach)) {
      var eventHash = eventName;

      for (var name in eventHash) {
        this.on(name, eventHash[name]);
      }

      return this;
    } else if (typeof eventName === "string" && typeof handlerToAttach === "function") {
      var handlerList = this._eventHandler[eventName];

      if (isUndefined(handlerList)) {
        this._eventHandler[eventName] = [];
        handlerList = this._eventHandler[eventName];
      }

      handlerList.push(handlerToAttach);
    }

    return this;
  };
  /**
   * Detaches an event from the component.<br/>If the `eventName` is not given this will detach all event handlers attached.<br/>If the `handlerToDetach` is not given, this will detach all event handlers for `eventName`.
   * @ko 컴포넌트에 등록된 이벤트를 해제한다.<br/>`eventName`이 주어지지 않았을 경우 모든 이벤트 핸들러를 제거한다.<br/>`handlerToAttach`가 주어지지 않았을 경우 `eventName`에 해당하는 모든 이벤트 핸들러를 제거한다.
   * @param {string?} eventName The name of the event to be detached <ko>해제할 이벤트의 이름</ko>
   * @param {function?} handlerToDetach The handler function of the event to be detached <ko>해제할 이벤트의 핸들러 함수</ko>
   * @return An instance of a component itself <ko>컴포넌트 자신의 인스턴스</ko>
   * @example
   * ```ts
   * import Component, { ComponentEvent } from "@egjs/component";
   *
   * class Some extends Component<{
   *   hi: void;
   * }> {
   *   hi() {
   *     console.log("hi");
   *   }
   *   some() {
   *     this.off("hi",this.hi); //detach event
   *   }
   * }
   * ```
   */


  __proto.off = function (eventName, handlerToDetach) {
    var e_1, _a; // Detach all event handlers.


    if (isUndefined(eventName)) {
      this._eventHandler = {};
      return this;
    } // Detach all handlers for eventname or detach event handlers by object.


    if (isUndefined(handlerToDetach)) {
      if (typeof eventName === "string") {
        delete this._eventHandler[eventName];
        return this;
      } else {
        var eventHash = eventName;

        for (var name in eventHash) {
          this.off(name, eventHash[name]);
        }

        return this;
      }
    } // Detach single event handler


    var handlerList = this._eventHandler[eventName];

    if (handlerList) {
      var idx = 0;

      try {
        for (var handlerList_1 = __values(handlerList), handlerList_1_1 = handlerList_1.next(); !handlerList_1_1.done; handlerList_1_1 = handlerList_1.next()) {
          var handlerFunction = handlerList_1_1.value;

          if (handlerFunction === handlerToDetach) {
            handlerList.splice(idx, 1);

            if (handlerList.length <= 0) {
              delete this._eventHandler[eventName];
            }

            break;
          }

          idx++;
        }
      } catch (e_1_1) {
        e_1 = {
          error: e_1_1
        };
      } finally {
        try {
          if (handlerList_1_1 && !handlerList_1_1.done && (_a = handlerList_1.return)) _a.call(handlerList_1);
        } finally {
          if (e_1) throw e_1.error;
        }
      }
    }

    return this;
  };
  /**
   * Version info string
   * @ko 버전정보 문자열
   * @name VERSION
   * @static
   * @example
   * Component.VERSION;  // ex) 3.0.0
   * @memberof Component
   */


  Component.VERSION = "3.0.2";
  return Component;
}();

/*
Copyright (c) NAVER Crop.
name: @cfcs/core
license: MIT
author: NAVER Crop.
repository: https://github.com/naver/cfcs
version: 0.0.6
*/

/**
 * cfcs
 * Copyright (c) 2022-present NAVER Corp.
 * MIT license
 */
function keys(obj) {
  return Object.keys(obj);
}
function isObject(val) {
  return typeof val === "object";
}
function isFunction(val) {
  return typeof val === "function";
}

var OBSERVERS_PATH = "__observers__";

var Observer =
/*#__PURE__*/
function () {
  function Observer(value) {
    this._emitter = new Component();
    this._current = value;
  }

  var __proto = Observer.prototype;
  Object.defineProperty(__proto, "current", {
    get: function () {
      return this._current;
    },
    set: function (value) {
      var isUpdate = value !== this._current;
      this._current = value;

      if (isUpdate) {
        this._emitter.trigger("update", value);
      }
    },
    enumerable: false,
    configurable: true
  });

  __proto.subscribe = function (callback) {
    this._emitter.on("update", callback);
  };

  __proto.unsubscribe = function (callback) {
    this._emitter.off("update", callback);
  };

  return Observer;
}();
function observe(defaultValue) {
  return new Observer(defaultValue);
}
function defineObservers(instance) {
  var observers = {};
  Object.defineProperty(instance, OBSERVERS_PATH, {
    get: function () {
      return observers;
    }
  });
  return observers;
}
function getObservers(instance) {
  if (!instance[OBSERVERS_PATH]) {
    defineObservers(instance);
  }

  return instance[OBSERVERS_PATH];
}
function getObserver(instance, name, defaultValue) {
  var observers = getObservers(instance);

  if (!observers[name]) {
    observers[name] = observe(defaultValue);
  }

  return observers[name];
}
function setObserver(instance, name, observer) {
  var observers = getObservers(instance);
  observers[name] = observer;
}
function isObserver(val) {
  return val && isObject(val) && "current" in val && "subscribe" in val && "unsubscribe" in val;
}

function Reactive(name) {
  return function (prototype, memberName) {
    var publicName = name || memberName;
    Object.defineProperty(prototype, memberName, {
      get: function () {
        return getObserver(this, publicName).current;
      },
      set: function (value) {
        getObserver(this, publicName, value).current = value;
      }
    });

    if (publicName !== memberName) {
      Object.defineProperty(prototype, publicName, {
        get: function () {
          return getObserver(this, publicName).current;
        }
      });
    }
  };
}

function injectReactiveSubscribe(object) {
  object["subscribe"] = function (name, callback) {
    getObserver(this, name).subscribe(callback);
  };

  object["unsubscribe"] = function (name, callback) {
    var _this = this;

    if (!name) {
      keys(getObservers(this)).forEach(function (observerName) {
        _this.unsubscribe(observerName);
      });
      return;
    }

    if (!(name in this)) {
      return;
    }

    getObserver(this, name).unsubscribe(callback);
  };
}

function reactive(setup) {
  var result = isFunction(setup) ? setup() : setup;
  var reactiveObject = {};
  defineObservers(reactiveObject);
  keys(result).forEach(function (name) {
    var value = result[name];

    if (isObserver(value)) {
      setObserver(reactiveObject, name, value);
      Reactive(name)(reactiveObject, name);
    } else {
      reactiveObject[name] = value;
    }
  });
  injectReactiveSubscribe(reactiveObject);
  return reactiveObject;
}

var instanceMap;
var REACTIVE = {
  events: ["keydown", "keyup", "blur"],
  state: {
    isKeydown: false
  },
  mounted: function (data) {
    var _a, _b;
    if (!instanceMap) {
      instanceMap = new Map();
    }
    var element = (_b = (_a = data.ref) === null || _a === void 0 ? void 0 : _a.current) !== null && _b !== void 0 ? _b : window;
    var info = instanceMap.get(element);
    if (!info) {
      info = {
        inst: new KeyController(element),
        count: 0
      };
      instanceMap.set(element, info);
    }
    ++info.count;
    var keycon = info.inst;
    var keys = data.keys;
    var isKeydown = observe(false);
    var checker = data.checker;
    keycon.keydown(keys, function (e) {
      if (!checker || checker(e)) {
        isKeydown.current = true;
      }
    });
    keycon.keyup(keys, function () {
      isKeydown.current = false;
    });
    keycon.on("blur", function () {
      isKeydown.current = false;
    });
    return reactive({
      inst: keycon,
      keys: keys,
      destroy: function () {
        return keycon.destroy();
      },
      isKeydown: isKeydown
    });
  },
  destroy: function (_a) {
    var inst = _a.inst;
    var element = inst.container;
    var info = instanceMap.get(element);
    --info.count;
    if (!info.count) {
      inst.destroy();
      instanceMap.delete(element);
    }
  },
  on: function (inst, name, callback) {
    var keycon = inst.inst;
    if (name === "keydown") {
      keycon.keydown(inst.keys, callback);
    } else if (name === "keyup") {
      keycon.keyup(inst.keys, callback);
    } else {
      keycon.on(name, callback);
    }
  },
  off: function (inst, name, callback) {
    var keycon = inst.inst;
    if (name === "keydown") {
      keycon.offKeydown(inst.keys, callback);
    } else if (name === "keyup") {
      keycon.offKeyup(inst.keys, callback);
    } else {
      keycon.off(name, callback);
    }
  }
};



var others = {
    __proto__: null,
    'default': KeyController,
    getKey: getKey,
    getCombi: getCombi,
    getModifierCombi: getModifierCombi,
    getArrangeCombi: getArrangeCombi,
    REACTIVE: REACTIVE
};

for (var name in others) {
  KeyController[name] = others[name];
}
module.exports = KeyController;

exports.REACTIVE = REACTIVE;
exports.default = KeyController;
exports.getArrangeCombi = getArrangeCombi;
exports.getCombi = getCombi;
exports.getKey = getKey;
exports.getModifierCombi = getModifierCombi;
//# sourceMappingURL=keycon.cjs.js.map
