var Emitter = require('events').EventEmitter
var vkey = require('vkey')

module.exports = function(keys, el) {
  if (typeof keys === 'string') keys = [keys]
  if (!el) el = window

  var emitter = new Emitter()
  emitter.pressed = {}
  
  el.addEventListener('blur', clearPressed)
  el.addEventListener('focus', clearPressed)
  
  el.addEventListener('keydown', function(ev) {
    var key = vkey[ev.keyCode]
    emitter.pressed[key] = true
    var allPressed = true
    keys.forEach(function(k) {
      if (!emitter.pressed[k]) allPressed = false
    })
    if (allPressed) {
      emitter.emit('pressed', emitter.pressed)

      // this seems to be necessary as keyup doesn't always fire during combos :/
      clearPressed()
    }
  })

  el.addEventListener('keyup', function(ev) {
    delete emitter.pressed[vkey[ev.keyCode]]
  })
  
  function clearPressed() {
    emitter.pressed = {}
  }
  
  return emitter
}
