"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FeelVariablesParser = void 0;
var antlr4_1 = require("antlr4");
var FEEL_1_1Parser_1 = require("./grammar/generated-parser/FEEL_1_1Parser");
var FEEL_1_1Lexer_1 = require("./grammar/generated-parser/FEEL_1_1Lexer");
var MapBackedType_1 = require("./grammar/MapBackedType");
var FeelVariablesParser = (function () {
    function FeelVariablesParser(variablesSource) {
        this.variablesRepository = variablesSource;
    }
    FeelVariablesParser.prototype.parse = function (variableContextUuid, expression) {
        var variables = new Array();
        var chars = new antlr4_1.CharStream(expression);
        var lexer = new FEEL_1_1Lexer_1.default(chars);
        var feelTokens = new antlr4_1.CommonTokenStream(lexer);
        var parser = new FEEL_1_1Parser_1.default(feelTokens);
        var variableContext = this.variablesRepository.variables.get(variableContextUuid);
        if (variableContext) {
            this.defineVariables(variableContext, parser);
        }
        parser.removeErrorListeners();
        parser.expression();
        variables.push.apply(variables, __spreadArray([], __read(parser.helper.variables), false));
        return variables;
    };
    FeelVariablesParser.prototype.defineVariables = function (variableContext, parser) {
        var e_1, _a;
        this.defineInputVariables(variableContext.inputVariables, parser);
        this.addToParser(parser, variableContext);
        if (variableContext.parent) {
            this.defineParentVariable(variableContext.parent, parser);
        }
        try {
            for (var _b = __values(variableContext.inputVariables), _c = _b.next(); !_c.done; _c = _b.next()) {
                var inputVariableContext = _c.value;
                var localVariable = this.variablesRepository.variables.get(inputVariableContext);
                if (localVariable) {
                    this.addToParser(parser, localVariable);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
    };
    FeelVariablesParser.prototype.defineParentVariable = function (variableNode, parser) {
        this.defineInputVariables(variableNode.inputVariables, parser);
        this.addToParser(parser, variableNode);
        if (variableNode.parent) {
            this.defineParentVariable(variableNode.parent, parser);
        }
    };
    FeelVariablesParser.prototype.createType = function (dataType) {
        var e_2, _a;
        var type = new MapBackedType_1.MapBackedType(dataType.name);
        try {
            for (var _b = __values(dataType.properties), _c = _b.next(); !_c.done; _c = _b.next()) {
                var property = _c.value;
                var innerType = this.createType(property[1]);
                type.properties.set(property[0], innerType);
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return type;
    };
    FeelVariablesParser.prototype.defineInputVariables = function (inputVariables, parser) {
        var e_3, _a;
        try {
            for (var inputVariables_1 = __values(inputVariables), inputVariables_1_1 = inputVariables_1.next(); !inputVariables_1_1.done; inputVariables_1_1 = inputVariables_1.next()) {
                var inputVariableId = inputVariables_1_1.value;
                var inputVariable = this.variablesRepository.variables.get(inputVariableId);
                if (inputVariable) {
                    this.addToParser(parser, inputVariable);
                }
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (inputVariables_1_1 && !inputVariables_1_1.done && (_a = inputVariables_1.return)) _a.call(inputVariables_1);
            }
            finally { if (e_3) throw e_3.error; }
        }
    };
    FeelVariablesParser.prototype.addToParser = function (parser, context) {
        parser.helper.defineVariable(context.variable.value, context.variable.typeRef ? this.createType(context.variable.typeRef) : undefined, context.variable.variableType);
    };
    return FeelVariablesParser;
}());
exports.FeelVariablesParser = FeelVariablesParser;
//# sourceMappingURL=FeelVariablesParser.js.map